﻿<%@ Page Language="C#" MasterPageFile="~/MasterPage.master" AutoEventWireup="true" CodeFile="Log_error.aspx.cs" Inherits="Log_error" %>

<asp:Content ID="Content1" ContentPlaceHolderID="Head" Runat="Server">
<title>Winson.Framework功能演示_错误日志</title>
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="Title" Runat="Server">
<h2>错误日志使用说明</h2>
</asp:Content>
<asp:Content ID="Content3" ContentPlaceHolderID="ContentPlaceHolder1" Runat="Server">

<h5>一、基本说明：</h5>

<p>错误日志可以自动捕获当前异常信息，指出具体出错的行数和代码，还可记录异常时所使用的相关参数。<br /><br />
记录日志信息支持2种方式：<br />
1.将异常信息写入XML文件，日志文件将会以日期天数命名，在使用XML文件记录错误日志前，请先在项目根目录里创建名为 <span class="comment">Log</span> 的目录，如希望使用其他目录名，请在web.config里更改配置<br />
2.将异常信息写入Windows的系统日志模块，在Windows里的应用程序日志中可查看到相关的记录</p>
<h5>二、操作步骤：</h5>

要使用XML记录还是Windows记录，只需修改配置文件web.config即可：
<pre>
<code class="xml">
&lt;LogProvider defaultProvider="Log2XMLProvider" useErrLog="True" useEventLog="True" eventTable="EventLog"&gt;
	&lt;!--参数说明:
	defaultProvider:使用哪种方式记录日志文件，与以下providers配置节的name相匹配
	useErrLog: 是否启用错误日志
	useEventLog: 是否启用事务日志，即操作日志，此日志直接写入数据库，需另行写代码实现
	eventTable：事务日志表名，useEventLog为True时才有效
	--&gt;
&lt;providers&gt;
    &lt;add name="Log2XMLProvider" type="Winson.Framework.LogProviders.Log2XMLProvider, Winson.Framework" logPath="Log\"/&gt;
    &lt;add name="Log2WinProvider" type="Winson.Framework.LogProviders.Log2WinProvider, Winson.Framework" eventSource="Winson.Framework"/&gt;
    &lt;/providers&gt;
&lt;/LogProvider&gt;
</code>
</pre>

 a.引用以下命名空间：
<pre>
<code class="csharp">using Winson.Framework.LogProviders;</code></pre>

b.在捕获异常时，调用日志处理方法 <span class="comment">OutputErrLog</span>，其中有2个参数，第一个为异常对象，第二个为当前应用程序使用的参数列表：
<pre><code class="csharp">
try
{
    code...;
}
catch (Exception e)
{
    LogManage.OutputErrLog(e, new Object[] { parms });
}
</code></pre>

c.完整代码如下：
<pre><code class="csharp">
public void TestError(string parm1,string parm2)
{
    try
    {
        code...;
    }
    catch (Exception e)
    {
        LogManage.OutputErrLog(e, new Object[] { parm1,parm2 });
    }
}
</code></pre>


</asp:Content>

