﻿<%@ Page Language="C#" MasterPageFile="~/MasterPage.master" AutoEventWireup="true" CodeFile="Popup.aspx.cs" Inherits="Index" Title="无标题页" %>
<%@ Register Assembly="Winson.Framework" Namespace="Winson.Framework.Controls" TagPrefix="PopupWin" %>
<asp:Content ID="Content1" ContentPlaceHolderID="Head" Runat="Server">
   <title>Winson.Framework_弹出框的使用</title>
</asp:Content>
<asp:Content ID="Content3" ContentPlaceHolderID="Title" Runat="Server">
   <h2>弹出框的使用</h2>
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="ContentPlaceHolder1" Runat="Server">
 
 <h5>一、基本说明：</h5>
<p>
    此弹出框控件是可像MSN一样的那种消息弹出提示框效果，此控件支持多种弹出效果，同时也可以设置钩子等，以下将为大家介绍相关的用法
 <br /><br />
  <h5>二、属性说明：</h5>
  
  <b>基本控件属性：</b><br />
<div class="detail">
<ul>
<li><span class="parm">ActionType:</span>动作类型(点击连接后)，返回PopupAction枚举。(<span class="comment">注意：如果要使用相关的点击事件，如 OnLinkClicked 和 OnPopupClosed，此处必须设为 RaiseEvents </span>)</li>
<li><span class="parm">Text:</span>设置或获取新窗口里要显示的文本</li>
<li><span class="parm">Link:</span>设置或获取点击连接时打开的地址或者js脚本</li>
<li><span class="parm">LinkTarget:</span>设置或获取连接打开的目标方式</li>
<li><span class="parm">ColorStyle:</span>设置或获取颜色样式，返回PopupColorStyle枚举</li>
<li><span class="parm">Message:</span>设置或获取弹出窗口显示的信息</li>
<li><span class="parm">Title:</span>设置或获取弹出窗口和新窗口的标题</li>
<li><span class="parm">GradientLight:</span>设置或获取亮度的颜色</li>
<li><span class="parm">GradientDark:</span>设置或获取暗度的颜色(在Mozilla里即背景色)</li>
<li><span class="parm">TextColor:</span>设置或获取文本颜色</li>
<li><span class="parm">LightShadow:</span>设置或获取亮度阴影的颜色</li>
<li><span class="parm">DarkShadow:</span>设置或获取暗度阴影的颜色</li>
<li><span class="parm">Shadow:</span>设置或获取阴影颜色</li>
<li><span class="parm">DockMode:</span>设置或获取弹出窗口的收缩状态，返回PopupDocking枚举</li>
<li><span class="parm">OffsetX:</span>设置或获取X轴的偏移坐标（从左或右）</li>
<li><span class="parm">OffsetY:</span>设置或获取Y轴的偏移坐标（从底部）</li>
<li><span class="parm">HideAfter:</span>设置或获取窗口显示的时间，默认为500毫秒（-1为无限时间）</li>
<li><span class="parm">PopupSpeed:</span>设置或获取弹出的速度，默认为20</li>
<li><span class="parm">ShowAfter:</span>设置或获取显示弹出窗口之前的延迟时间，默认为1000毫秒</li>
<li><span class="parm">AutoShow:</span>页面加载时自动显示弹出窗口（在设置的ShowAfter属性之后）</li>
<li><span class="parm">DragDrop:</span>设置或获取是否允许拖动弹出窗口</li>
<li><span class="parm">WindowSize:</span>设置或获取打开窗口大小</li>
<li><span class="parm">WindowScroll:</span>设置或获取新窗口是否允许滚动条</li>
<li><span class="parm">ShowLink:</span>是否在弹出窗口中显示连接和启用动作</li>
</ul>
</div>
<br />
 <b>钩子控件属性：</b><br />
<div class="detail">
<ul>
<li><span class="parm">ChangeTexts:</span>是否把弹出窗口里的文本替换为新的文本，默认为false</li>
<li><span class="parm">NewMessage:</span>新的信息文本</li>
<li><span class="parm">NewTitle:</span>新的弹出窗口标题</li>
<li><span class="parm">NewText:</span>在新窗口里显示的新文本</li>
<li><span class="parm">HandledEvent:</span>JavaScript事件句柄，默认为 onclick </li>
<li><span class="parm">PopupToShow:</span>事件发生时显示弹出窗口控件，即要关联的PopupWin的ID</li>
<li><span class="parm">LinkedControl:</span>触发弹出窗口显示事件的元素，输入元素ID即可</li>
<li><span class="parm">PopupToShowIsMP:</span>PopupToShow的元素是否要使用母板页处理，如使用了母板页，同时所关联的控件是服务器端运行的，则必须要设置此项，默认为False</li>
<li><span class="parm">LinkedControlIsMP:</span>LinkedControl的元素是否要使用母板页处理，如使用了母板页，同时所关联的控件是服务器端运行的，则必须要设置此项，默认为False</li>
<li><span class="parm">ContentPlaceHolderID:</span>当前所在母板的ContentPlaceHolderID，如果没使用母板页，则不用设置</li>
</ul>
</div>
  
    <h5>三、使用说明：</h5>
  
 <b>1.基本运用：</b><br /><br />
 基本控件使用 <span class="comment">PopupWin:popupwin</span> 标记调用，以下是相关的代码：<br />
 前台HTML代码：
<pre><code class="html">
&lt;!--在页面顶部添加控件的引用--&gt;
&lt;%@ Register Assembly="Winson.Framework" Namespace="Winson.Framework.Controls" TagPrefix="PopupWin" %&gt;

&lt;!--在页面任意位置添加控件代码--&gt;
&lt;PopupWin:popupwin id="popupWin" 
        style="z-index: 105;left: 296px; position: absolute;top: 528px" runat="server" 
        width="230px" height="100px" 
        windowsize="300, 200" windowscroll="False" 
        dockmode="BottomLeft" colorstyle="Blue" 
        gradientdark="210, 200, 220"
        textcolor="0, 0, 3" shadow="125, 90, 160" 
        lightshadow="185, 170, 200" darkshadow="128, 0, 102"
        visible="False" showlink="True" offsetx="150" 
        ActionType="RaiseEvents" 
        OnLinkClicked="popupWin_LinkClick"&gt;
&lt;/PopupWin:popupwin&gt;

&lt;!--放置一个按钮来触发--&gt;
&lt;asp:Button ID="btnPopup" runat="server" Text="显示弹出窗" OnClick="btnPopup_Click"&gt;&lt;/asp:Button&gt;
</code></pre>
后台服务器代码：
<pre><code class="csharp">
//按钮事件
protected void btnPopup_Click(object sender, EventArgs e)
{
	//设置自动隐藏时间
	popupWin.HideAfter = (sender == null) ? -1 : 5000;
	popupWin.Visible = true;
	popupWin.Title = textTitle.Text;
	popupWin.Message = textMsg.Text;
	popupWin.Text = textFull.Text;
	popupWin.DragDrop = true;
	//设置显示的位置,在屏幕底部左边
	popupWin.DockMode = PopupDocking.BottomLeft;
	//设置弹出框的颜色
	popupWin.ColorStyle = PopupColorStyle.Blue;
}

//设置点击弹出框里连接后的事件
protected void popupWin_LinkClick(object sender, System.EventArgs e)
{
	dialog = new Dialog(this);
	dialog.ShowMsgBox("Hey ! 你点击第一个弹出窗口!!");
}
</code></pre>
<br />
<b>2.高级运用：(钩子的使用)</b><br /><br />
利用钩子,可以实现AJAX的无刷新效果。要使用钩子，需使用 <span class="comment">PopupWin:popupwinanchor</span> 标记调用，然后指定此钩子所关联的 PopupWin 控件的ID，同时还要指定触发此 PopupWin 控件的页面元素，输入元素ID即可，元素触发事件可以通过设置 HandledEvent 属性来完成，如以下代码没设置HandledEvent属性，则默认为 onclick 事件，因此当点击了button后，弹出窗口即被触发了。以下是相关的代码：<br />
 前台HTML代码：
<pre><code class="html">
&lt;!--被钩子绑定的元素，点击后即可通过钩子触发PopupWin控件了--&gt;
&lt;Button ID="btnShow" &gt;&nbsp;&nbsp;显  示&nbsp;&nbsp;&lt;/Button&gt;

&lt;!--放置PopupWin控件--&gt;
&lt;PopupWin:popupwin id="popupTest" title="第一个标题" runat="server" 
    text="在新窗口的第一个文本"  message="第一个信息" dockmode="BottomLeft" 
    colorstyle="Violet" Height="107px" Width="235px" autoshow="False"&gt;
&lt;/PopupWin:popupwin&gt;

&lt;!--为以上PopupWin控件放置一个钩子，因为要在母板里使用,所以关联的元素ID也要加上母板ID--&gt;
 &lt;PopupWin:popupwinanchor id="showTest" runat="server" 
    linkedcontrol="btnShow" 
    popuptoshow="ctl00_ContentPlaceHolder1_popupTest" 
    newmessage="新的信息"
    newtext='可以在新窗口里显示一段很长文本信息。点击“显示弹出窗”按钮以显示弹出窗口效果，２'
    newtitle='新标题' changetexts="True"&gt;
&lt;/PopupWin:popupwinanchor&gt;
</code></pre>
使用钩子后，只需设置好HTML代码即可，不需服务器端代码了


  <form id="form1" runat="server"> 
<h5>四、效果演示：</h5>

   <b> 1.基本运用: </b>
<div id="Popup1">

<ul style="height: 30px;"> <li><a href="#Popup1-1"><span>　演　示　</span></a></li> <li><a href="#Popup1-2"><span>　源　码　</span></a></li>  

</ul> 

<div id="Popup1-1">
<table class="table-context">
<tr><td>
标题: </td><td><asp:TextBox ID="textTitle" CssClass="input" runat="server" Width="330px">在这里写标题.</asp:TextBox><br /></td>
</tr>
<tr><td>
显示的文本: </td><td><asp:TextBox ID="textMsg" CssClass="input" runat="server" Width="330px">此文本将显示在弹出窗口里.</asp:TextBox></td>
</tr>
<tr><td>
颜色样式: </td><td><asp:DropDownList ID="clrStyle" CssClass="input" runat="server" Width="330px">
            <asp:ListItem Value="Red">红</asp:ListItem>
            <asp:ListItem Value="Green">绿</asp:ListItem>
            <asp:ListItem Value="Blue" Selected="True">蓝</asp:ListItem>
            <asp:ListItem Value="Violet">紫</asp:ListItem>
        </asp:DropDownList></td>
</tr>
<tr><td>
弹出的位置: </td><td><asp:DropDownList ID="popDocking" CssClass="input" runat="server" Width="330px">
            <asp:ListItem Value="Bottom - Left">左下方</asp:ListItem>
            <asp:ListItem Value="Bottom - Right" Selected="True">右下方</asp:ListItem>
        </asp:DropDownList></td>
</tr>
<tr><td>
拖动: </td><td> <asp:DropDownList ID="dropDrag" CssClass="input"  runat="server" Width="330px">
            <asp:ListItem Value="Enable Drag&amp;drop" Selected="True">允许拖动</asp:ListItem>
            <asp:ListItem Value="Disable Drag&amp;drop">禁止拖动</asp:ListItem>
        </asp:DropDownList> </td>
</tr>
<tr><td>
此文本显示在信息窗口: </td><td><asp:TextBox ID="textFull"  Rows="4" TextMode="MultiLine" Columns="39"  CssClass="input" runat="server" >此文本将显示在弹出窗口里.</asp:TextBox></td>
</tr>
<tr><td colspan="2">
<asp:Button ID="btnPopup" CssClass="btn_mouseout" onmouseover="this.className='btn_mouseover'"
onmouseout="this.className='btn_mouseout'" onmousedown="this.className='btn_mousedown'"
    onmouseup="this.className='btn_mouseup'"
            runat="server" Text="显示弹出窗" OnClick="btnPopup_Click"></asp:Button>
            &nbsp;&nbsp;&nbsp;&nbsp;     
     <asp:Button ID="btn4Ever"  CssClass="btn_mouseout" onmouseover="this.className='btn_mouseover'"
onmouseout="this.className='btn_mouseout'" onmousedown="this.className='btn_mousedown'"
    onmouseup="this.className='btn_mouseup'"
            runat="server" Text="不自动隐藏" OnClick="btn4Ever_Click"></asp:Button>
     &nbsp;&nbsp;&nbsp;&nbsp;
     <asp:Button ID="btnTwo"  CssClass="btn_mouseout" onmouseover="this.className='btn_mouseover'"
onmouseout="this.className='btn_mouseout'" onmousedown="this.className='btn_mousedown'"
    onmouseup="this.className='btn_mouseup'"
            runat="server" Text="显示2个窗口" OnClick="btnTwo_Click"></asp:Button>
      &nbsp;&nbsp;&nbsp;&nbsp;
      <asp:Button ID="btnBob" CssClass="btn_mouseout" onmouseover="this.className='btn_mouseover'"
onmouseout="this.className='btn_mouseout'" onmousedown="this.className='btn_mousedown'"
    onmouseup="this.className='btn_mouseup'"
            runat="server" Text="显示 Banner" OnClick="btnBob_Click"></asp:Button>
</td>
</tr>
<tr><td colspan="2" align=center> <span class="comment">
注意:由于以上按钮调用的是服务器控件,因此点完后页面会post一次,跑到页面顶部,<br />
页弹出框将会显示在页面最底部,这时只要将页面拉下来即可看到效果的</span></td></tr>
</table>

<!--放置控件等待调用-->

<PopupWin:popupwin id="popupWin"  runat="server" width="230px" height="100px" windowsize="300, 200"
            windowscroll="False" dockmode="BottomLeft" colorstyle="Blue" gradientdark="210, 200, 220"
            textcolor="0, 0, 3" shadow="125, 90, 160" lightshadow="185, 170, 200" darkshadow="128, 0, 102"
            visible="False" showlink="True" offsetx="150" ActionType="RaiseEvents" 
            OnLinkClicked="popupWin_LinkClick">
</PopupWin:popupwin>

 <PopupWin:popupwin id="popupWin2" title="Second window"  runat="server" 
            text="新窗口中显示的文本. <br><b>此文本来自第二个窗口</b>"
            width="230px" dockmode="BottomRight" gradientdark="225, 225, 208" textcolor="0, 50, 0"
            shadow="160, 180, 140" lightshadow="208, 221, 195" darkshadow="50, 100, 50" visible="False"
            actiontype="RaiseEvents" gradientlight="255, 255, 255" 
            message="你可以开多个弹出窗口! <br/><br/><b>可以自定义颜色和结构</b>"
            hideafter="8000" offsety="130" OnLinkClicked="popupWin2_LinkClick" 
            OnPopupClosed="popupWin2_PopupClose"> 
</PopupWin:popupwin>        
        
<PopupWin:popupwin  id="popupBob" title="Visit bbs.szblogs.com"  runat="server" Width="450px" Visible="False"
            linktarget="_blank" Link="http://bbs.szblogs.com" ActionType="OpenLink" DockMode="BottomLeft"
            Message="<img src=&quot;images/logo.gif&quot; border=&quot;0&quot; align=&quot;right&quot;><p><b>Winson.Framework <span style=&quot;color:#00a000;&quot;>PROJECT</span></b><br><br>深博技术论坛.</p>"
            LightShadow="255, 192, 128" Shadow="128, 64, 0" 
            TextColor="0, 0, 0" DarkShadow="0, 0, 0"
            GradientLight="251, 238, 187" GradientDark="255, 153, 0">
</PopupWin:popupwin>
        
        
 </div> 
 
<div id="Popup1-2">
以下只放出核心代码,其余的请大家自行查看此页面的源码吧:<br /><br />
前台HTML代码:
<pre><code class="html">
&lt;%--放置控件等待调用--%&gt;

&lt;PopupWin:popupwin id="popupWin" 
        runat="server" 
        width="230px" height="100px" 
        windowsize="300, 200" windowscroll="False" 
        dockmode="BottomLeft" colorstyle="Blue" 
        gradientdark="210, 200, 220"
        textcolor="0, 0, 3" shadow="125, 90, 160" 
        lightshadow="185, 170, 200" darkshadow="128, 0, 102"
        visible="False" showlink="True" offsetx="150" 
        ActionType="RaiseEvents" 
        OnLinkClicked="popupWin_LinkClick"&gt;
&lt;/PopupWin:popupwin&gt;

 &lt;PopupWin:popupwin id="popupWin2" 
		title="Second window"  runat="server" 
		text="新窗口中显示的文本. &lt;br&gt;&lt;b&gt;此文本来自第二个窗口&lt;/b&gt;"
		width="230px" dockmode="BottomRight" 
		gradientdark="225, 225, 208" textcolor="0, 50, 0"
		shadow="160, 180, 140" lightshadow="208, 221, 195" 
		darkshadow="50, 100, 50" visible="False"
		actiontype="RaiseEvents" gradientlight="255, 255, 255" 
		message="你可以开多个弹出窗口! &lt;br/&gt;&lt;br/&gt;&lt;b&gt;可以自定义颜色和结构&lt;/b&gt;"
		hideafter="8000" offsety="130" 
		OnLinkClicked="popupWin2_LinkClick" 
		OnPopupClosed="popupWin2_PopupClose"&gt; 
&lt;/PopupWin:popupwin&gt;        
        
&lt;PopupWin:popupwin  id="popupBob" 
		title="Visit bbs.szblogs.com" runat="server"
		Width="450px" Visible="False"
		linktarget="_blank" 
		Link="http://bbs.szblogs.com" 
		ActionType="OpenLink" DockMode="BottomLeft"
		Message="&lt;img src=&quot;images/logo.gif&quot; border=&quot;0&quot; align=&quot;right&quot;&gt;&lt;p&gt;&lt;b&gt;Winson.Framework &lt;span style=&quot;color:#00a000;&quot;&gt;PROJECT&lt;/span&gt;&lt;/b&gt;&lt;br&gt;&lt;br&gt;深博技术论坛.&lt;/p&gt;"
		LightShadow="255, 192, 128" Shadow="128, 64, 0" 
		TextColor="0, 0, 0" DarkShadow="0, 0, 0"
		GradientLight="251, 238, 187" 
		GradientDark="255, 153, 0"&gt;
&lt;/PopupWin:popupwin&gt;
</code></pre>

<br />
后台服务器端代码:
<pre><code class="csharp">
protected void btnPopup_Click(object sender, EventArgs e)
{
	popupWin.HideAfter = (sender == null) ? -1 : 5000;
	popupWin.Visible = true;
	popupWin.Title = textTitle.Text;
	popupWin.Message = textMsg.Text;
	popupWin.Text = textFull.Text;
	popupWin.DragDrop = (dropDrag.SelectedIndex == 0);
	switch (popDocking.SelectedIndex)
	{
		case 0: popupWin.DockMode = PopupDocking.BottomLeft; break;
		case 1: popupWin.DockMode = PopupDocking.BottomRight; break;
	}
	switch (clrStyle.SelectedIndex)
	{
		case 0: popupWin.ColorStyle = PopupColorStyle.Red; break;
		case 1: popupWin.ColorStyle = PopupColorStyle.Green; break;
		case 2: popupWin.ColorStyle = PopupColorStyle.Blue; break;
		case 3: popupWin.ColorStyle = PopupColorStyle.Violet; break;
	}
	popupWin2.Visible = false;
}

protected void btn4Ever_Click(object sender, System.EventArgs e)
{
	btnPopup_Click(null, null);
}

protected void btnTwo_Click(object sender, System.EventArgs e)
{
	btnPopup_Click(sender, e);
	popupWin2.DockMode = popupWin.DockMode;
	popupWin2.DragDrop = (dropDrag.SelectedIndex == 0);
	popupWin2.Visible = true;
}

protected void btnBob_Click(object sender, System.EventArgs e)
{
	popupBob.Visible = true;
	popupBob.DragDrop = (dropDrag.SelectedIndex == 0);
}
</code></pre>
 </div> 
 </div>
 <br />
  
  
   <b> 2.高级运用: (以钩子实现AJAX效果)</b><br />

<div id="Popup2">
<ul style="height: 30px;"> <li><a href="#Popup2-1"><span>　演　示　</span></a></li> <li><a href="#Popup2-2"><span>　源　码　</span></a></li>  

</ul> 

<div id="Popup2-1">
<table class="table-context">
<tr><td colspan="2"><b>无刷新显示弹出窗口 (以点击事件触发 - 当点击了“显示弹出窗”后，新的属性将会生效)</b></td></tr>
<tr><td>
新信息: </td><td> <asp:TextBox ID="NewMsg" Class="input" runat="server" Width="330px">新信息文本</asp:TextBox></td>
</tr>
<tr><td>
新标题: </td><td><asp:TextBox ID="NewTitle" Class="input" runat="server" Width="330px">新标题</asp:TextBox></td>
</tr>
<tr><td>
新文本: </td><td><asp:TextBox ID="NewText" Class="input" runat="server" Width="330px" Columns="39" Rows="4" TextMode="MultiLine">可以在新窗口里显示一段很长文本信息。点击“显示弹出窗”按钮以显示弹出窗口效果.</asp:TextBox></td>
</tr>

<tr><td colspan="2">

<Button ID="btnShow" class="btn_mouseout" onmouseover="this.className='btn_mouseover'"
    onmouseout="this.className='btn_mouseout'" onmousedown="this.className='btn_mousedown'"
    onmouseup="this.className='btn_mouseup'">&nbsp;&nbsp;显示弹出窗&nbsp;&nbsp;</Button></td>
</tr>
</table>
<!--放置一个弹出框控件-->
<PopupWin:popupwin id="popupTest" title="第一个标题" runat="server" 
    text="在新窗口的第一个文本"  message="第一个信息" dockmode="BottomLeft" 
    colorstyle="Violet" Height="107px" Width="235px" autoshow="False">
</PopupWin:popupwin>

<!--放置一个弹出框控件的钩子,因为要在母板里使用,所以必须设置ContentPlaceHolderID属性
　　但由于　linkedcontrol　关联的元素　btnShow　不是服务器端的，因此不需设置其　LinkedcontrolIsMp　属性
-->
 <PopupWin:popupwinanchor id="showTest" runat="server" 
    linkedcontrol="btnShow" popuptoshow="popupTest" newmessage="新的信息"
    newtext="可以在新窗口里显示一段很长文本信息。点击“显示弹出窗”按钮以显示弹出窗口效果"
    newtitle="新标题" ContentPlaceHolderID="ContentPlaceHolder1" 
    PopupToShowIsMP="True" changetexts="True">
</PopupWin:popupwinanchor>
 <br />           
            
<table class="table-context">
<tr><td colspan="2"><b>从控件添加互动帮助: (获取焦点后将触发弹出窗口事件)</b></td></tr>
<tr><td>
第一个项: </td><td><asp:TextBox ID="textFirst" Class="input" runat="server" Width="330px"></asp:TextBox></td>
</tr>
<tr><td>
第二个项: </td><td><asp:TextBox ID="textSecond" Class="input" runat="server" Width="330px"></asp:TextBox></td>
</tr>
<tr><td  colspan="2"><asp:Button ID="btnSetProp" CssClass="btn_mouseout" onmouseover="this.className='btn_mouseover'"
    onmouseout="this.className='btn_mouseout'" onmousedown="this.className='btn_mousedown'"
    onmouseup="this.className='btn_mouseup'"
    runat="server" Text="设置属性"  OnClick="btnSetProp_Click"></asp:Button>
           &nbsp;&nbsp;&nbsp;&nbsp;</td></tr>
</table>

<!--放置弹出框控件-->
 <PopupWin:popupwin id="popupHelp" title="互动帮助"         
        runat="server" gradientdark="143, 188, 139" gradientlight="200, 220, 200"
        textcolor="0, 0, 0" darkshadow="85, 107, 47" shadow="34, 139, 34" lightshadow="50, 155, 50"
        autoshow="False" hideafter="2000">
</PopupWin:popupwin>

 <!--放置弹出框控件的钩子,因为要在母板里使用,所以必须设置ContentPlaceHolderID属性-->         
 <PopupWin:popupwinanchor id="helpFirst" runat="server" popuptoshow="popupHelp" 
            linkedcontrol="textFirst" handledevent="onfocus"
            newtitle="互动帮助" newtext="输入第一项<br/><br/>看看效果如何"
            newmessage="在这里输入第一项" changetexts="True"
            PopupToShowIsMP="True" LinkedControlIsMP="True"
            ContentPlaceHolderID="ContentPlaceHolder1">
</PopupWin:popupwinanchor>
 
 <PopupWin:popupwinanchor id="helpSecond" runat="server" popuptoshow="popupHelp" 
        linkedcontrol="textSecond" handledevent="onfocus" 
        newtitle="互动帮助" newtext="输入第二项<br/><br/>看看效果如何."
        newmessage="这里输入第二项" changetexts="True"
        PopupToShowIsMP="True" LinkedControlIsMP="True"
        ContentPlaceHolderID="ContentPlaceHolder1">
</PopupWin:popupwinanchor>
 

</div>

<div id="Popup2-2">
以下只放出核心代码,其余的请大家自行查看此页面的源码吧:<br /><br />
无刷新显示弹出窗口:
<pre><code class="html">
&lt;!--被钩子绑定的元素，点击后即可通过钩子触发PopupWin控件了--&gt;
&lt;Button ID="btnShow" &gt;&nbsp;&nbsp;显  示&nbsp;&nbsp;&lt;/Button&gt;

&lt;!--放置PopupWin控件--&gt;
&lt;PopupWin:popupwin id="popupTest" title="第一个标题" runat="server" 
    text="在新窗口的第一个文本"  message="第一个信息" dockmode="BottomLeft" 
    colorstyle="Violet" Height="107px" Width="235px" autoshow="False"&gt;
&lt;/PopupWin:popupwin&gt;

&lt;!--为以上PopupWin控件放置一个钩子，因为要在母板里使用,所以必须设置ContentPlaceHolderID属性
      但由于　linkedcontrol　关联的元素　btnShow　不是服务器端的，因此不需设置其　LinkedcontrolIsMp　属性
--&gt;
 &lt;PopupWin:popupwinanchor id="showTest" runat="server" 
    linkedcontrol="btnShow" 
    popuptoshow="popupTest" 
    newmessage="新的信息"
    newtext='可以在新窗口里显示一段很长文本信息。点击“显示弹出窗”按钮以显示弹出窗口效果'
    newtitle='新标题' changetexts="True"&gt;
    PopupToShowIsMP="True" 
    ContentPlaceHolderID="ContentPlaceHolder1"
&lt;/PopupWin:popupwinanchor&gt;
</code></pre>
<br />

从控件添加互动帮助:
<pre><code class="html">
第一个项: &lt;asp:TextBox ID="textFirst" Class="input" runat="server" Width="330px"&gt;&lt;/asp:TextBox&gt;

第二个项: &lt;asp:TextBox ID="textSecond" Class="input" runat="server" Width="330px"&gt;&lt;/asp:TextBox&gt;

&lt;!--放置弹出框控件--&gt;
 &lt;PopupWin:popupwin id="popupHelp" title="互动帮助"         
        runat="server" gradientdark="143, 188, 139" gradientlight="200, 220, 200"
        textcolor="0, 0, 0" darkshadow="85, 107, 47" shadow="34, 139, 34" lightshadow="50, 155, 50"
        autoshow="False" hideafter="2000"&gt;
&lt;/PopupWin:popupwin&gt;

 &lt;!--放置弹出框控件的钩子,因为要在母板里使用,所以必须设置ContentPlaceHolderID属性--&gt;         
 &lt;PopupWin:popupwinanchor id="helpFirst" runat="server" popuptoshow="popupHelp" 
            linkedcontrol="ctl00_ContentPlaceHolder1_textFirst" handledevent="onfocus"
            newtitle="互动帮助" newtext="输入第一项&lt;br/&gt;&lt;br/&gt;看看效果如何"
            newmessage="在这里输入第一项" changetexts="True"
            ContentPlaceHolderID="ContentPlaceHolder1"
            PopupToShowIsMP="True" LinkedControlIsMP="True"&gt;
&lt;/PopupWin:popupwinanchor&gt;
 
 &lt;PopupWin:popupwinanchor id="helpSecond" runat="server" popuptoshow="popupHelp" 
        linkedcontrol="ctl00_ContentPlaceHolder1_textSecond" handledevent="onfocus" 
        newtitle="互动帮助" newtext="输入第二项&lt;br/&gt;&lt;br/&gt;看看效果如何."
        newmessage="这里输入第二项" changetexts="True"
        PopupToShowIsMP="True" LinkedControlIsMP="True"
        ContentPlaceHolderID="ContentPlaceHolder1"&gt;
&lt;/PopupWin:popupwinanchor&gt;
</code></pre>
</div>
</div>

 </form>  
 <div class="top"><br /><a href=# title="返回顶部">Top</a></div>
</asp:Content>

