﻿using System;
using System.IO;
using System.Text;
using System.Collections;
using System.Collections.Specialized;
using System.Configuration;
using System.Data;
using System.Linq;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Xml.Linq;
using Winson.Framework.DBProviders;
using Winson.Framework.Controls;
using Winson.EntityOP;

public partial class SqlPagerDemo : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!Page.IsPostBack)
        {
            //设置分页查询条件
            //SqlPager1.SelectCommand = "select top 20 * from Test";
            //SqlPager1.SortField = "ID";
            //SqlPager1.SortStyle = SortStyle.DESC;

            //可支持自定义数据源
            Test test = new Test();
            NameValueCollection conditionValue = new NameValueCollection();
            conditionValue["name like"] = "sdf";
            DataSet testds = test.GetDataSet(null);

            SqlPager1.UseCustomDataSource = true;
            SqlPager1.CustomDataSource = testds;
            SqlPager1.DataBind();            

            SqlPager2.UseCustomDataSource = true;
            SqlPager2.CustomDataSource = testds;
            SqlPager2.DataBind();

            SqlPager3.UseCustomDataSource = true;
            SqlPager3.CustomDataSource = testds;
            SqlPager3.DataBind();

            SqlPager4.UseCustomDataSource = true;
            SqlPager4.CustomDataSource = testds;
            SqlPager4.DataBind();
        }

        if (!String.IsNullOrEmpty(Request["Action"]))
        {
            if (Request["Action"].ToLower().Equals("sqlpager"))
            {
                switch (Request["paterID"].ToLower())
                {
                    case "gridviewshow"://判断使用的是哪个元素下的分页控件，这里要与前台的元素ID相对应
                        PageChange1();
                        break;
                    case "datalistshow":
                        PageChange2();
                        break;
                    case "repeatershow":
                        PageChange3();
                        break;
                    case "gridviewshow2":
                        PageChange4();
                        break;
                }                
            }
            else
            {
                Response.Write("");
                Response.End();
            }
        }
    }
    public override void VerifyRenderingInServerForm(Control control)
    {
        //重写一个空的VerifyRenderingInServerForm方法，
        //是为了让AJAX方式分页时可免去检测 <form runat=server >的限制，
        //否则在使用AJAX时会不能重现相关的控件.
        //同时还要在页面<@Page >里加入 EnableEventValidation="false" 的选项
        //如果使用服务器Post分页，则不需要此方法
    }


    private void PageChange1()
    {
        int newPageIndex = Convert.ToInt32(Request["newIndex"]);
        SqlPager1.GoToPage(newPageIndex);
        StringWriter writer1 = new StringWriter(System.Globalization.CultureInfo.InvariantCulture);
        HtmlTextWriter writer2 = new HtmlTextWriter(writer1);

        if (GridView1 != null)
        {
            GridView1.Visible = true;
            GridView1.RenderControl(writer2);
        }
        SqlPager1.RenderControl(writer2);
        writer2.Flush();
        writer2.Close();
        Response.Write(writer1.ToString());
        Response.End();
    }

    private void PageChange2()
    {
        int newPageIndex = Convert.ToInt32(Request["newIndex"]);
        SqlPager2.GoToPage(newPageIndex);
        StringWriter writer1 = new StringWriter(System.Globalization.CultureInfo.InvariantCulture);
        HtmlTextWriter writer2 = new HtmlTextWriter(writer1);

        if (DataList1 != null)
        {
            DataList1.Visible = true;
            DataList1.RenderControl(writer2);
        }
        SqlPager2.RenderControl(writer2);
        writer2.Flush();
        writer2.Close();
        Response.Write(writer1.ToString());
        Response.End();
    }

    private void PageChange3()
    {
        int newPageIndex = Convert.ToInt32(Request["newIndex"]);
        SqlPager3.GoToPage(newPageIndex);
        StringWriter writer1 = new StringWriter(System.Globalization.CultureInfo.InvariantCulture);
        HtmlTextWriter writer2 = new HtmlTextWriter(writer1);

        if (Repeater1 != null)
        {
            Repeater1.Visible = true;
            Repeater1.RenderControl(writer2);
        }
        SqlPager3.RenderControl(writer2);
        writer2.Flush();
        writer2.Close();
        Response.Write(writer1.ToString());
        Response.End();
    }

    private void PageChange4()
    {
        int newPageIndex = Convert.ToInt32(Request["newIndex"]);
        SqlPager4.GoToPage(newPageIndex);
        StringWriter writer1 = new StringWriter(System.Globalization.CultureInfo.InvariantCulture);
        HtmlTextWriter writer2 = new HtmlTextWriter(writer1);

        if (GridView2 != null)
        {
            GridView2.Visible = true;
            GridView2.RenderControl(writer2);
        }
        SqlPager4.RenderControl(writer2);
        writer2.Flush();
        writer2.Close();
        Response.Write(writer1.ToString());
        Response.End();
    }
    
}
