﻿<%@ Page Language="C#" MasterPageFile="~/MasterPage.master" AutoEventWireup="true" CodeFile="TagCloud.aspx.cs" Inherits="TagCloud"  %>
<%@ Register Assembly="Winson.Framework" Namespace="Winson.Framework.Controls" TagPrefix="TagCloud" %>
<asp:Content ID="Content1" ContentPlaceHolderID="Head" Runat="Server">
   <title>Winson.Framework_云标签控件的使用</title>
</asp:Content>
<asp:Content ID="Content3" ContentPlaceHolderID="Title" Runat="Server">
   <h2>云标签控件的使用</h2>
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="ContentPlaceHolder1" Runat="Server">
 <h5>一、基本说明：</h5>
<p>
    云标签控件可以使多个关键字以云方式显示出来，即很多博客系统里的热门关键字等Tag效果，此控件来自于 http://www.codeproject.com/KB/aspnet/cloud.aspx
 <br /><br />
  <h5>二、属性说明：</h5>
<div class="detail">
<ul>

<li><span class="parm">Items:</span>云标签项集合</li>
<li><span class="parm">DataTextField:</span>设置/获取要绑定字段的名称,For Text属性</li>
<li><span class="parm">DataTextFormatString:</span>设置/获取 绑定字段显示的格式,即格式化输出的字段,For text属性的显示，{0} 将会替换成DataTextField属性的值 </li>
<li><span class="parm">DataHrefField:</span>设置/获取要绑定字段的名称,For Href属性</li>
<li><span class="parm">DataHrefFormatString:</span>设置/获取 绑定字段显示的格式,即格式化输出的字段,For href属性的显示，{0} 将会替换成DataHrefField属性的值 </li>
<li><span class="parm">DataTitleField:</span>设置/获取要绑定字段的名称,For Title属性</li>
<li><span class="parm">DataTitleFormatString:</span>设置/获取 绑定字段显示的格式,即格式化输出的字段,For title属性的显示，{0} 将会替换成DataTitleField属性的值 </li>
<li><span class="parm">DataWeightField:</span>设置/获取要绑定字段的名称,For Weight属性</li>
<li><span class="parm">ItemCssClassPrefix:</span>设置/获取 CSS名称的前缀，如要设置此项，必须先定义好7个CSS，如前缀名为 CloudStyle ,那么对应实际的CSS应该有以下7个： CloudStyle1 CloudStyle2 CloudStyle3  ... CloudStyle7，将分别对应7种不同大小的字体</li>
</ul>
</div>
  
    <h5>三、使用说明：</h5>
    
    
   <b> 1.设置数据源: </b><br /><br />
    
 要使用TagCloud，必须需为此控件指定数据源，然后绑定，与Gridview等数据源和绑定方法都是一样的，代码如下：
  <pre><code class="csharp">
Test test = new Test();
TagCloud1.DataTextField = "Name";
TagCloud1.DataTitleField = "Age";
TagCloud1.DataTitleFormatString = "{0} artilces on the subject";
TagCloud1.DataWeightField = "Age";
TagCloud1.DataSource = test.GetList(null);
TagCloud1.DataBind();
</code></pre>  

这里要说明一点的是，对应的数据源的字段，必须要有与CloudItem相对应的属性，其中Weight是代表此标签的数量或者点击等，是必须要有的，以上我只是使用Test库里的Age代替，就不再另行创建表来演示了<br /><br />


 <b>2.添加Items项: </b><br /><br />
另可以直接为TagCloud添加Item，有以下2种方法:<br />
 前台HTML里添加:
 <pre><code class="html">
&lt;TagCloud:Cloud ID="TagCloud1"  runat="server" OnItemClick="TagCloud1_ItemClick" &gt;
&lt;Items&gt;
    &lt;TagCloud:CloudItem 
        Text="深圳博客网" 
        Href="http://www.szblogs.com" 
        Weight="100" /&gt;
    &lt;TagCloud:CloudItem 
        Text="Winson.Framework" 
        Title="Test" 
        Href="http://bbs.szblogs.com" 
        Weight="50" /&gt;
    &lt;TagCloud:CloudItem 
        Text="SqlPager" 
        Title="Test" 
        Href="SqlPager.aspx" 
        Weight="5" /&gt;
    &lt;TagCloud:CloudItem 
        Text="Popup" 
        Title="Test" 
        Href="Popup.aspx" 
        Weight="11" /&gt;
    &lt;TagCloud:CloudItem 
        Text="添加数据" 
        Title="Test" 
        Href="Data_add.aspx" 
        Weight="88" /&gt;
&lt;/Items&gt;
</code></pre>

 后台服务器端添加:
 <pre><code class="csharp">
TagCloud1.Items.Add(new CloudItem("Test",20,"www.szblogs.com","测试");
</code></pre>

 
 
 <form id="form1" runat="server"> 
<h5>四、效果演示：</h5>

   <b> 1.直接调用: </b>
<div id="Cloud1">

<ul style="height: 30px;"> <li><a href="#Cloud1-1"><span>　演　示　</span></a></li> <li><a href="#Cloud1-2"><span>　源　码　</span></a></li>  

</ul> 

<div id="Cloud1-1">

<br /><br />
<TagCloud:Cloud ID="TagCloud1"  runat="server" OnItemClick="TagCloud1_ItemClick" >
<Items>
    <TagCloud:CloudItem Text="深圳博客网" Href="http://www.szblogs.com" Weight="100" />
    <TagCloud:CloudItem Text="Winson.Framework" Title="Test" Href="http://bbs.szblogs.com" Weight="50" />
    <TagCloud:CloudItem Text="SqlPager" Title="Test" Href="SqlPager.aspx" Weight="5" />
    <TagCloud:CloudItem Text="Popup" Title="Test" Href="Popup.aspx" Weight="11" />
    <TagCloud:CloudItem Text="添加数据" Title="Test" Href="Data_add.aspx" Weight="88" />
</Items>
</TagCloud:Cloud>


 </div> 
 
<div id="Cloud1-2"> 
前台HTML:
 <pre><code class="html">
&lt;TagCloud:Cloud ID="TagCloud1"  runat="server" OnItemClick="TagCloud1_ItemClick" &gt;
&lt;Items&gt;
    &lt;TagCloud:CloudItem 
        Text="深圳博客网" 
        Href="http://www.szblogs.com" 
        Weight="100" /&gt;
    &lt;TagCloud:CloudItem 
        Text="Winson.Framework" 
        Title="Test" 
        Href="http://bbs.szblogs.com" 
        Weight="50" /&gt;
    &lt;TagCloud:CloudItem 
        Text="SqlPager" 
        Title="Test" 
        Href="SqlPager.aspx" 
        Weight="5" /&gt;
    &lt;TagCloud:CloudItem 
        Text="Popup" 
        Title="Test" 
        Href="Popup.aspx" 
        Weight="11" /&gt;
    &lt;TagCloud:CloudItem 
        Text="添加数据" 
        Title="Test" 
        Href="Data_add.aspx" 
        Weight="88" /&gt;
&lt;/Items&gt;
</code></pre>
<br />
后台服务器端
<pre><code class="csharp">
Test test = new Test();
TagCloud1.DataTextField = "Name";
TagCloud1.DataTitleField = "Age";
TagCloud1.DataTitleFormatString = "{0} artilces on the subject";
TagCloud1.DataWeightField = "Age";
TagCloud1.DataSource = test.GetList(null);
TagCloud1.DataBind();
</code></pre>

<span class="comment">为了防止点击item后页面post导致云标签失效，因此以上数据源设置的代码要放到 if(!IsPostBack) 之外</span>

 </div> 
 
</div>

</form>
</p>

</asp:Content>

