﻿using System;
using System.Text;
using System.Data;
using System.Reflection;
using System.Data.Common;
using System.Collections;
using System.Collections.Generic;
using System.Collections.Specialized;
using Winson.Framework.DBProviders;
using Winson.Framework.LogProviders;

namespace Winson.EntityOP.Base
{
    public class BaseOP
    {
        protected string sql;
        protected string _tableName;
        protected string _primekey;

        /// <summary>
        /// 获取最大ID
        /// </summary>
        /// <returns>最大ID</returns>
        public int GetMaxID()
        {
			if (_primekey.Length == 0) return 0;
            object max = null;
            int maxID = 1;
            string cSQL = "select max(" + _primekey + ") from " + _tableName;
            max = DBManage.ExecuteScalar(cSQL);
            if (max != null && max.ToString().Length > 0)
                maxID = (int)max + 1;
            return maxID;
        }
        
        /// <summary>
        /// 获取实体，返回DataSet
        /// </summary>
        /// <param name="conditionValue">条件参数，如键名为"sql"，则为自定义条件;如为NULL则获取所有实体</param>
        /// <returns>DataSet数据</returns>
        public DataSet GetDataSet(NameValueCollection conditionValue)
        {
            try
            {
                return DBManage.ExecuteDataset(sql, _tableName, conditionValue);
            }
            catch (Exception e)
            {
                LogManage.OutputErrLog(e, new Object[] { conditionValue });
                return null;
            }
            finally
            {
                DBManage.Conn.Close();//51aspx
            }
        }
        
        /// <summary>
        /// 生成分页的SQL语句
        /// </summary>
        /// <param name="tableName">表名</param>
        /// <param name="limit">每页显示记录数</param>
        /// <param name="currpage">当前页数</param>
        /// <param name="criteria">查询条件,null为查询所有</param>
        /// <param name="orderby">排序字段</param>
        /// <param name="order">排序方式，默认为 ASC</param>
        /// <returns>SQL语句</returns>
        public string GeneratePagerSql(string tableName, int limit, int currpage, string criteria, string orderby, string order)
        {
            return DBManage.GeneratePagerSql(tableName, limit, currpage, criteria, orderby, order);
        }//51aspx
            
        #region 私有方法
        /// <summary>
        /// 填充实体内容
        /// </summary>
        /// <param name="targetObj">实体对象</param>
        /// <param name="dr">DbDataReader对象</param>
        protected void FillDS(object targetObj, DbDataReader reader)
        {
            try
            {
                //实现首字母大写，规范所有属性名称
                System.Globalization.CultureInfo cult = System.Threading.Thread.CurrentThread.CurrentCulture;
                System.Globalization.TextInfo textInfo = cult.TextInfo;
                string name = string.Empty;

                for (int i = 0; i < reader.FieldCount; i++)
                {
                    name = textInfo.ToTitleCase(reader.GetName(i).ToLower());
                    PropertyInfo propertyInfo = targetObj.GetType().GetProperty(name);
                    if (propertyInfo != null)
                    {
                        if (reader.GetValue(i) != DBNull.Value && propertyInfo.CanWrite)
                        {
                            propertyInfo.SetValue(targetObj, reader.GetValue(i), null);
                        }
                    }
                }
            }
            catch (Exception e)
            {
                LogManage.OutputErrLog(e, new Object[] { targetObj, reader });                    
            }
        }

        /// <summary>
        /// 获取当前操作表的主键名称
        /// </summary>
        /// <returns>主键名称</returns>
        protected string GetPrimeKey()
        {
            try
            {
                string result = DBManage.GetPrimeKey(_tableName);
                if (result.Length > 0)
                    return result.ToString();
                else
                    throw new Exception("请确认所操作的表有主键字段！");
            }
            catch (Exception e)
            {
                LogManage.OutputErrLog(e, new Object[] { _tableName });
                return "";
            }
        }
        #endregion

    }
}

