﻿using System;

namespace Winson.EntityOP.Entity
{	
	/// <summary>
    /// Orders表实体类
    /// </summary>
	public class OrdersDS
    {
        public OrdersDS(){}
        
		#region 成员
		/// <summary>
		/// 获取或设置Orderid(可读写)
		/// </summary>
		public int Orderid{get;set;}
		/// <summary>
		/// 获取或设置Customerid(可读写)
		/// </summary>
		public string Customerid{get;set;}
		/// <summary>
		/// 获取或设置Employeeid(可读写)
		/// </summary>
		public int Employeeid{get;set;}
		/// <summary>
		/// 获取或设置Orderdate(可读写)
		/// </summary>
		public System.DateTime Orderdate{get;set;}
		/// <summary>
		/// 获取或设置Requireddate(可读写)
		/// </summary>
		public System.DateTime Requireddate{get;set;}
		/// <summary>
		/// 获取或设置Shippeddate(可读写)
		/// </summary>
		public System.DateTime Shippeddate{get;set;}
		/// <summary>
		/// 获取或设置Shipvia(可读写)
		/// </summary>
		public int Shipvia{get;set;}
		/// <summary>
		/// 获取或设置Freight(可读写)
		/// </summary>
		public decimal Freight{get;set;}
		/// <summary>
		/// 获取或设置Shipname(可读写)
		/// </summary>
		public string Shipname{get;set;}
		/// <summary>
		/// 获取或设置Shipaddress(可读写)
		/// </summary>
		public string Shipaddress{get;set;}
		/// <summary>
		/// 获取或设置Shipcity(可读写)
		/// </summary>
		public string Shipcity{get;set;}
		/// <summary>
		/// 获取或设置Shipregion(可读写)
		/// </summary>
		public string Shipregion{get;set;}
		/// <summary>
		/// 获取或设置Shippostalcode(可读写)
		/// </summary>
		public string Shippostalcode{get;set;}
		/// <summary>
		/// 获取或设置Shipcountry(可读写)
		/// </summary>
		public string Shipcountry{get;set;}
		/// <summary>
		/// 获取字段数量(只读)
		/// </summary>
        public int Count{get { return 14; }}
        #endregion

		#region 索引器
        public object this[int index, int type, int maxID]
        {			 
			get
			{
				if(type==1)
                {
                    #region 返回字段名
                    switch (index)
                    {
						 case 0:
							 if (maxID > 0 || Orderid > 0)
								 return "Orderid";
							 else
								 return null;
						 case 1:
							 if(Customerid != null && Customerid.Length > 0)
								 return "Customerid";
							 else
								 return null;
						 case 2:
							 if(Employeeid > 0)
								 return "Employeeid";
							 else
								 return null;
						 case 3:
							 if(Orderdate != DateTime.MaxValue && Orderdate != DateTime.MinValue)
								 return "Orderdate";
							 else
								 return null;
						 case 4:
							 if(Requireddate != DateTime.MaxValue && Requireddate != DateTime.MinValue)
								 return "Requireddate";
							 else
								 return null;
						 case 5:
							 if(Shippeddate != DateTime.MaxValue && Shippeddate != DateTime.MinValue)
								 return "Shippeddate";
							 else
								 return null;
						 case 6:
							 if(Shipvia > 0)
								 return "Shipvia";
							 else
								 return null;
						 case 7:
							 if(Freight > 0)
								 return "Freight";
							 else
								 return null;
						 case 8:
							 if(Shipname != null && Shipname.Length > 0)
								 return "Shipname";
							 else
								 return null;
						 case 9:
							 if(Shipaddress != null && Shipaddress.Length > 0)
								 return "Shipaddress";
							 else
								 return null;
						 case 10:
							 if(Shipcity != null && Shipcity.Length > 0)
								 return "Shipcity";
							 else
								 return null;
						 case 11:
							 if(Shipregion != null && Shipregion.Length > 0)
								 return "Shipregion";
							 else
								 return null;
						 case 12:
							 if(Shippostalcode != null && Shippostalcode.Length > 0)
								 return "Shippostalcode";
							 else
								 return null;
						 case 13:
							 if(Shipcountry != null && Shipcountry.Length > 0)
								 return "Shipcountry";
							 else
								 return null;
                        default:
                            return null;                           
                    }
                    #endregion
                }
                else
                {
                    #region 返回字段值
                    switch (index)
                    {
						 case 0:
							 if (maxID > 0)
								 return maxID;
							 else if(Orderid > 0)
								 return  Orderid;
							 else
								 return null;
						 case 1:
								 return Customerid;
						 case 2:
								 return Employeeid;
						 case 3:
								 return Orderdate;
						 case 4:
								 return Requireddate;
						 case 5:
								 return Shippeddate;
						 case 6:
								 return Shipvia;
						 case 7:
								 return Freight;
						 case 8:
								 return Shipname;
						 case 9:
								 return Shipaddress;
						 case 10:
								 return Shipcity;
						 case 11:
								 return Shipregion;
						 case 12:
								 return Shippostalcode;
						 case 13:
								 return Shipcountry;
                        default:
                            return null;                           
                    }
                    #endregion
                }
			}	            
        }
		#endregion
	}
}


