﻿using System;

namespace Winson.EntityOP.Entity
{	
	/// <summary>
    /// Products表实体类
    /// </summary>
	public class ProductsDS
    {
        public ProductsDS(){}
        
		#region 成员
		/// <summary>
		/// 获取或设置Productid(可读写)
		/// </summary>
		public int Productid{get;set;}
		/// <summary>
		/// 获取或设置Productname(可读写)
		/// </summary>
		public string Productname{get;set;}
		/// <summary>
		/// 获取或设置Supplierid(可读写)
		/// </summary>
		public int Supplierid{get;set;}
		/// <summary>
		/// 获取或设置Categoryid(可读写)
		/// </summary>
		public int Categoryid{get;set;}
		/// <summary>
		/// 获取或设置Quantityperunit(可读写)
		/// </summary>
		public string Quantityperunit{get;set;}
		/// <summary>
		/// 获取或设置Unitprice(可读写)
		/// </summary>
		public decimal Unitprice{get;set;}
		/// <summary>
		/// 获取或设置Unitsinstock(可读写)
		/// </summary>
		public short Unitsinstock{get;set;}
		/// <summary>
		/// 获取或设置Unitsonorder(可读写)
		/// </summary>
		public short Unitsonorder{get;set;}
		/// <summary>
		/// 获取或设置Reorderlevel(可读写)
		/// </summary>
		public short Reorderlevel{get;set;}
		private bool _discontinued;
		private bool _discontinuedSetValue = false;
		public bool Discontinued { get{return _discontinued;} set { _discontinued = value ; _discontinuedSetValue = true; }}
		
		/// <summary>
		/// 获取字段数量(只读)
		/// </summary>
        public int Count{get { return 10; }}
        #endregion

		#region 索引器
        public object this[int index, int type, int maxID]
        {			 
			get
			{
				if(type==1)
                {
                    #region 返回字段名
                    switch (index)
                    {
						 case 0:
							 if (maxID > 0 || Productid > 0)
								 return "Productid";
							 else
								 return null;
						 case 1:
							 if(Productname != null && Productname.Length > 0)
								 return "Productname";
							 else
								 return null;
						 case 2:
							 if(Supplierid > 0)
								 return "Supplierid";
							 else
								 return null;
						 case 3:
							 if(Categoryid > 0)
								 return "Categoryid";
							 else
								 return null;
						 case 4:
							 if(Quantityperunit != null && Quantityperunit.Length > 0)
								 return "Quantityperunit";
							 else
								 return null;
						 case 5:
							 if(Unitprice > 0)
								 return "Unitprice";
							 else
								 return null;
						 case 6:
						 case 7:
						 case 8:
						 case 9:
							 if(_discontinuedSetValue)
								 return "Discontinued";
							 else
								 return null;
                        default:
                            return null;                           
                    }
                    #endregion
                }
                else
                {
                    #region 返回字段值
                    switch (index)
                    {
						 case 0:
							 if (maxID > 0)
								 return maxID;
							 else if(Productid > 0)
								 return  Productid;
							 else
								 return null;
						 case 1:
								 return Productname;
						 case 2:
								 return Supplierid;
						 case 3:
								 return Categoryid;
						 case 4:
								 return Quantityperunit;
						 case 5:
								 return Unitprice;
						 case 6:
								 return Unitsinstock;
						 case 7:
								 return Unitsonorder;
						 case 8:
								 return Reorderlevel;
						 case 9:
								 return Discontinued;
                        default:
                            return null;                           
                    }
                    #endregion
                }
			}	            
        }
		#endregion
	}
}


