﻿using System;

namespace Winson.EntityOP.Entity
{
    /// <summary>
    /// Test表实体类
    /// </summary>
    public class TestDS
    {
        public TestDS() { }

        #region 成员
        private int _id;
        private string _name;
        private bool _nameSetValue = false;
        private int _age;
        private bool _ageSetValue = false;
        private System.DateTime _datetime;
        private System.Byte[] _pic;
        private string _context;
        private bool _isuse;
        private bool _isuseSetValue = false;



        /// <summary>
        /// 获取或设置Id(可读写)
        /// </summary>
        public int Id
        {
            get { return _id; }
            set { _id = value; }
        }

        /// <summary>
        /// 获取或设置Name(可读写)
        /// </summary>
        public string Name
        {
            get { return _name; }
            set { _name = value; _nameSetValue = true; }
        }

        /// <summary>
        /// 获取或设置Age(可读写)
        /// </summary>
        public int Age
        {
            get { return _age; }
            set { _age = value; _ageSetValue = true; }
        }

        /// <summary>
        /// 获取或设置Datetime(可读写)
        /// </summary>
        public System.DateTime Datetime
        {
            get { return _datetime; }
            set { _datetime = value; }
        }

        /// <summary>
        /// 获取或设置Pic(可读写)
        /// </summary>
        public System.Byte[] Pic
        {
            get { return _pic; }
            set { _pic = value; }
        }

        /// <summary>
        /// 获取或设置Context(可读写)
        /// </summary>
        public string Context
        {
            get { return _context; }
            set { _context = value; }
        }

        /// <summary>
        /// 获取或设置Isuse(可读写)
        /// </summary>
        public bool Isuse
        {
            get { return _isuse; }
            set { _isuse = value; _isuseSetValue = true; }
        }
        /// <summary>
        /// 获取字段数量(只读)
        /// </summary>
        public int Count { get { return 7; } }
        #endregion

        #region 索引器
        public object this[int index, int type, int maxID]
        {
            get
            {
                if (type == 1)
                {
                    #region 返回字段名
                    switch (index)
                    {
                        case 0:
                            if (maxID > 0 || Id > 0)
                                return "Id";
                            else
                                return null;
                        case 1:
                            if ((Name != null && Name.Length > 0)||_nameSetValue)
                                return "Name";
                            else
                                return null;
                        case 2:
                            if (_age != 0 || _ageSetValue)
                                return "Age";
                            else
                                return null;
                        case 3:
                            if (Datetime != DateTime.MaxValue && Datetime != DateTime.MinValue)
                                return "Datetime";
                            else
                                return null;
                        case 4:
                            if (Pic != null)
                                return "Pic";
                            else
                                return null;
                        case 5:
                            if (Context != null && Context.Length > 0)
                                return "Context";
                            else
                                return null;
                        case 6:
                            if (_isuseSetValue)
                                return "Isuse";
                            else
                                return null;
                        default:
                            return null;
                    }
                    #endregion
                }
                else
                {
                    #region 返回字段值
                    switch (index)
                    {
                        case 0:
                            if (maxID > 0)
                                return maxID;
                            else if (Id > 0)
                                return Id;
                            else
                                return null;
                        case 1:
                            return Name;
                        case 2:
                            return Age;
                        case 3:
                            return Datetime;
                        case 4:
                            return Pic;
                        case 5:
                            return Context;
                        case 6:
                            return Isuse;
                        default:
                            return null;
                    }
                    #endregion
                }
            }
        }
        #endregion
    }
}


