﻿using System.Collections;
using System.Collections.Generic;
using System.Collections.Specialized;
using Winson.Framework.DBProviders;
using Winson.Framework.LogProviders;
using Winson.EntityOP.Base;
using Winson.EntityOP.Entity;
using Winson.EntityOP.BaseEntityOP;

namespace Winson.EntityOP
{	
	/// <summary>
    /// Products实体操作类
    /// </summary>
	public class Products
    {
        #region 私有变量
        EntityCollection<ProductsDS> _productsList;
        ProductsDS _productsDS;
        ProductsOP _op;
        #endregion

        #region 构造函数
        public Products()
        {
            _op = new  ProductsOP();
            _productsDS = new  ProductsDS();
            _productsList = new EntityCollection< ProductsDS>();
        }
        #endregion

        #region 实体操作
        /// <summary>
        /// 获取实体
        /// </summary>
        public ProductsDS Entity
        {
            get { return _productsDS; }
        }
        /// <summary>
        /// 创建新的实体
        /// </summary>
        public void CreateEntity()
        {
            _productsDS = new ProductsDS();
        }
        /// <summary>
        /// 追加实体到集合，以便批量操作
        /// </summary>
        public void AppendEntity()
        {
            _productsList.Add(_productsDS);
        }
        #endregion        

        #region 查询操作
        /// <summary>
        /// 获取实体集合
        /// </summary>
        /// <param name="conditionValue">条件参数，如键名为"sql"，则为自定义条件;如为NULL则获取所有实体</param>
        /// <returns>实体集合</returns>
        public IList GetList(NameValueCollection conditionValue)
        {
            return _op.GetList(conditionValue);
        }
        /// <summary>
        /// 从数据库中获取单个实体
        /// </summary>
        /// <param name="conditionValue">条件参数，如键名为"sql"，则为自定义条件;如为NULL则获取最后一个新增的实体</param>
        /// <returns>实体</returns>
        public ProductsDS GetEntity(NameValueCollection conditionValue)
        {
            return _op.GetEntity(conditionValue);
        }
        /// <summary>
        /// 从实体集合中获取单个实体
        /// </summary>
        /// <param name="entityList">实体集合</param>
        /// <param name="fieldID">实体ID</param>
        /// <returns>实体</returns>
        public ProductsDS GetEntity(IList entityList, int fieldID)
        {
            return _op.GetEntity(entityList, fieldID);
        }
        #endregion

        #region 单实体操作
        /// <summary>
        /// 添加实体
        /// </summary>
        /// <returns>影响记录数</returns>
        public int Add()
        {
            return _op.Add(_productsDS);
        }
        /// <summary>
        /// 更新实体
        /// </summary>
        /// <param name="conditionValue">条件参数，如键名为"sql"，则为自定义条件</param>
        /// <returns>影响记录数</returns>
        public int Update(NameValueCollection conditionValue)
        {
            return _op.Update(_productsDS, conditionValue);
        }
        /// <summary>
        /// 删除实体
        /// </summary>
        /// <param name="conditionValue">条件参数，如键名为"sql"，则为自定义条件</param>
        /// <returns>影响记录数</returns>
        public int Delete(NameValueCollection conditionValue)
        {
            return _op.Delete(conditionValue);
        }
        #endregion

        #region 批量操作

        /// <summary>
        /// 批量添加实体
        /// </summary>
        /// <returns>成功返回True 否则返回False</returns>
        public bool AddBatch()
        {
			if (_productsList.Count == 0)
                return false;
            else
            	return _op.AddBatch(_productsList);
        }

        /// <summary>
        /// 批量更新实体
        /// </summary>
        /// <returns>成功返回True 否则返回False</returns>
        public bool UpdateBatch()
        {
            if (_productsList.Count == 0)
                return false;
            else
            	return _op.UpdateBatch(_productsList);
        }

        /// <summary>
        /// 批量删除实体
        /// </summary>
        /// <returns>成功返回True 否则返回False</returns>
        public bool DeleteBatch()
        {
            if (_productsList.Count == 0)
                return false;
            else
            	return _op.DeleteBatch(_productsList);
        }
        #endregion
    }
}


