using System;
using System.Collections.Generic;
using System.Text;

namespace Winson.Framework.Controls
{
	public class CloudItem
	{
		public CloudItem()
		{
		}

		public CloudItem(string text, double weight)
		{
			this._text = text;
			this._weight = weight;
		}

		public CloudItem(string text, double weight, string href)
			: this(text, weight)
		{
			this._href = href;
		}

		public CloudItem(string text, double weight, string href, string title)
			: this(text, weight, href)
		{
			this._title = title;
		}

		private string _text;

		/// <summary>
		/// /ȡǩӵı
		/// </summary>
		public string Text
		{
			get
			{
				return _text;
			}
			set
			{
				_text = value;
			}
		}

		private string _href;

		/// <summary>
        /// /ȡǩURL
		/// </summary>
		public string Href
		{
			get
			{
				return _href;
			}
			set
			{
				_href = value;
			}
		}

		private string _title;

		/// <summary>
        /// /ȡǩӵʾ
		/// </summary>
		public string Title
		{
			get
			{
				return _title;
			}
			set { _title = value; }
		}

		private double _weight;

		/// <summary>
        /// /ȡǩ
		/// </summary>
		public double Weight
		{
			get { return _weight; }
			set { _weight = value; }
		}

		#region ݵл֧

		private bool ShouldSerializeWeight()
		{
			return _weight != 0;
		}

		private bool ShouldSerializeTitle()
		{
			return !String.IsNullOrEmpty(_title);
		}

		private bool ShouldSerializeText()
		{
			return !String.IsNullOrEmpty(_text);
		}

		private bool ShouldSerializeHref()
		{
			return !String.IsNullOrEmpty(_href);
		}

		#endregion

	}
}
