﻿using System;
using System.Collections.Generic;
using System.Configuration.Provider;
using System.Collections.Specialized;
using Winson.Framework.DBProviders;

namespace Winson.Framework.LogProviders
{
    internal abstract class LogProviderBase : ProviderBase
    {
        /// <summary>
        /// 异常日志记录
        /// </summary>
        /// <param name="methodName">抛出异常方法名</param>
        /// <param name="parametersList">方法参数列表,调用对象的ToString方法完成</param>
        /// <param name="exception">异常</param>
        /// <returns>成功为true 否则为 false</returns>
        public abstract bool OutputErrLog(string methodName,
                                      string parametersList,
                                      Exception exception);


        public virtual bool OutputEventLog(string tableName, NameValueCollection paramValue)
        {
            string strSql = "Insert into " + tableName;
            if (paramValue != null && paramValue.Count > 0)
            {
                strSql += " (";
                for (int i = 0; i < paramValue.Count; i++)
                {
                    strSql += paramValue.GetKey(i) + ",";
                }
                strSql = strSql.Substring(0, strSql.Length - 1);
                strSql += ") VALUES (";
                for (int i = 0; i < paramValue.Count; i++)
                {
                    strSql += "'" + paramValue.GetValues(i).GetValue(0).ToString() + "',";
                }
                strSql = strSql.Substring(0, strSql.Length - 1) + ")";
            }

            if (DBManage.ExecuteNonQuery(strSql) > 0)
                return true;
            else
                return false;
        }
    }
}
