﻿using System;
using System.Configuration.Provider;

namespace Winson.Framework.LogProviders
{
     partial class LogProviderCollection : ProviderCollection
    {
        /// <summary>
        /// 通过name获取provider
        /// </summary>
        public new LogProviderBase this[string name]
        {
            get { return (LogProviderBase)base[name]; }
        }

        /// <summary>
        /// 向集合中添加提供程序。
        /// </summary>
        /// <param name="provider">要添加的提供程序。</param>
        public override void Add(ProviderBase provider)
        {
            if (provider == null)
                throw new ArgumentNullException("provider参数不能为null");

            if (!(provider is LogProviderBase))
                throw new ArgumentException("provider参数类型必须是LogProviderBase.");

            base.Add(provider);

        }
    }
}
