﻿using System;
using System.Collections.Generic;
using System.Text;
using System.IO;

namespace Onfly.Editor
{
    /// <summary>
    /// 文件夹操作
    /// </summary>
    public static class DirectoryAction
    {
        #region 文件夹删除(包括其下子文件)
        /// <summary>
        /// 文件夹删除(包括其下子文件)
        /// </summary>
        /// <param name="DirectoryPath"></param>
        /// <returns></returns>
        public static bool DeleteDirectory(String DirectoryPath)
        {
            try
            {
                if (Directory.Exists(DirectoryPath)) //如果存在这个文件夹删除 
                {
                    foreach (string d in Directory.GetFileSystemEntries(DirectoryPath))
                    {
                        if (File.Exists(d))
                            File.Delete(d); //直接删除其中的文件 
                        else
                            DeleteDirectory(d); //递归删除子文件夹 
                    }
                    Directory.Delete(DirectoryPath); //删除已空文件夹 
                }
                return true;
            }
            catch
            {
                return false;
            }
        }
        #endregion

        #region 创建文件夹
        /// <summary>
        /// 创建文件夹
        /// </summary>
        /// <param name="DirectoryPath"></param>
        /// <returns></returns>
        public static bool CreateDirectory(String DirectoryPath)
        {
            try
            {
                if (Directory.Exists(DirectoryPath)) //存在则不创建
                {
                    return false;
                }
                Directory.CreateDirectory(DirectoryPath);//用于创建指定目录的文件夹
                return true;
            }
            catch
            {
                return false;
            }
        }
        #endregion

        //51aspx
        #region 拷贝文件夹
        /// <summary>
        /// 拷贝文件夹
        /// </summary>
        /// <param name="sourcePath"></param>
        /// <param name="objectPath"></param>
        /// <returns></returns>
        public static bool CopyDirectory(String sourcePath, String objectPath)
        {
            try
            {
                // 检查目标目录是否以目录分割字符结束如果不是则添加
                if (objectPath[objectPath.Length - 1] != Path.DirectorySeparatorChar)
                    objectPath += Path.DirectorySeparatorChar;
                // 判断目标目录是否存在如果不存在则新建
                if (!Directory.Exists(objectPath)) Directory.CreateDirectory(objectPath);
                // 得到源目录的文件列表，该里面是包含文件以及目录路径的一个数组
                // 如果你指向copy目标文件下面的文件而不包含目录请使用下面的方法
                // string[] fileList = Directory.GetFiles(sourcePath);
                string[] fileList = Directory.GetFileSystemEntries(sourcePath);
                // 遍历所有的文件和目录
                foreach (string file in fileList)
                {
                    // 先当作目录处理如果存在这个目录就递归Copy该目录下面的文件
                    if (Directory.Exists(file))
                        CopyDirectory(file, objectPath + Path.GetFileName(file));
                    // 否则直接Copy文件
                    else
                        File.Copy(file, objectPath + Path.GetFileName(file), true);
                }
                return true;
            }
            catch
            {
                return false;
            }
        }
        #endregion

        #region 文件夹移动
        /// <summary>
        /// 文件夹移动
        /// </summary>
        /// <param name="sourcePath"></param>
        /// <param name="objectPath"></param>
        /// <returns></returns>
        public static bool MoveDirectory(String sourcePath, String objectPath)
        {
            try
            {
                if (!Directory.Exists(sourcePath)) //源文件夹不存在则退出
                {
                    return false;
                }
                CopyDirectory(sourcePath, objectPath);  //复制源文件夹及子到目标文件夹
                DeleteDirectory(sourcePath);    //删除源文件夹及子
                return true;
            }
            catch
            {
                return false;
            }
        }
        #endregion

    }
}
