﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Text;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Collections.Specialized;

//51aspx
namespace Onfly.Editor
{
    /// <summary>
    /// 简单版编辑器
    /// </summary>
    [DefaultProperty("Text")]
    [ToolboxData("<{0}:Editor runat=server></{0}:Editor>")]
    public class Editor : System.Web.UI.WebControls.WebControl, INamingContainer, IPostBackDataHandler
    {
        /// <summary>
        /// ValueChangedEvent
        /// </summary>
        private static readonly object ValueChangedEvent;
        /// <summary>
        /// 编辑器值
        /// </summary>
        [Bindable(true)]
        [Category("Appearance")]
        [DefaultValue("")]
        [Localizable(true)]
        public string Text
        {
            get { object o = ViewState["Text"]; return (o == null ? "" : (string)o); }
            set { ViewState["Text"] = value; }
        }
        /// <summary>
        /// 编辑器高度
        /// </summary>
        [Bindable(true)]
        [Category("Custom Parameters")]
        [Browsable(true)]
        [Description("编辑器高度")]
        [DefaultValue("268px")]
        public Unit Height
        {
            get
            {
                object o = ViewState["Height"];
                return (o == null ? Unit.Pixel(268) : (Unit)o);
            }
            set { ViewState["Height"] = value; }
        }
        /// <summary>
        /// 编辑器宽度
        /// </summary>
        [Bindable(true)]
        [Category("Custom Parameters")]
        [Browsable(true)]
        [Description("编辑器宽度")]
        [DefaultValue("408px")]
        public Unit Width
        {
            get
            {
                object o = ViewState["Width"];
                return (o == null ? new Unit("100%") : (Unit)o);
            }
            set { ViewState["Width"] = value; }
        }
        /// <summary>
        /// 编辑器文件包路径
        /// </summary>
        [Bindable(true)]
        [Category("Custom Parameters")]
        [Browsable(true)]
        [Description("编辑器文件包路径")]
        [DefaultValue("AppSettings['Onfly:Editor.BasePath']")]
        public string BasePath
        {
            get
            {
                object o = ViewState["BasePath"];
                if (o == null)
                    o = System.Configuration.ConfigurationManager.AppSettings["Onfly:Editor.BasePath"];
                return (o == null ? "/editor/" : (string)o);
            }
            set { ViewState["BasePath"] = value; }
        }
        /// <summary>
        /// 输出编辑器界面
        /// </summary>
        /// <param name="writer"></param>
        protected override void Render(HtmlTextWriter writer)
        {
            writer.Write(
                    "<input type=\"hidden\" id=\"{0}\" name=\"{1}\" value=\"{2}\" />",
                        this.ClientID,
                        this.UniqueID,
                        System.Web.HttpUtility.HtmlEncode(this.Text));
            writer.Write(
                        "<iframe id=\"iframe{0}\" src=\"" + this.BasePath + "editor.html?id={0}&width={1}&height={2}\" frameborder=\"0\" style=\"width:{1};height:{2};overflow:hidden;\"></iframe>",
                            this.ClientID,
                            this.Width,
                            this.Height);
        }

        //51aspx
        /// <summary>
        /// Value Changed
        /// </summary>
        public event EventHandler ValueChanged
        {
            add
            {
                base.Events.AddHandler(ValueChangedEvent, value);
            }
            remove
            {
                base.Events.RemoveHandler(ValueChangedEvent, value);
            }
        }
        /// <summary>
        /// OnValueChanged
        /// </summary>
        /// <param name="e"></param>
        protected virtual void OnValueChanged(EventArgs e)
        {
            if (base.Events != null)
            {
                EventHandler handler = (EventHandler)base.Events[ValueChangedEvent];
                if (handler != null)//5-1-a-s-p-x
                {
                    handler(this, e);
                }
            }
        }
        /// <summary>
        /// IPostBackDataHandler
        /// </summary>
        void IPostBackDataHandler.RaisePostDataChangedEvent()
        {
            this.OnValueChanged(EventArgs.Empty);
        }
        /// <summary>
        /// LoadPostData
        /// </summary>
        /// <param name="postDataKey"></param>
        /// <param name="postCollection"></param>
        /// <returns></returns>
        bool IPostBackDataHandler.LoadPostData(string postDataKey, NameValueCollection postCollection)
        {
            if (postCollection[postDataKey] != this.Text)
            {
                this.Text = postCollection[postDataKey];
                return true;
            }
            return false;
        }
    }
}
