﻿using System;
using System.Globalization;
using System.Web;
using System.Text;
using System.Text.RegularExpressions;

namespace Onfly.Editor
{
    /// <summary>
    /// 文件上传
    /// </summary>
    public class UploadFile : System.Web.UI.Page
    {
        /// <summary>
        /// 上传控件
        /// </summary>
        HttpPostedFile fileupload;
        /// <summary>
        /// 文件保存路径
        /// </summary>
        protected string fileSavePath = "";
        /// <summary>
        /// OnLoad
        /// </summary>
        /// <param name="e"></param>
        protected override void OnLoad(EventArgs e)
        {
            try
            {
                fileupload = Request.Files["fileload"];
                if (fileupload == null)
                {
                    Response.Write("<script type=\"text/javascript\">");
                    Response.Write("parent.filerror();");
                    Response.Write("</script>");
                    return;
                }
                String fileName = fileupload.FileName.ToLower();
                String fileType = FileType(fileName);
                if (IsImage(fileName))
                {
                    String configpath = System.Configuration.ConfigurationManager.AppSettings["Onfly:Editor.FileSavePath"];
                    String tplPath = fileSavePath == configpath || fileSavePath == "" ? configpath : fileSavePath;
                    String newPath = fileSavePath == configpath || fileSavePath == "" ? GetSaveFilePath(tplPath) : "";
                    String newFileName = GetFileName(fileName);
                    DirectoryAction.CreateDirectory(System.Web.HttpContext.Current.Server.MapPath(tplPath));
                    fileupload.SaveAs(System.Web.HttpContext.Current.Server.MapPath(tplPath) + newPath + newFileName);
                    String sufile = (tplPath + newPath + newFileName).Replace("\\", "/").Replace("//", "/");
                    Response.Write("<script type=\"text/javascript\">");
                    Response.Write("parent.filesucceed('" + sufile + "') ;");
                    Response.Write("</script>");
                }
            }
            catch//51aspx
            {
                Response.Write("<script type=\"text/javascript\">");
                Response.Write("parent.filerror();");
                Response.Write("</script>");
            }
        }
        /// <summary>
        /// 文件扩展名
        /// </summary>
        /// <param name="fileName"></param>
        /// <returns></returns>
        private static String FileType(String fileName)
        {
            try
            {
                Int32 s = fileName.LastIndexOf(".");
                return fileName.Substring(s, fileName.Length - s).ToLower();
            }
            catch
            {
                return String.Empty;
            }

        }
        /// <summary>
        /// 强制重命名
        /// </summary>
        /// <param name="fileName"></param>
        /// <returns></returns>
        private String GetFileName(String fileName)
        {
            try//5~1-a~s~p~x
            {
                Int32 n = fileName.LastIndexOf(".");
                Int32 s = fileName.LastIndexOf("\\");
                Int32 startPos = fileName.LastIndexOf(".");
                String ext = fileName.Substring(startPos, fileName.Length - startPos);
                return DateTime.Now.ToString("\\\\yyyyMMddhhmmssffff") + ext;
            }
            catch
            {
                return string.Empty;
            }
        }
        /// <summary>
        /// 创建文件保存路径
        /// </summary>
        /// <param name="Path"></param>
        /// <returns></returns>
        private static String GetSaveFilePath(String Path)
        {
            try
            {
                String SavePath = System.Web.HttpContext.Current.Server.MapPath(Path);
                DateTime dateTime = DateTime.Now;
                string dir = dateTime.ToString(@"\\yyyyMMdd");
                DirectoryAction.CreateDirectory(SavePath + dir);
                return dir;
            }
            catch
            {
                return String.Empty;
            }
        }
        /// <summary>
        /// 验证图片格式
        /// </summary>
        /// <param name="strIn"></param>
        /// <returns></returns>//5^1^a^s^p^x
        public static Boolean IsImage(String S)
        {
            String fe =  System.Configuration.ConfigurationManager.AppSettings["Onfly:Editor.FileExtension"];
            fe = fe == null ? "gif|jpg|jpeg|png|bmp" : fe;
            Regex r = new Regex(@"^.+.(" + fe + ")$");
            return Regex.IsMatch(S, @"^.+.(" + fe + ")$");
        }
    }
}
