﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;

namespace TailspinSpyworks.Account
{
    public partial class Register : System.Web.UI.Page
    {

        protected void Page_Load(object sender, EventArgs e)
        {   //单击继续按钮后要使用的URL，这里直接使用ReturnUrl查询字符串
            RegisterUser.ContinueDestinationPageUrl = Request.QueryString["ReturnUrl"];
        }

        protected void RegisterUser_CreatedUser(object sender, EventArgs e)
        {
            //为注册用户创建Cookie
            FormsAuthentication.SetAuthCookie(RegisterUser.UserName, false);
            //获取用户单击继续按钮后将导航到的URL地址
            string continueUrl = RegisterUser.ContinueDestinationPageUrl;
            if (String.IsNullOrEmpty(continueUrl))
            {
                continueUrl = "~/";           //如果未设置，则导航到主页面
            }
            //实例化购物车对象
            MyShoppingCart usersShoppingCart = new MyShoppingCart();
            //得到购物车Id值
            String cartId = usersShoppingCart.GetShoppingCartId();
            //迁移购物车
            usersShoppingCart.MigrateCart(cartId, RegisterUser.UserName);
            Response.Redirect(continueUrl);   //重定向页面
        }

    }
}
