﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Diagnostics;

namespace TailspinSpyworks
{
    public partial class AddToCart : System.Web.UI.Page
    {
protected void Page_Load(object sender, EventArgs e)
{
    string rawId = Request.QueryString["ProductID"];    //获取产品Id
    int productId;
    if (!String.IsNullOrEmpty(rawId) && Int32.TryParse(rawId, out productId))
    {
        MyShoppingCart usersShoppingCart = new MyShoppingCart();//实例化购物车对象
        String cartId = usersShoppingCart.GetShoppingCartId();//生成一个新的购物车Id值
        usersShoppingCart.AddItem(cartId, productId, 1);     //添加产品到购物车清单
    }
    else                                                    //如果产品Id不存在显示异常
    {
        Debug.Fail("错误：无ProductId不能使用AddToCart.aspx添加购物到购物车.");
        throw new Exception("错误：无ProductId不能使用AddToCart.aspx添加购物到购物车.");
    }
    Response.Redirect("MyShoppingCart.aspx");             //重定向到购物车页面
}
    }
}