﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using TailspinSpyworks.Data_Access;
using System.Diagnostics;
//www.51aspx.com
namespace TailspinSpyworks.Controls
{
    public partial class AlsoPurchased : System.Web.UI.UserControl
    {
        private int _ProductId;                          //定义产品ID字段
        public int ProductId                             //定义产品ID属性
        { 
            get 
            {
                _ProductId = Convert.ToInt32(Session["ProductId"]); //从Session取出
                return _ProductId; 
            }
            set 
            { 
               Session["ProductId"] = Convert.ToInt32(value);      //保存到Session
               _ProductId = Convert.ToInt32(value);                //将传入的值转换为整型值
            } 
        }

        //------------------------------------------------------------------------------------------------------------------------------------------+
        protected void Page_PreRender(object sender, EventArgs e)
        {
            if (ProductId < 1)   //只有在设置了ProductId时才能显示产品清单
            {
                Debug.Fail("错误 : 在没有设置产品Id时不能获得购买相关商品列表");
                throw new Exception("错误：如果未设置ProductId不能显示控件内容");
            }     
            int ProductCount = 0;                 //初始产品数为0
            using (CommerceEntities db = new CommerceEntities())
            {
                try
                {   //使用ADO.NET Entity Framework调用存储过程查询产品
                    var v = db.SelectPurchasedWithProducts(ProductId);
                    ProductCount = v.Count();    //返回查询结果
                }
                catch (Exception exp)
                {
                    throw new Exception("错误：不能获取己购买相关的产品清单 - " 
                        + exp.Message.ToString(), exp);
                }
            }
            if (ProductCount > 0)                //如果找到相关产品清单
            {
                WriteAlsoPurchased(ProductId);  // 绑定到Repeater控件            
            }
            else
            {
                 WritePopularItems();            //否则绑定流行的产品列表
            }
        }

        //------------------------------------------------------------------------------------------------------------------------------------------+
        private void WriteAlsoPurchased(int currentProduct)
        {
            using (CommerceEntities db = new CommerceEntities())  //实体化ObjectContext
            {
                try
                {   //调用存储过程，返回复杂类型数据
                    var v = db.SelectPurchasedWithProducts(currentProduct);
                    RepeaterItemsList.DataSource = v;            //绑定到Repeater控件
                    RepeaterItemsList.DataBind();                //设置绑定，显示数据
                }
                catch (Exception exp)
                {  //显示异常信息
                    throw new Exception("错误：不能写入其它购买列表- " 
                        + exp.Message.ToString(), exp);
                }
            }
        }

        //------------------------------------------------------------------------------------------------------------------------------------------+
private void WritePopularItems()
{   //实例化ObjectContext实例
    using (CommerceEntities db = new CommerceEntities())  
    {
        try
        {   //定义一个分组查询
            var query = (from ProductOrders in db.OrderDetails
                            join SelectedProducts in db.Products on 
                            ProductOrders.ProductID equals SelectedProducts.ProductID
                            group ProductOrders by new
                            {   //按产品Id和ModelName分组
                                ProductId = SelectedProducts.ProductID,
                                ModelName = SelectedProducts.ModelName
                            } into grp
                            select new                           //返回的字段投影
                            {
                                ModelName = grp.Key.ModelName,
                                ProductId = grp.Key.ProductId,
                                Quantity = grp.Sum(o => o.Quantity)
                            } into orderdgrp
                            where orderdgrp.Quantity > 0          //指定数量大于0
                            orderby orderdgrp.Quantity descending //降序排序，购买最多的产品在前面
                            select orderdgrp).Take(5);            //选择前5条记录
            LabelTitle.Text = "你或许感兴趣的其它商品: ";
            //绑定到查询结果
            RepeaterItemsList.DataSource = query;
            RepeaterItemsList.DataBind();
        }
        catch (Exception exp)
        {   //显示异常消息
            throw new Exception("错误：不能加载流行产品列表 - " + 
                exp.Message.ToString(), exp);
        }
    }
}
    }
}