﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Styles/Site.Master" AutoEventWireup="true" CodeBehind="MyShoppingCart.aspx.cs" Inherits="TailspinSpyworks.MyShoppingCart" %>
<asp:Content ID="Content1" ContentPlaceHolderID="HeadContent" runat="server">
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="MainContent" runat="server">
        <div id="ShoppingCartTitle" runat="server" class="ContentHead">购物车</div>
        <asp:GridView ID="MyList" runat="server" AutoGenerateColumns="False" ShowFooter="True" GridLines="Vertical" CellPadding="4"
                      DataSourceID="EDS_Cart"  DataKeyNames="ProductID,UnitCost,Quantity" 
                      CssClass="CartListItem">              
            <AlternatingRowStyle CssClass="CartListItemAlt" />
            <Columns>
                <asp:BoundField DataField="ProductID" HeaderText="产品编号" ReadOnly="True" SortExpression="ProductID"  />
                <asp:BoundField DataField="ModelNumber" HeaderText="产品编码" SortExpression="ModelNumber" />
                <asp:BoundField DataField="ModelName" HeaderText="产品名称" SortExpression="ModelName"  />
                <asp:BoundField DataField="UnitCost" HeaderText="单价" ReadOnly="True" SortExpression="UnitCost" DataFormatString="{0:c}" />         
                <asp:TemplateField> 
                    <HeaderTemplate>数量</HeaderTemplate>
                    <ItemTemplate>
                        <asp:TextBox ID="PurchaseQuantity" Width="40" runat="server" Text='<%# Bind("Quantity") %>'></asp:TextBox> 
                    </ItemTemplate>
                </asp:TemplateField>           

                <asp:TemplateField> 
                    <HeaderTemplate>合计</HeaderTemplate>
                    <ItemTemplate>
                          <%# (Convert.ToDouble(Eval("Quantity")) *  Convert.ToDouble(Eval("UnitCost")))%>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField> 
                    <HeaderTemplate>移除项</HeaderTemplate>
                    <ItemTemplate>
                            <center>
                                <asp:CheckBox id="Remove" runat="server" />
                            </center>
                    </ItemTemplate>
                </asp:TemplateField>
            </Columns>
            <FooterStyle CssClass="CartListFooter"/>
            <HeaderStyle  CssClass="CartListHead" />
        </asp:GridView>
        <div style="float: right">
          <strong>
              <asp:Label ID="LabelTotalText" runat="server" Text="订单总计 : "></asp:Label><asp:Label CssClass="NormalBold" id="lblTotal" runat="server" EnableViewState="false"></asp:Label></strong> 
        </div>
        <br />
        <asp:imagebutton id="UpdateBtn" runat="server" ImageURL="Styles/Images/update_cart.gif" onclick="UpdateBtn_Click"></asp:imagebutton>
        <asp:imagebutton id="CheckoutBtn" runat="server" 
            ImageURL="Styles/Images/final_checkout.gif" PostBackUrl="~/CheckOut.aspx" 
            onclick="CheckoutBtn_Click"></asp:imagebutton>
    <asp:EntityDataSource ID="EDS_Cart" runat="server" 
                          ConnectionString="name=CommerceEntities" 
                          DefaultContainerName="CommerceEntities" EnableFlattening="False" 
                          EnableUpdate="True" EntitySetName="ViewCarts" 
                          AutoGenerateWhereClause="True" EntityTypeFilter="" Select="" Where="">
        <WhereParameters>
            <asp:SessionParameter Name="CartID" DefaultValue="0" SessionField="TailSpinSpyWorks_CartID" />
        </WhereParameters>
    </asp:EntityDataSource>
</asp:Content>
