﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Styles/Site.Master" AutoEventWireup="true" CodeBehind="ProductsList.aspx.cs" Inherits="TailspinSpyworks.ProductsList" %>
<asp:Content ID="Content1" ContentPlaceHolderID="HeadContent" runat="server">
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="MainContent" runat="server">
<!--产品列表ListView控件的定义代码-->
<asp:ListView ID="ListView_Products" runat="server" DataKeyNames="ProductID"  
DataSourceID="EDS_ProductsByCategory" GroupItemCount="2">
    <EmptyDataTemplate><table runat="server"><tr><td>没有找到数据.
    </td></tr></table></EmptyDataTemplate>
    <EmptyItemTemplate><td runat="server" /></EmptyItemTemplate>
    <GroupTemplate><tr ID="itemPlaceholderContainer" runat="server">
    <td ID="itemPlaceholder" runat="server"></td></tr></GroupTemplate>
    <ItemTemplate>
        <td runat="server">
            <table border="0" width="300">
                <tr>
                    <td style="width: 25px;">&nbsp</td>
                    <td style="vertical-align: middle; text-align: right;">
                        <a href='ProductDetails.aspx?productID=<%# Eval("ProductID") %>'>
                            <!--显示产品缩略图-->
                            <image src='Catalog/Images/Thumbs/<%# Eval("ProductImage") %>' 
                            width="100" height="75" border="0">
                        </a>&nbsp;&nbsp;
                    </td>
                        <td style="width: 250px; vertical-align: middle;">
                        <a href='ProductDetails.aspx?productID=<%# Eval("ProductID") %>'>
                        <span class="ProductListHead"><%# Eval("ModelName") %></span><br></a>
                        <!--为价格指定显示格式-->
                        <span class="ProductListItem"><b>指定价格: </b><%# Eval("UnitCost", "{0:c}")%>
                        </span><br>
                        <!--指定添加到购物车按钮-->
                        <a href='AddToCart.aspx?productID=<%# Eval("ProductID") %>'>
                        <span class="ProductListItem"><b>添加到购物车<b></font></span></a>
                    </td>
                </tr>
                </table>
        </td>
    </ItemTemplate>

    <LayoutTemplate>

        <table runat="server">
            <tr runat="server">
                <td runat="server">
                    <!--指定分组容器-->
                    <table ID="groupPlaceholderContainer" runat="server">
                        <tr ID="groupPlaceholder" runat="server"></tr>
                    </table>
                </td>
            </tr>
                <!--服务器端表格行-->
            <tr runat="server"><td runat="server"></td></tr>
        </table>
    </LayoutTemplate>
</asp:ListView>
    <!--定义产品列表数据源-->
    <asp:EntityDataSource ID="EDS_ProductsByCategory" runat="server"  
                          EnableFlattening="False" AutoGenerateWhereClause="True"
                          ConnectionString="name=CommerceEntities"  
                          DefaultContainerName="CommerceEntities" EntitySetName="Products">
                          <WhereParameters>
                                <asp:QueryStringParameter Name="CategoryID" 
                                QueryStringField="CategoryId" Type="Int32" />
                          </WhereParameters>
    </asp:EntityDataSource>
</asp:Content>
