﻿define('conditionStore', [], function () {
    var conditinoStore = {
        /*联系人模块查询条件*/
        Contacts: {
            keyCol: 'key',
            hasCondition: false,
            keyDynamic:false,
            customerId: {
                label: '客户', items: [{
                    label: '',
                    val: '',
                    curr: false
                }]
            },
            roles: {
                label: '角色：', items: [{
                    label: '不限',
                    val: '',
                    curr: true
                }], dyQuery: true, name: 'ContactRoleId', operator: 'Eq', binary: 'and'
            },
            birthday: {
                label: '生日：', items: [{
                    label: '不限',
                    val: '',
                    curr: true
                }, {
                    label: '本月生日',
                    val: '0',
                    curr: false
                }, {
                    label: '下月生日',
                    val: '1',
                    curr: false
                }]
            },
            birthdayDate:{
                label:'生日',items:[{
                    label: '',
                    val: '',
                    curr:false
                }]
            },
            letter: {
                label: '首字母', items: [{
                    label: '',
                    val: '',
                    curr: false
                }]
            },
            firstName: {
                label: '姓', items: [{
                    label: '',
                    val: '',
                    curr: false
                }]
            },
            sex: {
                label: '性别：', items: [{
                    label: '不限',
                    val: '',
                    curr: true
                }, {
                    label: '男',
                    val: '0',
                    curr: false
                }, {
                    label: '女',
                    val: '1',
                    curr: false
                }
                ], dyQuery: true, name: 'Sex', operator: 'Eq', binary: 'and'
            },
            currConditions: { roles: '', birthday: '', sex: '', customerId: '',birthdayDate:'',letter:'',firstName:'' }
        },
        //竞争对手模块查询条件
        Competitor: {
            category: {
                label: '竞争对手分类：', items: [{
                    label: '不限',
                    val: '',
                    curr: true
                }], dyQuery: true, name: 'CategoryId', operator: 'Eq', binary: 'and'
            },
            marketPos: {
                label: '市场地位：', items: [{
                    label: '不限',
                    val: '',
                    curr: true
                }], dyQuery: true, name: 'StageId', operator: 'Eq', binary: 'and'
            },
            threaten: {
                label: '威胁值评估：', items: [{
                    label: '不限',
                    val: '',
                    curr: true
                }, {
                    label: '威胁值：1 颗星',
                    val: 1,
                    curr: false
                }, {
                    label: '威胁值：2 颗星',
                    val: 2,
                    curr: false
                }, {
                    label: '威胁值：3 颗星',
                    val: 3,
                    curr: false
                }, {
                    label: '威胁值：4 颗星',
                    val: 4,
                    curr: false
                }, {
                    label: '威胁值：5 颗星',
                    val: 5,
                    curr: false
                }], dyQuery: true, name: 'Threaten', operator: 'Eq', binary: 'and'
            },
            currConditions: { category: '', marketPos: '', threaten: '' },
            hasCondition: false,
            removeThreaten: function () {
                var item = this.$vmodel
                var vm = vm[vm.$itemName], data
                vm.threaten.items.forEach(function (t) {
                    t.curr = !t.label
                })
                vm.currConditions.threaten = ''
                data = vm.createDyQuery()
                vm.loadData(data)
                avalon.vmodels.threatenRaty.val = 0
            }
        },
        //客户模块查询条件
        Customer: {
            followUp: {
                label: '回访：', items: [{
                    label: '不限',
                    val: '',
                    curr: true
                }, {
                    label: '15天未回访',
                    val: 15,
                    curr: false
                },
                    {
                        label: '30天未回访',
                        val: 30,
                        curr: false
                    },
                    {
                        label: '60天未回访',
                        val: 60,
                        curr: false
                    },
                    {
                        label: '90天未回访',
                        val: 90,
                        curr: false
                    }]
            },
            stages: {
                label: '阶段：', items: [{
                    label: '不限',
                    val: '',
                    curr: true
                }], dyQuery: true, name: 'StageId', operator: 'Eq', binary: 'and'
            },
            types: {
                label: '客户类型：', items: [{
                    label: '不限',
                    val: '',
                    curr: true
                },
                    {
                        label: '企业',
                        val: '0',
                        curr: false
                    },
                    {
                        label: '事业单位',
                        val: 2,
                        curr: false
                    },
                    {
                        label: '政府机构',
                        val: 3,
                        curr: false
                    },
                    {
                        label: '社会团体',
                        val: 4,
                        curr: false
                    },
                    {
                        label: '个人',
                        val: 1,
                        curr: false
                    }
                ], dyQuery: true, name: 'Type', operator: 'Eq', binary: 'and'
            },
            subCategory: {
                label: '客户分类：', showMore: false, length: 0, items: [{
                    label: '不限',
                    val: '',
                    curr: true
                }]
            },
            businessType: {
                label: '业务分类：', showMore: false, length: 0, items: [{
                    label: '不限',
                    val: '',
                    curr: true
                }]
            },
            serviceLabel: {
                label: '服务标签：', showMore: false, length: 0, items: [{
                    label: '不限',
                    val: '',
                    curr: true
                }]
            },
            memberGrade: {
                label: '会员级别：', showMore: false, length: 0, items: [{
                    label: '不限',
                    val: '',
                    curr: true
                }]
            },
            cState: {
                label: '客户状态：', items: [{
                    label: '不限',
                    val: '',
                    curr: true
                }, {
                    label: '正式客户',
                    val: '1',
                    curr: false
                }, {
                    label: '潜在客户',
                    val: '0',
                    curr: false
                }
                ]
            },
            supplierLevel: {
                label: '供应商级别：', items: [{
                    label: '不限',
                    val: '',
                    curr: true
                }]
            },
            channelArea:{
                label: '代理区域：', items: [{
                    label: '不限',
                    val: '',
                    curr: true
                }]
            },
            documentary: {
                label: '跟单：', items: [
                    {
                        label: '不限',
                        val: '',
                        curr: true
                    },
                    {
                        label: '15天未跟单',
                        val: 15,
                        curr: false
                    },
                    {
                        label: '30天未跟单',
                        val: 30,
                        curr: false
                    },
                    {
                        label: '60天未跟单',
                        val: 60,
                        curr: false
                    },
                    {
                        label: '90天未跟单',
                        val: 90,
                        curr: false
                    }
                ]
            },
            share: {
                label: '共享：', items: [
                    {
                        label: '不限',
                        val: '',
                        curr: true
                    },
                    {
                        label: '我的共享',
                        val: 1,
                        curr: false
                    },
                    {
                        label: '共享给我',
                        val: 2,
                        curr: false
                    }
                ]
            },
            nature: {
                label: '客户性质', items: [
                     {
                         label: '不限',
                         val: '',
                         curr: true
                     },
                      {
                          label: '新客户',
                          val: '1',
                          curr: false,
                          title: '未签单的客户'
                      },
                       {
                           label: '老客户',
                           val: '2',
                           curr: false,
                           title: '已签单的客户'
                       },
                ]
            },
            orderDate: {
                label: '排序方式：', items: [
                    {
                        label: '不限',
                        val: '',
                        curr: true
                    },
                    {
                        label: '最后修改',
                        val: 1,
                        curr: false
                    },
                    {
                        label: '创建时间',
                        val: 2,
                        curr: false
                    },
                    {
                        label: '最后回访',
                        val: 3,
                        curr: false
                    },
                    {
                        label: '最后跟单',
                        val: 4,
                        curr: false
                    },
                    {
                        label: '最后签约',
                        val: 5,
                        curr: false
                    }
                ]
            },
            belongTo: {
                label: '归属：', items: [
                    {
                        label: '我的客户',
                        val: 1,
                        curr: true
                    },
                    {
                        label: '指定部门/职位/员工',
                        val: 2,
                        curr: false
                    }
                ]
            },
            centerExpertTime: {
                label: '进入专管时间：', items: [{
                    label: '不限',
                    val: '',
                    curr: true
                }, {
                    label: '今天',
                    val: '0',
                    curr: false
                },
                {
                    label: '昨天',
                    val: '1',
                    curr: false
                },
                {
                    label: '7天内',
                    val: '7',
                    curr: false
                },
                {
                    label: '30天内',
                    val: '30',
                    curr: false
                }]
            },
            addTime:{
                label: '录入时间', items: [{label: '不限',val: '',curr: true},{label: '时间段',val: 'c',curr: false}]
            },
            addTime1: {
                label: '录入时间1'
            },
            addTime2: {
                label: '录入时间2'
            },
            currConditions: {
                nature: '', areas: '', centerExpertTime: '', followUp: '', types: '', documentary: '', share: '',
                orderDate: '', belongTo: '', stages: '', onlyMy: '', belongCustom: '', subCategory: '', businessType: "",
                serviceLabel: "", memberGrade: "", cState: "", supplierLevel: "", channelArea: "",addTime:'',addTime1:'',addTime2:'',
            },
            hasCondition: false
        },
        International: {
            enterTime: {
                label: '进入公海时间：', items: [{
                    label: '不限',
                    val: '',
                    curr: true
                }, {
                    label: '今天',
                    val: '0',
                    curr: false
                },
                {
                    label: '昨天',
                    val: '-1',
                    curr: false
                },
                {
                    label: '7天内',
                    val: '7',
                    curr: false
                },
                {
                    label: '30天内',
                    val: '30',
                    curr: false
                }]
            },
            currConditions: { enterTime: '' },
            hasCondition: false
        },
        //广告素材
        AdvertisingMaterials: {
            keyCol: 'Name',
            contentFormat: {
                label: "内容格式：", items: [{
                    label: '不限',
                    val: '',
                    curr: true
                }]
            },
            materialType: {
                label: "素材类型：", items: [{
                    label: '不限',
                    val: '',
                    curr: true
                }]
            },
            mediaType: {
                label: "适用媒体：", items: [{
                    label: '不限',
                    val: '',
                    curr: true
                }]
            },
            holidays: {
                label: "适用节庆：", items: [{
                    label: '不限',
                    val: '',
                    curr: true
                }]
            },
            currConditions: { contentFormat: '', materialType: '', mediaType: '', holidays: '' },
            hasCondition: false
        },
        //广告投放
        AdvertisingList: {
            keyCol: 'Theme',
            mediaType: {
                label: "媒体分类：", items: [{
                    label: '不限',
                    val: '',
                    curr: true
                }]
            },
            currConditions: { mediaType: '' },
            hasCondition: false
        },
        //书籍管理
        Books: {
            keyCol: 'name',
            totalMoney: {
                label: "购置金额：", items: [{
                    label: '不限',
                    val: '',
                    curr: true
                }, {
                    label: '<10元',
                    val: ',9.99',
                    curr: false
                }, {
                    label: '10-50元',
                    val: '10,50',
                    curr: false
                }, {
                    label: '50-100元',
                    val: '50,100',
                    curr: false
                }, {
                    label: '>100元 ',
                    val: '100.01',
                    curr: false
                }
                ]
            },
            buyCount: {
                label: "购置数量：", items: [{
                    label: '不限',
                    val: '',
                    curr: true
                }, {
                    label: '<3本',
                    val: ',2',
                    curr: false
                }, {
                    label: '3-10本',
                    val: '3,10',
                    curr: false
                }, {
                    label: '10-30本',
                    val: '10,30',
                    curr: false
                }, {
                    label: '>30本',
                    val: '31',
                    curr: false
                }]
            },
            buyTime: {
                label: "购置时间：", items: [{
                    label: '不限',
                    val: '',
                    curr: true
                }, {
                    label: '<30天',
                    val: ',1',
                    curr: false
                }, {
                    label: '1-3个月',
                    val: '1,3',
                    curr: false
                }, {
                    label: '3-6个月',
                    val: '3,6',
                    curr: false
                }, {
                    label: '>6-12个月',
                    val: '6,12',
                    curr: false
                }, {
                    label: '>12个月',
                    val: '12,',
                    curr: false
                }]
            },
            borrowCount: {
                label: "被借次数：", items: [{
                    label: '不限',
                    val: '',
                    curr: true
                }, {
                    label: '<50次',
                    val: ',49',
                    curr: false
                }, {
                    label: '50-100次',
                    val: '50,100',
                    curr: false
                }, {
                    label: '100-300次',
                    val: '100,300',
                    curr: false
                }, {
                    label: '>300次',
                    val: '301',
                    curr: false
                }]
            },
            typeId: {
                label: '分类', items: []
            },
            currConditions: { totalMoney: '', buyCount: '', buyTime: '', borrowCount: '', typeId: '' },
            hasCondition: false
        },
        //借阅管理
        BooksBorrow: {
            keyCol: 'name',
            borrowCount: {
                label: "借阅册数：", items: [{
                    label: '不限',
                    val: '',
                    curr: true
                }, {
                    label: '<3本',
                    val: ',2',
                    curr: false
                }, {
                    label: '3-10本',
                    val: '3,10',
                    curr: false
                }, {
                    label: '10-30本',
                    val: '10,30',
                    curr: false
                }, {
                    label: '>30本',
                    val: '31',
                    curr: false
                }]
            },
            borrowMoney: {
                label: "借阅金额：", items: [{
                    label: '不限',
                    val: '',
                    curr: true
                }, {
                    label: '<10元',
                    val: ',9.99',
                    curr: false
                }, {
                    label: '10-50元',
                    val: '10,50',
                    curr: false
                }, {
                    label: '50-100元',
                    val: '50,100',
                    curr: false
                }, {
                    label: '>100元 ',
                    val: '100.01',
                    curr: false
                }
                ]
            },

            returnTime: {
                label: "归还提醒：", items: [{
                    label: '不限',
                    val: '',
                    curr: true
                }, {
                    label: '7天后到期',
                    val: '-7,0',
                    curr: false
                }, {
                    label: '今天到期',
                    val: '0,0',
                    curr: false
                }, {
                    label: '已过期',
                    val: '1,',
                    curr: false
                }, {
                    label: '过期>7天',
                    val: '7,',
                    curr: false
                }, {
                    label: '过期>15天',
                    val: '15,',
                    curr: false
                }]
            },
            state: {
                label: "借单状态：", items: [{
                    label: '不限',
                    val: '',
                    curr: true
                }, {
                    label: '未还',
                    val: '0',
                    curr: false
                }, {
                    label: '已还清',
                    val: '2',
                    curr: false
                }, {
                    label: '已还部分',
                    val: '1',
                    curr: false
                }, {
                    label: '坏单',
                    val: '3',
                    curr: false
                }]
            },
            currConditions: { borrowCount: '', borrowMoney: '', returnTime: '', state: '' },
            hasCondition: false
        },
        //归还管理
        BooksReturn: {
            keyCol: 'name',
            returnCount: {
                label: "归还册数：", items: [{
                    label: '不限',
                    val: '',
                    curr: true
                }, {
                    label: '<3本',
                    val: ',2',
                    curr: false
                }, {
                    label: '3-10本',
                    val: '3,10',
                    curr: false
                }, {
                    label: '10-30本',
                    val: '10,30',
                    curr: false
                }, {
                    label: '>30本',
                    val: '31',
                    curr: false
                }]
            },
            returnMoney: {
                label: "归还金额：", items: [{
                    label: '不限',
                    val: '',
                    curr: true
                }, {
                    label: '<10元',
                    val: ',9.99',
                    curr: false
                }, {
                    label: '10-50元',
                    val: '10,50',
                    curr: false
                }, {
                    label: '50-100元',
                    val: '50,100',
                    curr: false
                }, {
                    label: '>100元 ',
                    val: '100.01',
                    curr: false
                }
                ]
            },
            outOfDay: {
                label: "归还时间：", items: [{
                    label: '不限',
                    val: '',
                    curr: true
                }, {
                    label: '提前归还',
                    val: ',0',
                    curr: false
                }, {
                    label: '准时归还',
                    val: '0,0',
                    curr: false
                }, {
                    label: '超期归还',
                    val: ',1',
                    curr: false
                }, {
                    label: '超期>7天',
                    val: '7,',
                    curr: false
                }, {
                    label: '超期>15天',
                    val: '15,',
                    curr: false
                }]
            },
            currConditions: { returnCount: '', returnMoney: '', returnTime: '' },
            hasCondition: false
        }
    }
    return {
        create: function (id) {
            return avalon.mix({
                conditionChanged: function (item, condistions) {
                    avalon.log(item.label)
                },
                createDyQuery: function () {
                    //[{\"Name\":\"ChildNum\",\"Value\":8,\"Operator\":\"LessOrEq\"}"];
                    var pvm = this,
                    $model = pvm.currConditions.$model,
                    prop, propVal, condition, val
                    dyQuery = [],
                    ret = {}
                    for (prop in $model) {
                        propVal = pvm.currConditions[prop]
                        if (propVal) {
                            condition = pvm[prop]
                            if (!condition) {
                                avalon.log('没有找到：' + prop + ' 的配置条件，请检查条件vm上是否存在对应的项')
                                continue
                            }
                            if (condition.items) {
                                condition.items.forEach(function (c) {
                                    if (c.label === propVal) {
                                        val = c.val
                                        return false
                                    }
                                })
                            } else {
                                val = propVal;
                            }
                            if (condition.dyQuery) {
                                dyQuery.push({
                                    'Name': condition.name,
                                    'Operator': condition.operator,
                                    'Value': val,
                                    'key': prop,
                                    'label': propVal
                                })
                            } else {
                                ret[prop] = val || condition
                            }
                        }
                    }
                    if (pvm.key) {
                        if (pvm.keyDynamic) {
                            dyQuery.push({
                                'Name': pvm.keyCol,
                                'Value': pvm.key.trim(),
                                'Operator': 'Like'
                            })
                        } else {
                            ret[pvm.keyCol] = pvm.key
                        }
                    }

                    ret['__dynamicQuery'] = JSON.stringify(dyQuery)

                    //avalon.log(JSON.stringify(ret))
                    return ret
                    
                },
                setedCondition: function (group) {
                    //avalon.log('seted group : ' + group)
                },
                setCondition: function (index, list, group) {
                    var curr = this.$vmodels[0],
                    pvm = this.$vmodels[1],
                    item = curr[curr.$itemName],
                    conditions
                    list = list || [];
                    list.forEach(function (item) {
                        item.curr = false
                    })
                    item.curr = true
                    pvm.hasCondition = true
                    pvm.currConditions[group] = ''
                    pvm.currConditions[group] = item.val ? item.label : ''
                    pvm.setedCondition(group);
                    pvm.checkCondition()
                    conditions = pvm.createDyQuery()
                    pvm.conditionChanged.call(this, item, conditions, group)
                },
                addCondition: function (name,val,disableChange) {
                    var pvm = this, conItem = pvm[name], curItem, curVal;
                    list = conItem.items;
                    if (list) {
                        list.forEach(function (item) {
                            if (item.val === val) {
                                item.curr = true;
                                curItem = item;
                                curVal = item.val ? item.label : "";
                            } else {
                                item.curr = false;
                            }
                        })
                    } else {
                        curVal = val;
                    }
                    pvm.hasCondition = true
                    pvm.currConditions[name] = ''
                    pvm.currConditions[name] = curVal == null ? "" : curVal;
                    pvm.setedCondition(name);
                    pvm.checkCondition()
                    if (disableChange) return;
                    var conditions = pvm.createDyQuery()
                    pvm.conditionChanged.call(curItem, curItem, conditions, name);
                },
                clearSearchItem: function () {
                    var vm = this.$vmodel
                    vm.key = ''
                    vm.clearAllItem.call(this)
                },
                clearAllItem: function () {
                    var vm = this.$vmodel,
                    currConditions = vm.currConditions.$model,
                    condition, items
                    vm.hasCondition = false
                    for (var item in currConditions) {
                        vm.currConditions[item] = ''
                        condition = vm[item]
                        if (!condition) continue
                        items = condition.items
                        if (!items || !items.length) continue
                        items.forEach(function (c, i) {
                            c.curr = i === 0
                            //avalon.log('label : ' +c.label + ' curr : ' +c.curr)
                        })
                    }
                    vm.key = ''
                    conditions = vm.createDyQuery()
                    if (vm.onClearAll) vm.onClearAll.call(this, conditions);
                    vm.conditionChanged(null, conditions)
                },
                checkCondition: function () {
                    var hasCondition = false, pvm = this
                    for (var c in pvm.currConditions.$model) {
                        hasCondition = pvm.currConditions[c] ? true : false
                        if (hasCondition) {
                            avalon.log(c + ' : ' + pvm.currConditions[c])
                            break
                        }
                    }
                    pvm.hasCondition = hasCondition
                },
                removedItem: function (key) {
                    avalon.log('removed key : ' + key)
                },
                removeItem: function () {
                    var vm = this.$vmodel,
                    pvm = this.$vmodels[1]
                    pvm.currConditions[vm.$key] = '',
                    items = pvm[vm.$key] ? pvm[vm.$key].items : ''
                    if (items) {
                        items.forEach(function (c, i) {
                            c.curr = i === 0
                        })
                    }
                    pvm.removedItem(vm.$key)
                    pvm.checkCondition()
                    conditions = pvm.createDyQuery()
                    pvm.conditionChanged.call(this, null, conditions)
                },
                toEnter: function (e) {
                    if (e.keyCode === 13)
                        this.$vmodel.toSearch.call(this)
                },
                execSearch: function (vm) {
                    var size
                    if (vm.key) {
                        vm.searchHistory.unshift(vm.key)
                        size = vm.searchHistory.size()
                        while (size > 5) {
                            size--
                            vm.searchHistory.pop()
                        }
                    }
                    //avalon.log('curr key : ' + vm.key + ' searchHistory len : ' + vm.searchHistory.size())
                    conditions = vm.createDyQuery()
                    vm.conditionChanged.call(this, null, conditions)
                },
                toSearch: function () {
                    var vm = this.$vmodel
                    vm.execSearch(vm)
                },
                findByHistoryKey: function () {
                    var vm = this.$vmodel,
                    pvm = this.$vmodels[1],
                    item = vm[vm.$itemName],
                    conditions
                    if (item) {
                        pvm.key = item
                        conditions = pvm.createDyQuery()
                        pvm.conditionChanged.call(this, null, conditions)
                    }
                },
                key: '',
                keyCol: '',
                keyDynamic: true,
                searchHistory: []
            }, conditinoStore[id] ? conditinoStore[id] : {});
        }
    }
})