﻿/*avalon的显示filter*/
(function () {
    //客户类型
    var customerType = [{ label: '企业', val: '0' }
                           , { label: '个人', val: '1' }
                           , { label: '事业单位', val: '2' }
                           , { label: '政府机构', val: '3' }
                           , { label: '社会团体', val: '4' }
    ]
    avalon.filters.customerType = function (val) {
        var type = ''
        customerType.forEach(function (c) {
            if (c.val == val) {
                type = c.label
                return false
            }
        })
        return type
    }
    avalon.filters.customerState = function (val) {
        if (val == 1) return "正式";
        return "潜在";
    }
    avalon.filters.sex = function (val) {
        if (val == 1) return "女";
        return "男";
    }
    //显示发送手机短信图标，需要VM实现sendSms方法，可以直接vm.sendSms=CBCRM.sendSms
    avalon.filters.mobileFormat = function (val) {
        if (!val) return val;
        var mreg = gRegExp.mobile, ismobile = mreg.test(val)
        var a = [], s = []
        if (ismobile) {
            s[0] = val.substring(0, 3);
            s[1] = val.substring(3, 7);
            s[2] = val.substring(7, 11);
        } else if (val.indexOf("-") != -1) {
            var arr = val.split("-");
            s[0] = arr[0] + "-";
            arr.splice(0, 1);
            val = arr.join("-");
            s[1] = val.substring(0, 4);
            s[2] = val.substring(4, val.length);
        } else {
            s[0] = val.substring(0, 4);
            s[1] = val.substring(4, 8);
            s[2] = val.substring(8, val.length);
        }
        a.push("<span style='color:#FF0000;'>" + s[0] + "</span>");
        a.push("<span style='color:#00aa00;'>" + s[1] + "</span>");
        a.push("<span style='color:#0000FF;'>" + s[2] + "</span>");
        if (ismobile) a.push("<a href='javascript:void(0);' ms-click=\"sendSms('" + val + "')\" class='sysphonelink' title='发送手机短信'></a>")
        var html = a.join("");
        return html;
    }
    //大数字显示
    avalon.filters.bigNumber = function (val) {
        if (val == "" || isNaN(val)) return val
        var v =Math.abs(parseFloat(val, 10));
        if (v > 100000000) return (v / 100000000).toFixed(2).replace(".00", "") + "亿"
        if (v > 100000) return (v / 10000).toFixed(2).replace(".00", "") + "万"
        v = v.toFixed(2).replace(".00", "");
        if (val < 0) v = "-" + v;
        return v;
    }
    //字符串截取
    avalon.filters.truncate2 = function (val, start, end, text) {
        if (val == null) return val;
        if (arguments.length == 3) {
            text = end;
            end = start;
            start = 0;
        } else if (arguments.length == 2) {
            text = "";
            end = start;
            start = 0;
        }
        var str = val.toString();
        str = str.substring(start);
        if (str.length <= end) return str;
        str = str.substring(0, end) + text;
        return str;
    }
    //时间间隔
    avalon.filters.dayspan = function (v1, v2) {
        if (!v1) return v1;
        var d1 = new Date(v1), d2;
        if (!v2) d2 = new Date();
        else d2 = new Date(v2);
        var sp = parseInt((d2 - d1) / (1000 * 3600 * 24), 10);
        return v1 + " 至今" + sp + "天"
    }
    //超连接显示
    avalon.filters.link = function (val, text, title) {
        if (!val || val == "http://" || val == "http") return "";
        if (!text) text = val;
        var pre = "http://";
        if (val.indexOf(pre) != 0) val = pre + val;
        if (!title) title = val
        var link = "<a href='" + val + "' target='_blank' title='" + title + "'>" + text + "</a>";
        return link;
    }
    //环比前缀
    avalon.filters.chainChange = function (val) {
        if (val == 0) return "不变";
        return val > 0 ? "上升" : "下降";
    }
    //取路径中的文件名
    avalon.filters.getFileName = function (val) {
        if (!val) return val;
        var a = val.split('/');
        return a[a.length - 1];
    }
    //付款状态
    avalon.filters.payStateIcon = function (val,val2) {
        var c,t;
        if (!val) {
            c = "stNoPay";
            t = "未付款";
        } else if (val < val2) {
            c = "stNo";
            t = "已付" + val + "元";
        } else if (val >= val2) {
            c = "stCom";
            t = "已付清";
        }
        return '<span class="' + c + '" title="' + t + '"></span>';
    }
    //客户归属来源
    avalon.filters.customerOwnerFrom = function (val) {
        if (!val) return "未知";
        var froms = { "Create": "手工录入", "Pick": "领取公海", "Assign": "分配归属", "Import": "客户导入" };
        var r = froms[val] || val;
        return r;
    }
    //格式化来自textArea的文本
    avalon.filters.areaText = function (val) {
        if (!val) return val;
        var r = val.replace(/\n/g, "<br />");
        return r;
    }
    //业务提成说明
    avalon.filters.royaltyDsc = function (item) {
        if (!item) return "";
        var rPrice = item.RoyaltyPrice || 0, rValue = item.RoyaltyValue || 0;
        rPrice = parseFloat(rPrice, 10);
        rValue = parseFloat(rValue, 10);
        var r = "";
        if (item.RoyaltyType == 1) {
            //按数量
            r = formatStr("默认按每件产品{0}元计算提成", rValue, num);
        } else {
            //按百分比
            if (item.RoyaltyCompute == 1) {
                //按销售金额百分比
                r = formatStr("默认按该产品提成基准价{0}元计算所得销售金额的{1}%计算提成", rPrice, rValue);
            } else {
                //按毛利百分比
                r = formatStr("默认按该产品提成基准价{0}元计算所得销售毛利的{1}%计算提成", rPrice, rValue);
            }
        }
        return r;
    }
    function formatStr(str){
        for (var i = 1, l = arguments.length; i < l; i++) {
            var a = arguments[i];
            if (a != null) a = a.toString();
            var reg = new RegExp("\\{" + (i-1) + "\\}", "g");
            str = str.replace(reg, a.toString());
        }
        return str;
    }
    avalon.filters.array = function (val) {
        if (!val) return "";
        return val.join(",");
    }
})();