﻿var map;
var transit;
var drivingRoute;
function initialize() {
    map = new BMap.Map('map');
    map.centerAndZoom(document.getElementById("txtCity").value, 13);
    map.enableScrollWheelZoom();
    map.addControl(new BMap.NavigationControl());
    map.addControl(new BMap.ScaleControl());
    map.addControl(new BMap.OverviewMapControl());
    map.addControl(new BMap.MapTypeControl());
    if (document.getElementById("ul_kh") != null) {
        add_marker();
    }
    else {
        $("#btn_seek").click();
    }

    transit = new BMap.TransitRoute(map, { renderOptions: { map: map, panel: "divline", autoViewport: true } });
    drivingRoute = new BMap.DrivingRoute(map, { renderOptions: { map: map, panel: "divline", autoViewport: true } });

}


function myCityCallback(result) {
    var cityName = result.name;
    map.setCenter(cityName);
    map.setCurrentCity(cityName);

}

function addMarker(khid, name, lng, lat) {

    var point = new BMap.Point(lng, lat);
    var marker = new BMap.Marker(point);
    marker.setTitle(name);
    var label = new BMap.Label(name, { position: point, offset: new BMap.Size(20, -10) });
    marker.setLabel(label);

    marker.addEventListener("click", function () {

        document.getElementById("txt_start").value = document.getElementById("txtCompanyName").value;
        document.getElementById("txt_end").value = name;
        document.getElementById("txt_end").setAttribute("lng", lng);
        document.getElementById("txt_end").setAttribute("lat", lat);

        newInfoWindow(this, khid);

    });


    map.addOverlay(marker);

}


function getOneMapOverlay(khid, name, lng, lat) {
    //alert(khid + "|" + name + "|" + lng + "|" + lat);
    var lays = map.getOverlays();
    for (var i = 0; i < lays.length; i++) {
        try {
            if (lays[i].getPosition() !== null) {
                var point = lays[i].getPosition();
                if (lng == point.lng && lat == point.lat) {
                    document.getElementById("txt_start").value = document.getElementById("txtCompanyName").value;
                    document.getElementById("txt_end").value = name;
                    document.getElementById("txt_end").setAttribute("lng", point.lng);
                    document.getElementById("txt_end").setAttribute("lat", point.lat);
                    newInfoWindow(lays[i], khid);
                }
            }
        }
        catch (e) { }
    }
}


function newInfoWindow(marker, khid) {
    var opt = {
        width: 365,
        height: 210,
        enableCloseOnClick: true
    };
    var obj = $("#" + khid);
    if (obj != undefined && obj != null) {
        var $name = $("#khname").children("span");
        var $tel = $("#tel");
        var $page = $("#page");
        var $address = $("#address");
        var $lastgd = $("#lastgd");
        var $xfje = $("#xfje");
        var $lasthf = $("#lasthf");
        var $xfcs = $("#xfcs");
        var $lastts = $("#lastts");
        var $tsnum = $("#tsnum");
        var link = "window.location.href='#/Customer/DetailCustomer/" + khid + "'";

        $("#khcontent").find("td").each(function () {
            $(this).text("");
        });
        $name.text(obj.attr("title"));
        $tel.text(obj.attr("tel"));
        $page.text(obj.attr("page"));
        $address.text(obj.attr("aes"));
        $lastgd.text(obj.attr("tlastgdel"));
        //$xfje.text("");
        $lasthf.text(obj.attr("lasthf"));
        //$xfcs.text("");
        $lastts.text(obj.attr("lastts"));
        $tsnum.text(obj.attr("tsnum"));
        $("#customerInfo").attr("onclick", link);
    }
    var infoWin = new BMap.InfoWindow($("#khcontent").html(), opt);
    infoWin.setTitle($("#khname").html());
    marker.openInfoWindow(infoWin);
}

function closeInfoWindow() {
    var lays = map.getOverlays();
    for (var i = 0; i < lays.length; i++) {
        try {
            if (lays[i].getPosition() !== null) {
                lays[i].closeInfoWindow();
            }
        }
        catch (e) { }
    }
}


function seekLocal(khid, city, name, sel) {

    var seek = 0;
    var local = new BMap.LocalSearch(city, {
        renderOptions: {
            map: map,
            autoViewport: false,
            selectFirstResult: sel,
            panel: "seekpanel"
        },

        onSearchComplete: function (results) {
        },
        onMarkersSet: function (pois) {
        },
        onInfoHtmlSet: function (poi, html) {
            var lng = poi.point.lng;
            var lat = poi.point.lat;
            $(html).append("<input type=\"button\" class=\"setPoint\" ref=\"ok\" style=\"width:100px; height:22px;  padding:0px;\" value=\"确定\" />");
            $(html).append("<input type=\"button\" class=\"setPoint\" ref=\"ca\" style=\"width:100px; height:22px; margin-left:20px; padding:0px;\" value=\"取消\" />");
            setPoint(khid, lng, lat);
        }
    });

    local.search(name);

}

function setPoint(lng, lat) {
    $(".setPoint").each(function () {

        $(this).click(function () {
            var atemp = "ctl00_ContentPlaceHolder1_";
            var etemp = "ctl00_ctl00_ContentPlaceHolder1_ContentPlaceHolder1_";
            $(window.parent.document).find("coordinate").attr("display", "");

            if ($(window.parent.document).find(atemp + "txtLng")) {
                $(window.parent.document).find(atemp + "txtLng").attr("value", lng);
                $(window.parent.document).find(atemp + "txtLat").attr("value", lat);
            }
            else {
                $(window.parent.document).find(etemp + "txtLng").attr("value", lng);
                $(window.parent.document).find(etemp + "txtLat").attr("value", lat);
            }
            $(window.parent.document).find("#ContentMessageBox2_btnHeaderCloseContentMessageBox").click();
        });
    });

}

function addMoveMarker(city, name) {
    map.setCenter(city);
    var marker = new BMap.Marker(map.getCenter());
    var opt = {
        width: 204,
        height: 50,
        enableCloseOnClick: true,
        title: name
    };

    var contetn = "<input type=\"button\" class=\"setPoint\" ref=\"ok\" style=\"width:100px; height:22px;  padding:0px;\" value=\"确定\" />" +
                  "<input type=\"button\" class=\"setPoint\" ref=\"ca\" style=\"width:100px; height:22px; margin-left:20px; padding:0px;\" value=\"取消\" />";
    var infoWin = new BMap.InfoWindow(contetn, opt);

    marker.enableDragging();

    marker.addEventListener("dragend", function () {
        if (!infoWin.isOpen()) {
            this.openInfoWindow(infoWin);
            setPoint(marker.getPosition().lng, marker.getPosition().lag);
        }

    });
    marker.addEventListener("click", function () {
        if (!infoWin.isOpen()) {
            this.openInfoWindow(infoWin);
            setPoint(marker.getPosition().lng, marker.getPosition().lag);
        }

    });

    map.addOverlay(marker);

}


function codeAddress(city, address) {

    var myGeo = new BMap.Geocoder();
    myGeo.getPoint(address, function (point) {
        if (point) {
            addMarker(point);
        }
    }, city);

}

function seekBusLine(city, lng1, lat1, lng2, lat2) {
    transit.setLocation(city);
    transit.setSearchCompleteCallback(function (results) {
        if (transit.getStatus() == BMAP_STATUS_SUCCESS) {
        }
    });
    var point1 = new BMap.Point(lng1, lat1);
    var point2 = new BMap.Point(lng2, lat2);
    transit.search(point1, point2);
}

function seekCarLine(city, lng1, lat1, lng2, lat2) {

    var point1 = new BMap.Point(lng1, lat1);
    var point2 = new BMap.Point(lng2, lat2);

    drivingRoute.search(point1, point2);
}

function clearMarker() {
    map.clearOverlays();
}

function loadScript() {
    var script = document.createElement("script");
    script.type = "text/javascript";
    script.src = "http://api.map.baidu.com/api?v=1.5&ak=225ec0d19b6a2e29301640397eab4e50&callback=initialize"; //此为v1.5版本的引用方式
    document.body.appendChild(script);
}






