﻿require(["floatCalc", "fusionCharts", "json", "cookie"], function () {
    var $a = avalon;
    var dateLen = 5;
    var mydepartments = '';
    var loadMyDeparts = function ()
    {
        $.get('/Market/GetSaleTargetDepartment', {}, function (ret) {
            mydepartments = ret.data;
        })
    }
    loadMyDeparts();
    var keyIndexMaps = {};
    var dateIndexMaps = {};
    var departments = mydepartments;
    var isNum = /^\d+(\.{1}\d+)?$/;
    var fulld;
    var time = "";
    var treeAsyncSuccess = function (event, treeId, treeNode, msg) {
        var tree = $.fn.zTree.getZTreeObj(treeId);
        var node;
        if (mydepartments.length) {
            $a.each(mydepartments, function (i, t) {
                node = tree.getNodeByParam("id", t, null);
                tree.checkNode(node, true, true);
            });
        } else {
            tree.checkAllNodes(true);
        }
    };
    var $saleTarget = $a.define("market.targets", function ($v) {
        $v.users = [];
        $v.dates = [];
        $v.btns = [];
        $v.columns = [];
        $v.checkNum = function (e) {
            var $el = $a(e.target);
            if (!isNum.test($el.val())) {
                showErrorMessageBox("请输入数字。");
                $(e.target).focus();
                setTimeout(function () {
                    $("#message").html("").hide(300);
                }, 5000);
                return false;
            }
        }
        $v.expandRow = function () {
            var $vm = this.$vmodel;
            var users = this.$vmodels[1].users;
            var index = $vm.$index;
            var depth = $vm.item.Depth;
            var current;
            var showDetails = $vm.item.showDetails = !$vm.item.showDetails;
            while (true) {
                current = users[++index];
                if (!current || current.Depth <= depth) break;
                current.show = current.showDetails = showDetails;
            }
        }
        $v.toChart = function () {
            var $vm = this.$vmodel;
            var users = this.$vmodels[1].users;
            var index = $vm.$index;
            toChart(users[index]);
        }
        $v.doEdit = ''
        $v.doCancel = ''
        $v.doSave = ''
    });
    var $totalChart = $a.define("market.totalChart", function ($v) {
        $v.changeChartType = function (e) {
            var $self = $a(e.target),
            type = $self.data("type");
            if (type) {
                createChart("chart", null, type);
            }
        }
    });
    var $search = $a.define("search", function ($v) {
        $v.startDate = '';
        $v.endDate = '';
        //$v.soptions = {
        //    onReturn: function (d, dateFormat) {
        //        $search.startDate = dateFormat.call(d, "yyyy-M");
        //        $a.log($search.startDate);
        //    }
        //};
        //$v.eoptions = {
        //    onReturn: function (d, dateFormat) {
        //        $search.endDate = dateFormat.call(d, "yyyy-M");
        //        $a.log($search.endDate);
        //    }
        //};
        $v.doShow = function () {
            $saleTarget.users = [];
            $saleTarget.dates = [];
            $saleTarget.btns = [];
            $saleTarget.columns = [];
            setDateRange();
            loadUsers();
        }
         
        $v.startDateOPts = {
            format: '%Y-%m',
            onSelect: function (date, formatDate, format) {
                $search.startDate = formatDate
            }
        }

        $v.endDateOPts = {
            format: '%Y-%m',
            onSelect: function (date, formatDate, format) {
                $search.endDate = formatDate
            }
        }
    }); 
    $search.$watch("startDate", function (c, o) {
        if (c !== o) {
            $search.startDate = c;
            $.cookie('ssd', c);
        }
    });
    $search.$watch("endDate", function (c, o) {
        if (c !== o) {
            $search.endDate = c;
            $.cookie('sed', c);
        }
    });
    var $doption = $a.define("doption", function ($v) {
        $v.treeopts = {
            treeopts: {
                check: {
                    enable: true
                },
                callback: {
                    onAsyncSuccess: treeAsyncSuccess,
                    onCheck: function (event, treeId, treeNode) {
                        var treeObj = $.fn.zTree.getZTreeObj(treeId);
                        var nodes = treeObj.getCheckedNodes(true);
                        var hasCheck = nodes.length > 0;
                        var users = $saleTarget.users;
                        var start = 0;
                        var node;
                        var g;
                        var depth;
                        var children
                        for (var j = 1, uLen = users.length; j < uLen; j++) {
                            g = users[j];
                            if (!hasCheck) {
                                g.show = true;
                                g.showDetails = g.show;
                            } else {
                                g.show = false;
                            }
                        }
                        departments = [];
                        for (var i = 0, len = nodes.length; i < len; i++) {
                            node = nodes[i].id;
                            departments.push(node);
                            start = keyIndexMaps[node];
                            //$a.log("GroupId：" + node.id + " Index：" + start);
                            if (!start) continue;
                            g = users[start];
                            depth = g.Depth;
                            g.show = true;
                            g.showDetails = true;
                            children = getChildren(users, start, depth);
                            $a.each(children, function (index, item) {
                                item.show = true;
                                item.showDetails = true;
                            });
                        }
                    }
                }
            }
        }
    });
    var now = new Date();
    var editIndex;
    var getChildren = function (arr, index, depth) {
        var current,
             ret = [];
        for (var i = index + 1, len = arr.length; i < len; i++) {
            current = arr[i];
            if (current.Depth <= depth) {
                break;
            } else {
                $a.log("current：" + (current.GroupName || current.Name) + " Depth：" + current.Depth);
                ret.push(current);
            }
        }
        return ret;
    }
    var targetCheck = function (row, column) {
        var users = $saleTarget.users;
        var root = users[0];
        var i = row || 1;
        var len = users.length;
        var stack = [root];
        var cur;
        var filter = ['show', 'toEdit', 'hasOwnProperty', 'SignAContractMoneyNotEq',
                'ReturnedMoneyNotEq', 'CustomerNumNotEq', 'SignAContractNotEq'];
        var empty = {
            SignAContract: 0,
            SignAContractTotal: 0,
            CompleteSignAContract: 0,
            SignAContractMoney: 0,
            SignAContractMoneyTotal: 0,
            CompleteSignAContractMoney: 0,
            ReturnedMoney: 0,
            ReturnedMoneyTotal: 0,
            CompleteReturnedMoney: 0,
            CustomerNum: 0,
            CustomerNumTotal: 0,
            CompleteCustomerNum: 0
        };
        var start = $a.mix({}, empty);
        var depth = root.Depth;
        var ret = {};
        var target;
        var el;
        var x = 0;
        var y = 0;
        var p = '';
        var calc = function (i, t) {
            var s = ret[i];
            for (var key in s) {
                p = key + "NotEq";
                if (t.hasOwnProperty(p)) {
                    x = parseInt(t[key], 10);
                    y = parseInt(s[key], 10);
                    x = isNaN(x) ? 0 : x;
                    y = isNaN(y) ? 0 : y;
                    /*if (x || y) {
                    $a.log("name:" + el.GroupName + "key:" + key + " x:" + x + " y:" + y);
                    }*/
                    t[p] = x < y;
                }
            }
        }
        for (; i < len; i++) {
            cur = users[i];
            if (cur.Depth === depth && stack.length) {
                //下一个部门时先计算压入堆栈里的部门
                var ts;
                while (el = stack.pop()) {
                    ts = el.Targets;
                    if (!column) {
                        $a.each(ts, calc);
                    } else {
                        calc(column, ts[column]);
                    }
                }
                ret = {};
                stack.push(root);
                stack.push(cur);
                start = $a.mix({}, empty);
            }
            if (!cur.show) continue;
            if (!cur.IsGroup) {
                if (column) {
                    target = cur.Targets[column];
                    $a.each(target, function (i, t) {
                        if ($.inArray(i, filter) === -1) {
                            start = ret[column] || $a.mix({}, empty);
                            ret[column] = start;
                            x = parseInt(start[i], 10);
                            y = parseInt(target[i], 10);
                            if ($a.type(x) === "number" && $a.type(y) === "number") {
                                x = isNaN(x) ? 0 : x;
                                y = isNaN(y) ? 0 : y;
                                //$a.log("key:"+j + " x:"+x + " y:"+y );
                                start[i] = x.add(y);
                            }
                        }
                    });
                } else {
                    $a.each(cur.Targets, function (i, t) {
                        start = ret[i] || $a.mix({}, empty);
                        ret[i] = start;
                        $a.each(t, function (j, item) {
                            if ($.inArray(j, filter) === -1) {
                                x = parseInt(start[j], 10);
                                y = parseInt(t[j], 10);
                                if ($a.type(x) === "number" && $a.type(y) === "number") {
                                    x = isNaN(x) ? 0 : x;
                                    y = isNaN(y) ? 0 : y;
                                    //$a.log("key:"+j + " x:"+x + " y:"+y );
                                    start[j] = x.add(y);
                                }
                            }
                        });
                    });
                }
            } else {
                depth = Math.max(depth, cur.Depth);
                stack.push(cur);
            }
        }
    }
    var targetTotal = function (row) {
        var users = $saleTarget.users;
        var i = row || 0;
        var len = users.length;
        var cur;
        var ct;
        var tlen = 0;
        var empty = {
            SignAContractMoneyTotal: 0,
            CompleteSignAContractMoneyTotal: 0,
            ReturnedMoneyTotal: 0,
            CompleteReturnedMoneyTotal: 0,
            CustomerNumTotal: 0,
            CompleteCustomerNumTotal: 0,
            SignAContractTotal: 0,
            CompleteSignAContractTotal: 0
        };
        var keyMap = {
            SignAContractMoneyTotal: "SignAContractMoney",
            CompleteSignAContractMoneyTotal: "CompleteSignAContractMoney",
            ReturnedMoneyTotal: "ReturnedMoney",
            CompleteReturnedMoneyTotal: "CompleteReturnedMoney",
            CustomerNumTotal: "CustomerNum",
            CompleteCustomerNumTotal: "CompleteCustomerNum",
            SignAContractTotal: "SignAContract",
            CompleteSignAContractTotal: "CompleteSignAContract"
        };
        var rowTotal = $a.mix({}, empty);
        var x = 0;
        var y = 0;
        for (; i < len; i++) {
            cur = users[i];
            tlen = cur.Targets.length;
            while (tlen) {
                tlen--;
                ct = cur.Targets[tlen];
                for (var key in rowTotal) {
                    x = parseInt(ct[keyMap[key]], 10);
                    y = parseInt(rowTotal[key], 10);
                    x = isNaN(x) ? 0 : x;
                    y = isNaN(y) ? 0 : y;
                    rowTotal[key] = x.add(y);
                }
            }
            for (var key in rowTotal) {
                //$a.log("rowindex:"+i + " key:"+key + " val:"+rowTotal[key]);
                cur[key] = rowTotal[key];
            }
            rowTotal = $a.mix({}, empty);
        }
    }
    var doCall = function (isEdit) {
        var $vmm = this.$vmodel;
        var $pvm = this.$vmodels[1];
        var index = $vmm.$index;
        var i = 0;
        var j = 0;
        var len = $pvm.users.length;
        var tLen;
        var current;
        var show;
        var t;
        var copy;
        $vmm.item.canCancel = $vmm.item.canSave = isEdit;
        $vmm.item.editing = !isEdit;
        editIndex = index;
        $a.log("当前编辑项索引:" + editIndex);
        for (; i < len; i++) {
            current = $pvm.users[i];
            if (!current.show) continue;
            tLen = current.Targets.length;
            for (; j < tLen; j++) {
                t = current.Targets[j];
                if (isEdit) {
                    show = j === index;
                    t.toEdit = true;
                    t.show = show;
                    $pvm.columns[j].show = show;
                    $pvm.dates[j].show = show;
                    $pvm.btns[j].show = show;
                } else {
                    t.show = true;
                    t.toEdit = false;
                    $pvm.columns[j].show = true;
                    $pvm.dates[j].show = true;
                    $pvm.btns[j].show = true;
                }
            }
            j = 0;
        }
    }
    var doCancel = function () {
        doCall.call(this, false);
    }
    var doEdit = function () {
        doCall.call(this, true);
    }
    var doSave = function () {
        if (!editIndex && editIndex !== 0) return;
        var users = $saleTarget.users;
        var dates = $saleTarget.dates;
        var i = 0;
        var len = users.length;
        var current;
        var target;
        var d = dates[editIndex].date + "-01";
        var ret = [];
        var self = this;
        var tmp;
        var departmentss = [];
        for (; i < len; i++) {
            current = users[i];
            if (!current.show) continue;
            target = current.Targets[editIndex];
            $a.log("Employee：" + current.Id + " Department：" + current.GroupId + " Date：" + d);
            if (current.GroupId) {
                departmentss.push(current.GroupId);
            }
            tmp = $a.mix({}, target.$model, { Employee: current.Id || ""
                        , Department: current.GroupId || ""
                        , CompleteDate: d
            });
            delete tmp.Id;
            delete tmp.EmployeeDisplay;
            delete tmp.SignAContractNotEq;
            delete tmp.SignAContractMoneyNotEq;
            delete tmp.ReturnedMoneyNotEq;
            delete tmp.CustomerNumNotEq;
            delete tmp.show;
            delete tmp.toEdit;
            ret.push(tmp);
        }
        if (ret.length === 0) {
            $a.log("没有销售目标值可保存。");
            return;
        }
        $.post("./SaleTargetSettingView.aspx", { Handle: "AjaxForm",
            targets: JSON.stringify(ret),
            departments: departmentss.join(",")
        }, function (res) {
            if (res.Result) {
                time = new Date();
                showSucceedMessageBox(res.Message);
                doCall.call(self, false);
                $a.nextTick(function () {
                    targetTotal();
                    targetCheck(0, editIndex);
                });
            } else {
                showErrorMessageBox(res.Messgae);
            }
        });
    }
    var monthCalc = function (startDate, endDate) {
        var number = 0;
        var yearToMonth = (endDate.getFullYear() - startDate.getFullYear()) * 12;
        number += yearToMonth;
        monthToMonth = endDate.getMonth() - startDate.getMonth();
        number += monthToMonth;
        return number + 1;
    }
    var createDate = function (len, month) {
        var d;
        for (var i = 0; i < len; i++) {
            d = new Date();
            d.setMonth(month + i);
            fulld = d.getFullYear() + "-" + (d.getMonth() + 1);
            dateIndexMaps[fulld] = i;
            $saleTarget.dates.push({
                date: fulld,
                show: true
            });
            $saleTarget.columns.push({
                show: true
            });
            $saleTarget.btns.push({              
                canCancel: false,
                canSave: false,
                show: true,
                editing: true
            });
        }
    }
    var dateFormat = function (val) {
        return typeof val.getFullYear !== "undefined" ? val.getFullYear() + "-" + (val.getMonth() + 1)
         : "";
    }
    var setDateRange = function () {
        var start = new Date($search.startDate.replace("-", "/") + "/01");
        var end = new Date($search.endDate.replace("-", "/") + "/01");
        var month = monthCalc(start, end);
        dateLen = month;
        createDate(month, start.getMonth());
    }
    var createChart = function (id, charts, charttype) {
        var myChart = new FusionCharts("/Scripts/Charts/Charts/" + (charttype || "MSColumn3D")
         + ".swf", "totalChart", "990", "350");
        myChart.setTransparent(true);
        myChart.setJSONData(charts || createChart.ret);
        myChart.render(id);
        if (charts) {
            createChart.ret = charts;
        }
    }
    var toChart = function (user) {
        var id = "chart", $chart = $("#" + id);
        if (!$chart.length) {
            $a.log("没有找到统计图表区域，停止执行。");
        }
        var data = $chart.data();
        if (!data) return;
        var column = data.column,
            completeColumn = "Complete" + column,
             charts = {
                 "chart": {
                     "caption": (user.GroupName || user.Name) + " 的 " + data.caption + "完成情况统计图",
                     "xaxisname": "时间范围",
                     "yaxisname": data.caption,
                     "yaxisminvalue": 0,
                     "yaxismaxvalue": 0,
                     "showcolumnshadow": "1",
                     "showvalues": "0",
                     "decimals": "0",
                     "numbersuffix": data.units,
                     "alternatevgridcolor": "f7f7f7",
                     "basefontcolor": "114B78",
                     "tooltipbordercolor": "114B78",
                     "tooltipbgcolor": "E7EFF6",
                     "plotborderdashed": "0",
                     "plotborderdashlen": "2",
                     "plotborderdashgap": "2",
                     "useroundedges": "1",
                     "showborder": "0",
                     "bgColor": "#e6e6e6",
                     "canvasBorderColor": "#e6e6e6",
                     "canvasBgColor": "#FFFFFF",
                     "canvasBgAlpha": "50",
                     "bgAlpha": "0",
                     "basefontsize": "12"
                 },
                 "categories": [{
                     "category": []
                 }],
                 "dataset": []
             },
        ymax = 0,
        targets = user.Targets,
        dates = $saleTarget.dates,
        targetVals = [],
        completeVals = [];
        $a.each(dates, function (i, item) {
            charts.categories[0].category.push({ "label": item.date });
        });
        $a.each(targets, function (i, item) {
            var val = item[column];
            ymax = Math.max(ymax, val);
            targetVals.push({
                "value": val
            });
        });
        $a.each(targets, function (i, item) {
            completeVals.push({
                "value": item[completeColumn]
            });
        });
        charts.dataset.push({ "seriesname": "目标值",
            "color": "AFD8F8",
            "data": targetVals
        });
        charts.dataset.push({ "seriesname": "完成值",
            "color": "F6BD0F",
            "data": completeVals
        });
        if (ymax < 10) {
            charts.chart.yaxismaxvalue = 10;
        }
        createChart(id, charts);
    }
    $search.startDate = $.cookie('ssd');
    $search.endDate = $.cookie('sed');
    if (!$search.startDate) {
        $search.startDate = dateFormat(now);
    }
    if (!$search.endDate) {
        var nd = new Date();
        nd.setMonth(nd.getMonth() + dateLen);
        $search.endDate = dateFormat(nd);
    }
    $saleTarget.doEdit = function () {
        //this.$vmodels.unshift(entity)
        doEdit.call(this)
        //doCall(true,entity,this.$vmodel,index)
    }
    $saleTarget.doSave = function () {
        doSave.call(this)
    }
    $saleTarget.doCancel = function () {
        doCall.call(this)
    }
    setDateRange();
    var loadUsers = function () {
        $.get('/Settings/GetGroupPostUser/2020900', {}, function (result) {
            var empty = {
                SignAContractMoneyTotal: '',
                CompleteSignAContractMoneyTotal: '',
                ReturnedMoneyTotal: '',
                CompleteReturnedMoneyTotal: '',
                CustomerNumTotal: '',
                CompleteCustomerNumTotal: '',
                SignAContractTotal: '',
                CompleteSignAContractTotal: '',
                show: true,
                showDetails: true,
                IsGroup: true,
                Targets: [],
                Depth: 0
            };
            var data = [$a.mix({}, empty, { GroupName: "公司", Id: 0 })];
            var elen = result.data.groups.length;
            var depthMap = {};
            var current;
            var employees = [];
            var employee;
            var i = 0;
            var ds = mydepartments;
            var hasDepartment = mydepartments.length > 0;
            var empSort = function (a, b) {
                if (a.Depth === b.Depth) {
                    return a.PostId > b.PosttId ? 1 : -1;
                }
                return a.Depth > b.Depth ? -1 : 1;
            }
            var groupCall = function (groups) {
                var j = 0;
                var len = groups.length;
                var depth;
                while (j < len) {
                    current = $a.mix(groups[j], empty);
                    i = elen;
                    if (!current.ParentId) {
                        depthMap[current.GroupId] = depth = 1;
                    } else {
                        depth = depthMap[current.ParentId];
                        if (!depth) {
                            depthMap[current.GroupId] = depth = 1;
                        } else {
                            depth += 1;
                            depthMap[current.GroupId] = depth;
                        }
                    }
                    current.Targets = [];
                    current.Depth = depth;
                    current.IsGroup = true;
                    if (hasDepartment) {
                        //$a.log("name:" + current.GroupName + " id :" + current.GroupId + " show:" + $.inArray(current.GroupId, ds)
                        //+ " group:" + ds.join(",") + " groupIdType:"+typeof current.GroupId);
                        current.show = $.inArray(parseInt(current.GroupId, 10), ds) > -1;
                    } else {
                        current.show = true;
                    }
                    current.showDetails = current.show;
                    data.push(current);
                    while (i) {
                        i--;
                        employee = employees[i];
                        if (current.Id == employee.GroupId) {
                            employee.Depth += current.Depth;
                            employee.show = current.show;
                            data.push(employee);
                        }
                    }
                    j++;
                }
            }
            while (i < elen) {  
                var curr = result.data.groups[i]
                curr.Posts.forEach(function (p, n) {
                    curr.Posts[n].ParentId = p.Boss ? p.Boss.Id : p.Group 
                    p.Users.forEach(function (u, j) {
                        var u = p.Users[j]
                        u.Name = u.FullName
                        employee = $a.mix(u, empty);
                        delete employee.showDetails;
                        employee.IsGroup = false;
                        if (!employee.BossIds) {
                            employee.Depth = 1;
                        } else {
                            employee.Depth = employee.BossIds.split(",").length;
                        }

                        employees.push(employee);
                    }) 
                })


                //employee = $a.mix(result.data.groups[i], empty);
                //delete employee.showDetails;
                //employee.IsGroup = false;
                //if (!employee.BossIds) {
                //    employee.Depth = 1;
                //} else {
                //    employee.Depth = employee.BossIds.split(",").length;
                //}

                //employees.push(employee);
                i++;
            }
            employees = employees.sort(empSort);
            groupCall(result.data.groups);
            $saleTarget.users = data;
            loadTargets();
        });
    }
    var createEmptyTargets = function (len) {
        var empty = {
            SignAContract: '',
            SignAContractTotal: '',
            SignAContractMoney: '',
            SignAContractMoneyTotal: '',
            ReturnedMoney: '',
            ReturnedMoneyTotal: '',
            CustomerNum: '',
            CustomerNumTotal: '',
            CompleteSignAContract: '',
            CompleteCustomerNum: '',
            CompleteSignAContractMoney: '',
            CompleteReturnedMoney: '',
            CompleteReturnedMoneyTotal: '',
            CompleteSignAContractMoneyTotal: '',
            CompleteSignAContractTotal: '',
            CompleteCustomerNumTotal: '',
            SignAContractMoneyNotEq: false,
            ReturnedMoneyNotEq: false,
            CustomerNumNotEq: false,
            SignAContractNotEq: false,
            show: true,
            toEdit: false
        };
        var ret = [];
        while (len) {
            len--;
            ret.push($a.mix({}, empty));
        }
        return ret;
    }
    var loadTargets = function () {
        var sd = $saleTarget.dates[0].date;
        var ed = $saleTarget.dates[dateLen - 1].date;
        var users = $saleTarget.users;
        var userLen = $saleTarget.users.length;
        $a.nextTick(function () {
            for (var g = 0; g < userLen; g++) {
                var c = users[g];
                keyIndexMaps[c.GroupId || c.Id] = g;
                c.Targets = createEmptyTargets(dateLen);
            }
        });
        $.get('/Market/GetSaleTarget', {
            StartDate: sd, EndDate: ed, t: time
        }, function (result) {
            var datas = result.data;
            if (!datas.length) {
                $a.log("没有" + sd + " 至 " + ed + " 销售目标数据……");
                setTimeout(function () {
                    var $el = $(".exmployee_saletarget");
                    $el.width($el.parent().width());
                }, 500);
                return;
            }
            time = "";
            var indexMaps = keyIndexMaps;
            var index;
            var d;
            var rd;
            var dindex;
            var t;
            $a.each(datas, function (index, item) {
                index = indexMaps[item.Department || item.Employee];
                d = item.CompleteDate.split("-");
                rd = d[0] + "-" + parseInt(d[1], 10);
                dindex = dateIndexMaps[rd];
                //$a.log("index:"+index + " Department:"+item.Department+
                //" Employee:"+ item.Employee);
                if (!item.Department && !item.Employee) {
                    index = 0;
                }
                if (index || index === 0) {
                    delete item.Id;
                    delete item.CompleteDate;
                    delete item.Employee;
                    delete item.EmployeeDisplay;
                    delete item.Department;
                    t = users[index].Targets[dindex];
                    var tmp,
                    model = t.$model
                    for (var prop in model) {
                        tmp = item[prop]
                        if(typeof tmp !== 'undefined')
                            t[prop] = tmp
                    }
                    //t = $a.mix(t, item);
                }
            });
            $a.nextTick(function () {
                targetTotal();
                targetCheck();
                toChart($saleTarget.users[0]);
                var $el = $(".exmployee_saletarget");
                $el.width($el.parent().width());
            });
        });
    }
    loadUsers();
    $a.scan();

    $(function () {
        setTimeout(function () {
            var $nodes = $(".setdepartment");
            $nodes.attr("ms-ui-treeopts", "dropDownDepartmentTree");
            $a.scan($nodes[0], $doption);
        }, 2000);
        //$a.log("userAgent：" + navigator.userAgent);
        if (navigator.userAgent.indexOf("MSIE 8.0") > 0) {
            $("#right").css("padding-right", 6);
        } else {
            $("#right").css("padding-right", 8);
        }
    });

    $a.filters.percents = function (str, val, fixed) {
        if (!str || !val) {
            return "";
        }
        var ret = str / val;
        if (isNaN(ret) || ret === 0) {
            return "0 %";
        }
        return (parseFloat((ret + "").substr(0, 4)) * 100) + "%"
        //return (Math.ceil(ret) * 100).toFixed(fixed || 2) + "%";
    }
});