﻿define('LeftMenu', ['avalon'], function (avalon) {
    var leftMenu = avalon.ui.leftMenu = function (el, data, vmodels) {
        var opts,
            model,
            CBCRM,
            lv2Menu,
            selected = false,
            len,
            tmp,
            last
        if (avalon.vmodels[data.leftMenuId])
            delete avalon.vmodels[data.leftMenuId]
        opts = avalon.mix({}, avalon.ui.leftMenu.defaults, data.leftMenuOptions)
        CBCRM = avalon.vmodels.CBCRM
        lv2Menu = CBCRM.gps[1]
        selected = false
        model = avalon.define(data.leftMenuId, function (vm) {
            avalon.mix(vm, opts)
            vm.menus = []
            vm.module = ''
            vm.leftMenuChanged = function (e) {
                var index = this.$vmodel.$index
                model.menus.forEach(function (m, i) {
                    if (i === index) {
                        m.selected = true
                        CBCRM.gps.splice(2, 1, m)
                        if (m.children && m.children.size()) {
                            m.showChildren = true
                        }
                    } else {
                        m.selected = false
                        if (m.children && m.children.size()) {
                            m.showChildren = false
                        }
                    }
                })
            }
        })
        if (lv2Menu) {
            model.menus = []
            CBCRM.getChildMenus(lv2Menu, 1, true).forEach(function (m) {
                var children
                    , menu
                if (!m.isAction) {
                    //model.menus.push(m)
                    children = CBCRM.getChildMenus(m, 1, true)
                    menu = avalon.mix({ showChildren: false }, m)
                    if (children.length)
                        menu.children = children
                    model.menus.push(menu)
                }
            })
            model.module = lv2Menu.name
        }
        //avalon.clearChild(el)
        var matchReg = /\/(\w+)\/(\w+)*/
            , tmpMatchs
        last = avalon.router.getLatelyPath().match(matchReg)
        len = model.menus.length
        while (len) {
            tmp = model.menus[--len]
            if (last && last.length) {
                tmpMatchs = tmp.path.match(matchReg)
                if (tmpMatchs) {
                    tmp.selected = (tmpMatchs[1] == last[1]) && (tmpMatchs[2] == last[2])
                    if (tmp.children && tmp.children.size()) {
                        tmp.showChildren = tmp.selected
                    }
                }
            }
            if (tmp.children && tmp.children.size()) {
                var chMatchs
                for (var i = 0, ch; ch = tmp.children[i++];) {
                    chMatchs = ch.path.match(matchReg)
                    ch.selected = (chMatchs[1] == last[1]) && (chMatchs[2] == last[2])
                    if (!selected)
                        selected = ch.selected
                }
                tmp.showChildren = selected
            }
        }
        avalon.nextTick(function () {
            el.innerHTML = opts.$tmpl
            avalon.scan(el, [model].concat(vmodels))
            if (!CBCRM.disableGPS && lv2Menu) $("#left_menu_top").html(lv2Menu.name).show()
        })
        return model
    }

    leftMenu.defaults = {
        $tmpl: '<div><ul ms-each-menu="menus">'
            + '<li ms-data-index="$index" ms-class-selected="menu.selected" ms-class-last="$last"'
            + ' ms-live-click="leftMenuChanged"><b ms-if="menu.children && menu.children.size() > 0"></b><a ms-href="\'#\'+menu.path" ms-attr-class="menu.icon"'
            + ' ms-html="menu.name" ms-data-index="$index"></a></li>'
            + '<div ms-if="menu.children && menu.children.size() > 0" class="subbox" ms-visible="menu.showChildren">'
            + '<ul><li ms-repeat-cmenu="menu.children" ms-class-on="cmenu.selected"><a ms-href="\'#\'+cmenu.path">{{cmenu.name}}</a></li></ul>'
            + '</div></ul></div>'
    }

    var materialsGiftMenu = avalon.ui.materialsGiftMenu = function (el, data, vmodels) {
        var model
            , ret = []
            , i = 0
            , item
            , tmp1 = '礼品/赠品'
            , tmp2 = '物料/印刷品'
            , tmp3 = '优惠劵'
            , tmp1Parnet = null
            , tmp2Parnet = null
            , tmp3Parnet = null
            , menus
        data.leftMenuId = 'materialsGiftMenu'
        model = avalon.ui.leftMenu(el, data, vmodels)
        menus = avalon.mix(true, [], model.menus.$model)
        model.menus.removeAll()
        for (; item = menus[i++];) {
            if (item.name.indexOf(tmp1) > -1) {
                if (!tmp1Parnet) {
                    tmp1Parnet = { id:2051100,pIds: [2000000, 2050000],path: '', name: tmp1 + '管理', showChildren: false,children: [], selected: false, icon: 'sellpresent' }
                    model.menus.push(tmp1Parnet)
                    tmp1Parnet = model.menus[model.menus.size() - 1]
                }
                item.pIds.push(2051100)
                if(item.selected)
                    tmp1Parnet.showChildren = item.selected
                tmp1Parnet.children.push(item)
            } else if (item.name.indexOf(tmp2) > -1) {
                if (!tmp2Parnet) {
                    tmp2Parnet = { id:2051200,pIds: [2000000, 2050000],path: '', name: tmp2 + '管理', showChildren: false,children: [], selected: false, icon: 'sellbrush' }
                    model.menus.push(tmp2Parnet)
                    tmp2Parnet = model.menus[model.menus.size() - 1]
                }
                item.pIds.push(2051200)
                if(item.selected)
                    tmp2Parnet.showChildren = item.selected
                tmp2Parnet.children.push(item)
            } else if (item.name.indexOf(tmp3) > -1) {
                if (!tmp3Parnet) {
                    tmp3Parnet = { id:2051300,pIds: [2000000, 2050000],path: '', name: tmp3 + '管理', showChildren: false,children: [], selected: false, icon: 'sellbookmark' }
                    model.menus.push(tmp3Parnet)
                    tmp3Parnet = model.menus[model.menus.size() - 1]
                }
                item.pIds.push(2051300)
                if(item.selected)
                    tmp3Parnet.showChildren = item.selected
                tmp3Parnet.children.push(item)
            }
        }
    }

    var hrResumetMenu = avalon.ui.hrResumetMenu = function (el, data, vmodels) {
        var model
            , ret = []
            , i = 0
            , item
            , tmp1 = '简历管理'
            , tmp2 = '面试管理'
            , tmp1Parnet = null
            , tmp2Parnet = null 
            , menus
        data.leftMenuId = 'hrResumetMenu'
        model = avalon.ui.leftMenu(el, data, vmodels)
        menus = avalon.mix(true, [], model.menus.$model)
        model.menus.removeAll()
        for (; item = menus[i++];) {
            if (item.id >= 6030310 && item.id <= 6030340) {
                if (!tmp1Parnet) {
                    tmp1Parnet = { id: 6031300, pIds: [6000000, 6030000], path: '', name: tmp1 , showChildren: false, children: [], selected: false, icon: 'sellpresent' }
                    model.menus.push(tmp1Parnet)
                    tmp1Parnet = model.menus[model.menus.size() - 1]
                }
                item.pIds.push(6031300)
                if (item.selected)
                    tmp1Parnet.showChildren = item.selected
                tmp1Parnet.children.push(item)
            } else if (item.id >= 6030350 && item.id <= 6030390) {
                if (!tmp2Parnet) {
                    tmp2Parnet = { id: 6032300, pIds: [6000000, 6030000], path: '', name: tmp2, showChildren: false, children: [], selected: false, icon: 'sellbrush' }
                    model.menus.push(tmp2Parnet)
                    tmp2Parnet = model.menus[model.menus.size() - 1]
                }
                item.pIds.push(6032300)
                if (item.selected)
                    tmp2Parnet.showChildren = item.selected
                tmp2Parnet.children.push(item)
            } else {
                model.menus.push(item)
            }
        }
    }

    //var productStorageMenu = avalon.ui.productStorageMenu = function (el, data, vmodels) {
    //    var model
    //        , ret = []
    //        , i = 0
    //        , item
    //        , tmp1 = '仓库盘点'
    //        , tmp2 = '库存预警'
    //        , tmp1Parnet = null
    //        , tmp2Parnet = null
    //        , menus
    //    data.leftMenuId = 'productStorageMenu'
    //    model = avalon.ui.leftMenu(el, data, vmodels)
    //    menus = avalon.mix(true, [], model.menus.$model)
    //    model.menus.removeAll()
    //    for (; item = menus[i++];) {
    //        if (item.id >= 5068000 && item.id <= 5068900) {
    //            if (!tmp1Parnet) {
    //                tmp1Parnet = { id: 5068000, pIds: [5000000, 5060000], path: '', name: tmp1, showChildren: false, children: [], selected: false, icon: 'sellpresent' }
    //                model.menus.push(tmp1Parnet)
    //                tmp1Parnet = model.menus[model.menus.size() - 1]
    //            }
    //            item.pIds.push(5068000)
    //            if (item.selected)
    //                tmp1Parnet.showChildren = item.selected
    //            tmp1Parnet.children.push(item)
    //        } else if (item.id >= 5069000 && item.id <= 5069900) {
    //            if (!tmp2Parnet) {
    //                tmp2Parnet = { id: 5069000, pIds: [5000000, 5060000], path: '', name: tmp2, showChildren: false, children: [], selected: false, icon: 'sellbrush' }
    //                model.menus.push(tmp2Parnet)
    //                tmp2Parnet = model.menus[model.menus.size() - 1]
    //            }
    //            item.pIds.push(5069000)
    //            if (item.selected)
    //                tmp2Parnet.showChildren = item.selected
    //            tmp2Parnet.children.push(item)
    //        } else {
    //            model.menus.push(item)
    //        }
    //    }
    //}

    return avalon
})