﻿/// <reference path="AllModule.js" />
define(function () {
    return [{ id: 100, name: '桌面', method: 'GET', path: '/Home/Index', pIds: '', icon: 'Home', selected: true }
                , { id: 1000000, name: '客户', method: 'GET', path: '/Customer/Index', pIds: '', icon: '', selected: false }
                , { id: 2000000, name: '市场', method: 'GET', path: '/Market/Index', pIds: '', icon: '', selected: false }
                , { id: 3000000, name: '服务', method: 'GET', path: '/Services/Index', pIds: '', icon: '', selected: false }
                , { id: 4000000, name: '内部办公', method: 'GET', path: '/Office/Index', pIds: '', icon: '', selected: false }
                , { id: 5000000, name: '产品', method: 'GET', path: '/Product/Index', pIds: '', icon: '', selected: false }
                , { id: 6000000, name: '人事', method: 'GET', path: '/HR/Index', pIds: '', icon: '', selected: false }
                , { id: 8000000, name: '知识', method: 'GET', path: '/Knowledge/Index', pIds: '', icon: '', selected: false }
                , { id: 7000000, name: '财务', method: 'GET', path: '/FinancialAffairs/Index', pIds: '', icon: '', selected: false }
                , { id: 100000000, name: '统计分析', method: 'GET', path: '/Report/Index', pIds: '', icon: '', selected: false }

                , { id: 900, name: '工具', method: 'GET', path: '/Tools/Index', pIds: '', icon: '', selected: false }

               , { id: 9000000, name: '设置', method: 'GET', path: '/Setting/Index', pIds: '', icon: '', selected: false }
                , { id: 101, name: '我的桌面', method: 'GET', path: '/Home/Index', pIds: [100], icon: 'desktop', selected: true }
                , { id: 1010000, name: '客户工作台', method: 'GET', path: '/Customer/Index', pIds: [1000000], icon: 'desktop', selected: true }
                , { id: 1020000, name: '全部客户', method: 'GET', path: '/Customer/All', pathRule: '/Customer/All/(:id)', pIds: [1000000], icon: 'allcustomer', selected: false }
                , { id: 1020000, name: '全部客户', method: 'GET', path: '/Customer/All', pathRule: '/Customer/All/(:id)/(:action)', pIds: [1000000], icon: 'allcustomer', selected: false, isAction: true }
                //, { id: 1020200, name: '潜在客户', method: 'GET', path: '/Customer/Latent', pIds: [1000000, 1020000], icon: 'custlatent', selected: false }
                , { id: 1020100, name: '终端客户', method: 'GET', path: '/Customer/Official', pIds: [1000000, 1020000], icon: 'custofficial', selected: false }
                , { id: 1020300, name: '合作伙伴', method: 'GET', path: '/Customer/Collaborate', pIds: [1000000, 1020000], icon: 'custcooperat', selected: false }
                , { id: 1020400, name: '渠道代理商', method: 'GET', path: '/Customer/Channel', pIds: [1000000, 1020000], icon: 'custagency', selected: false }
                , { id: 1020500, name: '供应商', method: 'GET', path: '/Customer/Supply', pIds: [1000000, 1020000], icon: 'custsupply', selected: false }
                , { id: 1020600, name: '媒体资源', method: 'GET', path: '/Customer/Advertising', pIds: [1000000, 1020000], icon: 'custmedia', selected: false }
                , { id: 1020700, name: '竞争对手', method: 'GET', path: '/Customer/Competitor', pIds: [1000000, 1020000], icon: 'custcompete', selected: false }
                , { id: 1020800, name: '社会关系', method: 'GET', path: '/Customer/Sociall', pIds: [1000000, 1020000], icon: 'custsocial', selected: false }
                , { id: 102, name: '新增客户', method: 'GET', path: '', pIds: [], icon: 'add', selected: false, isAction: true }
                , { id: 1020102, name: '新增终端客户', method: 'GET', path: '/Customer/AddCustomer', pIds: [1000000, 1020000, 102], isAction: true, icon: 'add', selected: false }
                , { id: 1020302, name: '新增合作伙伴', method: 'GET', path: '/Customer/AddCollaborate', pIds: [1000000, 1020000, 102], isAction: true, icon: 'add', selected: false }
                , { id: 1020402, name: '新增渠道代理商', method: 'GET', path: '/Customer/AddChannel', pIds: [1000000, 1020000, 102], isAction: true, icon: 'add', selected: false }
                , { id: 1020502, name: '新增供应商', method: 'GET', path: '/Customer/AddSupply', pIds: [1000000, 1020000, 102], isAction: true, icon: 'add', selected: false }
                , { id: 1020602, name: '新增媒体资源', method: 'GET', path: '/Customer/AddAdvertising', pIds: [1000000, 1020000, 102], isAction: true, icon: 'add', selected: false }
                , { id: 1020702, name: '新增竞争对手', method: 'GET', path: '/Customer/AddCompetitor', pIds: [1000000, 1020000, 102], isAction: true, icon: 'add', selected: false }
                , { id: 1020802, name: '新增社会关系', method: 'GET', path: '/Customer/AddSociall', pIds: [1000000, 1020000, 102], isAction: true, icon: 'add', selected: false }
                , { id: 200, name: '编辑客户', method: 'GET', path: '/Customer/EditCustomer/:id', pIds: [1000000, 1020000], isAction: true, icon: 'add', selected: false }
                , { id: 201, name: '编辑合作伙伴', method: 'GET', path: '/Customer/EditCollaborate/:id', pIds: [1000000, 1020000], isAction: true, icon: 'add', selected: false }
                , { id: 202, name: '编辑渠道代理商', method: 'GET', path: '/Customer/EditChannel/:id', pIds: [1000000, 1020000], isAction: true, icon: 'add', selected: false }
                , { id: 203, name: '编辑供应商', method: 'GET', path: '/Customer/EditSupply/:id', pIds: [1000000, 1020000], isAction: true, icon: 'add', selected: false }
                , { id: 204, name: '编辑媒体资源', method: 'GET', path: '/Customer/EditAdvertising/:id', pIds: [1000000, 1020000], isAction: true, icon: 'add', selected: false }
                , { id: 205, name: '编辑竞争对手', method: 'GET', path: '/Customer/EditCompetitor/:id', pIds: [1000000, 1020000], isAction: true, icon: 'add', selected: false }
                , { id: 206, name: '编辑社会关系', method: 'GET', path: '/Customer/EditSociall/:id', pIds: [1000000, 1020000], isAction: true, icon: 'add', selected: false }
                , { id: 301, name: '查看客户详情', method: 'GET', path: '/Customer/DetailCustomer/(:id)/(:action)', pIds: [1000000, 1020000], isAction: true, icon: 'add', selected: false }
                , { id: 302, name: '查看客户证件', method: 'GET', path: '/Customer/DetailCredentials/(:id)', pIds: [1000000, 1020000], isAction: true, icon: 'add', selected: false }
                , { id: 304, name: '查看单条客户记事', method: 'GET', path: '/Customer/RecordDetails/(:id)/(:ation)/(:type)/(:name)', pIds: [1000000, 1020000], isAction: true, icon: 'add', selected: false }
                , { id: 305, name: '查看右侧标签', method: 'GET', path: '/Customer/RecordTag/(:id)/(:ation)/(:type)', pIds: [1000000, 1020000], isAction: true, icon: 'add', selected: false }
                , { id: 306, name: '查看右侧列表', method: 'GET', path: '/Customer/RecordList/(:id)/(:ation)/(:type)', pIds: [1000000, 1020000], isAction: true, icon: 'add', selected: false }
                , { id: 307, name: '客户树', method: 'GET', path: '/Customer/Tree/(:id)/(:ation)', pIds: [1000000, 1020000], isAction: true, icon: '', selected: false }
                , { id: 308, name: '客户分析', method: 'GET', path: '/Customer/Analysis/(:id)/(:ation)', pIds: [1000000, 1020000], isAction: true, icon: '', selected: false }
                , { id: 309, name: '客户动态', method: 'GET', path: '/Customer/CustomerDynamics/(:id)/(:ation)', pIds: [1000000, 1020000], isAction: true, icon: '', selected: false }
                , { id: 310, name: '享受价格', method: 'GET', path: '/Customer/PriceList/(:id)/(:ation)', pIds: [1000000, 1020000], isAction: true, icon: '', selected: false }

                //, { id: 303, name: '查看销售机会', method: 'GET', path: '/Customer/DetailSalesOpportunities/(:id)', pIds: [1000000, 1020000], isAction: true, icon: 'add', selected: false }
                //, { id: 303, name: '查看跟单报价', method: 'GET', path: '/Customer/DetailDocumentaryOffer/(:id)', pIds: [1000000, 1020000], isAction: true, icon: 'add', selected: false }

                , { id: 1030000, name: '联系人', method: 'GET', path: '/Customer/Contacts', pathRule: '/Customer/Contacts(/:id)', pIds: [1000000], icon: 'linkman', selected: false }
                , { id: 1030000, name: '联系人跳转', method: 'GET', path: '/Customer/Contacts', pathRule: '/Customer/Contacts/(:id)/(:action)', pIds: [1000000], icon: 'linkman', selected: false, isAction: true }
                //, { id: 1060000, name: '客户动态', method: 'GET', path: '/Customer/Dynamic', pathRule: '/Customer/Dynamic/(:id)', pIds: [1000000], icon: 'linkman', selected: false, isAction: true }
                , { id: 1050100, name: '历史归属', method: 'GET', path: '/Customer/Contacts', pathRule: '/Customer/History/:id', pIds: [1000000, 1020000], icon: 'custBelongto', selected: false, isAction: true }
                , { id: 1020900, name: '公海客户', method: 'GET', path: '/Customer/International', pIds: [1000000], icon: 'publiccustomer', selected: false }
                , { id: 1020990, name: '专管客户', method: 'GET', path: '/Customer/CenterExpert', pIds: [1000000], icon: 'specialcustomer', selected: false }
                , { id: 1040000, name: '客户分布图', method: 'GET', path: '/Customer/Map', pIds: [1000000], icon: 'distribution', selected: false }
                , { id: 2010000, name: '市场工作台', method: 'GET', path: '/Market/Index', pIds: [2000000], icon: 'desktop', selected: true }
                , { id: 2020000, name: '销售管理', method: 'GET', path: '/Market/Sales', pIds: [2000000], icon: 'sellmag', selected: false }
                , { id: 2020100, name: '营销战役', method: 'GET', path: '/Market/Campaign', pIds: [2000000, 2020000], icon: 'sellnewspaper', selected: false }
                , { id: 2020100, name: '营销战役', method: 'GET', path: '/Market/Campaign', pathRule: '/Market/Campaign/(:id)/(:action)', pIds: [2000000, 2020000], icon: 'sellnewspaper', selected: false, isAction: true }
                , { id: 2020200, name: '调查反馈', method: 'GET', path: '/Market/ProbeFeedback', pIds: [2000000, 2020000], icon: 'sellballoon', selected: false }
                , { id: 2020200, name: '调查反馈', method: 'GET', path: '/Market/ProbeFeedback', pathRule: '/Market/ProbeFeedback/(:id)/(:action)', pIds: [2000000, 2020000], icon: 'sellballoon', selected: false, isAction: true }
                , { id: 2020300, name: '市场活动', method: 'GET', path: '/Market/Activity', pIds: [2000000, 2020000], icon: 'sellbriefcase', selected: false }
                , { id: 2020300, name: '市场活动', method: 'GET', path: '/Market/Activity', pathRule: '/Market/Activity/(:id)/(:action)', pIds: [2000000, 2020000], icon: 'sellbriefcase', selected: false, isAction: true }
                , { id: 2020400, name: '销售机会', method: 'GET', path: '/Market/SalesOpportunities', pIds: [2000000, 2020000], icon: 'selluserbriefcase', selected: false }
                , { id: 2020400, name: '销售机会', method: 'GET', path: '/Market/SalesOpportunities', pathRule: '/Market/SalesOpportunities/(:id)/(:action)', pIds: [2000000, 2020000], icon: 'selluserbriefcase', selected: false, isAction: true }
                , { id: 2020500, name: '跟单报价', method: 'GET', path: '/Market/DocumentaryOffer', pIds: [2000000, 2020000], icon: 'selluserpage', selected: false }
                , { id: 2020500, name: '跟单报价', method: 'GET', path: '/Market/DocumentaryOffer', pathRule: '/Market/DocumentaryOffer/(:id)/(:action)', pIds: [2000000, 2020000], icon: 'selluserpage', selected: false, isAction: true }
                , { id: 2020600, name: '合同订单', method: 'GET', path: '/Market/Contract', pIds: [2000000, 2020000], icon: 'sellpage_paste', selected: false }
                , { id: 2020600, name: '合同订单', method: 'GET', path: '/Market/Contract', pathRule: '/Market/Contract/(:id)/(:action)', pIds: [2000000, 2020000], icon: 'sellpage_paste', selected: false, isAction: true }
                , { id: 2020700, name: '业务明细', method: 'GET', path: '/Market/ProductList', pathRule: '/Market/ProductList', pIds: [2000000, 2020000], icon: 'custorder', selected: false }
                , { id: 2020700, name: '业务明细', method: 'GET', path: '/Market/ProductList', pathRule: '/Market/ProductList/(:id)/(:action)', pIds: [2000000, 2020000], icon: 'custorder', selected: false, isAction: true }
                , { id: 2020800, name: '销售漏斗', method: 'GET', path: '/Market/SalesFunnel', pIds: [2000000, 2020000], icon: 'sellchourglass', selected: false }
                , { id: 2020900, name: '销售目标', method: 'GET', path: '', pIds: [2000000, 2020000], icon: 'sellchart', selected: false }
                , { id: 2020901, name: '设置目标', method: 'GET', path: '/Market/SaleTargetSet', pIds: [2000000, 2020000, 2020900], icon: 'viewreturnedtarget', selected: false }
                , { id: 2020902, name: '目标签约额', method: 'GET', path: '/Market/SignAContractMoney', pIds: [2000000, 2020000, 2020900], icon: 'viewreturnedtarget', selected: false }
                , { id: 2020903, name: '目标回款额', method: 'GET', path: '/Market/ReturnedMoney', pIds: [2000000, 2020000, 2020900], icon: 'viewreturnedtarget', selected: false }
                , { id: 2020904, name: '目标客户数', method: 'GET', path: '/Market/CustomerSaleTarget', pIds: [2000000, 2020000, 2020900], icon: 'viewreturnedtarget', selected: false }
                , { id: 2020905, name: '目标签单数', method: 'GET', path: '/Market/SignAContractSaleTarget', pIds: [2000000, 2020000, 2020900], icon: 'viewreturnedtarget', selected: false }
                , { id: 2030000, name: '渠道管理', method: 'GET', path: '/Market/Channel', pIds: [2000000], icon: 'sellchannel', selected: false }
                , { id: 2030100, name: '渠道政策', method: 'GET', path: '/Market/ChannelPolicy', pathRule: '/Market/ChannelPolicy/(:id)', pIds: [2000000, 2030000], icon: 'sellbriefcasebooks', selected: false }
                , { id: 2030200, name: '渠道开发维护', method: 'GET', path: '/Market/ChannelDevelop', pathRule: '/Market/ChannelDevelop/(:id)', pIds: [2000000, 2030000], icon: 'sellbriefcasewrench', selected: false }
                , { id: 2030300, name: '渠道订单', method: 'GET', path: '/Market/ChannelOrder', pIds: [2000000, 2030000], icon: 'sellbooksbriefcase', selected: false }
                , { id: 2030400, name: '代理商区域', method: 'GET', path: '/Market/ChannelArea', pIds: [2000000, 2030000], icon: 'sellbooksbriefcase', selected: false }
                , { id: 2040000, name: '广告宣传', method: 'GET', path: '/Market/AdvertisingMaterials', pIds: [2000000], icon: 'selladv', selected: false }
                , { id: 2040100, name: '广告素材', method: 'GET', path: '/Market/AdvertisingMaterials', pIds: [2000000, 2040000], icon: 'sellphotoalbum', selected: false }
                , { id: 2040200, name: '广告投放', method: 'GET', path: '/Market/AdvertisingList', pIds: [2000000, 2040000], icon: 'sellmegaphone', selected: false }
                , { id: 2050000, name: '物料管理', method: 'GET', path: '/Market/MaterialsGift', pIds: [2000000], icon: 'sellmateriel', selected: false }
                , { id: 2050100, name: '礼品/赠品列表', method: 'GET', path: '/Market/MaterialsGift', pathRule: '/Market/MaterialsGift/(:id)', pIds: [2000000, 2050000], icon: 'sellpresent', selected: false }
                , { id: 2050200, name: '礼品/赠品领用', method: 'GET', path: '/Market/MaterialsGiftUse/0/', pathRule: '/Market/MaterialsGiftUse/(:id)/(:name)', pIds: [2000000, 2050000], icon: 'sellpresent', selected: false }
                , { id: 2050300, name: '物料/印刷品列表', method: 'GET', path: '/Market/MaterialsOrPrint', pathRule: '/Market/MaterialsOrPrint/(:id)', pIds: [2000000, 2050000], icon: 'sellpresent', selected: false }
                , { id: 2050400, name: '物料/印刷品领用', method: 'GET', path: '/Market/MaterialsUse/0/', pathRule: '/Market/MaterialsUse/(:id)/(:name)', pIds: [2000000, 2050000], icon: 'sellpresent', selected: false }
                , { id: 2050500, name: '优惠劵列表', method: 'GET', path: '/Market/MaterialsCoupon', pathRule: '/Market/MaterialsCoupon/(:id)', pIds: [2000000, 2050000], icon: 'sellpresent', selected: false }
                , { id: 2050600, name: '优惠劵领用', method: 'GET', path: '/Market/MaterialsCouponUse/0/', pathRule: '/Market/MaterialsCouponUse/(:id)/(:name)', pIds: [2000000, 2050000], icon: 'sellpresent', selected: false }
                , { id: 3010000, name: '服务工作台', method: 'GET', path: '/Services/Index', pIds: [3000000], icon: 'desktop', selected: true }
                , { id: 3020000, name: '来电管理', method: 'GET', path: '/Services/Calls', pathRule: '/Services/Calls/(:id)', pIds: [3000000], icon: 'sertel', selected: false }
                , { id: 3020000, name: '来电管理', method: 'GET', path: '/Services/Calls', pathRule: '/Services/Calls/(:id)/(:action)', pIds: [3000000], icon: 'sertel', selected: false, isAction: true }
                , { id: 3030000, name: '回访关怀', method: 'GET', path: '/Services/FollowUp', pathRule: '/Services/FollowUp/(:id)', pIds: [3000000], icon: 'servisit', selected: false }
                , { id: 3030000, name: '回访关怀', method: 'GET', path: '/Services/FollowUp', pathRule: '/Services/FollowUp/(:id)/(:action)', pIds: [3000000], icon: 'servisit', selected: false, isAction: true }

                , { id: 3040000, name: '客户服务', method: 'GET', path: '/Services/CServices', pathRule: '/Services/CServices/(:id)', pIds: [3000000], icon: 'sercustomer', selected: false }
                , { id: 3040000, name: '客户服务', method: 'GET', path: '/Services/CServices', pathRule: '/Services/CServices/(:id)/(:action)', pIds: [3000000], icon: 'sercustomer', selected: false, isAction: true }
                , { id: 3050000, name: '客户投诉', method: 'GET', path: '/Services/Complaints', pathRule: '/Services/Complaints/(:id)/(:action)', pIds: [3000000], icon: 'sercustomer', selected: false, isAction: true }
                , { id: 3050000, name: '客户投诉', method: 'GET', path: '/Services/Complaints', pIds: [3000000], icon: 'sercustomer', selected: false }
                , { id: 4010000, name: '办公工作台', method: 'GET', path: '/Office/Index', pIds: [4000000], icon: 'desktop', selected: true }
                , { id: 4020000, name: '新闻中心', method: 'GET', path: '/Office/ArticlesIndex', pIds: [4000000], icon: 'officnews', selected: false }
                , { id: 4020010, name: '新闻管理', method: 'GET', path: '/Office/Articles', pIds: [4000000, 4020000, 4020010], icon1: 'newsLeftMenu', selected: false }
                , { id: 4020100, name: '全部新闻', method: 'GET', path: '/Office/All', pIds: [4000000, 4020000], icon1: 'newsLeftMenu', selected: false }
                , { id: 4020101, name: '新闻列表', method: 'GET', path: '/Office/ArticlesList', pathRule: '/Office/ArticlesList/', pIds: [4000000, 4020000], icon1: 'newsLeftMenu', selected: false }
                , { id: 4020101, name: '新闻列表', method: 'GET', path: '/Office/ArticlesList', pathRule: '/Office/ArticlesList/(:Tid)/(:key)', pIds: [4000000, 4020000], icon1: 'newsLeftMenu', selected: false, isAction: true }
                , { id: 4020011, name: '新闻详情', method: 'GET', path: '/Office/ArticlesView', pathRule: '/Office/ArticlesView/(:id)', pIds: [4000000, 4020000], icon1: 'officnews', selected: false, isAction: true }
                , { id: 4020200, name: '分类管理', method: 'GET', path: '/Office/ArticlesType', pIds: [4000000, 4020000], icon1: 'newsLeftMenu', selected: false }
                //, { id: 4030000, name: '日程行动', method: 'GET', path: '/Office/Calendar/0/0/', pathRule: '/Office/Calendar/(:id)/(:cid)', pIds: [4000000], icon: 'officprogramme', selected: false }
                , { id: 4030000, name: '日程行动', method: 'GET', path: '/Office/CbCalendar', pIds: [4000000], icon: 'officprogramme', selected: false }
                , { id: 4030000, name: '日程行动', method: 'GET', path: '/Office/CbCalendar', pathRule: '/Office/CbCalendar/(:id)/(:action)', pIds: [4000000], icon: 'officprogramme', selected: false, isAction: true }
                , { id: 4040000, name: '工作报告', method: 'GET', path: '/Office/DailyReport', pathRule: '/Office/DailyReport/(:id)', pIds: [4000000], icon: 'officreport', selected: false }
                , { id: 4040000, name: '工作报告', method: 'GET', path: '/Office/DailyReport', pathRule: '/Office/DailyReport/(:id)/(:action)', pIds: [4000000], icon: 'officreport', selected: false, isAction: true }

                //, { id: 4050000, name: '物品资产', method: 'GET', path: '/Office/GoodsAssets', pIds: [4000000], icon: 'officreport', selected: true }
                //, { id: 4050100, name: '我的概况', method: 'GET', path: '/Office/GoodsAssets', pIds: [4000000, 4050000], icon: 'officreport', selected: true }
                //, { id: 4051000, name: '物品维护', method: 'GET', path: '/Office/GoodsList', pIds: [4000000, 4050000], icon: 'officreport', selected: false }
                //, { id: 4051100, name: '库存盘点', method: 'GET', path: '/Office/GoodsInventory', pIds: [4000000, 4050000], icon: 'officreport', selected: false }
                //, { id: 4051200, name: '采购历史', method: 'GET', path: '/Office/GoodsPurchase', pIds: [4000000, 4050000], icon: 'officreport', selected: false }
                //, { id: 4051300, name: '采购入库', method: 'GET', path: '/Office/GoodsStorage', pIds: [4000000, 4050000], icon: 'officreport', selected: false }
                //, { id: 4051400, name: '领用历史', method: 'GET', path: '/Office/GoodsUses', pIds: [4000000, 4050000], icon: 'officreport', selected: false }
                //, { id: 4051500, name: '我的领用', method: 'GET', path: '/Office/GoodsMyUses', pIds: [4000000, 4050000], icon: 'officreport', selected: false }
                //, { id: 4051600, name: '物品选择', method: 'GET', path: '/Office/GoodsSelect', pIds: [4000000, 4050000], icon: 'officreport', selected: false }
                //, { id: 4051700, name: '采购单选择', method: 'GET', path: '/Office/GoodsPurchaseSelect', pIds: [4000000, 4050000], icon: 'officreport', selected: false }
                //, { id: 4053000, name: '书籍管理', method: 'GET', path: '/Office/Books', pIds: [4000000, 4050000], icon: 'tsgl_ico', selected: false }
                //, { id: 4054000, name: '借阅管理', method: 'GET', path: '/Office/BooksBorrow', pIds: [4000000, 4050000], icon: 'officreport', selected: false }
                //, { id: 4055000, name: '归还管理', method: 'GET', path: '/Office/BooksReturn', pathRule: '/Office/BooksReturn/(:id)/(:act)', pIds: [4000000, 4050000], icon: 'officreport', selected: false }
                //, { id: 4056100, name: '用车申请', method: 'GET', path: '/Office/CarApply', pIds: [4000000, 4050000], icon: 'officreport', selected: false }
                //, { id: 4056200, name: '派车管理', method: 'GET', path: '/Office/CarAppoint', pIds: [4000000, 4050000], icon: 'officreport', selected: false }
                //, { id: 4056300, name: '车辆使用信息', method: 'GET', path: '/Office/CarUsesInfo', pIds: [4000000, 4050000], icon: 'officreport', selected: false }
                //, { id: 4056400, name: '用车查询', method: 'GET', path: '/Office/CarUseSearch', pIds: [4000000, 4050000], icon: 'officreport', selected: false }
                //, { id: 4056500, name: '车辆保险', method: 'GET', path: '/Office/CarInsure', pIds: [4000000, 4050000], icon: 'officreport', selected: false }
                //, { id: 4056500, name: '车辆维修保养', method: 'GET', path: '/Office/CarService', pIds: [4000000, 4050000], icon: 'officreport', selected: false }
                //, { id: 4056500, name: '车辆档案', method: 'GET', path: '/Office/Car', pIds: [4000000, 4050000], icon: 'officreport', selected: false }
                //, { id: 4057000, name: '资产登记', method: 'GET', path: '/Office/FixedAssets', pIds: [4000000, 4050000], icon: 'officreport', selected: false }
                //, { id: 4057100, name: '我的资产', method: 'GET', path: '/Office/FixedAssetsMy', pIds: [4000000, 4050000], icon: 'officreport', selected: false }
                //, { id: 4057200, name: '资产领用', method: 'GET', path: '/Office/FixedAssetsUses', pIds: [4000000, 4050000], icon: 'officreport', selected: false }
                //, { id: 4057300, name: '资产归还', method: 'GET', path: '/Office/FixedAssetsReturn', pIds: [4000000, 4050000], icon: 'officreport', selected: false }
                //, { id: 4057400, name: '资产报修', method: 'GET', path: '/Office/FixedAssetsRepairs', pIds: [4000000, 4050000], icon: 'officreport', selected: false }
                //, { id: 4057500, name: '维修确认', method: 'GET', path: '/Office/FixedAssetsRepairsConfirm', pIds: [4000000, 4050000], icon: 'officreport', selected: false }
                //, { id: 4057600, name: '资产报废', method: 'GET', path: '/Office/FixedAssetsScrap', pIds: [4000000, 4050000], icon: 'officreport', selected: false }
                //, { id: 4057700, name: '资产报表', method: 'GET', path: '/Office/FixedAssetsReport', pIds: [4000000, 4050000], icon: 'officreport', selected: false }
                //, { id: 4057710, name: '资产台账', method: 'GET', path: '/Office/FixedAssetsAccount', pIds: [4000000, 4050000], icon: 'officreport', selected: false }
                //, { id: 4057710, name: '资产财务', method: 'GET', path: '/Office/FixedAssetsFinance', pIds: [4000000, 4050000], icon: 'officreport', selected: false }
                //, { id: 4057720, name: '资产当前流向', method: 'GET', path: '/Office/FixedAssetsFlowNow', pIds: [4000000, 4050000], icon: 'officreport', selected: false }
                //, { id: 4057720, name: '资产历史流向', method: 'GET', path: '/Office/FixedAssetsFlow', pIds: [4000000, 4050000], icon: 'officreport', selected: false }
                //, { id: 4057720, name: '资产折旧历史', method: 'GET', path: '/Office/FixedAssetsDepreciation', pIds: [4000000, 4050000], icon: 'officreport', selected: false }

                //, { id: 4057800, name: '后台设置', method: 'GET', path: '/Office/FixedAssetsSet', pIds: [4000000, 4050000], icon: 'officreport', selected: false }
                //, { id: 4057810, name: '资产初始化', method: 'GET', path: '/Office/FixedAssetsInit', pIds: [4000000, 4050000], icon: 'officreport', selected: false }
                //, { id: 4057820, name: '类别设置', method: 'GET', path: '/Office/FixedAssetsType', pIds: [4000000, 4050000], icon: 'officreport', selected: false }
                //, { id: 4057820, name: '资产选择', method: 'GET', path: '/Office/FixedAssetsSelect', pIds: [4000000, 4050000], icon: 'officreport', selected: false }
                , { id: 5010000, name: '产品工作台', method: 'GET', path: '/Product/Index', pIds: [5000000], icon: 'desktop', selected: true }
                , { id: 5020000, name: '产品管理', method: 'GET', path: '/Product/Product', pathRule: '/Product/Product/(:key)', pIds: [5000000], icon: 'prodmang', selected: false }
                , { id: 5070000, name: '产品列表', method: 'GET', path: '/Product/Product', pathRule: '/Product/Product/(:id)/(:action)', pIds: [5000000, 5020000], icon: '', icon1: 'sellbooksbriefcase', selected: false }
                , { id: 5080000, name: '价格列表', method: 'GET', path: '/Product/PriceList', pIds: [5000000, 5020000], icon: '', selected: false }
                , { id: 5030000, name: '产品分类', method: 'GET', path: '/Product/Category', pIds: [5000000, 5020000], icon: '', icon1: 'prodtype', selected: false }
                , { id: 5040000, name: '产品品牌', method: 'GET', path: '/Product/Brand', pathRule: '/Product/Brand/(:key)', pIds: [5000000, 5020000], icon: '', icon1: 'prodbrand', selected: false }
                , { id: 5050000, name: '采购管理', method: 'GET', path: '/Product/PurchaseEnquiry', pIds: [5000000], icon: 'prodprocure ', selected: false }
                , { id: 5051000, name: '采购询价', method: 'GET', path: '/Product/PurchaseEnquiry', pIds: [5000000, 5050000], icon: '', selected: false }
                , { id: 5052000, name: '采购订单', method: 'GET', path: '/Product/PurchaseOrder', pIds: [5000000, 5050000], icon: '', selected: false }
                , { id: 5052000, name: '采购订单', method: 'GET', path: '/Product/PurchaseOrder', pathRule: '/Product/PurchaseOrder/(:id)/(:action)', pIds: [5000000, 5050000], icon: '', selected: false, isAction: true }
                , { id: 5053000, name: '采购付款', method: 'GET', path: '/Product/PurchasePay', pIds: [5000000, 5050000], icon: '', selected: false }
                , { id: 5054000, name: '采购入库', method: 'GET', path: '/Product/PurchasePutStorage', pIds: [5000000, 5050000], icon: '', selected: false }
                , { id: 5055000, name: '采购退货', method: 'GET', path: '/Product/PurchaseReturned', pIds: [5000000, 5050000], icon: '', selected: false }
                , { id: 5060000, name: '库存管理', method: 'GET', path: '/Product/ProductStorage', pIds: [5000000], icon: 'prodstock', selected: false }
                , { id: 5061000, name: '仓库管理', method: 'GET', path: '/Product/ProductStorage', pIds: [5000000, 5060000], icon: '', selected: false }
                //放在库存状况, { id: 5062000, name: '期初库存', method: 'GET', path: '/Product/ProductStorageInitAdd', pIds: [5000000, 5060000], icon: '', selected: false }
                , { id: 5063000, name: '库存状况', method: 'GET', path: '/Product/ProductStorageList', pIds: [5000000, 5060000], icon: '', selected: false }
                , { id: 5064000, name: '产品库存分布', method: 'GET', path: '/Product/ProductStorageView', pIds: [5000000, 5060000], icon: '', selected: false }
                , { id: 5069500, name: '销售出库', method: 'GET', path: '/Product/ProductStorageSalesOut', pIds: [5000000, 5060000], icon: '', selected: false }
                , { id: 5069500, name: '销售出库', method: 'GET', path: '/Product/ProductStorageSalesOut', pathRule: '/Product/ProductStorageSalesOut/(:id)/(:action)', isAction: true, pIds: [5000000, 5060000], icon: '', selected: false }
                , { id: 5065000, name: '仓库调拔', method: 'GET', path: '/Product/ProductStorageTransfer', pIds: [5000000, 5060000], icon: '', selected: false }
                , { id: 5066000, name: '其它入库', method: 'GET', path: '/Product/ProductStorageOtherIn', pIds: [5000000, 5060000], icon: '', selected: false }
                , { id: 5067000, name: '其它出库', method: 'GET', path: '/Product/ProductStorageOtherOut', pIds: [5000000, 5060000], icon: '', selected: false }
                , { id: 5068000, name: '仓库盘点', method: 'GET', path: '', pIds: [5000000, 5060000], icon: '', selected: false }
                , { id: 5068100, name: '盘点记录', method: 'GET', path: '/Product/ProductStorageCheck', pIds: [5000000, 5060000, 5068000], icon: '', selected: false }
                , { id: 5068200, name: '盘点报盈', method: 'GET', path: '/Product/ProductStorageCheckGain', pIds: [5000000, 5060000, 5068000], icon: '', selected: false }
                , { id: 5068300, name: '盘点报亏', method: 'GET', path: '/Product/ProductStorageCheckLoss', pIds: [5000000, 5060000, 5068000], icon: '', selected: false }
                , { id: 5069000, name: '库存预警', method: 'GET', path: '', pIds: [5000000, 5060000], icon: '', selected: false }
                , { id: 5069100, name: '库存上限报警', method: 'GET', path: '/Product/ProductStorageMaxWarn', pIds: [5000000, 5060000, 5069000], icon: '', selected: false }
                , { id: 5069200, name: '库存下限报警', method: 'GET', path: '/Product/ProductStorageMinWarn', pIds: [5000000, 5060000, 5069000], icon: '', selected: false }

                , { id: 6010000, name: '人事工作台', method: 'GET', path: '/HR/Index', pIds: [6000000], icon: 'desktop', selected: true }
                , { id: 6020000, name: '人资规划', method: 'GET', path: '/HR/Planning', pIds: [6000000], icon: 'planning', selected: false }
                , { id: 6020100, name: '规划制定', method: 'GET', path: '/HR/Planning', pIds: [6000000, 6020000], icon: '', selected: false }
                , { id: 6020200, name: '架构设计', method: 'GET', path: '/HR/HROrganization', pIds: [6000000, 6020000], icon: '', selected: false }
                , { id: 6020300, name: '职位拟编', method: 'GET', path: '/HR/HRPost', pathRule: '/HR/HRPost/(:key)', pIds: [6000000, 6020000], icon: '', selected: false }
                , { id: 6030000, name: '招聘管理', method: 'GET', path: '/HR/Recruitment', pIds: [6000000], icon: 'train1', selected: false }
                , { id: 6030100, name: '招聘计划', method: 'GET', path: '/HR/Recruitment', pIds: [6000000, 6030000], icon: 'Recruitment', selected: false }
                , { id: 6030200, name: '招聘职位', method: 'GET', path: '/HR/RecruitPost', pIds: [6000000, 6030000], icon: 'Recruitment', selected: false }
                //, { id: 6030300, name: '简历管理', method: 'GET', path: '/HR/Resume', pIds: [6000000, 6030000], icon: 'Recruitment', selected: false }
                , { id: 6030310, name: '简历库', method: 'GET', path: '/HR/Resume', pIds: [6000000, 6030000], icon: 'Recruitment', selected: false }
                , { id: 6030310, name: '简历库', method: 'GET', path: '/HR/Resume', pathRule: '/HR/Resume/(:id)/(:action)', pIds: [6000000, 6030000], icon: 'Recruitment', selected: false, isAction: true }
                , { id: 6030320, name: '拟面试', method: 'GET', path: '/HR/ResumePlan', pIds: [6000000, 6030000], icon: 'Recruitment', selected: false }
                , { id: 6030330, name: '备用人才', method: 'GET', path: '/HR/ResumeStore', pIds: [6000000, 6030000], icon: 'Recruitment', selected: false }
                , { id: 6030340, name: '不予考虑', method: 'GET', path: '/HR/ResumeWithout', pIds: [6000000, 6030000], icon: 'Recruitment', selected: false }
                , { id: 6030350, name: '面试库', method: 'GET', path: '/HR/ResumeAudition', pIds: [6000000, 6030000], icon: 'Recruitment', selected: false }
                , { id: 6030360, name: '复试库', method: 'GET', path: '/HR/ResumeReexamine', pIds: [6000000, 6030000], icon: 'Recruitment', selected: false }
                , { id: 6030370, name: '拟录用', method: 'GET', path: '/HR/ResumeHire', pIds: [6000000, 6030000], icon: 'Recruitment', selected: false }
                , { id: 6030380, name: '已入职', method: 'GET', path: '/HR/ResumeJoin', pIds: [6000000, 6030000], icon: 'Recruitment', selected: false }
                , { id: 6030390, name: '不予录用', method: 'GET', path: '/HR/ResumeNoHire', pIds: [6000000, 6030000], icon: 'Recruitment', selected: false }

                , { id: 6040000, name: '培训管理', method: 'GET', path: '/HR/TrainPlan', pIds: [6000000], icon: 'train1', selected: false }
                , { id: 6040100, name: '培训计划', method: 'GET', path: '/HR/TrainPlan', pIds: [6000000, 6040000], icon: 'personnelplan', selected: false }
                , { id: 6040200, name: '培训记录', method: 'GET', path: '/HR/TrainRecord', pathRule: '/HR/TrainRecord/(:id)', pIds: [6000000, 6040000], icon: 'personneltake', selected: false }

                , { id: 6060000, name: '绩效管理', method: 'GET', path: '/HR/Reward', pIds: [6000000], icon: 'performance', selected: true }
                , { id: 6060100, name: '奖惩记录', method: 'GET', path: '/HR/Reward', pIds: [6000000, 6060000], icon: '', selected: false }
                , { id: 6060100, name: '奖惩记录', method: 'GET', path: '/HR/Reward', pathRule: '/HR/Reward/(:id)/(:action)', pIds: [6000000, 6060000], icon: '', selected: false, isAction: true }
                , { id: 6060200, name: '积分明细', method: 'GET', path: '/HR/Integral', pIds: [6000000, 6060000], icon: '', selected: false }
                , { id: 6060200, name: '积分明细', method: 'GET', path: '/HR/Integral', pathRule: '/HR/Integral/(:id)/(:action)', pIds: [6000000, 6060000], icon: '', selected: false, isAction: true }
                , { id: 6060300, name: '考勤管理', method: 'GET', path: '#', pIds: [6000000, 6060000], icon: '', selected: false }
                , { id: 6060310, name: '考勤签到', method: 'GET', path: '/HR/CheckInList', pIds: [6000000, 6060000, 6060300], icon: '', selected: false }
                , { id: 6060320, name: '考勤统计', method: 'GET', path: '/HR/CheckInAnalysis', pIds: [6000000, 6060000, 6060300], icon: '', selected: false }
                , { id: 6060330, name: '员工位置', method: 'GET', path: '/HR/UserTrack', pIds: [6000000, 6060000, 6060300], icon: '', selected: false }

                , { id: 6050000, name: '员工关系', method: 'GET', path: '/HR/Archive', pIds: [6000000], icon: 'labour', selected: true }
                , { id: 6050100, name: '员工档案', method: 'GET', path: '/HR/Archive', pathRule: '/HR/Archive/(:id)', pIds: [6000000, 6050000], icon: 'personnelfiles', selected: false }
                , { id: 6050100, name: '员工档案', method: 'GET', path: '/HR/Archive', pathRule: '/HR/Archive/(:id)/(:action)', pIds: [6000000, 6050000], icon: 'personnelfiles', selected: false, isAction: true }
                , { id: 6050200, name: '人事合同', method: 'GET', path: '/HR/LabourContract', pathRule: '/HR/LabourContract/(:id)', pIds: [6000000, 6050000], icon: 'personnelwork', selected: false }
                , { id: 6050200, name: '人事合同', method: 'GET', path: '/HR/LabourContract', pathRule: '/HR/LabourContract/(:id)/(:key)', pIds: [6000000, 6050000], icon: 'personnelwork', selected: false, isAction: true }
                , { id: 6050300, name: '人事调动', method: 'GET', path: '/HR/PostChange', pathRule: '/HR/PostChange/(:id)', pIds: [6000000, 6050000], icon: 'personnelmove', selected: false }
                , { id: 6050300, name: '人事调动', method: 'GET', path: '/HR/PostChange', pathRule: '/HR/PostChange/(:id)/(:key)', pIds: [6000000, 6050000], icon: 'personnelmove', selected: false, isAction: true }
                , { id: 6050400, name: '员工沟通', method: 'GET', path: '/HR/Communication', pathRule: '/HR/Communication/(:id)', pIds: [6000000, 6050000], icon: 'personnelLinkup', selected: false }
                , { id: 6050400, name: '员工沟通', method: 'GET', path: '/HR/Communication', pathRule: '/HR/Communication/(:id)/(:key)', pIds: [6000000, 6050000], icon: 'personnelLinkup', selected: false, isAction: true }

                //, { id: 6060200, name: '积分明细', method: 'GET', path: '/HR/Reward', pIds: [6000000, 6060000], icon: 'personneltake', selected: false }

                , { id: 7010000, name: '财务概况', method: 'GET', path: '/FinancialAffairs/Index', pIds: [7000000], icon: 'desktop', selected: true }
                , { id: 7020000, name: '收支记账', method: 'GET', path: '/FinancialAffairs/Accounting', pathRule: '/FinancialAffairs/Accounting/(:id)', pIds: [7000000], icon: 'cw_sz', selected: false }
                , { id: 7020000, name: '收支记账', method: 'GET', path: '/FinancialAffairs/Accounting', pathRule: '/FinancialAffairs/Accounting/(:id)/(:action)', pIds: [7000000], icon: 'cw_sz', selected: false, isAction: true }
                , { id: 7020000, name: '收支记账', method: 'GET', path: '/FinancialAffairs/Accounting', pathRule: '/FinancialAffairs/Accounting/(:id)/(:action)/(:cid)/(:mid)', pIds: [7000000], icon: 'cw_sz', selected: false, isAction: true }
                , { id: 7030000, name: '开票记录', method: 'GET', path: '/FinancialAffairs/Bill', pathRule: '/FinancialAffairs/Bill/(:id)', pIds: [7000000], icon: 'cw_pj', selected: false }
                , { id: 7030000, name: '开票记录', method: 'GET', pewath: '/FinancialAffairs/Bill', pathRule: '/FinancialAffairs/Bill/(:id)/(:action)', pIds: [7000000], icon: 'cw_pj', selected: false, isAction: true }
                , { id: 7040000, name: '基本资料', method: 'GET', path: '/FinancialAffairs/Settings', pathRule: '/FinancialAffairs/Settings/(:id)', pIds: [7000000], icon: 'cw_zh', selected: false }
                , { id: 7040000, name: '基本资料', method: 'GET', path: '/FinancialAffairs/Settings', pathRule: '/FinancialAffairs/Settings/(:id)/(:action)', pIds: [7000000], icon: 'cw_zh', selected: false, isAction: true }
                , { id: 7050000, name: '应收应付', method: 'GET', path: '/FinancialAffairs/ARAPCollect', pIds: [7000000], icon: 'cw_pj', selected: false }
                , { id: 7051000, name: '应收款', method: 'GET', path: '/FinancialAffairs/ARAPCollect',  pIds: [7000000, 7050000], icon: '', selected: false,isAction:true }
                , { id: 7051000, name: '应收款', method: 'GET', path: '/FinancialAffairs/ARAPCollect', pathRule: '/FinancialAffairs/ARAPCollect/(:id)/(:action)', pIds: [7000000, 7050000], icon: '', selected: false }
                , { id: 7052000, name: '应付款', method: 'GET', path: '/FinancialAffairs/ARAPPay', pIds: [7000000, 7050000], icon: '', selected: false }
                , { id: 7052000, name: '应付款', method: 'GET', path: '/FinancialAffairs/ARAPPay', pathRule: '/FinancialAffairs/ARAPPay/(:id)/(:action)', pIds: [7000000, 7050000], icon: '', isAction: true }
                , { id: 7053000, name: '查看应收应付', method: 'GET', path: '/FinancialAffairs/ARAP', pathRule: '/FinancialAffairs/ARAP/(:id)/(:action)', pIds: [7000000, 7050000], icon: '', isAction: true }
                //知识
                , { id: 8010000, name: '知识管理', method: 'GET', path: '/Knowledge/Index', pIds: [8000000], icon: 'knowledge', selected: true }
                , { id: 8010100, name: '知识管理', method: 'GET', path: '/Knowledge/Index', pIds: [8000000, 8010000], icon: '', selected: true }
                , { id: 8020000, name: '知识分类', method: 'GET', path: '/Knowledge/Category', pIds: [8000000, 8010000], icon: '', selected: false }
                , { id: 8030000, name: '文档资料', method: 'GET', path: '/Knowledge/Documents', pIds: [8000000], icon: 'documents', selected: false }
                , { id: 8030100, name: '文档资料', method: 'GET', path: '/Knowledge/Documents', pIds: [8000000, 8030000], icon: '', selected: false }
                , { id: 8040000, name: '文档分类', method: 'GET', path: '/Knowledge/DocCategory', pIds: [8000000, 8030000], icon: '', selected: false }

                , { id: 9010000, name: '系统设置', method: 'GET', path: '/Settings/DetailCompanyInfo', pIds: [9000000], icon: 'sysset', selected: false }
                , { id: 9030000, name: '数据字典', method: 'GET', path: '/Settings/Dictionary', pIds: [9000000], icon: 'dictionary', selected: false }
                , { id: 9040000, name: '组织架构', method: 'GET', path: '/Settings/Organization', pIds: [9000000], icon: 'organization', selected: false }
                , { id: 9050000, name: '角色权限', method: 'GET', path: '/Settings/Permission', pIds: [9000000], icon: 'power', selected: false }
                , { id: 9060000, name: '用户管理', method: 'GET', path: '/Settings/Users', pIds: [9000000], icon: 'user', selected: false }
                , { id: 9060000, name: '用户跳转', method: 'GET', path: '/Settings/Users', pathRule: '/Settings/Users/(:id)/(:action)', isAction: true, pIds: [], icon: 'user', selected: false }

               , { id: 9070000, name: '接口设置', method: 'GET', path: '/Settings/InterfaceSettings', pIds: [9000000], icon: 'port', selected: false }
                , { id: 9070100, name: '短信接口设置', method: 'GET', path: '/Settings/InterfaceSettings', pIds: [9000000, 9070000], icon: 'sysphone', selected: false }
                , { id: 9070200, name: '电子邮件设置', method: 'GET', path: '/Settings/EmailInterface', pIds: [9000000, 9070000], icon: 'sysemail', selected: false }
                , { id: 9070300, name: '超博网接口', method: 'GET', path: '/Settings/CBInterface', pIds: [9000000, 9070000], icon: 'sysvcb', selected: false }
                , { id: 9070400, name: '公司网站接口', method: 'GET', path: '/Settings/CompanyInterface', pIds: [9000000, 9070000], icon: 'syswebinface', selected: false }
                , { id: 9070500, name: '来电弹屏', method: 'GET', path: '/Settings/CallInterface', pIds: [9000000, 9070000], icon: 'sysTel', selected: false }

                , { id: 9090000, name: '数据库备份', method: 'GET', path: '/Settings/DatabaseBackup', pIds: [9000000], icon: 'databak', selected: false }
                , { id: 9200000, name: '自定义', method: 'GET', path: '/Settings/ExpandoField', pIds: [9000000], icon: 'expando', selected: false }
                , { id: 9100000, name: '回收站', method: 'GET', path: '/Settings/RecycleBinCustomer', pIds: [9000000], icon: 'recycle', selected: false }
                , { id: 9101000, name: '客户回收站', method: 'GET', path: '/Settings/RecycleBinCustomer', pIds: [9000000,9100000], icon: '', selected: false }
                , { id: 9200100, name: '自定义字段', method: 'GET', path: '/Settings/ExpandoField', pIds: [9000000, 9200000], icon: '', selected: false }
                , { id: 9110000, name: '单位信息', method: 'GET', path: '/Settings/DetailCompanyInfo', pIds: [9000000, 9010000], icon: 'sysInfo', selected: false }
                , { id: 9120000, name: '全局设置', method: 'GET', path: '/Settings/SiteGolbal', pIds: [9000000, 9010000], icon: 'sysModule', selected: false }
                , { id: 9130000, name: '客户模块设置', method: 'GET', path: '#', pIds: [9000000, 9010000], icon: 'sysModule', selected: false }
                , { id: 9131000, name: '基础设置', method: 'GET', path: '/Settings/CustomerSettings', pIds: [9000000, 9010000, 9130000], icon: 'sysModule', selected: false }
                , { id: 9133000, name: '客户记事设置', method: 'GET', path: '/Settings/RecordSettings', pIds: [9000000, 9010000, 9130000], icon: 'sysModule', selected: false }
                , { id: 9150000, name: '办公模块设置', method: 'GET', path: '/Settings/OfficeSettings', pIds: [9000000, 9010000], icon: 'sysModule', selected: false }
                 , { id: 9160000, name: '人事模块设置', method: 'GET', path: '#', pIds: [9000000, 9010000], icon: 'sysModule', selected: false }
                , { id: 9161000, name: '考勤时间设置', method: 'GET', path: '/Settings/CheckInTime', pIds: [9000000, 9010000, 9160000], icon: 'sysModule', selected: false }
                , { id: 9162000, name: '考勤地点设置', method: 'GET', path: '/Settings/CheckInArea', pIds: [9000000, 9010000, 9160000], icon: 'sysModule', selected: false }


                , { id: 9020000, name: '附件管理', method: 'GET', path: '/Upload/Center', pIds: [9000000, 9010000], icon1: 'moreupload', selected: false }
                , { id: 9080000, name: '系统日志', method: 'GET', path: '#', pIds: [9000000, 9010000], icon1: 'log', selected: false }
                , { id: 9080100, name: '登录日志', method: 'GET', path: '/Settings/LoginLogs', pIds: [9000000, 9010000, 9080000], icon: 'log', selected: false }
                , { id: 9080200, name: '操作日志', method: 'GET', path: '/Settings/ActionLogs', pIds: [9000000, 9010000, 9080000], icon: 'log', selected: false }
                , { id: 9080300, name: '应用程序日志', method: 'GET', path: '/Settings/APPLogs', pIds: [9000000, 9010000, 9080000], icon: 'log', selected: false }
                , { id: 9140000, name: '权限设置', method: 'GET', path: '/Settings/Authorize/:id', pIds: [9000000, 1150], icon: 'add' }

                , { id: 9901000, name: '工具工作台', method: 'GET', path: '/Tools/Index', pIds: [900], icon: 'toolsdesk', selected: true }
                , { id: 9902000, name: '数据导入', method: 'GET', path: '/Tools/Import', pIds: [900], icon: 'toolsimport', selected: false }
                , { id: 9903000, name: '通讯工具', method: 'GET', path: '/Tools/Message', pIds: [900], icon: 'toolsmessage', selected: false }
                , { id: 9903001, name: '手机短信', method: 'GET', path: '/Tools/Message', pIds: [900, 9903000], icon1: 'toolsmessage', selected: false }
                , { id: 9903001, name: '手机短信', method: 'GET', path: '/Tools/Message', pathRule: '/Tools/Message/(:id)/(:action)', pIds: [900, 9903000], icon1: 'toolsmessage', selected: false, isAction: true }
                , { id: 9903002, name: '邮件信息', method: 'GET', path: '/Tools/Email', pIds: [900, 9903000], icon1: 'toolsemail', selected: false }
                , { id: 9903002, name: '邮件信息', method: 'GET', path: '/Tools/Email', pathRule: '/Tools/Email/(:id)/(:action)', pIds: [900, 9903000], icon1: 'toolsemail', selected: false, isAction: true }
                , { id: 9904000, name: '模板管理', method: 'GET', path: '#', pIds: [900, 9903000], icon: '', selected: false }
                , { id: 9904100, name: '内容管理', method: 'GET', path: '/Tools/MessageTmpl', pIds: [900, 9903000, 9904000], icon: '', selected: false }
                , { id: 9904200, name: '分类管理', method: 'GET', path: '/Tools/MessageTmplCategory', pIds: [900, 9903000, 9904000], icon: '', selected: false }
                //报表菜单
                , { id: 101000000, name: '运营概况', method: 'GET', path: '/Report/Index', pIds: [100000000], icon: 'desktop', selected: false }
                , { id: 101000010, name: '个人概况', method: 'GET', path: '/Report/Index', pIds: [100000000, 101000000], icon: 'desktop', selected: false }
                , { id: 101000020, name: '企业概况', method: 'GET', path: '/Report/CIndex', pIds: [100000000, 101000000], icon: 'desktop', selected: false }

                , { id: 102000000, name: '业绩排行榜', method: 'GET', path: '/Report/Results', pIds: [100000000], icon: 'Results', selected: false }

                , { id: 102010000, name: '人事.绩效.综合', method: 'GET', path: '#', pIds: [100000000, 102000000], icon: '', selected: false }
                , { id: 102000010, name: '拥有客户最多的员工', method: 'GET', path: '/Report/MaxCustomer', pIds: [100000000, 102000000, 102010000], icon: '', selected: false }
                , { id: 102000020, name: '签单最多的员工', method: 'GET', path: '/Report/MaxSignBill', pIds: [100000000, 102000000, 102010000], icon: '', selected: false }
                , { id: 102000030, name: '入职最长时间的员工', method: 'GET', path: '/Report/MaxOnJob', pIds: [100000000, 102000000, 102010000], icon: '', selected: false }
                , { id: 102000040, name: '流失老客户最多的员工', method: 'GET', path: '/Report/MaxDrainCustomer', pIds: [100000000, 102000000, 102010000], icon: '', selected: false }
                , { id: 102000050, name: '跟单失败最多的员工', method: 'GET', path: '/Report/MaxFailCustomer', pIds: [100000000, 102000000, 102010000], icon: '', selected: false }

                , { id: 102020000, name: '客户', method: 'GET', path: '#', pIds: [100000000, 102000000], icon: '', selected: false }
                , { id: 102000060, name: '购买次数最多的客户', method: 'GET', path: '/Report/MaxBuyCount', pIds: [100000000, 102000000, 102020000], icon: '', selected: false }
                , { id: 102000070, name: '购买金额最大的客户', method: 'GET', path: '/Report/MaxBuyMoney', pIds: [100000000, 102000000, 102020000], icon: '', selected: false }

                , { id: 102030000, name: '市场', method: 'GET', path: '#', pIds: [100000000, 102000000], icon: '', selected: false }
                , { id: 102000080, name: '价格最高的跟单报价', method: 'GET', path: '/Report/MaxDocumentary', pIds: [100000000, 102000000,102030000], icon: '', selected: false }
                , { id: 102000090, name: '金额最大的合同订单', method: 'GET', path: '/Report/MaxOrders', pIds: [100000000, 102000000,102030000], icon: '', selected: false }
                , { id: 102000100, name: '合同数量最多的类型', method: 'GET', path: '/Report/MaxOrdersCategory', pIds: [100000000, 102000000,102030000], icon: '', selected: false }
                , { id: 102000101, name: '机会最多的销售阶段', method: 'GET', path: '/Report/MaxSales', pIds: [100000000, 102000000,102030000], icon: '', selected: false }

                , { id: 102040000, name: '服务', method: 'GET', path: '#', pIds: [100000000, 102000000], icon: '', selected: false }
                , { id: 102000102, name: '来电最多的客户', method: 'GET', path: '/Report/MaxCalls', pIds: [100000000, 102000000, 102040000], icon: '', selected: false }
                , { id: 102000103, name: '投诉最多的客户', method: 'GET', path: '/Report/MaxComplaints', pIds: [100000000, 102000000, 102040000], icon: '', selected: false }
                , { id: 102000104, name: '服务最多的客户', method: 'GET', path: '/Report/MaxCusServices', pIds: [100000000, 102000000, 102040000], icon: '', selected: false }
                , { id: 102000105, name: '关怀最多的客户', method: 'GET', path: '/Report/MaxFollowup', pIds: [100000000, 102000000, 102040000], icon: '', selected: false }
                , { id: 102000106, name: '被投诉最多的员工', method: 'GET', path: '/Report/ComplaintsEmp', pIds: [100000000, 102000000, 102040000], icon: '', selected: false }
                , { id: 102000111, name: '客户服务次数top10分析', method: 'GET', path: '/Report/ServeTop', pIds: [100000000, 102000000, 102040000], icon: '', selected: false }
                , { id: 102000112, name: '客户投诉次数top10分析', method: 'GET', path: '/Report/ComplainTop', pIds: [100000000, 102000000, 102040000], icon: '', selected: false }
                , { id: 102000113, name: '回访客户次数top10分析', method: 'GET', path: '/Report/ReplyTop', pIds: [100000000, 102000000, 102040000], icon: '', selected: false }
                , { id: 102000114, name: '来电客户次数top10分析', method: 'GET', path: '/Report/CallTop', pIds: [100000000, 102000000, 102040000], icon: '', selected: false }

                , { id: 102050000, name: '财务', method: 'GET', path: '#', pIds: [100000000, 102000000], icon: '', selected: false }
                , { id: 102000107, name: '收入最高的业务', method: 'GET', path: '/Report/MaxBusiness', pIds: [100000000, 102000000, 102050000], icon: '', selected: false }
                , { id: 102000108, name: '收入最高的月份', method: 'GET', path: '/Report/MaxMonth', pIds: [100000000, 102000000, 102050000], icon: '', selected: false }

                , { id: 102060000, name: '产品', method: 'GET', path: '#', pIds: [100000000, 102000000], icon: '', selected: false }
                , { id: 102000109, name: '价格最高的产品', method: 'GET', path: '/Report/MaxProducts', pIds: [100000000, 102000000, 102060000], icon: '', selected: false }
                , { id: 102000110, name: '库存最多的产品', method: 'GET', path: '/Report/MaxStock', pIds: [100000000, 102000000, 102060000], icon: '', selected: false }
                , { id: 102000115, name: '产品销量前十', method: 'GET', path: '/Report/ProductTopBuy', pIds: [100000000, 102000000, 102060000], icon: '', selected: false }
                , { id: 102000116, name: '产品贡献收入金额前十', method: 'GET', path: '/Report/ProductTopMoney', pIds: [100000000, 102000000, 102060000], icon: '', selected: false }
                , { id: 102000117, name: '产品被投诉前十', method: 'GET', path: '/Report/ProductTopComplain', pIds: [100000000, 102000000, 102060000], icon: '', selected: false }

                , { id: 103000000, name: '复合报表', method: 'GET', path: '/Report/Complex', pIds: [100000000], icon: 'Complex', selected: false }
                , { id: 103000010, name: '公司月度经营报表', method: 'GET', path: '/Report/MonthComplex', pIds: [100000000, 103000000], icon: 'Complex', selected: false }
                , { id: 103000020, name: '销售机会分析', method: 'GET', path: '/Report/Jihui', pIds: [100000000, 103000000], icon: '', selected: false }
                , { id: 103000030, name: '销售分析报表', method: 'GET', path: '/Report/SalesComplex', pIds: [100000000, 103000000], icon: '', selected: false }

               , { id: 104010000, name: '客户', method: 'GET', path: '#', pIds: [100000000, 104000000], icon: '', selected: false }
               , { id: 104010001, name: '客户类别构成情况', method: 'GET', path: '/Report/CustomerType', pIds: [100000000, 104000000, 104010000], icon: '', selected: false }
               , { id: 104010002, name: '客户类型分析', method: 'GET', path: '/Report/CustomerCategory', pIds: [100000000, 104000000, 104010000], icon: '', selected: false }
               , { id: 104010003, name: '客户阶段分析', method: 'GET', path: '/Report/CustomerStage', pIds: [100000000, 104000000, 104010000], icon: '', selected: false }
               , { id: 104010007, name: '客户来源分析', method: 'GET', path: '/Report/CustomerSource', pIds: [100000000, 104000000, 104010000], icon: '', selected: false }
               , { id: 104010005, name: '客户注册资金分析', method: 'GET', path: '/Report/RegisterCapitalCustomer', pIds: [100000000, 104000000, 104010000], icon: '', selected: false }
               , { id: 104010006, name: '客户企业人员规模分析', method: 'GET', path: '/Report/PersonnelScaleCustomer', pIds: [100000000, 104000000, 104010000], icon: '', selected: false }
               , { id: 104010007, name: '客户主营行业分析', method: 'GET', path: '/Report/CustomerIndustry', pIds: [100000000, 104000000, 104010000], icon: '', selected: false }
               , { id: 104010008, name: '客户区域分析', method: 'GET', path: '/Report/CustomerArea', pIds: [100000000, 104000000, 104010000], icon: '', selected: false }
               , { id: 104010009, name: '客户联系方式填写情况分析', method: 'GET', path: '/Report/ContactStatusCustomer', pIds: [100000000, 104000000, 104010000], icon: '', selected: false }
               , { id: 104010010, name: '客户联系人分析', method: 'GET', path: '/Report/ContactPersonCustomer', pIds: [100000000, 104000000, 104010000], icon: '', selected: false }
               , { id: 104010011, name: '客户归属分析', method: 'GET', path: '/Report/CustomerOwnerType', pIds: [100000000, 104000000, 104010000], icon: '', selected: false }
               , { id: 104010012, name: '开发模式分析', method: 'GET', path: '/Report/CustomerMode', pIds: [100000000, 104000000, 104010000], icon: '', selected: false }
               , { id: 104010013, name: '老客户推荐新客户情况分析', method: 'GET', path: '/Report/CustomerIntroduce', pIds: [100000000, 104000000, 104010000], icon: '', selected: false }

               , { id: 104020000, name: '市场', method: 'GET', path: '#', pIds: [100000000, 104000000], icon: '', selected: false }
               , { id: 104020001, name: '销售机会来源分析', method: 'GET', path: '/Report/OpportunitySource', pIds: [100000000, 104000000, 104020000], icon: '', selected: false }
               , { id: 104020002, name: '销售机会跟单阶段分析', method: 'GET', path: '/Report/OpportunityStage', pIds: [100000000, 104000000, 104020000], icon: '', selected: false }
               , { id: 104020003, name: '销售机会状态分析', method: 'GET', path: '/Report/OpportunityStatus', pIds: [100000000, 104000000, 104020000], icon: '', selected: false }
               , { id: 104020004, name: '销售机会跟单人分析', method: 'GET', path: '/Report/OpportunityEmployee', pIds: [100000000, 104000000, 104020000], icon: '', selected: false }
               , { id: 104020005, name: '销售机会跟单部门分析', method: 'GET', path: '/Report/OpportunityGroup', pIds: [100000000, 104000000, 104020000], icon: '', selected: false }
               , { id: 104020006, name: '销售机会发现时间月份分析', method: 'GET', path: '/Report/OpportunityDate', pIds: [100000000, 104000000, 104020000], icon: '', selected: false }

               , { id: 104030000, name: '服务', method: 'GET', path: '#', pIds: [100000000, 104000000], icon: '', selected: false }
               , { id: 104030001, name: '客户服务类型分析', method: 'GET', path: '/Report/ServeType', pIds: [100000000, 104000000, 104030000], icon: '', selected: false }
               , { id: 104030002, name: '客户服务状态分析', method: 'GET', path: '/Report/ServeState', pIds: [100000000, 104000000, 104030000], icon: '', selected: false }
               , { id: 104030003, name: '客户服务紧急程度分析', method: 'GET', path: '/Report/ServeUrgent', pIds: [100000000, 104000000, 104030000], icon: '', selected: false }
               , { id: 104030004, name: '客户服务方式分析', method: 'GET', path: '/Report/ServeMode', pIds: [100000000, 104000000, 104030000], icon: '', selected: false }
               , { id: 104030005, name: '客户投诉类型分析', method: 'GET', path: '/Report/ComplainType', pIds: [100000000, 104000000, 104030000], icon: '', selected: false }
               , { id: 104030006, name: '客户投诉状态分析', method: 'GET', path: '/Report/ComplainState', pIds: [100000000, 104000000, 104030000], icon: '', selected: false }
               , { id: 104030007, name: '客户投诉紧急程度分析', method: 'GET', path: '/Report/ComplainUrgent', pIds: [100000000, 104000000, 104030000], icon: '', selected: false }
               , { id: 104030008, name: '回访处理状态分析', method: 'GET', path: '/Report/ReplyState', pIds: [100000000, 104000000, 104030000], icon: '', selected: false }
               , { id: 104030009, name: '回访方式分析', method: 'GET', path: '/Report/ReplyMode', pIds: [100000000, 104000000, 104030000], icon: '', selected: false }
               , { id: 104030010, name: '员工回访量分析', method: 'GET', path: '/Report/ReplyEmployees', pIds: [100000000, 104000000, 104030000], icon: '', selected: false }
               , { id: 104030011, name: '来电类型分析', method: 'GET', path: '/Report/CallType', pIds: [100000000, 104000000, 104030000], icon: '', selected: false }
               , { id: 104030012, name: '来电处理状态分析', method: 'GET', path: '/Report/CallState', pIds: [100000000, 104000000, 104030000], icon: '', selected: false }
               , { id: 104030013, name: '员工接听来电分析', method: 'GET', path: '/Report/CallEmployees', pIds: [100000000, 104000000, 104030000], icon: '', selected: false }

               , { id: 104040000, name: '内部办公', method: 'GET', path: '#', pIds: [100000000, 104000000], icon: '', selected: false }
               , { id: 104040001, name: '日程行动进度分析', method: 'GET', path: '/Report/CalendarProgress', pIds: [100000000, 104000000, 104040000], icon: '', selected: false }
               , { id: 104040002, name: '工作日志点评统计', method: 'GET', path: '/Report/DailyReportComment', pIds: [100000000, 104000000, 104040000], icon: '', selected: false }
               , { id: 104040003, name: '工作日志统计', method: 'GET', path: '/Report/DailyReportStatistics', pIds: [100000000, 104000000, 104040000], icon: '', selected: false }

               , { id: 104050000, name: '产品', method: 'GET', path: '#', pIds: [100000000, 104000000], icon: '', selected: false }
               , { id: 104050001, name: '产品分类统计', method: 'GET', path: '/Report/ProductCategory', pIds: [100000000, 104000000, 104050000], icon: '', selected: false }
               , { id: 104050002, name: '产品品牌统计', method: 'GET', path: '/Report/ProductBrand', pIds: [100000000, 104000000, 104050000], icon: '', selected: false }

               , { id: 104060000, name: '人事', method: 'GET', path: '#', pIds: [100000000, 104000000], icon: '', selected: false }
               , { id: 104060001, name: '部门员工统计', method: 'GET', path: '/Report/GroupEmployee', pIds: [100000000, 104000000, 104060000], icon: '', selected: false }
               , { id: 104060002, name: '员工学历统计', method: 'GET', path: '/Report/EmployeeDegree', pIds: [100000000, 104000000, 104060000], icon: '', selected: false }
               , { id: 104060003, name: '员工在职时间统计', method: 'GET', path: '/Report/EmployeeReportDay', pIds: [100000000, 104000000, 104060000], icon: '', selected: false }
               , { id: 104060004, name: '员工性别统计', method: 'GET', path: '/Report/EmployeeSex', pIds: [100000000, 104000000, 104060000], icon: '', selected: false }
               , { id: 104060005, name: '员工年龄统计', method: 'GET', path: '/Report/EmployeeAge', pIds: [100000000, 104000000, 104060000], icon: '', selected: false }
               , { id: 104060006, name: '合同状态统计', method: 'GET', path: '/Report/EmployeeLabourContract', pIds: [100000000, 104000000, 104060000], icon: '', selected: false }
               , { id: 104060007, name: '人事调动统计', method: 'GET', path: '/Report/EmployeePostChange', pIds: [100000000, 104000000, 104060000], icon: '', selected: false }
               , { id: 104060008, name: '员工沟通统计', method: 'GET', path: '/Report/EmployeeCommunication', pIds: [100000000, 104000000, 104060000], icon: '', selected: false }
               , { id: 104060009, name: '员工奖惩统计', method: 'GET', path: '/Report/EmployeeReward', pIds: [100000000, 104000000, 104060000], icon: '', selected: false }
               , { id: 104060010, name: '员工积分前十统计', method: 'GET', path: '/Report/EmployeeIntegral', pIds: [100000000, 104000000, 104060000], icon: '', selected: false }
               , { id: 104060011, name: '培训次数统计', method: 'GET', path: '/Report/EmployeeTraining', pIds: [100000000, 104000000, 104060000], icon: '', selected: false }
               , { id: 104060012, name: '简历统计分析', method: 'GET', path: '/Report/EmployeeResume', pIds: [100000000, 104000000, 104060000], icon: '', selected: false }
               , { id: 104060013, name: '招聘计划申请统计', method: 'GET', path: '/Report/RecruitmentApply', pIds: [100000000, 104000000, 104060000], icon: '', selected: false }
               , { id: 104060014, name: '招聘到职统计', method: 'GET', path: '/Report/RecruitPost', pIds: [100000000, 104000000, 104060000], icon: '', selected: false }
               
               , { id: 104070000, name: '财务', method: 'GET', path: '#', pIds: [100000000, 104000000], icon: '', selected: false }
               , { id: 104070001, name: '收支记账类型分析', method: 'GET', path: '/Report/FinancialAccountingTally', pIds: [100000000, 104000000, 104070000], icon: '', selected: false }
               , { id: 104070002, name: '收支账户类型分析', method: 'GET', path: '/Report/FinancialAccountingType', pIds: [100000000, 104000000, 104070000], icon: '', selected: false }
               , { id: 104070003, name: '收支项目类型分析', method: 'GET', path: '/Report/FinancialAccountingItem', pIds: [100000000, 104000000, 104070000], icon: '', selected: false }

               , { id: 104080000, name: '知识', method: 'GET', path: '#', pIds: [100000000, 104000000], icon: '', selected: false }
               , { id: 104080001, name: '知识文档分类统计', method: 'GET', path: '/Report/KnowledgeCategory', pIds: [100000000, 104000000, 104080000], icon: '', selected: false }
               , { id: 104080002, name: '知识文档发布时间统计', method: 'GET', path: '/Report/KnowledgePublishDate', pIds: [100000000, 104000000, 104080000], icon: '', selected: false }
    ]
})