﻿define("baseVm", function () {
    var navs = {
        customer: "/Customer/DetailCustomer/:id",//客户
        campaign: "/Market/Campaign/:id/view",//营销战役
        marketActivity: "/Market/Activity/:id/view",//市场活动
        contract: "/Market/Contract/:id/view",//合同订单
        productlist: "/Market/ProductList/:id/view",
        salesOpportunities: "/Market/SalesOpportunities/:id/view",//销售机会
        offer:"/Market/DocumentaryOffer/:id/view",//跟单报价
        followUp: "/Services/FollowUp/:id/view",//回访关怀
        hr: "/HR/Archive/:id/view",//人事档案
        product: "/Product/Product/:id/view"//产品
    }
    var customerTypes = [{ label: '企业', val: '0' }
                           , { label: '个人', val: '1' }
                           , { label: '事业单位', val: '2' }
                           , { label: '政府机构', val: '3' }
                           , { label: '社会团体', val: '4' }
    ];
    var baseVm = function (vmid) {
        var entitys = {};
        var bvm = {
            vmid:vmid,
            $skipArray: ['lang', 'tmpl', 'modelFactory'],
            getCustomerTypes:function(){
                return [].concat(customerTypes);
            },
            gotoview: function (id,key,data) {
                if (!id) {
                    messageBox.warning("还未有对应的Id");
                    return;
                }
                if (key == null) key = "customer";
                var url = navs[key];
                if (!url) {
                    console.log("no found key:" + key);
                    return;
                }
                url = url.replace(":id", id);
                goto(url, true,data);
            },
            gotourl: function (url, disableGps,data) {
                if (disableGps == null) disableGps = true;
                goto(url, disableGps,data);
            },
            destroyui: function () {
                destroyui.apply(this, arguments);
            },
            getEntityVm: function (id, entity) {
                var cvmid = vmid + "_Entity_" + id;
                var cvm = avalon.vmodels[cvmid];
                if (cvm) {
                    cvm.entity = entity;
                } else {
                    cvm = avalon.define(cvmid, function (vm) {
                        vm.entity = entity;
                    });
                    entitys[id] = true;
                }
                return cvm;
            },
            destroyEntityVm: function () {
                for (var key in entitys) {
                    if (entitys[key] === true) delete avalon.vmodels[key];
                }
            },
            downFile: function (path,fileName) {
                var url="/Upload/Down";
                var data={ path: path, fileName: fileName,downFile:true }
                frameSubmit(url, "post", data);
            },
            openTmpl:function(args){
                if (args.vm == null) args.vm = this;
                if (args.tmpl == null) args.tmpl = this.tmpl;
                return openTmpl(args);
            },
            openHtml: function (title,html, w, h, padding) {
                return this.openTmpl({
                    title:title,
                    w: w, h: h, padding: padding,
                    tmplId: html, isContent: true
                });
            },
            viewImg: function (src,options) {
                var defOps = { centered: true };
                var ops = $.extend(true, defOps, options || {});
                var imgs = [];
                if (typeof (src) == "string") src = [src];
                src.forEach(function (p) {
                    imgs.push('<img src="' + p + '" />');
                })
                console.log(imgs.join(""))
                require("lightbox", function () {
                    $(imgs.join("")).lightbox_me(ops);
                });
            }
        }
        return bvm;
    }
    return baseVm;
});