﻿define('Report', ['modelFactory','plugins',
    'json',
    'dialog',
    'jscal2',
    'common',
    'jcal',
    'fusionCharts',
    'jqselect',
    'kindedit',
    'upload',
    'jqPlot'],
    function (modelFactory,plugins) {

        var searchMode = {
            starTime: '',
            endTime: '',
            DepartIds: '',
            DepartIdName: '',
            typeid: 0,
            UserIds: '',
            UserIdName: '',
            CompanyCountryId: -1,
            CompanyProvinceId: -2,
            CompanyCityId: -3

        };

        var Condition = {
            starTime: '',
            endTime: '',
            DepartIds: '',
            DepartIdName: '',
            typeid: 0,
            UserIds: '',
            UserIdName: '',
            followStages: 0,
            Keneng: 0,
            opporStatus: 0,
            serviceTags: 0,
            SourceId: 0,
            year: ''

        };


        var ServeMode = {

            searchDay: '',//日
            searchMonth: '',//月
            searchYear: '',//年
            starTime: '',//开始时间
            endTime: '',//结束时间
            DepartIds: '',//部门ID
            DepartIdName: '',//部门名称
            UserIds: '',//员工编号
            UserIdName: ''//员工名称
        };

        //JQuery 饼图
        function createJQPieChart (chartId, title, chartData) {
            var pieData = [];
            $(chartId).empty();
            try{
                if (chartId == '#chart_pie') {
                    chartData.forEach(function (item) {
                        var name = item.seriesname;
                        var total = 0;
                        var itemData = item.data;
                        itemData.forEach(function (idata) {
                            total += parseInt(idata.value);
                        });

                        name += " " + total + '家';
                        pieData.push([name, total])
                    });
                }
                else {
                    chartData.forEach(function (item) {
                        pieData.push([item.label + ' ' + item.value, parseInt(item.value)]);
                    });
                }
                //console.log(pieData);
                $(chartId).jqplot([pieData], {
                    title: title,
                    pointLabels: { show: true },
                    seriesDefaults: {
                        fill: true,
                        showMarker: false,
                        shadow: false,
                        renderer: $.jqplot.PieRenderer,
                        rendererOptions: {
                            diameter: undefined,
                            padding: 10,
                            sliceMargin: 2,
                            fill: true,
                            shadow: true,
                            shadowOffset: 2,
                            shadowDepth: 5,
                            shadowAlpha: 0.07,
                            showDataLabels: true
                        },
                        pointLabels: { //数值点标签属性设置，该属性来自于jqplot.pointLabels.min.js
                            show: true, //是否在图表上显示数值点标签
                            location: 'e' //标签显示的方位
                        }
                    },
                    legend: {
                        show: true,
                        location: 'ne',
                        xoffset: 12,
                        yoffset: 12
                    }
                });
            }
            catch (ex) {
                $(chartId).html("<p class='nodata'>" + ex.message + "</p>");
            }
        }

        //JQuery 线性图
        function createJQLinear (chartId, title, chartData) {
            var linearData = [];
            var labels = [];
            $(chartId).empty();
            try{
                chartData.forEach(function (item) {
                    var a = [];
                    labels.push(item.seriesname);
                    item.data.forEach(function (node, i) {
                        a.push([(i + 1) + "月", node.value]);
                    })
                    linearData.push(a);
                });
                //console.log(linearData);
                $(chartId).jqplot(linearData, {
                    title: title,
                    animate: true,
                    animateReplot: true,
                    /*cursor: {
                        show: true,
                        showTooltip: true,
                        followMouse: true,
                        zoom: true,
                        looseZoom: true,
                        showTooltip: true,
                        tooltipOffset: 6,
                        showTooltipUnitPosition: true,
                        ooltipFormatString:'%.2f'
                    }, */
                    series: [
                        {
                            label: labels[0] || '',
                            showHighlight: true,
                            pointLabels: {
                                show: true
                            },
                            rendererOptions: {
                                animation: {
                                    speed: 2000
                                }
                            }
                        }, {
                            label: labels[1] || '',
                            showHighlight: true,
                            pointLabels: {
                                show: true
                            },
                            rendererOptions: {
                                animation: {
                                    speed: 2000
                                }
                            }
                        },
                    ],
                    axes: {
                        xaxis: {
                            renderer: $.jqplot.CategoryAxisRenderer
                        },
                        yaxis: {
                            label: '',
                            tickOptions: {
                                formatString: '%.1f'
                            },
                            rendererOptions: {
                                forceTickAt0: true
                            },
                            lableRenderer: $.jqplot.CanvasAxisLabelRenderer,
                        }
                    },
                    highlighter: {
                        show: true,
                        showLabel: true,
                        tooltipAxes: 'y',
                        sizeAjust: 7.5,
                        tooltipLocation: 'ne'
                    },
                    legend: {
                        renderer: $.jqplot.EnhancedLegendRenderer,
                        show: true,
                        location: 'ne',
                        // placement:'outsideGrid'
                    }
                });
            }
            catch (ex) {
                $(chartId).html("<p class='nodata'>" + ex.message + "</p>");
            }
        }

        //JQuery 线性图
        function createJQBar(chartId, title, chartData) {
            var barData = [];
            var labels = [];
            var a = [];
            $(chartId).empty();
            try{
                console.log(chartData);
                chartData.forEach(function (item) {      
                    labels.push(item.label);
                    a.push(item.value); 
                });
                barData.push(a);
                console.log(barData);
                $(chartId).jqplot(barData, {
                    title: title,
                    series: [
                       {
                           //color: '#5FAB78',
                           renderer: jQuery.jqplot.BarRenderer,
                           rendererOptions: {
                               barDirection: 'vertical',
                               barMargin: 15,
                               barWidth: 50
                           }
                       }
                    ],
                    seriesDefaults: {
                        renderer:$.jqplot.BarRenderer,
                        rendererOptions: {fillToZero: true},
                        pointLabels: { //数值点标签属性设置，该属性来自于jqplot.pointLabels.min.js
                            show: true, //是否在图表上显示数值点标签
                            location: 'n', //标签显示的方位 'se', 's', 'sw', 'w', 'nw'
                            edgeTolerance: -15
                        },
                        // Rotate the bar shadow as if bar is lit from top right.
                        shadowAngle: 135
                    },
                    cursor: {
                        show: true, //是否显示提示信息
                        zoom: true, //是否启用变焦，鼠标左键选中图表去拖动可放大图标
                        looseZoom: true //扩展变焦范围，提供更全面的刻度值信息，目前仅对有时间轴和线性轴的图表有效
                    },
                
                    axesDefaults: {
                        tickRenderer: $.jqplot.CanvasAxisTickRenderer,
                        tickOptions: {
                            fontFamily: 'Georgia',
                            angle: -30,
                            fontSize: '10pt'
                        }
                    },
                    axes: {
                        xaxis: {
                            renderer: $.jqplot.CategoryAxisRenderer,
                            ticks:labels,
                        },
                    },
                });
            }
            catch (ex) {
                $(chartId).html("<p class='nodata'>" + ex.message + "</p>");
            }
            //p.replot();
        }

        //线性图
        function createLineChart(chartRight, result) {
            var chartOption = avalon.mix({}, {
                anchorRadius: '5',
                baseFontSize: '12',
                numdivlines: '4',
                //numberSuffix: '元',
                lineThickness: '2',
                showValues: '0',
                numVDivLines: '12',
                formatNumberScale: '0',
                labelDisplay: 'ROTATE',
                bgColor: 'FFFFFF',
                slantLabels: '1',
                anchorRadius: '2',
                anchorBgAlpha: '50',
                showAlternateVGridColor: '1',
                anchorAlpha: '100',
                showBorder: '0',
                animation: '1',
                limitsDecimalPrecision: '0',
                divLineDecimalPrecision: '1'
            }, result.option, true)

            var charts = {
                chart: chartOption,
                dataset: result.source,
                categories: [
                {
                    category: [
                            { label: '1月' }, { label: '2月' }, { label: '3月' },
                            { label: '4月' }, { label: '5月' }, { label: '6月' },
                            { label: '7月' }, { label: '8月' }, { label: '9月' },
                            { label: '10月' }, { label: '11月' }, { label: '12月' }
                    ]
                }]
            }
            var myChart = new FusionCharts("/Scripts/Charts/Charts/MSLine.swf", "hellochart", "80%", "240px");;
            myChart.setJSONData(charts);
            myChart.render(chartRight);

        }
        //线性图
        function createLineChartSize(chartRight, result, width, height) {
            var chartOption = avalon.mix({}, {
                anchorRadius: '5',
                baseFontSize: '12',
                numdivlines: '4',
                //numberSuffix: '元',
                lineThickness: '2',
                showValues: '0',
                numVDivLines: '12',
                formatNumberScale: '0',
                labelDisplay: 'ROTATE',
                bgColor: 'FFFFFF',
                slantLabels: '1',
                anchorRadius: '2',
                anchorBgAlpha: '50',
                showAlternateVGridColor: '1',
                anchorAlpha: '100',
                showBorder: '0',
                animation: '1',
                limitsDecimalPrecision: '0',
                divLineDecimalPrecision: '1'
            }, result.option, true)

            var charts = {
                chart: chartOption,
                dataset: result.source,
                categories: [
                {
                    category: [
                            { label: '1月' }, { label: '2月' }, { label: '3月' },
                            { label: '4月' }, { label: '5月' }, { label: '6月' },
                            { label: '7月' }, { label: '8月' }, { label: '9月' },
                            { label: '10月' }, { label: '11月' }, { label: '12月' }
                    ]
                }]
            }
            var myChart = new FusionCharts("/Scripts/Charts/Charts/MSLine.swf", "hellochart", width, height);;
            myChart.setJSONData(charts);
            myChart.render(chartRight);

        }
        //饼图
        var createPieChart = function (chartData, chartId, width, heigh) {
            var charts = {
                chart: {
                    caption: "",
                    subcaption: "",
                    yaxisname: "",
                    xaxisname: "",
                    alternatevgridcolor: "AFD8F8",
                    basefontcolor: "114B78",
                    tooltipbordercolor: "114B78",
                    tooltipbgcolor: "E7EFF6",
                    plotborderdashed: "1",
                    plotborderdashlen: "2",
                    plotborderdashgap: "2",
                    useroundedges: "1",
                    bgColor: "#f3f3f3",
                    //"canvasBorderColor": "f3f3f3",
                    canvasBgAlpha: "1,1",
                    bgAlpha: "1,1",
                    //"showBorder": "1",
                    baseFontSize: "12",
                    showlegend: "1"
                },
                data: chartData,
                styles: {
                    definition: [{
                        type: "font",
                        name: "captionFont",
                        size: "15"
                    }],
                    application: [{
                        toobject: "caption",
                        styles: "captionFont"
                    }]
                }
            }
            var myChart = new FusionCharts("/Scripts/Charts/Charts/Pie3D.swf", "funnelChart_" + chartId, width, heigh);;
            myChart.setJSONData(charts);
            myChart.render(chartId);
        };
        //饼图---带标题
        var createPieChartWidthCaption = function (caption, chartData, chartId, width, heigh) {
            var charts = {
                chart: {
                    caption: caption,
                    subcaption: "",
                    yaxisname: "",
                    xaxisname: "",
                    alternatevgridcolor: "AFD8F8",
                    basefontcolor: "114B78",
                    tooltipbordercolor: "114B78",
                    tooltipbgcolor: "E7EFF6",
                    plotborderdashed: "1",
                    plotborderdashlen: "2",
                    plotborderdashgap: "2",
                    useroundedges: "1",
                    bgColor: "#f3f3f3",
                    //"canvasBorderColor": "f3f3f3",
                    canvasBgAlpha: "1,1",
                    bgAlpha: "1,1",
                    //"showBorder": "1",
                    baseFontSize: "12",
                    showlegend: "1"
                },
                data: chartData,
                styles: {
                    definition: [{
                        type: "font",
                        name: "captionFont",
                        size: "15"
                    }],
                    application: [{
                        toobject: "caption",
                        styles: "captionFont"
                    }]
                }
            }
            var myChart = new FusionCharts("/Scripts/Charts/Charts/Pie3D.swf", "funnelChart_" + chartId, width, heigh);;
            myChart.setJSONData(charts);
            myChart.render(chartId);
        };
        //柱状图
        function createColumnChart2(chartData, chartId, width, height) {
            var charts = {
                chart: {

                },
                categories: chartData.categories,
                dataset: chartData.dataset
            }
            if (chartData.chart) {
                $.extend(charts.chart, chartData.chart);
            }
            //MSLine
            //Column3D
            if (width && height) {
                var myChart = new FusionCharts("/Scripts/Charts/Charts/MSColumn2D.swf", "funnelChart_" + chartId, width, height);
            } else {
                var myChart = new FusionCharts("/Scripts/Charts/Charts/MSColumn2D.swf", "funnelChart_" + chartId);
            }
            myChart.setJSONData(charts);
            myChart.render(chartId);
        }
        var createColumnChart = function (chartData, chartId, width, heigh) {
            var charts = {
                chart: {
                    basefontsize: "12",
                    palette: "2"
                },
                data: chartData,
                styles: {
                    definition: [{
                        type: "font",
                        name: "captionFont",
                        size: "15"
                    }],
                    application: [{
                        toobject: "caption",
                        styles: "captionFont"
                    }]
                }
            }
            var myChart = new FusionCharts("/Scripts/Charts/Charts/Column3D.swf", "funnelChart_" + chartId, width, heigh);;
            myChart.setJSONData(charts);
            myChart.render(chartId);
        }

        //带标题柱状图
        var createColumnChartWithTitle = function (chartData, caption, chartId, width, heigh) {
            var charts = {
                chart: {
                    basefontsize: "12",
                    palette: "2",
                    caption: caption
                },
                data: chartData,
                styles: {
                    definition: [{
                        type: "font",
                        name: "captionFont",
                        size: "15"
                    }],
                    application: [{
                        toobject: "caption",
                        styles: "captionFont"
                    }]
                }
            }
            var myChart = new FusionCharts("/Scripts/Charts/Charts/Column3D.swf", "funnelChart_" + chartId, width, heigh);;
            myChart.setJSONData(charts);
            myChart.render(chartId);
        }

        //当前日期
        var Current = function () {
            var date = new Date();
            var yy = date.getFullYear();
            var mm = date.getMonth() + 1;
            var Format = function (i) {
                if (i < 10) {
                    return "0" + i;
                } else {
                    return i;
                }
            }
            var dd = date.getDate();
            mm = Format(mm);
            dd = Format(dd);
            return date.getFullYear() + "-" + mm + "-" + dd;
        }
        //本年第一天
        var FirstDayOfThisYear = function () {
            var date = new Date();
            return date.getFullYear() + "-01-01";
        }

        var notMemberFilter = function (treeId, parentNode, responseData) {
            var ret = [], len, curr, hasMember = false
            if (responseData.data && responseData.data.groups.length) {
                len = responseData.data.groups.length
                if (len) {
                    for (var i = 0; i < len; i++) {
                        curr = responseData.data.groups[i]
                        curr.nocheck = true
                        ret.push(curr)
                        curr.Posts.forEach(function (p, i) {
                            if (!p.Users.length) return true
                            hasMember = true
                            p.Users.forEach(function (u, i) {
                                var u = p.Users[i]
                                u.ParentId = u.PositionId
                                u.Name = u.FullName
                            })
                            curr.Posts[i].ParentId = p.Boss ? p.Boss.Id : p.Group
                            curr.Posts[i].nocheck = true
                            ret.push(curr.Posts[i])
                            ret = ret.concat(p.Users)
                        })
                    }
                }
            }
            return ret
        }
        var Report = {
            ///个人概况
            Index: function (tmpl, lang, contentId, module) {
                var CBCRM = avalon.vmodels.CBCRM
                var mvvm = avalon.define('IndexController', function (vm) {
                    vm.customerCount = 0;
                    vm.customerP = 0;
                    vm.signCount = 0;
                    vm.signP = 0;
                    vm.signmoney = 0;
                    vm.signmoneyP = 0;
                    vm.backmoney = 0;
                    vm.backmoneyP = 0;
                    vm.complaints = 0;
                    vm.complaintsP = 0;
                    vm.customerYP = 0;
                    vm.YbackMoney = 0;
                    vm.YsignCount = 0;
                    vm.companyShow = 0;
                });

                function getDataList() {
                    $.get('/Report/Index', {}, function (result) {
                        //createPieChart1(result.data.chart_customerTye, 'costomerType', '320', '220')
                        //createLineChart(result.data.chart_customerQX, 'Customerlive', '1012', '220')
                        //createLineChart(result.data.chart_sign, 'chart_sign', '690', '220')
                        createJQPieChart('#chart_pie', '', result.data.chart_sign);
                        createJQPieChart('#costomerType', '客户类型', result.data.chart_customerTye);
                        createJQLinear('#chart_sign', '签单/回款增长走势图', result.data.chart_sign)
                        createJQLinear('#Customerlive', '客户增长走势', result.data.chart_customerQX)
                        mvvm.customerCount = result.data.customerCount;
                        mvvm.customerP = result.data.customerP;
                        mvvm.signCount = result.data.signCount;
                        mvvm.signP = result.data.signP;
                        mvvm.signmoney = result.data.signmoney;
                        mvvm.signmoneyP = result.data.signmoneyP;
                        mvvm.backmoney = result.data.backmoney;
                        mvvm.backmoneyP = result.data.backmoneyP;
                        mvvm.complaints = result.data.complaints;
                        mvvm.complaintsP = result.data.complaintsP;
                        mvvm.customerYP = result.data.customerYP;
                        mvvm.YbackMoney = result.data.YbackMoney;
                        mvvm.YsignCount = result.data.YsignCount;
                        mvvm.companyShow = result.data.companyShow;
                    })
                }
                //JQuery 饼图
                var createJQPieChart = function (chartId, title, chartData) {
                    var pieData = [];
                    $(chartId).empty();
                    try{
                        if (chartId == '#chart_pie') {
                            chartData.forEach(function (item) {
                                var name = item.seriesname;
                                var total = 0;
                                var itemData = item.data;
                                itemData.forEach(function (idata) {
                                    total += parseInt(idata.value);
                                });

                                name += " " + total + '家';
                                pieData.push([name, total])
                            });
                        }
                        else {
                            chartData.forEach(function (item) {
                                pieData.push([item.label + ' ' + item.value, parseInt(item.value)]);
                            });
                        }
                        //console.log(pieData);
                        $(chartId).jqplot([pieData], {
                            title: title,
                            pointLabels: { show: true },
                            seriesDefaults: {
                                fill: true,
                                showMarker: false,
                                shadow: false,
                                renderer: $.jqplot.PieRenderer,
                                rendererOptions: {
                                    diameter: undefined,
                                    padding: 10,
                                    sliceMargin: 2,
                                    fill: true,
                                    shadow: true,
                                    shadowOffset: 2,
                                    shadowDepth: 5,
                                    shadowAlpha: 0.07,
                                    showDataLabels: true
                                },
                                pointLabels: { //数值点标签属性设置，该属性来自于jqplot.pointLabels.min.js
                                    show: true, //是否在图表上显示数值点标签
                                    location: 'e' //标签显示的方位
                                }
                            },
                            legend: {
                                show: true,
                                location: 'ne',
                                xoffset: 12,
                                yoffset: 12
                            }
                        });
                    }
                    catch (ex) {
                        $(chartId).html("<p class='nodata'>" + ex.message + "</p>");
                    }
                }

                //JQuery 线性图
                var createJQLinear = function (chartId, title, chartData) {
                    var linearData = [];
                    var labels = [];
                    $(chartId).empty();
                    try{
                        chartData.forEach(function (item) {
                            var a = [];
                            labels.push(item.seriesname);
                            item.data.forEach(function (node, i) {
                                a.push([(i + 1) + "月", node.value]);
                            })
                            linearData.push(a);
                        });
                        console.log(linearData);
                        $(chartId).jqplot(linearData, {
                            title: title,
                            animate: true,
                            animateReplot: true,
                            /*cursor: {
                                show: true,
                                showTooltip: true,
                                followMouse: true,
                                zoom: true,
                                looseZoom: true,
                                showTooltip: true,
                                tooltipOffset: 6,
                                showTooltipUnitPosition: true,
                                ooltipFormatString:'%.2f'
                            }, */
                            series: [
                                {
                                    label: labels[0] || '',
                                    showHighlight: true,
                                    pointLabels: {
                                        show: true
                                    },
                                    rendererOptions: {
                                        animation:{
                                            speed:2500
                                        }
                                    }
                                }, {
                                    label: labels[1] || '',
                                    showHighlight: true,
                                    pointLabels: {
                                        show: true
                                    },
                                    rendererOptions: {
                                        animation: {
                                            speed: 2500
                                        }
                                    }
                                },
                            ],
                            axes: {
                                xaxis: {
                                    renderer: $.jqplot.CategoryAxisRenderer
                                },
                                yaxis: {
                                    label: '',
                                    tickOptions: {
                                        formatString:'%.1f'
                                    },
                                    rendererOptions: {
                                        forceTickAt0: true
                                    },
                                    lableRenderer: $.jqplot.CanvasAxisLabelRenderer,
                                }
                            },
                            highlighter: {
                                show: true,
                                showLabel: true,
                                tooltipAxes: 'y',
                                sizeAjust: 7.5,
                                tooltipLocation: 'ne'
                            },
                            legend: {
                                renderer: $.jqplot.EnhancedLegendRenderer,
                                show: true,
                                location:'ne',
                                // placement:'outsideGrid'
                            }
                        });
                    }
                    catch (ex) {
                        $(chartId).html("<p class='nodata'>" + ex.message + "</p>");
                    }
                }

                //饼图
                var createPieChart1 = function (chartData, chartId, width, heigh) {
                    var charts = {
                        chart: {
                            caption: "",
                            subcaption: "",
                            yaxisname: "",
                            xaxisname: "",
                            alternatevgridcolor: "AFD8F8",
                            basefontcolor: "114B78",
                            tooltipbordercolor: "114B78",
                            tooltipbgcolor: "E7EFF6",
                            plotborderdashed: "1",
                            plotborderdashlen: "2",
                            plotborderdashgap: "2",
                            useroundedges: "1",
                            bgColor: "#f3f3f3",
                            //"canvasBorderColor": "f3f3f3",
                            canvasBgAlpha: "1,1",
                            bgAlpha: "1,1",
                            //"showBorder": "1",
                            baseFontSize: "12",

                        },
                        data: chartData,
                        styles: {
                            definition: [{
                                type: "font",
                                name: "captionFont",
                                size: "15"
                            }],
                            application: [{
                                toobject: "caption",
                                styles: "captionFont"
                            }]
                        }
                    }
                    var myChart = new FusionCharts("/Scripts/Charts/Charts/Pie3D.swf", "funnelChart_" + chartId, width, heigh);;
                    
                    myChart.setJSONData(charts);
                    myChart.render(chartId);
                };

                //线性图
                function createLineChart(chartData, chartId, width, height) {
                    var charts = {
                        chart: {
                            anchorRadius: '5',
                            baseFontSize: '12',
                            numdivlines: '4',
                            numberSuffix: '',
                            lineThickness: '2',
                            showValues: '0',
                            numVDivLines: '12',
                            formatNumberScale: '0',
                            labelDisplay: 'ROTATE',
                            bgColor: 'FFFFFF',
                            slantLabels: '1',
                            anchorRadius: '2',
                            anchorBgAlpha: '50',
                            showAlternateVGridColor: '1',
                            anchorAlpha: '100',
                            showBorder: '0',
                            animation: '1',
                            limitsDecimalPrecision: '0',
                            divLineDecimalPrecision: '1'
                        },
                        categories: [
                            {
                                category: [
                                        { label: '1月' }, { label: '2月' }, { label: '3月' },
                                        { label: '4月' }, { label: '5月' }, { label: '6月' },
                                        { label: '7月' }, { label: '8月' }, { label: '9月' },
                                        { label: '10月' }, { label: '11月' }, { label: '12月' }
                                ]
                            }
                        ],
                        dataset: chartData
                    }
                    var myChart = new FusionCharts("/Scripts/Charts/Charts/MSLine.swf", "funnelChart_" + chartId, width, height);;
                    myChart.setJSONData(charts);
                    myChart.render(chartId);
                }
                require("jqPlotPie,jqPointLabels,jqCanvasAxisTick,jqCategory,jqCanvasText,jqCanvasAxisLabel,jqEnhancedLegend,jqPointLabel,jqCursor,jqHighlighter,jqCanvasAxisTick",
                function () {
                    CBCRM.fillContent(tmpl, lang, contentId, module, mvvm);
                    getDataList();
                });
                
                CBCRM.onLoadModuleBefore = function () {
                    avalon.vmodels.Index = null
                }

            },

            ///企业概况
            CIndex: function (tmpl, lang, contentId, module) {
                var CBCRM = avalon.vmodels.CBCRM
                var mvvm = avalon.define('CIndexController', function (vm) {
                    vm.customerCount = 0;
                    vm.customerP = 0;
                    vm.signCount = 0;
                    vm.signP = 0;
                    vm.signmoney = 0;
                    vm.signmoneyP = 0;
                    vm.backmoney = 0;
                    vm.backmoneyP = 0;
                    vm.complaints = 0;
                    vm.complaintsP = 0;
                    vm.customerYP = 0;
                    vm.YbackMoney = 0;
                    vm.YsignCount = 0;
                });
                

                function getDataList() {
                    $.get('/Report/CIndex', {}, function (result) {
                        createPieChart1(result.data.chart_customerTye, 'costomerType', '320', '220')
                        //createLineChart(result.data.chart_customerQX, 'Customerlive', '470', '220') 
                        //createLineChart(result.data.chart_sign, 'chart_sign', '690', '220')
                        createJQLinear('#chart_sign', '签单/回款增长走势图', result.data.chart_sign)
                        createJQLinear('#Customerlive', '客户增长走势', result.data.chart_customerQX)
                        createJQLinear('#chartInOut', '收支情况', result.data.chart_InOut)
                        createJQPieChart('#chart_pie', '', result.data.chart_sign)
                        createJQPieChart('#costomerType','客户类型', result.data.chart_customerTye);
                        mvvm.customerCount = result.data.customerCount;
                        mvvm.customerP = result.data.customerP;
                        mvvm.signCount = result.data.signCount;
                        mvvm.signP = result.data.signP;
                        mvvm.signmoney = result.data.signmoney;
                        mvvm.signmoneyP = result.data.signmoneyP;
                        mvvm.backmoney = result.data.backmoney;
                        mvvm.backmoneyP = result.data.backmoneyP;
                        mvvm.complaints = result.data.complaints;
                        mvvm.complaintsP = result.data.complaintsP;
                        mvvm.customerYP = result.data.customerYP;
                        mvvm.YbackMoney = result.data.YbackMoney;
                        mvvm.YsignCount = result.data.YsignCount;
                    })
                }

                //JQuery 饼图
                var createJQPieChart = function (chartId, title, chartData) {
                    var pieData = [];
                    if (chartId == '#chart_pie') {
                        chartData.forEach(function (item) {
                            var name = item.seriesname;
                            var total = 0;
                            var itemData = item.data;
                            itemData.forEach(function (idata) {
                                total += parseInt(idata.value);
                            });

                            name += " " + total + '家';
                            pieData.push([name, total])
                        });
                    }
                    else {
                        chartData.forEach(function (item) {
                            pieData.push([item.label + ' ' + item.value, parseInt(item.value)]);
                        });
                    }
                    //console.log(pieData);
                    $(chartId).jqplot([pieData], {
                        title: title,
                        pointLabels: { show: true },
                        seriesDefaults: {
                            fill: true,
                            showMarker: false,
                            shadow: false,
                            renderer: $.jqplot.PieRenderer,
                            rendererOptions: {
                                diameter: undefined,
                                padding: 10,
                                sliceMargin: 2,
                                fill: true,
                                shadow: true,
                                shadowOffset: 2,
                                shadowDepth: 5,
                                shadowAlpha: 0.07,
                                showDataLabels: true
                            },
                            pointLabels: { //数值点标签属性设置，该属性来自于jqplot.pointLabels.min.js
                                show: true, //是否在图表上显示数值点标签
                                location: 'e' //标签显示的方位
                            }
                        },
                        legend: {
                            show: true,
                            location: 'ne',
                            xoffset: 12,
                            yoffset: 12
                        }
                    });
                }

                //JQuery 线性图
                var createJQLinear = function (chartId, title, chartData) {
                    var linearData = [];
                    var labels = [];
                    chartData.forEach(function (item) {
                        var a = [];
                        labels.push(item.seriesname);
                        item.data.forEach(function (node, i) {
                            a.push([(i + 1) + "月", node.value]);
                        })
                        linearData.push(a);
                    });
                    console.log(linearData);
                    $(chartId).jqplot(linearData, {
                        title: title,
                        animate: true,
                        animateReplot: true,
                        /*cursor: {
                            show: true,
                            showTooltip: true,
                            followMouse: true,
                            zoom: true,
                            looseZoom: true,
                            showTooltip: true,
                            tooltipOffset: 6,
                            showTooltipUnitPosition: true,
                            ooltipFormatString:'%.2f'
                        }, */
                        series: [
                            {
                                label: labels[0] || '',
                                showHighlight: true,
                                pointLabels: {
                                    show: true
                                },
                                rendererOptions: {
                                    animation: {
                                        speed: 2500
                                    }
                                }
                            }, {
                                label: labels[1] || '',
                                showHighlight: true,
                                pointLabels: {
                                    show: true
                                },
                                rendererOptions: {
                                    animation: {
                                        speed: 2500
                                    }
                                }
                            },
                        ],
                        axes: {
                            xaxis: {
                                renderer: $.jqplot.CategoryAxisRenderer
                            },
                            yaxis: {
                                label: '',
                                tickOptions: {
                                    formatString: '%.1f'
                                },
                                rendererOptions: {
                                    forceTickAt0: true
                                },
                                lableRenderer: $.jqplot.CanvasAxisLabelRenderer,
                            }
                        },
                        highlighter: {
                            show: true,
                            showLabel: true,
                            tooltipAxes: 'y',
                            sizeAjust: 7.5,
                            tooltipLocation: 'ne'
                        },
                        legend: {
                            renderer: $.jqplot.EnhancedLegendRenderer,
                            show: true,
                            location: 'ne',
                            // placement:'outsideGrid'
                        }
                    });
                }

                //饼图
                var createPieChart1 = function (chartData, chartId, width, heigh) {
                    var charts = {
                        chart: {
                            caption: "",
                            subcaption: "",
                            yaxisname: "",
                            xaxisname: "",
                            alternatevgridcolor: "AFD8F8",
                            basefontcolor: "114B78",
                            tooltipbordercolor: "114B78",
                            tooltipbgcolor: "E7EFF6",
                            plotborderdashed: "1",
                            plotborderdashlen: "2",
                            plotborderdashgap: "2",
                            useroundedges: "1",
                            bgColor: "#f3f3f3",
                            //"canvasBorderColor": "f3f3f3",
                            canvasBgAlpha: "1,1",
                            bgAlpha: "1,1",
                            //"showBorder": "1",
                            baseFontSize: "12",

                        },
                        data: chartData,
                        styles: {
                            definition: [{
                                type: "font",
                                name: "captionFont",
                                size: "15"
                            }],
                            application: [{
                                toobject: "caption",
                                styles: "captionFont"
                            }]
                        }
                    }
                    var myChart = new FusionCharts("/Scripts/Charts/Charts/Pie3D.swf", "funnelChart_" + chartId, width, heigh);;
                    myChart.setJSONData(charts);
                    myChart.render(chartId);
                };

                //线性图
                function createLineChart(chartData, chartId, width, height) {
                    var charts = {
                        chart: {
                            anchorRadius: '5',
                            baseFontSize: '12',
                            numdivlines: '4',
                            numberSuffix: '元',
                            lineThickness: '2',
                            showValues: '0',
                            numVDivLines: '12',
                            formatNumberScale: '0',
                            labelDisplay: 'ROTATE',
                            bgColor: 'FFFFFF',
                            slantLabels: '1',
                            anchorRadius: '2',
                            anchorBgAlpha: '50',
                            showAlternateVGridColor: '1',
                            anchorAlpha: '100',
                            showBorder: '0',
                            animation: '1',
                            limitsDecimalPrecision: '0',
                            divLineDecimalPrecision: '1'
                        },
                        categories: [
                            {
                                category: [
                                        { label: '1月' }, { label: '2月' }, { label: '3月' },
                                        { label: '4月' }, { label: '5月' }, { label: '6月' },
                                        { label: '7月' }, { label: '8月' }, { label: '9月' },
                                        { label: '10月' }, { label: '11月' }, { label: '12月' }
                                ]
                            }
                        ],
                        dataset: chartData
                    }
                    var myChart = new FusionCharts("/Scripts/Charts/Charts/MSLine.swf", "funnelChart_" + chartId, width, height);;
                    myChart.setJSONData(charts);
                    myChart.render(chartId);
                }

                require("jqPlotPie,jqPlotPie,jqPointLabels,jqCategory,jqCanvasText,jqCanvasAxisLabel,jqEnhancedLegend,jqPointLabel,jqCursor,jqHighlighter",
                function () {
                    CBCRM.fillContent(tmpl, lang, contentId, module, mvvm);
                    getDataList();
                });
                CBCRM.onLoadModuleBefore = function () {
                    avalon.vmodels.Index = null
                }

            },

            ///业绩排行榜
            Results: function (tmpl, lang, contentId, module) {
                var CBCRM = avalon.vmodels.CBCRM
                var mvvm = avalon.define('ResultsController', function (vm) {
                    vm.table1 = []
                    vm.table2 = []
                    vm.table3 = []
                    vm.table4 = []
                    vm.table5 = []
                    vm.table6 = []
                    vm.menus = [];
                    vm.getMenus = function () {
                        var lv2Menu = CBCRM.gps[1];
                        if (!lv2Menu) return;
                        var menus = [];
                        CBCRM.getChildMenus(lv2Menu, 1, false).forEach(function (m) {
                            var menu = $.extend(true, {}, m);
                            menu.children = CBCRM.getMenus(m.id).children;
                            menus.push(menu);
                        });
                        mvvm.menus = menus;
                        console.log(menus)
                    }
                });
                var str1 = "";
                function getreportlist() {
                    $.get("/Report/Results", {},
                    function (result) {
                        mvvm.table1 = result.data.tb1
                        mvvm.table2 = result.data.tb2
                        mvvm.table3 = result.data.tb3
                        mvvm.table4 = result.data.tb4
                        mvvm.table5 = result.data.tb5
                        mvvm.table6 = result.data.tb6
                        //createtable(result.data)
                    })
                }
                //getreportlist()
                mvvm.getMenus();
                // 填充表格
                function createtable(result) {
                    $.each(result, function (t, item) {
                        $.each(item, function (i, item2) {
                            if (i % 2 == 0) {
                                str1 += "<tr><td><a href=" + item2.Url + ">" + item2.Title + " </a></td>";
                            }
                            else
                                str1 += "<td><a href=" + item2.Url + ">" + item2.Title + " </a></td></tr>";
                        });
                        if (item.length % 2 == 1)
                            str1 += "</tr>";
                        if (item.length == 0)
                            str1 = "<tr> <td><a href='#'>暂无数据</a></td></tr>";
                        $("#" + t).append(str1);
                        str1 = "";
                    });
                }

                CBCRM.fillContent(tmpl, lang, contentId, module, mvvm);
                CBCRM.onLoadModuleBefore = function () {
                    avalon.vmodels.Index = null
                }

            },

            ///价格最高的跟单报价
            MaxDocumentary: function (tmpl, lang, contentId, module) {
                var CBCRM = avalon.vmodels.CBCRM
                var mvvm = avalon.define('MaxDocumentary', function (vm) {
                    vm.entity = {}
                    vm.dataList = []
                    vm.show = false
                    vm.search = function () {
                        getDataList(mvvm.entity.$model)
                    }
                    vm.dateOpts = {
                        format: '%Y-%m-%d',
                        onSelect: function (date, formatDate, format) {
                        }
                    }
                    vm.allDeaprt = function () {
                        mvvm.show = false;
                        mvvm.entity.$model.DepartIds = '';
                        mvvm.entity.DepartIdName = '';
                    }
                    vm.selectDeaprt = function () {
                        mvvm.show = true;
                    }
                    vm.clear = function () {
                        mvvm.entity = avalon.mix({}, searchMode);
                        getDataList(mvvm.entity.$model)
                    }
                    //选择部门
                    vm.postGroupTreeOpts = {
                        treeopts: {
                            check: {
                                enable: true,
                                chkboxType: { "Y": "s", "N": "s" },
                            },
                            async: {
                                enable: true,
                                url: '/Settings/GetGroupPostUser/102000000/'
                            },
                            callback: {
                                onCheck: function (event, treeId, treeNode) {
                                    tree = $.fn.zTree.getZTreeObj(treeId),
                                    names = [],
                                    ids = [],
                                    nodes = tree.getCheckedNodes(true)
                                    nodes.forEach(function (n, i) {
                                        names.push(n.Name)
                                        ids.push(n.Id)
                                    })
                                    mvvm.entity.$model.DepartIds = ids.join(',').toString();
                                    mvvm.entity.DepartIdName = names.join('，').toString()
                                }
                            }
                        }
                    }
                    vm.customerDetail = function (url) {
                        goto(url)
                    }
                })

                mvvm.entity = avalon.mix({}, searchMode);
                function getDataList(data) {
                    $.get('/Report/MaxDocumentary', data || searchMode, function (result) {
                        mvvm.dataList = result.data;
                    })
                }
                getDataList()
                CBCRM.fillContent(tmpl, lang, contentId, module, mvvm);
                CBCRM.onLoadModuleBefore = function () {
                    avalon.vmodels.Index = null;
                    if (avalon.vmodels.setGroup)
                        avalon.vmodels.setGroup.destroy()
                }
            },

            ///金额最大的合同订单
            MaxOrders: function (tmpl, lang, contentId, module) {
                var CBCRM = avalon.vmodels.CBCRM
                var mvvm = avalon.define('MaxOrders', function (vm) {
                    vm.entity = {}
                    vm.dataList = []
                    vm.show = false
                    vm.search = function () {
                        getDataList(mvvm.entity.$model)
                    }
                    vm.allDeaprt = function () {
                        mvvm.show = false;
                        mvvm.entity.$model.DepartIds = '';
                        mvvm.entity.DepartIdName = '';
                    }
                    vm.selectDeaprt = function () {
                        mvvm.show = true;
                    }
                    vm.clear = function () {
                        mvvm.entity = avalon.mix({}, searchMode);
                        getDataList(mvvm.entity.$model)
                    }
                    //选择部门
                    vm.postGroupTreeOpts = {
                        treeopts: {
                            check: {
                                enable: true,
                                chkboxType: { "Y": "s", "N": "s" },
                            },
                            async: {
                                enable: true,
                                url: '/Settings/GetGroupPostUser/102000000/'
                            },
                            callback: {
                                onCheck: function (event, treeId, treeNode) {
                                    tree = $.fn.zTree.getZTreeObj(treeId),
                                    names = [],
                                    ids = [],
                                    nodes = tree.getCheckedNodes(true)
                                    nodes.forEach(function (n, i) {
                                        names.push(n.Name)
                                        ids.push(n.Id)
                                    })
                                    mvvm.entity.$model.DepartIds = ids.join(',').toString();
                                    mvvm.entity.DepartIdName = names.join('，').toString()
                                }
                            }
                        }
                    }
                    vm.dateOpts = {
                        format: '%Y-%m-%d',
                        onSelect: function (date, formatDate, format) { }
                    }
                    vm.customerDetail = function (url) {
                        goto(url)
                    }
                })

                mvvm.entity = avalon.mix({}, searchMode);
                function getDataList(data) {
                    $.get('/Report/MaxOrders', data || searchMode, function (result) {
                        mvvm.dataList = result.data;
                    })
                }
                getDataList()
                CBCRM.fillContent(tmpl, lang, contentId, module, mvvm);
                CBCRM.onLoadModuleBefore = function () {
                    avalon.vmodels.Index = null;
                    if (avalon.vmodels.setGroup)
                        avalon.vmodels.setGroup.destroy()
                }
            },

            ///合同数量最多的类型
            MaxOrdersCategory: function (tmpl, lang, contentId, module) {
                var CBCRM = avalon.vmodels.CBCRM
                var mvvm = avalon.define('MaxOrdersCategory', function (vm) {
                    vm.entity = {}
                    vm.dataList = []
                    vm.show = false
                    vm.search = function () {
                        getDataList(mvvm.entity.$model)
                    }
                    vm.allDeaprt = function () {
                        mvvm.show = false;
                        mvvm.entity.$model.DepartIds = '';
                        mvvm.entity.DepartIdName = '';
                    }
                    vm.selectDeaprt = function () {
                        mvvm.show = true;
                    }
                    vm.clear = function () {
                        mvvm.entity = avalon.mix({}, searchMode);
                        getDataList(mvvm.entity.$model)
                    }
                    //选择部门
                    vm.postGroupTreeOpts = {
                        treeopts: {
                            check: {
                                enable: true,
                                chkboxType: { "Y": "s", "N": "s" },
                            },
                            async: {
                                enable: true,
                                url: '/Settings/GetGroupPostUser/102000000/'
                            },
                            callback: {
                                onCheck: function (event, treeId, treeNode) {
                                    tree = $.fn.zTree.getZTreeObj(treeId),
                                    names = [],
                                    ids = [],
                                    nodes = tree.getCheckedNodes(true)
                                    nodes.forEach(function (n, i) {
                                        names.push(n.Name)
                                        ids.push(n.Id)
                                    })
                                    mvvm.entity.$model.DepartIds = ids.join(',').toString();
                                    mvvm.entity.DepartIdName = names.join('，').toString()
                                }
                            }
                        }
                    }
                    vm.dateOpts = {
                        format: '%Y-%m-%d',
                        onSelect: function (date, formatDate, format) { }
                    }
                })

                mvvm.entity = avalon.mix({}, searchMode);
                function getDataList(data) {
                    $.get('/Report/MaxOrdersCategory', data || searchMode, function (result) {
                        mvvm.dataList = result.data;
                    })
                }
                getDataList()
                CBCRM.fillContent(tmpl, lang, contentId, module, mvvm);
                CBCRM.onLoadModuleBefore = function () {
                    avalon.vmodels.Index = null;
                    if (avalon.vmodels.setGroup)
                        avalon.vmodels.setGroup.destroy()
                }
            },

            ///机会最多的销售阶段
            MaxSales: function (tmpl, lang, contentId, module) {
                var CBCRM = avalon.vmodels.CBCRM
                var mvvm = avalon.define('MaxSales', function (vm) {
                    vm.entity = {}
                    vm.dataList = []
                    vm.show = false
                    vm.search = function () {
                        getDataList(mvvm.entity.$model)
                    }
                    vm.allDeaprt = function () {
                        mvvm.show = false;
                        mvvm.entity.$model.DepartIds = '';
                        mvvm.entity.DepartIdName = '';
                    }
                    vm.selectDeaprt = function () {
                        mvvm.show = true;
                    }
                    vm.clear = function () {
                        mvvm.entity = avalon.mix({}, searchMode);
                        getDataList(mvvm.entity.$model)
                    }
                    //选择部门
                    vm.postGroupTreeOpts = {
                        treeopts: {
                            check: {
                                enable: true,
                                chkboxType: { "Y": "s", "N": "s" },
                            },
                            async: {
                                enable: true,
                                url: '/Settings/GetGroupPostUser/102000000/'
                            },
                            callback: {
                                onCheck: function (event, treeId, treeNode) {
                                    tree = $.fn.zTree.getZTreeObj(treeId),
                                    names = [],
                                    ids = [],
                                    nodes = tree.getCheckedNodes(true)
                                    nodes.forEach(function (n, i) {
                                        names.push(n.Name)
                                        ids.push(n.Id)
                                    })
                                    mvvm.entity.$model.DepartIds = ids.join(',').toString();
                                    mvvm.entity.DepartIdName = names.join('，').toString()
                                }
                            }
                        }
                    }
                    vm.dateOpts = {
                        format: '%Y-%m-%d',
                        onSelect: function (date, formatDate, format) { }
                    }
                })

                mvvm.entity = avalon.mix({}, searchMode);
                function getDataList(data) {
                    $.get('/Report/MaxSales', data || searchMode, function (result) {
                        mvvm.dataList = result.data;
                    })
                }
                getDataList()
                CBCRM.fillContent(tmpl, lang, contentId, module, mvvm);
                CBCRM.onLoadModuleBefore = function () {
                    avalon.vmodels.Index = null;
                    if (avalon.vmodels.setGroup)
                        avalon.vmodels.setGroup.destroy()
                }
            },

            ///来电次数最多的客户
            MaxCalls: function (tmpl, lang, contentId, module) {
                var CBCRM = avalon.vmodels.CBCRM
                var mvvm = avalon.define('MaxCalls', function (vm) {
                    vm.entity = {}
                    vm.dataList = []
                    vm.show = false
                    vm.search = function () {
                        getDataList(mvvm.entity.$model)
                    }
                    vm.allDeaprt = function () {
                        mvvm.show = false;
                        mvvm.entity.$model.DepartIds = '';
                        mvvm.entity.DepartIdName = '';
                    }
                    vm.selectDeaprt = function () {
                        mvvm.show = true;
                    }
                    vm.clear = function () {
                        mvvm.entity = avalon.mix({}, searchMode);
                        getDataList(mvvm.entity.$model)
                    }
                    //选择部门
                    vm.postGroupTreeOpts = {
                        treeopts: {
                            check: {
                                enable: true,
                                chkboxType: { "Y": "s", "N": "s" },
                            },
                            async: {
                                enable: true,
                                url: '/Settings/GetGroupPostUser/102000000/'
                            },
                            callback: {
                                onCheck: function (event, treeId, treeNode) {
                                    tree = $.fn.zTree.getZTreeObj(treeId),
                                    names = [],
                                    ids = [],
                                    nodes = tree.getCheckedNodes(true)
                                    nodes.forEach(function (n, i) {
                                        names.push(n.Name)
                                        ids.push(n.Id)
                                    })
                                    mvvm.entity.$model.DepartIds = ids.join(',').toString();
                                    mvvm.entity.DepartIdName = names.join('，').toString()
                                }
                            }
                        }
                    }
                    vm.dateOpts = {
                        format: '%Y-%m-%d',
                        onSelect: function (date, formatDate, format) { }
                    }
                    vm.customerDetail = function (url) {
                        goto(url)
                    }
                })

                mvvm.entity = avalon.mix({}, searchMode);
                function getDataList(data) {
                    $.get('/Report/MaxCalls', data || searchMode, function (result) {
                        mvvm.dataList = result.data;
                    })
                }
                getDataList()
                CBCRM.fillContent(tmpl, lang, contentId, module, mvvm);
                CBCRM.onLoadModuleBefore = function () {
                    avalon.vmodels.Index = null;
                    if (avalon.vmodels.setGroup)
                        avalon.vmodels.setGroup.destroy()
                }
            },

            ///投诉最多的客户
            MaxComplaints: function (tmpl, lang, contentId, module) {
                var CBCRM = avalon.vmodels.CBCRM
                var mvvm = avalon.define('MaxComplaints', function (vm) {
                    vm.entity = {}
                    vm.dataList = []
                    vm.show = false
                    vm.search = function () {
                        getDataList(mvvm.entity.$model)
                    }
                    vm.allDeaprt = function () {
                        mvvm.show = false;
                        mvvm.entity.$model.DepartIds = '';
                        mvvm.entity.DepartIdName = '';
                    }
                    vm.selectDeaprt = function () {
                        mvvm.show = true;
                    }
                    vm.clear = function () {
                        mvvm.entity = avalon.mix({}, searchMode);
                        getDataList(mvvm.entity.$model)
                    }
                    //选择部门
                    vm.postGroupTreeOpts = {
                        treeopts: {
                            check: {
                                enable: true,
                                chkboxType: { "Y": "s", "N": "s" },
                            },
                            async: {
                                enable: true,
                                url: '/Settings/GetGroupPostUser/102000000/'
                            },
                            callback: {
                                onCheck: function (event, treeId, treeNode) {
                                    tree = $.fn.zTree.getZTreeObj(treeId),
                                    names = [],
                                    ids = [],
                                    nodes = tree.getCheckedNodes(true)
                                    nodes.forEach(function (n, i) {
                                        names.push(n.Name)
                                        ids.push(n.Id)
                                    })
                                    mvvm.entity.$model.DepartIds = ids.join(',').toString();
                                    mvvm.entity.DepartIdName = names.join('，').toString()
                                }
                            }
                        }
                    }
                    vm.dateOpts = {
                        format: '%Y-%m-%d',
                        onSelect: function (date, formatDate, format) { }
                    }
                    vm.customerDetail = function (url) {
                        goto(url)
                    }
                })

                mvvm.entity = avalon.mix({}, searchMode);
                function getDataList(data) {
                    $.get('/Report/MaxComplaints', data || searchMode, function (result) {
                        mvvm.dataList = result.data;
                    })
                }
                getDataList()
                CBCRM.fillContent(tmpl, lang, contentId, module, mvvm);
                CBCRM.onLoadModuleBefore = function () {
                    avalon.vmodels.Index = null;
                    if (avalon.vmodels.setGroup)
                        avalon.vmodels.setGroup.destroy()
                }
            },

            ///被投诉最多的员工
            ComplaintsEmp: function (tmpl, lang, contentId, module) {
                var CBCRM = avalon.vmodels.CBCRM
                var mvvm = avalon.define('ComplaintsEmp', function (vm) {
                    vm.entity = {}
                    vm.dataList = []
                    vm.show = false
                    vm.search = function () {
                        getDataList(mvvm.entity.$model)
                    }
                    vm.allDeaprt = function () {
                        mvvm.show = false;
                        mvvm.entity.$model.DepartIds = '';
                        mvvm.entity.DepartIdName = '';
                    }
                    vm.selectDeaprt = function () {
                        mvvm.show = true;
                    }
                    vm.clear = function () {
                        mvvm.entity = avalon.mix({}, searchMode);
                        getDataList(mvvm.entity.$model)
                    }
                    //选择部门
                    vm.postGroupTreeOpts = {
                        treeopts: {
                            check: {
                                enable: true,
                                chkboxType: { "Y": "s", "N": "s" },
                            },
                            async: {
                                enable: true,
                                url: '/Settings/GetGroupPostUser/102000000/'
                            },
                            callback: {
                                onCheck: function (event, treeId, treeNode) {
                                    tree = $.fn.zTree.getZTreeObj(treeId),
                                    names = [],
                                    ids = [],
                                    nodes = tree.getCheckedNodes(true)
                                    nodes.forEach(function (n, i) {
                                        names.push(n.Name)
                                        ids.push(n.Id)
                                    })
                                    mvvm.entity.$model.DepartIds = ids.join(',').toString();
                                    mvvm.entity.DepartIdName = names.join('，').toString()
                                }
                            }
                        }
                    }
                    vm.dateOpts = {
                        format: '%Y-%m-%d',
                        onSelect: function (date, formatDate, format) { }
                    }
                })

                mvvm.entity = avalon.mix({}, searchMode);
                function getDataList(data) {
                    $.get('/Report/ComplaintsEmp', data || searchMode, function (result) {
                        mvvm.dataList = result.data;
                    })
                }
                getDataList()
                CBCRM.fillContent(tmpl, lang, contentId, module, mvvm);
                CBCRM.onLoadModuleBefore = function () {
                    avalon.vmodels.Index = null;
                    if (avalon.vmodels.setGroup)
                        avalon.vmodels.setGroup.destroy()
                }
            },

            ///服务最多的客户
            MaxCusServices: function (tmpl, lang, contentId, module) {
                var CBCRM = avalon.vmodels.CBCRM
                var mvvm = avalon.define('MaxCusServices', function (vm) {
                    vm.entity = {}
                    vm.dataList = []
                    vm.show = false
                    vm.search = function () {
                        getDataList(mvvm.entity.$model)
                    }
                    vm.allDeaprt = function () {
                        mvvm.show = false;
                        mvvm.entity.$model.DepartIds = '';
                        mvvm.entity.DepartIdName = '';
                    }
                    vm.selectDeaprt = function () {
                        mvvm.show = true;
                    }
                    vm.clear = function () {
                        mvvm.entity = avalon.mix({}, searchMode);
                        getDataList(mvvm.entity.$model)
                    }
                    //选择部门
                    vm.postGroupTreeOpts = {
                        treeopts: {
                            check: {
                                enable: true,
                                chkboxType: { "Y": "s", "N": "s" },
                            },
                            async: {
                                enable: true,
                                url: '/Settings/GetGroupPostUser/102000000/'
                            },
                            callback: {
                                onCheck: function (event, treeId, treeNode) {
                                    tree = $.fn.zTree.getZTreeObj(treeId),
                                    names = [],
                                    ids = [],
                                    nodes = tree.getCheckedNodes(true)
                                    nodes.forEach(function (n, i) {
                                        names.push(n.Name)
                                        ids.push(n.Id)
                                    })
                                    mvvm.entity.$model.DepartIds = ids.join(',').toString();
                                    mvvm.entity.DepartIdName = names.join('，').toString()
                                }
                            }
                        }
                    }
                    vm.dateOpts = {
                        format: '%Y-%m-%d',
                        onSelect: function (date, formatDate, format) { }
                    }
                    vm.customerDetail = function (url) {
                        goto(url)
                    }
                })

                mvvm.entity = avalon.mix({}, searchMode);
                function getDataList(data) {
                    $.get('/Report/MaxCusServices', data || searchMode, function (result) {
                        mvvm.dataList = result.data;
                    })
                }
                getDataList()
                CBCRM.fillContent(tmpl, lang, contentId, module, mvvm);
                CBCRM.onLoadModuleBefore = function () {
                    avalon.vmodels.Index = null;
                    if (avalon.vmodels.setGroup)
                        avalon.vmodels.setGroup.destroy()
                }
            },

            ///关怀最多的客户
            MaxFollowup: function (tmpl, lang, contentId, module) {
                var CBCRM = avalon.vmodels.CBCRM
                var mvvm = avalon.define('MaxFollowup', function (vm) {
                    vm.entity = {}
                    vm.dataList = []
                    vm.show = false
                    vm.search = function () {
                        getDataList(mvvm.entity.$model)
                    }
                    vm.allDeaprt = function () {
                        mvvm.show = false;
                        mvvm.entity.$model.DepartIds = '';
                        mvvm.entity.DepartIdName = '';
                    }
                    vm.selectDeaprt = function () {
                        mvvm.show = true;
                    }
                    vm.clear = function () {
                        mvvm.entity = avalon.mix({}, searchMode);
                        getDataList(mvvm.entity.$model)
                    }
                    //选择部门
                    vm.postGroupTreeOpts = {
                        treeopts: {
                            check: {
                                enable: true,
                                chkboxType: { "Y": "s", "N": "s" },
                            },
                            async: {
                                enable: true,
                                url: '/Settings/GetGroupPostUser/102000000/'
                            },
                            callback: {
                                onCheck: function (event, treeId, treeNode) {
                                    tree = $.fn.zTree.getZTreeObj(treeId),
                                    names = [],
                                    ids = [],
                                    nodes = tree.getCheckedNodes(true)
                                    nodes.forEach(function (n, i) {
                                        names.push(n.Name)
                                        ids.push(n.Id)
                                    })
                                    mvvm.entity.$model.DepartIds = ids.join(',').toString();
                                    mvvm.entity.DepartIdName = names.join('，').toString()
                                }
                            }
                        }
                    }
                    vm.dateOpts = {
                        format: '%Y-%m-%d',
                        onSelect: function (date, formatDate, format) { }
                    }
                    vm.customerDetail = function (url) {
                        goto(url)
                    }
                })

                mvvm.entity = avalon.mix({}, searchMode);
                function getDataList(data) {
                    $.get('/Report/MaxFollowup', data || searchMode, function (result) {
                        mvvm.dataList = result.data;
                    })
                }
                getDataList()
                CBCRM.fillContent(tmpl, lang, contentId, module, mvvm);
                CBCRM.onLoadModuleBefore = function () {
                    avalon.vmodels.Index = null;
                    if (avalon.vmodels.setGroup)
                        avalon.vmodels.setGroup.destroy()
                }
            },

            ///拥有客户最多的员工
            MaxCustomer: function (tmpl, lang, contentId, module) {
                var CBCRM = avalon.vmodels.CBCRM
                var mvvm = avalon.define('MaxCustomerController', function (vm) {
                    vm.dataList = [];
                    vm.entity = {};
                    vm.show = false;
                    vm.search = function () {
                        $.get('/Report/MaxCustomer', mvvm.entity.$model, function (result) {
                            mvvm.dataList = result.data;
                        })
                    }
                    vm.dateOpts = {
                        format: '%Y-%m-%d',
                        onSelect: function (date, formatDate, format) {
                        }
                    }
                    vm.allDeaprt = function () {
                        mvvm.show = false;
                        mvvm.entity.$model.DepartIds = '';
                        mvvm.entity.DepartIdName = '';
                    }
                    vm.selectDeaprt = function () {
                        mvvm.show = true;
                    }
                    vm.clear = function () {

                        mvvm.entity = searchMode;
                    }

                    //选择部门
                    vm.postGroupTreeOpts = {
                        treeopts: {
                            check: {
                                enable: true,
                                chkboxType: { "Y": "s", "N": "s" },
                            },
                            async: {
                                enable: true,
                                url: '/Settings/GetGroupPostUser/102000000/'
                            },
                            callback: {
                                onCheck: function (event, treeId, treeNode) {
                                    tree = $.fn.zTree.getZTreeObj(treeId),
                                    names = [],
                                    ids = [],
                                    nodes = tree.getCheckedNodes(true)
                                    nodes.forEach(function (n, i) {
                                        names.push(n.Name)
                                        ids.push(n.Id)
                                    })
                                    mvvm.entity.$model.DepartIds = ids.join(',').toString();
                                    mvvm.entity.DepartIdName = names.join('，').toString()
                                }
                            }
                        }
                    }
                });

                getDataList();

                function getDataList() {
                    $.get('/Report/MaxCustomer', searchMode, function (result) {
                        mvvm.dataList = result.data;
                    })
                }
                mvvm.entity = searchMode;
                CBCRM.fillContent(tmpl, lang, contentId, module, mvvm);
                CBCRM.onLoadModuleBefore = function () {
                    avalon.vmodels.Index = null;
                    avalon.vmodels.setGroup.destroy()
                }
            },

            ///签单最多的员工
            MaxSignBill: function (tmpl, lang, contentId, module) {
                var CBCRM = avalon.vmodels.CBCRM

                var mvvm = avalon.define('MaxSignBillController', function (vm) {
                    vm.dataList = [];
                    vm.entity = {};
                    vm.show = false;
                    vm.search = function () {
                        $.get('/Report/MaxSignBill', mvvm.entity.$model, function (result) {
                            mvvm.dataList = result.data;
                        })
                    }
                    vm.dateOpts = {
                        format: '%Y-%m-%d',
                        onSelect: function (date, formatDate, format) {
                            mvvm.EndDate = formatDate;
                        }
                    }
                    vm.allDeaprt = function () {
                        mvvm.show = false;
                        mvvm.entity.$model.DepartIds = '';
                        mvvm.entity.DepartIdName = '';
                    }
                    vm.selectDeaprt = function () {
                        mvvm.show = true;
                    }
                    vm.clear = function () {

                        mvvm.entity = searchMode;
                    }

                    //选择部门
                    vm.postGroupTreeOpts = {
                        treeopts: {
                            check: {
                                enable: true,
                                chkboxType: { "Y": "s", "N": "s" },
                            },
                            async: {
                                enable: true,
                                url: '/Settings/GetGroupPostUser/102000000/'
                            },
                            callback: {
                                onCheck: function (event, treeId, treeNode) {

                                    tree = $.fn.zTree.getZTreeObj(treeId),

                                    names = [],
                                    ids = [],
                                    nodes = tree.getCheckedNodes(true)
                                    nodes.forEach(function (n, i) {
                                        names.push(n.Name)
                                        ids.push(n.Id)
                                    })
                                    mvvm.entity.$model.DepartIds = ids.join(',').toString();
                                    mvvm.entity.DepartIdName = names.join('，').toString()
                                }
                            }
                        }
                    }
                });

                getDataList();

                function getDataList() {
                    $.get('/Report/MaxSignBill', searchMode, function (result) {
                        mvvm.dataList = result.data;
                    })
                }
                mvvm.entity = searchMode;
                CBCRM.fillContent(tmpl, lang, contentId, module, mvvm);
                CBCRM.onLoadModuleBefore = function () {
                    avalon.vmodels.Index = null;
                    avalon.vmodels.setGroup.destroy()
                }
            },

            ///入职时间最长的员工
            MaxOnJob: function (tmpl, lang, contentId, module) {
                var CBCRM = avalon.vmodels.CBCRM

                var mvvm = avalon.define('MaxOnJobController', function (vm) {
                    vm.dataList = [];
                    vm.entity = {};
                    vm.show = false;
                    vm.search = function () {
                        $.get('/Report/MaxOnJob', mvvm.entity.$model, function (result) {
                            mvvm.dataList = result.data;
                        })
                    }
                    vm.dateOpts = {
                        format: '%Y-%m-%d',
                        onSelect: function (date, formatDate, format) {
                            mvvm.EndDate = formatDate;
                        }
                    }
                    vm.allDeaprt = function () {
                        mvvm.show = false;
                        mvvm.entity.$model.DepartIds = '';
                        mvvm.entity.DepartIdName = '';
                    }
                    vm.selectDeaprt = function () {
                        mvvm.show = true;
                    }
                    vm.clear = function () {

                        mvvm.entity = searchMode;
                    }

                    //选择部门
                    vm.postGroupTreeOpts = {
                        treeopts: {
                            check: {
                                enable: true,
                                chkboxType: { "Y": "s", "N": "s" },
                            },
                            async: {
                                enable: true,
                                url: '/Settings/GetGroupPostUser/102000000/'
                            },
                            callback: {
                                onCheck: function (event, treeId, treeNode) {

                                    tree = $.fn.zTree.getZTreeObj(treeId),

                                    names = [],
                                    ids = [],
                                    nodes = tree.getCheckedNodes(true)
                                    nodes.forEach(function (n, i) {
                                        names.push(n.Name)
                                        ids.push(n.Id)
                                    })
                                    mvvm.entity.$model.DepartIds = ids.join(',').toString();
                                    mvvm.entity.DepartIdName = names.join('，').toString()
                                }
                            }
                        }
                    }
                });

                getDataList();

                function getDataList() {
                    $.get('/Report/MaxOnJob', searchMode, function (result) {
                        mvvm.dataList = result.data;
                    })
                }
                mvvm.entity = searchMode;
                CBCRM.fillContent(tmpl, lang, contentId, module, mvvm);
                CBCRM.onLoadModuleBefore = function () {
                    avalon.vmodels.Index = null
                    avalon.vmodels.setGroup.destroy()
                }
            },

            ///流失老客户最多的员工
            MaxDrainCustomer: function (tmpl, lang, contentId, module) {
                var CBCRM = avalon.vmodels.CBCRM

                var mvvm = avalon.define('MaxDrainCustomerController', function (vm) {
                    vm.dataList = [];
                    vm.entity = {};
                    vm.show = false;
                    vm.search = function () {
                        $.get('/Report/MaxDrainCustomer', mvvm.entity.$model, function (result) {
                            mvvm.dataList = result.data;
                        })
                    }
                    vm.dateOpts = {
                        format: '%Y-%m-%d',
                        onSelect: function (date, formatDate, format) {
                            mvvm.EndDate = formatDate;
                        }
                    }
                    vm.allDeaprt = function () {
                        mvvm.show = false;
                        mvvm.entity.$model.DepartIds = '';
                        mvvm.entity.DepartIdName = '';
                    }
                    vm.selectDeaprt = function () {
                        mvvm.show = true;
                    }
                    vm.clear = function () {

                        mvvm.entity = searchMode;
                    }

                    //选择部门
                    vm.postGroupTreeOpts = {
                        treeopts: {
                            check: {
                                enable: true,
                                chkboxType: { "Y": "s", "N": "s" },
                            },
                            async: {
                                enable: true,
                                url: '/Settings/GetGroupPostUser/102000000/'
                            },
                            callback: {
                                onCheck: function (event, treeId, treeNode) {

                                    tree = $.fn.zTree.getZTreeObj(treeId),

                                    names = [],
                                    ids = [],
                                    nodes = tree.getCheckedNodes(true)
                                    nodes.forEach(function (n, i) {
                                        names.push(n.Name)
                                        ids.push(n.Id)
                                    })
                                    mvvm.entity.$model.DepartIds = ids.join(',').toString();
                                    mvvm.entity.DepartIdName = names.join('，').toString()
                                }
                            }
                        }
                    }
                });

                getDataList();

                function getDataList() {
                    $.get('/Report/MaxDrainCustomer', searchMode, function (result) {
                        mvvm.dataList = result.data;
                    })
                }
                mvvm.entity = searchMode;
                CBCRM.fillContent(tmpl, lang, contentId, module, mvvm);
                CBCRM.onLoadModuleBefore = function () {
                    avalon.vmodels.Index = null
                    avalon.vmodels.setGroup.destroy()
                }
            },

            ///跟单失败最多的员工
            MaxFailCustomer: function (tmpl, lang, contentId, module) {
                var CBCRM = avalon.vmodels.CBCRM

                var mvvm = avalon.define('MaxFailCustomerController', function (vm) {
                    vm.dataList = [];
                    vm.entity = {};
                    vm.show = false;
                    vm.search = function () {
                        $.get('/Report/MaxFailCustomer', mvvm.entity.$model, function (result) {
                            mvvm.dataList = result.data;
                        })
                    }
                    vm.dateOpts = {
                        format: '%Y-%m-%d',
                        onSelect: function (date, formatDate, format) {
                            mvvm.EndDate = formatDate;
                        }
                    }
                    vm.allDeaprt = function () {
                        mvvm.show = false;
                        mvvm.entity.$model.DepartIds = '';
                        mvvm.entity.DepartIdName = '';
                    }
                    vm.selectDeaprt = function () {
                        mvvm.show = true;
                    }
                    vm.clear = function () {

                        mvvm.entity = searchMode;
                    }

                    //选择部门
                    vm.postGroupTreeOpts = {
                        treeopts: {
                            check: {
                                enable: true,
                                chkboxType: { "Y": "s", "N": "s" },
                            },
                            async: {
                                enable: true,
                                url: '/Settings/GetGroupPostUser/102000000/'
                            },
                            callback: {
                                onCheck: function (event, treeId, treeNode) {

                                    tree = $.fn.zTree.getZTreeObj(treeId),

                                    names = [],
                                    ids = [],
                                    nodes = tree.getCheckedNodes(true)
                                    nodes.forEach(function (n, i) {
                                        names.push(n.Name)
                                        ids.push(n.Id)
                                    })
                                    mvvm.entity.$model.DepartIds = ids.join(',').toString();
                                    mvvm.entity.DepartIdName = names.join('，').toString()
                                }
                            }
                        }
                    }
                });

                getDataList();

                function getDataList() {
                    $.get('/Report/MaxFailCustomer', searchMode, function (result) {
                        mvvm.dataList = result.data;
                    })
                }
                mvvm.entity = searchMode;
                CBCRM.fillContent(tmpl, lang, contentId, module, mvvm);
                CBCRM.onLoadModuleBefore = function () {
                    avalon.vmodels.Index = null
                    avalon.vmodels.setGroup.destroy()
                }
            },

            ///购买次数最多的客户
            MaxBuyCount: function (tmpl, lang, contentId, module) {
                var CBCRM = avalon.vmodels.CBCRM

                var mvvm = avalon.define('MaxBuyCountController', function (vm) {
                    vm.dataList = [];
                    vm.entity = {};
                    vm.show = false;
                    vm.search = function () {
                        $.get('/Report/MaxBuyCount', mvvm.entity.$model, function (result) {
                            mvvm.dataList = result.data;
                        })
                    }
                    vm.dateOpts = {
                        format: '%Y-%m-%d',
                        onSelect: function (date, formatDate, format) {
                            mvvm.EndDate = formatDate;
                        }
                    }

                    vm.clear = function () {

                        mvvm.entity = searchMode;
                    }

                });

                getDataList();

                function getDataList() {
                    $.get('/Report/MaxBuyCount', searchMode, function (result) {
                        mvvm.dataList = result.data;
                    })
                }
                mvvm.entity = searchMode;
                CBCRM.fillContent(tmpl, lang, contentId, module, mvvm);
                CBCRM.onLoadModuleBefore = function () {
                    avalon.vmodels.Index = null
                }
            },

            ///购买金额最大的客户
            MaxBuyMoney: function (tmpl, lang, contentId, module) {
                var CBCRM = avalon.vmodels.CBCRM

                var mvvm = avalon.define('MaxBuyMoneyController', function (vm) {
                    vm.dataList = [];
                    vm.entity = {};
                    vm.show = false;
                    vm.search = function () {
                        $.get('/Report/MaxBuyMoney', mvvm.entity.$model, function (result) {
                            mvvm.dataList = result.data;
                        })
                    }
                    vm.dateOpts = {
                        format: '%Y-%m-%d',
                        onSelect: function (date, formatDate, format) {
                            mvvm.EndDate = formatDate;
                        }
                    }

                    vm.clear = function () {

                        mvvm.entity = searchMode;
                    }

                });

                getDataList();

                function getDataList() {
                    $.get('/Report/MaxBuyMoney', searchMode, function (result) {
                        mvvm.dataList = result.data;
                    })
                }
                mvvm.entity = searchMode;
                CBCRM.fillContent(tmpl, lang, contentId, module, mvvm);
                CBCRM.onLoadModuleBefore = function () {
                    avalon.vmodels.Index = null
                }
            },

            ///收入最高的业务
            MaxBusiness: function (tmpl, lang, contentId, module) {
                var CBCRM = avalon.vmodels.CBCRM

                var mvvm = avalon.define('MaxBusiness', function (vm) {
                    vm.dataList = [];
                    vm.entity = {};
                    vm.show = false;
                    vm.search = function () {
                        $.get('/Report/MaxBusiness', mvvm.entity.$model, function (result) {
                            mvvm.dataList = result.data;
                        })
                    }
                    vm.dateOpts = {
                        format: '%Y-%m-%d',
                        onSelect: function (date, formatDate, format) {
                            mvvm.EndDate = formatDate;
                        }
                    }

                    vm.clear = function () {

                        mvvm.entity = searchMode;
                    }

                });

                getDataList();

                function getDataList() {
                    $.get('/Report/MaxBusiness', searchMode, function (result) {
                        mvvm.dataList = result.data;
                    })
                }
                mvvm.entity = searchMode;
                CBCRM.fillContent(tmpl, lang, contentId, module, mvvm);
                CBCRM.onLoadModuleBefore = function () {
                    avalon.vmodels.Index = null
                }
            },

            ///收入最高的业务
            MaxMonth: function (tmpl, lang, contentId, module) {
                var CBCRM = avalon.vmodels.CBCRM

                var mvvm = avalon.define('MaxMonth', function (vm) {
                    vm.dataList = [];
                    vm.entity = {};
                    vm.show = false;
                    vm.search = function () {
                        $.get('/Report/MaxMonth', mvvm.entity.$model, function (result) {
                            mvvm.dataList = result.data;
                        })
                    }
                    vm.dateOpts = {
                        format: '%Y-%m-%d',
                        onSelect: function (date, formatDate, format) {
                            mvvm.EndDate = formatDate;
                        }
                    }

                    vm.clear = function () {

                        mvvm.entity = searchMode;
                    }

                });

                getDataList();

                function getDataList() {
                    $.get('/Report/MaxMonth', searchMode, function (result) {
                        mvvm.dataList = result.data;
                    })
                }
                mvvm.entity = searchMode;
                CBCRM.fillContent(tmpl, lang, contentId, module, mvvm);
                CBCRM.onLoadModuleBefore = function () {
                    avalon.vmodels.Index = null
                }
            },

            ///价格最高的产品
            MaxProducts: function (tmpl, lang, contentId, module) {
                var CBCRM = avalon.vmodels.CBCRM

                var mvvm = avalon.define('MaxProducts', function (vm) {
                    vm.dataList = [];
                    vm.entity = {};
                    vm.show = false;
                    vm.search = function () {
                        $.get('/Report/MaxProducts', mvvm.entity.$model, function (result) {
                            mvvm.dataList = result.data;
                        })
                    }
                    vm.dateOpts = {
                        format: '%Y-%m-%d',
                        onSelect: function (date, formatDate, format) {
                            mvvm.EndDate = formatDate;
                        }
                    }

                    vm.clear = function () {

                        mvvm.entity = searchMode;
                    }

                });

                getDataList();

                function getDataList() {
                    $.get('/Report/MaxProducts', searchMode, function (result) {
                        mvvm.dataList = result.data;
                    })
                }
                mvvm.entity = searchMode;
                CBCRM.fillContent(tmpl, lang, contentId, module, mvvm);
                CBCRM.onLoadModuleBefore = function () {
                    avalon.vmodels.Index = null
                }
            },

            ///库存最多的产品
            MaxStock: function (tmpl, lang, contentId, module) {
                var CBCRM = avalon.vmodels.CBCRM

                var mvvm = avalon.define('MaxStock', function (vm) {
                    vm.dataList = [];
                    vm.entity = {};
                    vm.show = false;
                    vm.search = function () {
                        $.get('/Report/MaxStock', mvvm.entity.$model, function (result) {
                            mvvm.dataList = result.data;
                        })
                    }
                    vm.dateOpts = {
                        format: '%Y-%m-%d',
                        onSelect: function (date, formatDate, format) {
                            mvvm.EndDate = formatDate;
                        }
                    }
                    vm.clear = function () {
                        mvvm.entity = searchMode;
                    }
                });
                getDataList();

                function getDataList() {
                    $.get('/Report/MaxStock', searchMode, function (result) {
                        mvvm.dataList = result.data;
                    })
                }
                mvvm.entity = searchMode;
                CBCRM.fillContent(tmpl, lang, contentId, module, mvvm);
                CBCRM.onLoadModuleBefore = function () {
                    avalon.vmodels.Index = null
                }
            },


            ///复合报表桌面
            Complex: function (tmpl, lang, contentId, module) {
                var CBCRM = avalon.vmodels.CBCRM
                var mvvm = avalon.define('ComplexController', function (vm) {
                    vm.table1 = []
                    vm.menus = [];
                    vm.getMenus = function () {
                        var lv2Menu = CBCRM.gps[1];
                        if (!lv2Menu) return;
                        var menus = [];
                        CBCRM.getChildMenus(lv2Menu, 1, false).forEach(function (m) {
                            menus.push($.extend(true, {}, m));
                        });
                        mvvm.menus = menus;
                    }
                });
                //改为从菜单处获取报表列表
                //getreportlist();
                mvvm.getMenus();
                function getreportlist() {

                    $.get("/Report/Complex", {},
                    function (result) {
                        mvvm.table1 = result.data.tb1
                    });
                };
                CBCRM.fillContent(tmpl, lang, contentId, module, mvvm);
                CBCRM.onLoadModuleBefore = function () {
                    avalon.vmodels.Index = null
                }
            },

            ///销售机会分析
            Jihui: function (tmpl, lang, contentId, module) {
                var CBCRM = avalon.vmodels.CBCRM
                var mvvm = avalon.define('JihuiController', function (vm) {
                    vm.dateOpts = {}
                    vm.total = 0
                    vm.expect = {}
                    vm.list = []
                    vm.entity = {}
                    vm.discover = {}
                    vm.opporStatus = {}
                    vm.possibility = {}
                    vm.followStage = {}
                    vm.customSource = {}
                    vm.followTag = {}
                    vm.clear = function () {
                        mvvm.entity = avalon.mix({}, { starTime: FirstDayOfThisYear(), endTime: Current(), DepartIds: '', DepartIdName: '', UserIds: '', UserIdName: '' });
                    }
                    vm.allDeaprt = function () {
                        initWithData()
                    }
                    //查询
                    vm.search = function () {
                        initWithData(mvvm.entity.$model)
                    }
                    vm.selectDeaprt = function () { }
                    vm.selectUser = function () { }
                    vm.show = 0
                    vm.showchange = function (val) {
                        mvvm.show = val
                    }
                    //选择部门
                    vm.postGroupTreeOpts = {
                        treeopts: {
                            check: {
                                enable: true,
                                chkboxType: { "Y": "s", "N": "s" },
                            },
                            async: {
                                enable: true,
                                url: '/Settings/GetGroupPostUser/104000000/'
                            },
                            callback: {
                                onCheck: function (event, treeId, treeNode) {
                                    tree = $.fn.zTree.getZTreeObj(treeId),
                                    names = [],
                                    ids = [],
                                    nodes = tree.getCheckedNodes(true)
                                    nodes.forEach(function (n, i) {
                                        names.push(n.Name)
                                        ids.push(n.Id)
                                    })
                                    mvvm.entity.DepartIds = ids.join(',').toString();
                                    mvvm.entity.DepartIdName = names.join(',').toString()
                                }
                            }
                        }
                    }

                    vm.UserGroupTreeOpts = {
                        treeopts: {
                            check: {
                                enable: true,
                                chkboxType: { "Y": "s", "N": "s" },
                            },

                            callback: {
                                onCheck: function (event, treeId, treeNode) {
                                    tree = $.fn.zTree.getZTreeObj(treeId),
                                    names = [],
                                    ids = [],
                                    nodes = tree.getCheckedNodes(true)
                                    nodes.forEach(function (n, i) {
                                        names.push(n.Name)
                                        ids.push(n.Id)
                                    })
                                    mvvm.entity.UserIds = ids.join(',').toString();
                                    mvvm.entity.UserIdName = names.join(',').toString()
                                }
                            },
                            async: {
                                url: function (treeId, treeNode) {
                                    return "/Settings/GetGroupPostUser/104000000"
                                },
                                dataFilter: notMemberFilter
                            }

                        }
                    }
                    vm.stDateOpts = {
                        format: '%Y-%m-%d',
                        onSelect: function (date, formatDate, format) {
                            mvvm.entity.starTime = formatDate
                        }
                    }
                    vm.edDateOpts = {
                        format: '%Y-%m-%d',
                        onSelect: function (date, formatDate, format) {
                            mvvm.entity.endTime = formatDate
                        }
                    }
                });

                var query = {
                    starTime: FirstDayOfThisYear(), endTime: Current(), DepartIds: '', DepartIdName: '', UserIds: '', UserIdName: ''
                }
                mvvm.entity = avalon.mix({}, query);
                mvvm.expect = avalon.mix({}, { data: [], models: [], total: 0 });
                mvvm.opporStatus = avalon.mix({}, { data: [], models: [], total: 0 });
                mvvm.possibility = avalon.mix({}, { data: [], models: [], total: 0 });
                mvvm.followStage = avalon.mix({}, { data: [], models: [], total: 0 });
                mvvm.discover = avalon.mix({}, { data: [], models: [], total: 0 });
                mvvm.customSource = avalon.mix({}, { data: [], models: [], total: 0 });
                mvvm.followTag = avalon.mix({}, { data: [], models: [], total: 0 });

                function initWithData(data) {
                    $.get('/Report/Jihui', data || query, function (ret) {
                        if (ret.result) {
                            var m = ret.data.expect
                            mvvm.expect.models = m.models;
                            mvvm.opporStatus.models = ret.data.oppoState.models;
                            mvvm.possibility.models = ret.data.possibility.models;
                            mvvm.followStage.models = ret.data.followStage.models;
                            mvvm.discover.models = ret.data.discover.models;
                            mvvm.discover.total = ret.data.discover.total;
                            mvvm.customSource.models = ret.data.customSource.models;
                            mvvm.customSource.total = ret.data.customSource.total;
                            mvvm.followTag.total = ret.data.followTag.total;
                            mvvm.followTag.models = ret.data.followTag.models;
                            mvvm.opporStatus.total = ret.data.oppoState.total;
                            mvvm.expect.total = ret.data.expect.total;
                            mvvm.possibility.total = ret.data.possibility.total;
                            mvvm.followStage.total = ret.data.followStage.total;
                            //预签单日期/预签金额
                            createJQLinear("#chartRight","预签单日期/预签金额",ret.data.expect.data);
                            
                            //机会状态
                            //createColumnChartWithTitle(ret.data.oppoState.data, "机会状态", 'Jihui', '60%', '300px');
                            createJQBar("#Jihui", "机会状态", ret.data.oppoState.data);
                            //签单可能性
                            createJQPieChart("#Possibility", "签单可能性", ret.data.possibility.data);
                            //跟单阶段
                            //createColumnChartWithTitle(ret.data.followStage.data, "跟单阶段", 'followStage', '60%', '300px');
                            createJQBar('#followStage',"跟单阶段",ret.data.followStage.data);
                            //销售机会发现时间/数量
                            createJQLinear("#DisChart", "销售机会发现时间/数量", ret.data.discover.data);
                            //销售机会来源
                            //createColumnChartWithTitle(ret.data.customSource.data, "销售机会来源", 'customSource', '60%', '300px');
                            createJQBar('#customSource', "销售机会来源", ret.data.customSource.data);
                            //跟单表情
                            createJQPieChart("#followTag", "跟单标签", ret.data.followTag.data);
                        }
                    })
                }

                require("jqPlotPie,jqBar,jqPointLabels,jqCategory,jqCanvasText,jqCanvasAxisLabel,jqEnhancedLegend,jqPointLabel,jqCursor,jqHighlighter",
                function () {
                    initWithData();
                    CBCRM.fillContent(tmpl, lang, contentId, module, mvvm);
                });
                ///销毁
                CBCRM.onLoadModuleBefore = function () {
                    destroyui(["setGroup", "setUser"])
                    avalon.vmodels.Index = null;
                }
            },


            ///公司月度经营报表
            MonthComplex: function (tmpl, lang, contentId, module) {
                var CBCRM = avalon.vmodels.CBCRM
                var mvvm = avalon.define('MonthComplexController', function (vm) {
                    vm.entity = {
                        BYkhCount: 0,
                        BYZkhCount: 0,
                        QYkhCount: 0,
                        CustomerTP: 0,
                        CustomerHP: 0,
                        QZBYkhCount: 0,
                        QZBYZkhCount: 0,
                        QZQYkhCount: 0,
                        QZCustomerTP: 0,
                        QZCustomerHP: 0,
                        ZSBYkhCount: 0,
                        ZSBYZkhCount: 0,
                        ZSQYkhCount: 0,
                        ZSCustomerTP: 0,
                        ZSCustomerHP: 0,
                        LSBYkhCount: 0,
                        LSBYZkhCount: 0,
                        LSQYkhCount: 0,
                        LSCustomerTP: 0,
                        LSCustomerHP: 0,
                        BYSamount: 0,
                        BYZSamount: 0,
                        QYSamount: 0,
                        SamountTP: 0,
                        SamountHP: 0,
                        BYqdCount: 0,
                        BYZqdCount: 0,
                        QYqdCount: 0,
                        ContractTP: 0,
                        ContractHP: 0,
                        BYqdmoney: 0,
                        BYZqdmoney: 0,
                        QYqdmoney: 0,
                        ContractmoneyTP: 0,
                        ContractmoneyHP: 0,
                        BYZamount: 0,
                        BYZZamount: 0,
                        QYZamount: 0,
                        ZamountTP: 0,
                        ZamountHP: 0,
                        BYxjmoney: 0,
                        BYZxjmoney: 0,
                        QYxjmoney: 0,
                        xjmoneyTP: 0,
                        xjmoneyHP: 0,
                        BYyhmoney: 0,
                        BYZyhmoney: 0,
                        QYyhmoney: 0,
                        yhmoneyTP: 0,
                        yhmoneyHP: 0,
                        BYxnmoney: 0,
                        BYZxnmoney: 0,
                        QYxnmoney: 0,
                        xnmoneyTP: 0,
                        xnmoneyHP: 0,
                        BYfzmoney: 0,
                        BYZfzmoney: 0,
                        QYfzmoney: 0,
                        fzmoneyTP: 0,
                        fzmoneyHP: 0,
                        BYzqmoney: 0,
                        BYZzqmoney: 0,
                        QYzqmoney: 0,
                        zqmoneyTP: 0,
                        zqmoneyHP: 0,
                        BYproperty: 0,
                        BYZproperty: 0,
                        QYproperty: 0,
                        propertyTP: 0,
                        propertyHP: 0,
                        BYjproperty: 0,
                        BYZjproperty: 0,
                        QYjproperty: 0,
                        jpropertyTP: 0,
                        jpropertyHP: 0,
                        BYygCount: 0,
                        BYZygCount: 0,
                        QYygCount: 0,
                        EmployeeTP: 0,
                        EmployeeHP: 0,
                        BYSJygCount: 0,
                        BYZSJygCount: 0,
                        QYSJygCount: 0,
                        SJEmployeeTP: 0,
                        SJEmployeeHP: 0,
                        BYLZygCount: 0,
                        BYZLZygCount: 0,
                        QYLZygCount: 0,
                        LZEmployeeTP: 0,
                        LZEmployeeHP: 0,
                        BYldCount: 0,
                        BYZldCount: 0,
                        QYldCount: 0,
                        CallsTP: 0,
                        CallsHP: 0,
                        BYtsCount: 0,
                        BYZtsCount: 0,
                        QYtsCount: 0,
                        ComplaintsTP: 0,
                        ComplaintsHP: 0,
                        BYhfCount: 0,
                        BYZhfCount: 0,
                        QYhfCount: 0,
                        FollowUpTP: 0,
                        FollowUpHP: 0
                    }
                    vm.monthvalue = 1;
                    vm.monthtext = '一月';
                    vm.year = new Date().getFullYear();
                    vm.totaty = GetDateTime();

                    vm.search = function () {
                        vm.monthtext = $("#month option:selected").text();
                        $.get("/Report/MonthComplex", { month: mvvm.monthvalue },
                         function (result) {
                             mvvm.entity = result.data;
                         });
                    }

                });

                getreportlist();

                function getreportlist() {

                    $.get("/Report/MonthComplex", { month: mvvm.monthvalue },
                    function (result) {
                        mvvm.entity = result.data;
                    });
                };

                CBCRM.fillContent(tmpl, lang, contentId, module, mvvm);
                CBCRM.onLoadModuleBefore = function () {
                    avalon.vmodels.Index = null
                }
            },
            // 销售分析报表
            SalesComplex:function (tmpl, lang, contentId, module) {
                var CBCRM = avalon.vmodels.CBCRM, vmid = "SalesComplex";
                var mvvm = CBCRM.define(vmid, function (vm) {
                    vm.data = {
                        list: [],
                        newCustomer: 0,
                        signCustomer: 0,
                        signAmount:0,
                        newSignCustomer: 0,
                        oldSignCustomer: 0,
                        newSignPercent: 0,
                        oldSignPercent: 0
                    };
                    vm.sum = {signCount: 0,signAmount: 0,signAmountReturm:0,signAmountNotReturm:0}
                    vm.queryData = {
                        startTime: '', endTime: '', uids: ''
                    };
                    vm.createQuery = function () {
                        var data = {};
                        var m=mvvm.queryData.$model
                        for (var key in m) {
                            if (m[key]) data[key] = m[key];
                        }
                        return data;
                    }
                    vm.clearQuery = function () {
                        var m = mvvm.queryData.$model
                        for (var key in m) {
                            mvvm.queryData[key] = "";
                        }
                    }
                    vm.doSearch = function () {
                        var data = mvvm.createQuery();
                        mvvm.loadData(data);
                    }
                    vm.selectUser = function (act) {
                        if (act == 0) {
                            if (!mvvm.queryData.uids) return;
                            mvvm.queryData.uids = "";
                            mvvm.doSearch();
                            return;
                        } else {
                            var uids = mvvm.queryData.uids.split(",");
                            plugins.selectUser({
                                dataAuth: 103000001,/*复合报表查看权限id*/
                                listData: uids,
                                callback: function (us) {
                                    if (us.length == 0) {
                                        messageBox.warning("请选择员工！");
                                        return false;
                                    }
                                    uids = where(us,true, "Id");
                                    mvvm.queryData.uids = uids.join(",");
                                    mvvm.doSearch();
                                }
                            });
                        }

                    }
                    vm.loadData = function (data) {
                        $.post("/Report/SalesComplex", data, function (ret) {
                            if (!ret || !ret.result) return CBCRM.showResult(ret);
                            var list = [], dict = {};
                            var sum = mvvm.sum;
                            sum.signCount = list.length;
                            ret.data.list.forEach(function (item) {
                                var amount = item.Amount, amountReturn = item.ReturnedMoney;
                                sum.signAmount += amount;
                                if (amountReturn) sum.signAmountReturm += amountReturn;
                                var cid = item.Customer;
                                if (!dict[cid]) dict[cid] = {
                                    _type:"cu", Id: cid, Name: item.Name, AddTime: item.AddTime
                                };
                            });
                            sum.signAmountNotReturm = sum.signAmount - sum.signAmountReturm;
                            for (var key in dict) {
                                var cu = dict[key];
                                var cList = where(ret.data.list, function (c) { return c.Customer == cu.Id });
                                var cuSpan = 0,i=0;
                                list.push(cu);
                                cList.forEach(function (c) {
                                    i++;
                                    var pList = where(ret.data.pList, function (p) { return p.Contract == c.Id });
                                    c._type = "c";
                                    c.rowspan = pList.length||1;
                                    cuSpan += c.rowspan;
                                    c.firstp = pList.length > 0 ? pList.shift() : {};
                                    if (i == 1) {
                                        cu.firstc = c;
                                    }
                                    else list.push(c);
                                    pList.forEach(function (p) {
                                        p._type = "p";
                                        list.push(p);
                                    });
                                });
                                cu.rowspan = cuSpan;
                                if (!cu.firstc) cu.firstc = { firstp: {} };
                            }
                            delete ret.data.pList;
                            ret.data.list = list;
                            for (var key in ret.data) {
                                mvvm.data[key] = ret.data[key];
                            }
                        })
                    }
                    vm.viewCuList = function () {
                        var data = {
                            addTime:"c",addTime1:mvvm.queryData.startTime,addTime2:mvvm.queryData.endTime
                        }
                        mvvm.gotourl("/Customer/All", false, data);
                    }
                });
                
                function initData() {
                    var now = new Date();
                    var startTime = new Date(now.getFullYear(), now.getMonth(), 1),
                    endTime = new Date(now.getFullYear(), now.getMonth() + 1, 0);
                    mvvm.queryData.startTime = GetDateTime(startTime, "yyyy-MM-dd");
                    mvvm.queryData.endTime = GetDateTime(endTime, "yyyy-MM-dd");;
                    mvvm.doSearch();
                }
                initData();
                
                CBCRM.fillContent(tmpl, lang, contentId, module, mvvm);
            },
            //分项报表桌面
            Breakdown: function (tmpl, lang, contentId, module) {
                var CBCRM = avalon.vmodels.CBCRM
                var mvvm = avalon.define('BreakdownController', function (vm) {
                    vm.table1 = []
                    vm.table2 = []
                    vm.table3 = []
                    vm.table4 = []
                    vm.table5 = []
                    vm.table6 = []
                    vm.table7 = []
                    vm.table8 = []
                    vm.menus = [];
                    vm.getMenus = function () {
                        var lv2Menu = CBCRM.gps[1];
                        if (!lv2Menu) return;
                        var menus = [];
                        CBCRM.getChildMenus(lv2Menu, 1, false).forEach(function (m) {
                            var menu = $.extend(true, {}, m);
                            menu.children = CBCRM.getMenus(m.id).children;
                            menus.push(menu);
                        });
                        mvvm.menus = menus;
                    }
                });
                //getreportlist();
                mvvm.getMenus();
                function getreportlist() {

                    $.get("/Report/Breakdown", {},
                    function (result) {

                        mvvm.table1 = result.data.tb1
                        mvvm.table2 = result.data.tb2
                        mvvm.table3 = result.data.tb3
                        mvvm.table4 = result.data.tb4
                        mvvm.table5 = result.data.tb5
                        mvvm.table6 = result.data.tb6
                        mvvm.table7 = result.data.tb7
                        mvvm.table8 = result.data.tb8

                    });
                };

                CBCRM.fillContent(tmpl, lang, contentId, module, mvvm);
                CBCRM.onLoadModuleBefore = function () {
                    avalon.vmodels.Index = null
                }

            },

            ///客户类别构成情况分析
            CustomerType: function (tmpl, lang, contentId, module) {
                var CBCRM = avalon.vmodels.CBCRM

                var mvvm = avalon.define('CustomerTypeController', function (vm) {
                    vm.dataList = [];
                    vm.entity = {};
                    vm.show = 0;
                    vm.total = 0;
                    vm.search = function () {
                        $.get('/Report/CustomerType', mvvm.entity.$model, function (result) {
                            mvvm.dataList = result.data.list;
                            mvvm.total = result.data.total;
                            createPieChart(result.data.list_chart, 'CustomerType', '600', '200')
                        })
                    }
                    vm.dateOpts = {
                        format: '%Y-%m-%d',
                        onSelect: function (date, formatDate, format) {
                            mvvm.EndDate = formatDate;
                        }
                    }
                    vm.allDeaprt = function () {
                        mvvm.show = 0;
                        mvvm.entity.$model.DepartIds = '';
                        mvvm.entity.$model.UserIds = '';
                        mvvm.entity.DepartIdName = '';
                        mvvm.entity.UserIdName = '';
                    }
                    vm.selectDeaprt = function () {
                        mvvm.entity.$model.UserIds = '';
                        mvvm.entity.UserIdName = '';
                        mvvm.show = 1;
                    }
                    vm.selectUser = function () {
                        mvvm.entity.$model.DepartIds = '';
                        mvvm.entity.DepartIdName = '';
                        mvvm.show = 2;
                    }
                    vm.clear = function () {

                        mvvm.entity = searchMode;
                    }

                    //选择部门
                    vm.postGroupTreeOpts = {
                        treeopts: {
                            check: {
                                enable: true,
                                chkboxType: { "Y": "s", "N": "s" },
                            },
                            async: {
                                enable: true,
                                url: '/Settings/GetGroupPostUser/104000000/'
                            },
                            callback: {
                                onCheck: function (event, treeId, treeNode) {

                                    tree = $.fn.zTree.getZTreeObj(treeId),

                                    names = [],
                                    ids = [],
                                    nodes = tree.getCheckedNodes(true)
                                    nodes.forEach(function (n, i) {
                                        names.push(n.Name)
                                        ids.push(n.Id)
                                    })
                                    mvvm.entity.$model.DepartIds = ids.join(',').toString();
                                    mvvm.entity.DepartIdName = names.join('，').toString()
                                }
                            }
                        }
                    }

                    vm.UserGroupTreeOpts = {
                        treeopts: {
                            check: {
                                enable: true,
                                chkboxType: { "Y": "s", "N": "s" },
                            },

                            callback: {
                                onCheck: function (event, treeId, treeNode) {

                                    tree = $.fn.zTree.getZTreeObj(treeId),

                                    names = [],
                                    ids = [],
                                    nodes = tree.getCheckedNodes(true)
                                    nodes.forEach(function (n, i) {
                                        names.push(n.Name)
                                        ids.push(n.Id)
                                    })
                                    mvvm.entity.$model.UserIds = ids.join(',').toString();
                                    mvvm.entity.UserIdName = names.join('，').toString()
                                }
                            },
                            async: {
                                url: function (treeId, treeNode) {
                                    return "/Settings/GetGroupPostUser/104000000/"
                                },
                                dataFilter: notMemberFilter
                            }

                        }
                    }
                });

                getDataList();

                function getDataList() {
                    $.get('/Report/CustomerType', searchMode, function (result) {
                        mvvm.dataList = result.data.list;
                        mvvm.total = result.data.total;
                        createPieChart(result.data.list_chart, 'CustomerType', '600', '200')
                    })
                }

                mvvm.entity = searchMode;
                CBCRM.fillContent(tmpl, lang, contentId, module, mvvm);
                CBCRM.onLoadModuleBefore = function () {
                    avalon.vmodels.Index = null
                    avalon.vmodels.setGroup.destroy()
                    avalon.vmodels.setUser.destroy()
                }
            },

            ///客户类型分析
            CustomerCategory: function (tmpl, lang, contentId, module) {
                var CBCRM = avalon.vmodels.CBCRM

                var mvvm = avalon.define('CustomerCategoryController', function (vm) {
                    vm.dataList = [];
                    vm.category = [];
                    vm.entity = {};
                    vm.show = 0;
                    vm.total = 0;
                    vm.search = function () {
                        $.get('/Report/CustomerCategory', mvvm.entity.$model, function (result) {
                            mvvm.dataList = result.data.list;
                            mvvm.total = result.data.total;
                            createPieChart(result.data.list_chart, 'chartId', '700', '300')
                        })
                    }
                    vm.dateOpts = {
                        format: '%Y-%m-%d',
                        onSelect: function (date, formatDate, format) {
                            mvvm.EndDate = formatDate;
                        }
                    }
                    vm.allDeaprt = function () {
                        mvvm.show = 0;
                        mvvm.entity.$model.DepartIds = '';
                        mvvm.entity.$model.UserIds = '';
                        mvvm.entity.DepartIdName = '';
                        mvvm.entity.UserIdName = '';
                    }
                    vm.selectDeaprt = function () {
                        mvvm.entity.$model.UserIds = '';
                        mvvm.entity.UserIdName = '';
                        mvvm.show = 1;
                    }
                    vm.selectUser = function () {
                        mvvm.entity.$model.DepartIds = '';
                        mvvm.entity.DepartIdName = '';
                        mvvm.show = 2;
                    }
                    vm.clear = function () {

                        mvvm.entity = searchMode;
                    }

                    //选择部门
                    vm.postGroupTreeOpts = {
                        treeopts: {
                            check: {
                                enable: true,
                                chkboxType: { "Y": "s", "N": "s" },
                            },
                            async: {
                                enable: true,
                                url: '/Settings/GetGroupPostUser/104000000/'
                            },
                            callback: {
                                onCheck: function (event, treeId, treeNode) {

                                    tree = $.fn.zTree.getZTreeObj(treeId),

                                    names = [],
                                    ids = [],
                                    nodes = tree.getCheckedNodes(true)
                                    nodes.forEach(function (n, i) {
                                        names.push(n.Name)
                                        ids.push(n.Id)
                                    })
                                    mvvm.entity.$model.DepartIds = ids.join(',').toString();
                                    mvvm.entity.DepartIdName = names.join('，').toString()
                                }
                            }
                        }
                    }

                    vm.UserGroupTreeOpts = {
                        treeopts: {
                            check: {
                                enable: true,
                                chkboxType: { "Y": "s", "N": "s" },
                            },

                            callback: {
                                onCheck: function (event, treeId, treeNode) {

                                    tree1 = $.fn.zTree.getZTreeObj(treeId),

                                    usernames = [],
                                    userids = [],
                                    nodes1 = tree1.getCheckedNodes(true)
                                    nodes1.forEach(function (n, i) {
                                        usernames.push(n.Name)
                                        userids.push(n.Id)
                                    })
                                    mvvm.entity.$model.UserIds = userids.join(',').toString();
                                    mvvm.entity.UserIdName = usernames.join('，').toString()
                                }
                            },
                            async: {
                                url: function (treeId, treeNode) {
                                    return "/Settings/GetGroupPostUser/104000000"
                                },
                                dataFilter: notMemberFilter
                            }

                        }
                    }
                });

                getDataList();

                function getDataList() {
                    $.get('/Report/CustomerCategory', searchMode, function (result) {
                        mvvm.dataList = result.data.list;
                        mvvm.total = result.data.total;
                        createPieChart(result.data.list_chart, 'chartId', '700', '300')
                    })
                    $.get('/Report/getdic', {}, function (result) {
                        result.data.unshift({ Id: 0, Data: '不限' });
                        mvvm.category = result.data;
                    })
                }

                mvvm.entity = searchMode;
                CBCRM.fillContent(tmpl, lang, contentId, module, mvvm);
                CBCRM.onLoadModuleBefore = function () {
                    avalon.vmodels.Index = null
                    avalon.vmodels.setGroup.destroy()
                    avalon.vmodels.setUser.destroy()
                }
            },

            ///客户阶段分析
            CustomerStage: function (tmpl, lang, contentId, module) {
                var CBCRM = avalon.vmodels.CBCRM

                var mvvm = avalon.define('CustomerStageController', function (vm) {
                    vm.dataList = [];
                    vm.entity = {};
                    vm.show = 0;
                    vm.total = 0;
                    vm.search = function () {
                        $.get('/Report/CustomerStage', mvvm.entity.$model, function (result) {
                            mvvm.dataList = result.data.list;
                            mvvm.total = result.data.total;
                            createPieChart(result.data.list_chart, 'chartId', '600', '300')
                        })
                    }
                    vm.dateOpts = {
                        format: '%Y-%m-%d',
                        onSelect: function (date, formatDate, format) {
                            mvvm.EndDate = formatDate;
                        }
                    }
                    vm.allDeaprt = function () {
                        mvvm.show = 0;
                        mvvm.entity.$model.DepartIds = '';
                        mvvm.entity.$model.UserIds = '';
                        mvvm.entity.DepartIdName = '';
                        mvvm.entity.UserIdName = '';
                    }
                    vm.selectDeaprt = function () {
                        mvvm.entity.$model.UserIds = '';
                        mvvm.entity.UserIdName = '';
                        mvvm.show = 1;
                    }
                    vm.selectUser = function () {
                        mvvm.entity.$model.DepartIds = '';
                        mvvm.entity.DepartIdName = '';
                        mvvm.show = 2;
                    }
                    vm.clear = function () {

                        mvvm.entity = searchMode;
                    }

                    //选择部门
                    vm.postGroupTreeOpts = {
                        treeopts: {
                            check: {
                                enable: true,
                                chkboxType: { "Y": "s", "N": "s" },
                            },
                            async: {
                                enable: true,
                                url: '/Settings/GetGroupPostUser/104000000/'
                            },
                            callback: {
                                onCheck: function (event, treeId, treeNode) {

                                    tree = $.fn.zTree.getZTreeObj(treeId),

                                    names = [],
                                    ids = [],
                                    nodes = tree.getCheckedNodes(true)
                                    nodes.forEach(function (n, i) {
                                        names.push(n.Name)
                                        ids.push(n.Id)
                                    })
                                    mvvm.entity.$model.DepartIds = ids.join(',').toString();
                                    mvvm.entity.DepartIdName = names.join('，').toString()
                                }
                            }
                        }
                    }

                    vm.UserGroupTreeOpts = {
                        treeopts: {
                            check: {
                                enable: true,
                                chkboxType: { "Y": "s", "N": "s" },
                            },

                            callback: {
                                onCheck: function (event, treeId, treeNode) {

                                    tree = $.fn.zTree.getZTreeObj(treeId),

                                    names = [],
                                    ids = [],
                                    nodes = tree.getCheckedNodes(true)
                                    nodes.forEach(function (n, i) {
                                        names.push(n.Name)
                                        ids.push(n.Id)
                                    })
                                    mvvm.entity.$model.UserIds = ids.join(',').toString();
                                    mvvm.entity.UserIdName = names.join('，').toString()
                                }
                            },
                            async: {
                                url: function (treeId, treeNode) {
                                    return "/Settings/GetGroupPostUser/104000000"
                                },
                                dataFilter: notMemberFilter
                            }

                        }
                    }
                });

                getDataList();

                function getDataList() {
                    $.get('/Report/CustomerStage', searchMode, function (result) {
                        mvvm.dataList = result.data.list;
                        mvvm.total = result.data.total;
                        createPieChart(result.data.list_chart, 'chartId', '600', '300')
                    })
                }

                mvvm.entity = searchMode;
                CBCRM.fillContent(tmpl, lang, contentId, module, mvvm);
                CBCRM.onLoadModuleBefore = function () {
                    avalon.vmodels.Index = null
                    avalon.vmodels.setGroup.destroy()
                    avalon.vmodels.setUser.destroy()
                }
            },

            ///客户来源分析
            CustomerSource: function (tmpl, lang, contentId, module) {
                var CBCRM = avalon.vmodels.CBCRM

                var mvvm = avalon.define('CustomerSourceController', function (vm) {
                    vm.dataList = [];
                    vm.entity = {};
                    vm.show = 0;
                    vm.total = 0;
                    vm.search = function () {
                        $.get('/Report/CustomerSource', mvvm.entity.$model, function (result) {
                            mvvm.dataList = result.data.list;
                            mvvm.total = result.data.total;
                            createColumnChart(result.data.list_chart, 'chartId', '900', '300')
                        })
                    }
                    vm.dateOpts = {
                        format: '%Y-%m-%d',
                        onSelect: function (date, formatDate, format) {
                            mvvm.EndDate = formatDate;
                        }
                    }
                    vm.allDeaprt = function () {
                        mvvm.show = 0;
                        mvvm.entity.$model.DepartIds = '';
                        mvvm.entity.$model.UserIds = '';
                        mvvm.entity.DepartIdName = '';
                        mvvm.entity.UserIdName = '';
                    }
                    vm.selectDeaprt = function () {
                        mvvm.entity.$model.UserIds = '';
                        mvvm.entity.UserIdName = '';
                        mvvm.show = 1;
                    }
                    vm.selectUser = function () {
                        mvvm.entity.$model.DepartIds = '';
                        mvvm.entity.DepartIdName = '';
                        mvvm.show = 2;
                    }
                    vm.clear = function () {

                        mvvm.entity = searchMode;
                    }

                    //选择部门
                    vm.postGroupTreeOpts = {
                        treeopts: {
                            check: {
                                enable: true,
                                chkboxType: { "Y": "s", "N": "s" },
                            },
                            async: {
                                enable: true,
                                url: '/Settings/GetGroupPostUser/104000000/'
                            },
                            callback: {
                                onCheck: function (event, treeId, treeNode) {

                                    tree = $.fn.zTree.getZTreeObj(treeId),

                                    names = [],
                                    ids = [],
                                    nodes = tree.getCheckedNodes(true)
                                    nodes.forEach(function (n, i) {
                                        names.push(n.Name)
                                        ids.push(n.Id)
                                    })
                                    mvvm.entity.$model.DepartIds = ids.join(',').toString();
                                    mvvm.entity.DepartIdName = names.join('，').toString()
                                }
                            }
                        }
                    }

                    vm.UserGroupTreeOpts = {
                        treeopts: {
                            check: {
                                enable: true,
                                chkboxType: { "Y": "s", "N": "s" },
                            },

                            callback: {
                                onCheck: function (event, treeId, treeNode) {

                                    tree = $.fn.zTree.getZTreeObj(treeId),

                                    names = [],
                                    ids = [],
                                    nodes = tree.getCheckedNodes(true)
                                    nodes.forEach(function (n, i) {
                                        names.push(n.Name)
                                        ids.push(n.Id)
                                    })
                                    mvvm.entity.$model.UserIds = ids.join(',').toString();
                                    mvvm.entity.UserIdName = names.join('，').toString()
                                }
                            },
                            async: {
                                url: function (treeId, treeNode) {
                                    return "/Settings/GetGroupPostUser/104000000"
                                },
                                dataFilter: notMemberFilter
                            }

                        }
                    }
                });

                getDataList();

                function getDataList() {
                    $.get('/Report/CustomerSource', searchMode, function (result) {
                        mvvm.dataList = result.data.list;
                        mvvm.total = result.data.total;
                        createColumnChart(result.data.list_chart, 'chartId', '900', '300')
                    })
                }

                mvvm.entity = searchMode;
                CBCRM.fillContent(tmpl, lang, contentId, module, mvvm);
                CBCRM.onLoadModuleBefore = function () {
                    avalon.vmodels.Index = null
                    avalon.vmodels.setGroup.destroy()
                    avalon.vmodels.setUser.destroy()
                }
            },

            ///客户注册资金分析
            RegisterCapitalCustomer: function (tmpl, lang, contentId, module) {
                var CBCRM = avalon.vmodels.CBCRM

                var mvvm = avalon.define('RegisterCapitalCustomer', function (vm) {
                    vm.dataList = [];
                    vm.entity = {};
                    vm.show = 0;
                    vm.total = 0;
                    vm.search = function () {
                        $.get('/Report/RegisterCapitalCustomer', mvvm.entity.$model, function (result) {
                            mvvm.dataList = result.data.list;
                            mvvm.total = result.data.total;
                            createColumnChart(result.data.list_chart, 'chartId', '900', '300')
                        })
                    }

                    vm.dateOpts = {
                        format: '%Y-%m-%d',
                        onSelect: function (date, formatDate, format) {
                            mvvm.EndDate = formatDate;
                        }
                    }
                    vm.allDeaprt = function () {
                        mvvm.show = 0;
                        mvvm.entity.$model.DepartIds = '';
                        mvvm.entity.$model.UserIds = '';
                        mvvm.entity.DepartIdName = '';
                        mvvm.entity.UserIdName = '';
                    }
                    vm.selectDeaprt = function () {
                        mvvm.entity.$model.UserIds = '';
                        mvvm.entity.UserIdName = '';
                        mvvm.show = 1;
                    }
                    vm.selectUser = function () {
                        mvvm.entity.$model.DepartIds = '';
                        mvvm.entity.DepartIdName = '';
                        mvvm.show = 2;
                    }
                    vm.clear = function () {

                        mvvm.entity = searchMode;
                    }

                    //选择部门
                    vm.postGroupTreeOpts = {
                        treeopts: {
                            check: {
                                enable: true,
                                chkboxType: { "Y": "s", "N": "s" },
                            },
                            async: {
                                enable: true,
                                url: '/Settings/GetGroupPostUser/104000000/'
                            },
                            callback: {
                                onCheck: function (event, treeId, treeNode) {

                                    tree = $.fn.zTree.getZTreeObj(treeId),

                                    names = [],
                                    ids = [],
                                    nodes = tree.getCheckedNodes(true)
                                    nodes.forEach(function (n, i) {
                                        names.push(n.Name)
                                        ids.push(n.Id)
                                    })
                                    mvvm.entity.$model.DepartIds = ids.join(',').toString();
                                    mvvm.entity.DepartIdName = names.join('，').toString()
                                }
                            }
                        }
                    }

                    vm.UserGroupTreeOpts = {
                        treeopts: {
                            check: {
                                enable: true,
                                chkboxType: { "Y": "s", "N": "s" },
                            },

                            callback: {
                                onCheck: function (event, treeId, treeNode) {

                                    tree = $.fn.zTree.getZTreeObj(treeId),

                                    names = [],
                                    ids = [],
                                    nodes = tree.getCheckedNodes(true)
                                    nodes.forEach(function (n, i) {
                                        names.push(n.Name)
                                        ids.push(n.Id)
                                    })
                                    mvvm.entity.$model.UserIds = ids.join(',').toString();
                                    mvvm.entity.UserIdName = names.join('，').toString()
                                }
                            },
                            async: {
                                url: function (treeId, treeNode) {
                                    return "/Settings/GetGroupPostUser/104000000"
                                },
                                dataFilter: notMemberFilter
                            }

                        }
                    }
                });

                getDataList();

                function getDataList() {
                    $.get('/Report/RegisterCapitalCustomer', searchMode, function (result) {
                        mvvm.dataList = result.data.list;
                        mvvm.total = result.data.total;
                        createColumnChart(result.data.list_chart, 'chartId', '900', '300')
                    })
                }

                mvvm.entity = searchMode;
                CBCRM.fillContent(tmpl, lang, contentId, module, mvvm);
                CBCRM.onLoadModuleBefore = function () {
                    avalon.vmodels.Index = null
                    avalon.vmodels.setGroup.destroy()
                    avalon.vmodels.setUser.destroy()
                }
            },

            ///客户企业人员规模分析
            PersonnelScaleCustomer: function (tmpl, lang, contentId, module) {
                var CBCRM = avalon.vmodels.CBCRM

                var mvvm = avalon.define('PersonnelScaleCustomer', function (vm) {
                    vm.dataList = [];
                    vm.entity = {};
                    vm.show = 0;
                    vm.total = 0;
                    vm.search = function () {
                        $.get('/Report/PersonnelScaleCustomer', mvvm.entity.$model, function (result) {
                            mvvm.dataList = result.data.list;
                            mvvm.total = result.data.total;
                            createColumnChart(result.data.list_chart, 'chartId', '900', '300')
                        })
                    }

                    vm.dateOpts = {
                        format: '%Y-%m-%d',
                        onSelect: function (date, formatDate, format) {
                            mvvm.EndDate = formatDate;
                        }
                    }
                    vm.allDeaprt = function () {
                        mvvm.show = 0;
                        mvvm.entity.$model.DepartIds = '';
                        mvvm.entity.$model.UserIds = '';
                        mvvm.entity.DepartIdName = '';
                        mvvm.entity.UserIdName = '';
                    }
                    vm.selectDeaprt = function () {
                        mvvm.entity.$model.UserIds = '';
                        mvvm.entity.UserIdName = '';
                        mvvm.show = 1;
                    }
                    vm.selectUser = function () {
                        mvvm.entity.$model.DepartIds = '';
                        mvvm.entity.DepartIdName = '';
                        mvvm.show = 2;
                    }
                    vm.clear = function () {

                        mvvm.entity = searchMode;
                    }

                    //选择部门
                    vm.postGroupTreeOpts = {
                        treeopts: {
                            check: {
                                enable: true,
                                chkboxType: { "Y": "s", "N": "s" },
                            },
                            async: {
                                enable: true,
                                url: '/Settings/GetGroupPostUser/104000000/'
                            },
                            callback: {
                                onCheck: function (event, treeId, treeNode) {

                                    tree = $.fn.zTree.getZTreeObj(treeId),

                                    names = [],
                                    ids = [],
                                    nodes = tree.getCheckedNodes(true)
                                    nodes.forEach(function (n, i) {
                                        names.push(n.Name)
                                        ids.push(n.Id)
                                    })
                                    mvvm.entity.$model.DepartIds = ids.join(',').toString();
                                    mvvm.entity.DepartIdName = names.join('，').toString()
                                }
                            }
                        }
                    }

                    vm.UserGroupTreeOpts = {
                        treeopts: {
                            check: {
                                enable: true,
                                chkboxType: { "Y": "s", "N": "s" },
                            },

                            callback: {
                                onCheck: function (event, treeId, treeNode) {

                                    tree = $.fn.zTree.getZTreeObj(treeId),

                                    names = [],
                                    ids = [],
                                    nodes = tree.getCheckedNodes(true)
                                    nodes.forEach(function (n, i) {
                                        names.push(n.Name)
                                        ids.push(n.Id)
                                    })
                                    mvvm.entity.$model.UserIds = ids.join(',').toString();
                                    mvvm.entity.UserIdName = names.join('，').toString()
                                }
                            },
                            async: {
                                url: function (treeId, treeNode) {
                                    return "/Settings/GetGroupPostUser/104000000"
                                },
                                dataFilter: notMemberFilter
                            }

                        }
                    }
                });

                getDataList();

                function getDataList() {
                    $.get('/Report/PersonnelScaleCustomer', searchMode, function (result) {
                        mvvm.dataList = result.data.list;
                        mvvm.total = result.data.total;
                        createColumnChart(result.data.list_chart, 'chartId', '900', '300')
                    })
                }

                mvvm.entity = searchMode;
                CBCRM.fillContent(tmpl, lang, contentId, module, mvvm);
                CBCRM.onLoadModuleBefore = function () {
                    avalon.vmodels.Index = null
                    avalon.vmodels.setGroup.destroy()
                    avalon.vmodels.setUser.destroy()
                }
            },

            ///客户主营行业分析
            CustomerIndustry: function (tmpl, lang, contentId, module) {
                var CBCRM = avalon.vmodels.CBCRM

                var mvvm = avalon.define('CustomerIndustry', function (vm) {
                    vm.dataList = [];
                    vm.entity = {};
                    vm.show = 0;
                    vm.total = 0;
                    vm.search = function () {
                        $.get('/Report/CustomerIndustry', mvvm.entity.$model, function (result) {
                            mvvm.dataList = result.data.list;
                            mvvm.total = result.data.total;
                            createColumnChart(result.data.list_chart, 'chartId', '900', '300')
                        })
                    }

                    vm.dateOpts = {
                        format: '%Y-%m-%d',
                        onSelect: function (date, formatDate, format) {
                            mvvm.EndDate = formatDate;
                        }
                    }
                    vm.allDeaprt = function () {
                        mvvm.show = 0;
                        mvvm.entity.$model.DepartIds = '';
                        mvvm.entity.$model.UserIds = '';
                        mvvm.entity.DepartIdName = '';
                        mvvm.entity.UserIdName = '';
                    }
                    vm.selectDeaprt = function () {
                        mvvm.entity.$model.UserIds = '';
                        mvvm.entity.UserIdName = '';
                        mvvm.show = 1;
                    }
                    vm.selectUser = function () {
                        mvvm.entity.$model.DepartIds = '';
                        mvvm.entity.DepartIdName = '';
                        mvvm.show = 2;
                    }
                    vm.clear = function () {

                        mvvm.entity = searchMode;
                    }

                    //选择部门
                    vm.postGroupTreeOpts = {
                        treeopts: {
                            check: {
                                enable: true,
                                chkboxType: { "Y": "s", "N": "s" },
                            },
                            async: {
                                enable: true,
                                url: '/Settings/GetGroupPostUser/104000000/'
                            },
                            callback: {
                                onCheck: function (event, treeId, treeNode) {

                                    tree = $.fn.zTree.getZTreeObj(treeId),

                                    names = [],
                                    ids = [],
                                    nodes = tree.getCheckedNodes(true)
                                    nodes.forEach(function (n, i) {
                                        names.push(n.Name)
                                        ids.push(n.Id)
                                    })
                                    mvvm.entity.$model.DepartIds = ids.join(',').toString();
                                    mvvm.entity.DepartIdName = names.join('，').toString()
                                }
                            }
                        }
                    }

                    vm.UserGroupTreeOpts = {
                        treeopts: {
                            check: {
                                enable: true,
                                chkboxType: { "Y": "s", "N": "s" },
                            },

                            callback: {
                                onCheck: function (event, treeId, treeNode) {

                                    tree = $.fn.zTree.getZTreeObj(treeId),

                                    names = [],
                                    ids = [],
                                    nodes = tree.getCheckedNodes(true)
                                    nodes.forEach(function (n, i) {
                                        names.push(n.Name)
                                        ids.push(n.Id)
                                    })
                                    mvvm.entity.$model.UserIds = ids.join(',').toString();
                                    mvvm.entity.UserIdName = names.join('，').toString()
                                }
                            },
                            async: {
                                url: function (treeId, treeNode) {
                                    return "/Settings/GetGroupPostUser/104000000"
                                },
                                dataFilter: notMemberFilter
                            }

                        }
                    }
                });

                getDataList();

                function getDataList() {
                    $.get('/Report/CustomerIndustry', searchMode, function (result) {
                        mvvm.dataList = result.data.list;
                        mvvm.total = result.data.total;
                        createColumnChart(result.data.list_chart, 'chartId', '900', '300')
                    })
                }

                mvvm.entity = searchMode;
                CBCRM.fillContent(tmpl, lang, contentId, module, mvvm);
                CBCRM.onLoadModuleBefore = function () {
                    avalon.vmodels.Index = null
                    avalon.vmodels.setGroup.destroy()
                    avalon.vmodels.setUser.destroy()
                }
            },

            ///客户区域分析
            CustomerArea: function (tmpl, lang, contentId, module) {
                var CBCRM = avalon.vmodels.CBCRM

                var mvvm = avalon.define('CustomerArea', function (vm) {
                    vm.dataList = [];
                    vm.entity = {};
                    vm.show = 0;
                    vm.total = 0;
                    vm.country = [];
                    vm.province = [];
                    vm.city = [];
                    vm.search = function () {
                        $.get('/Report/CustomerArea', mvvm.entity.$model, function (result) {
                            mvvm.dataList = result.data.list;
                            mvvm.total = result.data.total;
                            createColumnChart(result.data.list_chart, 'chartId', '900', '300')
                        })
                    }

                    vm.dateOpts = {
                        format: '%Y-%m-%d',
                        onSelect: function (date, formatDate, format) {
                            mvvm.EndDate = formatDate;
                        }
                    }
                    vm.allDeaprt = function () {
                        mvvm.show = 0;
                        mvvm.entity.$model.DepartIds = '';
                        mvvm.entity.$model.UserIds = '';
                        mvvm.entity.DepartIdName = '';
                        mvvm.entity.UserIdName = '';
                    }
                    vm.selectDeaprt = function () {
                        mvvm.entity.$model.UserIds = '';
                        mvvm.entity.UserIdName = '';
                        mvvm.show = 1;
                    }
                    vm.selectUser = function () {
                        mvvm.entity.$model.DepartIds = '';
                        mvvm.entity.DepartIdName = '';
                        mvvm.show = 2;
                    }
                    vm.clear = function () {

                        mvvm.entity = searchMode;
                    }

                    //选择部门
                    vm.postGroupTreeOpts = {
                        treeopts: {
                            check: {
                                enable: true,
                                chkboxType: { "Y": "s", "N": "s" },
                            },
                            async: {
                                enable: true,
                                url: '/Settings/GetGroupPostUser/104000000/'
                            },
                            callback: {
                                onCheck: function (event, treeId, treeNode) {

                                    tree = $.fn.zTree.getZTreeObj(treeId),

                                    names = [],
                                    ids = [],
                                    nodes = tree.getCheckedNodes(true)
                                    nodes.forEach(function (n, i) {
                                        names.push(n.Name)
                                        ids.push(n.Id)
                                    })
                                    mvvm.entity.$model.DepartIds = ids.join(',').toString();
                                    mvvm.entity.DepartIdName = names.join('，').toString()
                                }
                            }
                        }
                    }

                    vm.UserGroupTreeOpts = {
                        treeopts: {
                            check: {
                                enable: true,
                                chkboxType: { "Y": "s", "N": "s" },
                            },

                            callback: {
                                onCheck: function (event, treeId, treeNode) {

                                    tree = $.fn.zTree.getZTreeObj(treeId),

                                    names = [],
                                    ids = [],
                                    nodes = tree.getCheckedNodes(true)
                                    nodes.forEach(function (n, i) {
                                        names.push(n.Name)
                                        ids.push(n.Id)
                                    })
                                    mvvm.entity.$model.UserIds = ids.join(',').toString();
                                    mvvm.entity.UserIdName = names.join('，').toString()
                                }
                            },
                            async: {
                                url: function (treeId, treeNode) {
                                    return "/Settings/GetGroupPostUser/104000000"
                                },
                                dataFilter: notMemberFilter
                            }

                        }
                    }

                });

                getDataList();
                allLocations = [];
                mvvm.country.unshift({ Id: -1, Data: '不限' });


                function getDataList() {


                    $.get('/Report/CustomerArea', searchMode, function (result) {
                        mvvm.dataList = result.data.list;
                        mvvm.total = result.data.total;
                        createColumnChart(result.data.list_chart, 'chartId', '900', '300')
                    })
                    $.get('/Report/GetArea', {}, function (result) {
                        allLocations = result.data;

                        allLocations.forEach(function (l) {
                            if (l.ParentId === 0) {
                                mvvm.country.push(l)
                                mvvm.entity.CompanyCountryId = -1;
                                //mvvm.entity.CompanyCountryId = l.Id
                            }
                        })
                        bindWatch(mvvm.entity)
                    })
                }

                function bindWatch(entity) {
                    /*国家地区级联*/
                    entity.$watch('CompanyCountryId', function (n, o) {
                        var name = ''
                        if (n != o) {
                            mvvm.province.removeAll()
                            mvvm.province.unshift({ Id: -2, Data: '不限' });
                            allLocations.forEach(function (c) {
                                if (c.ParentId == n) {
                                    name = c.Data
                                    mvvm.province.push(c)

                                }
                            })
                            avalon.log('CompanyCountryId : ' + mvvm.entity.CompanyCountryId)
                            if (mvvm.province.size()) {
                                mvvm.entity.CompanyProvinceId = mvvm.province[0].Id

                            } else {
                                mvvm.entity.CompanyProvinceId = ''

                            }
                        }
                    })
                    entity.$watch('CompanyProvinceId', function (n, o) {
                        if (n != o) {
                            mvvm.city.removeAll()
                            mvvm.city.unshift({ Id: -3, Data: '不限' });
                            allLocations.forEach(function (c) {
                                if (c.ParentId == n) {
                                    name = c.Data
                                    mvvm.city.push(c)
                                }
                            })
                            avalon.log('CompanyProvinceId : ' + mvvm.entity.CompanyProvinceId)
                            if (mvvm.city.size()) {
                                mvvm.entity.CompanyCityId = mvvm.city[0].Id

                            } else {
                                mvvm.entity.CompanyCityId = ''
                            }
                        }
                    })
                }
                mvvm.entity = searchMode;
                CBCRM.fillContent(tmpl, lang, contentId, module, mvvm);
                CBCRM.onLoadModuleBefore = function () {
                    avalon.vmodels.Index = null
                    avalon.vmodels.setGroup.destroy()
                    avalon.vmodels.setUser.destroy()
                }
            },

            //客户联系方式填写情况分析
            ContactStatusCustomer: function (tmpl, lang, contentId, module) {
                var CBCRM = avalon.vmodels.CBCRM

                var mvvm = avalon.define('ContactStatusCustomer', function (vm) {
                    vm.dataList = [];
                    vm.entity = {};
                    vm.show = 0;
                    vm.total = 0;
                    vm.search = function () {
                        $.get('/Report/ContactStatusCustomer', mvvm.entity.$model, function (result) {
                            mvvm.dataList = result.data.list;
                            mvvm.total = result.data.total;
                        })
                    }

                    vm.dateOpts = {
                        format: '%Y-%m-%d',
                        onSelect: function (date, formatDate, format) {
                            mvvm.EndDate = formatDate;
                        }
                    }
                    vm.allDeaprt = function () {
                        mvvm.show = 0;
                        mvvm.entity.$model.DepartIds = '';
                        mvvm.entity.$model.UserIds = '';
                        mvvm.entity.DepartIdName = '';
                        mvvm.entity.UserIdName = '';
                    }
                    vm.selectDeaprt = function () {
                        mvvm.entity.$model.UserIds = '';
                        mvvm.entity.UserIdName = '';
                        mvvm.show = 1;
                    }
                    vm.selectUser = function () {
                        mvvm.entity.$model.DepartIds = '';
                        mvvm.entity.DepartIdName = '';
                        mvvm.show = 2;
                    }
                    vm.clear = function () {

                        mvvm.entity = searchMode;
                    }

                    //选择部门
                    vm.postGroupTreeOpts = {
                        treeopts: {
                            check: {
                                enable: true,
                                chkboxType: { "Y": "s", "N": "s" },
                            },
                            async: {
                                enable: true,
                                url: '/Settings/GetGroupPostUser/104000000/'
                            },
                            callback: {
                                onCheck: function (event, treeId, treeNode) {

                                    tree = $.fn.zTree.getZTreeObj(treeId),

                                    names = [],
                                    ids = [],
                                    nodes = tree.getCheckedNodes(true)
                                    nodes.forEach(function (n, i) {
                                        names.push(n.Name)
                                        ids.push(n.Id)
                                    })
                                    mvvm.entity.$model.DepartIds = ids.join(',').toString();
                                    mvvm.entity.DepartIdName = names.join('，').toString()
                                }
                            }
                        }
                    }

                    vm.UserGroupTreeOpts = {
                        treeopts: {
                            check: {
                                enable: true,
                                chkboxType: { "Y": "s", "N": "s" },
                            },

                            callback: {
                                onCheck: function (event, treeId, treeNode) {

                                    tree = $.fn.zTree.getZTreeObj(treeId),

                                    names = [],
                                    ids = [],
                                    nodes = tree.getCheckedNodes(true)
                                    nodes.forEach(function (n, i) {
                                        names.push(n.Name)
                                        ids.push(n.Id)
                                    })
                                    mvvm.entity.$model.UserIds = ids.join(',').toString();
                                    mvvm.entity.UserIdName = names.join('，').toString()
                                }
                            },
                            async: {
                                url: function (treeId, treeNode) {
                                    return "/Settings/GetGroupPostUser/104000000"
                                },
                                dataFilter: notMemberFilter
                            }

                        }
                    }
                });

                getDataList();

                function getDataList() {
                    $.get('/Report/ContactStatusCustomer', searchMode, function (result) {
                        mvvm.dataList = result.data.list;
                        mvvm.total = result.data.total;
                    })
                }

                mvvm.entity = searchMode;
                CBCRM.fillContent(tmpl, lang, contentId, module, mvvm);
                CBCRM.onLoadModuleBefore = function () {
                    avalon.vmodels.Index = null
                    avalon.vmodels.setGroup.destroy()
                    avalon.vmodels.setUser.destroy()
                }
            },

            //客户联系人分析
            ContactPersonCustomer: function (tmpl, lang, contentId, module) {
                var CBCRM = avalon.vmodels.CBCRM

                var mvvm = avalon.define('ContactPersonCustomer', function (vm) {

                    vm.entity = {};
                    vm.show = 0;

                    vm.search = function () {
                        $.get('/Report/ContactPersonCustomer', mvvm.entity.$model, function (result) {
                            createPieChart(result.data.list_chart, 'chartId', '700', '300')
                            createPieChart(result.data.list_sex, 'char_sex', '500', '300')
                        })
                    }

                    vm.dateOpts = {
                        format: '%Y-%m-%d',
                        onSelect: function (date, formatDate, format) {
                            mvvm.EndDate = formatDate;
                        }
                    }
                    vm.allDeaprt = function () {
                        mvvm.show = 0;
                        mvvm.entity.$model.DepartIds = '';
                        mvvm.entity.$model.UserIds = '';
                        mvvm.entity.DepartIdName = '';
                        mvvm.entity.UserIdName = '';
                    }
                    vm.selectDeaprt = function () {
                        mvvm.entity.$model.UserIds = '';
                        mvvm.entity.UserIdName = '';
                        mvvm.show = 1;
                    }
                    vm.selectUser = function () {
                        mvvm.entity.$model.DepartIds = '';
                        mvvm.entity.DepartIdName = '';
                        mvvm.show = 2;
                    }
                    vm.clear = function () {

                        mvvm.entity = searchMode;
                    }

                    //选择部门
                    vm.postGroupTreeOpts = {
                        treeopts: {
                            check: {
                                enable: true,
                                chkboxType: { "Y": "s", "N": "s" },
                            },
                            async: {
                                enable: true,
                                url: '/Settings/GetGroupPostUser/104000000/'
                            },
                            callback: {
                                onCheck: function (event, treeId, treeNode) {

                                    tree = $.fn.zTree.getZTreeObj(treeId),

                                    names = [],
                                    ids = [],
                                    nodes = tree.getCheckedNodes(true)
                                    nodes.forEach(function (n, i) {
                                        names.push(n.Name)
                                        ids.push(n.Id)
                                    })
                                    mvvm.entity.$model.DepartIds = ids.join(',').toString();
                                    mvvm.entity.DepartIdName = names.join('，').toString()
                                }
                            }
                        }
                    }

                    vm.UserGroupTreeOpts = {
                        treeopts: {
                            check: {
                                enable: true,
                                chkboxType: { "Y": "s", "N": "s" },
                            },

                            callback: {
                                onCheck: function (event, treeId, treeNode) {

                                    tree = $.fn.zTree.getZTreeObj(treeId),

                                    names = [],
                                    ids = [],
                                    nodes = tree.getCheckedNodes(true)
                                    nodes.forEach(function (n, i) {
                                        names.push(n.Name)
                                        ids.push(n.Id)
                                    })
                                    mvvm.entity.$model.UserIds = ids.join(',').toString();
                                    mvvm.entity.UserIdName = names.join('，').toString()
                                }
                            },
                            async: {
                                url: function (treeId, treeNode) {
                                    return "/Settings/GetGroupPostUser/104000000"
                                },
                                dataFilter: notMemberFilter
                            }

                        }
                    }
                });

                getDataList();

                function getDataList() {
                    $.get('/Report/ContactPersonCustomer', searchMode, function (result) {
                        createPieChart(result.data.list_chart, 'chartId', '700', '300')
                        createPieChart(result.data.list_sex, 'char_sex', '500', '300')
                    })
                }

                mvvm.entity = searchMode;
                CBCRM.fillContent(tmpl, lang, contentId, module, mvvm);
                CBCRM.onLoadModuleBefore = function () {
                    avalon.vmodels.Index = null
                    avalon.vmodels.setGroup.destroy()
                    avalon.vmodels.setUser.destroy()
                }
            },

            //客户归属分析
            CustomerOwnerType: function (tmpl, lang, contentId, module) {
                var CBCRM = avalon.vmodels.CBCRM

                var mvvm = avalon.define('CustomerOwnerType', function (vm) {
                    vm.dataList = [];
                    vm.entity = {};
                    vm.show = 0;
                    vm.total = 0;
                    vm.search = function () {
                        $.get('/Report/CustomerOwnerType', mvvm.entity.$model, function (result) {
                            mvvm.dataList = result.data.list;
                            mvvm.total = result.data.total;
                            createPieChart(result.data.list_chart, 'chartId', '700', '300')
                        })
                    }
                    vm.dateOpts = {
                        format: '%Y-%m-%d',
                        onSelect: function (date, formatDate, format) {
                            mvvm.EndDate = formatDate;
                        }
                    }
                    vm.allDeaprt = function () {
                        mvvm.show = 0;
                        mvvm.entity.$model.DepartIds = '';
                        mvvm.entity.$model.UserIds = '';
                        mvvm.entity.DepartIdName = '';
                        mvvm.entity.UserIdName = '';
                    }
                    vm.selectDeaprt = function () {
                        mvvm.entity.$model.UserIds = '';
                        mvvm.entity.UserIdName = '';
                        mvvm.show = 1;
                    }
                    vm.selectUser = function () {
                        mvvm.entity.$model.DepartIds = '';
                        mvvm.entity.DepartIdName = '';
                        mvvm.show = 2;
                    }
                    vm.clear = function () {

                        mvvm.entity = searchMode;
                    }

                    //选择部门
                    vm.postGroupTreeOpts = {
                        treeopts: {
                            check: {
                                enable: true,
                                chkboxType: { "Y": "s", "N": "s" },
                            },
                            async: {
                                enable: true,
                                url: '/Settings/GetGroupPostUser/104000000/'
                            },
                            callback: {
                                onCheck: function (event, treeId, treeNode) {

                                    tree = $.fn.zTree.getZTreeObj(treeId),

                                    names = [],
                                    ids = [],
                                    nodes = tree.getCheckedNodes(true)
                                    nodes.forEach(function (n, i) {
                                        names.push(n.Name)
                                        ids.push(n.Id)
                                    })
                                    mvvm.entity.$model.DepartIds = ids.join(',').toString();
                                    mvvm.entity.DepartIdName = names.join('，').toString()
                                }
                            }
                        }
                    }

                    vm.UserGroupTreeOpts = {
                        treeopts: {
                            check: {
                                enable: true,
                                chkboxType: { "Y": "s", "N": "s" },
                            },

                            callback: {
                                onCheck: function (event, treeId, treeNode) {

                                    tree = $.fn.zTree.getZTreeObj(treeId),

                                    names = [],
                                    ids = [],
                                    nodes = tree.getCheckedNodes(true)
                                    nodes.forEach(function (n, i) {
                                        names.push(n.Name)
                                        ids.push(n.Id)
                                    })
                                    mvvm.entity.$model.UserIds = ids.join(',').toString();
                                    mvvm.entity.UserIdName = names.join('，').toString()
                                }
                            },
                            async: {
                                url: function (treeId, treeNode) {
                                    return "/Settings/GetGroupPostUser/104000000"
                                },
                                dataFilter: notMemberFilter
                            }

                        }
                    }
                });

                getDataList();

                function getDataList() {
                    $.get('/Report/CustomerOwnerType', searchMode, function (result) {
                        mvvm.dataList = result.data.list;
                        mvvm.total = result.data.total;
                        createPieChart(result.data.list_chart, 'chartId', '700', '300')
                    })
                }

                mvvm.entity = searchMode;
                CBCRM.fillContent(tmpl, lang, contentId, module, mvvm);
                CBCRM.onLoadModuleBefore = function () {
                    avalon.vmodels.Index = null
                    avalon.vmodels.setGroup.destroy()
                    avalon.vmodels.setUser.destroy()
                }
            },

            //客户开发模式分析
            CustomerMode: function (tmpl, lang, contentId, module) {
                var CBCRM = avalon.vmodels.CBCRM

                var mvvm = avalon.define('CustomerMode', function (vm) {
                    vm.dataList = [];
                    vm.entity = {};
                    vm.show = 0;
                    vm.total = 0;
                    vm.search = function () {
                        $.get('/Report/CustomerMode', mvvm.entity.$model, function (result) {
                            mvvm.dataList = result.data.list;
                            mvvm.total = result.data.total;
                            createPieChart(result.data.list_chart, 'chartId', '700', '300')
                        })
                    }
                    vm.dateOpts = {
                        format: '%Y-%m-%d',
                        onSelect: function (date, formatDate, format) {
                            mvvm.EndDate = formatDate;
                        }
                    }
                    vm.allDeaprt = function () {
                        mvvm.show = 0;
                        mvvm.entity.$model.DepartIds = '';
                        mvvm.entity.$model.UserIds = '';
                        mvvm.entity.DepartIdName = '';
                        mvvm.entity.UserIdName = '';
                    }
                    vm.selectDeaprt = function () {
                        mvvm.entity.$model.UserIds = '';
                        mvvm.entity.UserIdName = '';
                        mvvm.show = 1;
                    }
                    vm.selectUser = function () {
                        mvvm.entity.$model.DepartIds = '';
                        mvvm.entity.DepartIdName = '';
                        mvvm.show = 2;
                    }
                    vm.clear = function () {

                        mvvm.entity = searchMode;
                    }

                    //选择部门
                    vm.postGroupTreeOpts = {
                        treeopts: {
                            check: {
                                enable: true,
                                chkboxType: { "Y": "s", "N": "s" },
                            },
                            async: {
                                enable: true,
                                url: '/Settings/GetGroupPostUser/104000000/'
                            },
                            callback: {
                                onCheck: function (event, treeId, treeNode) {

                                    tree = $.fn.zTree.getZTreeObj(treeId),

                                    names = [],
                                    ids = [],
                                    nodes = tree.getCheckedNodes(true)
                                    nodes.forEach(function (n, i) {
                                        names.push(n.Name)
                                        ids.push(n.Id)
                                    })
                                    mvvm.entity.$model.DepartIds = ids.join(',').toString();
                                    mvvm.entity.DepartIdName = names.join('，').toString()
                                }
                            }
                        }
                    }

                    vm.UserGroupTreeOpts = {
                        treeopts: {
                            check: {
                                enable: true,
                                chkboxType: { "Y": "s", "N": "s" },
                            },

                            callback: {
                                onCheck: function (event, treeId, treeNode) {

                                    tree = $.fn.zTree.getZTreeObj(treeId),

                                    names = [],
                                    ids = [],
                                    nodes = tree.getCheckedNodes(true)
                                    nodes.forEach(function (n, i) {
                                        names.push(n.Name)
                                        ids.push(n.Id)
                                    })
                                    mvvm.entity.$model.UserIds = ids.join(',').toString();
                                    mvvm.entity.UserIdName = names.join('，').toString()
                                }
                            },
                            async: {
                                url: function (treeId, treeNode) {
                                    return "/Settings/GetGroupPostUser/104000000"
                                },
                                dataFilter: notMemberFilter
                            }

                        }
                    }
                });

                getDataList();

                function getDataList() {
                    $.get('/Report/CustomerMode', searchMode, function (result) {
                        mvvm.dataList = result.data.list;
                        mvvm.total = result.data.total;
                        createPieChart(result.data.list_chart, 'chartId', '700', '300')
                    })
                }

                mvvm.entity = searchMode;
                CBCRM.fillContent(tmpl, lang, contentId, module, mvvm);
                CBCRM.onLoadModuleBefore = function () {
                    avalon.vmodels.Index = null
                    avalon.vmodels.setGroup.destroy()
                    avalon.vmodels.setUser.destroy()
                }
            },

            //老客户推荐新客户情况分析
            CustomerIntroduce: function (tmpl, lang, contentId, module) {
                var CBCRM = avalon.vmodels.CBCRM

                var mvvm = avalon.define('CustomerIntroduce', function (vm) {
                    vm.dataList = [];
                    vm.entity = {};
                    vm.show = 0;
                    vm.total = 0;
                    vm.search = function () {
                        $.get('/Report/CustomerIntroduce', mvvm.entity.$model, function (result) {
                            mvvm.dataList = result.data;
                        })
                    }
                    vm.dateOpts = {
                        format: '%Y-%m-%d',
                        onSelect: function (date, formatDate, format) {
                            mvvm.EndDate = formatDate;
                        }
                    }
                    vm.allDeaprt = function () {
                        mvvm.show = 0;
                        mvvm.entity.$model.DepartIds = '';
                        mvvm.entity.$model.UserIds = '';
                        mvvm.entity.DepartIdName = '';
                        mvvm.entity.UserIdName = '';
                    }
                    vm.selectDeaprt = function () {
                        mvvm.entity.$model.UserIds = '';
                        mvvm.entity.UserIdName = '';
                        mvvm.show = 1;
                    }
                    vm.selectUser = function () {
                        mvvm.entity.$model.DepartIds = '';
                        mvvm.entity.DepartIdName = '';
                        mvvm.show = 2;
                    }
                    vm.clear = function () {
                        mvvm.entity = searchMode;
                    }

                    //选择部门
                    vm.postGroupTreeOpts = {
                        treeopts: {
                            check: {
                                enable: true,
                                chkboxType: { "Y": "s", "N": "s" },
                            },
                            async: {
                                enable: true,
                                url: '/Settings/GetGroupPostUser/104000000/'
                            },
                            callback: {
                                onCheck: function (event, treeId, treeNode) {

                                    tree = $.fn.zTree.getZTreeObj(treeId),

                                    names = [],
                                    ids = [],
                                    nodes = tree.getCheckedNodes(true)
                                    nodes.forEach(function (n, i) {
                                        names.push(n.Name)
                                        ids.push(n.Id)
                                    })
                                    mvvm.entity.$model.DepartIds = ids.join(',').toString();
                                    mvvm.entity.DepartIdName = names.join('，').toString()
                                }
                            }
                        }
                    }

                    vm.UserGroupTreeOpts = {
                        treeopts: {
                            check: {
                                enable: true,
                                chkboxType: { "Y": "s", "N": "s" },
                            },

                            callback: {
                                onCheck: function (event, treeId, treeNode) {

                                    tree = $.fn.zTree.getZTreeObj(treeId),

                                    names = [],
                                    ids = [],
                                    nodes = tree.getCheckedNodes(true)
                                    nodes.forEach(function (n, i) {
                                        names.push(n.Name)
                                        ids.push(n.Id)
                                    })
                                    mvvm.entity.$model.UserIds = ids.join(',').toString();
                                    mvvm.entity.UserIdName = names.join('，').toString()
                                }
                            },
                            async: {
                                url: function (treeId, treeNode) {
                                    return "/Settings/GetGroupPostUser/104000000"
                                },
                                dataFilter: notMemberFilter
                            }

                        }
                    }
                });

                getDataList();

                function getDataList() {
                    $.get('/Report/CustomerIntroduce', searchMode, function (result) {
                        mvvm.dataList = result.data;
                    })
                }

                mvvm.entity = searchMode;
                CBCRM.fillContent(tmpl, lang, contentId, module, mvvm);
                CBCRM.onLoadModuleBefore = function () {
                    avalon.vmodels.Index = null
                    avalon.vmodels.setGroup.destroy()
                    avalon.vmodels.setUser.destroy()
                }
            },

            //销售机会来源分析
            OpportunitySource: function (tmpl, lang, contentId, module) {
                var CBCRM = avalon.vmodels.CBCRM

                var mvvm = avalon.define('OpportunitySource', function (vm) {
                    vm.dataList = [];
                    vm.entity = {};
                    vm.show = 0;
                    vm.total = 0;
                    vm.followStages = [];
                    vm.opporStatus = [];
                    vm.serviceTags = [];
                    vm.search = function () {
                        $.get('/Report/OpportunitySource', mvvm.entity.$model, function (result) {
                            mvvm.dataList = result.data.list;
                            mvvm.total = result.data.total;
                            createColumnChart(result.data.list_chart, 'chartId', '1000', '300')
                        })
                    }
                    vm.dateOpts = {
                        format: '%Y-%m-%d',
                        onSelect: function (date, formatDate, format) {
                            mvvm.EndDate = formatDate;
                        }
                    }
                    vm.allDeaprt = function () {
                        mvvm.show = 0;
                        mvvm.entity.$model.DepartIds = '';
                        mvvm.entity.$model.UserIds = '';
                        mvvm.entity.DepartIdName = '';
                        mvvm.entity.UserIdName = '';
                    }
                    vm.selectDeaprt = function () {
                        mvvm.entity.$model.UserIds = '';
                        mvvm.entity.UserIdName = '';
                        mvvm.show = 1;
                    }
                    vm.selectUser = function () {
                        mvvm.entity.$model.DepartIds = '';
                        mvvm.entity.DepartIdName = '';
                        mvvm.show = 2;
                    }
                    vm.clear = function () {
                        mvvm.entity = Condition;
                    }
                    vm.itemClick = function (e, item, label, val) {
                        $(this).attr('class', 'selected').siblings().removeClass('selected');
                        mvvm.entity[label] = val || item.Id
                    }

                    //选择部门
                    vm.postGroupTreeOpts = {
                        treeopts: {
                            check: {
                                enable: true,
                                chkboxType: { "Y": "s", "N": "s" },
                            },
                            async: {
                                enable: true,
                                url: '/Settings/GetGroupPostUser/104000000/'
                            },
                            callback: {
                                onCheck: function (event, treeId, treeNode) {

                                    tree = $.fn.zTree.getZTreeObj(treeId),

                                    names = [],
                                    ids = [],
                                    nodes = tree.getCheckedNodes(true)
                                    nodes.forEach(function (n, i) {
                                        names.push(n.Name)
                                        ids.push(n.Id)
                                    })
                                    mvvm.entity.$model.DepartIds = ids.join(',').toString();
                                    mvvm.entity.DepartIdName = names.join('，').toString()
                                }
                            }
                        }
                    }

                    vm.UserGroupTreeOpts = {
                        treeopts: {
                            check: {
                                enable: true,
                                chkboxType: { "Y": "s", "N": "s" },
                            },

                            callback: {
                                onCheck: function (event, treeId, treeNode) {

                                    tree = $.fn.zTree.getZTreeObj(treeId),

                                    names = [],
                                    ids = [],
                                    nodes = tree.getCheckedNodes(true)
                                    nodes.forEach(function (n, i) {
                                        names.push(n.Name)
                                        ids.push(n.Id)
                                    })
                                    mvvm.entity.$model.UserIds = ids.join(',').toString();
                                    mvvm.entity.UserIdName = names.join('，').toString()
                                }
                            },
                            async: {
                                url: function (treeId, treeNode) {
                                    return "/Settings/GetGroupPostUser/104000000"
                                },
                                dataFilter: notMemberFilter
                            }

                        }
                    }
                });

                getDataList();

                function getDataList() {
                    $.get('/Report/OpportunitySource', Condition, function (result) {
                        mvvm.dataList = result.data.list;
                        mvvm.total = result.data.total;
                        createColumnChart(result.data.list_chart, 'chartId', '1000', '300')
                    })

                    $.get('/Report/GetMarketDic', {}, function (result) {

                        mvvm.followStages = result.data.followStages;
                        mvvm.opporStatus = result.data.opporStatus;
                        mvvm.serviceTags = result.data.serviceTags;
                    })
                }

                mvvm.entity = Condition;
                CBCRM.fillContent(tmpl, lang, contentId, module, mvvm);
                CBCRM.onLoadModuleBefore = function () {
                    avalon.vmodels.Index = null
                    avalon.vmodels.setGroup.destroy()
                    avalon.vmodels.setUser.destroy()
                }
            },

            //销售机会跟单阶段分析
            OpportunityStage: function (tmpl, lang, contentId, module) {
                var CBCRM = avalon.vmodels.CBCRM

                var mvvm = avalon.define('OpportunityStage', function (vm) {
                    vm.dataList = [];
                    vm.entity = {};
                    vm.show = 0;
                    vm.total = 0;
                    vm.followStages = [];
                    vm.opporStatus = [];
                    vm.serviceTags = [];
                    vm.Source = [];
                    vm.search = function () {
                        $.get('/Report/OpportunityStage', mvvm.entity.$model, function (result) {
                            mvvm.dataList = result.data.list;
                            mvvm.total = result.data.total;
                            createColumnChart(result.data.list_chart, 'chartId', '1000', '300')
                        })
                    }
                    vm.dateOpts = {
                        format: '%Y-%m-%d',
                        onSelect: function (date, formatDate, format) {
                            mvvm.EndDate = formatDate;
                        }
                    }
                    vm.allDeaprt = function () {
                        mvvm.show = 0;
                        mvvm.entity.$model.DepartIds = '';
                        mvvm.entity.$model.UserIds = '';
                        mvvm.entity.DepartIdName = '';
                        mvvm.entity.UserIdName = '';
                    }
                    vm.selectDeaprt = function () {
                        mvvm.entity.$model.UserIds = '';
                        mvvm.entity.UserIdName = '';
                        mvvm.show = 1;
                    }
                    vm.selectUser = function () {
                        mvvm.entity.$model.DepartIds = '';
                        mvvm.entity.DepartIdName = '';
                        mvvm.show = 2;
                    }
                    vm.clear = function () {
                        mvvm.entity = Condition;
                    }
                    vm.itemClick = function (e, item, label, val) {
                        $(this).attr('class', 'selected').siblings().removeClass('selected');
                        mvvm.entity[label] = val || item.Id
                    }

                    //选择部门
                    vm.postGroupTreeOpts = {
                        treeopts: {
                            check: {
                                enable: true,
                                chkboxType: { "Y": "s", "N": "s" },
                            },
                            async: {
                                enable: true,
                                url: '/Settings/GetGroupPostUser/104000000/'
                            },
                            callback: {
                                onCheck: function (event, treeId, treeNode) {

                                    tree = $.fn.zTree.getZTreeObj(treeId),

                                    names = [],
                                    ids = [],
                                    nodes = tree.getCheckedNodes(true)
                                    nodes.forEach(function (n, i) {
                                        names.push(n.Name)
                                        ids.push(n.Id)
                                    })
                                    mvvm.entity.$model.DepartIds = ids.join(',').toString();
                                    mvvm.entity.DepartIdName = names.join('，').toString()
                                }
                            }
                        }
                    }

                    vm.UserGroupTreeOpts = {
                        treeopts: {
                            check: {
                                enable: true,
                                chkboxType: { "Y": "s", "N": "s" },
                            },

                            callback: {
                                onCheck: function (event, treeId, treeNode) {

                                    tree = $.fn.zTree.getZTreeObj(treeId),

                                    names = [],
                                    ids = [],
                                    nodes = tree.getCheckedNodes(true)
                                    nodes.forEach(function (n, i) {
                                        names.push(n.Name)
                                        ids.push(n.Id)
                                    })
                                    mvvm.entity.$model.UserIds = ids.join(',').toString();
                                    mvvm.entity.UserIdName = names.join('，').toString()
                                }
                            },
                            async: {
                                url: function (treeId, treeNode) {
                                    return "/Settings/GetGroupPostUser/104000000"
                                },
                                dataFilter: notMemberFilter
                            }

                        }
                    }
                });

                getDataList();

                function getDataList() {
                    $.get('/Report/OpportunityStage', Condition, function (result) {
                        mvvm.dataList = result.data.list;
                        mvvm.total = result.data.total;
                        createColumnChart(result.data.list_chart, 'chartId', '1000', '300')
                    })

                    $.get('/Report/GetMarketDic', {}, function (result) {

                        mvvm.Source = result.data.Source;
                        mvvm.opporStatus = result.data.opporStatus;
                        mvvm.serviceTags = result.data.serviceTags;
                    })
                }

                mvvm.entity = Condition;
                CBCRM.fillContent(tmpl, lang, contentId, module, mvvm);
                CBCRM.onLoadModuleBefore = function () {
                    avalon.vmodels.Index = null
                    avalon.vmodels.setGroup.destroy()
                    avalon.vmodels.setUser.destroy()
                }
            },

            //销售机会状态分析
            OpportunityStatus: function (tmpl, lang, contentId, module) {
                var CBCRM = avalon.vmodels.CBCRM

                var mvvm = avalon.define('OpportunityStatus', function (vm) {
                    vm.dataList = [];
                    vm.entity = {};
                    vm.show = 0;
                    vm.total = 0;
                    vm.followStages = [];
                    vm.opporStatus = [];
                    vm.serviceTags = [];
                    vm.Source = [];
                    vm.search = function () {
                        $.get('/Report/OpportunityStatus', mvvm.entity.$model, function (result) {
                            mvvm.dataList = result.data.list;
                            mvvm.total = result.data.total;
                            createColumnChart(result.data.list_chart, 'chartId', '1000', '300')
                        })
                    }
                    vm.dateOpts = {
                        format: '%Y-%m-%d',
                        onSelect: function (date, formatDate, format) {
                            mvvm.EndDate = formatDate;
                        }
                    }
                    vm.allDeaprt = function () {
                        mvvm.show = 0;
                        mvvm.entity.$model.DepartIds = '';
                        mvvm.entity.$model.UserIds = '';
                        mvvm.entity.DepartIdName = '';
                        mvvm.entity.UserIdName = '';
                    }
                    vm.selectDeaprt = function () {
                        mvvm.entity.$model.UserIds = '';
                        mvvm.entity.UserIdName = '';
                        mvvm.show = 1;
                    }
                    vm.selectUser = function () {
                        mvvm.entity.$model.DepartIds = '';
                        mvvm.entity.DepartIdName = '';
                        mvvm.show = 2;
                    }
                    vm.clear = function () {
                        mvvm.entity = Condition;
                    }
                    vm.itemClick = function (e, item, label, val) {
                        $(this).attr('class', 'selected').siblings().removeClass('selected');
                        mvvm.entity[label] = val || item.Id
                    }

                    //选择部门
                    vm.postGroupTreeOpts = {
                        treeopts: {
                            check: {
                                enable: true,
                                chkboxType: { "Y": "s", "N": "s" },
                            },
                            async: {
                                enable: true,
                                url: '/Settings/GetGroupPostUser/104000000/'
                            },
                            callback: {
                                onCheck: function (event, treeId, treeNode) {

                                    tree = $.fn.zTree.getZTreeObj(treeId),

                                    names = [],
                                    ids = [],
                                    nodes = tree.getCheckedNodes(true)
                                    nodes.forEach(function (n, i) {
                                        names.push(n.Name)
                                        ids.push(n.Id)
                                    })
                                    mvvm.entity.$model.DepartIds = ids.join(',').toString();
                                    mvvm.entity.DepartIdName = names.join('，').toString()
                                }
                            }
                        }
                    }

                    vm.UserGroupTreeOpts = {
                        treeopts: {
                            check: {
                                enable: true,
                                chkboxType: { "Y": "s", "N": "s" },
                            },

                            callback: {
                                onCheck: function (event, treeId, treeNode) {

                                    tree = $.fn.zTree.getZTreeObj(treeId),

                                    names = [],
                                    ids = [],
                                    nodes = tree.getCheckedNodes(true)
                                    nodes.forEach(function (n, i) {
                                        names.push(n.Name)
                                        ids.push(n.Id)
                                    })
                                    mvvm.entity.$model.UserIds = ids.join(',').toString();
                                    mvvm.entity.UserIdName = names.join('，').toString()
                                }
                            },
                            async: {
                                url: function (treeId, treeNode) {
                                    return "/Settings/GetGroupPostUser/104000000"
                                },
                                dataFilter: notMemberFilter
                            }

                        }
                    }
                });

                getDataList();

                function getDataList() {
                    $.get('/Report/OpportunityStatus', Condition, function (result) {
                        mvvm.dataList = result.data.list;
                        mvvm.total = result.data.total;
                        createColumnChart(result.data.list_chart, 'chartId', '1000', '300')
                    })

                    $.get('/Report/GetMarketDic', {}, function (result) {

                        mvvm.Source = result.data.Source;
                        mvvm.followStages = result.data.followStages;
                        mvvm.serviceTags = result.data.serviceTags;
                    })
                }

                mvvm.entity = Condition;
                CBCRM.fillContent(tmpl, lang, contentId, module, mvvm);
                CBCRM.onLoadModuleBefore = function () {
                    avalon.vmodels.Index = null
                    avalon.vmodels.setGroup.destroy()
                    avalon.vmodels.setUser.destroy()
                }
            },

            //销售机会跟单人分析
            OpportunityEmployee: function (tmpl, lang, contentId, module) {
                var CBCRM = avalon.vmodels.CBCRM

                var mvvm = avalon.define('OpportunityEmployee', function (vm) {
                    vm.dataList = [];
                    vm.entity = {};
                    vm.show = 0;
                    vm.total = 0;
                    vm.followStages = [];
                    vm.opporStatus = [];
                    vm.serviceTags = [];
                    vm.Source = [];
                    vm.search = function () {
                        $.get('/Report/OpportunityEmployee', mvvm.entity.$model, function (result) {
                            mvvm.dataList = result.data.list;
                            mvvm.total = result.data.total;
                            createColumnChart(result.data.list_chart, 'chartId', '1000', '300')
                        })
                    }
                    vm.dateOpts = {
                        format: '%Y-%m-%d',
                        onSelect: function (date, formatDate, format) {
                            mvvm.EndDate = formatDate;
                        }
                    }
                    vm.allDeaprt = function () {
                        mvvm.show = 0;
                        mvvm.entity.$model.DepartIds = '';
                        mvvm.entity.$model.UserIds = '';
                        mvvm.entity.DepartIdName = '';
                        mvvm.entity.UserIdName = '';
                    }
                    vm.selectDeaprt = function () {
                        mvvm.entity.$model.UserIds = '';
                        mvvm.entity.UserIdName = '';
                        mvvm.show = 1;
                    }
                    vm.selectUser = function () {
                        mvvm.entity.$model.DepartIds = '';
                        mvvm.entity.DepartIdName = '';
                        mvvm.show = 2;
                    }
                    vm.clear = function () {
                        mvvm.entity = Condition;
                    }
                    vm.itemClick = function (e, item, label, val) {
                        $(this).attr('class', 'selected').siblings().removeClass('selected');
                        mvvm.entity[label] = val || item.Id
                    }

                    //选择部门
                    vm.postGroupTreeOpts = {
                        treeopts: {
                            check: {
                                enable: true,
                                chkboxType: { "Y": "s", "N": "s" },
                            },
                            async: {
                                enable: true,
                                url: '/Settings/GetGroupPostUser/104000000/'
                            },
                            callback: {
                                onCheck: function (event, treeId, treeNode) {

                                    tree = $.fn.zTree.getZTreeObj(treeId),

                                    names = [],
                                    ids = [],
                                    nodes = tree.getCheckedNodes(true)
                                    nodes.forEach(function (n, i) {
                                        names.push(n.Name)
                                        ids.push(n.Id)
                                    })
                                    mvvm.entity.$model.DepartIds = ids.join(',').toString();
                                    mvvm.entity.DepartIdName = names.join('，').toString()
                                }
                            }
                        }
                    }

                    vm.UserGroupTreeOpts = {
                        treeopts: {
                            check: {
                                enable: true,
                                chkboxType: { "Y": "s", "N": "s" },
                            },

                            callback: {
                                onCheck: function (event, treeId, treeNode) {

                                    tree = $.fn.zTree.getZTreeObj(treeId),

                                    names = [],
                                    ids = [],
                                    nodes = tree.getCheckedNodes(true)
                                    nodes.forEach(function (n, i) {
                                        names.push(n.Name)
                                        ids.push(n.Id)
                                    })
                                    mvvm.entity.$model.UserIds = ids.join(',').toString();
                                    mvvm.entity.UserIdName = names.join('，').toString()
                                }
                            },
                            async: {
                                url: function (treeId, treeNode) {
                                    return "/Settings/GetGroupPostUser/104000000"
                                },
                                dataFilter: notMemberFilter
                            }

                        }
                    }
                });

                getDataList();

                function getDataList() {
                    $.get('/Report/OpportunityEmployee', Condition, function (result) {
                        mvvm.dataList = result.data.list;
                        mvvm.total = result.data.total;
                        createColumnChart(result.data.list_chart, 'chartId', '1000', '300')
                    })

                    $.get('/Report/GetMarketDic', {}, function (result) {

                        mvvm.Source = result.data.Source;
                        mvvm.followStages = result.data.followStages;
                        mvvm.serviceTags = result.data.serviceTags;
                        mvvm.opporStatus = result.data.opporStatus;
                    })
                }

                mvvm.entity = Condition;
                CBCRM.fillContent(tmpl, lang, contentId, module, mvvm);
                CBCRM.onLoadModuleBefore = function () {
                    avalon.vmodels.Index = null
                    avalon.vmodels.setGroup.destroy()
                    avalon.vmodels.setUser.destroy()
                }
            },

            //销售机会跟单部门分析
            OpportunityGroup: function (tmpl, lang, contentId, module) {
                var CBCRM = avalon.vmodels.CBCRM

                var mvvm = avalon.define('OpportunityGroup', function (vm) {
                    vm.dataList = [];
                    vm.entity = {};
                    vm.show = 0;
                    vm.total = 0;
                    vm.followStages = [];
                    vm.opporStatus = [];
                    vm.serviceTags = [];
                    vm.Source = [];
                    vm.search = function () {
                        $.get('/Report/OpportunityGroup', mvvm.entity.$model, function (result) {
                            mvvm.dataList = result.data.list;
                            mvvm.total = result.data.total;
                            createColumnChart(result.data.list_chart, 'chartId', '1000', '300')
                        })
                    }
                    vm.dateOpts = {
                        format: '%Y-%m-%d',
                        onSelect: function (date, formatDate, format) {
                            mvvm.EndDate = formatDate;
                        }
                    }
                    vm.allDeaprt = function () {
                        mvvm.show = 0;
                        mvvm.entity.$model.DepartIds = '';
                        mvvm.entity.$model.UserIds = '';
                        mvvm.entity.DepartIdName = '';
                        mvvm.entity.UserIdName = '';
                    }
                    vm.selectDeaprt = function () {
                        mvvm.entity.$model.UserIds = '';
                        mvvm.entity.UserIdName = '';
                        mvvm.show = 1;
                    }
                    vm.selectUser = function () {
                        mvvm.entity.$model.DepartIds = '';
                        mvvm.entity.DepartIdName = '';
                        mvvm.show = 2;
                    }
                    vm.clear = function () {
                        mvvm.entity = Condition;
                    }
                    vm.itemClick = function (e, item, label, val) {
                        $(this).attr('class', 'selected').siblings().removeClass('selected');
                        mvvm.entity[label] = val || item.Id
                    }

                    //选择部门
                    vm.postGroupTreeOpts = {
                        treeopts: {
                            check: {
                                enable: true,
                                chkboxType: { "Y": "s", "N": "s" },
                            },
                            async: {
                                enable: true,
                                url: '/Settings/GetGroupPostUser/104000000/'
                            },
                            callback: {
                                onCheck: function (event, treeId, treeNode) {

                                    tree = $.fn.zTree.getZTreeObj(treeId),

                                    names = [],
                                    ids = [],
                                    nodes = tree.getCheckedNodes(true)
                                    nodes.forEach(function (n, i) {
                                        names.push(n.Name)
                                        ids.push(n.Id)
                                    })
                                    mvvm.entity.$model.DepartIds = ids.join(',').toString();
                                    mvvm.entity.DepartIdName = names.join('，').toString()
                                }
                            }
                        }
                    }

                    vm.UserGroupTreeOpts = {
                        treeopts: {
                            check: {
                                enable: true,
                                chkboxType: { "Y": "s", "N": "s" },
                            },

                            callback: {
                                onCheck: function (event, treeId, treeNode) {

                                    tree = $.fn.zTree.getZTreeObj(treeId),

                                    names = [],
                                    ids = [],
                                    nodes = tree.getCheckedNodes(true)
                                    nodes.forEach(function (n, i) {
                                        names.push(n.Name)
                                        ids.push(n.Id)
                                    })
                                    mvvm.entity.$model.UserIds = ids.join(',').toString();
                                    mvvm.entity.UserIdName = names.join('，').toString()
                                }
                            },
                            async: {
                                url: function (treeId, treeNode) {
                                    return "/Settings/GetGroupPostUser/104000000"
                                },
                                dataFilter: notMemberFilter
                            }

                        }
                    }
                });

                getDataList();

                function getDataList() {
                    $.get('/Report/OpportunityGroup', Condition, function (result) {
                        mvvm.dataList = result.data.list;
                        mvvm.total = result.data.total;
                        createColumnChart(result.data.list_chart, 'chartId', '1000', '300')
                    })

                    $.get('/Report/GetMarketDic', {}, function (result) {

                        mvvm.Source = result.data.Source;
                        mvvm.followStages = result.data.followStages;
                        mvvm.serviceTags = result.data.serviceTags;
                        mvvm.opporStatus = result.data.opporStatus;
                    })
                }

                mvvm.entity = Condition;
                CBCRM.fillContent(tmpl, lang, contentId, module, mvvm);
                CBCRM.onLoadModuleBefore = function () {
                    avalon.vmodels.Index = null
                    avalon.vmodels.setGroup.destroy()
                    avalon.vmodels.setUser.destroy()
                }
            },

            //销售机会发现时间月份分析
            OpportunityDate: function (tmpl, lang, contentId, module) {
                var CBCRM = avalon.vmodels.CBCRM

                var mvvm = avalon.define('OpportunityDate', function (vm) {
                    vm.dataList = [];
                    vm.entity = {};
                    vm.year = [];
                    vm.total = 0;

                    vm.search = function () {
                        $.get('/Report/OpportunityDate', mvvm.entity.$model, function (result) {
                            mvvm.dataList = result.data.list;
                            mvvm.total = result.data.total;
                            createColumnChart(result.data.list_chart, 'chartId', '1000', '300')
                        })
                    }

                    vm.itemClick = function (e, item, label, val) {
                        $(this).attr('class', 'selected').siblings().removeClass('selected');
                        mvvm.entity[label] = val || item.year
                    }

                });

                getDataList();

                function getDataList() {
                    $.get('/Report/OpportunityDate', Condition, function (result) {
                        mvvm.dataList = result.data.list;
                        mvvm.total = result.data.total;
                        createColumnChart(result.data.list_chart, 'chartId', '1000', '300')
                    })

                    $.get('/Report/GetYearList', {}, function (result) {
                        mvvm.year = result.data;

                    })
                }

                mvvm.entity = Condition;
                CBCRM.fillContent(tmpl, lang, contentId, module, mvvm);
                CBCRM.onLoadModuleBefore = function () {
                    avalon.vmodels.Index = null
                }
            },

            //日程行动进度分析
            CalendarProgress: function (tmpl, lang, contentId, module) {
                var CBCRM = avalon.vmodels.CBCRM
                var mvvm = avalon.define('CalendarProgress', function (vm) {
                    vm.dataList = [];
                    vm.list_cat = [];
                    vm.entity = {};
                    vm.show = 0;
                    vm.total = 0;
                    vm.search = function () {
                        mvvm.entity.$model.notInit = '1';
                        $.get('/Report/CalendarProgress', mvvm.entity.$model, function (result) {
                            mvvm.dataList = result.data.list;
                            mvvm.total = result.data.total;
                            createColumnChart(result.data.list_chart, 'chartId', '90%', '360')
                        })
                    }
                    vm.dateOpts = {
                        format: '%Y-%m-%d',
                        onSelect: function (date, formatDate, format) {
                            mvvm.EndDate = formatDate;
                        }
                    }
                    vm.allDeaprt = function () {
                        mvvm.show = 0;
                        mvvm.entity.$model.DepartIds = '';
                        mvvm.entity.$model.UserIds = '';
                        mvvm.entity.DepartIdName = '';
                        mvvm.entity.UserIdName = '';
                    }
                    vm.selectDeaprt = function () {
                        mvvm.entity.$model.UserIds = '';
                        mvvm.entity.UserIdName = '';
                        mvvm.show = 1;
                    }
                    vm.selectUser = function () {
                        mvvm.entity.$model.DepartIds = '';
                        mvvm.entity.DepartIdName = '';
                        mvvm.show = 2;
                    }
                    vm.clear = function () {
                        mvvm.entity = searchMode;
                    }

                    //选择部门
                    vm.postGroupTreeOpts = {
                        treeopts: {
                            check: {
                                enable: true,
                                chkboxType: { "Y": "s", "N": "s" },
                            },
                            async: {
                                enable: true,
                                url: '/Settings/GetGroupPostUser/104000000/'
                            },
                            callback: {
                                onCheck: function (event, treeId, treeNode) {

                                    tree = $.fn.zTree.getZTreeObj(treeId),

                                    names = [],
                                    ids = [],
                                    nodes = tree.getCheckedNodes(true)
                                    nodes.forEach(function (n, i) {
                                        names.push(n.Name)
                                        ids.push(n.Id)
                                    })
                                    mvvm.entity.$model.DepartIds = ids.join(',').toString();
                                    mvvm.entity.DepartIdName = names.join('，').toString()
                                }
                            }
                        }
                    }

                    vm.UserGroupTreeOpts = {
                        treeopts: {
                            check: {
                                enable: true,
                                chkboxType: { "Y": "s", "N": "s" },
                            },

                            callback: {
                                onCheck: function (event, treeId, treeNode) {

                                    tree = $.fn.zTree.getZTreeObj(treeId),

                                    names = [],
                                    ids = [],
                                    nodes = tree.getCheckedNodes(true)
                                    nodes.forEach(function (n, i) {
                                        names.push(n.Name)
                                        ids.push(n.Id)
                                    })
                                    mvvm.entity.$model.UserIds = ids.join(',').toString();
                                    mvvm.entity.UserIdName = names.join('，').toString()
                                }
                            },
                            async: {
                                url: function (treeId, treeNode) {
                                    return "/Settings/GetGroupPostUser/104000000/"
                                },
                                dataFilter: notMemberFilter
                            }

                        }
                    }

                    vm.itemClick = function (e, item, label, val) {
                        $(this).attr('class', 'selected').siblings().removeClass('selected');
                        mvvm.entity.$model[label] = val || item.CategoryId;
                    }
                });

                getDataList();

                function getDataList() {
                    $.get('/Report/CalendarProgress', searchMode, function (result) {
                        mvvm.dataList = result.data.list;
                        mvvm.total = result.data.total;
                        mvvm.list_cat = result.data.list_cat;
                        createColumnChart(result.data.list_chart, 'chartId', '90%', '360')
                    })
                }

                mvvm.entity = searchMode;
                CBCRM.fillContent(tmpl, lang, contentId, module, mvvm);
                CBCRM.onLoadModuleBefore = function () {
                    avalon.vmodels.Index = null
                    avalon.vmodels.setGroup.destroy()
                    avalon.vmodels.setUser.destroy()
                }
            },

            ///服务类型分析 
            ServeType: function (tmpl, lang, contentId, module) {
                var CBCRM = avalon.vmodels.CBCRM
                var mvvm = avalon.define('ServeType', function (vm) {
                    vm.dataList = [];//数据列表
                    vm.category = [];//条件
                    vm.entity = {};//查询条件
                    vm.show = 0;//显示值
                    vm.hide = 0;//显示值
                    vm.total = 0;//总值
                    vm.search = function () {
                        $.get('/Report/ServeType', mvvm.entity.$model, function (result) {
                            mvvm.dataList = result.data.list;
                            mvvm.total = result.data.total;
                            var type = $('input[name="radioChart"]:checked').val();
                            switch (type) {
                                case "0":
                                    createColumnChart(result.data.list_chart, 'chartId', '850', '300')
                                    break;
                                case "1":
                                    createPieChart(result.data.list_chart, 'chartId', '850', '300')
                                    break;
                            }
                        })
                    }
                    vm.radioChart = function (type) {
                        $.get('/Report/ServeType', mvvm.entity.$model, function (result) {
                            mvvm.dataList = result.data.list;
                            mvvm.total = result.data.total;
                            switch (type) {
                                case 0:
                                    createColumnChart(result.data.list_chart, 'chartId', '850', '300')
                                    break;
                                case 1:
                                    createPieChart(result.data.list_chart, 'chartId', '850', '300')
                                    break;
                            }
                        })
                    }


                    vm.dateOpts = {
                        format: '%Y-%m-%d',
                        onSelect: function (date, formatDate, format) {
                            mvvm.StartDay = formatDate;
                            mvvm.StartDate = formatDate;
                            mvvm.EndDate = formatDate;
                        }
                    }

                    vm.MonthOpts = {
                        format: '%Y-%m',
                        onSelect: function (date, formatDate, format) {
                        }
                    }
                    vm.YearOpts = {
                        format: '%Y',
                        onSelect: function (date, formatDate, format) {
                        }
                    }


                    //查询日期范围
                    vm.rdSelect = function (type) {
                        mvvm.show = type;
                        switch (type) {
                            case 0:
                                mvvm.entity.searchMonth = '';
                                mvvm.entity.searchYear = '';
                                mvvm.entity.starTime = '';
                                mvvm.entity.endTime = '';
                                break;
                            case 1:
                                mvvm.entity.searchDay = '';
                                mvvm.entity.searchYear = '';
                                mvvm.entity.starTime = '';
                                mvvm.entity.endTime = '';
                                break;
                            case 2:
                                mvvm.entity.searchMonth = '';
                                mvvm.entity.searchDay = '';
                                mvvm.entity.starTime = '';
                                mvvm.entity.endTime = '';
                                break;
                            case 3:
                                mvvm.entity.searchDay = '';
                                mvvm.entity.searchMonth = '';
                                mvvm.entity.searchYear = '';
                                break;
                        }
                    }
                    //查询人员范围
                    vm.selectDeaprt = function (type) {
                        mvvm.hide = type;
                        switch (type) {
                            case 0:
                                mvvm.entity.$model.DepartIds = '';
                                mvvm.entity.$model.UserIds = '';
                                mvvm.entity.DepartIdName = '';
                                mvvm.entity.UserIdName = '';
                                break;
                            case 1:
                                mvvm.entity.$model.UserIds = '';
                                mvvm.entity.UserIdName = '';
                                break;
                            case 2:
                                mvvm.entity.$model.DepartIds = '';
                                mvvm.entity.DepartIdName = '';
                                break;
                        }
                    }
                    vm.clear = function () {
                        mvvm.entity = ServeMode;
                    }

                    //选择部门
                    vm.postGroupTreeOpts = {
                        treeopts: {
                            check: {
                                enable: true,
                                chkboxType: { "Y": "s", "N": "s" },
                            },
                            async: {
                                enable: true,
                                url: '/Settings/GetGroupPostUser/104000000/'
                            },
                            callback: {
                                onCheck: function (event, treeId, treeNode) {
                                    tree = $.fn.zTree.getZTreeObj(treeId),
                                    names = [],
                                    ids = [],
                                    nodes = tree.getCheckedNodes(true)
                                    nodes.forEach(function (n, i) {
                                        names.push(n.Name)
                                        ids.push(n.Id)
                                    })
                                    mvvm.entity.$model.DepartIds = ids.join(',').toString();
                                    mvvm.entity.DepartIdName = names.join('，').toString()
                                }
                            }
                        }
                    }

                    vm.UserGroupTreeOpts = {
                        treeopts: {
                            check: {
                                enable: true,
                                chkboxType: { "Y": "s", "N": "s" },
                            },

                            callback: {
                                onCheck: function (event, treeId, treeNode) {

                                    tree1 = $.fn.zTree.getZTreeObj(treeId),

                                    usernames = [],
                                    userids = [],
                                    nodes1 = tree1.getCheckedNodes(true)
                                    nodes1.forEach(function (n, i) {
                                        usernames.push(n.Name)
                                        userids.push(n.Id)
                                    })
                                    mvvm.entity.$model.UserIds = userids.join(',').toString();
                                    mvvm.entity.UserIdName = usernames.join('，').toString()
                                }
                            },
                            async: {
                                url: function (treeId, treeNode) {
                                    return "/Settings/GetGroupPostUser/104000000"
                                },
                                dataFilter: notMemberFilter
                            }
                        }
                    }
                });

                getDataList();
                function getDataList() {
                    $.get('/Report/ServeType', ServeMode, function (result) {
                        mvvm.dataList = result.data.list;
                        mvvm.total = result.data.total;
                        var type = $('input[name="radioChart"]:checked').val();
                        switch (type) {
                            case "0":
                                createColumnChart(result.data.list_chart, 'chartId', '850', '300')
                                break;
                            case "1":
                                createPieChart(result.data.list_chart, 'chartId', '850', '300')
                                break;
                        }
                    })
                }

                mvvm.entity = ServeMode;
                CBCRM.fillContent(tmpl, lang, contentId, module, mvvm);
                CBCRM.onLoadModuleBefore = function () {
                    avalon.vmodels.Index = null
                    avalon.vmodels.setGroup.destroy()
                    avalon.vmodels.setUser.destroy()
                }
            },

            ///服务状态分析 
            ServeState: function (tmpl, lang, contentId, module) {
                var CBCRM = avalon.vmodels.CBCRM
                var mvvm = avalon.define('ServeState', function (vm) {
                    vm.dataList = [];//数据列表
                    vm.category = [];//条件
                    vm.entity = {};//查询条件
                    vm.show = 0;//显示值
                    vm.hide = 0;//显示值
                    vm.total = 0;//总值
                    vm.search = function () {
                        $.get('/Report/ServeState', mvvm.entity.$model, function (result) {
                            mvvm.dataList = result.data.list;
                            mvvm.total = result.data.total;
                            var type = $('input[name="radioChart"]:checked').val();
                            switch (type) {
                                case "0":
                                    createColumnChart(result.data.list_chart, 'chartId', '850', '300')
                                    break;
                                case "1":
                                    createPieChart(result.data.list_chart, 'chartId', '850', '300')
                                    break;
                            }
                        })
                    }
                    vm.radioChart = function (type) {
                        $.get('/Report/ServeType', mvvm.entity.$model, function (result) {
                            mvvm.dataList = result.data.list;
                            mvvm.total = result.data.total;
                            switch (type) {
                                case 0:
                                    createColumnChart(result.data.list_chart, 'chartId', '850', '300')
                                    break;
                                case 1:
                                    createPieChart(result.data.list_chart, 'chartId', '850', '300')
                                    break;
                            }
                        })
                    }


                    vm.dateOpts = {
                        format: '%Y-%m-%d',
                        onSelect: function (date, formatDate, format) {
                            mvvm.StartDay = formatDate;
                            mvvm.StartDate = formatDate;
                            mvvm.EndDate = formatDate;
                        }
                    }

                    vm.MonthOpts = {
                        format: '%Y-%m',
                        onSelect: function (date, formatDate, format) {
                        }
                    }
                    vm.YearOpts = {
                        format: '%Y',
                        onSelect: function (date, formatDate, format) {
                        }
                    }


                    //查询日期范围
                    vm.rdSelect = function (type) {
                        mvvm.show = type;
                        switch (type) {
                            case 0:
                                mvvm.entity.searchMonth = '';
                                mvvm.entity.searchYear = '';
                                mvvm.entity.starTime = '';
                                mvvm.entity.endTime = '';
                                break;
                            case 1:
                                mvvm.entity.searchDay = '';
                                mvvm.entity.searchYear = '';
                                mvvm.entity.starTime = '';
                                mvvm.entity.endTime = '';
                                break;
                            case 2:
                                mvvm.entity.searchMonth = '';
                                mvvm.entity.searchDay = '';
                                mvvm.entity.starTime = '';
                                mvvm.entity.endTime = '';
                                break;
                            case 3:
                                mvvm.entity.searchDay = '';
                                mvvm.entity.searchMonth = '';
                                mvvm.entity.searchYear = '';
                                break;
                        }
                    }
                    //查询人员范围
                    vm.selectDeaprt = function (type) {
                        mvvm.hide = type;
                        switch (type) {
                            case 0:
                                mvvm.entity.$model.DepartIds = '';
                                mvvm.entity.$model.UserIds = '';
                                mvvm.entity.DepartIdName = '';
                                mvvm.entity.UserIdName = '';
                                break;
                            case 1:
                                mvvm.entity.$model.UserIds = '';
                                mvvm.entity.UserIdName = '';
                                break;
                            case 2:
                                mvvm.entity.$model.DepartIds = '';
                                mvvm.entity.DepartIdName = '';
                                break;
                        }
                    }
                    vm.clear = function () {
                        mvvm.entity = ServeMode;
                    }

                    //选择部门
                    vm.postGroupTreeOpts = {
                        treeopts: {
                            check: {
                                enable: true,
                                chkboxType: { "Y": "s", "N": "s" },
                            },
                            async: {
                                enable: true,
                                url: '/Settings/GetGroupPostUser/104000000/'
                            },
                            callback: {
                                onCheck: function (event, treeId, treeNode) {
                                    tree = $.fn.zTree.getZTreeObj(treeId),
                                    names = [],
                                    ids = [],
                                    nodes = tree.getCheckedNodes(true)
                                    nodes.forEach(function (n, i) {
                                        names.push(n.Name)
                                        ids.push(n.Id)
                                    })
                                    mvvm.entity.$model.DepartIds = ids.join(',').toString();
                                    mvvm.entity.DepartIdName = names.join('，').toString()
                                }
                            }
                        }
                    }

                    vm.UserGroupTreeOpts = {
                        treeopts: {
                            check: {
                                enable: true,
                                chkboxType: { "Y": "s", "N": "s" },
                            },

                            callback: {
                                onCheck: function (event, treeId, treeNode) {

                                    tree1 = $.fn.zTree.getZTreeObj(treeId),

                                    usernames = [],
                                    userids = [],
                                    nodes1 = tree1.getCheckedNodes(true)
                                    nodes1.forEach(function (n, i) {
                                        usernames.push(n.Name)
                                        userids.push(n.Id)
                                    })
                                    mvvm.entity.$model.UserIds = userids.join(',').toString();
                                    mvvm.entity.UserIdName = usernames.join('，').toString()
                                }
                            },
                            async: {
                                url: function (treeId, treeNode) {
                                    return "/Settings/GetGroupPostUser/104000000"
                                },
                                dataFilter: notMemberFilter
                            }
                        }
                    }
                });

                getDataList();
                function getDataList() {
                    $.get('/Report/ServeState', ServeMode, function (result) {
                        mvvm.dataList = result.data.list;
                        mvvm.total = result.data.total;
                        var type = $('input[name="radioChart"]:checked').val();
                        switch (type) {
                            case "0":
                                createColumnChart(result.data.list_chart, 'chartId', '850', '300')
                                break;
                            case "1":
                                createPieChart(result.data.list_chart, 'chartId', '850', '300')
                                break;
                        }
                    })
                }

                mvvm.entity = ServeMode;
                CBCRM.fillContent(tmpl, lang, contentId, module, mvvm);
                CBCRM.onLoadModuleBefore = function () {
                    avalon.vmodels.Index = null
                    avalon.vmodels.setGroup.destroy()
                    avalon.vmodels.setUser.destroy()
                }
            },

            ///服务紧急程度分析 
            ServeUrgent: function (tmpl, lang, contentId, module) {
                var CBCRM = avalon.vmodels.CBCRM
                var mvvm = avalon.define('ServeUrgent', function (vm) {
                    vm.dataList = [];//数据列表
                    vm.category = [];//条件
                    vm.entity = {};//查询条件
                    vm.show = 0;//显示值
                    vm.hide = 0;//显示值
                    vm.total = 0;//总值
                    vm.search = function () {
                        $.get('/Report/ServeUrgent', mvvm.entity.$model, function (result) {
                            mvvm.dataList = result.data.list;
                            mvvm.total = result.data.total;
                            var type = $('input[name="radioChart"]:checked').val();
                            switch (type) {
                                case "0":
                                    createColumnChart(result.data.list_chart, 'chartId', '850', '300')
                                    break;
                                case "1":
                                    createPieChart(result.data.list_chart, 'chartId', '850', '300')
                                    break;
                            }
                        })
                    }
                    vm.radioChart = function (type) {
                        $.get('/Report/ServeUrgent', mvvm.entity.$model, function (result) {
                            mvvm.dataList = result.data.list;
                            mvvm.total = result.data.total;
                            switch (type) {
                                case 0:
                                    createColumnChart(result.data.list_chart, 'chartId', '850', '300')
                                    break;
                                case 1:
                                    createPieChart(result.data.list_chart, 'chartId', '850', '300')
                                    break;
                            }
                        })
                    }


                    vm.dateOpts = {
                        format: '%Y-%m-%d',
                        onSelect: function (date, formatDate, format) {
                            mvvm.StartDay = formatDate;
                            mvvm.StartDate = formatDate;
                            mvvm.EndDate = formatDate;
                        }
                    }

                    vm.MonthOpts = {
                        format: '%Y-%m',
                        onSelect: function (date, formatDate, format) {
                        }
                    }
                    vm.YearOpts = {
                        format: '%Y',
                        onSelect: function (date, formatDate, format) {
                        }
                    }


                    //查询日期范围
                    vm.rdSelect = function (type) {
                        mvvm.show = type;
                        switch (type) {
                            case 0:
                                mvvm.entity.searchMonth = '';
                                mvvm.entity.searchYear = '';
                                mvvm.entity.starTime = '';
                                mvvm.entity.endTime = '';
                                break;
                            case 1:
                                mvvm.entity.searchDay = '';
                                mvvm.entity.searchYear = '';
                                mvvm.entity.starTime = '';
                                mvvm.entity.endTime = '';
                                break;
                            case 2:
                                mvvm.entity.searchMonth = '';
                                mvvm.entity.searchDay = '';
                                mvvm.entity.starTime = '';
                                mvvm.entity.endTime = '';
                                break;
                            case 3:
                                mvvm.entity.searchDay = '';
                                mvvm.entity.searchMonth = '';
                                mvvm.entity.searchYear = '';
                                break;
                        }
                    }
                    //查询人员范围
                    vm.selectDeaprt = function (type) {
                        mvvm.hide = type;
                        switch (type) {
                            case 0:
                                mvvm.entity.$model.DepartIds = '';
                                mvvm.entity.$model.UserIds = '';
                                mvvm.entity.DepartIdName = '';
                                mvvm.entity.UserIdName = '';
                                break;
                            case 1:
                                mvvm.entity.$model.UserIds = '';
                                mvvm.entity.UserIdName = '';
                                break;
                            case 2:
                                mvvm.entity.$model.DepartIds = '';
                                mvvm.entity.DepartIdName = '';
                                break;
                        }
                    }
                    vm.clear = function () {
                        mvvm.entity = ServeMode;
                    }

                    //选择部门
                    vm.postGroupTreeOpts = {
                        treeopts: {
                            check: {
                                enable: true,
                                chkboxType: { "Y": "s", "N": "s" },
                            },
                            async: {
                                enable: true,
                                url: '/Settings/GetGroupPostUser/104000000/'
                            },
                            callback: {
                                onCheck: function (event, treeId, treeNode) {
                                    tree = $.fn.zTree.getZTreeObj(treeId),
                                    names = [],
                                    ids = [],
                                    nodes = tree.getCheckedNodes(true)
                                    nodes.forEach(function (n, i) {
                                        names.push(n.Name)
                                        ids.push(n.Id)
                                    })
                                    mvvm.entity.$model.DepartIds = ids.join(',').toString();
                                    mvvm.entity.DepartIdName = names.join('，').toString()
                                }
                            }
                        }
                    }

                    vm.UserGroupTreeOpts = {
                        treeopts: {
                            check: {
                                enable: true,
                                chkboxType: { "Y": "s", "N": "s" },
                            },

                            callback: {
                                onCheck: function (event, treeId, treeNode) {

                                    tree1 = $.fn.zTree.getZTreeObj(treeId),

                                    usernames = [],
                                    userids = [],
                                    nodes1 = tree1.getCheckedNodes(true)
                                    nodes1.forEach(function (n, i) {
                                        usernames.push(n.Name)
                                        userids.push(n.Id)
                                    })
                                    mvvm.entity.$model.UserIds = userids.join(',').toString();
                                    mvvm.entity.UserIdName = usernames.join('，').toString()
                                }
                            },
                            async: {
                                url: function (treeId, treeNode) {
                                    return "/Settings/GetGroupPostUser/104000000"
                                },
                                dataFilter: notMemberFilter
                            }
                        }
                    }
                });

                getDataList();
                function getDataList() {
                    $.get('/Report/ServeUrgent', ServeMode, function (result) {
                        mvvm.dataList = result.data.list;
                        mvvm.total = result.data.total;
                        var type = $('input[name="radioChart"]:checked').val();
                        switch (type) {
                            case "0":
                                createColumnChart(result.data.list_chart, 'chartId', '850', '300')
                                break;
                            case "1":
                                createPieChart(result.data.list_chart, 'chartId', '850', '300')
                                break;
                        }
                    })
                }

                mvvm.entity = ServeMode;
                CBCRM.fillContent(tmpl, lang, contentId, module, mvvm);
                CBCRM.onLoadModuleBefore = function () {
                    avalon.vmodels.Index = null
                    avalon.vmodels.setGroup.destroy()
                    avalon.vmodels.setUser.destroy()
                }
            },

            ///服务方式分析 
            ServeMode: function (tmpl, lang, contentId, module) {
                var CBCRM = avalon.vmodels.CBCRM
                var mvvm = avalon.define('ServeMode', function (vm) {
                    vm.dataList = [];//数据列表
                    vm.category = [];//条件
                    vm.entity = {};//查询条件
                    vm.show = 0;//显示值
                    vm.hide = 0;//显示值
                    vm.total = 0;//总值
                    vm.search = function () {
                        $.get('/Report/ServeMode', mvvm.entity.$model, function (result) {
                            mvvm.dataList = result.data.list;
                            mvvm.total = result.data.total;
                            var type = $('input[name="radioChart"]:checked').val();
                            switch (type) {
                                case "0":
                                    createColumnChart(result.data.list_chart, 'chartId', '850', '300')
                                    break;
                                case "1":
                                    createPieChart(result.data.list_chart, 'chartId', '850', '300')
                                    break;
                            }
                        })
                    }
                    vm.radioChart = function (type) {
                        $.get('/Report/ServeMode', mvvm.entity.$model, function (result) {
                            mvvm.dataList = result.data.list;
                            mvvm.total = result.data.total;
                            switch (type) {
                                case 0:
                                    createColumnChart(result.data.list_chart, 'chartId', '850', '300')
                                    break;
                                case 1:
                                    createPieChart(result.data.list_chart, 'chartId', '850', '300')
                                    break;
                            }
                        })
                    }


                    vm.dateOpts = {
                        format: '%Y-%m-%d',
                        onSelect: function (date, formatDate, format) {
                            mvvm.StartDay = formatDate;
                            mvvm.StartDate = formatDate;
                            mvvm.EndDate = formatDate;
                        }
                    }

                    vm.MonthOpts = {
                        format: '%Y-%m',
                        onSelect: function (date, formatDate, format) {
                        }
                    }
                    vm.YearOpts = {
                        format: '%Y',
                        onSelect: function (date, formatDate, format) {
                        }
                    }


                    //查询日期范围
                    vm.rdSelect = function (type) {
                        mvvm.show = type;
                        switch (type) {
                            case 0:
                                mvvm.entity.searchMonth = '';
                                mvvm.entity.searchYear = '';
                                mvvm.entity.starTime = '';
                                mvvm.entity.endTime = '';
                                break;
                            case 1:
                                mvvm.entity.searchDay = '';
                                mvvm.entity.searchYear = '';
                                mvvm.entity.starTime = '';
                                mvvm.entity.endTime = '';
                                break;
                            case 2:
                                mvvm.entity.searchMonth = '';
                                mvvm.entity.searchDay = '';
                                mvvm.entity.starTime = '';
                                mvvm.entity.endTime = '';
                                break;
                            case 3:
                                mvvm.entity.searchDay = '';
                                mvvm.entity.searchMonth = '';
                                mvvm.entity.searchYear = '';
                                break;
                        }
                    }
                    //查询人员范围
                    vm.selectDeaprt = function (type) {
                        mvvm.hide = type;
                        switch (type) {
                            case 0:
                                mvvm.entity.$model.DepartIds = '';
                                mvvm.entity.$model.UserIds = '';
                                mvvm.entity.DepartIdName = '';
                                mvvm.entity.UserIdName = '';
                                break;
                            case 1:
                                mvvm.entity.$model.UserIds = '';
                                mvvm.entity.UserIdName = '';
                                break;
                            case 2:
                                mvvm.entity.$model.DepartIds = '';
                                mvvm.entity.DepartIdName = '';
                                break;
                        }
                    }
                    vm.clear = function () {
                        mvvm.entity = ServeMode;
                    }

                    //选择部门
                    vm.postGroupTreeOpts = {
                        treeopts: {
                            check: {
                                enable: true,
                                chkboxType: { "Y": "s", "N": "s" },
                            },
                            async: {
                                enable: true,
                                url: '/Settings/GetGroupPostUser/104000000/'
                            },
                            callback: {
                                onCheck: function (event, treeId, treeNode) {
                                    tree = $.fn.zTree.getZTreeObj(treeId),
                                    names = [],
                                    ids = [],
                                    nodes = tree.getCheckedNodes(true)
                                    nodes.forEach(function (n, i) {
                                        names.push(n.Name)
                                        ids.push(n.Id)
                                    })
                                    mvvm.entity.$model.DepartIds = ids.join(',').toString();
                                    mvvm.entity.DepartIdName = names.join('，').toString()
                                }
                            }
                        }
                    }

                    vm.UserGroupTreeOpts = {
                        treeopts: {
                            check: {
                                enable: true,
                                chkboxType: { "Y": "s", "N": "s" },
                            },

                            callback: {
                                onCheck: function (event, treeId, treeNode) {

                                    tree1 = $.fn.zTree.getZTreeObj(treeId),

                                    usernames = [],
                                    userids = [],
                                    nodes1 = tree1.getCheckedNodes(true)
                                    nodes1.forEach(function (n, i) {
                                        usernames.push(n.Name)
                                        userids.push(n.Id)
                                    })
                                    mvvm.entity.$model.UserIds = userids.join(',').toString();
                                    mvvm.entity.UserIdName = usernames.join('，').toString()
                                }
                            },
                            async: {
                                url: function (treeId, treeNode) {
                                    return "/Settings/GetGroupPostUser/104000000"
                                },
                                dataFilter: notMemberFilter
                            }
                        }
                    }
                });

                getDataList();
                function getDataList() {
                    $.get('/Report/ServeMode', ServeMode, function (result) {
                        mvvm.dataList = result.data.list;
                        mvvm.total = result.data.total;
                        var type = $('input[name="radioChart"]:checked').val();
                        switch (type) {
                            case "0":
                                createColumnChart(result.data.list_chart, 'chartId', '850', '300')
                                break;
                            case "1":
                                createPieChart(result.data.list_chart, 'chartId', '850', '300')
                                break;
                        }
                    })
                }

                mvvm.entity = ServeMode;
                CBCRM.fillContent(tmpl, lang, contentId, module, mvvm);
                CBCRM.onLoadModuleBefore = function () {
                    avalon.vmodels.Index = null
                    avalon.vmodels.setGroup.destroy()
                    avalon.vmodels.setUser.destroy()
                }
            },
            ///客户服务次数top10分析 
            ServeTop: function (tmpl, lang, contentId, module) {
                var CBCRM = avalon.vmodels.CBCRM
                var mvvm = avalon.define('ServeTop', function (vm) {
                    vm.dataList = [];//数据列表
                    vm.category = [];//条件
                    vm.entity = {};//查询条件
                    vm.show = 0;//显示值
                    vm.hide = 0;//显示值
                    vm.total = 0;//总值
                    vm.search = function () {
                        $.get('/Report/ServeTop', mvvm.entity.$model, function (result) {
                            mvvm.dataList = result.data.list;
                            mvvm.total = result.data.total;
                            var type = $('input[name="radioChart"]:checked').val();
                            switch (type) {
                                case "0":
                                    createColumnChart(result.data.list_chart, 'chartId', '850', '300')
                                    break;
                                case "1":
                                    createPieChart(result.data.list_chart, 'chartId', '850', '300')
                                    break;
                            }
                        })
                    }
                    vm.radioChart = function (type) {
                        $.get('/Report/ServeTop', mvvm.entity.$model, function (result) {
                            mvvm.dataList = result.data.list;
                            mvvm.total = result.data.total;
                            switch (type) {
                                case 0:
                                    createColumnChart(result.data.list_chart, 'chartId', '850', '300')
                                    break;
                                case 1:
                                    createPieChart(result.data.list_chart, 'chartId', '850', '300')
                                    break;
                            }
                        })
                    }


                    vm.dateOpts = {
                        format: '%Y-%m-%d',
                        onSelect: function (date, formatDate, format) {
                            mvvm.StartDay = formatDate;
                            mvvm.StartDate = formatDate;
                            mvvm.EndDate = formatDate;
                        }
                    }

                    vm.MonthOpts = {
                        format: '%Y-%m',
                        onSelect: function (date, formatDate, format) {
                        }
                    }
                    vm.YearOpts = {
                        format: '%Y',
                        onSelect: function (date, formatDate, format) {
                        }
                    }


                    //查询日期范围
                    vm.rdSelect = function (type) {
                        mvvm.show = type;
                        switch (type) {
                            case 0:
                                mvvm.entity.searchMonth = '';
                                mvvm.entity.searchYear = '';
                                mvvm.entity.starTime = '';
                                mvvm.entity.endTime = '';
                                break;
                            case 1:
                                mvvm.entity.searchDay = '';
                                mvvm.entity.searchYear = '';
                                mvvm.entity.starTime = '';
                                mvvm.entity.endTime = '';
                                break;
                            case 2:
                                mvvm.entity.searchMonth = '';
                                mvvm.entity.searchDay = '';
                                mvvm.entity.starTime = '';
                                mvvm.entity.endTime = '';
                                break;
                            case 3:
                                mvvm.entity.searchDay = '';
                                mvvm.entity.searchMonth = '';
                                mvvm.entity.searchYear = '';
                                break;
                        }
                    }
                    //查询人员范围
                    vm.selectDeaprt = function (type) {
                        mvvm.hide = type;
                        switch (type) {
                            case 0:
                                mvvm.entity.$model.DepartIds = '';
                                mvvm.entity.$model.UserIds = '';
                                mvvm.entity.DepartIdName = '';
                                mvvm.entity.UserIdName = '';
                                break;
                            case 1:
                                mvvm.entity.$model.UserIds = '';
                                mvvm.entity.UserIdName = '';
                                break;
                            case 2:
                                mvvm.entity.$model.DepartIds = '';
                                mvvm.entity.DepartIdName = '';
                                break;
                        }
                    }
                    vm.clear = function () {
                        mvvm.entity = ServeMode;
                    }

                    //选择部门
                    vm.postGroupTreeOpts = {
                        treeopts: {
                            check: {
                                enable: true,
                                chkboxType: { "Y": "s", "N": "s" },
                            },
                            async: {
                                enable: true,
                                url: '/Settings/GetGroupPostUser/104000000/'
                            },
                            callback: {
                                onCheck: function (event, treeId, treeNode) {
                                    tree = $.fn.zTree.getZTreeObj(treeId),
                                    names = [],
                                    ids = [],
                                    nodes = tree.getCheckedNodes(true)
                                    nodes.forEach(function (n, i) {
                                        names.push(n.Name)
                                        ids.push(n.Id)
                                    })
                                    mvvm.entity.$model.DepartIds = ids.join(',').toString();
                                    mvvm.entity.DepartIdName = names.join('，').toString()
                                }
                            }
                        }
                    }

                    vm.UserGroupTreeOpts = {
                        treeopts: {
                            check: {
                                enable: true,
                                chkboxType: { "Y": "s", "N": "s" },
                            },

                            callback: {
                                onCheck: function (event, treeId, treeNode) {

                                    tree1 = $.fn.zTree.getZTreeObj(treeId),

                                    usernames = [],
                                    userids = [],
                                    nodes1 = tree1.getCheckedNodes(true)
                                    nodes1.forEach(function (n, i) {
                                        usernames.push(n.Name)
                                        userids.push(n.Id)
                                    })
                                    mvvm.entity.$model.UserIds = userids.join(',').toString();
                                    mvvm.entity.UserIdName = usernames.join('，').toString()
                                }
                            },
                            async: {
                                url: function (treeId, treeNode) {
                                    return "/Settings/GetGroupPostUser/104000000"
                                },
                                dataFilter: notMemberFilter
                            }
                        }
                    }
                });

                getDataList();
                function getDataList() {
                    $.get('/Report/ServeTop', ServeMode, function (result) {
                        mvvm.dataList = result.data.list;
                        mvvm.total = result.data.total;
                        var type = $('input[name="radioChart"]:checked').val();
                        switch (type) {
                            case "0":
                                createColumnChart(result.data.list_chart, 'chartId', '850', '300')
                                break;
                            case "1":
                                createPieChart(result.data.list_chart, 'chartId', '850', '300')
                                break;
                        }
                    })
                }

                mvvm.entity = ServeMode;
                CBCRM.fillContent(tmpl, lang, contentId, module, mvvm);
                CBCRM.onLoadModuleBefore = function () {
                    avalon.vmodels.Index = null
                    avalon.vmodels.setGroup.destroy()
                    avalon.vmodels.setUser.destroy()
                }
            },
            ///投诉类型分析 
            ComplainType: function (tmpl, lang, contentId, module) {
                var CBCRM = avalon.vmodels.CBCRM
                var mvvm = avalon.define('ComplainType', function (vm) {
                    vm.dataList = [];//数据列表
                    vm.category = [];//条件
                    vm.entity = {};//查询条件
                    vm.show = 0;//显示值
                    vm.hide = 0;//显示值
                    vm.total = 0;//总值
                    vm.search = function () {
                        $.get('/Report/ComplainType', mvvm.entity.$model, function (result) {
                            mvvm.dataList = result.data.list;
                            mvvm.total = result.data.total;
                            var type = $('input[name="radioChart"]:checked').val();
                            switch (type) {
                                case "0":
                                    createColumnChart(result.data.list_chart, 'chartId', '850', '300')
                                    break;
                                case "1":
                                    createPieChart(result.data.list_chart, 'chartId', '850', '300')
                                    break;
                            }
                        })
                    }
                    vm.radioChart = function (type) {
                        $.get('/Report/ComplainType', mvvm.entity.$model, function (result) {
                            mvvm.dataList = result.data.list;
                            mvvm.total = result.data.total;
                            switch (type) {
                                case 0:
                                    createColumnChart(result.data.list_chart, 'chartId', '850', '300')
                                    break;
                                case 1:
                                    createPieChart(result.data.list_chart, 'chartId', '850', '300')
                                    break;
                            }
                        })
                    }


                    vm.dateOpts = {
                        format: '%Y-%m-%d',
                        onSelect: function (date, formatDate, format) {
                            mvvm.StartDay = formatDate;
                            mvvm.StartDate = formatDate;
                            mvvm.EndDate = formatDate;
                        }
                    }

                    vm.MonthOpts = {
                        format: '%Y-%m',
                        onSelect: function (date, formatDate, format) {
                        }
                    }
                    vm.YearOpts = {
                        format: '%Y',
                        onSelect: function (date, formatDate, format) {
                        }
                    }


                    //查询日期范围
                    vm.rdSelect = function (type) {
                        mvvm.show = type;
                        switch (type) {
                            case 0:
                                mvvm.entity.searchMonth = '';
                                mvvm.entity.searchYear = '';
                                mvvm.entity.starTime = '';
                                mvvm.entity.endTime = '';
                                break;
                            case 1:
                                mvvm.entity.searchDay = '';
                                mvvm.entity.searchYear = '';
                                mvvm.entity.starTime = '';
                                mvvm.entity.endTime = '';
                                break;
                            case 2:
                                mvvm.entity.searchMonth = '';
                                mvvm.entity.searchDay = '';
                                mvvm.entity.starTime = '';
                                mvvm.entity.endTime = '';
                                break;
                            case 3:
                                mvvm.entity.searchDay = '';
                                mvvm.entity.searchMonth = '';
                                mvvm.entity.searchYear = '';
                                break;
                        }
                    }
                    //查询人员范围
                    vm.selectDeaprt = function (type) {
                        mvvm.hide = type;
                        switch (type) {
                            case 0:
                                mvvm.entity.$model.DepartIds = '';
                                mvvm.entity.$model.UserIds = '';
                                mvvm.entity.DepartIdName = '';
                                mvvm.entity.UserIdName = '';
                                break;
                            case 1:
                                mvvm.entity.$model.UserIds = '';
                                mvvm.entity.UserIdName = '';
                                break;
                            case 2:
                                mvvm.entity.$model.DepartIds = '';
                                mvvm.entity.DepartIdName = '';
                                break;
                        }
                    }
                    vm.clear = function () {
                        mvvm.entity = ServeMode;
                    }

                    //选择部门
                    vm.postGroupTreeOpts = {
                        treeopts: {
                            check: {
                                enable: true,
                                chkboxType: { "Y": "s", "N": "s" },
                            },
                            async: {
                                enable: true,
                                url: '/Settings/GetGroupPostUser/104000000/'
                            },
                            callback: {
                                onCheck: function (event, treeId, treeNode) {
                                    tree = $.fn.zTree.getZTreeObj(treeId),
                                    names = [],
                                    ids = [],
                                    nodes = tree.getCheckedNodes(true)
                                    nodes.forEach(function (n, i) {
                                        names.push(n.Name)
                                        ids.push(n.Id)
                                    })
                                    mvvm.entity.$model.DepartIds = ids.join(',').toString();
                                    mvvm.entity.DepartIdName = names.join('，').toString()
                                }
                            }
                        }
                    }

                    vm.UserGroupTreeOpts = {
                        treeopts: {
                            check: {
                                enable: true,
                                chkboxType: { "Y": "s", "N": "s" },
                            },

                            callback: {
                                onCheck: function (event, treeId, treeNode) {

                                    tree1 = $.fn.zTree.getZTreeObj(treeId),

                                    usernames = [],
                                    userids = [],
                                    nodes1 = tree1.getCheckedNodes(true)
                                    nodes1.forEach(function (n, i) {
                                        usernames.push(n.Name)
                                        userids.push(n.Id)
                                    })
                                    mvvm.entity.$model.UserIds = userids.join(',').toString();
                                    mvvm.entity.UserIdName = usernames.join('，').toString()
                                }
                            },
                            async: {
                                url: function (treeId, treeNode) {
                                    return "/Settings/GetGroupPostUser/104000000"
                                },
                                dataFilter: notMemberFilter
                            }
                        }
                    }
                });

                getDataList();
                function getDataList() {
                    $.get('/Report/ComplainType', ServeMode, function (result) {
                        mvvm.dataList = result.data.list;
                        mvvm.total = result.data.total;
                        var type = $('input[name="radioChart"]:checked').val();
                        switch (type) {
                            case "0":
                                createColumnChart(result.data.list_chart, 'chartId', '850', '300')
                                break;
                            case "1":
                                createPieChart(result.data.list_chart, 'chartId', '850', '300')
                                break;
                        }
                    })
                }

                mvvm.entity = ServeMode;
                CBCRM.fillContent(tmpl, lang, contentId, module, mvvm);
                CBCRM.onLoadModuleBefore = function () {
                    avalon.vmodels.Index = null
                    avalon.vmodels.setGroup.destroy()
                    avalon.vmodels.setUser.destroy()
                }
            },
            ///投诉状态分析 
            ComplainState: function (tmpl, lang, contentId, module) {
                var CBCRM = avalon.vmodels.CBCRM
                var mvvm = avalon.define('ComplainState', function (vm) {
                    vm.dataList = [];//数据列表
                    vm.category = [];//条件
                    vm.entity = {};//查询条件
                    vm.show = 0;//显示值
                    vm.hide = 0;//显示值
                    vm.total = 0;//总值
                    vm.search = function () {
                        $.get('/Report/ComplainState', mvvm.entity.$model, function (result) {
                            mvvm.dataList = result.data.list;
                            mvvm.total = result.data.total;
                            var type = $('input[name="radioChart"]:checked').val();
                            switch (type) {
                                case "0":
                                    createColumnChart(result.data.list_chart, 'chartId', '850', '300')
                                    break;
                                case "1":
                                    createPieChart(result.data.list_chart, 'chartId', '850', '300')
                                    break;
                            }
                        })
                    }
                    vm.radioChart = function (type) {
                        $.get('/Report/ComplainState', mvvm.entity.$model, function (result) {
                            mvvm.dataList = result.data.list;
                            mvvm.total = result.data.total;
                            switch (type) {
                                case 0:
                                    createColumnChart(result.data.list_chart, 'chartId', '850', '300')
                                    break;
                                case 1:
                                    createPieChart(result.data.list_chart, 'chartId', '850', '300')
                                    break;
                            }
                        })
                    }


                    vm.dateOpts = {
                        format: '%Y-%m-%d',
                        onSelect: function (date, formatDate, format) {
                            mvvm.StartDay = formatDate;
                            mvvm.StartDate = formatDate;
                            mvvm.EndDate = formatDate;
                        }
                    }

                    vm.MonthOpts = {
                        format: '%Y-%m',
                        onSelect: function (date, formatDate, format) {
                        }
                    }
                    vm.YearOpts = {
                        format: '%Y',
                        onSelect: function (date, formatDate, format) {
                        }
                    }


                    //查询日期范围
                    vm.rdSelect = function (type) {
                        mvvm.show = type;
                        switch (type) {
                            case 0:
                                mvvm.entity.searchMonth = '';
                                mvvm.entity.searchYear = '';
                                mvvm.entity.starTime = '';
                                mvvm.entity.endTime = '';
                                break;
                            case 1:
                                mvvm.entity.searchDay = '';
                                mvvm.entity.searchYear = '';
                                mvvm.entity.starTime = '';
                                mvvm.entity.endTime = '';
                                break;
                            case 2:
                                mvvm.entity.searchMonth = '';
                                mvvm.entity.searchDay = '';
                                mvvm.entity.starTime = '';
                                mvvm.entity.endTime = '';
                                break;
                            case 3:
                                mvvm.entity.searchDay = '';
                                mvvm.entity.searchMonth = '';
                                mvvm.entity.searchYear = '';
                                break;
                        }
                    }
                    //查询人员范围
                    vm.selectDeaprt = function (type) {
                        mvvm.hide = type;
                        switch (type) {
                            case 0:
                                mvvm.entity.$model.DepartIds = '';
                                mvvm.entity.$model.UserIds = '';
                                mvvm.entity.DepartIdName = '';
                                mvvm.entity.UserIdName = '';
                                break;
                            case 1:
                                mvvm.entity.$model.UserIds = '';
                                mvvm.entity.UserIdName = '';
                                break;
                            case 2:
                                mvvm.entity.$model.DepartIds = '';
                                mvvm.entity.DepartIdName = '';
                                break;
                        }
                    }
                    vm.clear = function () {
                        mvvm.entity = ServeMode;
                    }

                    //选择部门
                    vm.postGroupTreeOpts = {
                        treeopts: {
                            check: {
                                enable: true,
                                chkboxType: { "Y": "s", "N": "s" },
                            },
                            async: {
                                enable: true,
                                url: '/Settings/GetGroupPostUser/104000000/'
                            },
                            callback: {
                                onCheck: function (event, treeId, treeNode) {
                                    tree = $.fn.zTree.getZTreeObj(treeId),
                                    names = [],
                                    ids = [],
                                    nodes = tree.getCheckedNodes(true)
                                    nodes.forEach(function (n, i) {
                                        names.push(n.Name)
                                        ids.push(n.Id)
                                    })
                                    mvvm.entity.$model.DepartIds = ids.join(',').toString();
                                    mvvm.entity.DepartIdName = names.join('，').toString()
                                }
                            }
                        }
                    }

                    vm.UserGroupTreeOpts = {
                        treeopts: {
                            check: {
                                enable: true,
                                chkboxType: { "Y": "s", "N": "s" },
                            },

                            callback: {
                                onCheck: function (event, treeId, treeNode) {

                                    tree1 = $.fn.zTree.getZTreeObj(treeId),

                                    usernames = [],
                                    userids = [],
                                    nodes1 = tree1.getCheckedNodes(true)
                                    nodes1.forEach(function (n, i) {
                                        usernames.push(n.Name)
                                        userids.push(n.Id)
                                    })
                                    mvvm.entity.$model.UserIds = userids.join(',').toString();
                                    mvvm.entity.UserIdName = usernames.join('，').toString()
                                }
                            },
                            async: {
                                url: function (treeId, treeNode) {
                                    return "/Settings/GetGroupPostUser/104000000"
                                },
                                dataFilter: notMemberFilter
                            }
                        }
                    }
                });

                getDataList();
                function getDataList() {
                    $.get('/Report/ComplainState', ServeMode, function (result) {
                        mvvm.dataList = result.data.list;
                        mvvm.total = result.data.total;
                        var type = $('input[name="radioChart"]:checked').val();
                        switch (type) {
                            case "0":
                                createColumnChart(result.data.list_chart, 'chartId', '850', '300')
                                break;
                            case "1":
                                createPieChart(result.data.list_chart, 'chartId', '850', '300')
                                break;
                        }
                    })
                }

                mvvm.entity = ServeMode;
                CBCRM.fillContent(tmpl, lang, contentId, module, mvvm);
                CBCRM.onLoadModuleBefore = function () {
                    avalon.vmodels.Index = null
                    avalon.vmodels.setGroup.destroy()
                    avalon.vmodels.setUser.destroy()
                }
            },
            ///投诉紧急程度分析 
            ComplainUrgent: function (tmpl, lang, contentId, module) {
                var CBCRM = avalon.vmodels.CBCRM
                var mvvm = avalon.define('ComplainUrgent', function (vm) {
                    vm.dataList = [];//数据列表
                    vm.category = [];//条件
                    vm.entity = {};//查询条件
                    vm.show = 0;//显示值
                    vm.hide = 0;//显示值
                    vm.total = 0;//总值
                    vm.search = function () {
                        $.get('/Report/ComplainUrgent', mvvm.entity.$model, function (result) {
                            mvvm.dataList = result.data.list;
                            mvvm.total = result.data.total;
                            var type = $('input[name="radioChart"]:checked').val();
                            switch (type) {
                                case "0":
                                    createColumnChart(result.data.list_chart, 'chartId', '850', '300')
                                    break;
                                case "1":
                                    createPieChart(result.data.list_chart, 'chartId', '850', '300')
                                    break;
                            }
                        })
                    }
                    vm.radioChart = function (type) {
                        $.get('/Report/ComplainUrgent', mvvm.entity.$model, function (result) {
                            mvvm.dataList = result.data.list;
                            mvvm.total = result.data.total;
                            switch (type) {
                                case 0:
                                    createColumnChart(result.data.list_chart, 'chartId', '850', '300')
                                    break;
                                case 1:
                                    createPieChart(result.data.list_chart, 'chartId', '850', '300')
                                    break;
                            }
                        })
                    }


                    vm.dateOpts = {
                        format: '%Y-%m-%d',
                        onSelect: function (date, formatDate, format) {
                            mvvm.StartDay = formatDate;
                            mvvm.StartDate = formatDate;
                            mvvm.EndDate = formatDate;
                        }
                    }

                    vm.MonthOpts = {
                        format: '%Y-%m',
                        onSelect: function (date, formatDate, format) {
                        }
                    }
                    vm.YearOpts = {
                        format: '%Y',
                        onSelect: function (date, formatDate, format) {
                        }
                    }


                    //查询日期范围
                    vm.rdSelect = function (type) {
                        mvvm.show = type;
                        switch (type) {
                            case 0:
                                mvvm.entity.searchMonth = '';
                                mvvm.entity.searchYear = '';
                                mvvm.entity.starTime = '';
                                mvvm.entity.endTime = '';
                                break;
                            case 1:
                                mvvm.entity.searchDay = '';
                                mvvm.entity.searchYear = '';
                                mvvm.entity.starTime = '';
                                mvvm.entity.endTime = '';
                                break;
                            case 2:
                                mvvm.entity.searchMonth = '';
                                mvvm.entity.searchDay = '';
                                mvvm.entity.starTime = '';
                                mvvm.entity.endTime = '';
                                break;
                            case 3:
                                mvvm.entity.searchDay = '';
                                mvvm.entity.searchMonth = '';
                                mvvm.entity.searchYear = '';
                                break;
                        }
                    }
                    //查询人员范围
                    vm.selectDeaprt = function (type) {
                        mvvm.hide = type;
                        switch (type) {
                            case 0:
                                mvvm.entity.$model.DepartIds = '';
                                mvvm.entity.$model.UserIds = '';
                                mvvm.entity.DepartIdName = '';
                                mvvm.entity.UserIdName = '';
                                break;
                            case 1:
                                mvvm.entity.$model.UserIds = '';
                                mvvm.entity.UserIdName = '';
                                break;
                            case 2:
                                mvvm.entity.$model.DepartIds = '';
                                mvvm.entity.DepartIdName = '';
                                break;
                        }
                    }
                    vm.clear = function () {
                        mvvm.entity = ServeMode;
                    }

                    //选择部门
                    vm.postGroupTreeOpts = {
                        treeopts: {
                            check: {
                                enable: true,
                                chkboxType: { "Y": "s", "N": "s" },
                            },
                            async: {
                                enable: true,
                                url: '/Settings/GetGroupPostUser/104000000/'
                            },
                            callback: {
                                onCheck: function (event, treeId, treeNode) {
                                    tree = $.fn.zTree.getZTreeObj(treeId),
                                    names = [],
                                    ids = [],
                                    nodes = tree.getCheckedNodes(true)
                                    nodes.forEach(function (n, i) {
                                        names.push(n.Name)
                                        ids.push(n.Id)
                                    })
                                    mvvm.entity.$model.DepartIds = ids.join(',').toString();
                                    mvvm.entity.DepartIdName = names.join('，').toString()
                                }
                            }
                        }
                    }

                    vm.UserGroupTreeOpts = {
                        treeopts: {
                            check: {
                                enable: true,
                                chkboxType: { "Y": "s", "N": "s" },
                            },

                            callback: {
                                onCheck: function (event, treeId, treeNode) {

                                    tree1 = $.fn.zTree.getZTreeObj(treeId),

                                    usernames = [],
                                    userids = [],
                                    nodes1 = tree1.getCheckedNodes(true)
                                    nodes1.forEach(function (n, i) {
                                        usernames.push(n.Name)
                                        userids.push(n.Id)
                                    })
                                    mvvm.entity.$model.UserIds = userids.join(',').toString();
                                    mvvm.entity.UserIdName = usernames.join('，').toString()
                                }
                            },
                            async: {
                                url: function (treeId, treeNode) {
                                    return "/Settings/GetGroupPostUser/104000000"
                                },
                                dataFilter: notMemberFilter
                            }
                        }
                    }
                });

                getDataList();
                function getDataList() {
                    $.get('/Report/ComplainUrgent', ServeMode, function (result) {
                        mvvm.dataList = result.data.list;
                        mvvm.total = result.data.total;
                        var type = $('input[name="radioChart"]:checked').val();
                        switch (type) {
                            case "0":
                                createColumnChart(result.data.list_chart, 'chartId', '850', '300')
                                break;
                            case "1":
                                createPieChart(result.data.list_chart, 'chartId', '850', '300')
                                break;
                        }
                    })
                }

                mvvm.entity = ServeMode;
                CBCRM.fillContent(tmpl, lang, contentId, module, mvvm);
                CBCRM.onLoadModuleBefore = function () {
                    avalon.vmodels.Index = null
                    avalon.vmodels.setGroup.destroy()
                    avalon.vmodels.setUser.destroy()
                }
            },
            ///客户投诉次数top10分析 
            ComplainTop: function (tmpl, lang, contentId, module) {
                var CBCRM = avalon.vmodels.CBCRM
                var mvvm = avalon.define('ComplainTop', function (vm) {
                    vm.dataList = [];//数据列表
                    vm.category = [];//条件
                    vm.entity = {};//查询条件
                    vm.show = 0;//显示值
                    vm.hide = 0;//显示值
                    vm.total = 0;//总值
                    vm.search = function () {
                        $.get('/Report/ComplainTop', mvvm.entity.$model, function (result) {
                            mvvm.dataList = result.data.list;
                            mvvm.total = result.data.total;
                            var type = $('input[name="radioChart"]:checked').val();
                            switch (type) {
                                case "0":
                                    createColumnChart(result.data.list_chart, 'chartId', '850', '300')
                                    break;
                                case "1":
                                    createPieChart(result.data.list_chart, 'chartId', '850', '300')
                                    break;
                            }
                        })
                    }
                    vm.radioChart = function (type) {
                        $.get('/Report/ComplainTop', mvvm.entity.$model, function (result) {
                            mvvm.dataList = result.data.list;
                            mvvm.total = result.data.total;
                            switch (type) {
                                case 0:
                                    createColumnChart(result.data.list_chart, 'chartId', '850', '300')
                                    break;
                                case 1:
                                    createPieChart(result.data.list_chart, 'chartId', '850', '300')
                                    break;
                            }
                        })
                    }


                    vm.dateOpts = {
                        format: '%Y-%m-%d',
                        onSelect: function (date, formatDate, format) {
                            mvvm.StartDay = formatDate;
                            mvvm.StartDate = formatDate;
                            mvvm.EndDate = formatDate;
                        }
                    }

                    vm.MonthOpts = {
                        format: '%Y-%m',
                        onSelect: function (date, formatDate, format) {
                        }
                    }
                    vm.YearOpts = {
                        format: '%Y',
                        onSelect: function (date, formatDate, format) {
                        }
                    }


                    //查询日期范围
                    vm.rdSelect = function (type) {
                        mvvm.show = type;
                        switch (type) {
                            case 0:
                                mvvm.entity.searchMonth = '';
                                mvvm.entity.searchYear = '';
                                mvvm.entity.starTime = '';
                                mvvm.entity.endTime = '';
                                break;
                            case 1:
                                mvvm.entity.searchDay = '';
                                mvvm.entity.searchYear = '';
                                mvvm.entity.starTime = '';
                                mvvm.entity.endTime = '';
                                break;
                            case 2:
                                mvvm.entity.searchMonth = '';
                                mvvm.entity.searchDay = '';
                                mvvm.entity.starTime = '';
                                mvvm.entity.endTime = '';
                                break;
                            case 3:
                                mvvm.entity.searchDay = '';
                                mvvm.entity.searchMonth = '';
                                mvvm.entity.searchYear = '';
                                break;
                        }
                    }
                    //查询人员范围
                    vm.selectDeaprt = function (type) {
                        mvvm.hide = type;
                        switch (type) {
                            case 0:
                                mvvm.entity.$model.DepartIds = '';
                                mvvm.entity.$model.UserIds = '';
                                mvvm.entity.DepartIdName = '';
                                mvvm.entity.UserIdName = '';
                                break;
                            case 1:
                                mvvm.entity.$model.UserIds = '';
                                mvvm.entity.UserIdName = '';
                                break;
                            case 2:
                                mvvm.entity.$model.DepartIds = '';
                                mvvm.entity.DepartIdName = '';
                                break;
                        }
                    }
                    vm.clear = function () {
                        mvvm.entity = ServeMode;
                    }

                    //选择部门
                    vm.postGroupTreeOpts = {
                        treeopts: {
                            check: {
                                enable: true,
                                chkboxType: { "Y": "s", "N": "s" },
                            },
                            async: {
                                enable: true,
                                url: '/Settings/GetGroupPostUser/104000000/'
                            },
                            callback: {
                                onCheck: function (event, treeId, treeNode) {
                                    tree = $.fn.zTree.getZTreeObj(treeId),
                                    names = [],
                                    ids = [],
                                    nodes = tree.getCheckedNodes(true)
                                    nodes.forEach(function (n, i) {
                                        names.push(n.Name)
                                        ids.push(n.Id)
                                    })
                                    mvvm.entity.$model.DepartIds = ids.join(',').toString();
                                    mvvm.entity.DepartIdName = names.join('，').toString()
                                }
                            }
                        }
                    }

                    vm.UserGroupTreeOpts = {
                        treeopts: {
                            check: {
                                enable: true,
                                chkboxType: { "Y": "s", "N": "s" },
                            },

                            callback: {
                                onCheck: function (event, treeId, treeNode) {

                                    tree1 = $.fn.zTree.getZTreeObj(treeId),

                                    usernames = [],
                                    userids = [],
                                    nodes1 = tree1.getCheckedNodes(true)
                                    nodes1.forEach(function (n, i) {
                                        usernames.push(n.Name)
                                        userids.push(n.Id)
                                    })
                                    mvvm.entity.$model.UserIds = userids.join(',').toString();
                                    mvvm.entity.UserIdName = usernames.join('，').toString()
                                }
                            },
                            async: {
                                url: function (treeId, treeNode) {
                                    return "/Settings/GetGroupPostUser/104000000"
                                },
                                dataFilter: notMemberFilter
                            }
                        }
                    }
                });

                getDataList();
                function getDataList() {
                    $.get('/Report/ComplainTop', ServeMode, function (result) {
                        mvvm.dataList = result.data.list;
                        mvvm.total = result.data.total;
                        var type = $('input[name="radioChart"]:checked').val();
                        switch (type) {
                            case "0":
                                createColumnChart(result.data.list_chart, 'chartId', '850', '300')
                                break;
                            case "1":
                                createPieChart(result.data.list_chart, 'chartId', '850', '300')
                                break;
                        }
                    })
                }
                
                mvvm.entity = ServeMode;
                CBCRM.fillContent(tmpl, lang, contentId, module, mvvm);
                CBCRM.onLoadModuleBefore = function () {
                    avalon.vmodels.Index = null
                    avalon.vmodels.setGroup.destroy()
                    avalon.vmodels.setUser.destroy()
                }
            },


            ///回访处理状态分析
            ReplyState: function (tmpl, lang, contentId, module) {
                var CBCRM = avalon.vmodels.CBCRM
                var mvvm = avalon.define('ReplyState', function (vm) {
                    vm.dataList = [];//数据列表
                    vm.category = [];//条件
                    vm.entity = {};//查询条件
                    vm.show = 0;//显示值
                    vm.hide = 0;//显示值
                    vm.total = 0;//总值
                    vm.search = function () {
                        $.get('/Report/ReplyState', mvvm.entity.$model, function (result) {
                            mvvm.dataList = result.data.list;
                            mvvm.total = result.data.total;
                            var type = $('input[name="radioChart"]:checked').val();
                            switch (type) {
                                case "0":
                                    createColumnChart(result.data.list_chart, 'chartId', '850', '300')
                                    break;
                                case "1":
                                    createPieChart(result.data.list_chart, 'chartId', '850', '300')
                                    break;
                            }
                        })
                    }
                    vm.radioChart = function (type) {
                        $.get('/Report/ReplyState', mvvm.entity.$model, function (result) {
                            mvvm.dataList = result.data.list;
                            mvvm.total = result.data.total;
                            switch (type) {
                                case 0:
                                    createColumnChart(result.data.list_chart, 'chartId', '700', '300')
                                    break;
                                case 1:
                                    createPieChart(result.data.list_chart, 'chartId', '700', '300')
                                    break;
                            }
                        })
                    }


                    vm.dateOpts = {
                        format: '%Y-%m-%d',
                        onSelect: function (date, formatDate, format) {
                            mvvm.StartDay = formatDate;
                            mvvm.StartDate = formatDate;
                            mvvm.EndDate = formatDate;
                        }
                    }

                    vm.MonthOpts = {
                        format: '%Y-%m',
                        onSelect: function (date, formatDate, format) {
                        }
                    }
                    vm.YearOpts = {
                        format: '%Y',
                        onSelect: function (date, formatDate, format) {
                        }
                    }


                    //查询日期范围
                    vm.rdSelect = function (type) {
                        mvvm.show = type;
                        switch (type) {
                            case 0:
                                mvvm.entity.searchMonth = '';
                                mvvm.entity.searchYear = '';
                                mvvm.entity.starTime = '';
                                mvvm.entity.endTime = '';
                                break;
                            case 1:
                                mvvm.entity.searchDay = '';
                                mvvm.entity.searchYear = '';
                                mvvm.entity.starTime = '';
                                mvvm.entity.endTime = '';
                                break;
                            case 2:
                                mvvm.entity.searchMonth = '';
                                mvvm.entity.searchDay = '';
                                mvvm.entity.starTime = '';
                                mvvm.entity.endTime = '';
                                break;
                            case 3:
                                mvvm.entity.searchDay = '';
                                mvvm.entity.searchMonth = '';
                                mvvm.entity.searchYear = '';
                                break;
                        }
                    }
                    //查询人员范围
                    vm.selectDeaprt = function (type) {
                        mvvm.hide = type;
                        switch (type) {
                            case 0:
                                mvvm.entity.$model.DepartIds = '';
                                mvvm.entity.$model.UserIds = '';
                                mvvm.entity.DepartIdName = '';
                                mvvm.entity.UserIdName = '';
                                break;
                            case 1:
                                mvvm.entity.$model.UserIds = '';
                                mvvm.entity.UserIdName = '';
                                break;
                            case 2:
                                mvvm.entity.$model.DepartIds = '';
                                mvvm.entity.DepartIdName = '';
                                break;
                        }
                    }
                    vm.clear = function () {
                        mvvm.entity = ServeMode;
                    }

                    //选择部门
                    vm.postGroupTreeOpts = {
                        treeopts: {
                            check: {
                                enable: true,
                                chkboxType: { "Y": "s", "N": "s" },
                            },
                            async: {
                                enable: true,
                                url: '/Settings/GetGroupPostUser/104000000/'
                            },
                            callback: {
                                onCheck: function (event, treeId, treeNode) {
                                    tree = $.fn.zTree.getZTreeObj(treeId),
                                    names = [],
                                    ids = [],
                                    nodes = tree.getCheckedNodes(true)
                                    nodes.forEach(function (n, i) {
                                        names.push(n.Name)
                                        ids.push(n.Id)
                                    })
                                    mvvm.entity.$model.DepartIds = ids.join(',').toString();
                                    mvvm.entity.DepartIdName = names.join('，').toString()
                                }
                            }
                        }
                    }

                    vm.UserGroupTreeOpts = {
                        treeopts: {
                            check: {
                                enable: true,
                                chkboxType: { "Y": "s", "N": "s" },
                            },

                            callback: {
                                onCheck: function (event, treeId, treeNode) {

                                    tree1 = $.fn.zTree.getZTreeObj(treeId),

                                    usernames = [],
                                    userids = [],
                                    nodes1 = tree1.getCheckedNodes(true)
                                    nodes1.forEach(function (n, i) {
                                        usernames.push(n.Name)
                                        userids.push(n.Id)
                                    })
                                    mvvm.entity.$model.UserIds = userids.join(',').toString();
                                    mvvm.entity.UserIdName = usernames.join('，').toString()
                                }
                            },
                            async: {
                                url: function (treeId, treeNode) {
                                    return "/Settings/GetGroupPostUser/104000000"
                                },
                                dataFilter: notMemberFilter
                            }
                        }
                    }
                });

                getDataList();
                function getDataList() {
                    $.get('/Report/ReplyState', ServeMode, function (result) {
                        mvvm.dataList = result.data.list;
                        mvvm.total = result.data.total;
                        var type = $('input[name="radioChart"]:checked').val();
                        switch (type) {
                            case "0":
                                createColumnChart(result.data.list_chart, 'chartId', '850', '300')
                                break;
                            case "1":
                                createPieChart(result.data.list_chart, 'chartId', '850', '300')
                                break;
                        }
                    })
                }

                mvvm.entity = ServeMode;
                CBCRM.fillContent(tmpl, lang, contentId, module, mvvm);
                CBCRM.onLoadModuleBefore = function () {
                    avalon.vmodels.Index = null
                    avalon.vmodels.setGroup.destroy()
                    avalon.vmodels.setUser.destroy()
                }
            },


            ///回访方式分析
            ReplyMode: function (tmpl, lang, contentId, module) {
                var CBCRM = avalon.vmodels.CBCRM
                var mvvm = avalon.define('ReplyMode', function (vm) {
                    vm.dataList = [];//数据列表
                    vm.category = [];//条件
                    vm.entity = {};//查询条件
                    vm.show = 0;//显示值
                    vm.hide = 0;//显示值
                    vm.total = 0;//总值
                    vm.search = function () {
                        $.get('/Report/ReplyMode', mvvm.entity.$model, function (result) {
                            mvvm.dataList = result.data.list;
                            mvvm.total = result.data.total;
                            var type = $('input[name="radioChart"]:checked').val();
                            switch (type) {
                                case "0":
                                    createColumnChart(result.data.list_chart, 'chartId', '850', '300')
                                    break;
                                case "1":
                                    createPieChart(result.data.list_chart, 'chartId', '850', '300')
                                    break;
                            }
                        })
                    }
                    vm.radioChart = function (type) {
                        $.get('/Report/ReplyMode', mvvm.entity.$model, function (result) {
                            mvvm.dataList = result.data.list;
                            mvvm.total = result.data.total;
                            switch (type) {
                                case 0:
                                    createColumnChart(result.data.list_chart, 'chartId', '850', '300')
                                    break;
                                case 1:
                                    createPieChart(result.data.list_chart, 'chartId', '850', '300')
                                    break;
                            }
                        })
                    }


                    vm.dateOpts = {
                        format: '%Y-%m-%d',
                        onSelect: function (date, formatDate, format) {
                            mvvm.StartDay = formatDate;
                            mvvm.StartDate = formatDate;
                            mvvm.EndDate = formatDate;
                        }
                    }

                    vm.MonthOpts = {
                        format: '%Y-%m',
                        onSelect: function (date, formatDate, format) {
                        }
                    }
                    vm.YearOpts = {
                        format: '%Y',
                        onSelect: function (date, formatDate, format) {
                        }
                    }


                    //查询日期范围
                    vm.rdSelect = function (type) {
                        mvvm.show = type;
                        switch (type) {
                            case 0:
                                mvvm.entity.searchMonth = '';
                                mvvm.entity.searchYear = '';
                                mvvm.entity.starTime = '';
                                mvvm.entity.endTime = '';
                                break;
                            case 1:
                                mvvm.entity.searchDay = '';
                                mvvm.entity.searchYear = '';
                                mvvm.entity.starTime = '';
                                mvvm.entity.endTime = '';
                                break;
                            case 2:
                                mvvm.entity.searchMonth = '';
                                mvvm.entity.searchDay = '';
                                mvvm.entity.starTime = '';
                                mvvm.entity.endTime = '';
                                break;
                            case 3:
                                mvvm.entity.searchDay = '';
                                mvvm.entity.searchMonth = '';
                                mvvm.entity.searchYear = '';
                                break;
                        }
                    }
                    //查询人员范围
                    vm.selectDeaprt = function (type) {
                        mvvm.hide = type;
                        switch (type) {
                            case 0:
                                mvvm.entity.$model.DepartIds = '';
                                mvvm.entity.$model.UserIds = '';
                                mvvm.entity.DepartIdName = '';
                                mvvm.entity.UserIdName = '';
                                break;
                            case 1:
                                mvvm.entity.$model.UserIds = '';
                                mvvm.entity.UserIdName = '';
                                break;
                            case 2:
                                mvvm.entity.$model.DepartIds = '';
                                mvvm.entity.DepartIdName = '';
                                break;
                        }
                    }
                    vm.clear = function () {
                        mvvm.entity = ServeMode;
                    }

                    //选择部门
                    vm.postGroupTreeOpts = {
                        treeopts: {
                            check: {
                                enable: true,
                                chkboxType: { "Y": "s", "N": "s" },
                            },
                            async: {
                                enable: true,
                                url: '/Settings/GetGroupPostUser/104000000/'
                            },
                            callback: {
                                onCheck: function (event, treeId, treeNode) {
                                    tree = $.fn.zTree.getZTreeObj(treeId),
                                    names = [],
                                    ids = [],
                                    nodes = tree.getCheckedNodes(true)
                                    nodes.forEach(function (n, i) {
                                        names.push(n.Name)
                                        ids.push(n.Id)
                                    })
                                    mvvm.entity.$model.DepartIds = ids.join(',').toString();
                                    mvvm.entity.DepartIdName = names.join('，').toString()
                                }
                            }
                        }
                    }

                    vm.UserGroupTreeOpts = {
                        treeopts: {
                            check: {
                                enable: true,
                                chkboxType: { "Y": "s", "N": "s" },
                            },

                            callback: {
                                onCheck: function (event, treeId, treeNode) {

                                    tree1 = $.fn.zTree.getZTreeObj(treeId),

                                    usernames = [],
                                    userids = [],
                                    nodes1 = tree1.getCheckedNodes(true)
                                    nodes1.forEach(function (n, i) {
                                        usernames.push(n.Name)
                                        userids.push(n.Id)
                                    })
                                    mvvm.entity.$model.UserIds = userids.join(',').toString();
                                    mvvm.entity.UserIdName = usernames.join('，').toString()
                                }
                            },
                            async: {
                                url: function (treeId, treeNode) {
                                    return "/Settings/GetGroupPostUser/104000000"
                                },
                                dataFilter: notMemberFilter
                            }
                        }
                    }
                });

                getDataList();
                function getDataList() {
                    $.get('/Report/ReplyMode', ServeMode, function (result) {
                        mvvm.dataList = result.data.list;
                        mvvm.total = result.data.total;
                        var type = $('input[name="radioChart"]:checked').val();
                        switch (type) {
                            case "0":
                                createColumnChart(result.data.list_chart, 'chartId', '850', '300')
                                break;
                            case "1":
                                createPieChart(result.data.list_chart, 'chartId', '850', '300')
                                break;
                        }
                    })
                }

                mvvm.entity = ServeMode;
                CBCRM.fillContent(tmpl, lang, contentId, module, mvvm);
                CBCRM.onLoadModuleBefore = function () {
                    avalon.vmodels.Index = null
                    avalon.vmodels.setGroup.destroy()
                    avalon.vmodels.setUser.destroy()
                }
            },

            ///客户回访次数top10分析
            ReplyTop: function (tmpl, lang, contentId, module) {
                var CBCRM = avalon.vmodels.CBCRM
                var mvvm = avalon.define('ReplyTop', function (vm) {
                    vm.dataList = [];//数据列表
                    vm.category = [];//条件
                    vm.entity = {};//查询条件
                    vm.show = 0;//显示值
                    vm.hide = 0;//显示值
                    vm.total = 0;//总值
                    vm.search = function () {
                        $.get('/Report/ReplyTop', mvvm.entity.$model, function (result) {
                            mvvm.dataList = result.data.list;
                            mvvm.total = result.data.total;
                            var type = $('input[name="radioChart"]:checked').val();
                            switch (type) {
                                case "0":
                                    createColumnChart(result.data.list_chart, 'chartId', '850', '300')
                                    break;
                                case "1":
                                    createPieChart(result.data.list_chart, 'chartId', '850', '300')
                                    break;
                            }
                        })
                    }
                    vm.radioChart = function (type) {
                        $.get('/Report/ReplyTop', mvvm.entity.$model, function (result) {
                            mvvm.dataList = result.data.list;
                            mvvm.total = result.data.total;
                            switch (type) {
                                case 0:
                                    createColumnChart(result.data.list_chart, 'chartId', '850', '300')
                                    break;
                                case 1:
                                    createPieChart(result.data.list_chart, 'chartId', '850', '300')
                                    break;
                            }
                        })
                    }
                    vm.dateOpts = {
                        format: '%Y-%m-%d',
                        onSelect: function (date, formatDate, format) {
                            mvvm.StartDay = formatDate;
                            mvvm.StartDate = formatDate;
                            mvvm.EndDate = formatDate;
                        }
                    }

                    vm.MonthOpts = {
                        format: '%Y-%m',
                        onSelect: function (date, formatDate, format) {
                        }
                    }
                    vm.YearOpts = {
                        format: '%Y',
                        onSelect: function (date, formatDate, format) {
                        }
                    }


                    //查询日期范围
                    vm.rdSelect = function (type) {
                        mvvm.show = type;
                        switch (type) {
                            case 0:
                                mvvm.entity.searchMonth = '';
                                mvvm.entity.searchYear = '';
                                mvvm.entity.starTime = '';
                                mvvm.entity.endTime = '';
                                break;
                            case 1:
                                mvvm.entity.searchDay = '';
                                mvvm.entity.searchYear = '';
                                mvvm.entity.starTime = '';
                                mvvm.entity.endTime = '';
                                break;
                            case 2:
                                mvvm.entity.searchMonth = '';
                                mvvm.entity.searchDay = '';
                                mvvm.entity.starTime = '';
                                mvvm.entity.endTime = '';
                                break;
                            case 3:
                                mvvm.entity.searchDay = '';
                                mvvm.entity.searchMonth = '';
                                mvvm.entity.searchYear = '';
                                break;
                        }
                    }
                    //查询人员范围
                    vm.selectDeaprt = function (type) {
                        mvvm.hide = type;
                        switch (type) {
                            case 0:
                                mvvm.entity.$model.DepartIds = '';
                                mvvm.entity.$model.UserIds = '';
                                mvvm.entity.DepartIdName = '';
                                mvvm.entity.UserIdName = '';
                                break;
                            case 1:
                                mvvm.entity.$model.UserIds = '';
                                mvvm.entity.UserIdName = '';
                                break;
                            case 2:
                                mvvm.entity.$model.DepartIds = '';
                                mvvm.entity.DepartIdName = '';
                                break;
                        }
                    }
                    vm.clear = function () {
                        mvvm.entity = ServeMode;
                    }

                    //选择部门
                    vm.postGroupTreeOpts = {
                        treeopts: {
                            check: {
                                enable: true,
                                chkboxType: { "Y": "s", "N": "s" },
                            },
                            async: {
                                enable: true,
                                url: '/Settings/GetGroupPostUser/104000000/'
                            },
                            callback: {
                                onCheck: function (event, treeId, treeNode) {
                                    tree = $.fn.zTree.getZTreeObj(treeId),
                                    names = [],
                                    ids = [],
                                    nodes = tree.getCheckedNodes(true)
                                    nodes.forEach(function (n, i) {
                                        names.push(n.Name)
                                        ids.push(n.Id)
                                    })
                                    mvvm.entity.$model.DepartIds = ids.join(',').toString();
                                    mvvm.entity.DepartIdName = names.join('，').toString()
                                }
                            }
                        }
                    }

                    vm.UserGroupTreeOpts = {
                        treeopts: {
                            check: {
                                enable: true,
                                chkboxType: { "Y": "s", "N": "s" },
                            },

                            callback: {
                                onCheck: function (event, treeId, treeNode) {

                                    tree1 = $.fn.zTree.getZTreeObj(treeId),

                                    usernames = [],
                                    userids = [],
                                    nodes1 = tree1.getCheckedNodes(true)
                                    nodes1.forEach(function (n, i) {
                                        usernames.push(n.Name)
                                        userids.push(n.Id)
                                    })
                                    mvvm.entity.$model.UserIds = userids.join(',').toString();
                                    mvvm.entity.UserIdName = usernames.join('，').toString()
                                }
                            },
                            async: {
                                url: function (treeId, treeNode) {
                                    return "/Settings/GetGroupPostUser/104000000"
                                },
                                dataFilter: notMemberFilter
                            }
                        }
                    }
                });

                getDataList();
                function getDataList() {
                    $.get('/Report/ReplyTop', ServeMode, function (result) {
                        mvvm.dataList = result.data.list;
                        mvvm.total = result.data.total;
                        var type = $('input[name="radioChart"]:checked').val();
                        switch (type) {
                            case "0":
                                createColumnChart(result.data.list_chart, 'chartId', '850', '300')
                                break;
                            case "1":
                                createPieChart(result.data.list_chart, 'chartId', '850', '300')
                                break;
                        }
                    })
                }

                mvvm.entity = ServeMode;
                CBCRM.fillContent(tmpl, lang, contentId, module, mvvm);
                CBCRM.onLoadModuleBefore = function () {
                    avalon.vmodels.Index = null
                    avalon.vmodels.setGroup.destroy()
                    avalon.vmodels.setUser.destroy()
                }
            },

            ///员工回访量分析
            ReplyEmployees: function (tmpl, lang, contentId, module) {
                var CBCRM = avalon.vmodels.CBCRM
                var mvvm = avalon.define('ReplyEmployees', function (vm) {
                    vm.dataList = [];//数据列表
                    vm.category = [];//条件
                    vm.entity = {};//查询条件
                    vm.show = 0;//显示值
                    vm.hide = 0;//显示值
                    vm.total = 0;//总值
                    vm.search = function () {
                        $.get('/Report/ReplyEmployees', mvvm.entity.$model, function (result) {
                            mvvm.dataList = result.data.list;
                            mvvm.total = result.data.total;
                            var type = $('input[name="radioChart"]:checked').val();
                            switch (type) {
                                case "0":
                                    createColumnChart(result.data.list_chart, 'chartId', '850', '300')
                                    break;
                                case "1":
                                    createPieChart(result.data.list_chart, 'chartId', '850', '300')
                                    break;
                            }
                        })
                    }
                    vm.radioChart = function (type) {
                        $.get('/Report/ReplyEmployees', mvvm.entity.$model, function (result) {
                            mvvm.dataList = result.data.list;
                            mvvm.total = result.data.total;
                            switch (type) {
                                case 0:
                                    createColumnChart(result.data.list_chart, 'chartId', '850', '300')
                                    break;
                                case 1:
                                    createPieChart(result.data.list_chart, 'chartId', '850', '300')
                                    break;
                            }
                        })
                    }
                    vm.dateOpts = {
                        format: '%Y-%m-%d',
                        onSelect: function (date, formatDate, format) {
                            mvvm.StartDay = formatDate;
                            mvvm.StartDate = formatDate;
                            mvvm.EndDate = formatDate;
                        }
                    }

                    vm.MonthOpts = {
                        format: '%Y-%m',
                        onSelect: function (date, formatDate, format) {
                        }
                    }
                    vm.YearOpts = {
                        format: '%Y',
                        onSelect: function (date, formatDate, format) {
                        }
                    }


                    //查询日期范围
                    vm.rdSelect = function (type) {
                        mvvm.show = type;
                        switch (type) {
                            case 0:
                                mvvm.entity.searchMonth = '';
                                mvvm.entity.searchYear = '';
                                mvvm.entity.starTime = '';
                                mvvm.entity.endTime = '';
                                break;
                            case 1:
                                mvvm.entity.searchDay = '';
                                mvvm.entity.searchYear = '';
                                mvvm.entity.starTime = '';
                                mvvm.entity.endTime = '';
                                break;
                            case 2:
                                mvvm.entity.searchMonth = '';
                                mvvm.entity.searchDay = '';
                                mvvm.entity.starTime = '';
                                mvvm.entity.endTime = '';
                                break;
                            case 3:
                                mvvm.entity.searchDay = '';
                                mvvm.entity.searchMonth = '';
                                mvvm.entity.searchYear = '';
                                break;
                        }
                    }
                    //查询人员范围
                    vm.selectDeaprt = function (type) {
                        mvvm.hide = type;
                        switch (type) {
                            case 0:
                                mvvm.entity.$model.DepartIds = '';
                                mvvm.entity.$model.UserIds = '';
                                mvvm.entity.DepartIdName = '';
                                mvvm.entity.UserIdName = '';
                                break;
                            case 1:
                                mvvm.entity.$model.UserIds = '';
                                mvvm.entity.UserIdName = '';
                                break;
                            case 2:
                                mvvm.entity.$model.DepartIds = '';
                                mvvm.entity.DepartIdName = '';
                                break;
                        }
                    }
                    vm.clear = function () {
                        mvvm.entity = ServeMode;
                    }

                    //选择部门
                    vm.postGroupTreeOpts = {
                        treeopts: {
                            check: {
                                enable: true,
                                chkboxType: { "Y": "s", "N": "s" },
                            },
                            async: {
                                enable: true,
                                url: '/Settings/GetGroupPostUser/104000000/'
                            },
                            callback: {
                                onCheck: function (event, treeId, treeNode) {
                                    tree = $.fn.zTree.getZTreeObj(treeId),
                                    names = [],
                                    ids = [],
                                    nodes = tree.getCheckedNodes(true)
                                    nodes.forEach(function (n, i) {
                                        names.push(n.Name)
                                        ids.push(n.Id)
                                    })
                                    mvvm.entity.$model.DepartIds = ids.join(',').toString();
                                    mvvm.entity.DepartIdName = names.join('，').toString()
                                }
                            }
                        }
                    }

                    vm.UserGroupTreeOpts = {
                        treeopts: {
                            check: {
                                enable: true,
                                chkboxType: { "Y": "s", "N": "s" },
                            },

                            callback: {
                                onCheck: function (event, treeId, treeNode) {

                                    tree1 = $.fn.zTree.getZTreeObj(treeId),

                                    usernames = [],
                                    userids = [],
                                    nodes1 = tree1.getCheckedNodes(true)
                                    nodes1.forEach(function (n, i) {
                                        usernames.push(n.Name)
                                        userids.push(n.Id)
                                    })
                                    mvvm.entity.$model.UserIds = userids.join(',').toString();
                                    mvvm.entity.UserIdName = usernames.join('，').toString()
                                }
                            },
                            async: {
                                url: function (treeId, treeNode) {
                                    return "/Settings/GetGroupPostUser/104000000"
                                },
                                dataFilter: notMemberFilter
                            }
                        }
                    }
                });

                getDataList();
                function getDataList() {
                    $.get('/Report/ReplyEmployees', ServeMode, function (result) {
                        mvvm.dataList = result.data.list;
                        mvvm.total = result.data.total;
                        var type = $('input[name="radioChart"]:checked').val();
                        switch (type) {
                            case "0":
                                createColumnChart(result.data.list_chart, 'chartId', '850', '300')
                                break;
                            case "1":
                                createPieChart(result.data.list_chart, 'chartId', '850', '300')
                                break;
                        }
                    })
                }

                mvvm.entity = ServeMode;
                CBCRM.fillContent(tmpl, lang, contentId, module, mvvm);
                CBCRM.onLoadModuleBefore = function () {
                    avalon.vmodels.Index = null
                    avalon.vmodels.setGroup.destroy()
                    avalon.vmodels.setUser.destroy()
                }
            },

            ///来电类型分析
            CallType: function (tmpl, lang, contentId, module) {
                var CBCRM = avalon.vmodels.CBCRM
                var mvvm = avalon.define('CallType', function (vm) {
                    vm.dataList = [];//数据列表
                    vm.category = [];//条件
                    vm.entity = {};//查询条件
                    vm.show = 0;//显示值
                    vm.hide = 0;//显示值
                    vm.total = 0;//总值
                    vm.search = function () {
                        $.get('/Report/CallType', mvvm.entity.$model, function (result) {
                            mvvm.dataList = result.data.list;
                            mvvm.total = result.data.total;
                            var type = $('input[name="radioChart"]:checked').val();
                            switch (type) {
                                case "0":
                                    createColumnChart(result.data.list_chart, 'chartId', '850', '300')
                                    break;
                                case "1":
                                    createPieChart(result.data.list_chart, 'chartId', '850', '300')
                                    break;
                            }
                        })
                    }
                    vm.radioChart = function (type) {
                        $.get('/Report/CallType', mvvm.entity.$model, function (result) {
                            mvvm.dataList = result.data.list;
                            mvvm.total = result.data.total;
                            switch (type) {
                                case 0:
                                    createColumnChart(result.data.list_chart, 'chartId', '850', '300')
                                    break;
                                case 1:
                                    createPieChart(result.data.list_chart, 'chartId', '850', '300')
                                    break;
                            }
                        })
                    }
                    vm.dateOpts = {
                        format: '%Y-%m-%d',
                        onSelect: function (date, formatDate, format) {
                            mvvm.StartDay = formatDate;
                            mvvm.StartDate = formatDate;
                            mvvm.EndDate = formatDate;
                        }
                    }

                    vm.MonthOpts = {
                        format: '%Y-%m',
                        onSelect: function (date, formatDate, format) {
                        }
                    }
                    vm.YearOpts = {
                        format: '%Y',
                        onSelect: function (date, formatDate, format) {
                        }
                    }


                    //查询日期范围
                    vm.rdSelect = function (type) {
                        mvvm.show = type;
                        switch (type) {
                            case 0:
                                mvvm.entity.searchMonth = '';
                                mvvm.entity.searchYear = '';
                                mvvm.entity.starTime = '';
                                mvvm.entity.endTime = '';
                                break;
                            case 1:
                                mvvm.entity.searchDay = '';
                                mvvm.entity.searchYear = '';
                                mvvm.entity.starTime = '';
                                mvvm.entity.endTime = '';
                                break;
                            case 2:
                                mvvm.entity.searchMonth = '';
                                mvvm.entity.searchDay = '';
                                mvvm.entity.starTime = '';
                                mvvm.entity.endTime = '';
                                break;
                            case 3:
                                mvvm.entity.searchDay = '';
                                mvvm.entity.searchMonth = '';
                                mvvm.entity.searchYear = '';
                                break;
                        }
                    }
                    //查询人员范围
                    vm.selectDeaprt = function (type) {
                        mvvm.hide = type;
                        switch (type) {
                            case 0:
                                mvvm.entity.$model.DepartIds = '';
                                mvvm.entity.$model.UserIds = '';
                                mvvm.entity.DepartIdName = '';
                                mvvm.entity.UserIdName = '';
                                break;
                            case 1:
                                mvvm.entity.$model.UserIds = '';
                                mvvm.entity.UserIdName = '';
                                break;
                            case 2:
                                mvvm.entity.$model.DepartIds = '';
                                mvvm.entity.DepartIdName = '';
                                break;
                        }
                    }
                    vm.clear = function () {
                        mvvm.entity = ServeMode;
                    }

                    //选择部门
                    vm.postGroupTreeOpts = {
                        treeopts: {
                            check: {
                                enable: true,
                                chkboxType: { "Y": "s", "N": "s" },
                            },
                            async: {
                                enable: true,
                                url: '/Settings/GetGroupPostUser/104000000/'
                            },
                            callback: {
                                onCheck: function (event, treeId, treeNode) {
                                    tree = $.fn.zTree.getZTreeObj(treeId),
                                    names = [],
                                    ids = [],
                                    nodes = tree.getCheckedNodes(true)
                                    nodes.forEach(function (n, i) {
                                        names.push(n.Name)
                                        ids.push(n.Id)
                                    })
                                    mvvm.entity.$model.DepartIds = ids.join(',').toString();
                                    mvvm.entity.DepartIdName = names.join('，').toString()
                                }
                            }
                        }
                    }

                    vm.UserGroupTreeOpts = {
                        treeopts: {
                            check: {
                                enable: true,
                                chkboxType: { "Y": "s", "N": "s" },
                            },

                            callback: {
                                onCheck: function (event, treeId, treeNode) {

                                    tree1 = $.fn.zTree.getZTreeObj(treeId),

                                    usernames = [],
                                    userids = [],
                                    nodes1 = tree1.getCheckedNodes(true)
                                    nodes1.forEach(function (n, i) {
                                        usernames.push(n.Name)
                                        userids.push(n.Id)
                                    })
                                    mvvm.entity.$model.UserIds = userids.join(',').toString();
                                    mvvm.entity.UserIdName = usernames.join('，').toString()
                                }
                            },
                            async: {
                                url: function (treeId, treeNode) {
                                    return "/Settings/GetGroupPostUser/104000000"
                                },
                                dataFilter: notMemberFilter
                            }
                        }
                    }
                });

                getDataList();
                function getDataList() {
                    $.get('/Report/CallType', ServeMode, function (result) {
                        mvvm.dataList = result.data.list;
                        mvvm.total = result.data.total;
                        var type = $('input[name="radioChart"]:checked').val();
                        switch (type) {
                            case "0":
                                createColumnChart(result.data.list_chart, 'chartId', '850', '300')
                                break;
                            case "1":
                                createPieChart(result.data.list_chart, 'chartId', '850', '300')
                                break;
                        }
                    })
                }

                mvvm.entity = ServeMode;
                CBCRM.fillContent(tmpl, lang, contentId, module, mvvm);
                CBCRM.onLoadModuleBefore = function () {
                    avalon.vmodels.Index = null
                    avalon.vmodels.setGroup.destroy()
                    avalon.vmodels.setUser.destroy()
                }
            },

            ///来电处理状态分析
            CallState: function (tmpl, lang, contentId, module) {
                var CBCRM = avalon.vmodels.CBCRM
                var mvvm = avalon.define('CallState', function (vm) {
                    vm.dataList = [];//数据列表
                    vm.category = [];//条件
                    vm.entity = {};//查询条件
                    vm.show = 0;//显示值
                    vm.hide = 0;//显示值
                    vm.total = 0;//总值
                    vm.search = function () {
                        $.get('/Report/CallState', mvvm.entity.$model, function (result) {
                            mvvm.dataList = result.data.list;
                            mvvm.total = result.data.total;
                            var type = $('input[name="radioChart"]:checked').val();
                            switch (type) {
                                case "0":
                                    createColumnChart(result.data.list_chart, 'chartId', '850', '300')
                                    break;
                                case "1":
                                    createPieChart(result.data.list_chart, 'chartId', '850', '300')
                                    break;
                            }
                        })
                    }
                    vm.radioChart = function (type) {
                        $.get('/Report/CallState', mvvm.entity.$model, function (result) {
                            mvvm.dataList = result.data.list;
                            mvvm.total = result.data.total;
                            switch (type) {
                                case 0:
                                    createColumnChart(result.data.list_chart, 'chartId', '850', '300')
                                    break;
                                case 1:
                                    createPieChart(result.data.list_chart, 'chartId', '850', '300')
                                    break;
                            }
                        })
                    }
                    vm.dateOpts = {
                        format: '%Y-%m-%d',
                        onSelect: function (date, formatDate, format) {
                            mvvm.StartDay = formatDate;
                            mvvm.StartDate = formatDate;
                            mvvm.EndDate = formatDate;
                        }
                    }

                    vm.MonthOpts = {
                        format: '%Y-%m',
                        onSelect: function (date, formatDate, format) {
                        }
                    }
                    vm.YearOpts = {
                        format: '%Y',
                        onSelect: function (date, formatDate, format) {
                        }
                    }


                    //查询日期范围
                    vm.rdSelect = function (type) {
                        mvvm.show = type;
                        switch (type) {
                            case 0:
                                mvvm.entity.searchMonth = '';
                                mvvm.entity.searchYear = '';
                                mvvm.entity.starTime = '';
                                mvvm.entity.endTime = '';
                                break;
                            case 1:
                                mvvm.entity.searchDay = '';
                                mvvm.entity.searchYear = '';
                                mvvm.entity.starTime = '';
                                mvvm.entity.endTime = '';
                                break;
                            case 2:
                                mvvm.entity.searchMonth = '';
                                mvvm.entity.searchDay = '';
                                mvvm.entity.starTime = '';
                                mvvm.entity.endTime = '';
                                break;
                            case 3:
                                mvvm.entity.searchDay = '';
                                mvvm.entity.searchMonth = '';
                                mvvm.entity.searchYear = '';
                                break;
                        }
                    }
                    //查询人员范围
                    vm.selectDeaprt = function (type) {
                        mvvm.hide = type;
                        switch (type) {
                            case 0:
                                mvvm.entity.$model.DepartIds = '';
                                mvvm.entity.$model.UserIds = '';
                                mvvm.entity.DepartIdName = '';
                                mvvm.entity.UserIdName = '';
                                break;
                            case 1:
                                mvvm.entity.$model.UserIds = '';
                                mvvm.entity.UserIdName = '';
                                break;
                            case 2:
                                mvvm.entity.$model.DepartIds = '';
                                mvvm.entity.DepartIdName = '';
                                break;
                        }
                    }
                    vm.clear = function () {
                        mvvm.entity = ServeMode;
                    }

                    //选择部门
                    vm.postGroupTreeOpts = {
                        treeopts: {
                            check: {
                                enable: true,
                                chkboxType: { "Y": "s", "N": "s" },
                            },
                            async: {
                                enable: true,
                                url: '/Settings/GetGroupPostUser/104000000/'
                            },
                            callback: {
                                onCheck: function (event, treeId, treeNode) {
                                    tree = $.fn.zTree.getZTreeObj(treeId),
                                    names = [],
                                    ids = [],
                                    nodes = tree.getCheckedNodes(true)
                                    nodes.forEach(function (n, i) {
                                        names.push(n.Name)
                                        ids.push(n.Id)
                                    })
                                    mvvm.entity.$model.DepartIds = ids.join(',').toString();
                                    mvvm.entity.DepartIdName = names.join('，').toString()
                                }
                            }
                        }
                    }

                    vm.UserGroupTreeOpts = {
                        treeopts: {
                            check: {
                                enable: true,
                                chkboxType: { "Y": "s", "N": "s" },
                            },

                            callback: {
                                onCheck: function (event, treeId, treeNode) {

                                    tree1 = $.fn.zTree.getZTreeObj(treeId),

                                    usernames = [],
                                    userids = [],
                                    nodes1 = tree1.getCheckedNodes(true)
                                    nodes1.forEach(function (n, i) {
                                        usernames.push(n.Name)
                                        userids.push(n.Id)
                                    })
                                    mvvm.entity.$model.UserIds = userids.join(',').toString();
                                    mvvm.entity.UserIdName = usernames.join('，').toString()
                                }
                            },
                            async: {
                                url: function (treeId, treeNode) {
                                    return "/Settings/GetGroupPostUser/104000000"
                                },
                                dataFilter: notMemberFilter
                            }
                        }
                    }
                });

                getDataList();
                function getDataList() {
                    $.get('/Report/CallState', ServeMode, function (result) {
                        mvvm.dataList = result.data.list;
                        mvvm.total = result.data.total;
                        var type = $('input[name="radioChart"]:checked').val();
                        switch (type) {
                            case "0":
                                createColumnChart(result.data.list_chart, 'chartId', '850', '300')
                                break;
                            case "1":
                                createPieChart(result.data.list_chart, 'chartId', '850', '300')
                                break;
                        }
                    })
                }

                mvvm.entity = ServeMode;
                CBCRM.fillContent(tmpl, lang, contentId, module, mvvm);
                CBCRM.onLoadModuleBefore = function () {
                    avalon.vmodels.Index = null
                    avalon.vmodels.setGroup.destroy()
                    avalon.vmodels.setUser.destroy()
                }
            },

            ///员工接听来电分析
            CallEmployees: function (tmpl, lang, contentId, module) {
                var CBCRM = avalon.vmodels.CBCRM
                var mvvm = avalon.define('CallEmployees', function (vm) {
                    vm.dataList = [];//数据列表
                    vm.category = [];//条件
                    vm.entity = {};//查询条件
                    vm.show = 0;//显示值
                    vm.hide = 0;//显示值
                    vm.total = 0;//总值
                    vm.search = function () {
                        $.get('/Report/CallEmployees', mvvm.entity.$model, function (result) {
                            mvvm.dataList = result.data.list;
                            mvvm.total = result.data.total;
                            var type = $('input[name="radioChart"]:checked').val();
                            switch (type) {
                                case "0":
                                    createColumnChart(result.data.list_chart, 'chartId', '850', '300')
                                    break;
                                case "1":
                                    createPieChart(result.data.list_chart, 'chartId', '850', '300')
                                    break;
                            }
                        })
                    }
                    vm.radioChart = function (type) {
                        $.get('/Report/CallEmployees', mvvm.entity.$model, function (result) {
                            mvvm.dataList = result.data.list;
                            mvvm.total = result.data.total;
                            switch (type) {
                                case 0:
                                    createColumnChart(result.data.list_chart, 'chartId', '850', '300')
                                    break;
                                case 1:
                                    createPieChart(result.data.list_chart, 'chartId', '850', '300')
                                    break;
                            }
                        })
                    }
                    vm.dateOpts = {
                        format: '%Y-%m-%d',
                        onSelect: function (date, formatDate, format) {
                            mvvm.StartDay = formatDate;
                            mvvm.StartDate = formatDate;
                            mvvm.EndDate = formatDate;
                        }
                    }

                    vm.MonthOpts = {
                        format: '%Y-%m',
                        onSelect: function (date, formatDate, format) {
                        }
                    }
                    vm.YearOpts = {
                        format: '%Y',
                        onSelect: function (date, formatDate, format) {
                        }
                    }


                    //查询日期范围
                    vm.rdSelect = function (type) {
                        mvvm.show = type;
                        switch (type) {
                            case 0:
                                mvvm.entity.searchMonth = '';
                                mvvm.entity.searchYear = '';
                                mvvm.entity.starTime = '';
                                mvvm.entity.endTime = '';
                                break;
                            case 1:
                                mvvm.entity.searchDay = '';
                                mvvm.entity.searchYear = '';
                                mvvm.entity.starTime = '';
                                mvvm.entity.endTime = '';
                                break;
                            case 2:
                                mvvm.entity.searchMonth = '';
                                mvvm.entity.searchDay = '';
                                mvvm.entity.starTime = '';
                                mvvm.entity.endTime = '';
                                break;
                            case 3:
                                mvvm.entity.searchDay = '';
                                mvvm.entity.searchMonth = '';
                                mvvm.entity.searchYear = '';
                                break;
                        }
                    }
                    //查询人员范围
                    vm.selectDeaprt = function (type) {
                        mvvm.hide = type;
                        switch (type) {
                            case 0:
                                mvvm.entity.$model.DepartIds = '';
                                mvvm.entity.$model.UserIds = '';
                                mvvm.entity.DepartIdName = '';
                                mvvm.entity.UserIdName = '';
                                break;
                            case 1:
                                mvvm.entity.$model.UserIds = '';
                                mvvm.entity.UserIdName = '';
                                break;
                            case 2:
                                mvvm.entity.$model.DepartIds = '';
                                mvvm.entity.DepartIdName = '';
                                break;
                        }
                    }
                    vm.clear = function () {
                        mvvm.entity = ServeMode;
                    }

                    //选择部门
                    vm.postGroupTreeOpts = {
                        treeopts: {
                            check: {
                                enable: true,
                                chkboxType: { "Y": "s", "N": "s" },
                            },
                            async: {
                                enable: true,
                                url: '/Settings/GetGroupPostUser/104000000/'
                            },
                            callback: {
                                onCheck: function (event, treeId, treeNode) {
                                    tree = $.fn.zTree.getZTreeObj(treeId),
                                    names = [],
                                    ids = [],
                                    nodes = tree.getCheckedNodes(true)
                                    nodes.forEach(function (n, i) {
                                        names.push(n.Name)
                                        ids.push(n.Id)
                                    })
                                    mvvm.entity.$model.DepartIds = ids.join(',').toString();
                                    mvvm.entity.DepartIdName = names.join('，').toString()
                                }
                            }
                        }
                    }

                    vm.UserGroupTreeOpts = {
                        treeopts: {
                            check: {
                                enable: true,
                                chkboxType: { "Y": "s", "N": "s" },
                            },

                            callback: {
                                onCheck: function (event, treeId, treeNode) {

                                    tree1 = $.fn.zTree.getZTreeObj(treeId),

                                    usernames = [],
                                    userids = [],
                                    nodes1 = tree1.getCheckedNodes(true)
                                    nodes1.forEach(function (n, i) {
                                        usernames.push(n.Name)
                                        userids.push(n.Id)
                                    })
                                    mvvm.entity.$model.UserIds = userids.join(',').toString();
                                    mvvm.entity.UserIdName = usernames.join('，').toString()
                                }
                            },
                            async: {
                                url: function (treeId, treeNode) {
                                    return "/Settings/GetGroupPostUser/104000000"
                                },
                                dataFilter: notMemberFilter
                            }
                        }
                    }
                });

                getDataList();
                function getDataList() {
                    $.get('/Report/CallEmployees', ServeMode, function (result) {
                        mvvm.dataList = result.data.list;
                        mvvm.total = result.data.total;
                        var type = $('input[name="radioChart"]:checked').val();
                        switch (type) {
                            case "0":
                                createColumnChart(result.data.list_chart, 'chartId', '850', '300')
                                break;
                            case "1":
                                createPieChart(result.data.list_chart, 'chartId', '850', '300')
                                break;
                        }
                    })
                }

                mvvm.entity = ServeMode;
                CBCRM.fillContent(tmpl, lang, contentId, module, mvvm);
                CBCRM.onLoadModuleBefore = function () {
                    avalon.vmodels.Index = null
                    avalon.vmodels.setGroup.destroy()
                    avalon.vmodels.setUser.destroy()
                }
            },

            ///客户来电次数top10分析
            CallTop: function (tmpl, lang, contentId, module) {
                var CBCRM = avalon.vmodels.CBCRM
                var mvvm = avalon.define('CallTop', function (vm) {
                    vm.dataList = [];//数据列表
                    vm.category = [];//条件
                    vm.entity = {};//查询条件
                    vm.show = 0;//显示值
                    vm.hide = 0;//显示值
                    vm.total = 0;//总值
                    vm.search = function () {
                        $.get('/Report/CallTop', mvvm.entity.$model, function (result) {
                            mvvm.dataList = result.data.list;
                            mvvm.total = result.data.total;
                            var type = $('input[name="radioChart"]:checked').val();
                            switch (type) {
                                case "0":
                                    createColumnChart(result.data.list_chart, 'chartId', '850', '300')
                                    break;
                                case "1":
                                    createPieChart(result.data.list_chart, 'chartId', '850', '300')
                                    break;
                            }
                        })
                    }
                    vm.radioChart = function (type) {
                        $.get('/Report/CallTop', mvvm.entity.$model, function (result) {
                            mvvm.dataList = result.data.list;
                            mvvm.total = result.data.total;
                            switch (type) {
                                case 0:
                                    createColumnChart(result.data.list_chart, 'chartId', '850', '300')
                                    break;
                                case 1:
                                    createPieChart(result.data.list_chart, 'chartId', '850', '300')
                                    break;
                            }
                        })
                    }
                    vm.dateOpts = {
                        format: '%Y-%m-%d',
                        onSelect: function (date, formatDate, format) {
                            mvvm.StartDay = formatDate;
                            mvvm.StartDate = formatDate;
                            mvvm.EndDate = formatDate;
                        }
                    }

                    vm.MonthOpts = {
                        format: '%Y-%m',
                        onSelect: function (date, formatDate, format) {
                        }
                    }
                    vm.YearOpts = {
                        format: '%Y',
                        onSelect: function (date, formatDate, format) {
                        }
                    }


                    //查询日期范围
                    vm.rdSelect = function (type) {
                        mvvm.show = type;
                        switch (type) {
                            case 0:
                                mvvm.entity.searchMonth = '';
                                mvvm.entity.searchYear = '';
                                mvvm.entity.starTime = '';
                                mvvm.entity.endTime = '';
                                break;
                            case 1:
                                mvvm.entity.searchDay = '';
                                mvvm.entity.searchYear = '';
                                mvvm.entity.starTime = '';
                                mvvm.entity.endTime = '';
                                break;
                            case 2:
                                mvvm.entity.searchMonth = '';
                                mvvm.entity.searchDay = '';
                                mvvm.entity.starTime = '';
                                mvvm.entity.endTime = '';
                                break;
                            case 3:
                                mvvm.entity.searchDay = '';
                                mvvm.entity.searchMonth = '';
                                mvvm.entity.searchYear = '';
                                break;
                        }
                    }
                    //查询人员范围
                    vm.selectDeaprt = function (type) {
                        mvvm.hide = type;
                        switch (type) {
                            case 0:
                                mvvm.entity.$model.DepartIds = '';
                                mvvm.entity.$model.UserIds = '';
                                mvvm.entity.DepartIdName = '';
                                mvvm.entity.UserIdName = '';
                                break;
                            case 1:
                                mvvm.entity.$model.UserIds = '';
                                mvvm.entity.UserIdName = '';
                                break;
                            case 2:
                                mvvm.entity.$model.DepartIds = '';
                                mvvm.entity.DepartIdName = '';
                                break;
                        }
                    }
                    vm.clear = function () {
                        mvvm.entity = ServeMode;
                    }

                    //选择部门
                    vm.postGroupTreeOpts = {
                        treeopts: {
                            check: {
                                enable: true,
                                chkboxType: { "Y": "s", "N": "s" },
                            },
                            async: {
                                enable: true,
                                url: '/Settings/GetGroupPostUser/104000000/'
                            },
                            callback: {
                                onCheck: function (event, treeId, treeNode) {
                                    tree = $.fn.zTree.getZTreeObj(treeId),
                                    names = [],
                                    ids = [],
                                    nodes = tree.getCheckedNodes(true)
                                    nodes.forEach(function (n, i) {
                                        names.push(n.Name)
                                        ids.push(n.Id)
                                    })
                                    mvvm.entity.$model.DepartIds = ids.join(',').toString();
                                    mvvm.entity.DepartIdName = names.join('，').toString()
                                }
                            }
                        }
                    }

                    vm.UserGroupTreeOpts = {
                        treeopts: {
                            check: {
                                enable: true,
                                chkboxType: { "Y": "s", "N": "s" },
                            },

                            callback: {
                                onCheck: function (event, treeId, treeNode) {

                                    tree1 = $.fn.zTree.getZTreeObj(treeId),

                                    usernames = [],
                                    userids = [],
                                    nodes1 = tree1.getCheckedNodes(true)
                                    nodes1.forEach(function (n, i) {
                                        usernames.push(n.Name)
                                        userids.push(n.Id)
                                    })
                                    mvvm.entity.$model.UserIds = userids.join(',').toString();
                                    mvvm.entity.UserIdName = usernames.join('，').toString()
                                }
                            },
                            async: {
                                url: function (treeId, treeNode) {
                                    return "/Settings/GetGroupPostUser/104000000"
                                },
                                dataFilter: notMemberFilter
                            }
                        }
                    }
                });

                getDataList();
                function getDataList() {
                    $.get('/Report/CallTop', ServeMode, function (result) {
                        mvvm.dataList = result.data.list;
                        mvvm.total = result.data.total;
                        var type = $('input[name="radioChart"]:checked').val();
                        switch (type) {
                            case "0":
                                createColumnChart(result.data.list_chart, 'chartId', '850', '300')
                                break;
                            case "1":
                                createPieChart(result.data.list_chart, 'chartId', '850', '300')
                                break;
                        }
                    })
                }

                mvvm.entity = ServeMode;
                CBCRM.fillContent(tmpl, lang, contentId, module, mvvm);
                CBCRM.onLoadModuleBefore = function () {
                    avalon.vmodels.Index = null
                    avalon.vmodels.setGroup.destroy()
                    avalon.vmodels.setUser.destroy()
                }
            },

            //工作日志点评统计
            DailyReportComment: function (tmpl, lang, contentId, module) {
                var CBCRM = avalon.vmodels.CBCRM
                var mvvm = avalon.define('DailyReportComment', function (vm) {
                    vm.dataList = [];
                    vm.entity = {};
                    vm.show = 0;
                    vm.total = 0;
                    vm.search = function () {
                        mvvm.entity.$model.notInit = '1';
                        $.get('/Report/DailyReportComment', mvvm.entity.$model, function (result) {
                            mvvm.dataList = result.data.list;
                            mvvm.total = result.data.total;
                            createPieChart(result.data.list_chart, 'chartId', '90%', '360')
                        })
                    }
                    vm.dateOpts = {
                        format: '%Y-%m-%d',
                        onSelect: function (date, formatDate, format) {
                            mvvm.EndDate = formatDate;
                        }
                    }
                    vm.allDeaprt = function () {
                        mvvm.show = 0;
                        mvvm.entity.$model.DepartIds = '';
                        mvvm.entity.$model.UserIds = '';
                        mvvm.entity.DepartIdName = '';
                        mvvm.entity.UserIdName = '';
                    }
                    vm.selectDeaprt = function () {
                        mvvm.entity.$model.UserIds = '';
                        mvvm.entity.UserIdName = '';
                        mvvm.show = 1;
                    }
                    vm.selectUser = function () {
                        mvvm.entity.$model.DepartIds = '';
                        mvvm.entity.DepartIdName = '';
                        mvvm.show = 2;
                    }
                    vm.clear = function () {
                        mvvm.entity = searchMode;
                    }

                    //选择部门
                    vm.postGroupTreeOpts = {
                        treeopts: {
                            check: {
                                enable: true,
                                chkboxType: { "Y": "s", "N": "s" },
                            },
                            async: {
                                enable: true,
                                url: '/Settings/GetGroupPostUser/104000000/'
                            },
                            callback: {
                                onCheck: function (event, treeId, treeNode) {

                                    tree = $.fn.zTree.getZTreeObj(treeId),

                                    names = [],
                                    ids = [],
                                    nodes = tree.getCheckedNodes(true)
                                    nodes.forEach(function (n, i) {
                                        names.push(n.Name)
                                        ids.push(n.Id)
                                    })
                                    mvvm.entity.$model.DepartIds = ids.join(',').toString();
                                    mvvm.entity.DepartIdName = names.join('，').toString()
                                }
                            }
                        }
                    }

                    vm.UserGroupTreeOpts = {
                        treeopts: {
                            check: {
                                enable: true,
                                chkboxType: { "Y": "s", "N": "s" },
                            },

                            callback: {
                                onCheck: function (event, treeId, treeNode) {

                                    tree = $.fn.zTree.getZTreeObj(treeId),

                                    names = [],
                                    ids = [],
                                    nodes = tree.getCheckedNodes(true)
                                    nodes.forEach(function (n, i) {
                                        names.push(n.Name)
                                        ids.push(n.Id)
                                    })
                                    mvvm.entity.$model.UserIds = ids.join(',').toString();
                                    mvvm.entity.UserIdName = names.join('，').toString()
                                }
                            },
                            async: {
                                url: function (treeId, treeNode) {
                                    return "/Settings/GetGroupPostUser/104000000/"
                                },
                                dataFilter: notMemberFilter
                            }

                        }
                    }

                    //vm.itemClick = function (e, item, label, val) {
                    //    $(this).attr('class', 'selected').siblings().removeClass('selected');
                    //    mvvm.entity.$model[label] = val || item.CategoryId;
                    //}
                });

                getDataList();

                function getDataList() {
                    $.get('/Report/DailyReportComment', searchMode, function (result) {
                        mvvm.dataList = result.data.list;
                        mvvm.total = result.data.total;
                        createPieChart(result.data.list_chart, 'chartId', '90%', '360')
                    })
                }

                mvvm.entity = searchMode;
                CBCRM.fillContent(tmpl, lang, contentId, module, mvvm);
                CBCRM.onLoadModuleBefore = function () {
                    avalon.vmodels.Index = null
                    avalon.vmodels.setGroup.destroy()
                    avalon.vmodels.setUser.destroy()
                }
            },

            //工作日志点评统计
            DailyReportStatistics: function (tmpl, lang, contentId, module) {
                var CBCRM = avalon.vmodels.CBCRM
                var mvvm = avalon.define('DailyReportStatistics', function (vm) {
                    vm.dataList = [];
                    vm.entity = {};
                    vm.show = 0;
                    vm.total = 0;
                    vm.search = function () {
                        $.get('/Report/DailyReportStatistics', mvvm.entity.$model, function (result) {
                            mvvm.dataList = result.data.list;
                            mvvm.total = result.data.total;
                            createPieChart(result.data.list_chart, 'chartId', '90%', '360')
                        })
                    }
                    vm.dateOpts = {
                        format: '%Y-%m-%d',
                        onSelect: function (date, formatDate, format) {
                            mvvm.EndDate = formatDate;
                        }
                    }
                    vm.allDeaprt = function () {
                        mvvm.show = 0;
                        mvvm.entity.$model.DepartIds = '';
                        mvvm.entity.$model.UserIds = '';
                        mvvm.entity.DepartIdName = '';
                        mvvm.entity.UserIdName = '';
                    }
                    vm.selectDeaprt = function () {
                        mvvm.entity.$model.UserIds = '';
                        mvvm.entity.UserIdName = '';
                        mvvm.show = 1;
                    }
                    vm.selectUser = function () {
                        mvvm.entity.$model.DepartIds = '';
                        mvvm.entity.DepartIdName = '';
                        mvvm.show = 2;
                    }
                    vm.clear = function () {
                        mvvm.entity = searchMode;
                    }

                    //选择部门
                    vm.postGroupTreeOpts = {
                        treeopts: {
                            check: {
                                enable: true,
                                chkboxType: { "Y": "s", "N": "s" },
                            },
                            async: {
                                enable: true,
                                url: '/Settings/GetGroupPostUser/104000000/'
                            },
                            callback: {
                                onCheck: function (event, treeId, treeNode) {

                                    tree = $.fn.zTree.getZTreeObj(treeId),

                                    names = [],
                                    ids = [],
                                    nodes = tree.getCheckedNodes(true)
                                    nodes.forEach(function (n, i) {
                                        names.push(n.Name)
                                        ids.push(n.Id)
                                    })
                                    mvvm.entity.$model.DepartIds = ids.join(',').toString();
                                    mvvm.entity.DepartIdName = names.join('，').toString()
                                }
                            }
                        }
                    }

                    vm.UserGroupTreeOpts = {
                        treeopts: {
                            check: {
                                enable: true,
                                chkboxType: { "Y": "s", "N": "s" },
                            },

                            callback: {
                                onCheck: function (event, treeId, treeNode) {

                                    tree = $.fn.zTree.getZTreeObj(treeId),

                                    names = [],
                                    ids = [],
                                    nodes = tree.getCheckedNodes(true)
                                    nodes.forEach(function (n, i) {
                                        names.push(n.Name)
                                        ids.push(n.Id)
                                    })
                                    mvvm.entity.$model.UserIds = ids.join(',').toString();
                                    mvvm.entity.UserIdName = names.join('，').toString()
                                }
                            },
                            async: {
                                url: function (treeId, treeNode) {
                                    return "/Settings/GetGroupPostUser/104000000/"
                                },
                                dataFilter: notMemberFilter
                            }

                        }
                    }
                });

                getDataList();

                function getDataList() {
                    $.get('/Report/DailyReportStatistics', searchMode, function (result) {
                        mvvm.dataList = result.data.list;
                        mvvm.total = result.data.total;
                        createPieChart(result.data.list_chart, 'chartId', '90%', '360')
                    })
                }

                mvvm.entity = searchMode;
                CBCRM.fillContent(tmpl, lang, contentId, module, mvvm);
                CBCRM.onLoadModuleBefore = function () {
                    avalon.vmodels.Index = null
                    avalon.vmodels.setGroup.destroy()
                    avalon.vmodels.setUser.destroy()
                }
            },

            //部门员工统计
            GroupEmployee: function (tmpl, lang, contentId, module) {
                var CBCRM = avalon.vmodels.CBCRM
                var mvvm = avalon.define('GroupEmployee', function (vm) {
                    vm.dataList = [];
                    vm.entity = {};
                    vm.total = 0;
                    vm.search = function () {
                        $.get('/Report/GroupEmployee', mvvm.entity.$model, function (result) {
                            mvvm.dataList = result.data.list;
                            mvvm.total = result.data.total;
                            createPieChart(result.data.list_chart, 'chartId', '90%', '360')
                        })
                    }
                    vm.itemClick = function (e, item, label, val) {
                        $(this).attr('class', 'selected').siblings().removeClass('selected');
                        mvvm.entity.$model[label] = val || null;
                    }
                });

                getDataList();

                function getDataList() {
                    $.get('/Report/GroupEmployee', searchMode, function (result) {
                        mvvm.dataList = result.data.list;
                        mvvm.total = result.data.total;
                        createPieChart(result.data.list_chart, 'chartId', '90%', '360')
                    })
                }

                mvvm.entity = searchMode;
                CBCRM.fillContent(tmpl, lang, contentId, module, mvvm);
                CBCRM.onLoadModuleBefore = function () {
                    avalon.vmodels.Index = null
                    //avalon.vmodels.setGroup.destroy()
                    //avalon.vmodels.setUser.destroy()
                }
            },

            //员工学历统计
            EmployeeDegree: function (tmpl, lang, contentId, module) {
                var CBCRM = avalon.vmodels.CBCRM
                var mvvm = avalon.define('EmployeeDegree', function (vm) {
                    vm.dataList = [];
                    vm.list_chart = [];
                    vm.entity = {};
                    vm.show = 0;
                    vm.total = 0;
                    vm.search = function () {
                        mvvm.entity.$model.notInit = '1';
                        $.get('/Report/EmployeeDegree', mvvm.entity.$model, function (result) {
                            mvvm.dataList = result.data.list;
                            mvvm.total = result.data.total;
                            createPieChart(result.data.list_chart, 'chartId', '90%', '360')
                        })
                    }
                    vm.allDeaprt = function () {
                        mvvm.show = 0;
                        mvvm.entity.$model.DepartIds = '';
                        mvvm.entity.$model.UserIds = '';
                        mvvm.entity.DepartIdName = '';
                        mvvm.entity.UserIdName = '';
                    }
                    vm.selectDeaprt = function () {
                        mvvm.entity.$model.UserIds = '';
                        mvvm.entity.UserIdName = '';
                        mvvm.show = 1;
                    }
                    vm.clear = function () {
                        mvvm.entity = searchMode;
                    }

                    //选择部门
                    vm.postGroupTreeOpts = {
                        treeopts: {
                            check: {
                                enable: true,
                                chkboxType: { "Y": "s", "N": "s" },
                            },
                            async: {
                                enable: true,
                                url: '/Settings/GetGroupPostUser/104000000/'
                            },
                            callback: {
                                onCheck: function (event, treeId, treeNode) {

                                    tree = $.fn.zTree.getZTreeObj(treeId),

                                    names = [],
                                    ids = [],
                                    nodes = tree.getCheckedNodes(true)
                                    nodes.forEach(function (n, i) {
                                        names.push(n.Name)
                                        ids.push(n.Id)
                                    })
                                    mvvm.entity.$model.DepartIds = ids.join(',').toString();
                                    mvvm.entity.DepartIdName = names.join('，').toString()
                                }
                            }
                        }
                    }
                    vm.itemClick = function (e, item, label, val) {
                        $(this).attr('class', 'selected').siblings().removeClass('selected');
                        mvvm.entity.$model[label] = val || null;
                    }
                });

                getDataList();

                function getDataList() {
                    $.get('/Report/EmployeeDegree', searchMode, function (result) {
                        mvvm.dataList = result.data.list;
                        mvvm.list_chart = result.data.list_chart;
                        mvvm.total = result.data.total;
                        createPieChart(mvvm.list_chart, 'chartId', '90%', '360');
                    })
                }

                mvvm.entity = searchMode;
                CBCRM.fillContent(tmpl, lang, contentId, module, mvvm);
                CBCRM.onLoadModuleBefore = function () {
                    avalon.vmodels.Index = null;
                    avalon.vmodels.setGroup.destroy();
                }
            },

            //员工在职时间统计
            EmployeeReportDay: function (tmpl, lang, contentId, module) {
                var CBCRM = avalon.vmodels.CBCRM
                var mvvm = avalon.define('EmployeeReportDay', function (vm) {
                    vm.dataList = [];
                    vm.entity = {};
                    vm.show = 0;
                    vm.total = 0;
                    vm.search = function () {
                        $.get('/Report/EmployeeReportDay', mvvm.entity.$model, function (result) {
                            mvvm.dataList = result.data.list;
                            mvvm.total = result.data.total;
                            createPieChart(result.data.list_chart, 'chartId', '90%', '360');
                        })
                    }
                    vm.allDeaprt = function () {
                        mvvm.show = 0;
                        mvvm.entity.$model.DepartIds = '';
                        mvvm.entity.$model.UserIds = '';
                        mvvm.entity.DepartIdName = '';
                        mvvm.entity.UserIdName = '';
                    }
                    vm.selectDeaprt = function () {
                        mvvm.entity.$model.UserIds = '';
                        mvvm.entity.UserIdName = '';
                        mvvm.show = 1;
                    }
                    vm.selectUser = function () {
                        mvvm.entity.$model.DepartIds = '';
                        mvvm.entity.DepartIdName = '';
                        mvvm.show = 2;
                    }
                    vm.clear = function () {
                        mvvm.entity = searchMode;
                    }

                    //选择部门
                    vm.postGroupTreeOpts = {
                        treeopts: {
                            check: {
                                enable: true,
                                chkboxType: { "Y": "s", "N": "s" },
                            },
                            async: {
                                enable: true,
                                url: '/Settings/GetGroupPostUser/104000000/'
                            },
                            callback: {
                                onCheck: function (event, treeId, treeNode) {
                                    tree = $.fn.zTree.getZTreeObj(treeId),
                                    names = [],
                                    ids = [],
                                    nodes = tree.getCheckedNodes(true)
                                    nodes.forEach(function (n, i) {
                                        names.push(n.Name)
                                        ids.push(n.Id)
                                    })
                                    mvvm.entity.$model.DepartIds = ids.join(',').toString();
                                    mvvm.entity.DepartIdName = names.join('，').toString()
                                }
                            }
                        }
                    }
                    //选择员工
                    vm.UserGroupTreeOpts = {
                        treeopts: {
                            check: {
                                enable: true,
                                chkboxType: { "Y": "s", "N": "s" },
                            },

                            callback: {
                                onCheck: function (event, treeId, treeNode) {

                                    tree = $.fn.zTree.getZTreeObj(treeId),

                                    names = [],
                                    ids = [],
                                    nodes = tree.getCheckedNodes(true)
                                    nodes.forEach(function (n, i) {
                                        names.push(n.Name)
                                        ids.push(n.Id)
                                    })
                                    mvvm.entity.$model.UserIds = ids.join(',').toString();
                                    mvvm.entity.UserIdName = names.join('，').toString()
                                }
                            },
                            async: {
                                url: function (treeId, treeNode) {
                                    return "/Settings/GetGroupPostUser/104000000/"
                                },
                                dataFilter: notMemberFilter
                            }

                        }
                    }
                    vm.itemClick = function (e, item, label, val) {
                        $(this).attr('class', 'selected').siblings().removeClass('selected');
                        mvvm.entity.$model[label] = val || null;
                    }
                });
                getDataList();
                function getDataList() {
                    $.get('/Report/EmployeeReportDay', searchMode, function (result) {
                        mvvm.dataList = result.data.list;
                        mvvm.total = result.data.total;
                        createPieChart(result.data.list_chart, 'chartId', '90%', '360')
                    })
                }
                mvvm.entity = searchMode;
                CBCRM.fillContent(tmpl, lang, contentId, module, mvvm);
                CBCRM.onLoadModuleBefore = function () {
                    avalon.vmodels.Index = null;
                    avalon.vmodels.setGroup.destroy();
                    avalon.vmodels.setUser.destroy();
                }
            },

            //员工性别统计
            EmployeeSex: function (tmpl, lang, contentId, module) {
                var CBCRM = avalon.vmodels.CBCRM
                var mvvm = avalon.define('EmployeeSex', function (vm) {
                    vm.dataList = [];
                    vm.list_chart = [];
                    vm.entity = {};
                    vm.show = 0;
                    vm.total = 0;
                    vm.search = function () {
                        mvvm.entity.$model.notInit = '1';
                        $.get('/Report/EmployeeSex', mvvm.entity.$model, function (result) {
                            mvvm.dataList = result.data.list;
                            mvvm.total = result.data.total;
                            createPieChart(result.data.list_chart, 'chartId', '90%', '360')
                        })
                    }
                    vm.allDeaprt = function () {
                        mvvm.show = 0;
                        mvvm.entity.$model.DepartIds = '';
                        mvvm.entity.$model.UserIds = '';
                        mvvm.entity.DepartIdName = '';
                        mvvm.entity.UserIdName = '';
                    }
                    vm.selectDeaprt = function () {
                        mvvm.entity.$model.UserIds = '';
                        mvvm.entity.UserIdName = '';
                        mvvm.show = 1;
                    }
                    vm.clear = function () {
                        mvvm.entity = searchMode;
                    }

                    //选择部门
                    vm.postGroupTreeOpts = {
                        treeopts: {
                            check: {
                                enable: true,
                                chkboxType: { "Y": "s", "N": "s" },
                            },
                            async: {
                                enable: true,
                                url: '/Settings/GetGroupPostUser/104000000/'
                            },
                            callback: {
                                onCheck: function (event, treeId, treeNode) {

                                    tree = $.fn.zTree.getZTreeObj(treeId),

                                    names = [],
                                    ids = [],
                                    nodes = tree.getCheckedNodes(true)
                                    nodes.forEach(function (n, i) {
                                        names.push(n.Name)
                                        ids.push(n.Id)
                                    })
                                    mvvm.entity.$model.DepartIds = ids.join(',').toString();
                                    mvvm.entity.DepartIdName = names.join('，').toString()
                                }
                            }
                        }
                    }
                    vm.itemClick = function (e, item, label, val) {
                        $(this).attr('class', 'selected').siblings().removeClass('selected');
                        mvvm.entity.$model[label] = val || null;
                    }
                });

                getDataList();

                function getDataList() {
                    $.get('/Report/EmployeeSex', searchMode, function (result) {
                        mvvm.dataList = result.data.list;
                        mvvm.list_chart = result.data.list_chart;
                        mvvm.total = result.data.total;
                        createPieChart(mvvm.list_chart, 'chartId', '90%', '360');
                    })
                }

                mvvm.entity = searchMode;
                CBCRM.fillContent(tmpl, lang, contentId, module, mvvm);
                CBCRM.onLoadModuleBefore = function () {
                    avalon.vmodels.Index = null;
                    avalon.vmodels.setGroup.destroy();
                }
            },

            //员工年龄统计
            EmployeeAge: function (tmpl, lang, contentId, module) {
                var CBCRM = avalon.vmodels.CBCRM
                var mvvm = avalon.define('EmployeeAge', function (vm) {
                    vm.dataList = [];
                    vm.list_chart = [];
                    vm.entity = {};
                    vm.show = 0;
                    vm.total = 0;
                    vm.search = function () {
                        $.get('/Report/EmployeeAge', mvvm.entity.$model, function (result) {
                            mvvm.dataList = result.data.list;
                            mvvm.total = result.data.total;
                            createColumnChart(result.data.list_chart, 'chartId', '90%', '360')
                        })
                    }
                    vm.allDeaprt = function () {
                        mvvm.show = 0;
                        mvvm.entity.$model.DepartIds = '';
                        mvvm.entity.$model.UserIds = '';
                        mvvm.entity.DepartIdName = '';
                        mvvm.entity.UserIdName = '';
                    }
                    vm.selectDeaprt = function () {
                        mvvm.entity.$model.UserIds = '';
                        mvvm.entity.UserIdName = '';
                        mvvm.show = 1;
                    }
                    vm.clear = function () {
                        mvvm.entity = searchMode;
                    }

                    //选择部门
                    vm.postGroupTreeOpts = {
                        treeopts: {
                            check: {
                                enable: true,
                                chkboxType: { "Y": "s", "N": "s" },
                            },
                            async: {
                                enable: true,
                                url: '/Settings/GetGroupPostUser/104000000/'
                            },
                            callback: {
                                onCheck: function (event, treeId, treeNode) {

                                    tree = $.fn.zTree.getZTreeObj(treeId),

                                    names = [],
                                    ids = [],
                                    nodes = tree.getCheckedNodes(true)
                                    nodes.forEach(function (n, i) {
                                        names.push(n.Name)
                                        ids.push(n.Id)
                                    })
                                    mvvm.entity.$model.DepartIds = ids.join(',').toString();
                                    mvvm.entity.DepartIdName = names.join('，').toString()
                                }
                            }
                        }
                    }
                    vm.itemClick = function (e, item, label, val) {
                        $(this).attr('class', 'selected').siblings().removeClass('selected');
                        mvvm.entity.$model[label] = val || null;
                    }
                });

                getDataList();

                function getDataList() {
                    $.get('/Report/EmployeeAge', searchMode, function (result) {
                        mvvm.dataList = result.data.list;
                        mvvm.list_chart = result.data.list_chart;
                        mvvm.total = result.data.total;
                        createColumnChart(mvvm.list_chart, 'chartId', '90%', '360');
                    })
                }

                mvvm.entity = searchMode;
                CBCRM.fillContent(tmpl, lang, contentId, module, mvvm);
                CBCRM.onLoadModuleBefore = function () {
                    avalon.vmodels.Index = null;
                    avalon.vmodels.setGroup.destroy();
                }
            },

            //合同状态统计
            EmployeeLabourContract: function (tmpl, lang, contentId, module) {
                var CBCRM = avalon.vmodels.CBCRM
                var mvvm = avalon.define('EmployeeLabourContract', function (vm) {
                    vm.dataList = [];
                    vm.list_chart = [];
                    vm.entity = {};
                    vm.show = 0;
                    vm.total = 0;
                    vm.tbtitle = "";
                    vm.search = function () {
                        $.get('/Report/EmployeeLabourContract', mvvm.entity.$model, function (result) {
                            mvvm.dataList = result.data.list;
                            mvvm.list_chart = result.data.list_chart;
                            mvvm.total = result.data.total;
                            mvvm.tbtitle = result.data.tbtitle;
                            createColumnChart(result.data.list_chart, 'chartId', '90%', '360')
                        })
                    }
                    vm.allDeaprt = function () {
                        mvvm.show = 0;
                        mvvm.entity.$model.DepartIds = '';
                        mvvm.entity.$model.UserIds = '';
                        mvvm.entity.DepartIdName = '';
                        mvvm.entity.UserIdName = '';
                    }
                    vm.selectDeaprt = function () {
                        mvvm.entity.$model.UserIds = '';
                        mvvm.entity.UserIdName = '';
                        mvvm.show = 1;
                    }
                    vm.clear = function () {
                        mvvm.entity = searchMode;
                    }

                    //选择部门
                    vm.postGroupTreeOpts = {
                        treeopts: {
                            check: {
                                enable: true,
                                chkboxType: { "Y": "s", "N": "s" },
                            },
                            async: {
                                enable: true,
                                url: '/Settings/GetGroupPostUser/104000000/'
                            },
                            callback: {
                                onCheck: function (event, treeId, treeNode) {

                                    tree = $.fn.zTree.getZTreeObj(treeId),

                                    names = [],
                                    ids = [],
                                    nodes = tree.getCheckedNodes(true)
                                    nodes.forEach(function (n, i) {
                                        names.push(n.Name)
                                        ids.push(n.Id)
                                    })
                                    mvvm.entity.$model.DepartIds = ids.join(',').toString();
                                    mvvm.entity.DepartIdName = names.join('，').toString()
                                }
                            }
                        }
                    }
                    vm.itemClick = function (e, item, label, val) {
                        $(this).attr('class', 'selected').siblings().removeClass('selected');
                        mvvm.entity.$model[label] = val || null;
                    }
                });

                getDataList();

                function getDataList() {
                    $.get('/Report/EmployeeLabourContract', searchMode, function (result) {
                        mvvm.dataList = result.data.list;
                        mvvm.list_chart = result.data.list_chart;
                        mvvm.total = result.data.total;
                        mvvm.tbtitle = result.data.tbtitle;
                        createColumnChart(mvvm.list_chart, 'chartId', '90%', '360');
                    })
                }

                mvvm.entity = searchMode;
                CBCRM.fillContent(tmpl, lang, contentId, module, mvvm);
                CBCRM.onLoadModuleBefore = function () {
                    avalon.vmodels.Index = null;
                    avalon.vmodels.setGroup.destroy();
                }
            },

            //人事调动统计
            EmployeePostChange: function (tmpl, lang, contentId, module) {
                var CBCRM = avalon.vmodels.CBCRM
                var mvvm = avalon.define('EmployeePostChange', function (vm) {
                    vm.dataList = [];
                    vm.list_chart = [];
                    vm.entity = {};
                    vm.show = 0;
                    vm.total = 0;
                    vm.search = function () {
                        $.get('/Report/EmployeePostChange', mvvm.entity.$model, function (result) {
                            mvvm.dataList = result.data.list;
                            mvvm.list_chart = result.data.list_chart;
                            mvvm.total = result.data.total;
                            createColumnChart(result.data.list_chart, 'chartId', '90%', '360')
                        })
                    }
                    vm.allDeaprt = function () {
                        mvvm.show = 0;
                        mvvm.entity.$model.DepartIds = '';
                        mvvm.entity.$model.UserIds = '';
                        mvvm.entity.DepartIdName = '';
                        mvvm.entity.UserIdName = '';
                    }
                    vm.selectUser = function () {
                        mvvm.entity.$model.DepartIds = '';
                        mvvm.entity.DepartIdName = '';
                        mvvm.show = 2;
                    }
                    vm.clear = function () {
                        mvvm.entity = searchMode;
                    }
                    //选择员工
                    vm.UserGroupTreeOpts = {
                        treeopts: {
                            check: {
                                enable: true,
                                chkboxType: { "Y": "s", "N": "s" },
                            },

                            callback: {
                                onCheck: function (event, treeId, treeNode) {

                                    tree = $.fn.zTree.getZTreeObj(treeId),

                                    names = [],
                                    ids = [],
                                    nodes = tree.getCheckedNodes(true)
                                    nodes.forEach(function (n, i) {
                                        names.push(n.Name)
                                        ids.push(n.Id)
                                    })
                                    mvvm.entity.$model.UserIds = ids.join(',').toString();
                                    mvvm.entity.UserIdName = names.join('，').toString()
                                }
                            },
                            async: {
                                url: function (treeId, treeNode) {
                                    return "/Settings/GetGroupPostUser/104000000/"
                                },
                                dataFilter: notMemberFilter
                            }

                        }
                    }
                    vm.itemClick = function (e, item, label, val) {
                        $(this).attr('class', 'selected').siblings().removeClass('selected');
                        mvvm.entity.$model[label] = val || null;
                    }
                });

                getDataList();

                function getDataList() {
                    $.get('/Report/EmployeePostChange', searchMode, function (result) {
                        mvvm.dataList = result.data.list;
                        mvvm.list_chart = result.data.list_chart;
                        mvvm.total = result.data.total;
                        createColumnChart(mvvm.list_chart, 'chartId', '90%', '360');
                    })
                }

                mvvm.entity = searchMode;
                CBCRM.fillContent(tmpl, lang, contentId, module, mvvm);
                CBCRM.onLoadModuleBefore = function () {
                    avalon.vmodels.Index = null;
                    avalon.vmodels.setUser.destroy();
                }
            },

            //员工沟通统计
            EmployeeCommunication: function (tmpl, lang, contentId, module) {
                var CBCRM = avalon.vmodels.CBCRM
                var mvvm = avalon.define('EmployeeCommunication', function (vm) {
                    vm.dataList = [];
                    vm.list_chart = [];
                    vm.entity = {};
                    vm.show = 0;
                    vm.total = 0;
                    vm.search = function () {
                        $.get('/Report/EmployeeCommunication', mvvm.entity.$model, function (result) {
                            mvvm.dataList = result.data.list;
                            mvvm.list_chart = result.data.list_chart;
                            mvvm.total = result.data.total;
                            createColumnChart(result.data.list_chart, 'chartId', '90%', '360')
                        })
                    }
                    vm.allDeaprt = function () {
                        mvvm.show = 0;
                        mvvm.entity.$model.DepartIds = '';
                        mvvm.entity.$model.UserIds = '';
                        mvvm.entity.DepartIdName = '';
                        mvvm.entity.UserIdName = '';
                    }
                    vm.selectUser = function () {
                        mvvm.entity.$model.DepartIds = '';
                        mvvm.entity.DepartIdName = '';
                        mvvm.show = 2;
                    }
                    vm.clear = function () {
                        mvvm.entity = searchMode;
                    }
                    //选择员工
                    vm.UserGroupTreeOpts = {
                        treeopts: {
                            check: {
                                enable: true,
                                chkboxType: { "Y": "s", "N": "s" },
                            },

                            callback: {
                                onCheck: function (event, treeId, treeNode) {

                                    tree = $.fn.zTree.getZTreeObj(treeId),

                                    names = [],
                                    ids = [],
                                    nodes = tree.getCheckedNodes(true)
                                    nodes.forEach(function (n, i) {
                                        names.push(n.Name)
                                        ids.push(n.Id)
                                    })
                                    mvvm.entity.$model.UserIds = ids.join(',').toString();
                                    mvvm.entity.UserIdName = names.join('，').toString()
                                }
                            },
                            async: {
                                url: function (treeId, treeNode) {
                                    return "/Settings/GetGroupPostUser/104000000/"
                                },
                                dataFilter: notMemberFilter
                            }

                        }
                    }
                    vm.itemClick = function (e, item, label, val) {
                        $(this).attr('class', 'selected').siblings().removeClass('selected');
                        mvvm.entity.$model[label] = val || null;
                    }
                });

                getDataList();

                function getDataList() {
                    $.get('/Report/EmployeeCommunication', searchMode, function (result) {
                        mvvm.dataList = result.data.list;
                        mvvm.list_chart = result.data.list_chart;
                        mvvm.total = result.data.total;
                        createColumnChart(mvvm.list_chart, 'chartId', '90%', '360');
                    })
                }

                mvvm.entity = searchMode;
                CBCRM.fillContent(tmpl, lang, contentId, module, mvvm);
                CBCRM.onLoadModuleBefore = function () {
                    avalon.vmodels.Index = null;
                    avalon.vmodels.setUser.destroy();
                }
            },

            //员工奖惩统计
            EmployeeReward: function (tmpl, lang, contentId, module) {
                var CBCRM = avalon.vmodels.CBCRM
                var mvvm = avalon.define('EmployeeReward', function (vm) {
                    vm.dataList = [];
                    vm.list_chart = [];
                    vm.entity = {};
                    vm.show = 0;
                    vm.total = 0;
                    vm.search = function () {
                        $.get('/Report/EmployeeReward', mvvm.entity.$model, function (result) {
                            mvvm.dataList = result.data.list;
                            mvvm.list_chart = result.data.list_chart;
                            mvvm.total = result.data.total;
                            createColumnChart(result.data.list_chart, 'chartId', '90%', '360')
                        })
                    }
                    vm.allDeaprt = function () {
                        mvvm.show = 0;
                        mvvm.entity.$model.DepartIds = '';
                        mvvm.entity.$model.UserIds = '';
                        mvvm.entity.DepartIdName = '';
                        mvvm.entity.UserIdName = '';
                    }
                    vm.selectDeaprt = function () {
                        mvvm.entity.$model.UserIds = '';
                        mvvm.entity.UserIdName = '';
                        mvvm.show = 1;
                    }
                    vm.clear = function () {
                        mvvm.entity = searchMode;
                    }
                    //选择部门
                    vm.postGroupTreeOpts = {
                        treeopts: {
                            check: {
                                enable: true,
                                chkboxType: { "Y": "s", "N": "s" },
                            },
                            async: {
                                enable: true,
                                url: '/Settings/GetGroupPostUser/104000000/'
                            },
                            callback: {
                                onCheck: function (event, treeId, treeNode) {

                                    tree = $.fn.zTree.getZTreeObj(treeId),

                                    names = [],
                                    ids = [],
                                    nodes = tree.getCheckedNodes(true)
                                    nodes.forEach(function (n, i) {
                                        names.push(n.Name)
                                        ids.push(n.Id)
                                    })
                                    mvvm.entity.$model.DepartIds = ids.join(',').toString();
                                    mvvm.entity.DepartIdName = names.join('，').toString()
                                }
                            }
                        }
                    }
                    vm.itemClick = function (e, item, label, val) {
                        $(this).attr('class', 'selected').siblings().removeClass('selected');
                        mvvm.entity.$model[label] = val || null;
                    }
                });

                getDataList();

                function getDataList() {
                    $.get('/Report/EmployeeReward', searchMode, function (result) {
                        mvvm.dataList = result.data.list;
                        mvvm.list_chart = result.data.list_chart;
                        mvvm.total = result.data.total;
                        createColumnChart(mvvm.list_chart, 'chartId', '90%', '360');
                    })
                }

                mvvm.entity = searchMode;
                CBCRM.fillContent(tmpl, lang, contentId, module, mvvm);
                CBCRM.onLoadModuleBefore = function () {
                    avalon.vmodels.Index = null;
                    avalon.vmodels.setGroup.destroy()
                }
            },

            //员工积分前十统计
            EmployeeIntegral: function (tmpl, lang, contentId, module) {
                var CBCRM = avalon.vmodels.CBCRM
                var mvvm = avalon.define('EmployeeIntegral', function (vm) {
                    vm.dataList = [];
                    vm.list_chart = [];
                    vm.entity = {};
                    vm.show = 0;
                    vm.search = function () {
                        $.get('/Report/EmployeeIntegral', mvvm.entity.$model, function (result) {
                            mvvm.dataList = result.data.list;
                            mvvm.list_chart = result.data.list_chart;
                            createColumnChart(result.data.list_chart, 'chartId', '90%', '360')
                        })
                    }
                    vm.allDeaprt = function () {
                        mvvm.show = 0;
                        mvvm.entity.$model.DepartIds = '';
                        mvvm.entity.$model.UserIds = '';
                        mvvm.entity.DepartIdName = '';
                        mvvm.entity.UserIdName = '';
                    }
                    vm.selectDeaprt = function () {
                        mvvm.entity.$model.UserIds = '';
                        mvvm.entity.UserIdName = '';
                        mvvm.show = 1;
                    }
                    vm.clear = function () {
                        mvvm.entity = searchMode;
                    }
                    //选择部门
                    vm.postGroupTreeOpts = {
                        treeopts: {
                            check: {
                                enable: true,
                                chkboxType: { "Y": "s", "N": "s" },
                            },
                            async: {
                                enable: true,
                                url: '/Settings/GetGroupPostUser/104000000/'
                            },
                            callback: {
                                onCheck: function (event, treeId, treeNode) {
                                    tree = $.fn.zTree.getZTreeObj(treeId),
                                    names = [],
                                    ids = [],
                                    nodes = tree.getCheckedNodes(true)
                                    nodes.forEach(function (n, i) {
                                        names.push(n.Name)
                                        ids.push(n.Id)
                                    })
                                    mvvm.entity.$model.DepartIds = ids.join(',').toString();
                                    mvvm.entity.DepartIdName = names.join('，').toString()
                                }
                            }
                        }
                    }
                    vm.itemClick = function (e, item, label, val) {
                        $(this).attr('class', 'selected').siblings().removeClass('selected');
                        mvvm.entity.$model[label] = val || null;
                    }
                });
                getDataList();
                function getDataList() {
                    $.get('/Report/EmployeeIntegral', searchMode, function (result) {
                        mvvm.dataList = result.data.list;
                        mvvm.list_chart = result.data.list_chart;
                        createColumnChart(mvvm.list_chart, 'chartId', '90%', '360');
                    })
                }
                mvvm.entity = searchMode;
                CBCRM.fillContent(tmpl, lang, contentId, module, mvvm);
                CBCRM.onLoadModuleBefore = function () {
                    avalon.vmodels.Index = null;
                    avalon.vmodels.setGroup.destroy()
                }
            },

            //培训次数统计
            EmployeeTraining: function (tmpl, lang, contentId, module) {
                var CBCRM = avalon.vmodels.CBCRM
                var mvvm = avalon.define('EmployeeTraining', function (vm) {
                    vm.dataList = [];
                    vm.list_chart = [];
                    vm.entity = {};
                    vm.show = 0;
                    vm.total = 0;
                    vm.search = function () {
                        $.get('/Report/EmployeeTraining', mvvm.entity.$model, function (result) {
                            mvvm.dataList = result.data.list;
                            mvvm.list_chart = result.data.list_chart;
                            mvvm.total = result.data.total;
                            createColumnChart(result.data.list_chart, 'chartId', '90%', '360')
                        })
                    }
                    vm.clear = function () {
                        mvvm.entity = searchMode;
                    }
                    vm.itemClick = function (e, item, label, val) {
                        $(this).attr('class', 'selected').siblings().removeClass('selected');
                        mvvm.entity.$model[label] = val || null;
                    }
                });
                getDataList();
                function getDataList() {
                    $.get('/Report/EmployeeTraining', searchMode, function (result) {
                        mvvm.dataList = result.data.list;
                        mvvm.list_chart = result.data.list_chart;
                        mvvm.total = result.data.total;
                        createColumnChart(mvvm.list_chart, 'chartId', '90%', '360');
                    })
                }
                mvvm.entity = searchMode;
                CBCRM.fillContent(tmpl, lang, contentId, module, mvvm);
                CBCRM.onLoadModuleBefore = function () {
                    avalon.vmodels.Index = null;
                }
            },

            //简历统计分析
            EmployeeResume: function (tmpl, lang, contentId, module) {
                var CBCRM = avalon.vmodels.CBCRM
                var mvvm = avalon.define('EmployeeResume', function (vm) {
                    vm.dataList = [];
                    vm.list_chart = [];
                    vm.entity = {};
                    vm.show = 0;
                    vm.total = 0;
                    vm.search = function () {
                        $.get('/Report/EmployeeResume', mvvm.entity.$model, function (result) {
                            mvvm.dataList = result.data.list;
                            mvvm.list_chart = result.data.list_chart;
                            mvvm.total = result.data.total;
                            createPieChart(result.data.list_chart, 'chartId', '90%', '360')
                        })
                    }
                    vm.clear = function () {
                        mvvm.entity = searchMode;
                    }
                });
                getDataList();
                function getDataList() {
                    $.get('/Report/EmployeeResume', searchMode, function (result) {
                        mvvm.dataList = result.data.list;
                        mvvm.list_chart = result.data.list_chart;
                        mvvm.total = result.data.total;
                        createPieChart(mvvm.list_chart, 'chartId', '90%', '360');
                    })
                }
                mvvm.entity = searchMode;
                CBCRM.fillContent(tmpl, lang, contentId, module, mvvm);
                CBCRM.onLoadModuleBefore = function () {
                    avalon.vmodels.Index = null;
                }
            },

            //招聘计划申请统计
            RecruitmentApply: function (tmpl, lang, contentId, module) {
                var CBCRM = avalon.vmodels.CBCRM
                var mvvm = avalon.define('RecruitmentApply', function (vm) {
                    vm.dataList = [];
                    vm.list_chart = [];
                    vm.entity = {};
                    vm.show = 0;
                    vm.total = 0;
                    vm.search = function () {
                        $.get('/Report/RecruitmentApply', mvvm.entity.$model, function (result) {
                            mvvm.dataList = result.data.list;
                            mvvm.list_chart = result.data.list_chart;
                            mvvm.total = result.data.total;
                            createPieChart(result.data.list_chart, 'chartId', '90%', '360')
                        })
                    }
                    vm.allDeaprt = function () {
                        mvvm.show = 0;
                        mvvm.entity.$model.DepartIds = '';
                        mvvm.entity.$model.UserIds = '';
                        mvvm.entity.DepartIdName = '';
                        mvvm.entity.UserIdName = '';
                    }
                    vm.selectDeaprt = function () {
                        mvvm.entity.$model.UserIds = '';
                        mvvm.entity.UserIdName = '';
                        mvvm.show = 1;
                    }
                    vm.clear = function () {
                        mvvm.entity = searchMode;
                    }
                    vm.postGroupTreeOpts = {
                        treeopts: {
                            check: {
                                enable: true,
                                chkboxType: { "Y": "s", "N": "s" },
                            },
                            async: {
                                enable: true,
                                url: '/Settings/GetGroupPostUser/104000000/'
                            },
                            callback: {
                                onCheck: function (event, treeId, treeNode) {

                                    tree = $.fn.zTree.getZTreeObj(treeId),

                                    names = [],
                                    ids = [],
                                    nodes = tree.getCheckedNodes(true)
                                    nodes.forEach(function (n, i) {
                                        names.push(n.Name)
                                        ids.push(n.Id)
                                    })
                                    mvvm.entity.$model.DepartIds = ids.join(',').toString();
                                    mvvm.entity.DepartIdName = names.join('，').toString()
                                }
                            }
                        }
                    }
                });
                getDataList();
                function getDataList() {
                    $.get('/Report/RecruitmentApply', searchMode, function (result) {
                        mvvm.dataList = result.data.list;
                        mvvm.list_chart = result.data.list_chart;
                        mvvm.total = result.data.total;
                        createPieChart(mvvm.list_chart, 'chartId', '90%', '360');
                    })
                }
                mvvm.entity = searchMode;
                CBCRM.fillContent(tmpl, lang, contentId, module, mvvm);
                CBCRM.onLoadModuleBefore = function () {
                    avalon.vmodels.Index = null;
                    avalon.vmodels.setGroup.destroy()
                }
            },

            //招聘到职统计
            RecruitPost: function (tmpl, lang, contentId, module) {
                var CBCRM = avalon.vmodels.CBCRM
                var mvvm = avalon.define('RecruitPost', function (vm) {
                    vm.dataList = [];
                    vm.entity = {};
                    vm.show = 0;
                    vm.initTime = '';
                    vm.search = function () {
                        mvvm.entity.$model.notInit = '1';
                        $.get('/Report/RecruitPost', mvvm.entity.$model, function (result) {
                            mvvm.dataList = result.data.list;
                            createColumnChartWithTitle(result.data.list_chart, '招聘职位统计', 'chartId', '90%', '360')
                        })
                    }
                    vm.dateOpts = {
                        format: '%Y-%m-%d',
                        onSelect: function (date, formatDate, format) {
                            mvvm.EndDate = formatDate;
                        }
                    }
                    vm.clear = function () {
                        mvvm.entity = searchMode;
                    }
                });

                getDataList();

                function getDataList() {
                    $.get('/Report/RecruitPost', searchMode, function (result) {
                        mvvm.dataList = result.data.list;
                        mvvm.initTime = result.data.initTime;
                        createColumnChartWithTitle(result.data.list_chart, '招聘职位统计', 'chartId', '90%', '360')
                    })
                }

                mvvm.entity = searchMode;
                CBCRM.fillContent(tmpl, lang, contentId, module, mvvm);
                CBCRM.onLoadModuleBefore = function () {
                    avalon.vmodels.Index = null
                }
            },

            //知识文档分类统计
            KnowledgeCategory: function (tmpl, lang, contentId, module) {
                var CBCRM = avalon.vmodels.CBCRM
                var mvvm = avalon.define('KnowledgeCategory', function (vm) {
                    vm.dataList = [];
                    vm.list_chart = [];
                    vm.entity = {};
                    vm.show = 0;
                    vm.total = 0;
                    vm.search = function () {
                        $.get('/Report/KnowledgeCategory', mvvm.entity.$model, function (result) {
                            mvvm.dataList = result.data.list;
                            mvvm.total = result.data.total;
                            createColumnChart(result.data.list_chart, 'chartId', '90%', '360')
                        })
                    }
                    vm.clear = function () {
                        mvvm.entity = searchMode;
                    }
                });

                getDataList();

                function getDataList() {
                    $.get('/Report/KnowledgeCategory', searchMode, function (result) {
                        mvvm.dataList = result.data.list;
                        mvvm.list_chart = result.data.list_chart;
                        mvvm.total = result.data.total;
                        createColumnChart(mvvm.list_chart, 'chartId', '90%', '360');
                    })
                }

                mvvm.entity = searchMode;
                CBCRM.fillContent(tmpl, lang, contentId, module, mvvm);
                CBCRM.onLoadModuleBefore = function () {
                    avalon.vmodels.Index = null;
                }
            },

            //知识文档分类统计
            KnowledgePublishDate: function (tmpl, lang, contentId, module) {
                var CBCRM = avalon.vmodels.CBCRM
                var mvvm = avalon.define('KnowledgePublishDate', function (vm) {
                    vm.dataList = [];
                    vm.list_chart = [];
                    vm.entity = {};
                    vm.show = 0;
                    vm.initTime = '';
                    vm.total = 0;
                    vm.search = function () {
                        $.get('/Report/KnowledgePublishDate', mvvm.entity.$model, function (result) {
                            mvvm.dataList = result.data.list;
                            mvvm.total = result.data.total;
                            createColumnChart(result.data.list_chart, 'chartId', '90%', '360')
                        })
                    }
                    vm.clear = function () {
                        mvvm.entity = searchMode;
                    }
                });

                getDataList();

                function getDataList() {
                    $.get('/Report/KnowledgePublishDate', searchMode, function (result) {
                        mvvm.dataList = result.data.list;
                        mvvm.list_chart = result.data.list_chart;
                        mvvm.total = result.data.total;
                        mvvm.initTime = result.data.initTime;
                        createColumnChart(mvvm.list_chart, 'chartId', '90%', '360');
                    })
                }

                mvvm.entity = searchMode;
                CBCRM.fillContent(tmpl, lang, contentId, module, mvvm);
                CBCRM.onLoadModuleBefore = function () {
                    avalon.vmodels.Index = null;
                }
            },

            //产品分类统计
            ProductCategory: function (tmpl, lang, contentId, module) {
                var CBCRM = avalon.vmodels.CBCRM
                var mvvm = avalon.define('ProductCategory', function (vm) {
                    vm.dataList = [];
                    vm.list_cat = [];
                    vm.nowCat = [];
                    vm.entity = {};
                    vm.show = 0;
                    vm.total = 0;
                    vm.search = function () {
                        $.get('/Report/ProductCategory', mvvm.entity.$model, function (result) {
                            mvvm.dataList = result.data.list;
                            mvvm.total = result.data.total;
                            mvvm.nowCat = result.data.nowCat;
                            mvvm.list_cat = result.data.list_cat;
                            createColumnChart(result.data.list_chart, 'chartId', '90%', '360')
                        })
                    }
                    vm.dateOpts = {
                        format: '%Y-%m-%d',
                        onSelect: function (date, formatDate, format) {
                            mvvm.EndDate = formatDate;
                        }
                    }
                    vm.clear = function () {
                        mvvm.entity = searchMode;
                    }

                    vm.itemClick = function (e, item, label, val) {
                        $(this).attr('class', 'selected').siblings().removeClass('selected');
                        mvvm.entity.$model[label] = val || item.Id;
                        mvvm.entity.$model.newInit = '1';
                    }
                    vm.itemBack = function (e, item, label, val) {
                        $(this).attr('class', 'selected').siblings().removeClass('selected');
                        mvvm.entity.$model[label] = val || item.Parent;
                        mvvm.entity.$model.newInit = '1';
                    }
                });

                getDataList();

                function getDataList() {
                    $.get('/Report/ProductCategory', searchMode, function (result) {
                        mvvm.dataList = result.data.list;
                        mvvm.total = result.data.total;
                        mvvm.nowCat = result.data.nowCat;
                        mvvm.list_cat = result.data.list_cat;
                        createColumnChart(result.data.list_chart, 'chartId', '90%', '360')
                    })
                }

                mvvm.entity = searchMode;
                CBCRM.fillContent(tmpl, lang, contentId, module, mvvm);
                CBCRM.onLoadModuleBefore = function () {
                    avalon.vmodels.Index = null
                }
            },

            //产品品牌统计
            ProductBrand: function (tmpl, lang, contentId, module) {
                var CBCRM = avalon.vmodels.CBCRM
                var mvvm = avalon.define('ProductBrand', function (vm) {
                    vm.dataList = [];
                    vm.list_chart = [];
                    vm.entity = {};
                    vm.show = 0;
                    vm.total = 0;
                    vm.search = function () {
                        $.get('/Report/ProductBrand', mvvm.entity.$model, function (result) {
                            mvvm.dataList = result.data.list;
                            mvvm.total = result.data.total;
                            createColumnChart(result.data.list_chart, 'chartId', '90%', '360')
                        })
                    }
                    vm.clear = function () {
                        mvvm.entity = searchMode;
                    }
                });

                getDataList();

                function getDataList() {
                    $.get('/Report/ProductBrand', searchMode, function (result) {
                        mvvm.dataList = result.data.list;
                        mvvm.list_chart = result.data.list_chart;
                        mvvm.total = result.data.total;
                        createColumnChart(mvvm.list_chart, 'chartId', '90%', '360');
                    })
                }

                mvvm.entity = searchMode;
                CBCRM.fillContent(tmpl, lang, contentId, module, mvvm);
                CBCRM.onLoadModuleBefore = function () {
                    avalon.vmodels.Index = null;
                }
            },

            //产品销量前十
            ProductTopBuy: function (tmpl, lang, contentId, module) {
                var CBCRM = avalon.vmodels.CBCRM
                var mvvm = avalon.define('ProductTopBuy', function (vm) {
                    vm.dataList = [];
                    vm.list_cat = [];
                    vm.nowCat = [];
                    vm.entity = {};
                    vm.show = 0;
                    vm.total = 0;
                    vm.search = function () {
                        $.get('/Report/ProductTopBuy', mvvm.entity.$model, function (result) {
                            mvvm.dataList = result.data.list;
                            mvvm.total = result.data.total;
                            mvvm.nowCat = result.data.nowCat;
                            mvvm.list_cat = result.data.list_cat;
                            createColumnChart(result.data.list_chart, 'chartId', '90%', '360')
                        })
                    }
                    vm.dateOpts = {
                        format: '%Y-%m-%d',
                        onSelect: function (date, formatDate, format) {
                            mvvm.EndDate = formatDate;
                        }
                    }
                    vm.clear = function () {
                        mvvm.entity = searchMode;
                    }

                    vm.itemClick = function (e, item, label, val) {
                        $(this).attr('class', 'selected').siblings().removeClass('selected');
                        mvvm.entity.$model[label] = val || item.Id;
                    }
                    vm.itemBack = function (e, item, label, val) {
                        $(this).attr('class', 'selected').siblings().removeClass('selected');
                        mvvm.entity.$model[label] = val || item.Parent;
                    }
                });

                getDataList();

                function getDataList() {
                    $.get('/Report/ProductTopBuy', searchMode, function (result) {
                        mvvm.dataList = result.data.list;
                        mvvm.total = result.data.total;
                        mvvm.nowCat = result.data.nowCat;
                        mvvm.list_cat = result.data.list_cat;
                        createColumnChart(result.data.list_chart, 'chartId', '90%', '360')
                    })
                }

                mvvm.entity = searchMode;
                CBCRM.fillContent(tmpl, lang, contentId, module, mvvm);
                CBCRM.onLoadModuleBefore = function () {
                    avalon.vmodels.Index = null
                }
            },

            //产品贡献收入金额前十
            ProductTopMoney: function (tmpl, lang, contentId, module) {
                var CBCRM = avalon.vmodels.CBCRM
                var mvvm = avalon.define('ProductTopMoney', function (vm) {
                    vm.dataList = [];
                    vm.list_cat = [];
                    vm.nowCat = [];
                    vm.entity = {};
                    vm.show = 0;
                    vm.total = 0;
                    vm.search = function () {
                        $.get('/Report/ProductTopMoney', mvvm.entity.$model, function (result) {
                            mvvm.dataList = result.data.list;
                            mvvm.total = result.data.total;
                            mvvm.nowCat = result.data.nowCat;
                            mvvm.list_cat = result.data.list_cat;
                            createColumnChart(result.data.list_chart, 'chartId', '90%', '360')
                        })
                    }
                    vm.dateOpts = {
                        format: '%Y-%m-%d',
                        onSelect: function (date, formatDate, format) {
                            mvvm.EndDate = formatDate;
                        }
                    }
                    vm.clear = function () {
                        mvvm.entity = searchMode;
                    }

                    vm.itemClick = function (e, item, label, val) {
                        $(this).attr('class', 'selected').siblings().removeClass('selected');
                        mvvm.entity.$model[label] = val || item.Id;
                    }
                    vm.itemBack = function (e, item, label, val) {
                        $(this).attr('class', 'selected').siblings().removeClass('selected');
                        mvvm.entity.$model[label] = val || item.Parent;
                    }
                });

                getDataList();

                function getDataList() {
                    $.get('/Report/ProductTopMoney', searchMode, function (result) {
                        mvvm.dataList = result.data.list;
                        mvvm.total = result.data.total;
                        mvvm.nowCat = result.data.nowCat;
                        mvvm.list_cat = result.data.list_cat;
                        createColumnChart(result.data.list_chart, 'chartId', '90%', '360')
                    })
                }

                mvvm.entity = searchMode;
                CBCRM.fillContent(tmpl, lang, contentId, module, mvvm);
                CBCRM.onLoadModuleBefore = function () {
                    avalon.vmodels.Index = null
                }
            },

            //产品被投诉前十
            ProductTopComplain: function (tmpl, lang, contentId, module) {
                var CBCRM = avalon.vmodels.CBCRM
                var mvvm = avalon.define('ProductTopComplain', function (vm) {
                    vm.dataList = [];
                    vm.list_cat = [];
                    vm.nowCat = [];
                    vm.entity = {};
                    vm.show = 0;
                    vm.total = 0;
                    vm.search = function () {
                        $.get('/Report/ProductTopComplain', mvvm.entity.$model, function (result) {
                            mvvm.dataList = result.data.list;
                            mvvm.total = result.data.total;
                            mvvm.nowCat = result.data.nowCat;
                            mvvm.list_cat = result.data.list_cat;
                            createColumnChart(result.data.list_chart, 'chartId', '90%', '360')
                        })
                    }
                    vm.dateOpts = {
                        format: '%Y-%m-%d',
                        onSelect: function (date, formatDate, format) {
                            mvvm.EndDate = formatDate;
                        }
                    }
                    vm.clear = function () {
                        mvvm.entity = searchMode;
                    }

                    vm.itemClick = function (e, item, label, val) {
                        $(this).attr('class', 'selected').siblings().removeClass('selected');
                        mvvm.entity.$model[label] = val || item.Id;
                    }
                    vm.itemBack = function (e, item, label, val) {
                        $(this).attr('class', 'selected').siblings().removeClass('selected');
                        mvvm.entity.$model[label] = val || item.Parent;
                    }
                });

                getDataList();

                function getDataList() {
                    $.get('/Report/ProductTopComplain', searchMode, function (result) {
                        mvvm.dataList = result.data.list;
                        mvvm.total = result.data.total;
                        mvvm.nowCat = result.data.nowCat;
                        mvvm.list_cat = result.data.list_cat;
                        createColumnChart(result.data.list_chart, 'chartId', '90%', '360')
                    })
                }

                mvvm.entity = searchMode;
                CBCRM.fillContent(tmpl, lang, contentId, module, mvvm);
                CBCRM.onLoadModuleBefore = function () {
                    avalon.vmodels.Index = null
                }
            },

            // 财务记账类型统计
            FinancialAccountingTally: function (tmpl, lang, contentId, module) {
                var CBCRM = avalon.vmodels.CBCRM
                var mvvm = CBCRM.define('FinancialAccountingTally', function (vm) {
                    vm.destroy = function () {

                    }
                    vm.dataList = [];//数据列表
                    //vm.dataHeader = []; //数据表头
                    vm.category = [];//条件
                    vm.entity = {};
                    vm.resetEntity = function () {
                        mvvm.entity = {
                            startTime: new Date().getFullYear() + '-1-1', //开始时间
                            endTime: GetDateTimeYMD(),//结束时间
                            typeid: 0,
                            empScope: 0,
                            UserIds: '',
                            UserIdName: ''
                        };
                        mvvm.entity.$watch("empScope", function (n,o) {
                            if (n == 0) {
                                mvvm.entity.UserIds = '';
                                mvvm.entity.UserIdName = '';
                            }
                        });
                    }
                    vm.hide = 0;//显示值
                    vm.total = 0;//总值
                    vm.receiveAmount = 0;
                    vm.expenseAmount = 0;
                    vm.transferAmount = 0;
                    vm.search = function () {
                        getDataList();
                    }
                    vm.radioChart = function (type) {
                        getDataList();
                    }


                    vm.dateOpts = {
                        format: '%Y-%m-%d',
                        onSelect: function (date, formatDate, format) {
                            mvvm.entity.startTime = formatDate;
                        }
                    }
                    vm.dateOpts1 = {
                        format: '%Y-%m-%d',
                        onSelect: function (date, formatDate, format) {
                            mvvm.entity.endTime = formatDate;
                        }
                    }
                    vm.clear = function () {
                        mvvm.resetEntity();
                        getDataList();
                    }
                    vm.selectUsers = function () {
                        var listData = (mvvm.entity.UserIds || "").split(",");
                        plugins.selectUser({
                            dataAuth: 104000000,
                            multiple: true,
                            listData:listData,
                            callback: function (us) {
                                mvvm.entity.UserIds = where(us, true, "Id").join(",");
                                mvvm.entity.UserIdName = where(us, true, "FullName").join(",");
                            }
                        });
                    }
                });
                function init() {
                    mvvm.resetEntity();
                    getDataList();
                }
                function getDataList() {
                    $.get('/Report/FinancialAccountingTally', mvvm.entity.$model, function (ret) {
                        if (!ret.result) {
                            return CBCRM.showResult(ret)
                        }
                        mvvm.dataList = ret.data.tableData;

                        createColumnChart2(ret.data.chartData1, 'chartId', '700', '300')
                    })
                }
                init();
                CBCRM.fillContent(tmpl, lang, contentId, module, mvvm);
            },

            // 财务项目类型统计
            FinancialAccountingItem: function (tmpl, lang, contentId, module) {
                var CBCRM = avalon.vmodels.CBCRM
                var mvvm = CBCRM.define('FinancialAccountingItem', function (vm) {
                    vm.dataList = {};//收入数据列表
                    vm.dataList2 = {}; //支出数据列表
                    vm.category = [];//条件
                    vm.entity = {};//查询条件
                    vm.resetEntity = function () {
                        mvvm.entity = {
                            startTime: new Date().getFullYear() + '-1-1', //开始时间
                            endTime: GetDateTimeYMD(),//结束时间
                            typeid: 0,
                            empScope: 0,
                            UserIds: '',
                            UserIdName: ''
                        };
                        mvvm.entity.$watch("empScope", function (n, o) {
                            if (n == 0) {
                                mvvm.entity.UserIds = '';
                                mvvm.entity.UserIdName = '';
                            }
                        });
                    }
                    vm.show = 0;//显示值
                    vm.hide = 0;//显示值
                    vm.total = 0;//总值
                    vm.receiveAmount = 0;
                    vm.expenseAmount = 0;
                    vm.search = function () {
                        getDataList();
                    }

                    vm.dateOpts = {
                        format: '%Y-%m-%d',
                        onSelect: function (date, formatDate, format) {
                            mvvm.entity.startTime = formatDate;
                        }
                    }
                    vm.dateOpts1 = {
                        format: '%Y-%m-%d',
                        onSelect: function (date, formatDate, format) {
                            mvvm.entity.endTime = formatDate;
                        }
                    }

                    vm.selectUsers = function () {
                        var listData = (mvvm.entity.UserIds || "").split(",");
                        plugins.selectUser({
                            dataAuth: 104000000,
                            multiple: true,
                            listData: listData,
                            callback: function (us) {
                                mvvm.entity.UserIds = where(us, true, "Id").join(",");
                                mvvm.entity.UserIdName = where(us, true, "FullName").join(",");
                            }
                        });
                    }
                    
                    vm.clear = function () {
                        mvvm.resetEntity();
                        getDataList();
                    }

                    vm.UserGroupTreeOpts = {
                        treeopts: {
                            check: {
                                enable: true,
                                chkboxType: { "Y": "s", "N": "s" },
                            },

                            callback: {
                                onCheck: function (event, treeId, treeNode) {

                                    tree = $.fn.zTree.getZTreeObj(treeId),

                                    names = [],
                                    ids = [],
                                    nodes = tree.getCheckedNodes(true)
                                    nodes.forEach(function (n, i) {
                                        names.push(n.Name)
                                        ids.push(n.Id)
                                    })
                                    mvvm.entity.$model.UserIds = ids.join(',').toString();
                                    mvvm.entity.UserIdName = names.join('，').toString()
                                }
                            },
                            async: {
                                url: function (treeId, treeNode) {
                                    return "/Settings/GetGroupPostUser/104000000/"
                                },
                                dataFilter: notMemberFilter
                            }

                        }
                    }
                });

                getDataList();
                function getDataList() {
                    if (!mvvm.entity.startTime)
                        mvvm.entity.startTime = (new Date()).getFullYear() + '-1-1';

                    $.get('/Report/FinancialAccountingItem', mvvm.entity.$model, function (ret) {
                        if (!ret.result) {
                            return CBCRM.showResult(ret)
                        }
                        mvvm.receiveAmount = ret.data.receiveAmount;
                        mvvm.expenseAmount = ret.data.expenseAmount;
                        mvvm.dataList = ret.data.tableData1;
                        mvvm.dataList2 = ret.data.tableData2;

                        createColumnChart2(ret.data.chartData1, 'chartId', '700', '300')
                        createColumnChart2(ret.data.chartData2, 'chartId2', '700', '300')
                    })
                }
                function init() {
                    mvvm.resetEntity();
                    getDataList();
                }
                init();
                CBCRM.fillContent(tmpl, lang, contentId, module, mvvm);
            },


            // 财务项目类型统计
            FinancialAccountingType: function (tmpl, lang, contentId, module) {
                var CBCRM = avalon.vmodels.CBCRM
                var mvvm = CBCRM.define('FinancialAccountingType', function (vm) {
                    vm.dataList = {};//收入数据列表
                    vm.dataList2 = {}; //支出数据列表
                    vm.category = [];//条件
                    vm.entity = {};//查询条件
                    vm.resetEntity = function () {
                        mvvm.entity = {
                            startTime: new Date().getFullYear() + '-1-1', //开始时间
                            endTime: GetDateTimeYMD(),//结束时间
                            typeid: 0,
                        };
                    }
                    vm.show = 0;//显示值
                    vm.hide = 0;//显示值
                    vm.total = 0;//总值
                    vm.receiveAmount = 0;
                    vm.expenseAmount = 0;
                    vm.balanceAmount = 0;
                    vm.search = function () {
                        getDataList();
                    }

                    vm.dateOpts = {
                        format: '%Y-%m-%d',
                        onSelect: function (date, formatDate, format) {
                            mvvm.entity.startTime = formatDate;
                        }
                    }
                    vm.dateOpts1 = {
                        format: '%Y-%m-%d',
                        onSelect: function (date, formatDate, format) {
                            mvvm.entity.endTime = formatDate;
                        }
                    }

                    vm.clear = function () {
                        mvvm.resetEntity();
                        getDataList();
                    }
                });

                getDataList();
                function getDataList() {
                    if (!mvvm.entity.startTime)
                        mvvm.entity.startTime = (new Date()).getFullYear() + '-1-1';

                    $.get('/Report/FinancialAccountingType', mvvm.entity.$model, function (ret) {
                        if (!ret.result) {
                            return CBCRM.showResult(ret)
                        }

                        var array2 = ret.data.chartData2.dataset[0];
                        var array3 = ret.data.chartData2.dataset[1];
                        var categories2 = ret.data.chartData2.categories[0];
                        mvvm.receiveAmount = ret.data.receiveAmount;
                        mvvm.expenseAmount = ret.data.expenseAmount;
                        mvvm.balanceAmount = ret.data.balanceAmount;

                        mvvm.dataList = ret.data.tableData1;

                        dataList2 = [];
                        for (var i = 0; i < array2.data.length; i++) {
                            var item = array2.data[i];
                            var item3 = array3.data[i];
                            var category = categories2.category[i];
                            dataList2[i] = new Array();
                            dataList2[i].push(category.label);
                            dataList2[i].push(item.value);
                            if (item.value == 0)
                                dataList2[i].push("0%");
                            else
                                dataList2[i].push((item.value * 100 / (item.value + item3.value)).toFixed(2) + "%");
                            dataList2[i].push(item3.value);
                            if (item3.value == 0)
                                dataList2[i].push("0%");
                            else
                                dataList2[i].push((item3.value * 100 / (item.value + item3.value)).toFixed(2) + "%");
                            var diffrence = item.value - item3.value;
                            dataList2[i].push(diffrence);
                        }
                        mvvm.dataList2 = dataList2;

                        createPieChart(ret.data.pieChartData, 'chartId', '700', '300')
                        createColumnChart2(ret.data.chartData2, 'chartId2', '700', '300')
                    })
                }
                function init() {
                    mvvm.resetEntity();
                    getDataList();
                }

                init();
                CBCRM.fillContent(tmpl, lang, contentId, module, mvvm);
            },

        }
        return Report;
    });