﻿define('Upload', ['upload', 'dialog', 'common', 'json', 'cookie'], function (up, jq) {
    var Upload = {
        Center: function (tmpl, lang, contentId, module) {
            var CBCRM = avalon.vmodels.CBCRM;
            var that = this;
            var path = document.location.href.toLocaleLowerCase();
            var vm = avalon.define('upload', function (scope) {
                scope.array = [];
                scope.$curArray = [];
                scope.returnOnQueueComplete = false;
                scope.lang = lang;
                scope.DELETE = false;
                scope.UPLOAD = false;
                scope.$userSettings = {};
                scope.settings = function (settings) {
                    vm.$userSettings = settings || {};
                }
                scope.delFile = function (node, data, fileItem) {
                    if (confirm(vm.lang.delFileConfirm)) {
                        $.get('/Upload/Delete/' + data.id, {}, function (ret) {
                            if (!ret.result)
                                avalon.vmodels.CBCRM.showResult(ret)
                            else vm.array.removeAt(parseInt(data.index, 10))
                        })
                    }
                }

                scope.clickProxy = function (e) {
                    var target = avalon(e.target),
                        data = target.data(),
                        call = vm[data.call] || '',
                        cur = vm.array[data.index].$model

                    if (call) {
                        call(target, data, cur)
                    } else {
                        vm.itemSelected(target, data, vm.$userSettings.multi ? [cur] : cur);
                    }
                }
                scope.itemSelected = function (node, data, fileItem) {
                    avalon.log('node : avalon(node) data : avalon(node).data fileItem : 选中的文件对象');
                }

            })
            if (path.indexOf("/upload/") > -1) {
                avalon.vmodels.CBCRM.fillContentBefore = function (tmpl, lang, contentId, module, vmodel) {
                    var content = $("#right");
                    if (content.length == 0) return true;
                    content.html(tmpl);
                    avalon.scan(content[0]);
                    return false;
                }
            }
            avalon.vmodels.CBCRM.fillContent(tmpl, lang, contentId, module, vm)
            avalon.vmodels.CBCRM.onLoadModuleBefore = function () {
                delete avalon.vmodels.upload
            }

            var settingUpload = function (data) {
                if (avalon.vmodels.CBCRM.$debug)
                    avalon.log($.cookie('MySession'))
                var ops = {
                    formData: { 'timestamp': data.timestamp, 'token': data.token, 'MySession': $.cookie('MySession') },
                    swf: '/Scripts/Uploadify/uploadify.swf',
                    uploader: '/Upload/Start/',
                    queueID: 'fileQueue',
                    fileSizeLimit: (data.fileSize || '4') + 'MB',
                    fileDataName: 'Filedata',
                    fileTypeDesc: 'Image Files',
                    fileTypeExts: data.fileExt || '*.gif; *.jpg; *.png; *.bmp; *.doc; *.docx; *.xls; *.xlsx; *.txt; *.rar; *.zip',
                    buttonText: vm.lang.uploadButtonText,
                    onUploadSuccess: function (file, data, response) {//单个文件上传成功
                        var ret = JSON.parse(data);
                        if (ret.error > 0) return messageBox.error(ret.message);
                        vm.$curArray.push(ret.model)
                    },
                    onQueueComplete: function () {//队列全部完成
                        if (!vm.returnOnQueueComplete) getFileList();
                        else {
                            if (vm.$curArray.length == 0) return;
                            vm.itemSelected(null, null, vm.$userSettings.multi ? vm.$curArray : vm.$curArray[0]);
                        }
                    },
                    onUploadError: function (file, code, msg, str) {//异常
                        avalon.log('onUploadError，file :  ' + file + ' code : ' + code + ' msg : ' + msg
                            + ' str : ' + str)
                    }
                }
                if (vm.$userSettings) $.extend(ops, vm.$userSettings);
                $('#file_upload').uploadify(ops);
            }

            $.post('/Upload/Token/', {}, function (data) {
                settingUpload(data);
            });

            typeSelect = function (val) {
                switch (val) {
                    case "txt": return "typeTxt"; break;
                    case "xls": return "typeExcel"; break;
                    case "xlsx": return "typeExcel"; break;
                    case "doc": return "typeDoc"; break;
                    case "docx": return "typeDoc"; break;
                    case "rar": return "typeRar"; break;
                    case "zip": return "typeZip"; break;
                }
            }

            imageShow = function (fileType) {
                return (fileType == 'jpg' || fileType == 'gif' || fileType == 'bmp' || fileType == 'png')
            }

            function getFileList() {
                var data = {};
                if (path.indexOf("/upload/") > -1) {
                    data.onlyMe = false;
                }
                $.get('/Upload/Center/', data, function (ret) {
                    if (!ret || !ret.result) return;
                    vm.DELETE = ret.DELETE;
                    vm.UPLOAD = ret.UPLOAD;
                    vm.array = ret.data;
                });
            };
            getFileList();

            var $hengWarp = $('.hengWarp li');
            //绑定鼠标移进移出事件
            $hengWarp.live({
                mouseover: function () {
                    $(this).css({ 'border': '1px solid #c9c9c9' });
                    $(this).find('.delFile').show();
                },
                mouseleave: function () {
                    $(this).css({ 'border': '1px solid #fff' });
                    $(this).find('.delFile').hide();
                }
            });
        }
    }
    return Upload
})