/**
 * The Javascript For The Module Calendar
 * calendar.js 2012-12-18
 * 
 */
/* common */
function _id(id) {
    return (document.getElementById(id))
}
//周期性按钮组与对应的checkbox联动
function linkageBtn(btnEl, cBoxEl){
    var oBtn = btnEl;
    var oBox = cBoxEl || oBtn.next();
    if(oBox.attr("checked")){
        oBtn.addClass("active");
    }else{
        oBtn.removeClass("active");
    }
    oBtn.off("click").on("click", function(){
        if($(this).hasClass("active")){
            oBox.attr("checked", false);
        }else{
            oBox.attr("checked", true);
        }
    })
}

//加载颜色模块函数
function StrFormatNoEncode(temp, dataarry) { 
    return temp.replace(/\{([\d]+)\}/g,function(s1, s2) {
        var s = dataarry[s2];
        if (typeof (s) != "undefined") {
            if (s instanceof (Date)) {
                return s.getTimezoneOffset();
            } else {
                return (s);
            }
        } else {
            return "";
        }
    });
}

/*
 *点击输入框删除对应字符，焦点离开则显示
 *@param elementid 元素ID
 *@param str 删除的字符-输入框里面的字符必需全等于这个字符串才会被删除
 */
function focuschanstr(elementid,str){
    var eobj = _id(elementid);
    eobj.onfocus = function(){
        eobj.style.color = ''; //颜色为默认
        if(eobj.value == str){ //如果等于传进的字符串
            eobj.value = '';
        }
    }
    eobj.onblur = function(){
        eobj.style.color = '#888'; //颜色灰
        if(eobj.value == ''){ //如果等于空
            eobj.value = str; //显示传进的字符串
        }   
    }
}
//切换显示周期性删除
function switchdel(isshow){
    if(isshow){
        $('#bubbleContent1').show(); //@dlh 显示原始界面
        $('#prong2').show();
        $('#bbit-del-buddle').hide();
    }else{      
        $('#bubbleContent1').hide(); //@dlh 显示周期性删除界面
        $('#prong2').hide();
        $('#bbit-del-buddle').show();
    }
}

//完成日程
function finishstatus(type){
    switch(type){
        case 0:
            $('#bbit-nofinish-btn').hide();
            $('#bbit-finish-btn').show();
            if($("#bbit-cs-what").parent().parent().attr('id')=="isfinish"){ //去除删除线
                $("#bbit-cs-what").parent().unwrap();
            }
            $("#cb-finish-msg").html('');
            break;
        case 1:
            $('#bbit-finish-btn').hide(); //完成按钮
            $('#bbit-nofinish-btn').show(); //未完成按钮
            $("#bbit-cs-what").parent().wrap('<del id="isfinish"></del>'); //增加删除线
            $("#cb-finish-msg").html('<i class="cb-finish">&nbsp;</i>已完成').show(); //显示完成状态
            break;
        case 2: //初始化状态
            $("#cb-finish-msg").html('');
            if($("#bbit-cs-what").parent().parent().attr('id')=="isfinish"){ //去除删除线
                $("#bbit-cs-what").parent().unwrap();
            }
            break;
    }
}

function show_window(_title,_url){
    $("#append_parent").iDialog({title:_title,href:_url});
}

//切换是否周期性日程
function a_c_setcycleopen(){
    _id('a_c_setday').style.display = 'none'; //id是设置第几天的元素
    _id('a_c_tb').style.display = 'block'; //id是设置周期的表格元素
}
function a_c_setcycleclose(){
    _id('a_c_tb').style.display = 'none';
    _id('a_c_setday').style.display = 'block';
}
//切换周期类型
function selectchange(ele){
    var value = $(ele).val();
    $("#repeat_per_"+value).show().siblings().hide()
}

/**
 * 当下属的下属的下拉框的焦点失去后，将调用这个方法，将下拉框的选项值重新指定了初始的默认值
 */
function resetselectValue(upuid) {
    var first_select = $("#first_option_" +upuid ).html();
    //        alert(first_select);
    $("#underunderlingselect_" +upuid ).html(first_select);
}

//切换显示、隐藏下属的下属的下拉列表
function switch_show_uul(selectid){
    //getunderunderling (upuid);
    $("#" + selectid ).slideToggle();
//        var uul_select = document.getElementById(selectid);
//        if(uul_select.style.display == "none" ){
//            uul_select.style.display = "";
//            $("#"+selectid).slideDown();
//        }else if(uul_select.style.display == "" ){
//            uul_select.style.display = "none";
//            $("#"+selectid).slideUp();
//        }
}