﻿function ChangeLang(ob, lang)
{
	if (typeof(ob.OldLang) == "undefined")
	    ob.OldLang = "CHS";
    
	ob.className = ob.className.replace(lang, ob.OldLang);
	ob.OldLang = lang;
	
	if ((ob.tagName == "INPUT" && ob.type == "text") || (ob.tagName == "TEXTAREA" ))
	{
		ob.value = "";
		ob.blur();
		ob.focus();
	}
}

function SetupIme()
{
	var inputs = document.getElementsByTagName("INPUT");
	var tas = document.getElementsByTagName("TEXTAREA");
	var len = inputs.length + tas.length;
	for (var i = 0; i < len; i++)
	{
		var tag = i < inputs.length ? inputs[i] : tas[i - inputs.length];
		if (!tag.className.match(/(UYG|KZA|KGA)Font/))
			continue;

		if (navigator.userAgent.match(/android/i))
		{
			tag.addEventListener("focus", function(){this.value = Uyg2Uyl(this.value);}, false); 
			tag.addEventListener("blur", function(){this.value = Uyl2Uyg(this.value);}, false); 
			tag.style.direction = "ltr";
			tag.style.textAlign = "center";
		}
		else
		{
			if (window.addEventListener)
			{ 
				tag.removeEventListener("keydown", OnEdit, false);
				tag.removeEventListener("keypress", OnEdit, false);

				tag.addEventListener("keydown", OnEdit, false); 
				tag.addEventListener("keypress", OnEdit, false); 
			} 
			else
			{
				tag.detachEvent("onkeydown", OnEdit);
				tag.attachEvent("onkeydown", OnEdit); 
	
				tag.detachEvent("onkeypress", OnEdit);
				tag.attachEvent("onkeypress", OnEdit);
			}
		}
	}
}

function OnEdit()
{
	var e;
	var browser = "IE";
	if (navigator.userAgent.indexOf("Gecko") != -1)
	{
		/*
		//判断是否是dispatchEvent调的
		var caller = arguments.callee.caller;
		if (caller != null && caller.caller != null && caller.caller.name == "OnEdit")
			return true;
		*/

		e = arguments[0] || OnEdit.caller.arguments[0];
		browser = navigator.userAgent.indexOf('WebKit') != -1 ? 'Ch' : 'FF';
	}
	else
	{
		e = window.event || arguments[0].event || arguments[0];
	}
	
	
    var lang = "CHS";
    var ob = e.srcElement || e.target;
    if (ob.tagName == "BODY" || ob.tagName == "HTML")//HtmlEditor
    {
        lang = ob.lang;
    }
	else
	{
	    if (ob.className.indexOf("UYG") != -1)
	        lang = "UYG";
	    else if (ob.className.indexOf("KZA") != -1)
	        lang = "KZA";
	    else if (ob.className.indexOf("KGA") != -1)
	        lang = "KGA";
	}
	
	if (e.type == "keydown")
	{
		var code = e.keyCode | e.which;
		if (code == 113)
		{
			if (e.ctrlKey)
			{//CTRL+F2
			    ChangeLang(ob, lang);
			    ob.English = false;
			}
			else
			{//F2
			    ob.English = !ob.English;
			}
		}
		else if (e.ctrlKey && code == 75)//ctrl + k
		{
			ob.English = !ob.English;
			if (browser == "IE")
				e.returnValue = false;
			else
				e.preventDefault();
		}
		else if (e.ctrlKey && code == 85)//ctrl+u
		{
			ob.value = Uyl2Uyg(ob.value);
			if (browser == "IE")
				e.returnValue = false;
			else
				e.preventDefault();
		}
		else if (e.ctrlKey && code == 76)//ctrl+l
		{
			ob.value = Uyg2Uyl(ob.value);
			if (browser == "IE")
				e.returnValue = false;
			else
				e.preventDefault();
		}
	}
	else if (lang != "CHS" && !ob.English)
	{
		var code = browser == "IE" ? e.keyCode : e.charCode;
		if (code == 0 || e.ctrlKey)
			return true;

		code = Map(lang, code);
		if (browser == "IE")
		{
			if (ob.tagName == "INPUT" || ob.tagName == "TEXTAREA")
			{
				e.keyCode = code;
			}
			else
			{
				var selection = ob.ownerDocument.selection;
				var range = selection.createRange ? selection.createRange() : selection.getRangeAt(0);
				range.text = String.fromCharCode(code);
				range.collapse(false);
				range.select();
				e.preventDefault();
			}
		}
		else if (browser == "FF")
		{
			if (ob.tagName == "INPUT" || ob.tagName == "TEXTAREA")
			{
				var start  = ob.selectionStart;
				var end  = ob.selectionEnd;
			
				var top, left;
				if (ob.type == "textarea" && typeof(ob.scrollTop) != "undefined")
				{
					top = ob.scrollTop;
					left = ob.scrollLeft;
				}
			
				ob.value = ob.value.substring (0, start) + String.fromCharCode(code) + ob.value.substr(end);
			
				if (typeof(top) != "undefined")
				{
					ob.scrollTop = top;
					ob.scrollLeft = left;
				}
			
				ob.setSelectionRange(start + 1, start + 1);
			}
			else
			{
				var selection = ob.ownerDocument.getSelection();
				var range = selection.createRange ? selection.createRange() : selection.getRangeAt(0);
				var node = ob.ownerDocument.createTextNode(String.fromCharCode(code));
				range.deleteContents();
				range.insertNode(node);
				range.collapse(false);
			}
			e.preventDefault();
		}
		else
		{
			if (window.TextEvent)
			{
				var keyEvent = document.createEvent("TextEvent");
				keyEvent.initTextEvent("textInput", true, true, null, String.fromCharCode(code));
				e.preventDefault();
				ob.dispatchEvent(keyEvent);
			}
			else if (window.KeyEvent)
			{
				var keyEvent = document.createEvent("KeyEvents");
				keyEvent.initKeyEvent("keypress", true, false, null, false, false, false, false, 0, code);
				e.preventDefault();
				ob.dispatchEvent(keyEvent);
			}
		}
	}
	return true;
}

function Map(lang, code)
{
	switch(code)
	{
		case 97: //a
			return 0X06BE;//v
		case 65: //A
			return 0;
		case 98: //b
			return 0X0628;//b
		case 66: //B
			return 0;
		case 99: //c
			if (lang == "UYG")
				return 0X063A;//gh
			else if (lang == "KZA" || lang == "KGA")
				return 0X0639;//gh
		case 67: //C
			return 0;
		case 100: //d
			return 0X062F;//d
		case 68: //D
			if (lang == "UYG")
				return 0X0698;//zj
		case 101: //e
			return 0X06D0;//e
		case 69: //E
			return 0;
		case 102: //f
			return 0X0627;//a
		case 70: //F
			if (lang == "UYG" || lang == "KGA")
				return 0X0641;//f
		case 103: //g
			return 0X06D5;//ae
		case 71: //G
			return 0X06AF;//g
		case 104: //h
			return 0X0649;//i
		case 72: //H
			if (lang == "UYG")
				return 0X062E;//h
			else if (lang == "KZA" || lang == "KGA")
				return 0X062D;//h
		case 105: //i
			return 0X06AD;//ng
		case 73: //I
			return 0;
		case 106: //j
			return 0X0642;//kh
		case 74: //J
			return 0X062C;//j
		case 107: //k
			return 0X0643;//k
		case 75: //K
			if (lang == "UYG")
				return 0X06C6;//oe
			else if (lang == "KGA")
				return 0X06C5;//oe
		case 108: //l
			return 0X0644;//l
		case 76: //L
			return 0;
		case 109: //m
			return 0X0645;//m
		case 77: //M
			return 0;
		case 110: //n
			return 0X0646;//n
		case 78: //N
			return 0;
		case 111: //o
			return 0X0648;//o
		case 79: //O
			return 0;
		case 112: //p
			return 0X067E;//p
		case 80: //P
			return 0;
		case 113: //q
			return 0X0686;//q
		case 81: //Q
			return 0;
		case 114: //r
			return 0X0631;//r
		case 82: //R
			return 0;
		case 115: //s
			return 0X0633;//s
		case 83: //S
			return 0;
		case 116: //t
			return 0X062A;//t
		case 84: //T
			return 0;
		case 117: //u
			return 0X06C7;//u
		case 85: //U
			return 0;
		case 118: //v
			if (lang == "UYG")
				return 0X06C8;//ue
			else if (lang == "KZA")
				return 0X06C6;//ue
			else if (lang == "KGA")
				return 0X06C9;//ue
		case 86: //V
			return 0;
		case 119: //w
			return 0X06CB;//w
		case 87: //W
			return 0;
		case 120: //x
			return 0X0634;//x
		case 88: //X
			return 0;
		case 121: //y
			return 0X064A;//y
		case 89: //Y
			return 0;
		case 122: //z
			return 0X0632;//z
		case 90: //Z
			return 0;
		case 44: //,
			return 0X060C;//逗号
		case 62: //>
			return 0X003C;
		case 41: //)
			return 0X0028;
		case 60: //>
			return 0X003E;
		case 40: //(
			return 0X0029;
		case 47: ///
			if (lang == "UYG")
				return 0X0626;//Hamza
			else if (lang == "KZA" || lang == "KGA")
				return 0X0621;//Hamza
		case 63: //?
			return 0X061F;//问号
		case 59: //;
			return 0X061B;//分号
		case 39: // '
			return 0X002C;
		case 34: //"
			return 0X0022;
		case 91: //[
			return 0X005D;
		case 123: //{
			return 0X007D;
		case 93: //]
			return 0X005B;
		case 125: //}
			return 0X007B;
	}
	
	return code;
}

var _uyl, _uyg;
function InitMap()
{
	_uyg = ['ا', 'ە', 'ب', 'پ', 'ت', 'ج', 'چ', 'خ', 'د', 'ر', 'ز', 'ژ', 'ش', 'س', 'ف', 'ق', 'ك', 'ن', 'غ', 'ڭ', 'گ', 'ل', 'م', 'ھ', 'و', 'ۇ', 'ۆ', 'ۈ', 'ۋ', 'ې', 'ى', 'ي', '،', '؟', '؛'];
	_uyl = ["a", "e", "b", "p", "t", "j", "ch", "x", "d", "r", "z", "zh", "sh", "s", "f", "q", "k", "n", "gh", "ng", "g", "l", "m", "h", "o", "u", "ö", "ü", "w", "ë", "i", "y", ",", "?", ";"];
}

function Uyl2Uyg(uyl)
{
	if (_uyl == null)
		InitMap();

	var uyg = "";
	var skip = false;
	uyl = uyl.toLowerCase();
	for (var i = 0; i < uyl.length; i++)
	{
		//不做处理的内容
		if (uyl[i] == '`')
		{
			skip = !skip;
			continue;
		}
		
		if (skip)
		{
			uyg += uyl[i];
			continue;
		}
		
		//忽略专为区分双字符的单引号
		if (uyl[i] == '\'' && i > 0 && i < uyl.length - 1 && ((uyl[i - 1] == 's' && uyl[i + 1] == 'h') || (uyl[i - 1] == 'n' && uyl[i + 1] == 'g') || (uyl[i - 1] == 'g' && uyl[i + 1] == 'h')))
			continue;
		
		//处理hamza
		if (/a|e|o|u|ö|ü|ë|i/.test(uyl[i]) && (i == 0 || /a|e|o|u|ö|ü|ë|[^a-z]/.test(uyl[i - 1])))
			uyg += "ئ";
		
		//处理双字符
		if (i < uyl.length - 1)
		{
			var c = 0;
			if (uyl[i] == 'c' && uyl[i + 1] == 'h')
				c = 'چ';
			else if (uyl[i] == 'g' && uyl[i + 1] == 'h')
				c = 'غ';
			else if (uyl[i] == 'n' && uyl[i + 1] == 'g' && uyl[i + 2] != 'h')
				c = 'ڭ';
			else if (uyl[i] == 's' && uyl[i + 1] == 'h')
				c = 'ش';
			else if (uyl[i] == 's' && uyl[i + 1] == 'z' || uyl[i] == 'z' && uyl[i + 1] == 'h')
				c = 'ژ';
			else if (uyl[i] == 'e' && uyl[i + 1] == 'e')
				c = 'ې';
			else if (uyl[i] == 'o' && uyl[i + 1] == 'e')
				c = 'ۆ';
			else if (uyl[i] == 'u' && uyl[i + 1] == 'e')
				c = 'ۈ';
			
			if (c != 0)
			{
				uyg += c;
				i++;
				continue;
			}
		}
		
		//维文字符
		var j = 0;
		for (; j < _uyl.length; j++)
		{
			if (_uyl[j].length == 2)
				continue;

			if (uyl[i] == _uyl[j][0])
			{
				uyg += _uyg[j];
				break;
			}
		}
		if (j < _uyl.length)
			continue;
		
		//其他字符
		uyg += uyl[i];
	}
	
	return uyg;
}

function Uyg2Uyl(uyg)
{
	if (_uyg == null)
		InitMap();

	var uyl = "";
	for (var i = 0; i < uyg.length; i++)
	{
		if (uyg[i] == 'ئ')
		{
			if (i == 0 || uyg[i - 1] == '،' || uyg[i - 1] == '؟' || uyg[i - 1] == '؛')
				continue;

			var j = 0;
			for (; j < _uyg.length; j++)
			{
				if (uyg[i - 1] == _uyg[j])
				{
					uyl += '\'';
					break;
				}
			}
			
			continue;
		}
		
		if (uyg[i] == 'س' && i + 1 < uyg.length && uyg[i + 1] == 'ھ')
		{
			uyl += "s'h";
			i++;
			continue
		}
		
		if (uyg[i] == 'ن' && i + 1 < uyg.length)
		{
			if (uyg[i + 1] == 'غ')
			{
				uyl += "n'gh";
				i++;
				continue
			}
			else if (uyg[i + 1] == 'گ')
			{
				uyl += "n'g";
				i++;
				continue
			}
		}
		
		if (uyg[i] == 'ڭ' && i + 1 < uyg.length && uyg[i + 1] == 'ھ')
		{
			uyl += "ng'h";
			i++;
			continue
		}
		
		//维文字符
		var j = 0;
		for (; j < _uyg.length; j++)
		{
			if (uyg[i] == _uyg[j])
			{
				uyl += _uyl[j];
				break;
			}
		}
		if (j < _uyg.length)
			continue;
		
		//其他字符
		uyl += uyg[i];
	}
	
	return uyl;
}
