/**
 * @license Copyright (c) 2003-2013, CKSource - Frederico Knabben. All rights reserved.
 * For licensing, see LICENSE.html or http://ckeditor.com/license
 */

CKEDITOR.editorConfig = function(config)
{
	// Define changes to default configuration here. For example:
	config.language = 'zh-cn';
	config.autoUpdateElement = true;
	config.enterMode = CKEDITOR.ENTER_BR;
	config.font_names = 'Arial;Times New Roman;UKIJ Tuz Tom;宋体;楷体;黑体';
	config.toolbar_Full =
	[
		{ name: 'clipboard',   items : [ 'Cut','Copy','Paste','PasteText','PasteFromWord','-','Undo','Redo' ] },
		{ name: 'editing',     items : [ 'Find','Replace','-','SelectAll'] },
		{ name: 'basicstyles', items : [ 'Bold','Italic','Underline','Strike','RemoveFormat' ] },
		{ name: 'paragraph',   items : [ 'NumberedList','BulletedList','-','Outdent','Indent','-','Blockquote','-','JustifyLeft','JustifyCenter','JustifyRight','JustifyBlock','-','BidiLtr','BidiRtl' ] },
		{ name: 'links',       items : [ 'Link','Unlink','Anchor' ] },
		{ name: 'insert',      items : [ 'Image','Flash','Table','HorizontalRule','Smiley','SpecialChar','PageBreak' ] },
		{ name: 'styles',      items : [ 'Format','Font','FontSize' ] },
		{ name: 'colors',      items : [ 'TextColor','BGColor' ] },
		{ name: 'tools',       items : [ 'Maximize', 'ShowBlocks','-','Source' ] }
	];
	config.toolbar_Basic =
	[
		{ name: 'basicstyles', items : [ 'Bold','Italic','TextColor','BGColor' ] },
		{ name: 'paragraph',   items : [ 'NumberedList','BulletedList' ] },
		{ name: 'links',       items : [ 'Link','Unlink' ] },
		{ name: 'insert',      items : [ 'Image','Flash','Table' ] },
		{ name: 'styles',      items : [ 'Format','Font','FontSize' ] },
		{ name: 'tools',       items : [ 'Maximize' ] }
	];
	config.toolbar = 'Full';
};
