$.fn.marquee = function(direction, amount, speed)
{
	var marquee = $(this);
	if(marquee.length == 0)
		return marquee;

	marquee.css("overflow", "hidden");

	var paused = false;
	var left = 0, width, scrollWidth, dir;
	if (direction == "up" || direction == "down")
	{
		dir = "scrollTop";
		width = marquee.height();
	}
	else
	{
		marquee.css("direction", "ltr");
		dir = "scrollLeft";
		width = marquee.width();
	}
	
	function Set(e, html)
	{
		if (direction == "up" || direction == "down")
		{
			marquee.html("<div style=\"padding:" + width + "px 0\">" + html + "</div>");
			scrollWidth = marquee[0].scrollHeight;
		}
		else
		{
			marquee.html("<div style=\"float:left;white-space:nowrap;padding:0 " + width + "px\">" + html + "</div>");
			scrollWidth = marquee[0].scrollWidth;
		}
	}
	function Run()
	{
		if (!paused)
		{
			if (direction == "up" || direction == "left")
			{
				if (left > scrollWidth - width)
					left = 0;
				else
					left += amount;
			}
			else if (direction == "down" || direction == "right")
			{
				if (left < 0)
					left = scrollWidth - width;
				else
					left -= amount;
			}
			marquee[0][dir] = left;
		}
		setTimeout(Run, speed);
	}
	
	marquee.bind("start", function(){paused = false;});
	marquee.bind("stop", function(){paused = true;});
	marquee.bind("set", Set);	
	
	Set(null, marquee.html());
	Run();
	
	return marquee;
};
