﻿function Uploader()
{
	var _uploadID = null;
	var _xmlHttp = null;
	var _status = "";
	var _params = "";
	var _nameBySystem = true;
	var _overwrite = true;
	var _interval = 200;
	var _onChange = null;
	var _onComplete = null;
	var _webPath = "/";
	var _info = null;
	var _forms = new Array();
	
	this.GetInfo = function(){return _info;};

	this.Init = function(option)
	{
		if (option.Status != null)
			_status = option.Status;
		if (option.Params != null)
			_params = option.Params;
		if (option.NameBySystem != null)
			_nameBySystem = option.NameBySystem;
		if (option.Overwrite != null)
			_overwrite = option.Overwrite;
		if (option.Interval != null)
			_interval = option.Interval;
		if (option.OnChange != null)
			_onChange = option.OnChange;
		if (option.OnComplete != null)
			_onComplete = option.OnComplete;
		if (option.WebPath != null)
			_webPath = option.WebPath;
	};
	
	this.OnMouseMove = function()
	{
		var form = null;
		for (var i = 0; i < _forms.length; i++)
		{
			if (_forms[i].BrowseID == this.id)
			{
				form = document.getElementById(_forms[i].ID);
				break;
			}
		}
		
		if (form == null)
			return;
		
		var top = this.offsetTop;
		var left = this.offsetLeft;
		var parent	= this.offsetParent;
		while (parent != null)
		{
			top	+= parent.offsetTop;
			left += parent.offsetLeft;
			parent = parent.offsetParent;
		}
		
		//this.style.visibility = "hidden";
		
		form.style.top = top + "px";
		form.style.left = left + "px";
		form.style.position = 'absolute';
		form.style.zIndex = 100000;
		form.style.display = "";
	};
	
	this.OnMouseOut = function()
	{
		for (var i = 0; i < _forms.length; i++)
		{
			if (_forms[i].ID == this.id)
			{
				this.style.display = "none";
				//document.getElementById(_forms[i].BrowseID).style.visibility = "visible";
			}
		}
	};
	
	this.OnChange = function()
	{
		for (var i = 0; i < _forms.length; i++)
		{
			if (_forms[i].FileID == this.id)
			{
				var textbox = document.getElementById(_forms[i].TextboxID);
				textbox.value = this.value;
				/*
				if (typeof(textbox.fireEvent) == "function")
					textbox.fireEvent("onchange");
				if (textbox.onchange != null)
					textbox.onchange();
				*/
				$(textbox).change();
			}
		}
	};
	
	this.Add = function(name, textboxID, browseID)
	{
		if (name == "" || document.getElementById(textboxID) == null || document.getElementById(browseID) == null)
			return;
			
		for (var i = 0; i < _forms.length; i++)
		{
			if (_forms[i].Name == name)
				return;
		}
		
		var form = new Object();
		form.Name = name;
		form.ID = "Uploader_Form_" + name;
		form.FileID = "Uploader_File_" + name;
		form.TextboxID = textboxID;
		form.BrowseID = browseID;
		
		var browseElement = document.getElementById(browseID);
		browseElement.style.margin = "0";
		browseElement.style.padding = "0";
		browseElement.style.width = "65px";
		browseElement.style.height = "20px";
		//browseElement.style.fontFamily = "宋体";
		browseElement.style.fontSize = "12px";
		browseElement.onmousemove = this.OnMouseMove;
		
		var formElement = null;
		if(navigator.userAgent.indexOf("MSIE") != -1 && navigator.userAgent.match(/MSIE\s*(9|10)/) == null)
		{
			formElement = document.createElement("<form method='post' enctype='multipart/form-data'></form>");
			formElement.style.filter = "alpha(opacity = 0)";
		}
		else
		{
			formElement = document.createElement("FORM");
			formElement.method = "post";
			formElement.enctype = "multipart/form-data";
			formElement.style.opacity = 0;
		}
		formElement.id = form.ID;
		formElement.style.display = "none";
		formElement.style.position = "absolute";
		formElement.style.margin = "0";
		formElement.style.padding = "0";
		formElement.style.overflow = "hidden";
		formElement.onmouseout = this.OnMouseOut;
		document.body.insertBefore(formElement, null);
		
		var fileElement = document.createElement("INPUT");
		fileElement.type = "file";
		fileElement.name = name;
		fileElement.id = form.FileID;
		fileElement.size = "1";
		fileElement.style.marginLeft = "-25px";
		fileElement.style.padding = "0";
		fileElement.style.width = "90px";
		fileElement.style.height = "20px";
		fileElement.style.fontFamily = "宋体";
		fileElement.style.fontSize = "12px";
		fileElement.onchange = this.OnChange;
		formElement.insertBefore(fileElement, null);
		
		var submitElement = document.createElement("INPUT");
		submitElement.type = "submit";
		submitElement.setAttribute("id", "Submit");
		submitElement.style.display = "none";
		formElement.insertBefore(submitElement, null);
		
		_forms[_forms.length] = form;
	};
	
	this.Delete = function(name)
	{
		var found = false;
		for (var i = 0; i < _forms.length; i++)
		{
			if (found)
			{
				_forms[i - 1] = _forms[i];
			}
			else if (_forms[i].Name == name)
			{
				document.body.removeChild(document.getElementById(_forms[i].ID));
				found = true;
			}
		}
		
		if (found)
			_forms.length -= 1;
	};
	
	this.NeedUpload = function(name)
	{
		for (var i = 0; i < _forms.length; i++)
		{
			if (_forms[i].Name == name)
			{
				var value = document.getElementById(_forms[i].FileID).value;
				if (value != "" && value == document.getElementById(_forms[i].TextboxID).value)
					return true;
				else
					return false;
			}
		}
		
		return false;
	};
	
	this.XMLStateChange = function()
	{
		if (_xmlHttp.readyState == 4)
		{
			if (_xmlHttp.status == 200)
			{
				if (_uploadID == null)
				{
					window.status = "";
					return;
				}
				
				_info = eval(_xmlHttp.responseText);
	
				if (parseFloat(_info.total) > 0)
					_info.percent = (parseFloat(_info.process) * 100 / parseFloat(_info.total)).toFixed(2) + "%";
				else
					_info.percent = "";

				if (typeof(SetStatusMessage) != "undefined")
					SetStatusMessage(_status + _info.percent, null, 10000000);
				else
					window.status = _status + _info.percent;

				if (_onChange != null)
					_onChange();
				
				setTimeout("_uploader.ProgressCallback()", _interval);
			}
		}
	};
	
	this.ProgressCallback = function()
	{
		if (_uploadID == null)
		{
			window.status = "";
			return;
		}
		
		if (window.ActiveXObject)
			_xmlHttp = new ActiveXObject("Microsoft.XMLHTTP");
		else
			_xmlHttp = new XMLHttpRequest();
		_xmlHttp.onreadystatechange = this.XMLStateChange;
		_xmlHttp.open("GET", _webPath + "alicms.aspx?Action=UploadState&UploadID=" + _uploadID, true);
		_xmlHttp.send("");
	};
	
	this.CompleteCallback = function(json)
	{
		if (_uploadID != null)
		{
			//clearTimeout(_uploadID);
			_uploadID = null;
		}
		
		if (_onComplete != null)
		{
			_onComplete(json.errorCode, unescape(json.message));
		}
		else
		{
			if (json.errorCode != 0)
				alert(unescape(json.message));
		}
		
		_info = null;
	};
	
	this.Upload = function(name)
	{
		if (name == null || !this.NeedUpload(name) || _uploadID != null)
			return;
		
		if (arguments.length == 2)
			_onComplete = arguments[1];
		
		var form = null;
		for (var i = 0; i < _forms.length; i++)
		{
			if (_forms[i].Name == name)
			{
				form = document.getElementById(_forms[i].ID);
				break;
			}
		}
		
		if (form == null)
			return;
		
		var frame = document.getElementById("Uploader_Frame");
		if (frame == null)
		{
			if(navigator.userAgent.indexOf("MSIE") != -1 && navigator.userAgent.match(/MSIE\s*(9|10)/) == null)
			{
				frame = document.createElement("<iframe name=\"Uploader_Frame\" id=\"Uploader_Frame\" width=\"0\" height=\"0\" style=\"display:none\"></iframe>");
			}
			else
			{
				frame = document.createElement("iframe");
				frame.name = "Uploader_Frame";
				frame.id = "Uploader_Frame";
				frame.width = "0";
				frame.height = "0";
				frame.style.display = "none";
			}
			document.body.insertBefore(frame, null);
		}
		
		_uploadID = setTimeout("_uploader.ProgressCallback()", _interval);
		form.action = _webPath + "alicms.aspx?Action=Upload&UploadID=" + _uploadID + "&UploadFileNameBySystem= " + _nameBySystem + "&UploadFileOverwrite=" + _overwrite + "&Callback=parent._uploader.CompleteCallback&" + _params;
		form.target = "Uploader_Frame";
		form.Submit.click();
	};
}
var _uploader = new Uploader();