﻿<%@ Page CodeFileBaseClass="AliCMS.Lib.SystemPageBase" %>
<script language="c#" runat="server">
protected string Condition()
{
	StringBuilder condition = new StringBuilder();
	string and = "";

	#region 广告位
	string positionID = Request.QueryString["PositionID"];
	if (!String.IsNullOrEmpty(positionID))
		condition.Append(Alias.Ad.PositionID + "=" + positionID);
	#endregion

	if (and == String.Empty && condition.Length != 0)
		and = " AND ";

	#region 是否回收
	string isRecycled = Request.QueryString["IsRecycled"];
	if (isRecycled == null)
		condition.Append(and + Alias.Ad.IsDeleted + "=false");
	else if (isRecycled != String.Empty)
		condition.Append(and + Alias.Ad.IsDeleted + "=" + isRecycled);
	#endregion

	if (and == String.Empty && condition.Length != 0)
		and = " AND ";

	#region 是否审核
	string isChecked = Request.QueryString["IsChecked"];
	if (isChecked == null)
		condition.Append(and + Alias.Ad.IsChecked + "=true");
	else if (isChecked != String.Empty)
		condition.Append(and + Alias.Ad.IsChecked + "=" + isChecked);
	#endregion

	if (and == String.Empty && condition.Length != 0)
		and = " AND ";

	#region 关键词
	string keyword = Request.QueryString["Keyword"];
	if (!String.IsNullOrEmpty(keyword))
	{
		if (Request.QueryString["KeywordType"] == "Title")
			condition.Append(and + Alias.Ad.Title + " LIKE '%" + keyword + "%'");
		else if (Request.QueryString["KeywordType"] == "SubInstanceID")
			condition.Append(and + Alias.Ad.SubInstanceID + "=" + keyword);
	}
	#endregion
	
	return condition.ToString();
}

protected string Sort()
{
	string sort = String.Empty;
	switch (Request.QueryString["Sort"])
	{
		case "1":
			sort = Alias.Ad.InnerID + " DESC";
			break;
		case "2":
			sort = Alias.Ad.InnerID + " ASC";
			break;
		case "3":
			sort = Alias.Ad.StartTime + " ASC";
			break;
		case "4":
			sort = Alias.Ad.StartTime + " DESC";
			break;
		case "5":
			sort = Alias.Ad.EndTime + " ASC";
			break;
		case "6":
			sort = Alias.Ad.EndTime + " DESC";
			break;
		case "7":
			sort = Alias.Ad.Sort + " ASC";
			break;
		default:
			sort = Alias.Ad.EndTime + " DESC";
			break;
	}
	
	return sort;
}

protected string FormatDate(object date)
{
	if (Convert.IsDBNull(date))
		return String.Empty;
	else
		return Convert.ToDateTime(date).ToString("yyyy-MM-dd");
}
</script>
<table border="0" cellpadding="4" cellspacing="1" class="ListTable">
	<thead>
		<tr>
			<th width="40">选择</th>
			<th width="40">编号</th>
			<th width="200">图片</th>
			<th>名称</th>
			<th width="60">开始日期</th>
			<th width="60">结束日期</th>
		</tr>
	</thead>
	<tbody>
		<ali:List ID="List" Object="Ad" Page="PageNumber" PageSize="20" Condition="Condition()" Sort="Sort()">
			<ali:Record>
				<tr id="Row<%=InnerID%>">
					<td><input type="checkbox" name="Sel" value="<%=InnerID%>" /></td>
					<td><%=InnerID%></td>
					<td>
						<%If !String.Equals(Image, String.Empty)%>
							<a href="<%=Image%>" target="_blank"><img src="<%=Image%>" class="Thumbnail" /></a>
						<%EndIf%>
					</td>
					<td class="<%=ContentLang%>Font"><a href="../ad/edit.aspx?Lang=<%=ContentLang%>&PositionID=<%=Request.QueryString["PositionID"]%>&ID=<%=InnerID%>"><%=Title%></a></td>
					<td><%=FormatDate(StartTime)%></td>
					<td><%=FormatDate(EndTime)%></td>
				</tr>
			</ali:Record>
		</ali:List>
	</tbody>
</table>
<ali:Pagination Page="PageNumber" PageSize="20" RecordCount="List[RecordCount]">
	<div class="Pagination">
		<div class="Left">共 <%=RecordCount%> 条 当前显示第 <%=PageNumber%> 页 第 <%=RangeLower%>-<%=RangeUpper%> 条 </div>
		<div class="Right">
			<ali:FirstPage>
				<ali:Yes>
					<img src="<%=ImagePath%>pagination/first_page_off.gif"/>
					<img src="<%=ImagePath%>pagination/previous_page_off.gif"/>
				</ali:Yes>
				<ali:No>
					<a href="javascript:Go(1)"><img src="<%=ImagePath%>pagination/first_page_on.gif"/></a>
					<a href="javascript:Go(<%=PageNumber%> - 1)" id="PrevPage"><img src="<%=ImagePath%>pagination/previous_page_on.gif"/></a>
				</ali:No>
			</ali:FirstPage>
			<ali:CurrentPage Range="5">
				<ali:Yes>
					<span class="Current"><%=Index%></span>						
				</ali:Yes>
				<ali:No>
					<a href="javascript:Go(<%=Index%>)">[<%=Index%>]</a>
				</ali:No>
			</ali:CurrentPage>
			<ali:LastPage>
				<ali:Yes>
					<img src="<%=ImagePath%>pagination/next_page_off.gif"/>
					<img src="<%=ImagePath%>pagination/last_page_off.gif"/>
				</ali:Yes>
				<ali:No>
					<a href="javascript:Go(<%=PageNumber%> + 1)" id="NextPage"><img src="<%=ImagePath%>pagination/next_page_on.gif"/></a>
					<a href="javascript:Go(<%=PageCount%>)"><img src="<%=ImagePath%>pagination/last_page_on.gif"/></a>
				</ali:No>
			</ali:LastPage>
		</div>
	</div>
</ali:Pagination>