﻿<%@ Page CodeFileBaseClass="AliCMS.Lib.SystemPageBase" %>
<%@ Register TagPrefix="alicmsUC" TagName="Ime" Src="../../ime.dwt.ascx"%>
<%@ Register TagPrefix="alicmsUC" TagName="LanguageMenu" Src="../../language_menu.dwt.ascx"%>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<!-- TemplateInfo codeOutsideHTMLIsLocked="true" -->
<ali:Get ID="Position" Object="Position" InnerID="Request.QueryString['PositionID']" />
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<title>查询广告</title>
<link rel="stylesheet" type="text/css" href="<%=CommonPath%>jquery/themes/lightness/all.css" />
<ali:Comment><link rel="stylesheet" type="text/css" href="../../S01/CHS/css/common.css" /></ali:Comment>
<link rel="stylesheet" href="<%=CssPath%>common.css" />
<alicmsUC:Ime Ime="true" Eot="true" runat="server" />
<style type="text/css">
.Thumbnail{max-width:200px;max-height:40px;_width:expression(this.scrollWidth > 200 ? "200px" : true);_height:40px}
</style>
<script language="c#" runat="server">
protected string Condition()
{
	StringBuilder condition = new StringBuilder();
	string and = "";

	#region 广告位
	string positionID = Request.QueryString["PositionID"];
	if (!String.IsNullOrEmpty(positionID))
		condition.Append(Alias.Ad.PositionID + "=" + positionID);
	#endregion

	if (and == String.Empty && condition.Length != 0)
		and = " AND ";

	#region 是否回收
	string isRecycled = Request.QueryString["IsRecycled"];
	if (isRecycled == null)
		condition.Append(and + Alias.Ad.IsDeleted + "=false");
	else if (isRecycled != String.Empty)
		condition.Append(and + Alias.Ad.IsDeleted + "=" + isRecycled);
	#endregion

	if (and == String.Empty && condition.Length != 0)
		and = " AND ";

	#region 是否审核
	string isChecked = Request.QueryString["IsChecked"];
	if (isChecked == null)
		condition.Append(and + Alias.Ad.IsChecked + "=true");
	else if (isChecked != String.Empty)
		condition.Append(and + Alias.Ad.IsChecked + "=" + isChecked);
	#endregion

	if (and == String.Empty && condition.Length != 0)
		and = " AND ";

	#region 关键词
	string keyword = Request.QueryString["Keyword"];
	if (!String.IsNullOrEmpty(keyword))
	{
		if (Request.QueryString["KeywordType"] == "Title")
			condition.Append(and + Alias.Ad.Title + " LIKE '%" + keyword + "%'");
		else if (Request.QueryString["KeywordType"] == "SubInstanceID")
			condition.Append(and + Alias.Ad.SubInstanceID + "=" + keyword);
	}
	#endregion
	
	return condition.ToString();
}

protected string Sort()
{
	string sort = String.Empty;
	switch (Request.QueryString["Sort"])
	{
		case "1":
			sort = Alias.Ad.InnerID + " DESC";
			break;
		case "2":
			sort = Alias.Ad.InnerID + " ASC";
			break;
		case "3":
			sort = Alias.Ad.StartTime + " ASC";
			break;
		case "4":
			sort = Alias.Ad.StartTime + " DESC";
			break;
		case "5":
			sort = Alias.Ad.EndTime + " ASC";
			break;
		case "6":
			sort = Alias.Ad.EndTime + " DESC";
			break;
		case "7":
			sort = Alias.Ad.Sort + " ASC";
			break;
		default:
			sort = Alias.Ad.EndTime + " DESC";
			break;
	}
	
	return sort;
}

protected string FormatDate(object date)
{
	if (Convert.IsDBNull(date))
		return String.Empty;
	else
		return Convert.ToDateTime(date).ToString("yyyy-MM-dd");
}
</script>
<script type="text/javascript">
var _page = "ad_search";
var _lang = "<%=ContentLang%>";
var _webPath = "<%=WebPath%>";
var _imagePath = "<%=ImagePath%>";
var _positionID = "<%=Request.QueryString["PositionID"]%>";
var _lang_working = "正在操作...";
var _lang_operation_fail = "操作失败！";
var _lang_operation_success = "操作成功！";
var _lang_confirm_delete = "要删除此项吗？";
var _lang_check = "审核";
var _lang_recycle = "回收";
var _lang_recover = "还原";
var _lang_delete = "删除";
</script>
</head>
<body>
<div class="WhiteHeader">
	<div class="Left"><img src="<%=ImagePath%>close_frame.gif" /></div>
	<div class="Title">查询广告</div>
	<div class="Right">
		<alicmsUC:LanguageMenu runat="server" />
		<img height="15" src="<%=ImagePath%>dropdown.gif" /> 语言：<%=CurrentLanguage%>
	</div>
</div>
<div class="Block">
	<ul class="TabMenu">
		<li class="Left"></li>
		<li class="Middle"><a href="../position/list.aspx?Lang=<%=ContentLang%>">广告位列表</a></li>
		<li class="Right"></li>
		<li class="Left"></li>
		<li class="Middle"><a href="../position/add.aspx?Lang=<%=ContentLang%>">添加广告位</a></li>
		<li class="Right"></li>
		<li class="Left Selected"></li>
		<li class="Middle Selected">查询广告</li>
		<li class="Right Selected"></li>
	</ul>
	<ul class="Title">
		<li class="Left"></li>
		<li class="Middle"></li>
		<li class="Right"></li>
	</ul>
	<div class="ToolBar">
		<select id="IsRecycled">
			<option value="">是否回收</option>
			<option value="false" selected="selected">未回收</option>
			<option value="true">已回收</option>
		</select>
		<select id="IsChecked">
			<option value="">是否审核</option>
			<option value="false">未审核</option>
			<option value="true" selected="selected">已审核</option>
		</select>
		<select id="PositionID" class="<%=ContentLang%>Font">
			<option>所有广告位</option>
			<ali:List Object="Position" Condition="IsDeleted=false">
				<ali:Record>
					<option value="<%=ID%>"><%=Name%></option>
				</ali:Record>
			</ali:List>
		</select>
	</div>
	<div class="ToolBar">
		<select id="Sort">
			<option value="1">编号↓</option>
			<option value="2">编号↑</option>
			<option value="3">开始日期↑</option>
			<option value="4">开始日期↓</option>
			<option value="5">结束日期↑</option>
			<option value="6" selected="selected">结束日期↓</option>
			<option value="7">手动排序</option>
		</select>
		<input id="Keyword" class="Text <%=ContentLang%>Font" />
		<select id="KeywordType">
			<option value="Title">标题</option>
			<option value="SubInstanceID">子实例</option>
		</select>
		<input type="button" id="Search" value="搜索" class="Button" />
		<input type="button" id="SelectAll" value="全选" class="Button" />
		<input type="button" id="ReverseSelect" value="反选" class="Button" />
		<span id="ExtraButton"></span>
	</div>
	<div id="List">
		<table border="0" cellpadding="4" cellspacing="1" class="ListTable">
			<thead>
				<tr>
					<th width="40">选择</th>
					<th width="40">编号</th>
					<th width="200">图片</th>
					<th>名称</th>
					<th width="60">开始日期</th>
					<th width="60">结束日期</th>
				</tr>
			</thead>
			<tbody>
				<ali:List ID="List" Object="Ad" Page="PageNumber" PageSize="20" Condition="Condition()" Sort="Sort()" Validate="True">
					<ali:Record>
						<tr id="Row<%=InnerID%>">
							<td><input type="checkbox" name="Sel" value="<%=InnerID%>" /></td>
							<td><%=InnerID%></td>
							<td>
								<%If !String.Equals(Image, String.Empty)%>
									<a href="<%=Image%>" target="_blank"><img src="<%=Image%>" class="Thumbnail" /></a>
								<%EndIf%>
							</td>
							<td class="<%=ContentLang%>Font"><a href="../ad/edit.aspx?Lang=<%=ContentLang%>&amp;PositionID=<%=Request.QueryString["PositionID"]%>&amp;ID=<%=InnerID%>"><%=Title%></a></td>
							<td><%=FormatDate(StartTime)%></td>
							<td><%=FormatDate(EndTime)%></td>
						</tr>
					</ali:Record>
				</ali:List>
			</tbody>
		</table>
		<ali:Pagination Page="PageNumber" PageSize="20" RecordCount="List[RecordCount]">
			<div class="Pagination">
				<div class="Left">共 <%=RecordCount%> 条 当前显示第 <%=PageNumber%> 页 第 <%=RangeLower%>-<%=RangeUpper%> 条 </div>
				<div class="Right">
					<ali:FirstPage>
						<ali:Yes>
							<img src="<%=ImagePath%>pagination/first_page_off.gif"/>
							<img src="<%=ImagePath%>pagination/previous_page_off.gif"/>
						</ali:Yes>
						<ali:No>
							<a href="javascript:Go(1)"><img src="<%=ImagePath%>pagination/first_page_on.gif"/></a>
							<a href="javascript:Go(<%=PageNumber%> - 1)" id="PrevPage"><img src="<%=ImagePath%>pagination/previous_page_on.gif"/></a>
						</ali:No>
					</ali:FirstPage>
					<ali:CurrentPage Range="5">
						<ali:Yes>
							<span class="Current"><%=Index%></span>						
						</ali:Yes>
						<ali:No>
							<a href="javascript:Go(<%=Index%>)">[<%=Index%>]</a>
						</ali:No>
					</ali:CurrentPage>
					<ali:LastPage>
						<ali:Yes>
							<img src="<%=ImagePath%>pagination/next_page_off.gif"/>
							<img src="<%=ImagePath%>pagination/last_page_off.gif"/>
						</ali:Yes>
						<ali:No>
							<a href="javascript:Go(<%=PageNumber%> + 1)" id="NextPage"><img src="<%=ImagePath%>pagination/next_page_on.gif"/></a>
							<a href="javascript:Go(<%=PageCount%>)"><img src="<%=ImagePath%>pagination/last_page_on.gif"/></a>
						</ali:No>
					</ali:LastPage>
				</div>
			</div>
		</ali:Pagination>
	</div>
</div>
<script type="text/javascript" src="<%=CommonPath%>jquery/core.js"></script>
<script type="text/javascript" src="<%=CommonPath%>jquery/ui.js"></script>
<script type="text/javascript" src="<%=CommonPath%>utility.js"></script>
<script type="text/javascript" src="<%=JsPath%>global.js"></script>
<script type="text/javascript" src="<%=ModuleJsPath%>module.js"></script>
</body>
</html>