﻿<%@ Page CodeFileBaseClass="AliCMS.Lib.SystemPageBase" %>
<script language="c#" runat="server">
protected string Condition()
{
	StringBuilder condition = new StringBuilder();
	string and = String.Empty;

	#region 开始日期
	string startTime = Request.QueryString["StartTime"];
	if (!String.IsNullOrEmpty(startTime))
		condition.Append(and + Alias.Click.Time + " >= #" + startTime + "#");
	#endregion

	if (and == String.Empty && condition.Length != 0)
		and = " AND ";

	#region 结束日期
	string endTime = Request.QueryString["EndTime"];
	if (!String.IsNullOrEmpty(endTime))
		condition.Append(and + Alias.Click.Time + " <= #" + endTime + "#");
	#endregion

	if (and == String.Empty && condition.Length != 0)
		and = " AND ";

	#region 关键词
	string keyword = Request.QueryString["Keyword"];
	if (!String.IsNullOrEmpty(keyword))
	{
		if (Request.QueryString["KeywordType"] == "PositionName")
			condition.Append(and + Alias.Click.PositionName + " LIKE '%" + keyword + "%'");
		else if (Request.QueryString["KeywordType"] == "PositionInnerID")
			condition.Append(and + Alias.Click.PositionInnerID + "=" + keyword);
		else if (Request.QueryString["KeywordType"] == "Advertiser")
			condition.Append(and + Alias.Click.Advertiser + " LIKE '%" + keyword + "%'");
		else if (Request.QueryString["KeywordType"] == "AdTitle")
			condition.Append(and + Alias.Click.AdTitle + " LIKE '%" + keyword + "%'");
	}
	#endregion
	
	return condition.ToString();
}
</script>
<table border="0" cellpadding="4" cellspacing="1" class="ListTable">
	<thead>
		<tr>
			<th>广告位</th>
			<th>广告</th>
			<th>时间</th>
			<th>IP地址</th>
			<th>浏览器</th>
			<th>操作系统</th>
		</tr>
	</thead>
	<tbody>
		<ali:List ID="List" Object="Click" Page="PageNumber" PageSize="20" Condition="Condition()" Validate="True">
			<ali:Record>
				<tr>
					<td class="<%=ContentLang%>Font"><a href="../position/edit.aspx?Lang=<%=ContentLang%>&ID=<%=PositionInnerID%>"><%=PositionName%></a></td>
					<td class="<%=ContentLang%>Font"><a href="../ad/edit.aspx?Lang=<%=ContentLang%>&ID=<%=AdInnerID%>"><%=AdTitle%></a></td>
					<td><%=Time%></td>
					<td><%=IP%></td>
					<td><%=Browser%></td>
					<td><%=Platform%></td>
				</tr>
			</ali:Record>
		</ali:List>
	</tbody>
</table>
<ali:Pagination Page="PageNumber" PageSize="20" RecordCount="List[RecordCount]">
	<div class="Pagination">
		<div class="Left">共 <%=RecordCount%> 条 当前显示第 <%=PageNumber%> 页 第 <%=RangeLower%>-<%=RangeUpper%> 条 </div>
		<div class="Right">
			<ali:FirstPage>
				<ali:Yes>
					<img src="<%=ImagePath%>pagination/first_page_off.gif"/>
					<img src="<%=ImagePath%>pagination/previous_page_off.gif"/>
				</ali:Yes>
				<ali:No>
					<a href="javascript:Go(1)"><img src="<%=ImagePath%>pagination/first_page_on.gif"/></a>
					<a href="javascript:Go(<%=PageNumber%> - 1)" id="PrevPage"><img src="<%=ImagePath%>pagination/previous_page_on.gif"/></a>
				</ali:No>
			</ali:FirstPage>
			<ali:CurrentPage Range="5">
				<ali:Yes>
					<span class="Current"><%=Index%></span>						
				</ali:Yes>
				<ali:No>
					<a href="javascript:Go(<%=Index%>)">[<%=Index%>]</a>
				</ali:No>
			</ali:CurrentPage>
			<ali:LastPage>
				<ali:Yes>
					<img src="<%=ImagePath%>pagination/next_page_off.gif"/>
					<img src="<%=ImagePath%>pagination/last_page_off.gif"/>
				</ali:Yes>
				<ali:No>
					<a href="javascript:Go(<%=PageNumber%> + 1)" id="NextPage"><img src="<%=ImagePath%>pagination/next_page_on.gif"/></a>
					<a href="javascript:Go(<%=PageCount%>)"><img src="<%=ImagePath%>pagination/last_page_on.gif"/></a>
				</ali:No>
			</ali:LastPage>
		</div>
	</div>
</ali:Pagination>