﻿<%@ Page CodeFileBaseClass="AliCMS.Lib.SystemPageBase" %>
<%@ Register TagPrefix="alicmsUC" TagName="Ime" Src="../../ime.dwt.ascx"%>
<%@ Register TagPrefix="alicmsUC" TagName="LanguageMenu" Src="../../language_menu.dwt.ascx"%>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<!-- TemplateInfo codeOutsideHTMLIsLocked="true" -->
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<title>按点击计费</title>
<link rel="stylesheet" type="text/css" href="<%=CommonPath%>jquery/themes/lightness/all.css" />
<ali:Comment><link rel="stylesheet" type="text/css" href="../../S01/CHS/css/common.css" /></ali:Comment>
<link rel="stylesheet" href="<%=CssPath%>common.css" />
<alicmsUC:Ime Ime="true" Eot="true" runat="server" />
<script language="c#" runat="server">
protected string Condition()
{
	StringBuilder condition = new StringBuilder();
	string and = String.Empty;

	#region 开始日期
	string startTime = Request.QueryString["StartTime"];
	if (!String.IsNullOrEmpty(startTime))
		condition.Append(and + Alias.Click.Time + " >= #" + startTime + "#");
	#endregion

	if (and == String.Empty && condition.Length != 0)
		and = " AND ";

	#region 结束日期
	string endTime = Request.QueryString["EndTime"];
	if (!String.IsNullOrEmpty(endTime))
		condition.Append(and + Alias.Click.Time + " <= #" + endTime + "#");
	#endregion

	if (and == String.Empty && condition.Length != 0)
		and = " AND ";

	#region 关键词
	string keyword = Request.QueryString["Keyword"];
	if (!String.IsNullOrEmpty(keyword))
	{
		if (Request.QueryString["KeywordType"] == "PositionName")
			condition.Append(and + Alias.Click.PositionName + " LIKE '%" + keyword + "%'");
		else if (Request.QueryString["KeywordType"] == "PositionInnerID")
			condition.Append(and + Alias.Click.PositionInnerID + "=" + keyword);
		else if (Request.QueryString["KeywordType"] == "Advertiser")
			condition.Append(and + Alias.Click.Advertiser + " LIKE '%" + keyword + "%'");
		else if (Request.QueryString["KeywordType"] == "AdTitle")
			condition.Append(and + Alias.Click.AdTitle + " LIKE '%" + keyword + "%'");
	}
	#endregion
	
	return condition.ToString();
}
</script>
<script type="text/javascript">
var _page = "income_cpc";
var _lang = "<%=ContentLang%>";
var _webPath = "<%=WebPath%>";
var _imagePath = "<%=ImagePath%>";
var _lang_working = "正在操作...";
var _lang_operation_fail = "操作失败！";
var _lang_operation_success = "操作成功！";
var _lang_start_time_incorrect = "开始日期不正确！";
var _lang_end_time_incorrect = "结束日期不正确！";
var _lang_confirm_settle = "真的要结算吗？";
</script>
</head>
<body>
<div class="WhiteHeader">
	<div class="Left"><img src="<%=ImagePath%>close_frame.gif" /></div>
	<div class="Title">按点击计费</div>
	<div class="Right">
		<alicmsUC:LanguageMenu runat="server" />
		<img height="15" src="<%=ImagePath%>dropdown.gif" /> 语言：<%=CurrentLanguage%>
	</div>
</div>
<div class="Block">
	<ul class="TabMenu">
		<li class="Left Selected"></li>
		<li class="Middle Selected">按点击计费</li>
		<li class="Right Selected"></li>
		<li class="Left"></li>
		<li class="Middle"><a href="../income/cpt.aspx?Lang=<%=ContentLang%>">按时长计费</a></li>
		<li class="Right"></li>
		<li class="Left"></li>
		<li class="Middle"><a href="../income/clicks.aspx?Lang=<%=ContentLang%>">点击清单</a></li>
		<li class="Right"></li>
		<li class="Left"></li>
		<li class="Middle"><a href="../income/list.aspx?Lang=<%=ContentLang%>">收入清单</a></li>
		<li class="Right"></li>
	</ul>
	<ul class="Title">
		<li class="Left"></li>
		<li class="Middle"></li>
		<li class="Right"></li>
	</ul>
	<div class="ToolBar">
		从：<input type="text" size="12" id="StartTime" class="Wdate" />
		到：<input type="text" size="12" id="EndTime" class="Wdate" />
		关键词：<input id="Keyword" class="Text <%=ContentLang%>Font" />
		<select id="KeywordType">
			<option value="PositionName">广告位名称</option>
			<option value="PositionInnerID">广告位编号</option>
			<option value="Advertiser">广告主</option>
			<option value="AdTitle">广告标题</option>
		</select>
		<input type="button" id="Search" value="搜索" class="Button" />
	</div>
	<div id="List">
		<table border="0" cellpadding="4" cellspacing="1" class="ListTable">
			<thead>
				<tr>
					<th>广告位</th>
					<th>广告</th>
					<th>广告主</th>
					<th>点击单价（元）</th>
					<th>点击数</th>
					<th>收入</th>
					<th>结算</th>
				</tr>
			</thead>
			<tbody>
				<ali:List ID="List" Object="Click" Operation="ListCpc" Page="PageNumber" PageSize="20" Condition="Condition()" Validate="True">
					<ali:Record>
						<tr>
							<td class="<%=ContentLang%>Font"><a href="../position/edit.aspx?Lang=<%=ContentLang%>&amp;ID=<%=PositionInnerID%>"><%=PositionName%></a></td>
							<td class="<%=ContentLang%>Font"><a href="../ad/edit.aspx?Lang=<%=ContentLang%>&amp;ID=<%=AdInnerID%>"><%=AdTitle%></a></td>
							<td><%=Advertiser%></td>
							<td><%=ClickPrice%></td>
							<td><%=HitCount%></td>
							<td><%=Convert.ToDecimal(ClickPrice) * Convert.ToInt32(HitCount)%></td>
							<td><button id="<%=AdInnerID%>">结算</button></td>
						</tr>
					</ali:Record>
				</ali:List>
			</tbody>
		</table>
		<ali:Pagination Page="PageNumber" PageSize="20" RecordCount="List[RecordCount]">
			<div class="Pagination">
				<div class="Left">共 <%=RecordCount%> 条 当前显示第 <%=PageNumber%> 页 第 <%=RangeLower%>-<%=RangeUpper%> 条 </div>
				<div class="Right">
					<ali:FirstPage>
						<ali:Yes>
							<img src="<%=ImagePath%>pagination/first_page_off.gif"/>
							<img src="<%=ImagePath%>pagination/previous_page_off.gif"/>
						</ali:Yes>
						<ali:No>
							<a href="javascript:Go(1)"><img src="<%=ImagePath%>pagination/first_page_on.gif"/></a>
							<a href="javascript:Go(<%=PageNumber%> - 1)" id="PrevPage"><img src="<%=ImagePath%>pagination/previous_page_on.gif"/></a>
						</ali:No>
					</ali:FirstPage>
					<ali:CurrentPage Range="5">
						<ali:Yes>
							<span class="Current"><%=Index%></span>						
						</ali:Yes>
						<ali:No>
							<a href="javascript:Go(<%=Index%>)">[<%=Index%>]</a>
						</ali:No>
					</ali:CurrentPage>
					<ali:LastPage>
						<ali:Yes>
							<img src="<%=ImagePath%>pagination/next_page_off.gif"/>
							<img src="<%=ImagePath%>pagination/last_page_off.gif"/>
						</ali:Yes>
						<ali:No>
							<a href="javascript:Go(<%=PageNumber%> + 1)" id="NextPage"><img src="<%=ImagePath%>pagination/next_page_on.gif"/></a>
							<a href="javascript:Go(<%=PageCount%>)"><img src="<%=ImagePath%>pagination/last_page_on.gif"/></a>
						</ali:No>
					</ali:LastPage>
				</div>
			</div>
		</ali:Pagination>
	</div>
</div>
<script type="text/javascript" src="<%=CommonPath%>jquery/core.js"></script>
<script type="text/javascript" src="<%=CommonPath%>jquery/ui.js"></script>
<script type="text/javascript" src="<%=CommonPath%>utility.js"></script>
<script type="text/javascript" src="<%=CommonPath%>date_picker/date_picker.js"></script>
<script type="text/javascript" src="<%=JsPath%>global.js"></script>
<script type="text/javascript" src="<%=ModuleJsPath%>module.js"></script>
</body>
</html>