﻿function BuildHeader()
{
	if (_page == "guestbook_list")
		return BuildAjaxPath(true) + "?Lang=" + _lang + "&IsChecked=" + $("#IsChecked").val() + "&CategoryID=" + $("#CategoryID").val() + "&Sort=" + $("#Sort").val() + "&Keyword=" + encodeURIComponent($("#Keyword").val()) + "&KeywordType=" + $("#KeywordType").val() + "&Page=" + _pageNumber;
	else
	    return BuildAjaxPath();
}

function Search()
{
	if (arguments.length > 0 && typeof(arguments[0]) != "object")
		_pageNumber = arguments[0];
	
	if (_page == "guestbook_list")
		SetCookie("IsChecked", $("#IsChecked").val(), 10*360*24*60);
	
	SetStatusMessage(_lang_working);
	$.ajax(
	{
		url : BuildHeader(),
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
			$("#RecordList").html(HandleFake404(data, "text"));
			Init();
			SetStatusMessage();

			if (typeof(SetupIme) == "function")
				SetupIme();
		}
	});
}

function MakeButton()
{
	var buttons = "";
	
	if (_page == "guestbook_list")
	{
	    //审核
	    var obj = $("#IsChecked")[0];
	    if (obj.selectedIndex == 1)
		    buttons += "<button class=\"Button\" onclick=\"UpdateGuestBook('Check')\" >" + _lang_check + "</button>";
	    else if (obj.selectedIndex == 2)
		    buttons += "<button class=\"Button\" onclick=\"UpdateGuestBook('UnCheck')\" >" + _lang_uncheck + "</button>";
	}

	$("#ExtraButton").html(buttons);
}

//-------------------------------------------------
//Start : 留言管理
function UpdateGuestBook(action, id)
{
	if (id == null)
	{
		id = "";
		$("[name=Sel]:checked").each(function(){id += id == "" ? this.value : "|" + this.value;});
		if(id == "")
		{
			Alert(_lang_selection_empty);
			return;
		}
		
		if(action == "Delete")
			Confirm(_lang_confirm_delete, function(returnValue){if (returnValue)UpdateGuestBook(action, id);}, this);
		else
			UpdateGuestBook(action, id);
	}
	else
	{
		SetStatusMessage(_lang_working);

		$.ajax(
		{
			url : _webPath + "alicms.aspx?Lang=" + _lang + "&Object=GuestBook&Operation=" + action + "&ID=" + id + "&Transfer=" + encodeURIComponent(BuildHeader()),
			data : {},
			type : "POST",
			error : function(request)
			{
				Alert(_lang_operation_fail);
				SetStatusMessage();
			},
			success : function(data)
			{
				Alert(_lang_operation_success);
				SetStatusMessage();

				$("#RecordList").html(HandleFake404(data, "text"));				
			}
		});
	}
}

function EditGuestBook()
{
	var category = $("[name=CategoryID] option:selected");
	var type = $("[name=TypeID] option:selected");

	var data = "Head=" + encodeURIComponent(this.Head.value);
	data += "&Name=" + encodeURIComponent(this.Name.value);
	data += "&TypeID=" + this.TypeID.value;
	data += "&TypeName=" + encodeURIComponent(type.attr("Name"));
	data += "&QQ=" + encodeURIComponent(this.QQ.value);
	data += "&Email=" + encodeURIComponent(this.Email.value);
	data += "&Phone=" + encodeURIComponent(this.Phone.value);
	data += "&Homepage=" + encodeURIComponent(this.Homepage.value);
	data += "&CategoryID=" + this.CategoryID.value;
	data += "&CategoryName=" + encodeURIComponent(category.attr("Name"));
	data += "&Subject=" + encodeURIComponent(this.Subject.value);
	var editor;
	if ($('[name=Content].editor').length == 1)
		data += "&Content=" + encodeURIComponent(CKEDITOR.instances[this.Content.id].getData());
	else
	    data += "&Content=" + encodeURIComponent(this.Content.value);
	data += '&Reply=' + encodeURIComponent(CKEDITOR.instances[this.Reply.id].getData());
	data += "&IsChecked=" + $("#IsCheckedYes")[0].checked;

	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "alicms.aspx?Lang=" + _lang + "&Object=GuestBook&Operation=Modify&ID=" + _id,
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		}
	});
	
	return false;	
}
//End : 留言管理
//-------------------------------------------------

//-------------------------------------------------
//Start : 类型管理
function AddType()
{
	if (this.Name.value == "")
	{
		Alert(_lang_name_empty, function(){this.Name.select();}, this);
		return false;
	}
	
	var data = "Name=" + encodeURIComponent(this.Name.value);

	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "alicms.aspx?Lang=" + _lang + "&Object=Type&Operation=Add",
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		}
	});
	
	return false;
}

function EditType()
{
	if (this.Name.value == "")
	{
		Alert(_lang_name_empty, function(){this.Name.select();}, this);
		return false;
	}
	
	var data = "Name=" + encodeURIComponent(this.Name.value);

	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "alicms.aspx?Lang=" + _lang + "&Object=Type&Operation=Modify&ID=" + _id,
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
		    Alert(_lang_operation_success);
		    SetStatusMessage();
		    $(":submit")[0].disabled = false;
		}
	});
	
	return false;
}

function ModifyType(form, id)
{
	if (form.Name.value == "")
	{
		Alert(_lang_name_empty, function(){form.Name.select();}, this);
		return false;
	}
	
	var data = "Name=" + encodeURIComponent(form.Name.value);

	form.disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "alicms.aspx?Lang=" + _lang + "&Object=Type&Operation=Modify&ID=" + id,
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		}
	});
	
	return false;	
}

function DeleteType(id)
{
	SetStatusMessage(_lang_working);

	$.ajax(
	{
		url : _webPath + "alicms.aspx?Lang=" + _lang + "&Object=Type&Operation=Delete&ID=" + id,
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();

			$("#" + id).remove();
		}
	});
}
//End : 类型管理
//-------------------------------------------------

//-------------------------------------------------
//Start : 类别管理
function AddCategory()
{
	if (this.Name.value == "")
	{
		Alert(_lang_name_empty, function(){this.Name.select();}, this);
		return false;
	}
	
	var data = "Name=" + encodeURIComponent(this.Name.value);
	data += "&ParentID=" + encodeURIComponent(this.ParentID.value);

	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "alicms.aspx?Lang=" + _lang + "&Object=Category&Operation=Add",
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		}
	});
	
	return false;	
}

function EditCategory()
{
	if (this.Name.value == "")
	{
		Alert(_lang_name_empty, function(){this.Name.select();}, this);
		return false;
	}
	
	var data = "Name=" + encodeURIComponent(this.Name.value);
	data += "&ParentID=" + encodeURIComponent(this.ParentID.value);

	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "alicms.aspx?Lang=" + _lang + "&Object=Category&Operation=Modify&ID=" + _id,
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		}
	});
	
	return false;	
}

function MoveCategory(from, to)
{
	if (from == to)
		return;
	
	SetStatusMessage(_lang_working);

	$.ajax(
	{
		url : _webPath + "alicms.aspx?Lang=" + _lang + "&Object=Category&Operation=" + g_action + "&From=" + from + "&To=" + to,
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
			
			ClientMove(from, to, _imagePath);
		}
	});
}

function ModifyCategory(form, id)
{
	if (form.Name.value == "")
	{
		Alert(_lang_name_empty, function(){form.Name.select();}, this);
		return;
	}
	
	form.disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "alicms.aspx?Lang=" + _lang + "&Object=Category&Operation=Modify&ID=" + id,
		data : "Name=" + encodeURIComponent(form.Name.value),
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			form.disabled = false;
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
			form.disabled = false;
		}
	});
}

function DeleteCategory(id)
{
	SetStatusMessage(_lang_working);

	$.ajax(
	{
		url : _webPath + "alicms.aspx?Lang=" + _lang + "&Object=Category&Operation=Delete&ID=" + id,
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();

			ClientDelete(id);
		}
	});
}
//End : 类别管理
//-------------------------------------------------

//-------------------------------------------------
//Start : 栏目设置
function SetBasicSettings()
{
	var data = "IsNeedToCheck=" + $("#IsNeedToCheckYes")[0].checked;
	data += "&EnableHtmlEditor=" + $("#EnableHtmlEditorYes")[0].checked;

	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "alicms.aspx?Lang=" + _lang + "&Object=InstanceConfig&Operation=SetBasicSettings",
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		}
	});
	
	return false;	
}

function HtmlEncode()
{
    var me = $(this);
	me.attr("disabled", true);
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "alicms.aspx?Lang=" + _lang + "&Object=GuestBook&Operation=HtmlEncode",
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
	        me.attr("disabled", false);
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
	        me.attr("disabled", false);
		}
	});
	
	return false;	
}
//End : 栏目设置
//-------------------------------------------------

function Init()
{
	if (typeof (_page) == "undefined")
		return;
	
	if (_page == "guestbook_list")
	{
	    MakeButton();
	
		if (arguments.length == 0)
		    return;

		$("#IsChecked,#CategoryID,#Sort").change(Search);
		$("#Keyword").keydown(function(e){if(e.keyCode == 13){Search(1);e.preventDefault();}});
		$("#Search").click(function(){Search(1);});
		$("#SelectAll").click(function(){$(":checkbox[name=Sel]").each(function(){this.checked = true;});});
		$("#ReverseSelect").click(function(){$(":checkbox[name=Sel]").each(function(){this.checked = !this.checked;});});
		$("#Delete").click(function(){UpdateGuestBook("Delete");});
	}
	else if (_page == "guestbook_edit")
	{
		$("form").eq(0).submit(EditGuestBook);
	}
	else if (_page == "type_add")
	{
		$("form").eq(0).submit(AddType);
	}
	else if (_page == "type_edit")
	{
		$("form").eq(0).submit(EditType);
	}
	else if (_page == "type_list")
	{
		$("tr").each(function()
		{
			var id = this.id;
			
			$(this).find("form").submit(function(){return ModifyType(this, id);});

			$(this).find("a:last").click(function()
			{
				Confirm(_lang_confirm_delete, function(returnValue){if (returnValue)DeleteType(id);}, this);
				return false;
			});
		});
	}
	else if (_page == "category_add")
	{
		$("form").eq(0).submit(AddCategory);
	}
	else if (_page == "category_edit")
	{
		$("form").eq(0).submit(EditCategory);
	}
	else if (_page == "category_list")
	{
		$("tr").each(function()
		{
			var id = $(this).attr("ItemID");
			
			$(this).find("form").submit(function(){ModifyCategory(this, id);return false;});
			$(this).find("[sort=" + id + "]").mouseover(function(){this.className += " Move_MouseOver";}).mouseout(function(){this.className="Move";});

			$(this).find("a:last").click(function()
			{
				Confirm(_lang_confirm_delete, function(returnValue){if (returnValue)DeleteCategory(id);}, this);
				return false;
			});
		});
		
		InitMove(null,"Move", null, MoveCategory);
	}
	else if (_page == "config_basic")
	{
		$("form").eq(0).submit(SetBasicSettings);
		$("#HtmlEncode").click(HtmlEncode);
	}
}
Init(true);