﻿<%@ Page CodeFileBaseClass="AliCMS.Lib.SystemPageBase" %>
<ali:Get ID="Config" Object="InstanceConfig" Operation="GetBasicSettings()" />
<script language="c#" runat="server">
protected string Condition()
{
	StringBuilder condition = new StringBuilder();
	string and = String.Empty;

	#region 是否审核
	string isChecked = Request.QueryString["IsChecked"];
	if (isChecked == null && Request.Cookies["IsChecked"] != null)
		isChecked = Request.Cookies["IsChecked"].Value;

	if (isChecked == null)
		condition.Append(and + Alias.GuestBook.IsChecked + "=true");
	else if (isChecked != String.Empty && isChecked != "*")
		condition.Append(and + Alias.GuestBook.IsChecked + "=" + isChecked);
	#endregion

	if (and == String.Empty && condition.Length != 0)
		and = " AND ";

	#region 类别
	string categoryID = Request.QueryString["CategoryID"];
	if (!String.IsNullOrEmpty(categoryID))
	{
		if (categoryID == "0")
			condition.Append(and + Alias.GuestBook.CategoryID + " IS NULL");
		else
			condition.Append(and + Alias.GuestBook.CategoryID + "=" + categoryID);
	}
	#endregion

	if (and == String.Empty && condition.Length != 0)
		and = " AND ";

	#region 关键词
	string keyword = Request.QueryString["Keyword"];
	if (!String.IsNullOrEmpty(keyword))
	{
		switch (Request.QueryString["KeywordType"])
		{
			case "Subject":
				condition.Append(and + Alias.GuestBook.Subject + " LIKE '%" + keyword + "%'");
				break;
			case "Content":
				condition.Append(and + Alias.GuestBook.Content + " LIKE '%" + keyword + "%'");
				break;
			case "Name":
				condition.Append(and + Alias.GuestBook.Name + " LIKE '%" + keyword + "%'");
				break;
		}
	}
	#endregion
	
	return condition.ToString();
}

protected string Sort()
{
	string sort = String.Empty;
	switch (Request.QueryString["Sort"])
	{
		case "1":
			sort = Alias.GuestBook.CreateTime + " DESC";
			break;
		case "2":
			sort = Alias.GuestBook.CreateTime + " ASC";
			break;
		default:
			sort = Alias.GuestBook.CreateTime + " DESC";
			break;
	}
	
	return sort;
}
</script>
<ali:List ID="List" Object="GuestBook" Page="PageNumber" PageSize="5" Condition="Condition()" Sort="Sort()" Validate="True">
	<ali:Record>
		<div id="Record<%=InnerID%>">
			<ul class="Title">
				<li class="Left"></li>
				<li class="Middle"><a href="../guest_book/edit.aspx?Lang=<%=ContentLang%>&ID=<%=InnerID%>">编辑</a><input type="checkbox" name="Sel" value="<%=InnerID%>" /></li>
				<li class="Right"></li>
			</ul>
			<table align="center" cellpadding="4" cellspacing="1">
				<tr>
					<td rowspan="3" class="Left">
						<img src="<%=Head%>" /><br />
						<span class="<%=ContentLang%>Font"><%=Name%></span>
						<div>
							<strong>QQ：</strong><%=QQ%><br />
							<strong>Email：</strong><%=Email%><br />
							<strong>主页：</strong><%=Homepage%><br />
							<strong>IP：</strong><%=IP%><br />
							<strong>是否保密：</strong>
								<%If Convert.ToBoolean(Private)%>
									是
								<%Else%>
									否
								<%EndIf%>
						</div>
					</td>
					<td>
						<span class="Subject <%=ContentLang%>Font"><a href="../guest_book/edit.aspx?Lang=<%=ContentLang%>&ID=<%=InnerID%>"><%=HttpUtility.HtmlEncode(Convert.ToString(Subject))%></a></span>
						<span class="Time">发布于：<%=CreateTime%></span>
					</td>
				</tr>
				<tr>
					<td class="<%=ContentLang%>Font">
						<%If Convert.ToBoolean(Config[EnableHtmlEditor])%>
							<%=Content%>
						<%Else%>
							<%=HttpUtility.HtmlEncode(Convert.ToString(Content))%>
						<%EndIf%>
					</td>
				</tr>
				<tr>
					<td class="Reply <%=ContentLang%>Font">
						<%=Reply%>
					</td>
				</tr>
			</table>
		</div>
	</ali:Record>
</ali:List>
<ali:Pagination Page="PageNumber" PageSize="5" RecordCount="List[RecordCount]">
	<div class="Pagination">
		<div class="Left">共 <%=RecordCount%> 条 当前显示第 <%=PageNumber%> 页 第 <%=RangeLower%>-<%=RangeUpper%> 条 </div>
		<div class="Right">
			<ali:FirstPage>
				<ali:Yes>
					<img src="<%=ImagePath%>pagination/first_page_off.gif"/>
					<img src="<%=ImagePath%>pagination/previous_page_off.gif"/>
				</ali:Yes>
				<ali:No>
					<a href="javascript:Go(1)"><img src="<%=ImagePath%>pagination/first_page_on.gif"/></a>
					<a href="javascript:Go(<%=PageNumber%> - 1)" id="PrevPage"><img src="<%=ImagePath%>pagination/previous_page_on.gif"/></a>
				</ali:No>
			</ali:FirstPage>
			<ali:CurrentPage Range="5">
				<ali:Yes>
					<span class="Current"><%=Index%></span>						
				</ali:Yes>
				<ali:No>
					<a href="javascript:Go(<%=Index%>)">[<%=Index%>]</a>
				</ali:No>
			</ali:CurrentPage>
			<ali:LastPage>
				<ali:Yes>
					<img src="<%=ImagePath%>pagination/next_page_off.gif"/>
					<img src="<%=ImagePath%>pagination/last_page_off.gif"/>
				</ali:Yes>
				<ali:No>
					<a href="javascript:Go(<%=PageNumber%> + 1)" id="NextPage"><img src="<%=ImagePath%>pagination/next_page_on.gif"/></a>
					<a href="javascript:Go(<%=PageCount%>)"><img src="<%=ImagePath%>pagination/last_page_on.gif"/></a>
				</ali:No>
			</ali:LastPage>
		</div>
	</div>
</ali:Pagination>