﻿function BuildHeader()
{
	if (_page == 'admin_list')
		return BuildAjaxPath(true) + '?Lang=' + _lang + '&IsRecycled=' + $('#IsRecycled').val() + '&RoleID=' + $('#RoleID').val() + '&Page=' + _pageNumber;
	else if (_page == 'log_list')
		return BuildAjaxPath(true) + '?Lang=' + _lang + '&Page=' + _pageNumber;
	else if (_page == 'link_category_list')
		return BuildAjaxPath(true) + '?Lang=' + _lang + '&IsDisplay=' + $('#IsDisplay').val() + '&IsRecommended=' + $('#IsRecommended').val() + '&IsHeld=' + $('#IsHeld').val() + '&Sort=' + $('#Sort').val();
	else if (_page == 'link_list')
		return BuildAjaxPath(true) + '?Lang=' + _lang + '&IsChecked=' + $('#IsChecked').val() + '&CategoryID=' + $('#CategoryID').val() + '&IncludeSubCategory=' + $('#IncludeSubCategory')[0].checked + '&Sort=' + $('#Sort').val() + '&Keyword=' + encodeURIComponent($('#Keyword').val()) + '&KeywordType=' + $('#KeywordType').val() + '&Page=' + _pageNumber;
	else if (_page == 'module_list')
		return BuildAjaxPath(true) + '?Lang=' + _lang + '&Page=' + _pageNumber;
	else if (_page == 'player_list')
		return BuildAjaxPath(true) + '?Lang=' + _lang + '&Page=' + _pageNumber;
	else if (_page == 'menu_list')
		return BuildAjaxPath(true) + '?Lang=' + _lang + '&CategoryID=' + $('#CategoryID').val();
	else if (_page == 'privilege')
		return BuildAjaxPath(true) + '?Lang=' + _lang + '&InstanceID=' + $('#InstanceID').val() + '&CurrentLang=' + $('#CurrentLang').val() + '&RoleID=' + $('#RoleID').val();
	else if (_page == 'skin_list')
		return BuildAjaxPath(true) + '?Lang=' + _lang + '&Page=' + _pageNumber;
	else if (_page == 'template_list')
		return BuildAjaxPath(true) + '?Lang=' + _lang + '&Page=' + _pageNumber;
	else if (_page == 'template_dictionary_list')
		return BuildAjaxPath(true) + '?Lang=' + _lang + '&TemplatePath=' + _templatePath + '&Language=' + document.forms[0].TargetLanguageAb.value + '&Page=' + _pageNumber;
	else if (_page == 'template_menu_list')
		return BuildAjaxPath(true) + '?Lang=' + _lang + '&TemplatePath=' + _templatePath + '&Namespace=' + $('#Namespace').val() + '&Page=' + _pageNumber;
	else if (_page == 'config_rewrite')
		return BuildAjaxPath(true) + '?Lang=' + _lang + '&Page=' + _pageNumber;
	else if (_page == 'generate_manual_list')
		return BuildAjaxPath(true) + '?Lang=' + _lang + '&ChannelID=' + $('#ChannelID').val();
	else if (_page == 'module_dictionary_list')
		return BuildAjaxPath(true) + '?Lang=' + _lang + '&Keyword=' + encodeURIComponent($('#Keyword').val()) + '&KeywordType=' + $('#KeywordType').val() + '&Namespace=' + _namespace + '&Page=' + _pageNumber;
	else
	    return BuildAjaxPath();
}

function Search()
{
	if (arguments.length > 0 && typeof(arguments[0]) != 'object')
		_pageNumber = arguments[0];
	
	SetStatusMessage(_lang_working);

	$.ajax(
	{
		url: BuildHeader(),
		data: {},
		type: 'POST',
		error: function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success: function(data)
		{
			var list = $('#List');

			list.html(HandleFake404(data, 'text'));
			SetStatusMessage();

			if (typeof(SetupIme) == 'function')
				SetupIme();
				
			MakeButton();
		}
	});
}

function MakeButton()
{
	var buttons = '';
	var button;
	
	//审核
	button = $('#IsChecked');
	if (button.length == 1)
	{
	    if (button[0].selectedIndex == 1)
		    buttons += '<button class="Button" id="Check">' + _lang_check + '</button>';
	    else if (button[0].selectedIndex == 2)
		    buttons += '<button class="Button" id="UnCheck">' + _lang_uncheck + '</button>';
	}
	
	//回收
	button = $('#IsRecycled');
	if (button.length == 1)
	{
	    if (button[0].selectedIndex == 1)
	    {
		    buttons += '<button class="Button" id="Recycle">' + _lang_recycle + '</button>';
	    }
	    else if (button[0].selectedIndex == 2)
	    {
		    buttons += '<button class="Button" id="Delete">' + _lang_delete + '</button>';
		    buttons += '<button class="Button" id="Recover">' + _lang_recover + '</button>';
	    }
	}
	
	//显示
	button = $('#IsDisplay');
	if (button.length == 1)
	{
	    if (button[0].selectedIndex == 1)
		    buttons += '<button class="Button" id="Display">' + _lang_display + '</button>';
	    else if (button[0].selectedIndex == 2)
		    buttons += '<button class="Button" id="UnDisplay">' + _lang_undisplay + '</button>';
	}
	
	//置顶
	button = $('#IsHeld');
	if (button.length == 1)
	{
	    if (button[0].selectedIndex == 1)
		    buttons += '<button class="Button" id="Hold">' + _lang_hold + '</button>';
	    else if (button[0].selectedIndex == 2)
		    buttons += '<button class="Button" id="UnHold">' + _lang_unhold + '</button>';
	}
	
	//推荐
	button = $('#IsRecommended');
	if (button.length == 1)
	{
	    if (button[0].selectedIndex == 1)
		    buttons += '<button class="Button" id="Recommend">' + _lang_recommend + '</button>';
	    else if (button[0].selectedIndex == 2)
		    buttons += '<button class="Button" id="UnRecommend">' + _lang_unrecommend + '</button>';
	}

	$('#ExtraButton').html(buttons);
}

function SelectFile(type, path)
{
	var form = $('form')[0];
	switch (type)
	{
		case 'Menu/Thumbnail':
			form.Picture.value = path;
			$("#PictureView").attr('src', path);
			break;
	}	
}

function Style_OnChange()
{
	if (this.id == 'Custom')
	{
		$('#Custom')[0].checked ? $('[name=CustomStyle]').show() : $('[name=CustomStyle]').hide();
		return;
	}

    var result = '';

    if ($('#Bold')[0].checked)
        result = 'font-weight:bold';

    if ($('#Italic')[0].checked)
    {
        if (result != '')
            result += ';';

        result += 'font-style:italic';
    }

    if ($.trim($('#Color').val()) != '')
    {
        if (result != '')
            result += ';';

        result += 'color:' + $('#Color').val();
    }
    
    $('[name=CustomStyle]').val(result);
}

//-------------------------------------------------
//Start: 管理人员
function Admin()
{
	var __object = 'Admin',
		__base = new Base();

	function prepareData(form)
	{
		if (form.Name.value == '')
		{
			Alert(_lang_name_empty, function(){form.Name.select();}, this);
			return null;
		}
		
		if (!form.Email.value.match(/\w+([-+.]\w+)*@\w+([-.]\w+)*\.\w+([-.]\w+)*/))
		{
			Alert(_lang_email_incorrect, function(){this.Email.select();}, this);
			return false;
		}
		
		//data	
		var data = 'RoleID=' + form.RoleID.value;
		data += '&Name=' + encodeURIComponent(form.Name.value);
		data += '&Password=' + encodeURIComponent(form.Password.value);
		data += '&Email=' + encodeURIComponent(form.Email.value);
		data += '&RealName=' + encodeURIComponent(form.RealName.value);
		data += '&QQ=' + encodeURIComponent(form.QQ.value);
		data += '&MSN=' + encodeURIComponent(form.MSN.value);
		data += '&HasSelfLimitation=' + $('#HasSelfLimitationYes')[0].checked;
		
		return data;
	}

	this.add = function()
	{
		var data = prepareData(this);
		if (!data)
			return false;
	
		if (this.Password.value == '')
		{
			Alert(_lang_password_empty, function(){this.Password.select();}, this);
			return false;
		}

		__base.add({object:__object,data:data});
		
		return false;	
	};

	this.modify = function()
	{
		var data = prepareData(this);
		if (!data)
			return false;
	
		__base.modify({object:__object,data:data});
		return false;	
	};
	
	this.update = function(operation, id)
	{
		if (this.tagName == 'BUTTON')
			operation = this.id;

		__base.update(__object, operation, id);
	};
}
//End: 管理人员
//-------------------------------------------------

//--------------------------------------------------
//start:实例管理
function Instance()
{
	var __object = 'Instance',
		__base = new Base();
	
	function prepareData(form)
	{	
		if (form.Name.value == '')
		{
			Alert(_lang_name_empty, function(){form.Name.select();}, this);
			return null;
		}
		
		var data = 'Name=' + encodeURIComponent(form.Name.value);
		data += '&DatabeseProvider=' + form.DatabaseProvider.value;
		data += '&ConnectionString=' + encodeURIComponent(form.ConnectionString.value);
		if ($('#IsMultiUserYes').length)
			data += '&IsMultiUser=' + $('#IsMultiUserYes')[0].checked; 
		
		return data;
	};
	
	this.add = function()
	{
		var data = prepareData(this);
		if(!data)
			return false;
		
		data += '&ModuleID=' + this.ModuleID.value;
			
		__base.add({object:__object,data:data});
		
		return false;
	};
	
	this.modify = function()
	{
		var data = prepareData(this)
		if(!data)
			return false;
			
		__base.modify({object:__object,data:data});
		
		return false;	
	};
	
	this.modifyName = function()
	{
		if (this.Name.value == '')
		{
			Alert(_lang_name_empty, function(){this.Name.select();}, this);
			return null;
		}
				
		var data = data += '&Name=' + encodeURIComponent(this.Name.value);
		
		if (!data)
			return false;
	
		__base.modify({object:__object,data:data,id:$(this).closest('tr').attr('ItemID')});
		
		return false;
	};

	this.move = function(from, to)
 	{
  		var action = 'Move';
  		var sort = $('#Sort').val();
  		if (sort == '2' || sort == '3')
   			action = 'MoveRecommend';
  		else if (sort == '4' || sort == '5')
   			action = 'MoveHold';
 
	  __base.move(__object, action, from, to);
 	};
	
	this.del = function(id)
	{
		__base.post({object:__object,operation:'Delete',hasList:true,params:'ID=' +id});
	};
}
//end: 实例管理
//--------------------------------------------------

//--------------------------------------------------
//start:语言管理
function Language()
{
	var __object = 'Language',
		__base = new Base();
	
	this.add = function()
	{
		if (this.Ab.value == '')
		{
			Alert(_lang_ab_empty, function(){this.Ab.select();}, this);
			return false;
		}
		
		var data = prepareData(this)
		if(!data)
			return false;
		
		data += '&Ab=' + encodeURIComponent(this.Ab.value);		
		data += '&Direction=' + encodeURIComponent(this.Direction.value);
		if (this.Candidate.selectedIndex != 0)
		{
			var items = this.Candidate.value.split('|');
			data += '&ID=' + items[0];
		}
		
		__base.add({object:__object,data:data});
		
		return false;
	};
	
	this.modify = function()
	{
		var data = prepareData(this);
		if(!data)
			return false;
		
		__base.modify({object:__object,data:data});
		return false;
	};
	
	this.update =function(operation, id)
	{
		if(this.tagName == 'BUTTON')
			operation = this.id;
		
		__base.update(__object, operation, id);
	};
	
	this.onCandidateChange = function()
	{
		var form = this.form;
		if (this.selectedIndex == 0)
		{
			form.Name.disabled = false;
			form.Ab.disabled = false;
			form.Direction.disabled = false;
		}
		else
		{
			form.Name.disabled = true;
			form.Ab.disabled = true;
			form.Direction.disabled = true;
			
			var items = form.Candidate.value.split('|');
			form.Name.value = items[1];
			form.Ab.value = items[2];
			$(form.Direction).val(items[3]);
			form.FontFamily.value = items[4];
			form.Eot.value = items[5];
		}
	};
	
	function prepareData(form)
	{
		if (form.Name.value == '')
		{
			Alert(_lang_name_empty, function(){form.Name.select();}, this);
			return null;
		}
		
		var data = 'Name=' + encodeURIComponent(form.Name.value);
		data += '&FontFamily=' + encodeURIComponent(form.FontFamily.value);
		data += '&Eot=' + encodeURIComponent(form.Eot.value);

		return data;
	};
}
//end:语言管理
//--------------------------------------------------

//--------------------------------------------------
//start:链接管理
function Link()
{
	var __object = 'Link',
		__base = new Base();
	
	function prepareData(form)
	{
		if (form.Name.value == '')
		{
			Alert(_lang_name_empty, function(){form.Name.select();}, this);
			return null;
		}
		
		//data
		var data = "Name=" + encodeURIComponent(form.Name.value);
		if (form.CustomStyle.value != "")
	   	    data += "&Style=" + encodeURIComponent(" style=\"" + form.CustomStyle.value + "\"");
		data += "&CategoryID=" + form.CategoryID.value;
		data += "&URL=" + encodeURIComponent(form.URL.value);
		data += "&Email=" + encodeURIComponent(form.Email.value);
		data += "&QQ=" + encodeURIComponent(form.QQ.value);
		data += "&Phone=" + encodeURIComponent(form.Phone.value);
		data += "&Description=" + encodeURIComponent(form.Description.value);
		_uploadLogo = _uploader.NeedUpload("Logo");
		if (!_uploadLogo)
			data += "&Logo=" + encodeURIComponent(form.Logo.value);
			
		$(":submit")[0].disabled = true;
		SetStatusMessage(_lang_working);
		return data ;
	};
	
	this.add = function ()
	{
		var data = prepareData(this);
		if (!data)
			return false;
				
		__base.add({object:__object,data:data});
		return false;
	};
	this.modify = function()
	{
		var data = prepareData(this);
		if (!data)
			return false;
	
		__base.modify({object:__object,data:data});
		return false;	
	};
	
	this.modifyName = function()
	{
		if (this.Name.value == '')
		{
			Alert(_lang_name_empty, function(){this.Name.select();}, this);
			return false;
		}
		
		var data = 'Name=' + encodeURIComponent(this.Name.value);
		data += "&URL=" + encodeURIComponent(this.URL.value);
		__base.modify({object:__object,data:data,id:$(this).closest('tr').attr('ItemID')});
		
		return false;
	};

	
	this.move = function(from, to)
	{
		var action = 'Move';
		var sort = $('#Sort').val();
		if (sort == '2' || sort == '3')
			action = 'MoveRecommend';
		else if (sort == '4' || sort == '5')
			action = 'MoveHold';
		
		__base.move(__object, action, from, to);
	};

	this.update = function(operation, id)
	{
		if (this.tagName == 'BUTTON')
			operation = this.id;

		__base.update(__object, operation, id);
	};
}

//end: 链接管理
//--------------------------------------------------

//--------------------------------------------------
//start: 链接类别
function LinkCategory()
{
	var __object = 'LinkCategory',
		__base = new Base();
	
	function prepareData(form)
	{
		if (form.Name.value == '')
		{
			Alert(_lang_name_empty, function(){form.Name.select();}, this);
			return null;
		}

		//data
		var data = 'Name=' + encodeURIComponent(form.Name.value);
		if ($('#GuidCheckBox')[0].checked)
			data += '&ID=' + form.ID.value;
		data += '&ParentID=' + encodeURIComponent(form.ParentID.value);
		_uploadPicture = _uploader.NeedUpload('Picture');
		if (!_uploadPicture)
			data += '&Picture=' + encodeURIComponent(form.Picture.value);
		data += '&IsRecommended=' + $('#IsRecommendedYes')[0].checked;
		data += '&IsHeld=' + $('#IsHeldYes')[0].checked;
		data += '&IsDisplay=' + $('#IsDisplayYes')[0].checked;
		return data;
	};
			
	this.add = function ()
	{
		var data = prepareData(this);
		if (!data)
			return false;
			
		__base.add({object:__object,data:data});
		return false;
	};
	
	this.modifyName = function(form, id)
	{
		if (form.Name.value == '')
	    {
	  		Alert(_lang_name_empty, function(){form.Name.select();}, this);
	  	 	return false;
	  	}
	 
	 	var data = 'Name=' + encodeURIComponent(form.Name.value);
	 
	 	__base.modify({object:__object,data:data,id:$(this).closest('tr').attr('ItemID')});
	 
	 	return false;
	 };
	
	this.modify = function()
	{
		var data = prepareData(this);
		if (!data)
			return false;
	
		__base.modify({object:__object,data:data});
		return false;
	};
	
	this.update = function(operation, id)
	{
		if (this.tagName == 'BUTTON')
			operation = this.id;

		__base.update(__object, operation, id);
	};
	
	this.move = function(from, to)
	{
		var action = 'Move';
		var sort = $('#Sort').val();
		if (sort == '2' || sort == '3')
		action = 'MoveRecommend';
		else if (sort == '4' || sort == '5')
		action = 'MoveHold';
	
		__base.move(__object, action, from, to);
	};
	
	this.del = function(id)
	{
		__base.update(__object, 'Delete', id);
	};
}
// end: 链接类别
//---------------------------------------------------

//--------------------------------------------------
//start: 日志
function Log()
{
	var __object = 'Log',
		__base = new Base();
	
	this.update = function(operation, id)
	{
		if (this.tagName == "BUTTON")
			operation = this.id;
			
		if (operation == 'Delete')
			__base.update(__object, operation, id);
		else
			__base.post({object:__object,operation:operation,hasList:true});
	};
}
//end: 日志
//--------------------------------------------------

//--------------------------------------------------
//star:菜单管理
function Menu()
{
	var __object = 'Menu',
		__base = new Base(),
		__uploadThumbnail,
		__uploadFile;
		
	function prepareData(form)
	{
		if (form.Name.value == '')
		{
			Alert(_lang_name_empty, function(){form.Name.select();}, this);
			return false;
		}
		
		if (!IsAllowedType(form.Thumbnail.value, form.ThumbnailAllowedType.value))
		{
			Alert(_lang_thumbnail_type_must_be + form.ThumbnailAllowedType.value, function(){form.Thumbnail.select();}, this);
			return false;
		}
		
		if (!form.HitCount.value.match(/^\d+$/))
		{
			Alert(_lang_hit_count_incorrect, function(){form.HitCount.select();}, this);
			return false;
		}
	
		if (!form.DownCount.value.match(/^\d+$/))
		{
			Alert(_lang_down_count_incorrect, function(){form.DownCount.select();}, this);
			return false;
		}
	
		var data = 'Name=' + encodeURIComponent(form.Name.value);
		if ($('#GuidCheckBox')[0].checked)
			data += '&ID=' + form.ID.value;
		if (form.CustomStyle.value != '')
			data += '&Style=' + encodeURIComponent(' style="' + form.CustomStyle.value + '"');
		data += '&CategoryID=' + form.CategoryID.value;
		data += '&ParentID=' + form.ParentID.value;
		data += '&ChannelID=' + form.ChannelID.value;
		data += '&PageGenerate=' + $('[name=PageGenerate]:checked').val();
		data += '&PageTemplate=' + encodeURIComponent(form.PageTemplate.value);
		data += '&PageExtension=' + encodeURIComponent(form.PageExtension.value);		
		data += '&LinkType=' + encodeURIComponent($('[name=LinkType]:checked').val());
		data += '&Path=' + encodeURIComponent(form.Path.value);
		data += '&Target=' + form.Target.value;
		data += '&Type=' + form.Type.value;
		data += '&PlayerID=' + form.PlayerID.value;
		data += '&HitCount=' + form.HitCount.value;
		data += '&DownCount=' + form.DownCount.value;
		data += '&IsDisplay=' + $('#IsDisplayYes')[0].checked;
		data += '&Content=' + encodeURIComponent(CKEDITOR.instances[form.Content.id].getData());
	
		__uploadThumbnail = _uploader.NeedUpload('Thumbnail');
		if (!__uploadThumbnail)
			data += '&Thumbnail=' + encodeURIComponent(form.Thumbnail.value);
	
		__uploadFile = _uploader.NeedUpload('File');
		if (!__uploadFile)
			data += '&File=' + encodeURIComponent(form.File.value);
		
		return data;
	};
	
	this.add = function()
	{
		var data = prepareData(this)
		if(!data)
			return false;

		//页面标识
		var pageID = this.PageID.value;
		if (pageID == '')
			pageID = '{ID}';
		
		var guid = __base.add({object:__object,data:data,silent:true});
		if (guid)
		{
			var id = __base.post({object:__object,operation:'GetInnerIDFromGuid',params:'ID=' + guid,silent:true});
			setPageID(pageID, guid, id);
		}

		return false;
	};
	
	this.modify = function()
	{
		var data = prepareData(this)
		if(!data)
			return false;
		
		var pageID = this.PageID.value;
		pageID = pageID.replace(/\{Guid\}/g, _guid)
		pageID = pageID.replace(/\{ID\}/g, _id)
		data += '&PageID=' + encodeURIComponent(pageID);

		__base.modify({object:__object,data:data,silent:true});
		uploadThumbnail(_id);

		return false;
	};
	
	function setPageID(pageID, guid, id)
	{
		pageID = pageID.replace(/\{Guid\}/g, guid);
		pageID = pageID.replace(/\{ID\}/g, id);
		
		__base.post({object:__object,operation:'Modify',data:'PageID=' + pageID,params:'ID=' + id,silent:true});
		uploadThumbnail(id);
	}
	
	function uploadThumbnail(id)
	{
		if (!__uploadThumbnail)
		{
			uploadFile(id);
			return;
		}
		
		_uploader.Init({Status:_lang_uploading_thumbnail,Params:'Lang=' + _lang + '&Object=' + __object + '&Operation=UploadThumbnail&ID=' + id});
		_uploader.Upload('Thumbnail', function()
		{
			if (arguments[0] != 0)
			{
				Alert(arguments[1]);
				SetStatusMessage();
				$(':submit')[0].disabled = false;
			}
			else
			{
				uploadFile(id);
			}
		});
	}
	
	function uploadFile(id)
	{
		if (!__uploadFile)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
			$(':submit')[0].disabled = false;
			return;
		}
		
		_uploader.Init({Status:_lang_uploading_file,Params:'Lang=' + _lang + '&Object=' + __object + '&Operation=UploadFile&ID=' + id});
		_uploader.Upload('File', function()
		{
			if (arguments[0] != 0)
				Alert(arguments[1]);
			else
				Alert(_lang_operation_success);
			SetStatusMessage();
			$(':submit')[0].disabled = false;
		});
	}
	
	this.modifyName = function()
	{
		if (this.Name.value == '')
		{
			Alert(_lang_name_empty, function(){this.Name.select();}, this);
			return false;
		}
		
		var data = 'Name=' + encodeURIComponent(this.Name.value);
		
		__base.modify({object:__object,data:data,id:$(this).closest('tr').attr('ItemID')});
		
		return false;
	};
 
	this.move = function(from, to)
	{
		var action = 'Move';
		var sort = $('#Sort').val();
		if (sort == '2' || sort == '3')
			action = 'MoveRecommend';
		else if (sort == '4' || sort == '5')
			action = 'MoveHold';
		
		__base.move(__object, action, from, to);
	};
	
	this.getParentList = function()
	{
		var form = $('form')[0];

		SetStatusMessage(_lang_parent);

		$.post('ajax_get_parent_list.aspx?Lang=' + _lang + '&CategoryID=' + form.CategoryID.value, function(data)
		{
			form.ParentID.length = 1;
			$(form.ParentID).append(data);
			SetStatusMessage();
		});
	};

	this.selectThumbnail = function()
	{
		__base.showDialog({fileBrowse:true,type:'Menu/Thumbnail',listByPicture:true,root:_root});
	};	
	
	this.selectFile = function()
	{
		__base.showDialog({fileBrowse:true,type:'Menu/File',listByPicture:true,root:_root});
	};
	
	this.del = function(id)
	{
		__base.post({object:__object,operation:'Delete',hasList:true,params:'ID=' +id});
	};		
}
//end:菜单管理
//--------------------------------------------------

//--------------------------------------------------
//star:菜单类别管理
function MenuCategory()
{
	var __object = 'MenuCategory',
		__base = new Base();
		
	function prepareData(form)
	{
		if (form.Name.value == '')
		{
			Alert(_lang_name_empty, function(){form.Name.select();}, this);
			return null;
		}
	
		var data = 'ParentID=' + form.ParentID.value;
		data += '&Name=' + encodeURIComponent(form.Name.value);
		if ($('#GuidCheckBox')[0].checked)
			data += "&ID=" + form.ID.value;
			
		return data;
	}
	
	this.add = function()
	{
		var data = prepareData(this)
		if(!data)
			return false;
			
		__base.add({object:__object,data:data});
		
		return false;
	};
	
	this.modifyName = function(form, id)
	{
		if (form.Name.value == '')
		{
			Alert(_lang_name_empty, function(){form.Name.select();}, this);
			return false;
		}
		
		var data = 'Name=' + encodeURIComponent(form.Name.value);
	
		__base.modify({object:__object,data:data,id:$(this).parent().attr('ItemID')});		
		return false;
	};

	
	this.modify = function()
	{
		var data = prepareData(this);
		if(!data)
			return false;
			
		__base.modify({object:__object,data:data});
		return false;
	};
	
	this.update =function(operation,id)
	{
		if(this.tagName == 'BUTTON')
			operation = this.id;
		
		__base.update({object:__object,operation:operation});
	};
	
	this.move = function(from, to)
	{
		var action = 'Move';
		var sort = $('#Sort').val();
		if (sort == '2' || sort == '3')
			action = 'MoveRecommend';
		else if (sort == '4' || sort == '5')
			action = 'MoveHold';
	
		__base.move(__object, action, from, to);
	};
	
	this.del = function(id)
	{
		__base.update(__object, 'Delete', id);
	};

}
//end:菜单类别管理
//--------------------------------------------------

//--------------------------------------------------
//start:模块管理_词典管理
function ModuleDictionary()
{
	var __object = 'Module.Dictionary',
		__base = new Base();
		
	function prepareData(form)
	{
		if (form.Name.value == '')
		{
			Alert(_lang_name_empty, function(){form.Name.select();}, this);
			return false;
		}
		
		var data = 'Name=' + encodeURIComponent(form.Name.value);
		data += '&Content=' + encodeURIComponent(form.Content.value);
		
		return data;
	};
		
	this.add = function()
	{
		var data = prepareData(this)
		if(!data)
			return false;
		
		__base.post({object:__object,operation:'Add',data:data,params:'Namespace=' + _namespace});
		return false;
	};
	
	this.modify = function()
	{
		var row = $(this).closest('tr');
		var name = $('[name=Name]', row);
		var content = $('[name=Content]', row);

  		if (name.val() == '')
  		{
   			Alert(_lang_name_empty, function(){name[0].select();}, this);
   			return false;
  		}
 
		var data = 'Name=' + encodeURIComponent(name.val());
		data += '&Content=' + encodeURIComponent(content.val());
 
		__base.post({object:__object,operation:'Modify',data:data,params:'Name=' + row.data('id') + '&Namespace=' + _namespace});
 
  		return false;
	};
		
	this.del = function(id)
	{
		var row = $(this).closest('tr');
		var id = row.data('id');
		Confirm(_lang_confirm_delete, function (returnValue)
		{
			if (returnValue)
			{
				__base.post({object:__object,operation:'Delete',params:'Name=' + row.data('id') + '&Namespace=' + _namespace});
				row.remove();
			}
		}, this);

		return false;
	};
}
//end:模块管理_词典管理
//--------------------------------------------------

//--------------------------------------------------
//start:管理模块_操作管理
function ModuleObjectOperation()
{
	var __object = 'Module.Object.Operation',
		__base = new Base();
	
	function prepareData(form)
	{
		if (form.Label.value == '')
		{
			Alert(_lang_label_empty, function(){form.Label.select();}, this);
			return null;
		}
		
		if (form.Name.value == '')
		{
			Alert(_lang_name_empty, function(){form.Name.select();}, this);
			return null;
		}
		
		var data = 'Name=' + encodeURIComponent(form.Name.value);
		data += '&Label=' + encodeURIComponent(form.Label.value);
		
		return data;
	};
	
	this.add = function()
	{
		var data = prepareData(this)
		if(!data)
			return false;

		if ($('#GuidCheckBox')[0].checked)
			data += '&ID=' + form.ID.value;
		
		__base.post({object:__object,operation:'Add',data:data,params:'Namespace=' + _namespace + '&ObjectID=' + _objectID});
		return false;
	};
	
	this.modify = function()
	{
		var data = prepareData(this)
		if(!data)
			return false;
			
		__base.post({object:__object,operation:'Modify',data:data,params:'Namespace=' + _namespace + '&ObjectID=' + _objectID + '&ID=' + _id});
		return false;
	};
	
	this.modifyName = function(form, id)
	{	
		if (form.Label.value == '')
		{
			Alert(_lang_label_empty, function(){form.Label.select();}, this);
			return null;
		}
		if(form.Name.value == '')
		{
			Alert(_lang_name_empty,function(){form.Name.select();},this)
			return null;
		}
		
		var data ='Name=' + encodeURIComponent(form.Name.value);
		data += '&Label=' + encodeURIComponent(form.Label.value);
		
		__base.post({object:__object,operation:'Modify',data:data,params:'Namespace=' + _namespace + '&ObjectID=' + _objectID + '&ID=' + id});
		
		return false;
	}
	
	this.update = function(operation,id)
	{
		if(this.tagName =='BUTTON')
			operation = this.id;
			
		__base.post({object:__object,operation:operation,hasList:true,params:'Namespace=' + _namespace + '&ObjectID=' + _objectID + '&ID=' + id});
	}
}
//end:管理模块_操作管理
//--------------------------------------------------

//--------------------------------------------------
//start:管理模块_属性管理
function ModuleObjectProperty()
{
	var __object = 'Module.Object.Property',
		__base = new Base();
	
	function prepareData(form)
	{
		if (form.Name.value == '')
		{
			Alert(_lang_name_empty, function(){form.Name.select();}, this);
			return false;
		}
	
		if (!form.MaxLength.value.match(/^\d*$/))
		{
			Alert(_lang_max_length_incorrect, function(){form.MaxLength.select();}, this);
			return false;
		}
	
		if (!form.NumericPrecision.value.match(/^\d*$/))
		{
			Alert(_lang_numeric_precision_empty, function(){form.NumericPrecision.select();}, this);
			return false;
		}
	
		if (!form.NumericScale.value.match(/^\d*$/))
		{
			Alert(_lang_numeric_scale_empty, function(){form.NumericScale.select();}, this);
			return false;
		}
	
		var data = 'Name=' + encodeURIComponent(form.Name.value);
		data += '&FieldName=' + encodeURIComponent(form.FieldName.value);
		data += '&IsNullable=' + $('#IsNullableYes')[0].checked;
		data += '&SqlDbDefault=' + encodeURIComponent(form.SqlDbDefault.value);
		data += '&OleDbDefault=' + encodeURIComponent(form.OleDbDefault.value);
		data += '&SqlDbType=' + form.SqlDbType.value;
		data += '&OleDbType=' + form.OleDbType.value;
		data += '&MaxLength=' + form.MaxLength.value;
		data += '&NumericPrecision=' + form.NumericPrecision.value;
		data += '&NumericScale=' + form.NumericScale.value;
		data += '&IsIdentity=' + $('#IsIdentityYes')[0].checked;
		data += '&MultiLanguage=' + $('#MultiLanguageYes')[0].checked;
		data += '&PrimaryKey=' + $('#PrimaryKeyYes')[0].checked;
		data += '&Unique=' + $('#UniqueYes')[0].checked;
		data += '&IsMeta=' + $('#IsMetaYes')[0].checked;
		data += '&MainTableID=' + form.MainTableID.value;
		data += '&MainFieldID=' + form.MainFieldID.value;
		data += '&UpdateRule=' + $("#UpdateRuleYes")[0].checked;
		data += '&DeleteRule=' + $("#DeleteRuleYes")[0].checked;
		
		return data ;
	};
	
	this.add = function()
	{
		var data = prepareData(this)
		if(!data)
			return false;

		if ($('#GuidCheckBox')[0].checked)
			data += '&ID=' + form.ID.value;

		__base.post({object:__object,operation:'Add',data:data,params:'Namespace=' + _namespace + '&ObjectID=' + _objectID});
		return false;
	};
	
	this.modify = function()
	{
		var data = prepareData(this)
		if(!data)
			return false;
			
		__base.post({object:__object,operation:'Modify',data:data,params:'Namespace=' + _namespace + '&ObjectID=' + _objectID + '&ID=' + _id});
		return false;	
	};
	
	this.modifyName = function(form, id)
	{
		if (form.Name.value == '')
		{
			Alert(_lang_name_empty, function(){form.Name.select();}, this);
			return false;
		}
		
		var data = 'Name=' + encodeURIComponent(form.Name.value);
		
		__base.post({object:__object,operation:'Modify',data:data,params:'Namespace=' + _namespace + '&ObjectID=' + _objectID + '&ID=' + id});
		
		return false;
	};
	
	this.move = function(from, to)
	{
		__base.move(__object, 'Move', from, to, 'Namespace=' + _namespace + '&ObjectID=' + _objectID);
	};
	
	this.update = function(operation,id)
	{
		if(this.tagName =='BUTTON')
			operation = this.id;
			
		__base.post({object:__object,operation:operation,hasList:true,params:'Namespace=' + _namespace + '&ObjectID=' + _objectID + '&ID=' + id});
	};
	
	this.onSqlDbTypeChange = function()
	{
		var form = this.form;
		var oleDbType = $('[name=OleDbType]')[0];
		switch (parseInt(form.SqlDbType.value))
		{
			case 8://Int
				CheckAndSelect(oleDbType, 3);
				break;
			case 12://NVarChar
				CheckAndSelect(oleDbType, 202);
				break;
			case 22://VarChar
				CheckAndSelect(oleDbType, 200);
				break;
			case 11://NText
				CheckAndSelect(oleDbType, 203);
				break;
			case 2://Bit
				CheckAndSelect(oleDbType, 11);
				break;
			case 15://SmallDateTime
				CheckAndSelect(oleDbType, 135);
				break;
			case 4://DateTime
				CheckAndSelect(oleDbType, 7);
				break;
			case 9://Money
				CheckAndSelect(oleDbType, 6);
				break;
			case 5://Decimal
				CheckAndSelect(oleDbType, 131);
				break;
			case 14://UniqueIdentifier
				CheckAndSelect(oleDbType, 72);
				break;
		}
	};
	
	this.onMainTableIDChange = function()
	{
		var form = document.forms[0];
		if (form.MainTableID.selectedIndex > 0)
		{
			form.MainFieldID.length = 0;
			
			var condition = AliCMS.SystemModule.Module_Object_Property.ModuleInnerID + ':' + _namespace;
			condition += ';' + AliCMS.SystemModule.Module_Object_Property.ObjectID + ':' + form.MainTableID.value;
		
			$.ajax(
			{
				url: _webPath + 'alicms.aspx?Lang=' + _lang + '&Object=Module.Object.Property&Operation=List&Condition=' + condition,
				type: 'GET',
				error: function(request)
				{
					Alert(_lang_operation_fail);
				},
				success: function(data)
				{
					var mainFieldIDSelect = form.MainFieldID;
					
					var xmlDoc = CreateXmlDom();
					xmlDoc.loadXML(data);
					var itemList = xmlDoc.documentElement.childNodes;
					for (var i = 0; i < itemList.length; i++)
					{
						if (typeof (itemList[i].selectSingleNode) == 'undefined')
							continue;
							
						var id = itemList[i].selectSingleNode(AliCMS.SystemModule.Module_Object_Property.ID).text;
						var name = itemList[i].selectSingleNode(AliCMS.SystemModule.Module_Object_Property.Name).text;
	
						mainFieldIDSelect.options.add(new Option(name, id));
						
						if (_page == 'module_object_property_edit' && id == _mainFieldID)
						{
							mainFieldIDSelect.selectedIndex = mainFieldIDSelect.length - 1;
						}
					}
				}
			});
		}
		else
		{
			form.MainFieldID.length = 0;
		}
	};
}
//end:管理模块_属性管理
//--------------------------------------------------

//--------------------------------------------------
//start:管理模块_对象管理
function ModuleObject()
{
	var __object = 'Module.Object',
		__base = new Base();
	
	function prepareData(form)
	{
		if (form.Label.value == '')
		{
			Alert(_lang_label_empty, function(){form.Label.select();}, this);
			return null;
		}
		
		if (form.Name.value == '')
		{
			Alert(_lang_name_empty, function(){form.Name.select();}, this);
			return null;
		}
		
		var data = 'Name=' + encodeURIComponent(form.Name.value);
		data += '&Label=' + encodeURIComponent(form.Label.value);
		data += '&ParentID=' + encodeURIComponent(form.ParentID.value);
		data += '&TableName=' + encodeURIComponent(form.TableName.value);
	
		return data;
	}
	
	this.add = function()
	{
		var data = prepareData(this)
		if(!data)
			return false;

		if ($('#GuidCheckBox')[0].checked)
			data += '&ID=' + form.ID.value;

		__base.post({object:__object,operation:'Add',data:data,params:'Namespace=' + _namespace});
		return false;
	};
	
	this.modify = function()
	{
		var data = prepareData(this)
		if(!data)
			return false;
			
		__base.post({object:__object,operation:'Modify',data:data,params:'Namespace=' + _namespace + '&ID=' + _id});
		return false;
	};
	
	this.modifyName = function(form, id)
	{
		if (form.Label.value == '')
		{
			Alert(_lang_label_empty, function(){form.Label.select();}, this);
			return null;
		}
		
		if (form.Name.value == '')
		{
			Alert(_lang_name_empty, function(){form.Name.select();}, this);
			return null;
		}
		
		var data = 'Name=' + encodeURIComponent(form.Name.value);
		data += '&Label=' + encodeURIComponent(form.Label.value);
		
		__base.post({object:__object,operation:'Modify',data:data,params:'Namespace=' + _namespace + '&ID=' + id});
		
		return false;
	};
	
	this.move = function(from, to)
	{
		__base.move(__object, 'Move', from, to, 'Namespace=' + _namespace);
	};
	
	this.update = function(operation,id)
	{
		if(this.tagName =='BUTTON')
			operation = this.id;
			
		__base.post({object:__object,operation:operation,hasList:true,params:'Namespace=' + _namespace + '&ID=' + id});
	};
}
//end:管理模块_对象管理
//---------------------------------------------------

//---------------------------------------------------
//start:模块管理
function Module()
{
	var __object = 'Module',
		__base = new Base();
	
	function prepareData(form)
	{	
		if (form.Label.value == '')
		{
			Alert(_lang_label_empty, function(){form.Label.select();}, this);
			return false;
		}
			
		var data = '&Label=' + encodeURIComponent(form.Label.value);
		data += '&Description=' + encodeURIComponent(form.Description.value);
		
		return data;
	}
	
	this.add = function()
	{	
		if (this.Name.value == '' || !this.Name.value.match(/^[a-zA-Z]+$/g))
		{
			Alert(_lang_namespace_incorrect, function(){this.Name.select();}, this);
			return null;
		}

		if (this.Company.value == '' || !this.Company.value.match(/^[a-zA-Z]+$/g))
		{
			Alert(_lang_namespace_incorrect, function(){this.Company.select();}, this);
			return null;
		}

		this.Name.value = this.Name.value.substr(0, 1).toUpperCase() + this.Name.value.substr(1);
	
		var data = 'Name=' + encodeURIComponent(this.Name.value);
		    data += prepareData(this);
			data += '&Namespace=' + encodeURIComponent(this.Company.value + '.' + this.Name.value + 'Module');
		if(!data)
			return false;
				
		if ($('#GuidCheckBox')[0].checked)
			data += '&ID=' + this.ID.value;

		__base.add({object:__object,data:data});
		return false;
	};
	
	this.modify = function()
	{
		var dateTime = /^(\d{1,4})(-|\/)(\d{1,2})(-|\/)(\d{1,2})( (\d{1,2}):(\d{1,2}):(\d{1,2}))?$/;
		if (!dateTime.test(this.UpdateTime.value))
		{
			Alert(_lang_update_time_incorrect, function(){this.UpdateTime.select();}, this);
			return false;
		}	
		
		var data = prepareData(this);
		
		if (this.UpdateTime.value != '')
			data += '&UpdateTime=' + this.UpdateTime.value;
				
		if(!data)
			return false;
			
		__base.post({object:__object,operation:'Modify',data:data,params:'Namespace=' + _id});
		return false;
	};
			
	this.del = function(ns)
	{
		__base.post({object:__object,operation:'Delete',hasList:true,params:'Namespace=' + ns});
	};
	
	this.installModule = function()
	{
		if (this.File.value == '' || this.File.value.lastIndexOf('.zip') == -1)
		{
			Alert(_lang_format_incorrect);
			return false;
		}
	
		var form = this;
		$(':submit', form)[0].disabled = true;
		
		_uploader.Init({Status:_lang_uploading,Params:'Lang=' + _lang + '&Object=' + __object + '&Operation=Install'});
		_uploader.Upload('File', function()
		{
			if (arguments[0] != 0)
			{
				Alert(arguments[1]);
			}
			else
			{
				Alert(_lang_operation_success);
				Search(1);
			}
			SetStatusMessage();
			$(':submit', form)[0].disabled = false;
		});
	
		return false;
	};
	
	this.buildAlias = function()
	{
		var me = $(this);
		me.attr("disabled", true);
		SetStatusMessage(_lang_working);
	
		$.ajax(
		{
			url : _webPath + "alicms.aspx?Lang=" + _lang + "&Object=Module&Operation=BuildAlias",
			data : {},
			type : "POST",
			error : function(request)
			{
				Alert(_lang_operation_fail);
				SetStatusMessage();
				me.attr("disabled", false);
			},
			success : function(data)
			{
				Alert(_lang_operation_success);
				SetStatusMessage();
				me.attr("disabled", false);
			}
		});
	}
}
//end:模块管理
//---------------------------------------------------

//---------------------------------------------------
//start:在线客服
function OnlineService()
{
	var __object = 'OnlineService',
		__base = new Base();
		
	function prepareData(form)
	{
		if (form.Name.value == '')
		{
			Alert(_lang_name_empty, function(){form.Name.select();}, this);
			return false;
		}
		
		if (form.Account.value == '')
		{
			Alert(_lang_account_empty, function(){form.Account.select();}, this);
			return false;
		}
		
		var data = 'Name=' + encodeURIComponent(form.Name.value);
		data += '&Type=' + encodeURIComponent(form.Type.value);
		data += '&Account=' + encodeURIComponent(form.Account.value);
		
		return data;
	};
	
	this.add = function()
	{
		var data = prepareData(this);
		if(!data)
			return false;
			
		__base.add({object:__object,data:data});
		
		return false;
	};
	
	this.modify = function()
	{
		var data = prepareData(this);
		if(!data)
			return false;
			
		__base.post({object:__object,operation:'Modify',data:data,params:'ID=' + _id});
		
		return false;
	};
	
	this.move = function(form,to)
	{
		var action ='Move';
		var sort = $('#Sort').val();
		if (sort == '2' || sort == '3')
   		action = 'MoveRecommend';
   		else if (sort == '4' || sort == '5')
   		action = 'MoveHold';
 
 	    __base.move(__object, action, from, to);
 	};	
	
	this.del = function(id)
	{
		__base.post({object:__object,operation:'Delete',hasList:true,params:'ID=' +id});
	};		
}
//end:在线客服
//---------------------------------------------------

//---------------------------------------------------
//start:支付管理
function Payment()
{
	var __object = 'Payment',
		__base = new Base(),
		__uploadLogo;

	function prepareData(form)
	{
		if (form.Name.value == '')
		{
			Alert(_lang_name_empty, function(){form.Name.select();}, this);
			return null;
		}
		
		if (!IsAllowedType(form.Logo.value, form.LogoAllowedType.value))
		{
			Alert(_lang_type_must_be + form.LogoAllowedType.value, function(){form.Logo.select();}, this);
			return null;
		}
		
		var data = 'Name=' + encodeURIComponent(form.Name.value);
		data += '&Description=' + encodeURIComponent(form.Description.value);
		data += '&Type=' + encodeURIComponent(form.Type.value);
		data += '&AccountName=' + encodeURIComponent(form.AccountName.value);
		data += '&Account=' + encodeURIComponent(form.Account.value);
		data += '&Rate=' + form.Rate.value;
		if (form.Type.value == 'Alipay' || form.Type.value == 'Tenpay' || form.Type.value == 'ChinaBank')
		{
			data += '&PartnerID=' + encodeURIComponent(form.PartnerID.value);
			data += '&Key=' + encodeURIComponent(form.Key.value);
			data += '&IsOnline=true';
		}
		else
		{
			data += '&PartnerID=';
			data += '&Key=';
			data += '&IsOnline=false';
		}
		if (form.Type.value == 'Alipay')
			data += '&Service=' + form.Service.value;
		else
			data += '&Service=';

		__uploadLogo = _uploader.NeedUpload('Logo');
		if (!__uploadLogo)
			data += '&Logo=' + encodeURIComponent(form.Logo.value);
		
		return data;
	}

	this.add = function()
	{
		var data = prepareData(this);
		if (!data)
			return false;
	
		var guid = __base.add({object:__object,data:data,silent:true});
		if (guid)
		{
			var id = __base.post({object:__object,operation:'GetInnerIDFromGuid',params:'ID=' + guid,silent:true});
			uploadLogo(id);
		}

		return false;
	}

	this.modify = function()
	{
		var data = prepareData(this);
		if (!data)
			return false;
	
		__base.modify({object:__object,data:data,silent:true});
		uploadLogo(_id);

		return false;
	}

	function uploadLogo(id)
	{
		if (!__uploadLogo)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
			$(':submit')[0].disabled = false;
			return;
		}
	
		_uploader.Init({Status:_lang_uploading,Params:'Lang=' + _lang + '&Object=' + __object + '&Operation=UploadLogo&ID=' + id});
		_uploader.Upload('Logo', function()
		{
			if (arguments[0] != 0)
			{
				Alert(arguments[1]);
				SetStatusMessage();
				$(':submit')[0].disabled = false;
			}
			else
			{
				$('#LogoTextbox').val(arguments[1]);
				$('#LogoView').attr('src', arguments[1]);
				
				Alert(_lang_operation_success);
				SetStatusMessage();
				$(':submit')[0].disabled = false;
				return;
			}
		});
	}
	
	this.del = function(id)
	{
		__base.update(__object, 'Delete', id);
	};
	
	this.onTypeChange = function()
	{
		if (this.value == 'ChinaBank')
		{
			$('#pid>th').text(_lang_pid_chinabank);
			$('#key>th').text(_lang_key_chinabank);
		}
		else
		{
			$('#pid>th').text(_lang_pid);
			$('#key>th').text(_lang_key);
		}

		if (this.value == 'Alipay' || this.value == 'Tenpay' || this.value == 'ChinaBank')
			$('#pid,#key').show();
		else
			$('#pid,#key').hide();
		
		if (this.value == 'Alipay')
			$('#service').show();
		else
			$('#service').hide();
	};
	
	this.onEditInit = function()
	{
		$('#service select').val(_service);
		$('[name=Type]').val(_type).change();
	}
}
//end:支付管理
//---------------------------------------------------

//---------------------------------------------------
//start:播放器管理
function Player()
{
	var __object ='Player',
		__base = new Base();
	
	function prepareData(form)
	{
		if (form.Name.value == '')
		{
			Alert(_lang_name_empty, function(){form.Name.select();}, this);
			return false;
		}
	
		var data = 'Name=' + encodeURIComponent(form.Name.value);
		data += '&Code=' + encodeURIComponent(form.Code.value);
		data += '&PackExtention=' + encodeURIComponent(form.PackExtention.value);
		data += '&Pack=' + encodeURIComponent(form.Pack.value);
		data += '&Rule=' + encodeURIComponent(form.Rule.value);
		data += '&Type=' + $('[name=Type]:checked').val();
		data += '&Description=' + encodeURIComponent(form.Description.value);
		_uploadFile = _uploader.NeedUpload("File");
		if (!_uploadFile)
			data += '&File=' + encodeURIComponent(form.File.value);
			
		return data;
	};
	
	this.add = function()
	{
		var data = prepareData(this)
		if(!data)
			return false;
		
		__base.add({object:__object,data:data});
	
		return false;
	};
	
	this.modify = function()
	{
		var data = prepareData(this)
		if(!data)
			return false;
		
		__base.post({object:__object,operation:'Modify',data:data,params:'ID=' + _id});
		
		return false;
	};
	
	this.move = function(from,to)
	{
		var action ='Move';
		var sort = $('#Sort').val();
		if (sort == '2' || sort == '3')
   		action = 'MoveRecommend';
   		else if (sort == '4' || sort == '5')
   		action = 'MoveHold';
 
 	    __base.move(__object, action, from, to);
 	};	
	
	this.del = function(id)
	{
		__base.update(__object, 'Delete', id);
	};
}
//end:播放器管理
//---------------------------------------------------

//---------------------------------------------------
//start: 角色管理
function Role()
{
	var __object = 'Role' ,
		__base = new Base();
	
	function prepareData(form)
	{
		if (form.Name.value == '')
		{
			Alert(_lang_name_empty, function(){form.Name.select();}, this);
			return false;
		}
		
		var data = 'Name=' + encodeURIComponent(form.Name.value);
		data += '&Description=' + encodeURIComponent(form.Description.value);
		data += '&HasPrivilegeByDefault=' + $('#HasPrivilegeByDefaultYes')[0].checked;
		return data;
	};
	
	this.add =function()
	{
		var data = prepareData(this)
		if(!data)
			return false;
		
		__base.add({object:__object,data:data});
		return false;
	};
	
	this.modify = function()
	{
		var data = prepareData(this)
		if(!data)
			return false;
			
		__base.post({object:__object,operation:'Modify',data:data,params:'ID=' + _id});
		return false;
	};
	this.del = function(id)
	{
		__base.post({object:__object,operation:'Delete',hasList:true,params:'ID=' +id});
	};
}

function SavePrivilege()
{
	_addIndex = 0;
	_addList.length = 0;
	_deleteIndex = 0;
	_deleteList.length = 0;

    $('[name=OperationID]').each(function()
    {
        var me = $(this);
	    if (this.checked && me.attr('PrivilegeID') == '')
	    {
		    var data = 'InstanceID=' + $('#InstanceID').val() + '&Lang=' + $('#CurrentLang').val() + '&ObjectID=' + me.attr('ObjectID') + '&OperationID=' + me.val() + '&ObjectName=' + me.attr('ObjectName') + '&OperationName=' + me.attr('OperationName');
		    if ($('#RoleID').val() != '')
			    data += '&RoleID=' + $('#RoleID').val();

		    _addList[_addList.length] = new Object();
		    _addList[_addList.length - 1].ID = this.id;
		    _addList[_addList.length - 1].Data = data;
	    }
	    else if (!this.checked && me.attr('PrivilegeID') != '')
	    {
		    _deleteList[_deleteList.length] = new Object();
		    _deleteList[_deleteList.length - 1].ID = this.id;
		    _deleteList[_deleteList.length - 1].PrivilegeID = me.attr('PrivilegeID');
	    }
    });
	
	if (_addList.length == 0 && _deleteList.length == 0)
	{
		Alert(_lang_no_changes);
		return;
	}
	
	$('#Save').attr('disabled', true);
	SetStatusMessage(_lang_working);
	DeletePrivilege();
}

function DeletePrivilege()
{
	if (_deleteIndex >= _deleteList.length)
	{
		AddPrivilege();
		return;
	}

	$.ajax(
	{
		url : _webPath + 'alicms.aspx?Lang=' + _lang + '&Object=Privilege&Operation=Delete&ID=' + _deleteList[_deleteIndex++].PrivilegeID,
		data : {},
		type : 'POST',
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$('#Save').attr('disabled', false);
		},
		success : function(data)
		{
		    $('#' + _deleteList[_deleteIndex - 1].ID).attr('PrivilegeID', '');
			DeletePrivilege();
		}
	});
}

function AddPrivilege()
{
	if (_addIndex >= _addList.length)
	{
	    Alert(_lang_operation_success);
	    SetStatusMessage();
		$('#Save').attr('disabled', false);
		return;
	}

	$.ajax(
	{
		url : _webPath + 'alicms.aspx?Lang=' + _lang + '&Object=Privilege&Operation=Add',
		data : _addList[_addIndex++].Data,
		type : 'POST',
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$('#Save').attr('disabled', false);
		},
		success : function(data)
		{
	        $.ajax(
	        {
		        url : _webPath + 'alicms.aspx?Lang=' + _lang + '&Object=Privilege&Operation=GetInnerIDFromGuid&ID=' + data,
		        type : 'GET',
		        error : function(request)
		        {
			        Alert(_lang_operation_fail);
			        SetStatusMessage();
			        $('#Save').attr('disabled', false);
		        },
		        success : function(data)
		        {
		            $('#' + _addList[_addIndex - 1].ID).attr('PrivilegeID', data);
			        AddPrivilege();
		        }
		    });
		}
	});
}
//end: 角色管理
//---------------------------------------------------

//---------------------------------------------------
//start:皮肤管理
function Skin()
{
	var __object = 'Skin',
		__base = new Base();
	
	function prepareData(form)
	{
		if (form.TemplatePath.value == '')
		{
			Alert(_lang_select_template);
			return false;
		}
	
		if (form.Language.value == '')
		{
			Alert(_lang_select_language);
			return false;
		}
		
		var data = 'Path=' + encodeURIComponent(form.SkinPath.value);
		data += '&TemplatePath=' + encodeURIComponent(form.TemplatePath.value);
		data += '&Language=' + encodeURIComponent(form.Language.value);
		data += '&Name=' + encodeURIComponent(form.Name.value);
		data += '&Version=' + encodeURIComponent(form.Version.value);
		data += '&AuthorName=' + encodeURIComponent(form.AuthorName.value);
		data += '&AuthorID=' + encodeURIComponent(form.AuthorID.value);
		data += '&Organization=' + encodeURIComponent(form.Organization.value);
		data += '&Description=' + encodeURIComponent(form.Description.value);
		return data;
	};
	
	this.add = function()
	{
		var data = prepareData(this)
		if(!data)
			return false;
			
		__base.add({object:__object,data:data});
		return false;
	};
	
	this.modify = function()
	{	
		var data = "Name=" + encodeURIComponent(this.Name.value);
		data += "&Version=" + this.Version.value;
		data += "&AuthorName=" + this.AuthorName.value;
		data += "&AuthorID=" + this.AuthorID.value;
		data += "&Organization=" + this.Organization.value;
		data += "&Description=" + this.Description.value;
		
		if(!data)
			return false;
		
		__base.modify({object:__object,data:data,params:'Path=' + _id});
	};
	
	this.del = function(id)
	{
		__base.post({object:__object,operation:'Delete',hasList:true,params:'path=' + id});
	};
}
//大图
function UploadSkinPicture()
{
	if (!_uploader.NeedUpload("File"))
	{
		Alert(_lang_select_file);
		return false;
	}
	
	if (!this.Width.value.match(/^\d*$/))
	{
		Alert(_lang_width_incorrect, function(){this.Width.select();}, this);
		return false;
	}	
	
	if (!this.Height.value.match(/^\d*$/))
	{
		Alert(_lang_height_incorrect, function(){this.Height.select();}, this);
		return false;
	}
	
	if (!IsAllowedType(this.File.value, this.AllowedType.value))
	{
		Alert(_lang_type_must_be + this.AllowedType.value);
		return false;
	}
    
	SetStatusMessage(_lang_start_upload);
	_uploader.Init({Status:_lang_uploading,Params:"Lang=" + _lang + "&Object=Skin&Operation=UploadPicture&Path=" + _id});
	_uploader.Upload("File", function()
	{
        if (arguments[0] != 0)
            Alert(arguments[1]);
        else
            Alert(_lang_operation_success);
        SetStatusMessage();
        $(":submit")[0].disabled = false;
	});
	
	return false;
}

//缩略图
function UploadSkinThumbnail()
{
	if (!_uploader.NeedUpload("File"))
	{
		Alert(_lang_select_file);
		return false;
	}
	
	if (!IsAllowedType(this.File.value, this.AllowedType.value))
	{
		Alert(_lang_type_must_be + this.AllowedType.value);
		return false;
	}
    
    $(":submit")[0].disabled = true;
	SetStatusMessage(_lang_start_upload);
	_uploader.Init({Status:_lang_uploading,Params:"Lang=" + _lang + "&Object=Skin&Operation=UploadThumbnail&Path=" + _id});
	_uploader.Upload("File", function()
	{
        if (arguments[0] != 0)
            Alert(arguments[1]);
        else
            Alert(_lang_operation_success);
        SetStatusMessage();
        $(":submit")[0].disabled = false;
	});
	
	return false;
}
//翻译
function TranslateSkin()
{
	if ($('#To').val() == '')
	{
		Alert(_lang_select_target);
		return;
	}
	
	$('#Start').eq(0).attr('disabled', true);
	$('body').append(_lang_working);

	$.ajax(
	{
		url : _webPath + 'alicms.aspx?Lang=' + _lang + '&Object=Skin&Operation=Translate&Path=' + _path + '&To=' + encodeURIComponent($('#To').val()) + '&MoveImage=' + $('#MoveImage')[0].checked,
		data : {},
		type : 'POST',
		error : function(request)
		{
			$('body').append(_lang_operation_fail);
	        $('#Start').eq(0).attr('disabled', false);
		},
		success : function(data)
		{
			$('body').append(_lang_operation_success);
	        $('#Start').eq(0).attr('disabled', false);
		}
	});
}

//--------------------
//start:皮肤管理_样式管理
function SkinCss()
{
	var __object = 'Skin.Css',
		__base = new Base();
		
	function prepareData(form)
	{
		var data = 'Content=' + encodeURIComponent(form.Content.value);
		return data;
	};
	
	this.add = function()
	{
		if (!CheckFileName(this.Name.value))
		{
			Alert(_lang_file_name_invalid, function(){this.Name.select();}, this);
			return false;
		}
		
		var data = prepareData(this)
		if(!data)
			return false;
		
		data += '&Name=' + encodeURIComponent(this.Name.value + '.css');

		__base.post({object:__object,operation:'Add',data:data,params:'SkinPath=' + _skinPath});
		return false;
	};
	
	this.modify = function()
	{
		var data = prepareData(this)
		if(!data)
			return false;
		
		__base.post({object:__object,operation:'Modify',data:data,params:'Name=' + _id + '&SkinPath=' + _skinPath});
		return false;
	};

	this.del = function(id)
	{
		__base.post({object:__object,operation:'Delete',hasList:true,params:'Name=' + id + '&SkinPath=' + _skinPath});
	};
}

function CheckFileName(name)
{
	if (name.match(/^(CON\.)|(AUX\.)|(COM1\.)|(COM2\.)|(COM3\.)|(COM4\.)|(LPT1\.)|(LPT2\.)|(LPT3\.)|(PRN\.)|(NUL\.)/))
		return false;

	if (name.match(/^((CON)|(AUX)|(COM1)|(COM2)|(COM3)|(COM4)|(LPT1)|(LPT2)|(LPT3)|(PRN)|(NUL))$/))
		return false;
		
	if (name.length >= 255)
		return false;
	
	if (name.match(/"|'|\/|\\|:|\|/))
		return false;
	
	if (!name.match(/^[a-z]|[A-Z]|\d/))
		return false;
	
	return true;
};
//end: 皮肤管理_样式管理
//--------------------

//--------------------
//start: 皮肤管理_图片管理
function SkinImage()
{
	var __object = 'Skin.Image',
		__base = new Base();
		
	function prepareData(form)
	{
		if (!_uploader.NeedUpload("File"))
		{
			Alert(_lang_select_file);
			return false;
		}
		
		if (!IsAllowedType(form.File.value, form.AllowedType.value))
		{
			Alert(_lang_type_must_be + form.AllowedType.value);
			return false;
		}
		return data;
	};
	
	this.add = function()
	{
		var data = prepareData(this)
		if(!data)
			return false;
		
		__base.add({object:__object,data:data});
		return false;
	}
}

function Skin_GetLanguageList()
{
	SetStatusMessage(_lang_loading_language_list);

	$.ajax(
	{
		url : _webPath + 'alicms.aspx?Lang=' + _lang + '&Object=Language&Operation=List',
		type : 'POST',
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
			_xmlLanguage.loadXML(data);
			
			Skin_GetSkinList();
		}
	});
}

function Skin_GetSkinList()
{
	SetStatusMessage(_lang_loading_skin_list);

	$.ajax(
	{
		url : _webPath + 'alicms.aspx?Lang=' + _lang + '&Object=Skin&Operation=List',
		type : 'POST',
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
			var templateSelect = document.forms[0].TemplatePath;
			
			_xmlSkin.loadXML(data);
			var items = _xmlSkin.documentElement.childNodes;
			for (var i = 0; i < items.length; i++)
			{
				if (typeof (items[i].selectSingleNode) == 'undefined')
					continue;
						
				var templatePath = items[i].selectSingleNode(AliCMS.SystemModule.Skin.TemplatePath).text;
				var j = 0;
				for (; j < templateSelect.options.length; j++)
				{
					if (templateSelect.options[j].value == templatePath)
						break;
				}
				
				if (j < templateSelect.options.length)
					continue;
					
				templateSelect.options.add(new Option(templatePath, templatePath));
			}
			
			Skin_TemplatePath_OnChange();
			SetStatusMessage();
		}
	});
}

function Skin_TemplatePath_OnChange()
{
    var form = document.forms[0];
    
	var templateSelect = form.TemplatePath;
	if (templateSelect.selectedIndex == -1)
		return;
	
	var skinSelect = form.SkinPath;
	skinSelect.length = 1;
	var items = _xmlSkin.selectNodes("//Item[" + AliCMS.SystemModule.Skin.TemplatePath + "='" + templateSelect.value + "']");
	for (var i = 0; i < items.length; i++)
	{
		var path = items[i].selectSingleNode(AliCMS.SystemModule.Skin.Path).text;
		path = path.substr(templateSelect.value.length);
		path = path.substr(0, path.indexOf('/') + 1);
				
		var j = 0;
		for (; j < skinSelect.options.length; j++)
		{
			if (skinSelect.options[j].text == path)
				break;
		}
		
		if (j < skinSelect.options.length)
			continue;

		skinSelect.options.add(new Option(path, path));
	}
	
	var languageSelect = form.Language;
	languageSelect.length = 0;
	items = _xmlLanguage.documentElement.childNodes;
	for (var i = 0; i < items.length; i++)
	{
		if (typeof (items[i].selectSingleNode) == 'undefined')
			continue;
						
		var name = items[i].selectSingleNode(AliCMS.SystemModule.Language.Name).text;
		var ab = items[i].selectSingleNode(AliCMS.SystemModule.Language.Ab).text;

		languageSelect.options.add(new Option(name, ab));
	}	
    
}

function Skin_SkinPath_OnChange()
{
    var form = document.forms[0];
    
	var languageSelect = form.Language;
	languageSelect.length = 0;
	items = _xmlLanguage.documentElement.childNodes;
	
	if (form.SkinPath.value == '')
	{
		for (var i = 0; i < items.length; i++)
		{
			if (typeof (items[i].selectSingleNode) == 'undefined')
				continue;
						
			var name = items[i].selectSingleNode(AliCMS.SystemModule.Language.Name).text;
			var ab = items[i].selectSingleNode(AliCMS.SystemModule.Language.Ab).text;
	
			languageSelect.options.add(new Option(name, ab));
		}	
	}
	else
	{
		for (var i = 0; i < items.length; i++)
		{
			if (typeof (items[i].selectSingleNode) == 'undefined')
				continue;
						
			var name = items[i].selectSingleNode(AliCMS.SystemModule.Language.Name).text;
			var ab = items[i].selectSingleNode(AliCMS.SystemModule.Language.Ab).text;

			var nodeList = _xmlSkin.selectNodes("//Item[" + AliCMS.SystemModule.Skin.Path + "='" + form.TemplatePath.value + form.SkinPath.value + ab + "/']");
			if (nodeList.length > 0)
				continue;
	
			languageSelect.options.add(new Option(name, ab));
		}	
	}
}

function DeleteFile(id)
{
	SetStatusMessage(_lang_working);

	$.ajax(
	{
		url : _webPath + 'alicms.aspx?Lang=' + _lang + '&Object=Skin.Image&Operation=DeleteFile&FolderName=' + encodeURIComponent($('#Folder').val()) + '&FileName=' + id + '&SkinPath=' + _skinPath,
		data : {},
		type : 'POST',
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();

			$('#' + id).html("<span style='color:#333'>" + _lang_deleted + '</span>');
		}
	});
}

function DeleteFolder()
{
	if ($('#Folder').val() == '')
	{
		Alert(_lang_cant_delete_root);
		return;
	}
	
	SetStatusMessage(_lang_working);

	$.ajax(
	{
		url : _webPath + 'alicms.aspx?Lang=' + _lang + '&Object=Skin.Image&Operation=DeleteFolder&FolderName=' + encodeURIComponent($('#Folder').val()) + '&SkinPath=' + _skinPath,
		data : {},
		type : 'POST',
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
			
			var folder = $('#Folder')[0];
			folder.remove(folder.selectedIndex);
			folder.selectedIndex = folder.length - 1;
			Folder_OnChange();			
		}
	});
}

//end: 皮肤管理_图片管理
//--------------------

function SkinImage_AddFolder()
{
	var folderName = $("#FolderName").val();
	if (!CheckFileName(folderName))
	{
		Alert(_lang_file_name_invalid);
		return;
	}
	
	var folder = $("#Folder")[0];
	folderName = folder.value + "/" + folderName;
	var len = folder.value.length;
	for (var i = 0; i < len; i++)
	{
		if (folder.options[i].value == folderName)
		{
		    Alert(_lang_folder_exist);
			return;
		}
	}
	
	$("#AddFolder").eq(0).attr("disabled", true);
	SetStatusMessage(_lang_working);

	$.ajax(
	{
		url : _webPath + "alicms.aspx?Lang=" + _lang + "&Object=Skin.Image&Operation=AddFolder&FolderName=" + encodeURIComponent(folderName) + "&SkinPath=" + _skinPath,
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
	        $("#AddFolder").eq(0).attr("disabled", false);
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
	        $("#AddFolder").eq(0).attr("disabled", false);
	        
			var folderName = $("#Folder").val() + "/" + $("#FolderName").val();
			$("#FolderName").val("");
			$("#Folder")[0].options.add(new Option(folderName, folderName));
			$("#Folder")[0].selectedIndex = $("#Folder")[0].length - 1;
		}
	});
}
//end:皮肤管理
//---------------------------------------------------

//---------------------------------------------------
//start:模板管理
function Template()
{
	var __object = 'Template',
		__base = new Base();
	
	function prepareData(form)
	{
		if (form.Name.value == '')
		{
			Alert(_lang_name_empty, function(){form.Name.select();}, this);
			return false;
		}
		
		var data = 'Name=' + encodeURIComponent(form.Name.value);
		data += '&Version=' + encodeURIComponent(form.Version.value);
		data += '&SystemVersion=' + encodeURIComponent(form.SystemVersion.value);
		data += '&AuthorName=' + encodeURIComponent(form.AuthorName.value);
		data += '&AuthorID=' + encodeURIComponent(form.AuthorID.value);
		data += '&Organization=' + encodeURIComponent(form.Organization.value);
		data += '&Description=' + encodeURIComponent(form.Description.value);
		return data;
	};
	
	this.add = function()
	{		
		var data = 'Language=' + this.Language.value;
		var data = prepareData(this)
		if(!data)
			return false;
		
		__base.add({object:__object,data:data});
		return false;
	};
	
	this.modify = function()
	{
		var data = prepareData(this)
		if(!data)
			return false;
		
		__base.post({object:__object,operation:'Modify',data:data,params:'Path=' + _id});
		return false;
	};

	this.del = function(id)
	{
		__base.post({object:__object,operation:'Delete',hasList:true,params:'Path=' + encodeURIComponent(id) + '&Transfer=' + encodeURIComponent(BuildAjaxPath())});
	};		
}

function EncryptTemplate(id)
{
	SetStatusMessage(_lang_working);

	$.ajax(
	{
		url : _webPath + 'alicms.aspx?Lang=' + _lang + '&Object=Template&Operation=Encrypt&Path=' + id,
		data : {},
		type : 'POST',
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
		}
	});

    return false;
}

function DecryptTemplate(id)
{
	SetStatusMessage(_lang_working);

	$.ajax(
	{
		url : _webPath + 'alicms.aspx?Lang=' + _lang + '&Object=Template&Operation=Decrypt&Path=' + id,
		data : {},
		type : 'POST',
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
		}
	});

    return false;
}

function ClearTemplateCache(id)
{
	SetStatusMessage(_lang_working);

	$.ajax(
	{
		url : _webPath + 'alicms.aspx?Lang=' + _lang + '&Object=Template&Operation=ClearCache&Path=' + id,
		data : {},
		type : 'POST',
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
		}
	});

    return false;
}


//end:模板管理
//---------------------------------------------------

//---------------------------------------------------
//start: 模板管理_词典
function TemplateDictionary()
{
	var __object = 'Template.Dictionary',
		__base = new Base();
	
	function prepareData(form)
	{	
		var data = 'Name=' + encodeURIComponent(form.Name.value);
		data += '&From=' + encodeURIComponent(form.SourceLanguage.value);
		data += '&To=' + encodeURIComponent(form.TargetLanguage.value);
		return data;
	}
	
	this.add = function()
	{
		if (this.TargetLanguageAb.value == '')
		{
			Alert(_lang_target_language_empty);
			return false
		}

		var data = prepareData(this)
		if(!data)
			return false;
		
		__base.post({object:__object,operation:'Add',data:data,params:'TemplatePath=' + _templatePath + '&Language=' + this.TargetLanguageAb.value + '&Transfer=' + encodeURIComponent(BuildHeader())});
		return false;
	};
	
	this.modify = function(row)
	{
		var data = 'Name=' + encodeURIComponent($('[name=Name]', row).val());
		data += '&From=' + encodeURIComponent($('[name=SourceLanguage]', row).val());
		data += '&To=' + encodeURIComponent($('[name=TargetLanguage]', row).val());
			
		__base.post({object:__object,operation:'Modify',data:data,params:'ID=' + row.data('id') + '&TemplatePath=' + _templatePath + '&Language=' + document.forms[0].TargetLanguageAb.value});
		return false;
	};
	
	this.del = function(id)
	{
		__base.post({object:__object,operation:'Delete',hasList:true,params:'ID=' + id + '&TemplatePath=' + _templatePath + '&Language=' + document.forms[0].TargetLanguageAb.value + '&Transfer=' + encodeURIComponent(BuildHeader())});
	};
}


function TargetLanguageAb_OnChange()
{
	SetCookie('TargetLanguageAb', this.value, 10*360*24*60);
	$(this.form.TargetLanguage).attr('class', 'Text' + this.value + 'Font');
	Search(1);
}

function GetChineseString()
{
	SetStatusMessage(_lang_working);

	$.ajax(
	{
		url : _webPath + 'alicms.aspx?Lang=' + _lang + '&Object=Template.Dictionary&Operation=GetString&TemplatePath=' + _templatePath + '&Language=' + document.forms[0].TargetLanguageAb.value + '&Transfer=' + encodeURIComponent(BuildHeader()),
		data : {},
		type : 'POST',
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();

			$('#List').html(HandleFake404(data, 'text'));
			//Init();

			if (typeof(SetupIme) == 'function')
				SetupIme();
		}
	});
}

//end:  模板管理_词典
//---------------------------------------------------

//---------------------------------------------------
//start: 模板管理_绑定
function TemplateModule()
{
	var __object = 'Template.Module'
		__base = new Base();
	
	this.add = function()
	{
		var data = prepareData(this)
		if(!data)
			return false;

		__base.post({object:__object,operation:'Add',data:data,hasList:true,params:'TemplatePath=' + _templatePath});
		return false;
	};

	this.del = function(id)
	{
		__base.post({object:__object,operation:'Delete',hasList:true,params:'_Mark=' + id + '&TemplatePath=' + _templatePath});
		return false;
	};
	
	function prepareData(form)
	{
		var data = 'ModuleID=' + form.ModuleID.value;
		data += '&Mark=' + encodeURIComponent(form.Mark.value);
		data += '&JustData=' + form.JustData.checked;
		return data;
	}
}
//end:  模板管理_绑定
//---------------------------------------------------

//---------------------------------------------------
//start:模板管理_菜单管理
function TemplateMenu()
{
	var __object = 'Template.Menu',
		__base  = new Base();
	
	function prepareData(form)
	{
		if (form.Name.value == '')
		{
			Alert(_lang_name_empty, function(){form.Name.select();}, this);
			return false;
		}
		
		var data = 'Name=' + encodeURIComponent(form.Name.value);
		data += '&ParentID=' + form.ParentID.value;
		data += '&ObjectID=' + form.ObjectID.value;
		data += '&OperationID=' + form.OperationID.value;
		data += '&PathInTemplate=' + encodeURIComponent(form.PathInTemplate.value);
		data += '&URL=' + encodeURIComponent(form.URL.value);
		data += '&Target=' + encodeURIComponent(form.Target.value);
		data += '&IsDisplay=' + $("#IsDisplayYes")[0].checked;
		data += '&IsDefault=' + $("#IsDefaultYes")[0].checked;
	
		return data;
	};
	
	this.add = function()
	{
		var data = prepareData(this)
		if(!data)
			return false;
		
		__base.post({object:__object,operation:'Add',data:data,params:'TemplatePath=' + _templatePath + '&Namespace=' + $('#Namespace').val()});
		return false;
	};
	
	this.modify = function()
	{
		var data = prepareData(this)
		if(!data)
			return false;
			
		__base.post({object:__object,operation:'Modify',data:data,params:'TemplatePath=' + _templatePath + '&Namespace=' + _namespace + '&ID=' + _id});
		return false;
	};
	
	this.modifyName = function()
	{
		if (form.Name.value == '')
		{
			Alert(_lang_name_empty, function(){form.Name.select();}, this);
			return false;
		}
		
		var data = 'Name=' + encodeURIComponent(form.Name.value);
	
		__base.modify({object:__object,data:data,id:$(this).closest('tr').attr('ItemID')});
	
		return false;
	};

	this.move = function (from, to)
	{
	    __base.move(__object, 'Move', from, to, 'TemplatePath=' + _templatePath + '&Namespace=' + $('#Namespace').val());
	};
		
	this.del = function(id)
	{
		__base.post({object:__object,operation:'Delete',hasList:true,params:'TemplatePath=' + _templatePath + '&Namespace=' + $('#Namespace').val() + '&ID=' + id});
	};	
}

function TemplateMenu_GetPageList(type)
{
	var pageSelect = $('#PathInTemplate')[0];
	pageSelect.length = 0;
	pageSelect.options.add(new Option(_lang_none, ''));
	
	var namespace;
	if (_page == 'template_menu_edit')
		namespace = _namespace;
	else
		namespace = $('#Namespace').val();

	SetStatusMessage(_lang_loading_page_list);
	
	$.ajax(
	{
		url : _webPath + 'alicms.aspx?Lang=' + _lang + '&Object=Template.Page&Operation=List&Condition=' + encodeURIComponent(AliCMS.SystemModule.Template_Page.TemplatePath + ':' + _templatePath + ';' + AliCMS.SystemModule.Template_Page.Namespace + ':' + namespace),
		type : 'GET',
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
			var pageSelect = $('#PathInTemplate')[0];

			_xmlDoc.loadXML(data);
			var itemList = _xmlDoc.documentElement.childNodes;
			for (var i = 0; i < itemList.length; i++)
			{
				if (typeof (itemList[i].selectSingleNode) == 'undefined')
					continue;
				
				var pathInTemplate = itemList[i].selectSingleNode(AliCMS.SystemModule.Template_Page.PathInTemplate).text;
				pageSelect.options.add(new Option(pathInTemplate, pathInTemplate));
			}
			
			if (_page == 'template_menu_add')
			{
			    TemplateMenu_GetParentList(type);
			}
			else if (type == 'loading')
			{
				CheckAndSelect(pageSelect, _pathInTemplate);
				TemplateMenu_GetObjectList(type);
			}
		}
	});
}

function TemplateMenu_GetParentList(type)
{
	SetStatusMessage(_lang_loading_parent_list);

	$.ajax(
	{
		url : _webPath + 'alicms.aspx?Lang=' + _lang + '&Object=Template.Menu&Operation=List&Condition=' + encodeURIComponent(AliCMS.SystemModule.Template_Menu.Namespace + ':' + $('#Namespace').val() + ';' + AliCMS.SystemModule.Template_Menu.TemplatePath + ':' + _templatePath),
		type : 'POST',
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
			var parentSelect = $('#ParentID')[0];
			var curParent = parentSelect.value;
			parentSelect.length = 0;
			parentSelect.options.add(new Option(_lang_none, ''));
		
			_xmlDoc.loadXML(data);	
			BuildTreeOptions(_xmlDoc, AliCMS.SystemModule.Template_Menu.ParentID, AliCMS.SystemModule.Template_Menu.ID, AliCMS.SystemModule.Template_Menu.Name, parentSelect);
			
			if (type != 'loading')
			{
				CheckAndSelect(parentSelect, curParent);
				SetStatusMessage();
			}

			if (type != 'adding')
				TemplateMenu_GetObjectList(type);
		}
	});
}

function TemplateMenu_GetObjectList(type)
{
	SetStatusMessage(_lang_loading_object_list);

	var namespace;
	if (_page == 'template_menu_edit')
		namespace = _namespace;
	else
		namespace = $('#Namespace').val();

	$.ajax(
	{
		url : _webPath + 'alicms.aspx?Lang=' + _lang + '&Object=Module.Object&Operation=List&Condition=' + encodeURIComponent(AliCMS.SystemModule.Module_Object.Namespace + ':' + namespace),
		type : 'GET',
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
			var objectSelect = $('#ObjectID')[0];
			objectSelect.length = 1;
		
			_xmlDoc.loadXML(data);	
			BuildTreeOptions(_xmlDoc, AliCMS.SystemModule.Module_Object.ParentID, AliCMS.SystemModule.Module_Object.ID, AliCMS.SystemModule.Module_Object.Name, objectSelect);
			
			if (type == 'loading')
			{
			    if (_page == 'template_menu_edit' && _objectID != '')
			    {
					CheckAndSelect(objectSelect, _objectID);
					TemplateMenu_ObjectID_OnChange(type);
			    }
			}

			SetStatusMessage();
		}
	});
}

function TemplateMenu_ObjectID_OnChange(type)
{
	var operationSelect = $('#OperationID')[0];
	operationSelect.length = 0;
	operationSelect.options.add(new Option(_lang_none, ''));
	
	var objectSelect = $('#ObjectID')[0];
	if (objectSelect.selectedIndex == -1 || objectSelect.value == '')
		return;

	SetStatusMessage(_lang_loading_operation_list);

	$.ajax(
	{
		url : _webPath + 'alicms.aspx?Lang=' + _lang + '&Object=Module.Object.Operation&Operation=List&Condition=' + encodeURIComponent(AliCMS.SystemModule.Module_Object_Operation.ObjectID + ':' + objectSelect.value),
		type : 'GET',
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
			var operationSelect = $('#OperationID')[0];
		
			_xmlDoc.loadXML(data);
			var itemList = _xmlDoc.documentElement.childNodes;
			for (var i = 0; i < itemList.length; i++)
			{
				if (typeof (itemList[i].selectSingleNode) == 'undefined')
					continue;
						
				var value = itemList[i].selectSingleNode(AliCMS.SystemModule.Module_Object_Operation.ID).text;
				var text = itemList[i].selectSingleNode(AliCMS.SystemModule.Module_Object_Operation.Name).text;
				operationSelect.options.add(new Option(text, value));
			}
			
			if (_page == 'template_menu_edit' && type == 'loading')
			{
				CheckAndSelect(operationSelect, _operationID);
			}

			SetStatusMessage();
		}
	});
}
//end:模板管理_菜单管理
//---------------------------------------------------

//---------------------------------------------------
//start: 模板管理_页面管理
function TemplatePage()
{
	var __object = 'Template.Page',
		__base = new Base();
		
	function prepareData(form)
	{
		var data = 'Content=' + encodeURIComponent(form.Content.value);
		return data;
	};
	
	this.add = function()
	{
		if (!CheckFileName(this.Name.value))
		{
			Alert(_lang_file_name_invalid, function(){this.Name.select();}, this);
			return false;
		}
		
		var folder = $('#Folder')[0];
		var pathInTemplate = '';
		if (folder.selectedIndex > 0)
			pathInTemplate = folder.value + '/' + this.Name.value;
		else
			pathInTemplate = this.Name.value;
		pathInTemplate += $('#Extention').text();
		
		
		var data = prepareData(this)
		 data += '&PathInTemplate=' + encodeURIComponent(pathInTemplate);
		if(!data)
			return false;
			
		__base.post({object:__object,operation:'Add',data:data,params:'TemplatePath=' + _templatePath});
		return false;
	};
	
	this.modify = function()
	{
		var data = prepareData(this)
		if(!data)
			return false;
		
		__base.post({object:__object,operation:'Modify',data:data,params:'PathInTemplate=' + _id + '&TemplatePath=' + _templatePath});
		return false;
	};
	
	this.del = function(id)
	{
		__base.post({object:__object,operation:'Delete',hasList:true,params:'PathInTemplate=' + id + '&TemplatePath=' + _templatePath});
	}
}

function TemplatePage_AddFolder()
{
	var folderName = $('#FolderName').val();
	if (!CheckFileName(folderName))
	{
		Alert(_lang_file_name_invalid);
		return;
	}
	
	var folder = $('#Folder')[0];
	folderName = folder.value + '/' + folderName;
	var len = folder.value.length;
	for (var i = 0; i < len; i++)
	{
		if (folder.options[i].value == folderName)
		{
		    Alert(_lang_folder_exist);
			return;
		}
	}
	
	$('#AddFolder').eq(0).attr('disabled', true);
	SetStatusMessage(_lang_working);

	$.ajax(
	{
		url : _webPath + 'alicms.aspx?Lang=' + _lang + '&Object=Template.Page&Operation=AddFolder&Folder=' + encodeURIComponent(folderName) + '&TemplatePath=' + _templatePath,
		data : {},
		type : 'POST',
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
	        $('#AddFolder').eq(0).attr('disabled', false);
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
	        $('#AddFolder').eq(0).attr('disabled', false);
	        
	        var folder = $('#Folder')[0];
	        var folderName = $('#FolderName')[0];
			var value = '';
			if (folder.selectedIndex > 0)
			    value = folder.value + '/' + folderName.value;
			else
			    value = folderName.value;
			folderName.value = '';
			folder.options.add(new Option(value, value));
			folder.selectedIndex = folder.length - 1;
		}
	});
}

function TemplatePage_DeleteFolder()
{
	var folder = $('#Folder')[0];
	if (folder.value == '')
	{
		Alert(_lang_cant_delete_root);
		return;
	}
	
	$('#DeleteFolder').attr('disabled', true);
	SetStatusMessage(_lang_working);

	$.ajax(
	{
		url : _webPath + 'alicms.aspx?Lang=' + _lang + '&Object=Template.Page&Operation=DeleteFolder&Folder=' + encodeURIComponent(folder.value) + '&TemplatePath=' + _templatePath + '&Transfer=' + encodeURIComponent(BuildAjaxPath()),
		data : {},
		type : 'POST',
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
			var index = folder.selectedIndex;
			folder.options.remove(index);
			folder.selectedIndex = index - 1;
	        $('#DeleteFolder').attr('disabled', false);

			SetStatusMessage();
		}
	});
}

//end: 模板管理_页面管理
//----------------------------------------------------

//----------------------------------------------------
//start:  模板管理_脚本管理
function TemplateScript()
{
	var __object = 'Template.Script',
		__base = new Base();
		
	function prepareData(form)
	{
		var data = "Content=" + encodeURIComponent(form.Content.value);
		return data;
	};
	
	this.add = function()
	{
		if (!CheckFileName(this.Name.value))
		{
			Alert(_lang_file_name_invalid, function(){this.Name.select();}, this);
			return false;
		}
		var data = prepareData(this)
		data += "&Name=" + encodeURIComponent(this.Name.value + ".js");
		if(!data)
			return false;
		
		__base.post({object:__object,operation:'Add',data:data,params:'TemplatePath=' + _templatePath});
		return false;
	};
	
	this.modify = function()
	{
		var data = prepareData(this)
		if(!data)
			return false;
			
		__base.post({object:__object,operation:'Modify',data:data,params:'Name=' + _id + '&TemplatePath=' + _templatePath});
		return false;
	}
	
	this.del = function(id)
	{
		__base.post({object:__object,operation:'Delete',hasList:true,params:'Name=' + id + '&TemplatePath=' + _templatePath});
	}
}
//end:  模板管理_脚本管理
//----------------------------------------------------

//----------------------------------------------------
//start:实用工具
function BackupDb()
{
	SetStatusMessage(_lang_working);

	$.ajax(
	{
		url : _webPath + "alicms.aspx?Lang=" + _lang + "&Object=Utility&Operation=BackupDb&Name=" + encodeURIComponent(this.Name.value) + "&Transfer=" + encodeURIComponent(BuildAjaxPath()),
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();

			$("#List").html(HandleFake404(data, "text"));
			//Init();
		}
	});
	
	return false;
}

function BackupSite()
{
    var me = this;
    me.disabled = true;
	SetStatusMessage(_lang_working);

	$.ajax(
	{
		url : _webPath + "alicms.aspx?Lang=" + _lang + "&Object=Utility&Operation=BackupSite",
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
            me.disabled = false;
		},
		success : function(data)
		{
			Alert(_lang_backup_site_success);
			SetStatusMessage();
            me.disabled = false;
		}
	});
	
	return false;
}

function CompactDb()
{
	SetStatusMessage(_lang_working);

	$.ajax(
	{
		url : _webPath + "alicms.aspx?Lang=" + _lang + "&Object=Utility&Operation=CompactDb",
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
		}
	});
}

function RestoreDb(name)
{
	SetStatusMessage(_lang_working);

	$.ajax(
	{
		url : _webPath + "alicms.aspx?Lang=" + _lang + "&Object=Utility&Operation=RestoreDb&Name=" + encodeURIComponent(name),
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
		}
	});
	
	return false;
}

function DeleteDbBackup(name)
{
	SetStatusMessage(_lang_working);

	$.ajax(
	{
		url : _webPath + "alicms.aspx?Lang=" + _lang + "&Object=Utility&Operation=DeleteDbBackup&Name=" + encodeURIComponent(name) + "&Transfer=" + encodeURIComponent(BuildAjaxPath()),
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();

			$("#List").html(HandleFake404(data, "text"));
		}
	});
}

function ClearCache()
{
    var me = this;
    me.disabled = true;
	SetStatusMessage(_lang_working);

	$.ajax(
	{
		url : _webPath + "alicms.aspx?Lang=" + _lang + "&Object=Utility&Operation=ClearCache",
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
            me.disabled = false;
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
            me.disabled = false;
		}
	});
	
	return false;
}

function UpdateTemplateCache()
{
    var me = this;
    me.disabled = true;
	SetStatusMessage(_lang_working);

	$.ajax(
	{
		url : _webPath + "alicms.aspx?Lang=" + _lang + "&Object=Utility&Operation=UpdateTemplateCache",
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
            me.disabled = false;
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
            me.disabled = false;
		}
	});
	
	return false;
}

function InitSystem()
{
    var me = this;
    me.disabled = true;
	SetStatusMessage(_lang_working);

	$.ajax(
	{
		url : _webPath + "alicms.aspx?Lang=" + _lang + "&Object=Utility&Operation=InitSystem",
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
            me.disabled = false;
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
            me.disabled = false;
		}
	});
	
	return false;
}

function ReplaceEotRootString(value)
{
	if (typeof(value) != "string")
	{
		Prompt(_lang_prompt, "", function(returnValue){if (returnValue != null && returnValue != "")ReplaceEotRootString(returnValue);}, this);
	}
	else
	{
		var me = this;
		me.disabled = true;
		SetStatusMessage(_lang_working);
	
		$.ajax(
		{
			url : _webPath + "alicms.aspx?Lang=" + _lang + "&Object=Utility&Operation=ReplaceEotRootString",
			data : "RootString=" + encodeURIComponent(value),
			type : "POST",
			error : function(request)
			{
				Alert(_lang_operation_fail);
				SetStatusMessage();
				me.disabled = false;
			},
			success : function(data)
			{
				Alert(_lang_operation_success);
				SetStatusMessage();
				me.disabled = false;
			}
		});
	}
}
//end:实用工具
//----------------------------------------------------

//----------------------------------------------------
//start:系统设置
function SetBasicSettings()
{
	if (!IsAllowedType(this.Logo.value, this.LogoAllowedType.value))
	{
		Alert(_lang_logo_type_must_be + this.LogoAllowedType.value, function(){this.Logo.select();}, this);
		return false;
	}
	
	if (!IsAllowedType(this.Link.value, this.LinkAllowedType.value))
	{
		Alert(_lang_link_type_must_be + this.LinkAllowedType.value, function(){this.Link.select();}, this);
		return false;
	}

	var data = 'Name=' + encodeURIComponent(this.Name.value);
	data += '&Description=' + encodeURIComponent(CKEDITOR.instances[this.Description.id].getData());
	data += '&Notice=' + encodeURIComponent(this.Notice.value);
	data += '&Footer=' + encodeURIComponent(CKEDITOR.instances[this.Footer.id].getData());
	data += '&ICP=' + encodeURIComponent(this.ICP.value);
	data += '&StatisticsCode=' + encodeURIComponent(this.StatisticsCode.value);
	data += '&UploadType=' + encodeURIComponent(this.UploadType.value);
	data += '&Error404Redirect=' + encodeURIComponent(this.Error404Redirect.value);
	data += '&ErrorRedirect=' + encodeURIComponent(this.ErrorRedirect.value);
	data += '&DisplayCheckCode=' + $('#DisplayCheckCodeYes')[0].checked;
	_uploadLogo = _uploader.NeedUpload('Logo');
	if (!_uploadLogo)
		data += '&Logo=' + encodeURIComponent(this.Logo.value);
	_uploadLink = _uploader.NeedUpload('Link');
	if (!_uploadLink)
		data += '&Link=' + encodeURIComponent(this.Link.value);
	data += '&MetaKeywords=' + encodeURIComponent(this.MetaKeywords.value);
	data += '&MetaDescription=' + encodeURIComponent(this.MetaDescription.value);

	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);

	$.ajax(
	{
		url : _webPath + 'alicms.aspx?Lang=' + _lang + '&Object=InstanceConfig&Operation=SetBasicSettings',
		data : data,
		type : 'POST',
		error : function(request)
		{
			Alert(_lang_operation_fail);

			SetStatusMessage();
			$(':submit')[0].disabled = false;
		},
		success : function(data)
		{
			SetBasicSettings_UploadLogo();
		}
	});
	
	return false;	
}
function SetBasicSettings_UploadLogo()
{
    if (!_uploadLogo)
    {
		SetBasicSettings_UploadLink();
        return;
    }

    SetStatusMessage(_lang_start_upload_logo);
    _uploader.Init({Status:_lang_uploading_logo,Params:'Lang=' + _lang + '&Object=InstanceConfig&Operation=UploadLogo'});
    _uploader.Upload("Logo", function()
    {
        if (arguments[0] != 0)
        {
            Alert(arguments[1]);
		    SetStatusMessage();
		    $(':submit')[0].disabled = false;
        }
        else
        {
            SetBasicSettings_UploadLink();
        }
    });
}

function SetBasicSettings_UploadLink()
{
    if (!_uploadLink)
    {
		Alert(_lang_operation_success);
		SetStatusMessage();
		$(':submit')[0].disabled = false;

        return;
    }

    SetStatusMessage(_lang_start_upload_link);
    _uploader.Init({Status:_lang_uploading_link,Params:'Lang=' + _lang + '&Object=InstanceConfig&Operation=UploadLink'});
    _uploader.Upload('Link', function()
    {
        if (arguments[0] != 0)
            Alert(arguments[1]);
        else
		    Alert(_lang_operation_success);
	    SetStatusMessage();
	    $(":submit")[0].disabled = false;
    });
}

function SetEmailSettings()
{
	var data = 'Tool=' + this.Tool.value;
	data += '&Name=' + encodeURIComponent(this.Name.value);
	data += '&Address=' + encodeURIComponent(this.Address.value);
	data += '&Account=' + encodeURIComponent(this.Account.value);
	if (this.Password.value != '')
		data += '&Password=' + encodeURIComponent(this.Password.value);
	data += '&Server=' + encodeURIComponent(this.Server.value);
	data += '&NeedValidation=' + $('#NeedValidationYes')[0].checked;

	$(':submit')[0].disabled = true;
	SetStatusMessage(_lang_working);

	$.ajax(
	{
		url : _webPath + 'alicms.aspx?Lang=' + _lang + '&Object=InstanceConfig&Operation=SetEmailSettings',
		data : data,
		type : 'POST',
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(':submit')[0].disabled = false;
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
			$(':submit')[0].disabled = false;
		}
	});
	
	return false;	
}

function SmartUpdate_OnChange()
{
	switch ($('[name=SmartUpdate]:checked').attr('id'))
	{
		case 'SmartUpdateDisable':
			$('#SpeedUpTR,#LowTR,#HighTR,#IntervalTR').hide();
			break;
		case 'SmartUpdateLow':
			$('#LowTR,#IntervalTR').show();
			$('#SpeedUpTR,#HighTR').hide();
			break;
		case 'SmartUpdateHigh':
			$('#HighTR,#IntervalTR').show();
			$('#SpeedUpTR,#LowTR').hide();
			break;
		case 'SmartUpdateSpeedUp':
			$('#SpeedUpTR').show();
			$('#LowTR,#HighTR,#IntervalTR').hide();
			break;
	}
}

function SetGlobalSettings()
{
	if (this.ConnectionString.value == '')
	{
		Alert(_lang_connection_string_empty, function(){this.ConnectionString.select();}, this);
		return false;
	}
	
	var data = 'Domain=' + encodeURIComponent(this.Domain.value);
	data += '&DatabaseProvider=' + encodeURIComponent(this.DatabaseProvider.value);
	data += '&ProtectConnectionString=' + $('#ProtectConnectionStringYes')[0].checked;
	data += '&ConnectionString=' + encodeURIComponent(this.ConnectionString.value);
	data += '&ClearWhiteSpace=' + $('#ClearWhiteSpace')[0].checked;
	data += '&ClearHtmlComment=' + $('#ClearHtmlComment')[0].checked;
	data += '&ClearScriptComment=' + $('#ClearScriptComment')[0].checked;
	data += '&GZipEnabled=' + $('#GZipEnabledYes')[0].checked;
	data += '&Fake404=' + $('#Fake404Yes')[0].checked;
	data += '&OnlyAdminCanDebug=' + $('#OnlyAdminCanDebug')[0].checked;
	data += '&DisplayTrace=' + $('#DisplayTrace')[0].checked;
	data += '&ShutDown=' + $('#ShutDownYes')[0].checked;
	data += '&ShutDownReason=' + encodeURIComponent(this.ShutDownReason.value);
	data += '&UserDataDirectory=' + encodeURIComponent(this.UserDataDirectory.value);
	data += '&DataDirectory=' + encodeURIComponent(this.DataDirectory.value);
	data += '&TemplateDirectory=' + encodeURIComponent(this.TemplateDirectory.value);
	data += '&CacheDirectory=' + encodeURIComponent(this.CacheDirectory.value);
	data += '&ModuleDirectory=' + encodeURIComponent(this.ModuleDirectory.value);
	data += '&CommonDirectory=' + encodeURIComponent(this.CommonDirectory.value);

	$(':submit')[0].disabled = true;
	SetStatusMessage(_lang_working);

	$.ajax(
	{
		url : _webPath + 'alicms.aspx?Lang=' + _lang + '&Object=InstanceConfig&Operation=SetGlobalSettings',
		data : data,
		type : 'POST',
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(':submit')[0].disabled = false;
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
			$(':submit')[0].disabled = false;
		}
	});
	
	return false;	
}

function SetWaterMarkSettings()
{
	if (this.FontSize.value != '' && !this.FontSize.value.match(/^\d+$/))
	{
		Alert(_lang_font_size_incorrect, function(){this.FontSize.select();}, this);
		return false;
	}

	if (this.ForeColor.value != '' && !this.ForeColor.value.match(/^#[0-9a-fA-F]{6}$/))
	{
		Alert(_lang_font_color_incorrect, function(){this.ForeColor.select();}, this);
		return false;
	}

	if (this.BackColor.value != '' && !this.BackColor.value.match(/^#[0-9a-fA-F]{6}$/))
	{
		Alert(_lang_back_color_incorrect, function(){this.BackColor.select();}, this);
		return false;
	}

	if (this.MarginX.value != '' && !this.MarginX.value.match(/^\d+$/))
	{
		Alert(_lang_margin_x_incorrect, function(){this.MarginX.select();}, this);
		return false;
	}

	if (this.MarginY.value != '' && !this.MarginY.value.match(/^\d+$/))
	{
		Alert(_lang_margin_y_incorrect, function(){this.MarginY.select();}, this);
		return false;
	}

	if (this.Transparency.value != '' && !this.Transparency.value.match(/^(1|(0.\d+))$/))
	{
		Alert(_lang_transparency_incorrect, function(){this.Transparency.select();}, this);
		return false;
	}
	
	if (!IsAllowedType(this.Image.value, this.ImageAllowedType.value))
	{
		Alert(_lang_type_must_be + this.ImageAllowedType.value, function(){this.Image.select();}, this);
		return false;
	}
	
	var data = 'Type=' + $('[name=Type]:checked').val();
	_uploadImage = _uploader.NeedUpload('Image');
	if (!_uploadImage)
		data += '&Image=' + encodeURIComponent(this.Image.value);
	data += '&Text=' + encodeURIComponent(this.Text.value);
	data += '&FontFamily=' + encodeURIComponent(this.FontFamily.value);
	data += '&FontSize=' + encodeURIComponent(this.FontSize.value);
	data += '&ForeColor=' + encodeURIComponent(this.ForeColor.value);
	data += '&BackColor=' + encodeURIComponent(this.BackColor.value);
	data += '&Bold=' + $("#BoldYes")[0].checked;
	data += '&Italic=' + $("#ItalicYes")[0].checked;
	data += '&Position=' + encodeURIComponent(this.Position.value);
	data += '&MarginX=' + encodeURIComponent(this.MarginX.value);
	data += '&MarginY=' + encodeURIComponent(this.MarginY.value);
	data += '&Transparency=' + encodeURIComponent(this.Transparency.value);

	$(':submit')[0].disabled = true;
	SetStatusMessage(_lang_working);

	$.ajax(
	{
		url : _webPath + 'alicms.aspx?Lang=' + _lang + '&Object=InstanceConfig&Operation=SetWaterMarkSettings',
		data : data,
		type : 'POST',
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(':submit')[0].disabled = false;
		},
		success : function(data)
		{
			SetWaterMarkSettings_UploadImage();
		}
	});
	
	return false;	
}

function SetWaterMarkSettings_UploadImage()
{
    if (!_uploadImage)
    {
		Alert(_lang_operation_success);
		SetStatusMessage();
		$(':submit')[0].disabled = false;
        return;
    }
    
	SetStatusMessage(_lang_start_upload);
	_uploader.Init({Status:_lang_uploading,Params:'Lang=' + _lang + '&Object=InstanceConfig&Operation=UploadWaterMarkImage'});
	_uploader.Upload('Image', function()
	{
        if (arguments[0] != 0)
            Alert(arguments[1]);
        else
    		Alert(_lang_operation_success);
		SetStatusMessage();
		$(":submit")[0].disabled = false;
	});
}

function AddRewrite()
{
	if (this.LookFor.value == '')
	{
		Alert(_lang_lookfor_empty, function(){this.LookFor.select();}, this);
		return false;
	}
	
	if (!this.LookFor.value.match(/^((http:\/\/)|(~\/)|(\/))/))
	{
		Alert(_lang_lookfor_incorrect, function(){this.LookFor.select();}, this);
		return false;
	}
	
	if (this.SendTo.value == '' && this.InstanceID.value == '' && this.ObjectFullName.value == '')
	{
		Alert(_lang_sendto_empty, function(){this.SendTo.select();}, this);
		return false;
	}
	
	if (this.SendTo.value != '' && !this.SendTo.value.match(/^((http:\/\/)|(~\/)|(\/))/))
	{
		Alert(_lang_sendto_incorrect, function(){this.SendTo.select();}, this);
		return false;
	}
	
	var data = 'LookFor=' + encodeURIComponent(this.LookFor.value);
	if (this.SendTo.value == '')
	{
		data += '&InstanceID=' + this.InstanceID.value;
		data += '&ObjectFullName=' + this.ObjectFullName.options[form.ObjectFullName.selectedIndex].name;
	}
	else
	{
		data += '&SendTo=' + encodeURIComponent(this.SendTo.value);
	}
	data += '&Is301=' + this.Is301.checked;

	$(':submit')[0].disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + 'alicms.aspx?Lang=' + _lang + '&Object=Rewrite&Operation=Add&Transfer=' + encodeURIComponent(BuildHeader()),
		data : data,
		type : 'POST',
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(':submit')[0].disabled = false;
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
			$(':submit')[0].disabled = false;

			$('#List').html(HandleFake404(data, "text"));
		}
	});
	
	return false;	
}

function DeleteRewrite(id)
{
	SetStatusMessage(_lang_working);

	$.ajax(
	{
		url : _webPath + 'alicms.aspx?Lang=' + _lang + '&Object=Rewrite&Operation=Delete&ID=' + id + '&Transfer=' + encodeURIComponent(BuildHeader()),
		data : {},
		type : 'POST',
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();

			$('#List').html(HandleFake404(data, 'text'));
			//Init();
		}
	});
}
//end:系统设置
//----------------------------------------------------

//----------------------------------------------------
//start:文件管理
function FileManager_CalcSize()
{
	var sum = 0;
	$('tbody tr').each(function()
	{
		var name = $(this).attr('id');
		
		var tds = $(this).find('td');
		
		var size = tds.eq(1).text();
		if (size.indexOf(' B') != -1)
			sum += parseFloat(size.replace(' B', ''));
		else if (size.indexOf(' K') != -1)
			sum += parseFloat(size.replace(' B', '')) * 1024;
		else if (size.indexOf(' M') != -1)
			sum += parseFloat(size.replace(' M', '')) * 1024 * 1024;
		else if (size.indexOf(' G') != -1)
			sum += parseFloat(size.replace(' G', '')) * 1024 * 1024 * 1024;		
	});
	
	var unit = ' B';
	if (sum > 1024)
	{
		sum = sum / 1024;
		unit = ' K';
	}
	if (sum > 1024)
	{
		sum = sum / 1024;
		unit = ' M';
	}
	if (sum > 1024)
	{
		sum = sum / 1024;
		unit = ' G';
	}
	$('tfoot td:last').html(sum.toFixed(2) + unit);
}

function List()
{
	var input = $('#Folder')[0];
	var slash = input.value.indexOf('/');
	if (slash != 0)
	{
		Alert(_lang_start_slash);
		return;
	}
	
	slash = input.value.lastIndexOf('/');
	if (slash < input.value.length - 1)
		input.value += '/';
	
	if (arguments.length == 1 && typeof(arguments[0]) == 'string')
		input.value = input.value + arguments[0] + "/";
	
	SetStatusMessage(_lang_working);

	$.ajax(
	{
		url : BuildAjaxPath(true) + '?Lang=' + _lang + '&Folder=' + encodeURIComponent(input.value),
		data : {},
		type : 'POST',
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
			$('#List').html(HandleFake404(data, 'text'));
			//Init();
			SetStatusMessage();
		}
	});
}

function Up()
{
	var input = $('#Folder')[0];
	var value = input.value;
	if (value.length <= 1)
	    return;
		
	if (value.lastIndexOf('/') == value.length - 1)
	    value = value.substr(0, value.length - 1);

	var slash = value.lastIndexOf('/');
	if (slash == -1)
		return;

	input.value = value.substr(0, slash + 1);
	
	SetStatusMessage(_lang_working);

	$.ajax(
	{
		url : BuildAjaxPath(true) + '?Lang=' + _lang + '&Folder=' + encodeURIComponent(input.value),
		data : {},
		type : 'POST',
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
			$('#List').html(HandleFake404(data, 'text'));
			SetStatusMessage();
		}
	});
}

function CreateFolder(value)
{
	if (typeof(value) != 'string')
	{
		Prompt(_lang_folder_name, '', function(returnValue){if (returnValue != null && returnValue != '')CreateFolder(returnValue);}, this);
	}
	else
	{
		var folder = $('#Folder').val();
		if (folder.lastIndexOf('/') != folder.length - 1)
			folder += '/';

		SetStatusMessage(_lang_working);
	
		$.ajax(
		{
			url : _webPath + 'alicms.aspx?Lang=' + _lang + '&Object=FileManager&Operation=CreateFolder&Path=' + encodeURIComponent(folder + value) + '&Transfer=' + encodeURIComponent(BuildAjaxPath(true) + '?Lang=' + _lang + '&Folder=' + folder),
			data : {},
			type : 'POST',
			error : function(request)
			{
				Alert(_lang_operation_fail);
				SetStatusMessage();
			},
			success : function(data)
			{
				$('#List').html(HandleFake404(data, 'text'));
				SetStatusMessage();
			}
		});
	}
}

function Upload()
{
	if (!_uploader.NeedUpload('File'))
	{
		Alert(_lang_select_file);
		return false;
	}
	
	var folder = $('#Folder').val();
	if (folder.lastIndexOf('/') != folder.length - 1)
		folder += "/";

	$(':submit')[0].disabled = true;
    SetStatusMessage(_lang_start_upload);
    
    _uploader.Init({Status:_lang_uploading,Params:'Lang=' + _lang + '&Object=FileManager&Operation=Upload&Folder=' + encodeURIComponent(folder) + '&AddWaterMark=' + $('#AddWaterMark')[0].checked});
    _uploader.Upload('File', function()
    {
        if (arguments[0] != 0)
        {
            Alert(arguments[1]);
        }
        else
        {
    		Alert(_lang_operation_success);
    		List();
    	}
		SetStatusMessage();
		$(':submit')[0].disabled = false;
    });

	return false;
}

function Delete(name)
{
	var folder = $('#Folder').val();
	if (folder.lastIndexOf('/') != folder.length - 1)
		folder += '/';
	
	SetStatusMessage(_lang_working);

	$.ajax(
	{
		url : _webPath + 'alicms.aspx?Lang=' + _lang + '&Object=FileManager&Operation=Delete&Path=' + encodeURIComponent(folder + name) + '&Transfer=' + encodeURIComponent(BuildAjaxPath(true) + '?Lang=' + _lang + '&Folder=' + folder),
		data : {},
		type : 'POST',
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
			$("#List").html(HandleFake404(data, 'text'));
			SetStatusMessage();
		}
	});
}

function Rename(name, value)
{
	if (value == null)
	{
		Prompt(_lang_input_name, '', function(returnValue){if (returnValue != null && returnValue != '')Rename(name, returnValue);}, this);
	}
	else
	{
		var folder = $('#Folder').val();
		if (folder.lastIndexOf('/') != folder.length - 1)
			folder += '/';
		
		SetStatusMessage(_lang_working);
	
		$.ajax(
		{
			url : _webPath + 'alicms.aspx?Lang=' + _lang + '&Object=FileManager&Operation=Rename&From=' + encodeURIComponent(folder + name) + '&To=' + encodeURIComponent(folder + value) + '&Transfer=' + encodeURIComponent(BuildAjaxPath(true) + '?Lang=' + _lang + '&Folder=' + folder),
			data : {},
			type : 'POST',
			error : function(request)
			{
				Alert(_lang_operation_fail);
				SetStatusMessage();
			},
			success : function(data)
			{
				$('#List').html(HandleFake404(data, 'text'));
				SetStatusMessage();
			}
		});
	}
}

function Move(name, value)
{
	if (value == null)
	{
		Prompt(_lang_input_name, '', function(returnValue){if (returnValue != null && returnValue != '')Move(name, returnValue);}, this);
	}
	else
	{
		var folder = $('#Folder').val();
		if (folder.lastIndexOf('/') != folder.length - 1)
			folder += '/';
			
		if (value.indexOf('/') != 0)
			value = folder + value;
		
		var slash = value.lastIndexOf('/');
		var dot = value.indexOf('.', slash + 1);
		if (dot == -1)
		{
			if (slash != value.length - 1)
				value += '/';
			value += name;
		}
		
		SetStatusMessage(_lang_working);
	
		$.ajax(
		{
			url : _webPath + 'alicms.aspx?Lang=' + _lang + '&Object=FileManager&Operation=Move&From=' + encodeURIComponent(folder + name) + '&To=' + encodeURIComponent(value) + "&Transfer=" + encodeURIComponent(BuildAjaxPath(true) + '?Lang=' + _lang + '&Folder=' + folder),
			data : {},
			type : 'POST',
			error : function(request)
			{
				Alert(_lang_operation_fail);
				SetStatusMessage();
			},
			success : function(data)
			{
				$('#List').html(HandleFake404(data, 'text'));
				SetStatusMessage();
			}
		});
	}
}

function Copy(name, value)
{
	if (value == null)
	{
		Prompt(_lang_target_name, '', function(returnValue){if (returnValue != null && returnValue != '')Copy(name, returnValue);}, this);
	}
	else
	{
		var folder = document.getElementById('Folder').value;
		if (folder.lastIndexOf('/') != folder.length - 1)
			folder += '/';
			
		if (value.indexOf('/') != 0)
			value = folder + value;
		
		var slash = value.lastIndexOf('/');
		var dot = value.indexOf('.', slash + 1);
		if (dot == -1)
		{
			if (slash != value.length - 1)
				value += '/';
			value += name;
		}
	
		SetStatusMessage(_lang_working);
	
		$.ajax(
		{
			url : _webPath + 'alicms.aspx?Lang=' + _lang + '&Object=FileManager&Operation=Copy&From=' + encodeURIComponent(folder + name) + '&To=' + encodeURIComponent(value) + "&Transfer=" + encodeURIComponent(BuildAjaxPath(true) + '?Lang=' + _lang + '&Folder=' + folder),
			data : {},
			type : 'POST',
			error : function(request)
			{
				Alert(_lang_operation_fail);
				SetStatusMessage();
			},
			success : function(data)
			{
				$('#List').html(HandleFake404(data, 'text'));
				SetStatusMessage();
			}
		});
	}
}

function Zip(name, value)
{
	if (value == null)
	{
		Prompt(_lang_target_file, '', function(returnValue){if (returnValue != null && returnValue != '')Zip(name, returnValue);}, this);
	}
	else
	{
		if (value.length <= 4 || value.substr(value.length - 4) != '.zip')
		{
			Alert(_lang_must_be_zip);
			return;
		}
		
		var folder = $('#Folder').val();
		if (folder.lastIndexOf('/') != folder.length - 1)
			folder += '/';
			
		if (value.indexOf('/') != 0)

			result = folder + value;
		
		SetStatusMessage(_lang_working);
	
		$.ajax(
		{
			url : _webPath + 'alicms.aspx?Lang=' + _lang + '&Object=FileManager&Operation=Zip&From=' + encodeURIComponent(folder + name) + '&To=' + encodeURIComponent(value) + '&Transfer=' + encodeURIComponent(BuildAjaxPath(true) + '?Lang=' + _lang + '&Folder=' + folder),
			data : {},
			type : 'POST',
			error : function(request)
			{
				Alert(_lang_operation_fail);
				SetStatusMessage();
			},
			success : function(data)
			{
				$('#List').html(HandleFake404(data, 'text'));
				SetStatusMessage();
			}
		});
	}
}

function UnZip(name, value)
{
	if (value == null)
	{
		Prompt(_lang_target_folder, '', function(returnValue){if (returnValue != null && returnValue != '')UnZip(name, returnValue);}, this);
	}
	else
	{
		var folder = $('#Folder').val();
		if (folder.lastIndexOf('/') != folder.length - 1)
			folder += "/";
			
		if (value.indexOf('/') != 0)
			value = folder + value;
		
		SetStatusMessage(_lang_working);
	
		$.ajax(
		{
			url : _webPath + 'alicms.aspx?Lang=' + _lang + '&Object=FileManager&Operation=UnZip&From=' + encodeURIComponent(folder + name) + '&To=' + encodeURIComponent(value) + '&Transfer=' + encodeURIComponent(BuildAjaxPath(true) + '?Lang=' + _lang + '&Folder=' + folder),
			data : {},
			type : 'POST',
			error : function(request)
			{
				Alert(_lang_operation_fail);
				SetStatusMessage();
			},
			success : function(data)
			{
				$('#List').html(HandleFake404(data, 'text'));
				SetStatusMessage();
			}
		});
	}
}

function NormalizeFolder()
{
	var input = $('#Folder')[0];
	var value = input.value;
	var slash = value.indexOf('/');
	if (slash == 0)
		value = value.substr(1);
	if (value == '')
		return _root;
	
	if (value.lastIndexOf('/') != value.length - 1)
		value += '/';
	
	return _root + value;
}

function BuildTransfer(folder)
{
	return '&Transfer=' + encodeURIComponent(BuildAjaxPath(true) + '?Lang=' + _lang + '&Root=' + folder + '&ListByPicture=' + $('#ListByPicture')[0].checked);
}

function Select_Up()
{
	var folder = NormalizeFolder();
	if (folder == _root)
		return;
		
	var slash = folder.lastIndexOf('/', folder.length - 2);
	if (slash == -1)
		return;
	
	folder = folder.substr(0, slash).substr(_root.length - 1);
	$('#Folder').val(folder == '' ? '/' : folder);

	Search(1);
}

function Select_CreateFolder(value)
{
	if (typeof(value) != 'string')
	{
		Prompt(_lang_folder_name, '', function(returnValue){if (returnValue != null && returnValue != '')Select_CreateFolder(returnValue);}, this);
	}
	else
	{
		var folder = NormalizeFolder();
		
		SetStatusMessage(_lang_working);
	
		$.ajax(
		{
			url : _webPath + 'alicms.aspx?Lang=' + _lang + '&Object=FileManager&Operation=CreateFolder&Path=' + encodeURIComponent(folder + value) + BuildTransfer(folder),
			data : {},
			type : 'POST',
			error : function(request)
			{
				Alert(_lang_operation_fail);
				SetStatusMessage();
			},
			success : function(data)
			{
				$("#List").html(HandleFake404(data, 'text'));
				SetStatusMessage();
			}
		});
	}
}

function Select_Rename(name, value)
{
	if (value == null)
	{
		Prompt(_lang_input_name, '', function(returnValue){if (returnValue != null && returnValue != '')Select_Rename(name, returnValue);}, this);
	}
	else
	{
		var folder = NormalizeFolder();
		
		SetStatusMessage(_lang_working);
	
		$.ajax(
		{
			url : _webPath + 'alicms.aspx?Lang=' + _lang + '&Object=FileManager&Operation=Rename&From=' + encodeURIComponent(folder + name) + '&To=' + encodeURIComponent(folder + value) + BuildTransfer(folder),
			data : {},
			type : 'POST',
			error : function(request)
			{
				Alert(_lang_operation_fail);
				SetStatusMessage();
			},
			success : function(data)
			{
				$('#List').html(HandleFake404(data, 'text'));
				SetStatusMessage();
			}
		});
	}
}

function Select_Move(name, value)
{
	if (value == null)
	{
		Prompt(_lang_target_folder, '', function(returnValue){if (returnValue != null && returnValue != '')Select_Move(name, returnValue);}, this);
	}
	else
	{
		var folder = NormalizeFolder();
			
		if (value.indexOf('/') != 0)
			value = folder + value;
		else
			value = (_root + value).replace('//', '/');
		
		var slash = value.lastIndexOf('/');
		var dot = value.indexOf('.', slash + 1);
		if (dot == -1)
		{
			if (slash != value.length - 1)
				value += '/';
			value += name;
		}
		
		SetStatusMessage(_lang_working);
	
		$.ajax(
		{
			url : _webPath + 'alicms.aspx?Lang=' + _lang + '&Object=FileManager&Operation=Move&From=' + encodeURIComponent(folder + name) + '&To=' + encodeURIComponent(value) + BuildTransfer(folder),
			data : {},
			type : 'POST',
			error : function(request)
			{
				Alert(_lang_operation_fail);
				SetStatusMessage();
			},
			success : function(data)
			{
				$('#List').html(HandleFake404(data, 'text'));
				SetStatusMessage();
			}
		});
	}
}

function Select_Copy(name, value)
{
	if (value == null)
	{
		Prompt(_lang_target_name, '', function(returnValue){if (returnValue != null && returnValue != '')Select_Copy(name, returnValue);}, this);
	}
	else
	{
		var folder = NormalizeFolder();
			
		if (value.indexOf('/') != 0)
			value = folder + value;
		else
			value = (_root + value).replace('//', '/');
		
		var slash = value.lastIndexOf('/');
		var dot = value.indexOf('.', slash + 1);
		if (dot == -1)
		{
			if (slash != value.length - 1)
				value += '/';
			value += name;
		}
		
		SetStatusMessage(_lang_working);
	
		$.ajax(
		{
			url : _webPath + 'alicms.aspx?Lang=' + _lang + '&Object=FileManager&Operation=Copy&From=' + encodeURIComponent(folder + name) + '&To=' + encodeURIComponent(value) + BuildTransfer(folder),
			data : {},
			type : 'POST',
			error : function(request)
			{
				Alert(_lang_operation_fail);
				SetStatusMessage();
			},
			success : function(data)
			{
				$('#List').html(HandleFake404(data, 'text'));
				SetStatusMessage();
			}
		});
	}
}

function Select_Zip(name, value)
{
	if (value == null)
	{
		Prompt(_lang_target_file, '', function(returnValue){if (returnValue != null && returnValue != '')Select_Zip(name, returnValue);}, this);
	}
	else
	{
		if (value.length <= 4 || value.substr(value.length - 4) != '.zip')
		{
			Alert(_lang_must_be_zip);
			return;
		}
		
		var folder = NormalizeFolder();
			
		if (value.indexOf('/') == 0)
			value = _root + value.substr(1);
		else
			value = folder + value;
		
		SetStatusMessage(_lang_working);
	
		$.ajax(
		{
			url : _webPath + 'alicms.aspx?Lang=' + _lang + '&Object=FileManager&Operation=Zip&From=' + encodeURIComponent(folder + name) + '&To=' + encodeURIComponent(value) + BuildTransfer(folder),
			data : {},
			type : 'POST',
			error : function(request)
			{
				Alert(_lang_operation_fail);
				SetStatusMessage();
			},
			success : function(data)
			{
				$('#List').html(HandleFake404(data, 'text'));
				SetStatusMessage();
			}
		});
	}
}

function Select_UnZip(name, value)
{
	if (value == null)
	{
		Prompt(_lang_target_folder, '', function(returnValue){if (returnValue != null)Select_UnZip(name, returnValue);}, this);
	}
	else
	{
		var folder = NormalizeFolder();

		if (value.indexOf('/') == 0)
			value = _root + value.substr(1);
		else
			value = folder + value;
		
		SetStatusMessage(_lang_working);
	
		$.ajax(
		{
			url : _webPath + 'alicms.aspx?Lang=' + _lang + '&Object=FileManager&Operation=UnZip&From=' + encodeURIComponent(folder + name) + '&To=' + encodeURIComponent(value) + BuildTransfer(folder),
			data : {},
			type : 'POST',
			error : function(request)
			{
				Alert(_lang_operation_fail);
				SetStatusMessage();
			},
			success : function(data)
			{
				$('#List').html(HandleFake404(data, 'text'));
				SetStatusMessage();
			}
		});
	}
}

function Select_Delete(name)
{
	var folder = NormalizeFolder();
	
	SetStatusMessage(_lang_working);

	$.ajax(
	{
		url : _webPath + 'alicms.aspx?Lang=' + _lang + '&Object=FileManager&Operation=Delete&Path=' + encodeURIComponent(folder + name) + BuildTransfer(folder),
		data : {},
		type : 'POST',
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
			$('#List').html(HandleFake404(data, 'text'));
			SetStatusMessage();
		}
	});
}

function Select_Upload()
{
	if (!_uploader.NeedUpload('File'))
	{
		Alert(_lang_select_file);
		return false;
	}
	
	var folder = NormalizeFolder();

	$(":submit")[0].disabled = true;
    SetStatusMessage(_lang_start_upload);
    
    _uploader.Init({Status:_lang_uploading,Params:'Lang=' + _lang + '&Object=FileManager&Operation=Upload&Folder=' + encodeURIComponent(folder) + '&AddWaterMark=' + $('#AddWaterMark')[0].checked});
    _uploader.Upload('File', function()
    {
        if (arguments[0] != 0)
        {
            Alert(arguments[1]);
        }
        else
        {
			if (_type == 'Editor')
				window.opener.CKEDITOR.tools.callFunction(_ckeditorFuncNum, arguments[1]);
			else if (g_browser == 'IE')
				window.dialogArguments.SelectFile(_type, arguments[1]);
			else
				window.opener.SelectFile(_type, arguments[1]);
			window.close();			
    	}
		SetStatusMessage();
		$(':submit')[0].disabled = false;
    });

	return false;
}
//end:文件管理
//----------------------------------------------------

//----------------------------------------------------
//start:栏目管理
function Channel()
{
	var __object = 'Channel',
		__base  = new Base(),
		__uploadLogo,
		__uploadLink;
	
	this.add = function()
	{
		if ($('#FunctionalChannel')[0].checked && this.InstanceID == null)
		{
			Alert(_lang_select_instance);
			return false;
		}
	
		if (this.Name.value == '')
		{
			Alert(_lang_name_empty, function(){this.Name.select();}, this);
			return false;
		}
	
		if (!$('#OuterLink')[0].checked)
		{
			if (this.TemplatePath.selectedIndex == -1)
			{
				Alert(_lang_select_template);
				return false;
			}
		
			if (this.SkinPath.selectedIndex == -1)
			{
				Alert(_lang_select_skin);
				return false;
			}
	
			if (!IsAllowedType(this.Logo.value, this.LogoAllowedType.value))
			{
				Alert(_lang_logo_type_must_be + this.LogoAllowedType.value, function(){this.Logo.select();}, this);
				return false;
			}
			
			if (!IsAllowedType(this.Link.value, this.LinkAllowedType.value))
			{
				Alert(_lang_link_type_must_be + this.LinkAllowedType.value, function(){this.Link.select();}, this);
				return false;
			}
		}
		
		var data = 'Name=' + encodeURIComponent(this.Name.value);
		data += '&Lang=' + _lang;
		if (this.ParentID.value != '')
			data += '&ParentID=' + this.ParentID.value;
		data += '&Path=' + encodeURIComponent(this.Path.value);
		data += '&TemplateLang=' + this.TemplateLang.value;
		if (!$('#OuterLink')[0].checked)
		{
			if (this.Path.value.indexOf('/') == 0 || this.Path.value.lastIndexOf('/') != this.Path.value.length - 1)
			{
				Alert(_lang_path_incorrect, function(){this.Path.select();}, this);
				return false;
			}
		
			var itemNodes = _xmlChannel.documentElement.childNodes;
			for (var i = 0; i < itemNodes.length; i++)
			{
				if (typeof (itemNodes[i].selectSingleNode) == 'undefined')
					continue;
							
				var pathNode = itemNodes[i].selectSingleNode(AliCMS.SystemModule.Channel.Path);
				if ((pathNode == null && this.Path.value == '') || (pathNode != null && pathNode.text == this.Path.value))
				{
					Alert(_lang_path_exist, function(){this.Path.select();}, this);
					return false;
				}
			}
	
			if ($('#FunctionalChannel')[0].checked)
				data += '&InstanceID=' + this.InstanceID.value;
			data += '&TemplatePath=' + this.TemplatePath.value;
			data += '&SkinPath=' + this.SkinPath.value;
			data += '&TranslateLang=' + this.TranslateLang.value;
			data += '&IsDynamicTemplate=' + $('#IsDynamicTemplateYes')[0].checked;
			data += '&Generate=' + $('#GenerateYes')[0].checked;
			data += '&DefaultDocument=' + encodeURIComponent(this.DefaultDocument.value);
			data += '&Extension=' + encodeURIComponent(this.Extension.value);
			data += '&Domain=' + encodeURIComponent(this.Domain.value);
			data += '&Notice=' + encodeURIComponent(this.Notice.value);
			data += '&Footer=' + encodeURIComponent(this.Footer.value);
			data += '&ICP=' + encodeURIComponent(this.ICP.value);
			data += '&StatisticsCode=' + encodeURIComponent(this.StatisticsCode.value);
			data += '&VisualEdit=' + $('[name=VisualEdit]:checked').val();
			data += '&EnableMenu=' + $('[name=EnableMenu]:checked').val();
			data += '&NavPosition=' + $('[name=NavPosition]:checked').val();
			data += '&SideNavStyle=' + $('[name=SideNavStyle]:checked').val();
			data += '&AdminRole=' + encodeURIComponent(this.AdminRole.value);
			data += '&LoginPath=' + encodeURIComponent(this.LoginPath.value);
			data += '&MetaKeywords=' + encodeURIComponent(this.MetaKeywords.value);
			data += '&MetaDescription=' + encodeURIComponent(this.MetaDescription.value);

			__uploadLogo = _uploader.NeedUpload('Logo');
			if (!__uploadLogo)
				data += '&Logo=' + encodeURIComponent(this.Logo.value);

			__uploadLink = _uploader.NeedUpload('Link');
			if (!__uploadLink)
				data += '&Link=' + encodeURIComponent(this.Link.value);
			
			var guid = __base.add({object:__object,data:data,silent:true});
			if (guid)
			{
				var id = __base.post({object:__object,operation:'GetInnerIDFromGuid',params:'ID=' + guid,silent:true});
				uploadLogo(id);
			}

			return false;
		}
	};
	
	this.modify = function()
	{
		if (this.Name.value == "")
		{
			Alert(_lang_name_empty, function(){this.Name.select();}, this);
			return false;
		}
		
		if (_type != 'OuterLink')
		{
			if (this.Path.value.indexOf('/') == 0 || this.Path.value.lastIndexOf('/') != this.Path.value.length - 1)
			{
				Alert(_lang_path_incorrect, function(){this.Path.select();}, this);
				return false;
			}
		}
		
		var data = 'ParentID=' + this.ParentID.value;
		data += '&Name=' + encodeURIComponent(this.Name.value);
		data += '&Path=' + encodeURIComponent(this.Path.value);
		if (_templatePath != '')
		{
			if (!IsAllowedType(this.Logo.value, this.LogoAllowedType.value))
			{
				Alert(_lang_logo_type_must_be + this.LogoAllowedType.value, function(){this.Logo.select();}, this);
				return false;
			}
			
			if (!IsAllowedType(this.Link.value, this.LinkAllowedType.value))
			{
				Alert(_lang_link_type_must_be + this.LinkAllowedType.value, function(){this.Link.select();}, this);
				return false;
			}
			
			if (_instanceID != g_empty)
			{
				data += '&InstanceID=' + encodeURIComponent(this.InstanceID.value);
				data += '&IsDynamicTemplate=' + $("#IsDynamicTemplateYes")[0].checked;
				data += '&VisualEdit=' + $("[name=VisualEdit]:checked").val();
			}
			data += '&Generate=' + $('#GenerateYes')[0].checked;
			data += '&DefaultDocument=' + encodeURIComponent(this.DefaultDocument.value);
			data += '&Extension=' + encodeURIComponent(this.Extension.value);

			data += '&Domain=' + encodeURIComponent(this.Domain.value);
			data += '&Notice=' + encodeURIComponent(this.Notice.value);
			data += '&Footer=' + encodeURIComponent(this.Footer.value);
			data += '&ICP=' + encodeURIComponent(this.ICP.value);
			data += '&StatisticsCode=' + encodeURIComponent(this.StatisticsCode.value);
			data += '&EnableMenu=' + $('[name=EnableMenu]:checked').val();
			data += '&NavPosition=' + $('[name=NavPosition]:checked').val();
			data += '&SideNavStyle=' + $('[name=SideNavStyle]:checked').val();
			data += '&AdminRole=' + encodeURIComponent(this.AdminRole.value);
			data += '&LoginPath=' + encodeURIComponent(this.LoginPath.value);
			data += '&MetaKeywords=' + encodeURIComponent(this.MetaKeywords.value);
			data += '&MetaDescription=' + encodeURIComponent(this.MetaDescription.value);

			__uploadLogo = _uploader.NeedUpload('Logo');
			if (!__uploadLogo)
				data += '&Logo=' + encodeURIComponent(this.Logo.value);

			__uploadLink = _uploader.NeedUpload('Link');
			if (!__uploadLink)
				data += '&Link=' + encodeURIComponent(this.Link.value);
			
			__base.post({object:__object,operation:'Modify',data:data,params:'ID=' + _id,silent:true});
			uploadLogo(_id);

			return false;
		}
	};
	
	function uploadLogo(id)
	{
		if (!__uploadLogo)
		{
			uploadLink(id);
			return;
		}
		
		_uploader.Init({Status:_lang_uploading_logo,Params:'Lang=' + _lang + '&Object=' + __object + '&Operation=UploadLogo&ID=' + id});
		_uploader.Upload('Logo', function()
		{
			if (arguments[0] != 0)
			{
				Alert(arguments[1]);
				SetStatusMessage();
				$(':submit')[0].disabled = false;
			}
			else
			{
				$('#LogoTextbox').val(arguments[1]);
				uploadLink(id);
			}
		});
	}
	
	function uploadLink(id)
	{
		if (!__uploadLink)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
			$(':submit')[0].disabled = false;
			return;
		}
		
		_uploader.Init({Status:_lang_uploading_link,Params:'Lang=' + _lang + '&Object=' + __object + '&Operation=UploadLink&ID=' + id});
		_uploader.Upload('Link', function()
		{
			if (arguments[0] != 0)
			{
				Alert(arguments[1]);
			}
			else
			{
				$('#LinkTextbox').val(arguments[1]);
				Alert(_lang_operation_success);
			}
			SetStatusMessage();
			$(':submit')[0].disabled = false;
		});
	}
	
	this.move = function(from,to)
	{
		var action = 'Move';
		var sort = $('#Sort').val();

		if (sort == '2' || sort == '3')
			action = 'MoveRecommend';
		else if (sort == '4' || sort == '5')
			action = 'MoveHold';
		
		__base.move(__object, action, from, to);
	};
	
	this.del = function(id)
 	{
		__base.post({object:__object, operation:'Delete',hasList:true,params:'ID=' + id});
	};
	
	this.onTypeClick = function()
	{
		var trs = $('tr');
		
		if ($('#FunctionalChannel')[0].checked)
		{
			onInstanceIDChange();
			
			trs.each(function(){this.style.display = '';});
			$('[name=EnableMenu]:checked').click();
			
			$('#PathTip').html(_lang_path_tip1);
			$('[name=Path]').val('');
			
			$('#IsDynamicTemplateNo').closest('tr').show();
			$('#VisualEdit0').closest('tr').show();
		}
		else if ($('#NonFunctionalChannel')[0].checked)
		{
			var templateSelect = document.forms[0].TemplatePath;
			templateSelect.length = 0;
			
			var itemList = _xmlTemplate.documentElement.childNodes;
			for (var i = 0; i < itemList.length; i++)
			{
				if (typeof (itemList[i].selectSingleNode) == 'undefined')
					continue;
	
				if (itemList[i].selectSingleNode(AliCMS.SystemModule.Template.IsWebsite).text.toLowerCase() == 'true')
					continue;
	
				var path = itemList[i].selectSingleNode(AliCMS.SystemModule.Template.Path).text;
				var moduleID = itemList[i].selectSingleNode(AliCMS.SystemModule.Template.ModuleID).text;
				if (moduleID != '')
					continue;
				
				var skins = _xmlSkin.selectNodes('//Item[' + AliCMS.SystemModule.Skin.Language + "='" + document.forms[0].TemplateLang.value + "']");
				for (var j = 0; j < skins.length; j++)
				{
					var templatePath = skins[j].selectSingleNode(AliCMS.SystemModule.Skin.TemplatePath).text;
					if (templatePath.indexOf(path) != -1)
					{
						templateSelect.options.add(new Option(path.substr(0, path.length - 1), path));
						break;
					}
				}
			}
		
			_onTemplatePathChange();
			
			for (var i = 0; i < trs.length; i++)
			{
				if (i == 2)
					trs.eq(i).css('display', 'none');
				else
					trs.eq(i).css('display', '');
			}
			$('[name=EnableMenu]:checked').click();
			
			$("#PathTip").html(_lang_path_tip1);
			$("[name=Path]").val("");
			
			var dt = $('#IsDynamicTemplateNo');
			dt[0].checked = true;
			dt.closest('tr').hide();
			
			var ve = $('#VisualEdit0');
			ve[0].checked = true;
			ve.closest("tr").hide();
			
			$(':submit')[0].disabled = false;
		}
		else
		{
			for (var i = 2; i < trs.length; i++)
			{
				if (i == 3 || i == 4 || i == 5)
					continue;
					
				trs.eq(i).css('display', 'none');
			}
			
			$('#PathTip').html(_lang_path_tip2);
			$('[name=Path]').val('http://');
			
			$(':submit')[0].disabled = false;
		}
	};
	
	this.onTemplatePathChange = function()
	{
		_onTemplatePathChange();
	};
	
	function _onTemplatePathChange()
	{
		var form = document.forms[0];
		var templateSelect = form.TemplatePath;
		var skinSelect = form.SkinPath;
		skinSelect.length = 0;
		
		if (templateSelect.selectedIndex == -1)
			return;
	
		var itemList = _xmlSkin.selectNodes('//Item[' + AliCMS.SystemModule.Skin.Language + "='" + form.TemplateLang.value + "']");
		for (var i = 0; i < itemList.length; i++)
		{
			if (typeof (itemList[i].selectSingleNode) == 'undefined')
				continue;
			
			var templatePath = itemList[i].selectSingleNode(AliCMS.SystemModule.Skin.TemplatePath).text;
			if (templatePath.indexOf(templateSelect.options[templateSelect.selectedIndex].text + '/') == -1)
				continue;
	
			var path = itemList[i].selectSingleNode(AliCMS.SystemModule.Skin.Path).text;
			var text = path.substr(0, path.length - 2 - form.TemplateLang.value.length);
			var slash = text.lastIndexOf('/');
			if (slash != -1)
				text = text.substr(slash + 1);
			
			skinSelect.options.add(new Option(text, path));
			
			if (_page == 'channel_change_template' && path == _skinPath)
				skinSelect.selectedIndex = skinSelect.options.length - 1;
		}
		
		_onSkinPathChange();
	}
	
	this.onMatchClick = function()
	{
		_onMatchClick();
	};
	
	function _onMatchClick()
	{
		var form = document.forms[0];
		if (this.checked)
			form.TemplateLang.value = form.TranslateLang.value;
		else
			form.TemplateLang.value = _channelLang;
		_onTemplatePathChange();
	}
	
	this.onTranslateLangChange = function()
	{
		var form = document.forms[0];
		if (form.TranslateLang.value == '')
		{
			$('#MatchSpan').css('display', 'none');
			$('#Match')[0].checked = false;
		}
		else
		{
			$('#MatchSpan').css('display', '');
		}
		
		_onMatchClick();
	};
	
	this.onSkinPathChange = function()
	{
		_onSkinPathChange();
	};
	
	function _onSkinPathChange()
	{
		var form = document.forms[0];
		var templateSelect = form.TemplatePath;
		var skinSelect = form.SkinPath;
		
		if (skinSelect.selectedIndex == -1)
			return;
		
		var itemList = _xmlSkin.selectNodes('//Item[' + AliCMS.SystemModule.Skin.Language + "='" + form.TemplateLang.value + "' and " + AliCMS.SystemModule.Skin.Path + "='" + skinSelect.value + "']");
		for (var i = 0; i < itemList.length; i++)
		{
			if (typeof (itemList[i].selectSingleNode) == 'undefined')
				continue;
			
			var templatePath = itemList[i].selectSingleNode(AliCMS.SystemModule.Skin.TemplatePath).text;
			if (templatePath.indexOf(templateSelect.options[templateSelect.selectedIndex].text) != -1)
			{
				$('#Thumbnail').attr('src', itemList[i].selectSingleNode(AliCMS.SystemModule.Skin.Thumbnail).text);
				break;
			}
		}
	}
	
	this.getTemplateList = function(moduleID)
	{
		SetStatusMessage(_lang_loading_template_list);
	
		$.ajax(
		{
			url : _webPath + 'alicms.aspx?Lang=' + _lang + '&Object=Template&Operation=List' + (moduleID == null ? '' : '&Condition=' + encodeURIComponent(AliCMS.SystemModule.Template.ModuleID + ':' + moduleID)),
			data : {},
			type : 'POST',
			error : function(request)
			{
				Alert(_lang_operation_fail);
				SetStatusMessage();
			},
			success : function(data)
			{
				_xmlTemplate.loadXML(data);
				_getSkinList();
			}
		});
	};
	
	this.getSkinList = function()
	{
		_getSkinList();
	};
	
	function _getSkinList()
	{
		SetStatusMessage(_lang_loading_skin_list);
	
		$.ajax(
		{
			url : _webPath + 'alicms.aspx?Lang=' + _lang + '&Object=Skin&Operation=List',
			data : {},
			type : 'POST',
			error : function(request)
			{
				Alert(_lang_operation_fail);
				SetStatusMessage();
			},
			success : function(data)
			{
				_xmlSkin.loadXML(data);
				
				if (_page == 'channel_add')
				{
					if ($('#FunctionalChannel')[0].checked)
						_onInstanceIDChange();
						
					_getChannelList();
				}
				else// if (_page == "channel_change_template")
				{
					var templateSelect = document.forms[0].TemplatePath;
				
					var itemList = _xmlTemplate.documentElement.childNodes;
					for (var i = 0; i < itemList.length; i++)
					{
						if (typeof (itemList[i].selectSingleNode) == 'undefined')
							continue;
						
						if (itemList[i].selectSingleNode(AliCMS.SystemModule.Template.IsWebsite).text.toLowerCase() == 'true')
							continue;
	
						var path = itemList[i].selectSingleNode(AliCMS.SystemModule.Template.Path).text;
						
						var skins = _xmlSkin.documentElement.childNodes;
						for (var j = 0; j < skins.length; j++)
						{
							if (typeof (skins[j].selectSingleNode) == 'undefined')
								continue;
							
							var templatePath = skins[j].selectSingleNode(AliCMS.SystemModule.Skin.TemplatePath).text;
							if (templatePath.indexOf(path) != -1)
							{
								templateSelect.options.add(new Option(path.substr(0, path.length - 1), path));
								
								if (path == _templatePath)
									templateSelect.selectedIndex = templateSelect.length - 1;
								break;
							}
						}
					}
					
					var form = document.forms[0];
					if (form.TranslateLang.value == '')
					{
						$('#MatchSpan').css('display', 'none');
						$('#Match')[0].checked = false;
					}
					else
					{
						$('#MatchSpan').css('display', '');
					}
	
					_onTemplatePathChange();
					
					SetStatusMessage();
				}
			}
		});
	}
	
	this.getChannelList = function()
	{
		_getChannelList();
	};
	
	function _getChannelList()
	{
		SetStatusMessage(_lang_loading_channel_list);
	
		$.ajax(
		{
			url : _webPath + 'alicms.aspx?Lang=' + _lang + '&Object=Channel&Operation=List',
			data : {},
			type : 'POST',
			error : function(request)
			{
				Alert(_lang_operation_fail);
				SetStatusMessage();
			},
			success : function(data)
			{
				_xmlChannel.loadXML(data);
				
				if (_page != 'channel_extra_instance')
				{
					var parentSelect = document.forms[0].ParentID;
					var oldParentID = parentSelect.value;
					parentSelect.length = 1;
				
					BuildTreeOptions(_xmlChannel, AliCMS.SystemModule.Channel.ParentID, AliCMS.SystemModule.Channel.ID, AliCMS.SystemModule.Channel.Name, parentSelect);
					CheckAndSelect(parentSelect, oldParentID);
				}
				
				SetStatusMessage();
			}
		});
	}
	
	this.onInstanceIDChange = function()
	{
		_onInstanceIDChange();
	};
	
	function _onInstanceIDChange()
	{
		var form = document.forms[0];
		var instanceSelect = form.InstanceID;
		var templateSelect = form.TemplatePath;
		var skinSelect = form.SkinPath;
		templateSelect.length = 0;
		skinSelect.length = 0;
		
		if (instanceSelect == null)
		{
			$(':submit')[0].disabled = true;
			return;
		}
		
		if (instanceSelect.length == 0)
			return;
		
		var itemList = _xmlTemplate.selectNodes('//Item[' + AliCMS.SystemModule.Template.ModuleID + "='" + $(instanceSelect.options[instanceSelect.selectedIndex]).attr("ModuleID") + "']");
		for (var i = 0; i < itemList.length; i++)
		{
			if (typeof (itemList[i].selectSingleNode) == 'undefined')
				continue;
			
			if (itemList[i].selectSingleNode(AliCMS.SystemModule.Template.IsWebsite).text.toLowerCase() == 'true')
				continue;
	
			var path = itemList[i].selectSingleNode(AliCMS.SystemModule.Template.Path).text;
			
			var skins = _xmlSkin.selectNodes('//Item[' + AliCMS.SystemModule.Skin.Language + "='" + form.TemplateLang.value + "']");
			for (var j = 0; j < skins.length; j++)
	
			{
				var templatePath = skins[j].selectSingleNode(AliCMS.SystemModule.Skin.TemplatePath).text;
				if (templatePath.indexOf(path) != -1)
				{
					templateSelect.options.add(new Option(path.substr(0, path.length - 1), path));
					break;
				}
			}
		}
		
		_onTemplatePathChange();
	}
	
	this.changeTemplate = function()
	{
		if (this.TemplatePath.selectedIndex == -1)
		{
			Alert(_lang_select_template);
			return false;
		}
	
		if (this.SkinPath.selectedIndex == -1)
		{
			Alert(_lang_select_skin);
			return false;
		}
		
		var data = 'TemplatePath=' + this.TemplatePath.value;
		data += '&SkinPath=' + this.SkinPath.value;
		data += '&TemplateLang=' + this.TemplateLang.value;
		data += '&TranslateLang=' + this.TranslateLang.value;
	
		$(':submit')[0].disabled = true;
		SetStatusMessage(_lang_working);
		
		$.ajax(
		{
			url : _webPath + 'alicms.aspx?Lang=' + _lang + '&Object=' + __object + '&Operation=Modify&ID=' + _id,
			data : data,
			type : 'POST',
			error : function(request)
			{
				Alert(_lang_operation_fail);
				SetStatusMessage();
				$(':submit')[0].disabled = false;
			},
			success : function(data)
			{
				Alert(_lang_operation_success);
				SetStatusMessage();
				$(':submit')[0].disabled = false;
			}
		});
		
		return false;
	};
	
	this.onBindingInstanceChange = function()
	{
		var form = this.form;
		if (form.BindingChannelID == null)
			return;

		form.BindingChannelID.length = 1;
		if (form.BindingInstanceID.value != '')
		{
			var channels = _xmlChannel.selectNodes('//Item[' + AliCMS.SystemModule.Channel.InstanceID + "='" + form.BindingInstanceID.value + "' and " + AliCMS.SystemModule.Channel.Lang + "='" + _channelLang + "']");
			for (var i = 0; i < channels.length; i++)
			{
				var name = channels[i].selectSingleNode(AliCMS.SystemModule.Channel.Name).text;
				var id = channels[i].selectSingleNode(AliCMS.SystemModule.Channel.ID).text;
				var parent = channels[i];
				while (parent.selectSingleNode(AliCMS.SystemModule.Channel.ParentID).text != g_empty)
				{
					parent = _xmlChannel.selectSingleNode('//Item[' + AliCMS.SystemModule.Channel.ID + "='" + parent.selectSingleNode(AliCMS.SystemModule.Channel.ParentID).text + "']");
					name = parent.selectSingleNode(AliCMS.SystemModule.Channel.Name).text + ' → ' + name;
				}
				form.BindingChannelID.options.add(new Option(name, id));
			}
		}
	};
	
	this.setExtraInstance = function()
	{
		if (this.BindingInstanceID.value == '' && (typeof(this.BindingChannelID) == 'undefined' || this.BindingChannelID.value == ''))
		{
			if (this.ID.value == '')
				return false;
	
			var form = this;
			
			SetStatusMessage(_lang_working);
	
			$.ajax(
			{
				url : _webPath + 'alicms.aspx?Lang=' + _lang + '&Object=Channel.ExtraInstance&Operation=Delete&ID=' + this.ID.value,
				data : {},
				type : 'POST',
				error : function(request)
				{
					Alert(_lang_operation_fail);
					SetStatusMessage();
				},
				success : function(data)
				{
					Alert(_lang_operation_success);
					SetStatusMessage();
					
					form.ID.value = '';
				}
			});		
		}
		else
		{
			if (typeof(this.BindingChannelID) != 'undefined' && this.BindingChannelID.value == '')
			{
				Alert(_lang_select_channel);
				return false;
			}
			
			var form = this;
			var data = '';
	
			SetStatusMessage(_lang_working);
	
			if (this.ID.value == '')
			{
				if (typeof(this.BindingChannelID) == 'undefined')
					data = 'ChannelID=' + _channelID + '&Mark=' + this.Mark.value + '&BindingInstanceID=' + this.BindingInstanceID.value + '&BindingChannelID=';
				else
					data = 'ChannelID=' + _channelID + '&Mark=' + this.Mark.value + '&BindingChannelID=' + this.BindingChannelID.value + '&BindingInstanceID=';
					
				$.ajax(
				{
					url : _webPath + 'alicms.aspx?Lang=' + _lang + '&Object=Channel.ExtraInstance&Operation=Add',
					data : data,
					type : 'POST',
					error : function(request)
					{
						Alert(_lang_operation_fail);
						SetStatusMessage();
					},
					success : function(data)
					{
						$.ajax(
						{
							url : _webPath + 'alicms.aspx?Lang=' + _lang + '&Object=Channel.ExtraInstance&Operation=GetInnerIDFromGuid&ID=' + data,
							type : 'GET',
							error : function(request)
							{
								Alert(_lang_operation_fail);
								SetStatusMessage();
							},
							success : function(data)
							{
								Alert(_lang_operation_success);
								SetStatusMessage();
								
								form.ID.value = data;
							}
						});
					}
				});		
			}
			else
			{
				if (this.BindingChannelID == null)
					data = 'BindingInstanceID=' + this.BindingInstanceID.value + '&BindingChannelID=';
				else
					data = 'BindingChannelID=' + this.BindingChannelID.value + '&BindingInstanceID=';
	
				$.ajax(
				{
					url : _webPath + 'alicms.aspx?Lang=' + _lang + '&Object=Channel.ExtraInstance&Operation=Modify&ID=' + this.ID.value,
					data : data,
					type : 'POST',
					error : function(request)
					{
						Alert(_lang_operation_fail);
						SetStatusMessage();
					},
					success : function(data)
					{
						Alert(_lang_operation_success);
						SetStatusMessage();
					}
				});
			}
		}
	
		return false;
	}
}

//------------------
//start:栏目管理_栏目菜单
function ChannelMenu()
{
	var __object = 'Channel.Menu';
	var __base = new Base();

	this.add = function()
	{
		if (this.Name.value == '')
		{
			Alert(_lang_name_empty, function(){this.Name.select();}, this);
			return false;
		}

		var data = 'ChannelID=' + _channelID;
		data += '&ParentID=' + this.ParentID.value;
		data += '&Nav=' + this.Nav.value;
		data += '&Name=' + encodeURIComponent(this.Name.value);
		if ($('#page-type-template')[0].checked)
		{
			data += '&TemplatePath=' + encodeURIComponent(this.TemplatePath.value);
			data += '&PathInTemplate=' + encodeURIComponent(this.PathInTemplate.value);
			data += '&URL=';
		}
		else
		{
			data += '&TemplatePath=';
			data += '&PathInTemplate=';
			data += '&URL=' + encodeURIComponent(this.URL.value);
		}
		data += '&Target=' + encodeURIComponent(this.Target.value);

		data += '&InstanceID=' + this.InstanceID.value;
		if (this.OperationID.value != '')
		{
			data += '&ObjectID=' + this.ObjectID.value;
			data += '&OperationID=' + this.OperationID.value;
		}

		__base.add({object:__object,data:data});
		
		return false;
	};
	
	this.modifyName = function()
	{
		if (this.Name.value == '')
		{
			Alert(_lang_name_empty, function(){this.Name.select();}, this);
			return false;
		}

		var data = 'Name=' + encodeURIComponent(this.Name.value);

		__base.modify({object:__object,data:data,id:$(this).parent().attr('ItemID')});

		return false;
	};
	
	this.modify = function()
	{
		if (this.Name.value == '')
		{
			Alert(_lang_name_empty, function(){this.Name.select();}, this);
			return false;
		}

		var data = 'ParentID=' + this.ParentID.value;
		data += '&Nav=' + this.Nav.value;
		data += '&Name=' + encodeURIComponent(this.Name.value);
		if ($('#page-type-template')[0].checked)
		{
			data += '&TemplatePath=' + encodeURIComponent(this.TemplatePath.value);
			data += '&PathInTemplate=' + encodeURIComponent(this.PathInTemplate.value);
			data += '&URL=';
		}
		else
		{
			data += '&TemplatePath=';
			data += '&PathInTemplate=';
			data += '&URL=' + encodeURIComponent(this.URL.value);
		}
		data += '&Target=' + encodeURIComponent(this.Target.value);

		data += '&InstanceID=' + this.InstanceID.value;
		if (this.OperationID.value != '')
		{
			data += '&ObjectID=' + this.ObjectID.value;
			data += '&OperationID=' + this.OperationID.value;
		}
		else
		{
			data += '&ObjectID=';
			data += '&OperationID=';
		}

		__base.modify({object:__object,data:data});
		
		return false;
	};
	
	this.move = function(from, to)
	{

		__base.move(__object, g_action, from, to);
	}
	
	this.update = function(operation, id)
	{
		if (this.tagName == 'BUTTON')
			operation = this.id;

		__base.update(__object, operation, id);
	};
	
	this.onPageReady = function()
	{
		if (_page == 'channel_menu_edit')
		{
			$('[name=InstanceID]').change();
			$('[name=ParentID]').change();
		}
		else
		{
			loadParentList();
		}
	};
	
	function loadParentList()
	{
		var parent = $('[name=ParentID]');
		SetStatusMessage(_lang_loading_parent_list);
		
		$.ajax(
		{
			url: 'ajax_parent_list.aspx?ChannelID=' + _channelID + '&ParentID=' + parent.val(),
			type: 'GET',
			async: false,
			error: function(request)
			{
				Alert(_lang_operation_fail);
				SetStatusMessage();
			},
			success: function(data)
			{
				parent[0].length = 1;
				parent.append(data);
				SetStatusMessage();
			}
		});
	}

	function loadTemplatePathList(templatePath)
	{
		var ns = $('[name=InstanceID] :selected').data('namespace');
		if (ns == '')
			return;

		SetStatusMessage(_lang_loading_template_path_list);

		$.ajax(
		{
			url: 'ajax_template_path_list.aspx?Namespace=' + ns,
			type: 'GET',
			async: false,
			error: function(request)
			{
				Alert(_lang_operation_fail);
				SetStatusMessage();
			},
			success: function(data)
			{
				var element =$('[name=TemplatePath]');
				element[0].length = 1;
				element.append(data);
				
				if (templatePath)
				{
					element.val(templatePath);
					if (_page == 'channel_menu_edit')
						loadPageList(_nav, _pathInTemplate);
					else
						loadPageList();
				}

				SetStatusMessage();
			}
		});
	}

    function loadPageList(nav, pathInTemplate)
    {
		var templatePath = $('[name=TemplatePath] :selected').val();
		if (templatePath == '')
			return;

		SetStatusMessage(_lang_loading_page_list);

		$.ajax(
		{
			url: 'ajax_page_list.aspx?TemplatePath=' + templatePath,
			type: 'GET',
			async: false,
			error: function(request)
			{
				Alert(_lang_operation_fail);
				SetStatusMessage();
			},
			success: function(data)
			{
				var element = $('[name=Nav]');
				element[0].length = 1;
				element.append(data);
				if (nav)
					element.val(nav);

				element = $('[name=PathInTemplate]');
				element[0].length = 1;
				element.append(data);
				if (pathInTemplate)
					element.val(pathInTemplate);

				SetStatusMessage();
			}
		});
    };

	function loadObjectList(objectID)
	{
		$('[name=ObjectID]')[0].length = 1;
		$('[name=OperationID]')[0].length = 1;
		
		var option = $('[name=InstanceID] :selected');
		if (option.val() == '')
			return;

		SetStatusMessage(_lang_loading_object_list);

		$.ajax(
		{
			url: 'ajax_object_list.aspx?Namespace=' + option.data('namespace') + '&ObjectID=' + objectID,
			type: 'GET',
			async: false,
			error: function(request)
			{
				Alert(_lang_operation_fail);
				SetStatusMessage();
			},
			success: function(data)
			{
				$('[name=ObjectID]').append(data);
				
				if (objectID)
				{
					if (_page == 'channel_menu_edit')
						loadOperationList(_operationID);
					else
						loadOperationList();
				}

				SetStatusMessage();
			}
		});
	}
	
	this.onObjectIDChange = function()
	{
		if (_page == 'channel_menu_edit')
			loadOperationList(_operationID);
		else
			loadOperationList();
	}

    function loadOperationList(operationID)
    {

		$('[name=OperationID]')[0].length = 1;

		var option = $('[name=ObjectID] :selected');
		if (option.val() == '')
			return;
		
		SetStatusMessage(_lang_loading_operation_list);

		$.ajax(
		{
			url: 'ajax_operation_list.aspx?Namespace=' + $('[name=InstanceID] :selected').data('namespace') + '&ObjectID='  + option.data('innerId') + '&OperationID=' + operationID,
			type: 'GET',
			async: false,
			error: function(request)
			{
				Alert(_lang_operation_fail);
				SetStatusMessage();
			},
			success: function(data)
			{
				$('[name=OperationID]').append(data);
				SetStatusMessage();
			}
		});
    }
	
	this.onParentIDChange = function()
	{
		var option = $('[name=ParentID] :selected');
		if (option.val() != '')
			$('[name=Nav]').val('')[0].disabled = true;
		else
			$('[name=Nav]')[0].disabled = false;
	};
	
	this.onPageTypeClick = function()
	{
		var table = $(this).closest('table');
		if (this.id == 'page-type-template')
		{
			table.find('tr:eq(1)').show();
			table.find('tr:eq(2)').hide();
		}
		else
		{
			table.find('tr:eq(1)').hide();
			table.find('tr:eq(2)').show();
		}
	};
	
	this.onInstanceIDChange = function()
	{
		var option = $('[name=InstanceID] :selected');

		$('[name=Nav]')[0].length = 1;
		$('[name=TemplatePath]')[0].length = 1;
		$('[name=PathInTemplate]')[0].length = 1;

		if (option.val() == '')
			return;

		if (_page == 'channel_menu_edit')
		{
			loadTemplatePathList(_templatePath);
			loadObjectList(_objectID);
		}
		else
		{
			loadTemplatePathList();
			loadObjectList();
		}
	};
	
	this.onTemplatePathChange = function()
	{
		var option = $('[name=TempaltePath] :selected');

		$('[name=Nav]')[0].length = 1;
		$('[name=PathInTemplate]')[0].length = 1;

		if (option.val() == '')
			return;

		loadPageList();
	};

	this.onTargetCandidateChange = function()
	{
		this.form.Target.value = this.value;
	};
}
//end:栏目管理_栏目菜单
//------------------
//end:栏目管理
//----------------------------------------------------

//-------------------------------------------------
//Start : 生成管理
function GetTemplatePages()
{
	$.ajax(
	{
		url : _webPath + "alicms.aspx?Object=Template.Page&Operation=List&Condition=" + encodeURIComponent(AliCMS.SystemModule.Template_Page.TemplatePath + ":" + _channels[_channelIndex].TemplatePath),
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_pages);
		},
		success : function(data)
		{
			_pages.loadXML(data);
			_pageIndex = 0;
			GenerateChannel();
		}
	});
}

function GenerateChannel()
{
	var pages = _pages.documentElement.childNodes;
	
	while (_pageIndex < pages.length && typeof(pages[_pageIndex].selectSingleNode) == "undefined")
	{
		_pageIndex++;
	}
	
	if (_pageIndex >= pages.length)
	{
		$(document.body).append(_lang_generate_complete);
		return;
	}

	_mark  = pages[_pageIndex].selectSingleNode(AliCMS.SystemModule.Template_Page.Mark).text;
	_object  = pages[_pageIndex].selectSingleNode(AliCMS.SystemModule.Template_Page.Object).text;
	if (_type == "Object" && _objectHeader != _object)
	{
		_pageIndex++;
		GenerateChannel();
		return;
	}
	
	_pathInChannel = pages[_pageIndex].selectSingleNode(AliCMS.SystemModule.Template_Page.PathInChannel).text;
	if (_pathInChannel == "")
	{
		_pathInChannel = pages[_pageIndex].selectSingleNode(AliCMS.SystemModule.Template_Page.PathInTemplate).text.replace(".dwt", "");
		if (_pathInChannel.indexOf(".e") == _pathInChannel.length - 2)
			_pathInChannel = _pathInChannel.substr(0, _pathInChannel.length - 2);
	}
	_pathInChannel = _webPath + _channels[_channelIndex].Path + _pathInChannel;

	var runAt = pages[_pageIndex].selectSingleNode(AliCMS.SystemModule.Template_Page.RunAt).text;
	if (_pathInChannel.indexOf(".ascx") != -1 && runAt == "Execute")
	{
		_pageIndex++;
		GenerateChannel();
		return;
	}
	
	_pageIndex++;
	if (_object == "")
	{
		_pathInChannel = _pathInChannel.replace("{Ext}", _channels[_channelIndex].Extension);
		
		if (_pathInChannel.replace("{Page}", "").indexOf("{") != -1)
		{
			GenerateChannel();
			return;
		}
		
		_caller[_caller.length] = GenerateChannel;
		if (_pathInChannel.indexOf("{Page}") != -1)
		{
			_pageNumber = -1;
			_pageCount = 0;
			GeneratePage();
		}
		else
		{
			Generate(_pathInChannel);
		}
	}
	else
	{
		if (_pathInChannel.replace(/\{(ID|Page|Ext)\}/g, "").indexOf("{") != -1)
		{
			GenerateChannel();
			return;
		}
		
		_records = null;
		_recordPageNumber = 1;
		_pathInChannelBackup = _pathInChannel;
		GenerateObject();
	}
}

function GenerateObject()
{
	if (_records == null)
	{
		$.ajax(
		{
			url : _webPath + "alicms.aspx?Instance=" + _channels[_channelIndex].InstanceID + "&Lang=" + _channels[_channelIndex].Lang + "&Object=" + _object + "&Operation=List&Page=" + _recordPageNumber + "&PageSize=" + _pageSize,
			type : "GET",
			error : function(request)
			{
				GenerateChannel();
			},
			success : function(data)
			{
				_recordIndex = 0;
				_records = CreateXmlDom();
				_records.loadXML(data);
				if (data.indexOf("<") != 0 || _records.documentElement.childNodes.length == 0)
					GenerateChannel();
				else
					GenerateObject();
			}
		});
		return;
	}
	
	var records = _records.documentElement.childNodes;
	
	while (_recordIndex < records.length && typeof(records[_recordIndex].selectSingleNode) == "undefined")
	{
		_recordIndex++;
	}
	
	if (_recordIndex >= records.length)
	{
		_records = null;
		_recordPageNumber++;
		GenerateObject();
		return;
	}
	
	_pathInChannel = _pathInChannelBackup;

    var prefix = "";
    if (_mark != "")
    {
        for (var i = 0; i < _extraInstances.length; i++)
        {
            if (_extraInstances[i].ChannelID == _channels[_channelIndex].ID && _extraInstances[i].Mark == _mark)
            {
                prefix = _extraInstances[i].Namespace;
                break;
            }
        }
        
        if (prefix == "")
        {
            for (var i = 0; i < _modules.length; i++)
            {
                if (_modules[i].Name == _mark)
                {
                    prefix = _modules[i].Namespace;
                    break;
                }
            }
        }
    }
    else
    {
	    prefix = _channels[_channelIndex].Namespace;
    }
    
    if (prefix != "")
    {
        prefix = prefix + "." + _object.replace(/\./g, "_") + ".";
	    if (eval("typeof (" + prefix + "PageID) == \"undefined\""))
	    {
		    _pathInChannel = _pathInChannel.replace("{ID}", records[_recordIndex].selectSingleNode(eval(prefix + "InnerID")).text);
		    _pathInChannel = _pathInChannel.replace("{Ext}", _channels[_channelIndex].Extension);
	    }
	    else
	    {
	        var node = records[_recordIndex].selectSingleNode(eval(prefix + "PageGenerate"));
		    if (node != null && node.text == "0")
		    {
			    _recordIndex++;
			    GenerateObject();
			    return;
		    }

    		node = records[_recordIndex].selectSingleNode(eval(prefix + "PageID"));
		    _pathInChannel = _pathInChannel.replace("{ID}", node.text);
    		
    		node = records[_recordIndex].selectSingleNode(eval(prefix + "PageExtension"));
		    if (node == null || node.text == "")
			    _pathInChannel = _pathInChannel.replace("{Ext}", _channels[_channelIndex].Extension);
		    else
			    _pathInChannel = _pathInChannel.replace("{Ext}", node.text);
	    }
	}
	
	_recordIndex++;
	_caller[_caller.length] = GenerateObject;
	if (_pathInChannel.indexOf("{Page}") != -1)
	{
		_pageNumber = -1;
		_pageCount = 0;
		GeneratePage();
	}
	else
	{
		Generate(_pathInChannel);
	}
}

function GeneratePage()
{
	if (_pageNumber >= _pageCount || (_pageNumber == 0 && _pageCount == 1))
	{
		var caller = _caller[_caller.length - 1];
		_caller.length = _caller.length - 1;
		caller();
		return;
	}
	
	if (_pageCount <= 0)
	{
		$.ajax(
		{
			url : _webPath + "alicms.aspx?Action=Generate&Path=" + encodeURIComponent(_pathInChannel.replace("{Page}", "")) + "&GetPageCount=1",
			type : "GET",
			error : function(request)
			{
				var caller = _caller[_caller.length - 1];
				_caller.length = _caller.length - 1;
				caller();
			},
			success : function(data)
			{
				_pageCount = parseInt(data);
				if (_pageCount == 0 || isNaN(_pageCount))
					_pageCount = 1;
				GeneratePage();
			}
		});
	}
	else
	{
		_pageNumber++;
		_caller[_caller.length] = GeneratePage;
		Generate(_pageNumber == 0 ? _pathInChannel.replace("{Page}", "") : _pathInChannel.replace("{Page}", "_" + _pageNumber));
	}
}

function Generate(path)
{
	if (path == null)
	{
		var caller = _caller[_caller.length - 1];
		_caller.length = _caller.length - 1;
		caller();
		return;
	}

	$(document.body).append(_lang_generating + "<a href=\"" + path + "\" target=\"_blank\">" + path + "</a>");
	window.scrollTo(0, document.body.scrollHeight);
	$.ajax(
	{
		url : _webPath + "alicms.aspx?Action=Generate&Path=" + encodeURIComponent(path),
		data : {},
		type : "POST",
		error : function(request)
		{
			$(document.body).append(" , <div style=\"display:inline;color:#F00\">" + _lang_generate_fail + "," + _lang_sleep.replace("{Interval}", _interval) + "<div>");
			setTimeout("Generate()", _interval * 1000);
		},
		success : function(data)
		{
			$(document.body).append(" , <div style=\"display:inline;color:#393\">" + _lang_generate_success + "," + _lang_sleep.replace("{Interval}", _interval) + "<div>");
			setTimeout("Generate()", _interval * 1000);
		}
	});
}

function SetGenerateSettings()
{
	if (!this.GenerateInterval.value.match(/^\d+$/))
	{
		Alert(_lang_generate_interval_incorrect, function(){this.GenerateInterval.select();}, this);
		return false;
	}
	
	var data = "DisableSmartUpdate=" + $("#SmartUpdateDisable")[0].checked;
	switch ($("[name=SmartUpdate]:checked").attr("id"))
	{
		case "SmartUpdateLow":
			data += "&SpeedUpConnectionString=";
			data += "&IIS404=false";
			data += "&GenerateInterval=" + this.GenerateInterval.value;
			break;
		case "SmartUpdateHigh":
			data += "&SpeedUpConnectionString=";
			data += "&IIS404=true";
			data += "&GenerateInterval=" + this.GenerateInterval.value;
			break;
		case "SmartUpdateSpeedUp":
			data += "&SpeedUpConnectionString=" + encodeURIComponent(this.SpeedUpConnectionString.value);
			data += "&IIS404=false";
			break;
	}

	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);

	$.ajax(
	{
		url : _webPath + "alicms.aspx?Lang=" + _lang + "&Object=InstanceConfig&Operation=SetGlobalSettings",
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		}
	});
	
	return false;	
}

//End : 生成管理
//-------------------------------------------------



(function()
{
	if (typeof(_page) == 'undefined')
		return;
	
	if (_page == 'admin_add')
	{
		var admin = new Admin();

		$('form:first').submit(admin.add);
	}
	else if (_page == 'admin_edit')
	{
		var admin = new Admin();

		$('form:first').submit(admin.modify);
	}
	else if (_page == 'admin_list')
	{
		var admin = new Admin();

		MakeButton();

		$('#IsRecycled,#RoleID').change(Search);
		$('#SelectAll').click(function(){$(':checkbox[name=Sel]').each(function(){this.checked = true;});});
		$('#ReverseSelect').click(function(){$(':checkbox[name=Sel]').each(function(){this.checked = !this.checked;});});
		$('body').on('click', '#Recycle,#Delete,#Recover', admin.update);
	}
	else if (_page == 'log_list')
	{
		var log = new Log();

		MakeButton();

		$('#SelectAll').click(function(){$(':checkbox[name=Sel]').each(function(){this.checked = true;});});
		$('#ReverseSelect').click(function(){$(':checkbox[name=Sel]').each(function(){this.checked = !this.checked;});});
		$('#Delete').click(log.update);
				
		$('#DeleteAll').on('click', function()
		{
			Confirm(_lang_confirm_delete_all, function(returnValue){if (returnValue)log.update('DeleteAll');}, this);
			return false;
		});
	}
	else if (_page == 'link_category_add')
	{
		var linkCategory = new LinkCategory();
		
		_uploader.Init({WebPath:_webPath});
		_uploader.Add("Picture", "PictureTextbox", "PictureBrowse");
		
		$('form:first').submit(linkCategory.add);
		
		$("#GuidCheckBox").click(function()
		{
			this.form.ID.disabled = !this.checked;
			if (this.form.ID.disabled)
				this.form.ID.className = "Disabled";
			else
				this.form.ID.className = "Text";
		});
	}
	else if (_page == 'link_category_edit')
	{
		var linkCategory = new LinkCategory();
		
		_uploader.Init({WebPath:_webPath});
		_uploader.Add("Picture", "PictureTextbox", "PictureBrowse");
		
		$('form:first').submit(linkCategory.modify);
		
		$("#GuidCheckBox").click(function()
		{
			this.form.ID.disabled = !this.checked;
			if (this.form.ID.disabled)
				this.form.ID.className = "Disabled";
			else
				this.form.ID.className = "Text";
		});
	}
	else if (_page == 'link_category_list')
	{
		var linkCategory = new LinkCategory();	

		MakeButton();
			
		var list = $('#List');
		
		list.on('submit', 'form', function()
		{
		   var id = $(this).parent().attr("ItemID");
		   linkCategory.modifyName(this, id);
		   return false;
		});
		
  		list.on('mouseover', '[sort]', function(){this.className += ' Move_MouseOver';});
		list.on('mouseout', '[sort]', function(){this.className='Move';});
		
		list.on('click', 'td:last-child a', function()
		{
			var id = $(this).closest('tr').attr('ItemID');
			Confirm(_lang_confirm_delete, function(returnValue){linkCategory.update('Delete',id);}, this);
			return false;
		});
		
		InitMove(null, 'Move', null, linkCategory.move);
		
		$('#IsDisplay,#IsRecommended,#IsHeld,#Sort').change(Search);
		$('form').submit(linkCategory.modifyName);
		$('body').on('click', '#Display,#UnDisplay,#Recommend,#UnRecommend,#Hold,#UnHold', linkCategory.update);
	}
	else if (_page == 'link_add')
	{
		var link = new Link();
		
		_uploader.Init({WebPath:_webPath});
		_uploader.Add('Logo', 'LogoTextbox', 'LogoBrowse');
		
		$('form:first').submit(link.add)	
	}
	else if (_page == 'link_edit')
	{
		var link = new Link();
		
		_uploader.Init({WebPath:_webPath});
		_uploader.Add('Logo', 'LogoTextbox', 'LogoBrowse');
		
		$('form:first').submit(link.modify);
	}
	else if (_page == 'link_list')
	{	
		var link = new Link();

		var list = $('#List');

		MakeButton();
		
		$('form').submit(link.modifyName);
		$('#IsChecked,#CategoryID,#Sort').change(Search);
		$('#IncludeSubCategory').click(Search);
		$('#Search').click(function(){Search(1);});
		$('#SelectAll').click(function(){$(':checkbox[name=Sel]').each(function(){this.checked = true;});});
		$('#ReverseSelect').click(function(){$(':checkbox[name=Sel]').each(function(){this.checked = !this.checked;});});
		$('body').on('click', '#Delete,#Check,#UnCheck', link.update);
		
		list.on('submit', 'form', function()
		{
			var id = $(this).closest('tr').attr('ItemID');
			link.modifyName(this, id);
			return false;
		});
		
		list.on('moseover', '[sort]', function(){this.className += 'Move_Mouseover';});
		list.on('mouseout', '[sort]', function(){this.claseName='move';});
		
		InitMove(null,'Move', null, link.move);
	}
	else if (_page == 'language_add')
	{
		var language = new Language();
		
		$('form:first').submit(language.add);
		$('[name=Candidate]').change(language.onCandidateChange);
	}
	else if (_page == 'language_edit')
	{
		var language = new Language();
		
		$('form:first').submit(language.modify);
	}
	else if (_page == 'language_list')
	{
		var language = new Language();
		
		$('table').on('click', ':button', function()
		{
			var id = $(this).closest('tr').attr('id');
			if (this.tagName == 'INPUT')
				Confirm(_lang_confirm_delete, function(){language.update('Delete', id);}, this);
			else 
				Confirm(_lang_confirm_delete, function(){language.update('Delete',id);}, this);
		});
	}
	else if (_page =='instance_add')
	{
		var instance = new Instance();
		
		$('form:first').submit(instance.add)
	}
	else if (_page =='instance_edit')
	{
		var instance = new Instance();
		
		$('form:first').submit(instance.modify);
	}
	else if (_page == 'instance_list')
	{	
		var instance = new Instance();
		
		var list = $('#List');
			
		list.on('submit', 'form' , instance.modifyName);
		
		list.on('moseover','[sort]',function(){this.className += 'Move_Mouseover';});
		list.on('mouseout','[sort]',function(){this.claseName='move';});
				
		list.on('click', 'td:last-child a', function()
		{
			var id = $(this).closest('tr').attr('ItemID');
		    Confirm(_lang_confirm_delete, function(returnValue){if (returnValue)instance.del(id);}, this);
		    return false;
		});
		  		
		InitMove(null,'Move', null, instance.move);
	}
	else if(_page =='menu_add')
	{
		//创建实例
		var menu = new Menu();
		
		//绑定事件
		$('form:first').submit(menu.add);	
		$('#Bold,#Italic,#Custom').click(Style_OnChange);
		$('#Color').keyup(Style_OnChange);
		$('[name=CategoryID]').change(menu.getParentList);
		$('[name=PlayerID]').change(ParsePlayer);
		$('#PageIDCandidate').change(PageIDCandidate_OnChange);
		$('#thumbnail-select').click(menu.selectThumbnail);
		$('#file-select').click(menu.selectFile);

		$('[name=LinkType]').click(function()
		{
			if (this.value == 'Content')
			{
				$('[name=Path]').hide();
				$('#PathTip').hide();
				$('#Page').show();
				//$('#HtmlEditorTR').show();
				$('#ChannelIDSpan').show();
			}
			else if (this.value == 'InnerLink')
			{
				$('#Page').hide();
				//$('#HtmlEditorTR').hide();
				$('#ChannelIDSpan').show();
				$('#PathTip').show();
				$('[name=Path]').show();
				//$('[name=Path]').val('');
			}
			else
			{
				$('#ChannelIDSpan').hide();
				$('#PathTip').hide();
				$('#Page').hide();
				//$('#HtmlEditorTR').hide();
				$('[name=Path]').show();
				//$('[name=Path]').val('http://');
			}
		});
		
		$('#GuidCheckBox').click(function()
		{
			this.form.ID.disabled = !this.checked;
			if (this.form.ID.disabled)
				this.form.ID.className = 'Disabled';
			else
				this.form.ID.className = 'Text';
		});
		
		$('[name=Type]').change(function()
		{
			if (this.value == 'Text')
			{
				$('#thumbnail-row,#file-row').hide();
			}
			else
			{
				if (this.value == 'Audio' || this.value == 'Video' || this.value == 'Flash')
					$('[name=PlayerID]').show();
				else
					$('[name=PlayerID]').hide();
				$('#thumbnail-row,#file-row').show();
			}
		});
		
		//初始化
		_uploader.Init({WebPath:_webPath});
		_uploader.Add('Thumbnail', 'thumbnail-textbox', 'thumbnail-browse');
		_uploader.Add('File', 'file-textbox', 'file-browse');
		
		if (GetCookie('LinkType') != '')
			$('[name=LinkType][value=' + GetCookie('LinkType') + ']').click();
		else
			$('[name=LinkType][value=Content]').click();
	}
	else if(_page == 'menu_edit')
	{
		var menu = new Menu();
		
		//绑定事件
		$('form:first').submit(menu.modify);
		$('#Bold,#Italic,#Custom').click(Style_OnChange);
		$('#Color').keyup(Style_OnChange);
		$('[name=CategoryID]').change(menu.getParentList);
		$('#thumbnail-select').click(menu.selectThumbnail);
		$('#file-select').click(menu.selectFile);
		$('[name=PlayerID]').change(ParsePlayer);
		$('#PageIDCandidate').change(PageIDCandidate_OnChange);
		
		$('#GuidCheckBox').click(function()
		{
			this.form.ID.disabled = !this.checked;
			if (this.form.ID.disabled)
				this.form.ID.className = 'Disabled';
			else
				this.form.ID.className = 'Text';
		});

		$('[name=LinkType]').click(function()
		{
			if (this.value == 'Content')
			{
				$('[name=Path]').hide();
				$('#PathTip').hide();
				$('#Page').show();
				//$('#HtmlEditorTR').show();
				$('#ChannelIDSpan').show();
			}
			else if (this.value == 'InnerLink')
			{
				$('#Page').hide();
				//$('#HtmlEditorTR').hide();
				$('#ChannelIDSpan').show();
				$('#PathTip').show();
				$('[name=Path]').show();
				//$('[name=Path]').val('');
			}
			else
			{
				$('#ChannelIDSpan').hide();
				$('#PathTip').hide();
				$('#Page').hide();
				//$('#HtmlEditorTR').hide();
				$('[name=Path]').show();
				//$('[name=Path]').val('http://');
			}
		});
		
		_uploader.Init({WebPath:_webPath});
		_uploader.Add('Thumbnail', 'thumbnail-textbox', 'thumbnail-browse');
		_uploader.Add('File', 'file-textbox', 'file-browse');
		
		$('[name=Type]').change(function()
		{
			if (this.value == 'Text')
			{
				$('#thumbnail-row,#file-row').hide();
			}
			else
			{
				if (this.value == 'Audio' || this.value == 'Video' || this.value == 'Flash')
					$('[name=PlayerID]').show();
				else
					$('[name=PlayerID]').hide();
				$('#thumbnail-row,#file-row').show();
			}
		});
		
		//初始化数据
		//menu.getParentList();
		$('[name=Target]').val(_target);
		$('[name=PageGenerate][value="' + _pageGenerate + '"]')[0].checked = true;
		$('[name=LinkType][value=' + _linkType + ']').click();
		$('[name=Type]').val(_type).change();

		if (_style.indexOf(' style="') != -1)
		{
		    _style = _style.substr(8, _style.length - 9);
		    var props = _style.split(';');
		    for (var i = 0; i < props.length; i++)
		    {
		        if (props[i] != 'font-weight:bold' && props[i] != 'font-style:italic' && props[i].indexOf('color:') != 0)
		        {
    		        $('#Custom')[0].checked = true;
    		        $('[name=CustomStyle]').show();
		        }
		        
		        if (props[i] == 'font-weight:bold')
		            $('#Bold')[0].checked = true;
		            
		        if (props[i] == 'font-style:italic')
		            $('#Italic')[0].checked = true;
		            
		        if (props[i].indexOf('color:') == 0)
		            $('#Color').val(props[i].substr(6));
		    }
		    $('[name=CustomStyle]').val(_style);
		}
	}
	else if(_page == 'menu_list')
	{
		var menu = new Menu();

		var list = $('#List');
		list.on('submit', 'form', menu.modifyName);
		
		$('[sort]').mouseover(function(){this.className += ' Move_MouseOver';}).mouseout(function(){this.className='Move';});
		InitMove(null, 'Move', null, menu.move);		
		
  		list.on('click', 'td:last-child a', function()
		{
			var id = $(this).closest('tr').attr('ItemID');	
   			Confirm(_lang_confirm_delete, function(returnValue){if (returnValue)menu.del(id);}, this);	
			return false;				
		});
		
		$("#CategoryID").change(Search);
	}
	else if (_page == 'menu_category_add')
	{
		var menuCategory = new MenuCategory();
		
		$('form:first').submit(menuCategory.add);
		
		$('#GuidCheckBox').click(function()
		{
			this.form.ID.disabled = !this.checked;
			if (this.form.ID.disabled)
				this.form.ID.className = "Disabled";
			else
				this.form.ID.className = "Text";
		});
	}
	else if (_page =='menu_category_edit')
	{
		var menuCategory = new MenuCategory();

		$('form:first').submit(menuCategory.modify);
		
		$('#GuidCheckBox').click(function()
		{
			this.form.ID.disabled = !this.checked;
			if (this.form.ID.disabled)
				this.form.ID.className = "Disabled";
			else
				this.form.ID.className = "Text";
		});
	}
	else if (_page =='menu_category_list')
	{
		var menuCategory = new MenuCategory();
		
		var list = $('#List');

		InitMove(null, 'Move', null, menuCategory.move);

		$('#IsDisplay,#IsRecommended,#IsHeld,#Sort').change(Search);
		
		list.on('submit', 'form',  menuCategory.modifyName);
		
		$('[sort]').mouseover(function(){this.className += ' Move_MouseOver';}).mouseout(function(){this.className='Move';});

		list.on('click', 'td:last-child a', function()
		{
			var id = $(this).closest('tr').attr('ItemID');
			Confirm(_lang_confirm_delete, function(returnValue){if (returnValue)menuCategory.del(id);}, this);
			return false;
		});		  	
	}
	else if(_page == 'module_dictionary_add')
	{
		var moduleDictionary = new ModuleDictionary();
		
		$('form:first').submit(moduleDictionary.add);
	}
	else if(_page == 'module_dictionary_list')
	{
		var moduleDictionary = new ModuleDictionary();
		
		$('#List').on('click', ':image', moduleDictionary.modify)
				.on('click', 'td:last-child a', moduleDictionary.del);
	}
	else if(_page =='module_object_operation_add')
	{
		var moduleObjectOperation = new ModuleObjectOperation();
		
		$('form:first').submit(moduleObjectOperation.add);
		
		$('#GuidCheckBox').click(function()
		{
			this.form.ID.disabled = !this.checked;
			if (this.form.ID.disabled)
				this.form.ID.className = "Disabled";
			else
				this.form.ID.className = "Text";
		});
	}
	else if(_page =='module_object_operation_edit')
	{
		var moduleObjectOperation = new ModuleObjectOperation();
		
		$('form:first').submit(moduleObjectOperation.modify);
	}
	else if(_page =='module_object_operation_list')
	{
		var moduleObjectOperation = new ModuleObjectOperation();
		var list = $('#List');
		
		list.on('submit', 'form' , function()
		{
			var id = $(this).closest('tr').data('id');
			moduleObjectOperation.modifyName(this, id);
			return false;
		});
		 
		list.on('moseover','[sort]',function(){this.className += 'Move_Mouseover';});
		list.on('mouseout','[sort]',function(){this.claseName='move';});
		 
		list.on('click','td:last-child a',function()
		{
			var id = $(this).closest('tr').data('id');
		   Confirm(_lang_confirm_delete, function(returnValue){moduleObjectOperation.update('Delete',id);}, this);
		   return false;
		});	
		
		InitMove(null,'Move', null, moduleObjectOperation.move);	
	 
	}
	else if(_page =='module_object_property_add')
	{
		var moduleObjectProperty = new ModuleObjectProperty();
		
		$('form:first').submit(moduleObjectProperty.add);
		$('[name=SqlDbType]').change(moduleObjectProperty.onSqlDbTypeChange);
		$('[name=MainTableID]').change(moduleObjectProperty.onMainTableIDChange);
		
		$('#GuidCheckBox').click(function()
		{
			this.form.ID.disabled = !this.checked;
			if (this.form.ID.disabled)
				this.form.ID.className = 'Disabled';
			else
				this.form.ID.className = 'Text';
		});
	}
	else if(_page =='module_object_property_edit')
	{
		var moduleObjectProperty = new ModuleObjectProperty();
		
		//事件绑定
		$('form:first').submit(moduleObjectProperty.modify);
		$('[name=SqlDbType]').change(moduleObjectProperty.onSqlDbTypeChange);
		$('[name=MainTableID]').change(moduleObjectProperty.onMainTableIDChange);
		
		//初始化数据
		$('[name=MainTableID]').change();
		$('[name=SqlDbType]').val(_sqlDbType);
		$('[name=OleDbType]').val(_oleDbType);
	}
	else if(_page == 'module_object_property_list')
	{
		var moduleObjectProperty = new ModuleObjectProperty();
		
		var list = $('#List');
		
		list.on('submit', 'form' , function()
		{
			var id = $(this).closest('tr').attr('ItemID');
			moduleObjectProperty.modifyName(this, id);
			return false;
		});
		 
		list.on('moseover','[sort]',function(){this.className += 'Move_Mouseover';});
		list.on('mouseout','[sort]',function(){this.claseName='move';});
		 
		list.on('click','td:last-child a',function()
		{
			var id = $(this).closest('tr').attr('ItemID');
		   Confirm(_lang_confirm_delete, function(returnValue){moduleObjectProperty.update('Delete',id);}, this);
		   return false;
		});	
		
		InitMove(null,'Move', null, moduleObjectProperty.move);	
	}
	else if(_page == 'module_object_add')
	{
		var moduleObject = new ModuleObject();
		
		$('form:first').submit(moduleObject.add);
		
		$('#GuidCheckBox').click(function()
		{
			this.form.ID.disabled = !this.checked;
			if (this.form.ID.disabled)
				this.form.ID.className = 'Disabled';
			else
				this.form.ID.className = 'Text';
		});
	}
	else if(_page =='module_object_edit')
	{
		var moduleObject = new ModuleObject();
		
		$('form:first').submit(moduleObject.modify);
	}
	else if(_page == 'module_object_list')
	{
		var moduleObject = new ModuleObject();
		
		var list = $('#List');
		
		list.on('submit', 'form' , function()
		{
			var id = $(this).closest('tr').attr('ItemID');
			moduleObject.modifyName(this, id);
			return false;
		});
		 
		list.on('moseover','[sort]',function(){this.className += 'Move_Mouseover';});
		list.on('mouseout','[sort]',function(){this.claseName='move';});
		 
		list.on('click','td:last-child a',function()
		{
			var id = $(this).closest('tr').attr('ItemID');
			Confirm(_lang_confirm_delete, function(returnValue){moduleObject.update('Delete',id);}, this);
			return false;
		});	
		
		InitMove(null,'Move', null, moduleObject.move);	
	}
	else if(_page =='module_add')
	{
		var module = new Module();
		
		$('form:first').submit(module.add);
		
		$('#GuidCheckBox').click(function()
		{
			this.form.ID.disabled = !this.checked;
			if (this.form.ID.disabled)
				this.form.ID.className = "Disabled";
			else
				this.form.ID.className = "Text";
		});
	}
	else if(_page =='module_edit')
	{
		var module = new Module();
		
		$('form:first').submit(module.modify);
	}
	else if(_page =='module_list')
	{
	   var module = new Module();
		
	   var list = $('#List');
		
	   list.on('click', 'td:last-child a', function()
	   {
	  		var id = $(this).closest('tr').data('id');
	  	 	Confirm(_lang_confirm_delete, function(returnValue){if (returnValue)module.del(id);}, this);
	   		return false;
	   });
	   
   		$('#BuildAlias').click(module.buildAlias);

        _uploader.Init({WebPath: _webPath, NameBySystem:false, Overwrite:false});
        _uploader.Add('File', 'FileTextbox', 'FileBrowse');

        $('#install').submit(module.installModule);
	}
	else if(_page =='online_service_add')
	{
		var onlineService = new OnlineService();
	
		$('form:first').submit(onlineService.add);
	}
	else if(_page =='online_service_edit')
	{
		var onlineService = new OnlineService();
		
		$('form:first').submit(onlineService.modify);
	}
	else if(_page =='online_service_list')
	{
		var onlineService = new OnlineService();
		
		var list = $('#List');
		
		InitMove(null, 'Move', null, onlineService.move);
		
		$('#Sort').change(Search);
  		$('[sort]').mouseover(function(){this.className += ' Move_MouseOver';}).mouseout(function(){this.className='Move';});
		$('#Search').click(function(){Search(1);});
		list.on('click', 'td:last-child a', function()
  		{
 	 	 	var id = $(this).closest('tr').attr('ItemID');
   			Confirm(_lang_confirm_delete, function(returnValue){if (returnValue)onlineService.del(id);}, this);
  			return false;
 		});
	}
	else if (_page == 'payment_add')
	{
		var payment = new Payment();

		_uploader.Init({WebPath:_webPath});
		_uploader.Add('Logo', 'LogoTextbox', 'LogoBrowse');
		
		$('form:first').submit(payment.add);
		$('[name=Type]').change(payment.onTypeChange);
	}
	else if (_page == 'payment_edit')
	{
		var payment = new Payment();

		//上传绑定
		_uploader.Init({WebPath:_webPath});
		_uploader.Add('Logo', 'LogoTextbox', 'LogoBrowse');
		
		//事件绑定
		$('form:first').submit(payment.modify);
		$('[name=Type]').change(payment.onTypeChange);
		
		//初始化
		payment.onEditInit();
	}
	else if (_page == 'payment_list')
	{
		var payment = new Payment();

		$('#List').on('click', 'td:last-child a', function()
		{
			var id = $(this).closest('tr').attr('id');
			Confirm(_lang_confirm_delete, function(returnValue){if (returnValue)payment.del(id);}, this);
			return false;
		});
	}
	else if(_page =='player_add')
	{
		var player = new Player();
		
		$('form:first').submit(player.add);
		
		_uploader.Init({WebPath:_webPath});
		_uploader.Add('File', 'FileTextbox', 'FileBrowse');
	}
	else if(_page =='player_edit')
	{
		var player = new Player();
		
		$('form:first').submit(player.modify);
						
		_uploader.Init({WebPath:_webPath});
		_uploader.Add('File', 'FileTextbox', 'FileBrowse');
	}
	else if(_page =='player_list')
	{
		var player = new Player();
		var list = $('#List');
		
 		$('#Sort').change(Search);
		$('[sort]').mouseover(function(){this.className += ' Move_MouseOver';}).mouseout(function(){this.className='Move';});
	
	  	list.on('click', 'td:last-child a', function()
	    {
  			var id = $(this).closest('tr').attr('ItemID');
   			Confirm(_lang_confirm_delete, function(returnValue){if (returnValue)player.del(id);}, this);
   			return false;
 	    });
		
		InitMove(null, 'Move', null, player.move);
	}
	else if(_page =='role_add')
	{
		var role = new Role();
		
		$('form:first').submit(role.add);
	}
	else if(_page =='role_edit')
	{
		var role = new Role();
		
		$('form:first').submit(role.modify);
	}
	else if(_page =='role_list')
	{
		var role = new Role();
		var list = $('#List');
		
	  	list.on('click', 'td:last-child a', function()
	    {
  			var id = $(this).closest('tr').attr('ID');
   			Confirm(_lang_confirm_delete, function(returnValue){if (returnValue)role.del(id);}, this);
   			return false;
 	    });
	}
	else if(_page =='privilege')
	{
		var list = $('#List');

		list.on('click', '[name=ObjectID]', function()
		{$(this.parentNode.parentNode.cells[1]).find(':checkbox').attr('checked', this.checked);});

	    $('#Save').click(SavePrivilege);
	    $('#RoleID,#InstanceID,#CurrentLang').change(Search);
	    $('#CheckAll').click(function(){$('[name=OperationID]').attr('checked', true);});
	}
	else if (_page =='skin_css_add')
	{
		var skinCss = new SkinCss();
		
		$('form:first').submit(skinCss.add)
	}
	else if(_page =='skin_css_edit')
	{
		var skinCss = new SkinCss();
		
		$('form:first').submit(skinCss.modify)
	}
	else if(_page =='skin_css_list')
	{
		var skinCss = new SkinCss();
		var list = $('#List');
		
	  	list.on('click', 'td:last-child a', function()
	    {
  			var id = $(this).closest('tr').data('id');
   			Confirm(_lang_confirm_delete, function(returnValue){if (returnValue)skinCss.del(id);}, this);
   			return false;
 	    });
	}
	else if(_page =='skin_image_add')
	{
		var skinImage = new SkinImage();
		
		_uploader.Init({WebPath:_webPath,NameBySystem:false,Overwrite:false});
		_uploader.Add('File', 'FileTextbox', 'FileBrowse');

		$('form:first').submit(UploadSkinImage);
		$('#FolderName').keydown(function(e){if(e.keyCode == 13){SkinImage_AddFolder();e.preventDefault();}});
		$('#AddFolder').click(SkinImage_AddFolder);
		$('#FileTextbox').change(function(){$('#Thumbnail').attr('src', this.value)});
	}
	else if(_page =='skin_image_list')
	{
		var list = $('#List');

		list.delegate('td:last-child a', 'click', function()
		{
			var id = $(this).closest('tr').attr('id');
			Confirm(_lang_confirm_delete, function(returnValue){if (returnValue)DeleteFile(id);}, this);
			return false;
		});

	    $('#Folder').change(Folder_OnChange);
	    $('#DeleteFolder').click(function()
	    {
			Confirm(_lang_confirm_delete, function(returnValue){if (returnValue)DeleteFolder();}, this);
	    });
	}
	else if(_page == 'skin_add')
	{
		var skin = new Skin();
		
	    _xmlLanguage = CreateXmlDom();
	    _xmlSkin = CreateXmlDom();

	    Skin_GetLanguageList();

		$('form:first').submit(skin.add);
		$('[name=TemplatePath]').change(Skin_TemplatePath_OnChange);
		$('[name=SkinPath]').change(Skin_SkinPath_OnChange);
	}
	else if(_page =='skin_edit')
	{
		var skin = new Skin();
		
		$('form:first').submit(skin.modify);
	}
	else if(_page =='skin_list')
	{
		var list = $('#List');
		
	  	list.on('click', 'dd:last-child a', function()
	    {
  			var id = $(this).closest('dl').attr('id');
			var index = $(this).parent().children().index(this);
			if (index == 0)
				window.open(HandleFake404('translate.aspx?Lang=' + _lang + '&Path=' + id, 'url'), '', 'top=200,left=200,width=500,height=400,menubar=0,toolbar=0,scrollbars=yes');
			else
   				Confirm(_lang_confirm_delete, function(returnValue){skinCss.del(id);}, this);
   			return false;
 	    });
	}
	else if(_page =='skin_picture')
	{
		_uploader.Init({WebPath:_webPath});
		_uploader.Add('File', 'FileTextbox', 'FileBrowse');
	
		$('form:first').submit(UploadSkinPicture)
		$('#FileTextbox').change(function(){$('#Picture').attr('src', this.value)});
	}
	else if(_page =='skin_thumbnail')
	{
		_uploader.Init({WebPath:_webPath});
		_uploader.Add('File', 'FileTextbox', 'FileBrowse');

		$('form:first').submit(UploadSkinThumbnail);
		$('#FileTextbox').change(function(){$('#Thumbnail').attr('src', this.value)});
	}
	else if(_page == 'skin_translate')
	{
	    var i = 0;
	    $('option').each(function()
	    {
	        if (_path.indexOf("/" + this.value + "/") != -1)
	        {
	            $('#SourceLanguage').html(this.text);
	            this.parentNode.remove(i);
	            return;
	        }
	        i++;
	    });
	    
	    $('#Start').click(TranslateSkin);
	}
	else if(_page =='template_add')
	{
		var template = new Template();
		
		$('form:first').submit(template.add);
	}
	else if(_page =='template_edit')
	{
		var template = new Template();
		
		$('form:first').submit(template.modify);
	}
	else if(_page =='template_list')
	{
		var list = $("#List");

		list.on('click', 'td:nth-child(8) a', function()
		{
			var id = $(this).closest("tr").attr("id");
			
			var index = $(this).parent().children().index(this);
			if (index == 0)
				return EncryptTemplate(id);
			else
				return DecryptTemplate(id);
		});

		list.on('click', 'td:nth-child(9) a', function()
		{
			var id = $(this).closest("tr").attr("id");
			return ClearTemplateCache(id);
		});

		list.on('click', 'td:last-child a', function()
		{
			var id = $(this).closest('tr').attr('id');
			Confirm(_lang_confirm_delete, function(returnValue){template.del(id);}, this);
			return false;
		});

        _uploader.Init({ WebPath: _webPath, NameBySystem: false, Overwrite: false });
        _uploader.Add('File', 'FileTextbox', 'FileBrowse');

        $('#install').submit(InstallTemplate);
	}
	else if(_page == 'template_dictionary_list')
	{	
		var templateDictionary= new TemplateDictionary();
		var list = $('#List');

		list.on('click', ':image', function()
		{
			templateDictionary.modify($(this).closest('tr'));
			return false;
		});
		
		list.on('click', 'td:last-child a', function()
		{
			var id = $(this).closest('tr').attr('id');
			Confirm(_lang_confirm_delete, function(returnValue){templateDictionary.del(id);}, this);
			return false;
		});

		$('form:first').submit(templateDictionary.add);
		$('[name=TargetLanguageAb]').change(TargetLanguageAb_OnChange);
		$('#GetChineseString').click(GetChineseString);
	}
	else if(_page =='template_module_list')
	{	
		var templateModule = new TemplateModule();
		var list = $('#List');

		list.on('click', 'td:last-child a', function()
		{
			var id = $(this).closest('tr').attr('id');
			Confirm(_lang_confirm_delete, function(returnValue){templateModule.del(id);}, this);
			return false;
		});

		$('form:first').submit(templateModule.add);
	}
	else if(_page =='template_menu_add')
	{
		var templateMenu = new TemplateMenu();
		
	    _xmlDoc = CreateXmlDom();
		
		TemplateMenu_GetPageList('loading');

		$('#Namespace').change(function()
		{
			SetCookie('Namespace', $('#Namespace').val(), 10*360*24*60);
			
			TemplateMenu_GetPageList();
		});
		$('form:first').submit(templateMenu.add);
		$('#ObjectID').change(TemplateMenu_ObjectID_OnChange);
		$("#TargetCandidate").change(function(){this.form.Target.value=this.value;});
	}
	else if(_page =='template_menu_edit')
	{	
		var templateMenu = new TemplateMenu();
		
	    _xmlDoc = CreateXmlDom();
	    TemplateMenu_GetPageList('loading');
	
		$('#Namespace').change(TemplateMenu_GetPageList);
		$('form:first').submit(templateMenu.modify);
		$('#ObjectID').change(TemplateMenu_ObjectID_OnChange);
		$('#TargetCandidate').change(function(){this.form.Target.value=this.value;});
	}
	else if(_page =='template_menu_list')
	{
		Search();
		
		var templateMenu = new TemplateMenu();
		var list = $('#List');

		$('form').submit(templateMenu.modifyName);
		  		
		list.on('moseover','[sort]', function(){this.className += ' Move_MouseOver';});
		list.on('mouseout','[sort]', function(){this.className='Move';});
		
		list.on('click', 'td:last-child a', function()
		{
			var id = $(this).closest('tr').attr('ItemID');
			Confirm(_lang_confirm_delete, function(returnValue){templateMenu.del(id);}, this);
			return false;
		});
		
		$('#Namespace').change(Search);

		InitMove(null,'Move', null, templateMenu.move);
	}
	else if(_page =='template_page_add')
	{	
		var templatePage = new TemplatePage();
		
		$('form:first').submit(templatePage.add);
		$('#FolderName').keydown(function(e){if(e.keyCode == 13){TemplatePage_AddFolder();e.preventDefault();}});
		$('#AddFolder').click(TemplatePage_AddFolder);
		$('#DeleteFolder').click(TemplatePage_DeleteFolder);
	}
	else if(_page =='template_page_edit')
	{
		var templatePage = new TemplatePage();
		
		$('form:first').submit(templatePage.modify);
	}
	else if(_page =='template_page_list')
	{
		var templatePage = new TemplatePage();
		var list = $('#List');

		list.on('click', 'td:last-child a', function()
		{
			var id = $(this).closest('tr').attr('id');
			Confirm(_lang_confirm_delete, function(returnValue){if (returnValue)templatePage.del(id);}, this);
			return false;
		});
	}
	else if(_page =='template_script_add')
	{	
		var templateScript = new TemplateScript()
		
		$('form:first').submit(templateScript.add);
	}
	else if(_page =='template_script_edit')
	{
		var templateScript = new TemplateScript()
		
		$('form:first').submit(templateScript.modify);
	}
	else if(_page =='template_script_list')
	{
		var templateScript = new TemplateScript();
		var list = $('#List');

		list.on('click', 'td:last-child a', function()
		{
			var id = $(this).closest('tr').attr('id');
			Confirm(_lang_confirm_delete, function(returnValue){if (returnValue)templateScript.del(id);}, this);
			return false;
		});
	}
	else if(_page =='utility_data_list')
	{
		var list = $('#List');

		list.on('click', 'td:last-child a', function()
		{
			var id = $(this).closest('tr').attr('id');
			return RestoreDb(id);
		});

		list.on('click', 'td:last-child a', function()
		{
			var id = $(this).closest('tr').attr('id');
			Confirm(_lang_confirm_delete, function(returnValue){if (returnValue)DeleteDbBackup(id);}, this);
			return false;
		});

		$("form:first").submit(BackupDb);
		$("#CompactDb").click(CompactDb);
		$("#BackupSite").click(BackupSite);
	}
	else if(_page =='task_list')
	{
		var list = $('.ListTable');

		list.on('submit', 'form', function()
		{
			var id = $(this).closest('tr').attr('id');
			ModifyTask(this, id);
			return false;
		});
		
		list.on('click', 'td:last-child a', function()
		{
			var id = $(this).closest('tr').attr('id');
			Confirm(_lang_confirm_delete, function(returnValue){if (returnValue)DeleteTask(id);}, this);
			return false;
		});
	}
	else if(_page =='utility_other')
	{
		$('#ClearCache').click(ClearCache);
		$('#UpdateTemplateCache').click(UpdateTemplateCache);
		$('#InitSystem').click(InitSystem);
		$('#ReplaceEotRootString').click(ReplaceEotRootString);
	}
	else if(_page =='config_basic')
	{
		_uploader.Init({WebPath:_webPath});
		_uploader.Add('Logo', 'LogoTextbox', 'LogoBrowse');
        _uploader.Add('Link', 'LinkTextbox', 'LinkBrowse');
		
		$('form:first').submit(SetBasicSettings);
		$('#LogoTextbox').change(function(){$('#LogoView').attr('src', this.value)});
		$('#LinkTextbox').change(function(){$('#LinkView').attr('src', this.value)});
	}
	else if(_page =='config_email')
	{
	    CheckAndSelect($('[name=Tool]')[0], _tool);
	
		$('form:first').submit(SetEmailSettings);
	}
	else if(_page ==='config_global')
	{
	    CheckAndSelect($('[name=DatabaseProvider]')[0], _databaseProvider);
	
		$('form:first').submit(SetGlobalSettings);
	}
	else if(_page =='config_rewrite')
	{
		var list = $('#List');

		list.on('click', 'td:last-child a', function()
		{
			var id = $(this).closest('tr').attr('id');
			Confirm(_lang_confirm_delete, function(returnValue){if (returnValue)DeleteRewrite(id);}, this);
			return false;
		});
		
		$('tbody tr').each(function()
		{
			var id = $(this).attr('id');
			
			var cell = $(this.cells[3]);
			var option = $('[name=InstanceID] [value=' + cell.attr('InstanceID') + ']');
			if (option.length == 0)
			    cell.html('');
			else
			    cell.html(option.text());
		});
	
		$('form:first').submit(AddRewrite);
		
		$('[name=InstanceID]').change(function()
		{
		    var form = this.form;
	        form.ObjectFullName.length = 0;
	        if (form.InstanceID.value == '')
	        {
		        form.ObjectFullName.options.add(new Option('--未指定--'), '');
	        }
	        else
	        {
	            SetStatusMessage(_lang_working);

	            $.ajax(
	            {
		            url : _webPath + 'alicms.aspx?Lang=' + _lang + '&Object=Module.Object&Operation=List&Condition=' + encodeURIComponent(AliCMS.SystemModule.Module_Object.ModuleID + ':' + $('[name=InstanceID] option:selected').attr('ModuleID')),
		            type : 'GET',
		            error : function(request)
		            {
			            Alert(_lang_operation_fail);
			            SetStatusMessage();
			            $(":submit")[0].disabled = false;
		            },
		            success : function(data)
		            {
			            var objectSelect = document.forms[0].ObjectFullName;
			            var xmlDoc = CreateXmlDom();
			            xmlDoc.loadXML(data);
			            BuildTreeOptions(xmlDoc, AliCMS.SystemModule.Module_Object.ParentID, AliCMS.SystemModule.Module_Object.ID, AliCMS.SystemModule.Module_Object.Name, objectSelect);
            			
			            for (var i = 0; i < objectSelect.options.length; i++)
			            {
				            var id = objectSelect.options[i].value;
				            if (id == '')
					            continue;
            				
				            var name = '';
				            var itemNode = null;
				            var nodes = xmlDoc.selectNodes('//' + AliCMS.SystemModule.Module_Object.ID);
				            for (var j = 0; j < nodes.length; j++)
				            {
					            var node = nodes[j];
					            if (node.text == id)
					            {
						            itemNode = node.parentNode;
						            break;
					            }
				            }

				            var parentID = itemNode.selectSingleNode(AliCMS.SystemModule.Module_Object.ParentID).text;
				            while (parentID != g_empty)
				            {
					            if (name == '')
						            name = itemNode.selectSingleNode(AliCMS.SystemModule.Module_Object.Name).text;
					            else
						            name = itemNode.selectSingleNode(AliCMS.SystemModule.Module_Object.Name).text + '.' + name;
            					
					            nodes = xmlDoc.selectNodes('//' + AliCMS.SystemModule.Module_Object.ID);
					            for (var j = 0; j < nodes.length; j++)
					            {
						            var node = nodes[j];
						            if (node.text == parentID)
						            {
							            itemNode = node.parentNode;
							            break;
						            }
					            }
					            parentID = itemNode.selectSingleNode(AliCMS.SystemModule.Module_Object.ParentID).text;
				            }
            				
				            if (name == '')
					            name = itemNode.selectSingleNode(AliCMS.SystemModule.Module_Object.Name).text;
				            else
					            name = itemNode.selectSingleNode(AliCMS.SystemModule.Module_Object.Name).text + '.' + name;
            				
				            objectSelect.options[i].name = name;
			            }
		            
			            SetStatusMessage();
		            }
	            });
	        }
		});
	}
	else if(_page =='config_water_mark')
	{
		_uploader.Init({WebPath:_webPath});
		_uploader.Add('Image', 'ImageTextbox', 'ImageBrowse');

	    CheckAndSelect($('[name=Position]')[0], _position);
	
		$('form:first').submit(SetWaterMarkSettings);
		$('#ImageTextbox').change(function(){$('#ImageView').attr('src', this.value)});
	}
	else if(_page =='file_manager_list')
	{
		var list = $('#List');

		list.on('click', 'th a', function()
		{
		    if ($(this).closest('tr').find('td:eq(4)').text() == 'd')
		    {
				List($(this).text());
				return false;
		    }
			else
			{
				return true;
			}
		});

		list.on('click', 'td:nth-child(7) a', function()
		{
			var name = $(this).closest('tr').find('th a').text();
			Rename(name);
			return false;
		});

		list.on('click', 'td:nth-child(8) a', function()
		{
			var name = $(this).closest('tr').find('th a').text();
			Move(name);
			return false;
		});

		list.delegate('click', 'td:nth-child(9) a', function()
		{
			var name = $(this).closest('tr').find('th a').text();
			Copy(name);
			return false;
		});

		list.on('click', 'td:nth-child(10) a', function()
		{
			var name = $(this).closest('tr').find('th a').text();
			if (name.substr(name.length - 4) == ".zip")
				UnZip(name);
			else
				Zip(name);
			return false;
		});

		list.on('click', 'td:nth-child(11) a', function()
		{
			var name = $(this).closest('tr').find('th a').text();
			Confirm(_lang_confirm_delete, function(returnValue){if (returnValue)Delete(name);}, this);
			return false;
		});
		
		FileManager_CalcSize();

		_uploader.Init({WebPath:_webPath,NameBySystem:false,Overwrite:false});
		_uploader.Add('File', 'FileTextbox', 'FileBrowse');
	
		$('form:first').submit(Upload);
		$('#Folder').keydown(function(e){if(e.keyCode == 13){List();e.preventDefault();}});
		$('#Open').click(List);
		$('#Up').click(Up);
		$('#CreateFolder').click(CreateFolder);
	}
	else if(_page =='file_manager_select')
	{
		var list = $('#List');

		list.on('click', 'ul a', function()
		{
		    if ($(this).attr('Path') == null)
		    {
		        Search($(this).text());
		    }
		    else
		    {
		        if (_type == 'Editor')
					window.opener.CKEDITOR.tools.callFunction(_ckeditorFuncNum, $(this).attr('Path'));
	            else if (g_browser == 'IE')
		            window.dialogArguments.SelectFile(_type, $(this).attr('Path'));
	            else
		            window.opener.SelectFile(_type, $(this).attr("Path"));
	            window.close();
		    }
		    return false;
		});

		list.on('click', 'th a', function ()
		{
		    if ($(this).attr('Path') == null)
		    {
				Search($(this).text());
		    }
			else
			{
				if (_type == 'Editor')
					window.opener.CKEDITOR.tools.callFunction(_ckeditorFuncNum, $(this).attr('Path'));
				else if (g_browser == 'IE')
					window.dialogArguments.SelectFile(_type, $(this).attr('Path'));
				else
					window.opener.SelectFile(_type, $(this).attr('Path'));
				window.close();
			}
			return false;
		});


        list.on('click', 'td:nth-child(7) a', function ()
		{
			var name = $(this).closest('tr').find('th a').text();
			Select_Rename(name);
			return false;
		});


        list.on('click', 'td:nth-child(8) a', function ()
		{
			var name = $(this).closest('tr').find('th a').text();
			Select_Move(name);
			return false;
		});


        list.on('click', 'td:nth-child(9) a', function ()
		{
			var name = $(this).closest('tr').find('th a').text();
			Select_Copy(name);
			return false;
		});


        list.on('click', 'td:nth-child(10) a', function ()
		{
			var name = $(this).closest('tr').find('th a').text();
			if (name.substr(name.length - 4) == '.zip')
				Select_UnZip(name);
			else
				Select_Zip(name);
			return false;
		});


        list.on('click', 'td:nth-child(11) a', function ()
		{
			var name = $(this).closest('tr').find('th a').text();
			Confirm(_lang_confirm_delete, function(returnValue){if (returnValue)Select_Delete(name);}, this);
			return false;
		});

	    var referrer = null;
	    if (window.opener != null)
	        referrer = window.opener.location.href;
	    else
	        referrer = window.dialogArguments.location.href;
	    if (referrer.indexOf(document.domain) == -1)
	        window.close();
        if (_root == '')
	        window.close();
        if (_root.charAt(_root.length - 1) != '/')
	        _root += '/';
		
		_uploader.Init({WebPath:_webPath,NameBySystem:false,Overwrite:false});
		_uploader.Add('File', 'FileTextbox', 'FileBrowse');

	    $('html').bind('contextmenu', function(){return false;});
		$('form:first').submit(Select_Upload);
		$('#Folder').keydown(function(e){if(e.keyCode == 13){Search();e.preventDefault();}});
		$('#Open').click(Search);
		$('#Up').click(Select_Up);
		$('#CreateFolder').click(Select_CreateFolder);
		
		$('#ListByPicture').click(function()
		{
			SetCookie('ListByPicture', $('#ListByPicture')[0].checked, 10*360*24*60);
			Search();
		});
	}
	else if(_page == 'channel_add')
	{	
		var channel = new Channel();

        _xmlChannel = CreateXmlDom();
        _xmlTemplate = CreateXmlDom();
        _xmlSkin = CreateXmlDom();
        
        channel.getTemplateList();
        
        if (_lang == 'UYG')
        {
	        var option = document.createElement('OPTION');
	        option.text = _lang_uyl;
	        option.value = 'UYL';
	        document.forms[0].TranslateLang.options.add(option);
        	
	        option = document.createElement('OPTION');
	        option.text = _lang_uyc;
	        option.value = 'UYC';
	        document.forms[0].TranslateLang.options.add(option);
        }
        else if (_lang == 'CHS')
        {
	        var option = document.createElement('OPTION');
	        option.text = _lang_cht;
	        option.value = 'CHT';
	        document.forms[0].TranslateLang.options.add(option);
        }
        else if (_lang == 'KGA')
        {
	        var option = document.createElement('OPTION');
	        option.text = _lang_kgc;
	        option.value = 'KGC';
	        document.forms[0].TranslateLang.options.add(option);
        }
		
		$('form:first').submit(channel.add);
		$('[name=Type]').click(channel.onTypeClick);
		$('[name=TemplatePath]').change(channel.onTemplatePathChange);
		$('[name=SkinPath]').change(channel.onSkinPathChange);
		$('[name=TranslateLang]').change(channel.onTranslateLangChange);
		$('[name=InstanceID]').change(channel.onInstanceIDChange);
		$('#Match').click(channel.onMatchClick);
		$('#GenerateYes').click(function(){this.form.Extension.value='.htm';});
		$('#GenerateNo').click(function(){this.form.Extension.value='.aspx';});
		$('#LogoTextbox').change(function(){$('#LogoView').attr('src', this.value)});
		$('#LinkTextbox').change(function(){$('#LinkView').attr('src', this.value)});
		
		$('[name=IsDynamicTemplate]').click(function()
		{
			if ($('#IsDynamicTemplateYes')[0].checked)
				$(this).siblings('ol').show();
			else
				$(this).siblings('ol').hide();
		});
		
		$('[name=EnableMenu]').click(function()
		{
			if (this.value == 'true')
				$(this).closest('tr').next().show().next().show().next().show().next().show();
			else
				$(this).closest('tr').next().hide().next().hide().next().hide().next().show();
		});
		
		_uploader.Init({WebPath:_webPath});
		_uploader.Add('Logo', 'LogoTextbox', 'LogoBrowse');
		_uploader.Add('Link', 'LinkTextbox', 'LinkBrowse');
	}
	else if(_page == 'channel_edit')
	{
		var channel = new Channel();

	    $('#' + _type)[0].checked = true;
	    if (_type == 'OuterLink')
	        $('#PathTip').html(_lang_path_tip2);
	    else
	        $('#PathTip').html(_lang_path_tip1);

		$('form:first').submit(channel.modify);
		$('#GenerateYes').click(function(){this.form.Extension.value='.html';});
		$('#GenerateNo').click(function(){this.form.Extension.value='.aspx';});
		$('#LogoTextbox').change(function(){$('#LogoView').attr('src', this.value)});
		$('#LinkTextbox').change(function(){$('#LinkView').attr('src', this.value)});
		
		$('[name=IsDynamicTemplate]').click(function()
		{
			if ($('#IsDynamicTemplateYes')[0].checked)
				$(this).siblings('ol').show();
			else
				$(this).siblings('ol').hide();
		});
		$('[name=IsDynamicTemplate]:checked').click();
		
		$('[name=EnableMenu]').click(function()
		{
			if (this.value == 'true')
				$(this).closest('tr').next().show().next().show().next().show().next().show();
			else
				$(this).closest('tr').next().hide().next().hide().next().hide().next().show();
		});
		$('[name=EnableMenu]:checked').click();
		
		_uploader.Init({WebPath:_webPath});
		_uploader.Add('Logo', 'LogoTextbox', 'LogoBrowse');
		_uploader.Add('Link', 'LinkTextbox', 'LinkBrowse');
	}
	else if (_page == 'channel_list')
	{
		var channel = new Channel();
		var list = $('#List');

		list.on('mouseover', '[sort]', function(){this.className += ' Move_MouseOver';});
		list.on('mouseout', '[sort]', function(){this.className='Move';});
		
		list.on('click', 'td:last-child a', function()
		{
			var id = $(this).closest('tr').attr('ItemID');
			Confirm(_lang_confirm_delete, function(returnValue){if (returnValue)channel.del(id);}, this);
			return false;
		});
		
		InitMove(null,'Move', null, channel.move);
	}
	else if(_page == 'channel_change_template')
	{
		var channel = new Channel();

        _xmlTemplate = CreateXmlDom();
        _xmlSkin = CreateXmlDom();
        
        var form = document.forms[0];
        if (_channelLang == 'UYG')
        {
	        var option = document.createElement('OPTION');
	        option.text = _lang_uyl;
	        option.value = 'UYL';
	        form.TranslateLang.options.add(option);
        	
	        option = document.createElement('OPTION');
	        option.text = _lang_uyc;
	        option.value = 'UYC';
	        form.TranslateLang.options.add(option);
        }
        else if (_channelLang == 'CHS')
        {
	        var option = document.createElement('OPTION');
	        option.text = _lang_cht;
	        option.value = 'CHT';
	        form.TranslateLang.options.add(option);
        }
        else if (_channelLang == 'KGA')
        {
	        var option = document.createElement('OPTION');
	        option.text = _lang_kgc;
	        option.value = 'KGC';
	        form.TranslateLang.options.add(option);
        }
        
        CheckAndSelect(form.TranslateLang, _translateLang);
        if (form.TemplateLang.value == form.TranslateLang.value)
	        $('#Match')[0].checked = true;
        
        channel.getTemplateList(_moduleID);
        
		$('form').submit(channel.changeTemplate);
		$('[name=TranslateLang]').change(channel.onTranslateLangChange);
		$('[name=TemplatePath]').change(channel.onTemplatePathChange);
		$('[name=SkinPath]').change(channel.onSkinPathChange);
		$('#Match').click(channel.onMatchClick);
	}
	else if (_page == 'channel_extra_instance')
	{
		var channel = new Channel();

        _xmlChannel = CreateXmlDom();
        channel.getChannelList();
        
		$('form').submit(channel.setExtraInstance);
		$('[name=BindingInstanceID]').click(channel.onBindingInstanceChange);
	}
	else if (_page == 'channel_menu_add')
	{
		var channelMenu = new ChannelMenu();
		
		$('form:first').submit(channelMenu.add);
		$('[name=ParentID]').change(channelMenu.onParentIDChange);
		$('[name=PageType]').click(channelMenu.onPageTypeClick);
		$('#target-candidate').change(channelMenu.onTargetCandidateChange);
		$('[name=InstanceID]').change(channelMenu.onInstanceIDChange);
		$('[name=ObjectID]').change(channelMenu.onObjectIDChange);
		$('[name=TemplatePath]').change(channelMenu.onTemplatePathChange);

		channelMenu.onPageReady();
	}
	else if (_page == 'channel_menu_edit')
	{
		var channelMenu = new ChannelMenu();

		$('form:first').submit(channelMenu.modify);
		$('[name=ParentID]').change(channelMenu.onParentIDChange);
		$('[name=PageType]').click(channelMenu.onPageTypeClick);
		$('#target-candidate').change(channelMenu.onTargetCandidateChange);
		$('[name=InstanceID]').change(channelMenu.onInstanceIDChange);
		$('[name=ObjectID]').change(channelMenu.onObjectIDChange);
		$('[name=TemplatePath]').change(channelMenu.onTemplatePathChange);
		
		if (_pathInTemplate == '')
			$('#page-type-url').click();

		channelMenu.onPageReady();
	}
	else if (_page == 'channel_menu_list')
	{
		var channelMenu = new ChannelMenu();
		var list = $('#List');

		list.on('submit', 'form', channelMenu.modifyName);
		list.on('mouseover', '[sort]', function(){this.className += ' Move_MouseOver';});
		list.on('mouseout', '[sort]', function(){this.className='Move';});
		
		$('table').on('click', 'td:last-child a', function()
		{
			var id = $(this).closest('tr').attr('ItemID');
			Confirm(_lang_confirm_delete, function(returnValue){if (returnValue)channelMenu.update('Delete', id);}, this);
			return false;
		});
		
		InitMove(null,'Move', null, channelMenu.move);
	}
	else if (_page == 'generate_manual_list')
	{
		//生成对象
		$("#List").on('click', 'input', function()
		{
			window.open(HandleFake404('do.aspx?Type=Object&ChannelID=' + $('#ChannelID').val() + '&Object=' + this.name, 'url'));
		});

		$('#ChannelID').change(function()
		{
			if ($(this.options[this.selectedIndex]).css('color') == '#ccc')
			{
				this.selectedIndex = 0;
				return false;
			}

			Search();
		});

		$('#ChannelID option').each(function()

		{
			if ($(this).attr('Generate') == 'False')
				$(this).css('color', '#CCC');
		});
		
		//生成网站
		$('.ToolBar input').eq(1).click(function()
		{
			window.open(HandleFake404('do.aspx?Type=Site', 'url'));
		});
		
		//生成栏目
		$('.ToolBar input').eq(0).click(function()
		{
			var channelIDSelect = document.getElementById("ChannelID");
			if ($('#ChannelID').val() == '')
			{
				Alert(_lang_select_channel);
				return;
			}
			
			window.open(HandleFake404('do.aspx?Type=Channel&ChannelID=' + $('#ChannelID').val(), 'url'));
		});
	}
	else if (_page == 'generate_do')
	{
		if (_channels.length == 0)
		{
			$(document.body).append('<div>' + _lang_nothing + '</div>');
			return;
		}
		
		_pages = CreateXmlDom();
		GetTemplatePages();
	}
	else if(_page =='generate_config_basic')
	{
		$('form:first').submit(SetGenerateSettings);
		
		$('[name=SmartUpdate]').change(SmartUpdate_OnChange).change();
	}
})();