﻿<%@ Page CodeFileBaseClass="AliCMS.Lib.SystemPageBase" %>
<!doctype html>
<html>
<head>
<meta charset="utf-8">
<title>管理员列表</title>
<link rel="stylesheet" href="<%=CommonPath%>jquery/themes/lightness/all.css" >
<ali:Comment><link rel="stylesheet" href="../../S01/CHS/css/common.css" ></ali:Comment>
<link rel="stylesheet" href="<%=CssPath%>common.css" >
<script language="c#" runat="server">
protected string Condition()
{
	StringBuilder condition = new StringBuilder();
	string and = String.Empty;

	#region 是否回收
	string isRecycled = Request.QueryString["IsRecycled"];
	if (isRecycled == null)
		condition.Append(Alias.Admin.IsDeleted + "=false");
	else if (isRecycled != String.Empty)
		condition.Append(Alias.Admin.IsDeleted + "=" + isRecycled);
	#endregion

	if (and == String.Empty && condition.Length != 0)
		and = " AND ";

	#region 角色
	if (!String.IsNullOrEmpty(Request.QueryString["RoleID"]))
		condition.Append(and + Alias.Admin.RoleID + "=" + Request.QueryString["RoleID"]);
	#endregion
	
	return condition.ToString();
}
</script>
<script >
var _page = 'admin_list',
    _lang ='<%=ContentLang%>',
    _webPath = '<%=WebPath%>',
    _imagePath = '<%=ImagePath%>',
    _lang_working = '正在操作...',
    _lang_operation_fail = '操作失败！',
    _lang_operation_success = '操作成功！',
    _lang_confirm_delete = '要删除此项吗？',
    _lang_recycle = '回收',
    _lang_delete = '删除',
    _lang_recover = '还原';
</script>
</head>
<body>
<div class="WhiteHeader">
	<div class="Left"><img src="<%=ImagePath%>close_frame.gif" ></div>
	<div class="Title">管理员列表</div>
	<div class="Right"></div>
</div>
<div class="Block">
	<ul class="TabMenu">
		<li class="Left Selected"></li>
		<li class="Middle Selected">管理员列表</li>
		<li class="Right Selected"></li>
		<li class="Left"></li>
		<li class="Middle"><a href="../admin/add.aspx?Lang=<%=ContentLang%>">添加管理员</a></li>
		<li class="Right"></li>
	</ul>
	<ul class="Title">
		<li class="Left"></li>
		<li class="Middle"></li>
		<li class="Right"></li>
	</ul>
	<div class="ToolBar">
		<select id="IsRecycled">
			<option value="">是否回收</option>
			<option value="false" selected="selected">未回收</option>
			<option value="true">已回收</option>
		</select>
		<select id="RoleID" class="<%=ContentLang%>Font">
			<option value="">所有角色</option>
			<ali:List Object="Role">
				<ali:Record>
					<option value="<%=ID%>"><%=Name%></option>
				</ali:Record>
			</ali:List>
		</select>
		<input id="SelectAll" type="button" value="全选" class="Button" >
		<input id="ReverseSelect" type="button" value="反选" class="Button">
		<span id="ExtraButton"></span>
	</div>
	<div id="List">
		<table border="0" cellpadding="4" cellspacing="1" class="ListTable">
			<thead>
				<tr>
					<th width="40">选择</th>
					<th>名称</th>
					<th>Email</th>
					<th>真实姓名</th>
					<th>QQ</th>
					<th>MSN</th>
				</tr>
			</thead>
			<tbody>
				<ali:List ID="List" Object="Admin" Page="PageNumber" PageSize="20" Condition="Condition()" Validate="True">
					<ali:Record>
						<tr id="Row<%=InnerID%>">
							<td>
								<%If User["ID"] != Convert.ToString(ID)%>
									<input type="checkbox" name="Sel" value="<%=InnerID%>" >
								<%EndIf%>
							</td>
							<td><a href="../admin/edit.aspx?Lang=<%=ContentLang%>&amp;ID=<%=InnerID%>"><%=Name%></a></td>
							<td><%=Email%></td>
							<td><%=RealName%></td>
							<td><%=QQ%></td>
							<td><%=MSN%></td>
						</tr>
					</ali:Record>
				</ali:List>
			</tbody>
		</table>
		<ali:Pagination Page="PageNumber" PageSize="20" RecordCount="List[RecordCount]">
			<div class="Pagination">
				<div class="Left">共 <%=RecordCount%> 条 当前显示第 <%=PageNumber%> 页 第 <%=RangeLower%>-<%=RangeUpper%> 条 </div>
				<div class="Right">
					<ali:FirstPage>
						<ali:Yes>
							<img src="<%=ImagePath%>pagination/first_page_off.gif">
							<img src="<%=ImagePath%>pagination/previous_page_off.gif">
						</ali:Yes>
						<ali:No>
							<a href="javascript:Go(1)"><img src="<%=ImagePath%>pagination/first_page_on.gif"></a>
							<a href="javascript:Go(<%=PageNumber%> - 1)" id="PrevPage"><img src="<%=ImagePath%>pagination/previous_page_on.gif"></a>
						</ali:No>
					</ali:FirstPage>
					<ali:CurrentPage Range="5">
						<ali:Yes>
							<span class="Current"><%=Index%></span>						
						</ali:Yes>
						<ali:No>
							<a href="javascript:Go(<%=Index%>)">[<%=Index%>]</a>
						</ali:No>
					</ali:CurrentPage>
					<ali:LastPage>
						<ali:Yes>
							<img src="<%=ImagePath%>pagination/next_page_off.gif">
							<img src="<%=ImagePath%>pagination/last_page_off.gif">
						</ali:Yes>
						<ali:No>
							<a href="javascript:Go(<%=PageNumber%> + 1)" id="NextPage"><img src="<%=ImagePath%>pagination/next_page_on.gif"></a>
							<a href="javascript:Go(<%=PageCount%>)"><img src="<%=ImagePath%>pagination/last_page_on.gif"></a>
						</ali:No>
					</ali:LastPage>
				</div>
			</div>
		</ali:Pagination>
	</div>
</div>
<script src="<%=CommonPath%>jquery/core.js"></script>
<script src="<%=CommonPath%>jquery/ui.js"></script>
<script src="<%=CommonPath%>utility.js"></script>
<script src="<%=JsPath%>global.js"></script>
<script src="<%=ModuleJsPath%>module.js"></script>
</body>
</html>