﻿<%@ Page CodeFileBaseClass="AliCMS.Lib.SystemPageBase" %>
<%@ Register TagPrefix="alicmsUC" TagName="Ime" Src="../../ime.dwt.ascx"%>
<%@ Register TagPrefix="alicmsUC" TagName="LanguageMenu" Src="../../language_menu.dwt.ascx"%>
<!doctype html>
<html>
<head>
<meta charset="utf-8">
<ali:Get ID="ThisChannel" Object="Channel" InnerID="Request.QueryString['ID']" Validate="True" />
<title>编辑栏目</title>
<link rel="stylesheet"  href="<%=CommonPath%>jquery/themes/lightness/all.css" >
<ali:Comment><link rel="stylesheet"  href="../../S01/CHS/css/common.css" ></ali:Comment>
<link rel="stylesheet" href="<%=CssPath%>common.css" >
<alicmsUC:Ime Ime="true" Eot="true" runat="server" />
<script language="c#" runat="server">
protected string CurrentModuleID
{
	get
	{
		object instanceID = ThisChannel[AliCMS.SystemModule.Alias.Channel.InstanceID];
		if (Guid.Equals(instanceID, Guid.Empty))
			return Guid.Empty.ToString();
		
		DataRow[] rows = Manager.Channels.Select(AliCMS.SystemModule.Alias.Instance.ID + "='" + instanceID + "'");
		return rows[0][AliCMS.SystemModule.Alias.Module.ID].ToString();
	}
}
</script>
<script >
var _page = 'channel_edit',
    _lang = '<%=ContentLang%>',
    _webPath = '<%=WebPath%>',
    _imagePath = '<%=ImagePath%>',
    _id = '<%=Request.QueryString["ID"]%>',
    _templatePath = '<%=ThisChannel[TemplatePath]%>',
    _instanceID = '<%=ThisChannel[InstanceID]%>',
<%If Convert.IsDBNull(ThisChannel[TemplatePath])%>
	    _type = 'OuterLink',
<%ElseIf Guid.Equals(ThisChannel[InstanceID], Guid.Empty)%>
	    _type = 'NonFunctional',
<%Else%>
	    _type = 'Functional',
<%EndIf%>
    _uploadLogo = false,
    _uploadLink = false,
    _lang_working = '正在操作...',
    _lang_operation_fail = '操作失败！',
    _lang_operation_success = '操作成功！',
    _lang_start_upload_logo = '开始上传栏目Logo...',
    _lang_uploading_logo = '开始上传栏目Logo...',
    _lang_start_upload_link = '开始上传链接Logo...',
    _lang_uploading_link = '开始上传链接Logo...',
    _lang_logo_type_must_be = '栏目Logo类型应为：',
    _lang_link_type_must_be = '链接Logo类型应为：',
    _lang_name_empty = '名称不能空！',
    _lang_path_tip1 = '首页，则留空。其它必须以斜杠（/）结尾，路经不能重复！<br />可以包含正则表达式，格式：{名称:正则表达式}',
    _lang_path_tip2 = '必须以http://开头',
    _lang_path_incorrect = '路径格式不正确！',
    _lang_path_exist = '路径已经存在！';
</script>
</head>
<body>
<div class="WhiteHeader">
	<div class="Left"><img src="<%=ImagePath%>close_frame.gif"></div>
	<div class="Title"><a href="../channel/list.aspx?Lang=<%=ContentLang%>">栏目列表</a> → <span class="<%=ContentLang%>Font"><%=ThisChannel[Name]%></span></div>
	<div class="Right">
		<alicmsUC:LanguageMenu runat="server" />
		<img height="15" src="<%=ImagePath%>dropdown.gif" > 语言：<%=CurrentLanguage%>
	</div>
</div>
<div class="Block">
	<ul class="TabMenu">
		<li class="Left Selected"></li>
		<li class="Middle Selected">编辑</li>
		<li class="Right Selected"></li>
		<%If !Convert.IsDBNull(ThisChannel[TemplatePath])%>
			<li class="Left"></li>
			<li class="Middle"><a href="../channel/change_template.aspx?Lang=<%=ContentLang%>&amp;ID=<%=Request.QueryString["ID"]%>">更改模板</a></li>
			<li class="Right"></li>
			<li class="Left"></li>
			<li class="Middle"><a href="../channel/extra_instance.aspx?Lang=<%=ContentLang%>&amp;ID=<%=Request.QueryString["ID"]%>">栏目邦定</a></li>
			<li class="Right"></li>
		<%EndIf%>
		<%If Convert.ToBoolean(ThisChannel[EnableMenu])%>
			<li class="Left"></li>
			<li class="Middle"><a href="../channel/menu/list.aspx?Lang=<%=ContentLang%>&amp;ChannelID=<%=Request.QueryString["ID"]%>">栏目菜单</a></li>
			<li class="Right"></li>
			<li class="Left"></li>
			<li class="Middle"><a href="../channel/menu/add.aspx?Lang=<%=ContentLang%>&amp;ChannelID=<%=Request.QueryString["ID"]%>">添加菜单</a></li>
			<li class="Right"></li>
		<%EndIf%>
	</ul>
	<ul class="Title">
		<li class="Left"></li>
		<li class="Middle"></li>
		<li class="Right"></li>
	</ul>
	<form>
		<table border="0" cellpadding="4" cellspacing="1">
			
			<tbody>
				<tr>
					<th width="120">类型：</th>
					<td>
						<input type="radio" id="Functional" disabled="disabled" >功能栏目
						<input type="radio" id="NonFunctional" disabled="disabled" >非功能栏目
						<input type="radio" id="OuterLink" disabled="disabled" >外部链接
					</td>
				</tr>
				<%If !Guid.Equals(ThisChannel[InstanceID], Guid.Empty)%>
					<tr>
						<th>实例：</th>
						<td>
							<ali:List Object="Instance" Condition="ModuleID=CurrentModuleID">
								<select name="InstanceID" class="<%=ContentLang%>Font">
								<ali:Record>
									<%If Guid.Equals(ThisChannel[InstanceID], ID)%>
										<option value="<%=ID%>" selected="selected"><%=Name%></option>
									<%Else%>
										<option value="<%=ID%>"><%=Name%></option>
									<%EndIf%>
								</ali:Record>
								</select>
							</ali:List>
						</td>
					</tr>
				<%EndIf%>
				<tr>
					<th>父栏目：</th>
					<td>
						<select name="ParentID" class="<%=ContentLang%>Font">
							<option value="">未指定</option>
							<ali:Tree Object="Channel">
								<ali:Control>
									<ali:Space>&nbsp;&nbsp;</ali:Space>
									<ali:Line>│</ali:Line>
									<ali:TopOpen>┌</ali:TopOpen>
									<ali:Top>┌</ali:Top>
									<ali:MiddleOpen>├</ali:MiddleOpen>
									<ali:Middle>├</ali:Middle>
									<ali:BottomOpen>└</ali:BottomOpen>
									<ali:Bottom>└</ali:Bottom>
								</ali:Control>
								<ali:Record>
									<%If Guid.Equals(ID, ThisChannel[ParentID])%>
										<option value="<%=ID%>" selected="selected"><%=Control%><%=Name%></option>
									<%Else%>
										<option value="<%=ID%>"><%=Control%><%=Name%></option>
									<%EndIf%>
									<%=ChildRecords%>
								</ali:Record>
							</ali:Tree>
						</select>
					</td>
				</tr>
				<tr>
					<th>名称：</th>
					<td><input type="text" name="Name" value="<%=ThisChannel[Name]%>" maxlength="50" class="Text <%=ContentLang%>Font" ></td>
				</tr>
				<tr>
					<th>路径：</th>
					<td><input type="text" name="Path" value="<%=ThisChannel[Path]%>" size="40" maxlength="50" class="Text" ><br /><span id="PathTip"></span></td>
				</tr>
				<%If !Convert.IsDBNull(ThisChannel[TemplatePath])%>
					<%If !Guid.Equals(ThisChannel[InstanceID], Guid.Empty)%>
						<tr>
							<th>是否动态模板：</th>
							<td>
								<%If Convert.ToBoolean(ThisChannel[IsDynamicTemplate])%>
									<input type="radio" name="IsDynamicTemplate" id="IsDynamicTemplateYes" checked="checked" ><label for="IsDynamicTemplateYes">是</label>
									<input type="radio" name="IsDynamicTemplate" id="IsDynamicTemplateNo" ><label for="IsDynamicTemplateNo">否</label>
								<%Else%>
									<input type="radio" name="IsDynamicTemplate" id="IsDynamicTemplateYes" ><label for="IsDynamicTemplateYes">是</label>
									<input type="radio" name="IsDynamicTemplate" id="IsDynamicTemplateNo" checked="checked" ><label for="IsDynamicTemplateNo">否</label>
								<%EndIf%>
								<br />
								<ol style="display:none">
									<li>如果是动态模板，并且栏目路径中没有正则表达式，则设置name为ID，value为栏目路径后的第一个目录名称。</li>
									<li>如果是动态模板，并且栏目路径中包含正则表达式，则设置name为正则名称，value为正则匹配值。</li>
									<li>栏目所属的模块的InstanceConfig对象必须包含GetDynamicTemplate的函数，它接受name和value的两个参数，并且返回皮肤路径。</li>
								</ol>
							</td>
						</tr>
					<%EndIf%>
					<tr>
						<th>是否生成：</th>
						<td>
							<%If Convert.ToBoolean(ThisChannel[Generate])%>
								<input type="radio" name="Generate" id="GenerateYes" checked="checked" ><label for="GenerateYes">是</label>
								<input type="radio" name="Generate" id="GenerateNo" ><label for="GenerateNo">否</label>
							<%Else%>
								<input type="radio" name="Generate" id="GenerateYes" ><label for="GenerateYes">是</label>
								<input type="radio" name="Generate" id="GenerateNo" checked="checked" ><label for="GenerateNo">否</label>
							<%EndIf%>
						</td>
					</tr>
					<tr>
						<th>默认文档（首页）：</th>
						<td><input type="text" name="DefaultDocument" value="<%=ThisChannel[DefaultDocument]%>" size="15" maxlength="50" class="Text" ></td>
					</tr>
					<tr>
						<th>扩展名：</th>
						<td><input type="text" name="Extension" value="<%=ThisChannel[Extension]%>" size="10" maxlength="50" class="Text" ></td>
					</tr>
					<tr>
						<th>域名：</th>
						<td>
							<input type="text" name="Domain" value="<%=ThisChannel[Domain]%>" size="40" maxlength="50" class="Text" ><br />
							以http://开头，以斜杠（/）结束，可以包含子目录。可绑定多个域名，多域名用"|"隔开。
						</td>
					</tr>
					<tr>
						<th>公告：</th>
						<td><textarea type="text" name="Notice" cols="60" rows="4" wrap="off" class="Text <%=ContentLang%>Font"><%=ThisChannel[Notice]%></textarea></td>
					</tr>
					<tr>
						<th>脚注（版权信息）：</th>
						<td><textarea type="text" name="Footer" cols="60" rows="4" wrap="off" class="Text <%=ContentLang%>Font"><%=ThisChannel[Footer]%></textarea></td>
					</tr>
					<tr>
						<th>ICP备案号：</th>
						<td><input type="text" name="ICP" value="<%=ThisChannel[ICP]%>" size="40" class="Text" ></td>
					</tr>
					<tr>
						<th>统计代码：</th>
						<td><textarea type="text" name="StatisticsCode" cols="60" rows="2" wrap="off" class="Text"><%=ThisChannel[StatisticsCode]%></textarea></td>
					</tr>
					<tr>
						<th>栏目Logo：</th>
						<td>
							<input id="LogoTextbox" type="text" name="Logo" value="<%=ThisChannel[Logo]%>" size="60" class="Text" >
							<input id="LogoBrowse" type="button" value="浏览..." >
							<input type="hidden" name="LogoAllowedType" value="gif|jpg|jpeg|png|bmp|png" >
							<a href="<%=ThisChannel[Logo]%>" target="_blank"><img src="<%=ThisChannel[Logo]%>" height="22" id="LogoView" alt="栏目Logo" style="vertical-align:bottom" ></a>
						</td>
					</tr>
					<tr>
						<th>链接Logo：</th>
						<td>
							<input id="LinkTextbox" type="text" name="Link" value="<%=ThisChannel[Link]%>" size="60" class="Text" >
							<input id="LinkBrowse" type="button" value="浏览..." >
							<input type="hidden" name="LinkAllowedType" value="gif|jpg|jpeg|png|bmp|png" >
							<a href="<%=ThisChannel[Link]%>" target="_blank"><img src="<%=ThisChannel[Link]%>" height="22" id="LinkView" alt="链接Logo" style="vertical-align:bottom" ></a>
						</td>
					</tr>
					<%If !Guid.Equals(ThisChannel[InstanceID], Guid.Empty)%>
						<tr>
							<th>启用可视编辑：</th>
							<td>
								<%If Convert.ToInt32(ThisChannel[VisualEdit]) == 1%>
									<input type="radio" name="VisualEdit" id="VisualEdit0" value="0" ><label for="VisualEdit0">禁用</label>
									<input type="radio" name="VisualEdit" id="VisualEdit1" value="1" checked="checked" ><label for="VisualEdit1">静态</label>
									<input type="radio" name="VisualEdit" id="VisualEdit2" value="2" ><label for="VisualEdit2">动态</label>
								<%ElseIf Convert.ToInt32(ThisChannel[VisualEdit]) == 2%>
									<input type="radio" name="VisualEdit" id="VisualEdit0" value="0" ><label for="VisualEdit0">禁用</label>
									<input type="radio" name="VisualEdit" id="VisualEdit1" value="1" ><label for="VisualEdit1">静态</label>
									<input type="radio" name="VisualEdit" id="VisualEdit2" value="2" checked="checked" ><label for="VisualEdit2">动态</label>
								<%Else%>
									<input type="radio" name="VisualEdit" id="VisualEdit0" value="0" checked="checked" ><label for="VisualEdit0">禁用</label>
									<input type="radio" name="VisualEdit" id="VisualEdit1" value="1" ><label for="VisualEdit1">静态</label>
									<input type="radio" name="VisualEdit" id="VisualEdit2" value="2" ><label for="VisualEdit2">动态</label>
								<%EndIf%>
								<ol>
									<li>如果是动态，并且栏目路径中不包含正则表达式，则设置name为ID，value为栏目路径后的第一个目录名称。</li>
									<li>如果是动态，并且栏目路径中包含正则表达式，则设置name为正则名称，value为正则匹配值。</li>
									<li>栏目所属的模块的InstanceConfig对象必须包含GetVisualEditFolder(name, value, checkRight)的函数，它返回可视编辑目录路径。</li>
								</ol>
							</td>
						</tr>
					<%EndIf%>
					<tr>
						<th>栏目菜单：</th>
						<td>
							<%If Convert.ToBoolean(ThisChannel[EnableMenu])%>
								<label><input type="radio" name="EnableMenu" value="true" checked="checked" >启用</label>
								<label><input type="radio" name="EnableMenu" value="false" >禁用</label>
							<%Else%>
								<label><input type="radio" name="EnableMenu" value="true" >启用</label>
								<label><input type="radio" name="EnableMenu" value="false" checked="checked" >禁用</label>
							<%EndIf%>
						</td>
					</tr>
					<tr style="display:none">
						<th>导航位置：</th>
						<td>
							<%If Convert.ToString(ThisChannel[NavPosition]) == "Top"%>
								<label><input type="radio" name="NavPosition" value="Top" checked="checked">顶部</label>
								<label><input type="radio" name="NavPosition" value="Left" >左侧</label>
							<%Else%>
								<label><input type="radio" name="NavPosition" value="Top" >顶部</label>
								<label><input type="radio" name="NavPosition" value="Left" checked="checked" >左侧</label>
							<%EndIf%>
						</td>
					</tr>
					<tr style="display:none">
						<th>侧栏导航样式：</th>
						<td>
							<%If Convert.ToString(ThisChannel[SideNavStyle]) == "Tree"%>
								<label><input type="radio" name="SideNavStyle" value="Tree" checked="checked" >树型</label>
								<label><input type="radio" name="SideNavStyle" value="Accordion" >折叠型</label>
							<%Else%>
								<label><input type="radio" name="SideNavStyle" value="Tree" >树型</label>
								<label><input type="radio" name="SideNavStyle" value="Accordion" checked="checked" >折叠型</label>
							<%EndIf%>
						</td>
					</tr>
					<tr style="display:none">
						<th>管理员角色：</th>
						<td><input type="text" name="AdminRole" value="<%=ThisChannel[AdminRole]%>" size="30" class="Text" ></td>
					</tr>
					<tr style="display:none">
						<th>辅助登陆路径：</th>
						<td><input type="text" name="LoginPath" value="<%=ThisChannel[LoginPath]%>" size="30" class="Text" /></td>
					</tr>
					<tr>
						<th>Meta：</th>
						<td>
							Keywords：<input type="text" name="MetaKeywords" value="<%=ThisChannel[MetaKeywords]%>" size="20" maxlength="255" class="Text <%=ContentLang%>Font" >
							Description：<input type="text" name="MetaDescription" value="<%=ThisChannel[MetaDescription]%>" size="20" maxlength="255" class="Text <%=ContentLang%>Font" >
						</td>
					</tr>
				<%EndIf%>
			</tbody>
			<tfoot>
				<tr>
					<td colspan="2">
						<input type="submit" value="编辑" />
					</td>
				</tr>
			</tfoot>
		</table>
	</form>
	<div class="Footer"></div>
</div>
<script src="<%=CommonPath%>jquery/core.js"></script>
<script src="<%=CommonPath%>jquery/ui.js"></script>
<script src="<%=CommonPath%>uploader.js"></script>
<script src="<%=CommonPath%>utility.js"></script>
<script src="<%=JsPath%>global.js"></script>
<script src="<%=ModuleJsPath%>module.js"></script>
</body>
</html>