﻿<%@ Page CodeFileBaseClass="AliCMS.Lib.SystemPageBase" %>
<ali:List ID="Template" Object="Template" Condition="IsAdmin=true" />
<script language="c#" runat="server">
protected DataTable TemplatePaths
{
	get
	{
		DataTable result = new DataTable();
		result.Columns.Add("Path", typeof(string));
		
		string ns = Request.QueryString["Namespace"];

		#region 管理模板
		string templateRoot = Manager.GetTemplatePath(null);
		foreach (DataRow templateRow in Template.Rows)
		{
			string path = templateRoot + templateRow[Alias.Template.Path];
			if (!System.IO.Directory.Exists(Manager.MapPath(path + ns)))
				continue;
			
			DataRow row = result.NewRow();
			row["Path"] = path + ns + "/page/";
			result.Rows.Add(row);
		}
		#endregion
		
		#region module下的模板
		string modulePath = Manager.GetModulePath(ns);
		string dir = Manager.MapPath(modulePath + "template/");
		if (!System.IO.Directory.Exists(dir))
			return result;
		
		string[] templates = System.IO.Directory.GetDirectories(dir, "*", System.IO.SearchOption.TopDirectoryOnly);
		foreach (string template in templates)
		{
			DataRow row = result.NewRow();
			row["Path"] = modulePath + "template/" + System.IO.Path.GetFileName(template) + "/page/";
			result.Rows.Add(row);
		}
		#endregion
		
		return result;
	}
}
</script>
<ali:List Source="TemplatePaths">
	<ali:Record>
		<option value="<%=[0]%>"><%=[0]%></option>
	</ali:Record>
</ali:List>