﻿<%@ Page CodeFileBaseClass="AliCMS.Lib.SystemPageBase" %>
<!doctype html>
<html>
<head>
<meta charset="utf-8">
<ali:Get ID="Config" Object="InstanceConfig" Operation="GetGlobalSettings()" Validate="True" />
<title>全局设置</title>
<link rel="stylesheet"  href="<%=CommonPath%>jquery/themes/lightness/all.css" >
<ali:Comment><link rel="stylesheet"  href="../../S01/CHS/css/common.css" ></ali:Comment>
<link rel="stylesheet" href="<%=CssPath%>common.css" >
<script >
var _page = 'config_global',
   _lang = '<%=ContentLang%>',
   _webPath = '<%=WebPath%>',
   _imagePath = '<%=ImagePath%>',
   _databaseProvider = '<%=Config[DatabaseProvider]%>',
   _lang_working = '正在操作...',
   _lang_operation_fail = '操作失败！',
   _lang_operation_success = '操作成功！',
   _lang_connection_string_empty = '数据库连接字符串不能为空！';
</script>
</head>
<body>
<div class="WhiteHeader">
	<div class="Left"><img src="<%=ImagePath%>close_frame.gif" ></div>
	<div class="Title">全局设置</div>
	<div class="Right"></div>
</div>
<div class="Block">
	<ul class="TabMenu">
		<li class="Left"></li>
		<li class="Middle"><a href="../config/basic.aspx?Lang=<%=ContentLang%>">基本设置</a></li>
		<li class="Right"></li>
		<li class="Left"></li>
		<li class="Middle"><a href="../config/email.aspx?Lang=<%=ContentLang%>">邮件设置</a></li>
		<li class="Right"></li>
		<li class="Left"></li>
		<li class="Middle"><a href="../config/water_mark.aspx?Lang=<%=ContentLang%>">水印设置</a></li>
		<li class="Right"></li>
		<li class="Left"></li>
		<li class="Middle"><a href="../config/rewrite.aspx?Lang=<%=ContentLang%>">URL重写</a></li>
		<li class="Right"></li>
		<li class="Left Selected"></li>
		<li class="Middle Selected">全局设置</li>
		<li class="Right Selected"></li>
	</ul>
	<ul class="Title">
		<li class="Left"></li>
		<li class="Middle"></li>
		<li class="Right"></li>
	</ul>
	<form>
		<table border="0" cellpadding="4" cellspacing="1">
			<tbody>
				<tr>
					<th>系统版本：</th>
					<td><%=Config[Version]%></td>
				</tr>
				<tr>
					<th>网站域名：</th>
					<td>
						<input type="text" name="Domain" value="<%=Config[Domain]%>" size="60" maxlength="255" class="Text" >
						<br />以http://开头，以斜杠（/）结束
					</td>
				</tr>
				<tr>
					<th>数据库提供者：</th>
					<td>
						<select name="DatabaseProvider">
							<option value="OleDb">OleDb</option>
						</select>
					</td>
				</tr>
				<tr>
					<th>是否保护连接字符串：</th>
					<td>
						<%If Convert.ToBoolean(Config[ProtectConnectionString])%>
							<input type="radio" name="ProtectConnectionString" id="ProtectConnectionStringYes" checked="checked" ><label for="ProtectConnectionStringYes">是</label>
							<input type="radio" name="ProtectConnectionString" id="ProtectConnectionStringNo" ><label for="ProtectConnectionStringNo">否</label>
						<%Else%>
							<input type="radio" name="ProtectConnectionString" id="ProtectConnectionStringYes" ><label for="ProtectConnectionStringYes">是</label>
							<input type="radio" name="ProtectConnectionString" id="ProtectConnectionStringNo" checked="checked" ><label for="ProtectConnectionStringNo">否</label>
						<%EndIf%>
					</td>
				</tr>
				<tr>
					<th>连接字符串：</th>
					<td>
						<input type="text" name="ConnectionString" value="<%=Config[ConnectionString]%>" size="80" maxlength="255" class="Text" >
						<br />{#WebPath#}表示网站根目录，{#DataPath#}表示数据目录
					</td>
				</tr>
				<tr>
					<th>网页瘦身：</th>
					<td>
						<%If Convert.ToBoolean(Config[ClearWhiteSpace])%>
							<input type="checkbox" id="ClearWhiteSpace" checked="checked" ><label for="ClearWhiteSpace">清除空白</label>
						<%Else%>
							<input type="checkbox" id="ClearWhiteSpace" ><label for="ClearWhiteSpace">清除空白</label>
						<%EndIf%>

						<%If Convert.ToBoolean(Config[ClearHtmlComment])%>
							<input type="checkbox" id="ClearHtmlComment" checked="checked" ><label for="ClearHtmlComment">清除Html注释</label>
						<%Else%>
							<input type="checkbox" id="ClearHtmlComment" /><label for="ClearHtmlComment">清除Html注释</label>
						<%EndIf%>

						<%If Convert.ToBoolean(Config[ClearScriptComment])%>
							<input type="checkbox" id="ClearScriptComment" checked="checked" ><label for="ClearScriptComment">清除脚本注释</label>
						<%Else%>
							<input type="checkbox" id="ClearScriptComment" ><label for="ClearScriptComment">清除脚本注释</label>
						<%EndIf%>
					</td>
				</tr>
				<tr>
					<th>GZip：</th>
					<td>
						<%If Convert.ToBoolean(Config[GZipEnabled])%>
							<input type="radio" name="GZipEnabled" id="GZipEnabledYes" checked="checked" ><label for="GZipEnabledYes">启用</label>
							<input type="radio" name="GZipEnabled" id="GZipEnabledNo" ><label for="GZipEnabledNo">禁用</label>
						<%Else%>
							<input type="radio" name="GZipEnabled" id="GZipEnabledYes" ><label for="GZipEnabledYes">启用</label>
							<input type="radio" name="GZipEnabled" id="GZipEnabledNo" checked="checked" ><label for="GZipEnabledNo">禁用</label>
						<%EndIf%>
					</td>
				</tr>
				<tr>
					<th>伪404：</th>
					<td>
						<%If Convert.ToBoolean(Config[Fake404])%>
							<input type="radio" name="Fake404" id="Fake404Yes" checked="checked" ><label for="Fake404Yes">启用</label>
							<input type="radio" name="Fake404" id="Fake404No" ><label for="Fake404No">禁用</label>
						<%Else%>
							<input type="radio" name="Fake404" id="Fake404Yes" ><label for="Fake404Yes">启用</label>
							<input type="radio" name="Fake404" id="Fake404No" checked="checked" ><label for="Fake404No">禁用</label>
						<%EndIf%>
						<br />当网站首页能打开，但是其他页面出现404错误时，并且空间设置不能改变的情况下，启用此设置。
						<br />空间设置方法：1）启动IIS。2）打开你的网站属性。3）切换到”主目录“。3）点击”配置“。4）切换到”映射“。5）列表中选择”.aspx“，点击”编辑“。6）选中”检查文件是否存在“。
						<br />空间设置好了之后，可以禁用此设置。
					</td>
				</tr>
				<tr>
					<th>网站调试：</th>
					<td>
						<%If Convert.ToBoolean(Config[OnlyAdminCanDebug])%>
							<input type="checkbox" id="OnlyAdminCanDebug" checked="checked" ><label for="OnlyAdminCanDebug">只有管理员可以调试</label>
						<%Else%>
							<input type="checkbox" id="OnlyAdminCanDebug" ><label for="OnlyAdminCanDebug">只有管理员可以调试</label>
						<%EndIf%>

						<%If Convert.ToBoolean(Config[DisplayTrace])%>
							<input type="checkbox" id="DisplayTrace" checked="checked" ><label for="DisplayTrace">显示跟踪</label>
						<%Else%>
							<input type="checkbox" id="DisplayTrace" ><label for="DisplayTrace">显示跟踪</label>
						<%EndIf%>
					</td>
				</tr>
				<tr>
					<th>暂时关闭网站：</th>
					<td>
						<%If Convert.ToBoolean(Config[ShutDown])%>
							<input type="radio" name="ShutDown" id="ShutDownYes" checked="checked" ><label for="ShutDownYes">是</label>
							<input type="radio" name="ShutDown" id="ShutDownNo" ><label for="ShutDownNo">否</label>
						<%Else%>
							<input type="radio" name="ShutDown" id="ShutDownYes" ><label for="ShutDownYes">是</label>
							<input type="radio" name="ShutDown" id="ShutDownNo" checked="checked" ><label for="ShutDownNo">否</label>
						<%EndIf%>
					</td>
				</tr>
				<tr>
					<th>关闭网站的原因：</th>
					<td><textarea type="text" name="ShutDownReason" cols="60" rows="4" wrap="off" class="Text"><%=Config[ShutDownReason]%></textarea></td>
				</tr>
				<tr>
					<th>用户数据目录名称：</th>
					<td>
						<input type="text" name="UserDataDirectory" value="<%=Config[UserDataDirectory]%>" size="60" class="Text" >
					</td>
				</tr>
				<tr>
					<th>数据目录名称：</th>
					<td><input type="text" name="DataDirectory" value="<%=Config[DataDirectory]%>" maxlength="50" class="Text" ></td>
				</tr>
				<tr>
					<th>模板目录名称：</th>
					<td><input type="text" name="TemplateDirectory" value="<%=Config[TemplateDirectory]%>" maxlength="50" class="Text" ></td>
				</tr>
				<tr>
					<th>缓存目录名称：</th>
					<td><input type="text" name="CacheDirectory" value="<%=Config[CacheDirectory]%>" maxlength="50" class="Text" ></td>
				</tr>
				<tr>
					<th>模块目录名称：</th>
					<td><input type="text" name="ModuleDirectory" value="<%=Config[ModuleDirectory]%>" maxlength="50" class="Text" ></td>
				</tr>
				<tr>
					<th>公用目录名称：</th>
					<td><input type="text" name="CommonDirectory" value="<%=Config[CommonDirectory]%>" maxlength="50" class="Text" ></td>
				</tr>
			</tbody>
			<tfoot>
				<tr>
					<td colspan="2"><input type="submit" class="Button" value="编辑" ></td>
				</tr>
			</tfoot>
		</table>
	</form>
	<div class="Footer"></div>
</div>
<script src="<%=CommonPath%>jquery/core.js"></script>
<script src="<%=CommonPath%>jquery/ui.js"></script>
<script src="<%=CommonPath%>utility.js"></script>
<script src="<%=JsPath%>global.js"></script>
<script src="<%=ModuleJsPath%>module.js"></script>
</body>
</html>