﻿<%@ Page CodeFileBaseClass="AliCMS.Lib.SystemPageBase" %>
<%@ Import Namespace="System.Text.RegularExpressions" %>
<script language="c#" runat="server">
protected bool IsImage(object extention)
{
	return Regex.IsMatch(extention.ToString(), "jpg|jpeg|gif|png|bmp");
}

protected string GetSize(object size)
{
	string unit = " B";
	Single result = Convert.ToSingle(size);
	if (result > 1024)
	{
		result = result / 1024;
		unit = " K";
	}
	if (result > 1024)
	{
		result = result / 1024;
		unit = " M";
	}
	if (result > 1024)
	{
		result = result / 1024;
		unit = " G";
	}
	
	return result.ToString("0.00") + unit;
}

protected bool ListByPicture
{
	get
	{
		if (Request.QueryString["ListByPicture"] != null)
			return Convert.ToBoolean(Request.QueryString["ListByPicture"]);
		else if (Request.Cookies["ListByPicture"] != null)
			return Convert.ToBoolean(Request.Cookies["ListByPicture"].Value);
		else
			return false;
	}
}
</script>
<ali:List ID="List" Object="FileManager" Page="PageNumber" PageSize="50" Condition="Folder=Request.QueryString['Root']" Validate="True" />
<%If ListByPicture%>
	<ali:List Object="FileManager" Source="List">
		<ali:Row MaxCol="4">
			<ul>
				<ali:Col MaxRecord="1">
					<ali:Record>
						<li>
							<%If IsImage(Extension)%>
								<a href="" Path="<%=Folder%><%=Name%>"><img src="<%=Folder%><%=Name%>" /></a>
								<div><a href="" Path="<%=Folder%><%=Name%>"><%=Name%></a></div>
							<%ElseIf Convert.ToBoolean(IsFolder)%>
								<img src="<%=ImagePath%>tree/folder.gif" />
								<div><a href=""><%=Name%></a></div>
							<%Else%>
								<img src="<%=ImagePath%>tree/file.gif" />
								<div><%=Name%></div>
							<%EndIf%>
						</li>
					</ali:Record>
				</ali:Col>
			</ul>
		</ali:Row>
	</ali:List>
<%Else%>
	<table border="0" cellpadding="4" cellspacing="1" class="ListTable">
		<thead>
			<tr>
				<th>名称</th>
				<th width="50">扩展名</th>
				<th width="40">大小</th>
				<th width="120">创建时间</th>
				<th width="120">更新时间</th>
				<th width="40">属性</th>
				<th width="40">重名</th>
				<th width="40">移动</th>
				<th width="40">复制</th>
				<th width="40">压解</th>
				<th width="40">删除</th>
			</tr>
		</thead>
		<tbody>
			<ali:List Object="FileManager" Source="List">
				<ali:Record>
					<tr id="<%=Name%>">
						<th>
							<%If Convert.ToBoolean(IsFolder)%>
								<img src="<%=ImagePath%>tree/folder.gif" /><a href=""><%=Name%></a>
							<%Else%>
								<img src="<%=ImagePath%>tree/file.gif" /><a href="" Path="<%=Folder%><%=Name%>"><%=Name%></a>
							<%EndIf%>
						</th>
						<td><%=Extension%></td>
							<td><%=GetSize(Size)%></td>
						<td><%=CreateTime%></td>
						<td><%=UpdateTime%></td>
						<td><%=Attribute%></td>
						<td><a href="">重名</a></td>
						<td><a href="">移动</a></td>
						<td><a href="">复制</a></td>
						<td>
							<%If Convert.ToString(Extension) == ".zip"%>
								<a href="">解压</a>
							<%Else%>
								<a href="">压缩</a>
							<%EndIf%>
						</td>
						<td><a href="">删除</a></td>
					</tr>
				</ali:Record>
			</ali:List>
		</tbody>
	</table>
<%EndIf%>
<ali:Pagination Page="PageNumber" PageSize="50" RecordCount="List[RecordCount]">
	<div class="Pagination">
		<div class="Left">共 <%=RecordCount%> 条 当前显示第 <%=PageNumber%> 页 第 <%=RangeLower%>-<%=RangeUpper%> 条 </div>
		<div class="Right">
			<ali:FirstPage>
				<ali:Yes>
					<img src="<%=ImagePath%>pagination/first_page_off.gif"/>
					<img src="<%=ImagePath%>pagination/previous_page_off.gif"/>
				</ali:Yes>
				<ali:No>
					<a href="javascript:Go(1)"><img src="<%=ImagePath%>pagination/first_page_on.gif"/></a>
					<a href="javascript:Go(<%=PageNumber%> - 1)" id="PrevPage"><img src="<%=ImagePath%>pagination/previous_page_on.gif"/></a>
				</ali:No>
			</ali:FirstPage>
			<ali:CurrentPage Range="5">
				<ali:Yes>
					<span class="Current"><%=Index%></span>						
				</ali:Yes>
				<ali:No>
					<a href="javascript:Go(<%=Index%>)">[<%=Index%>]</a>
				</ali:No>
			</ali:CurrentPage>
			<ali:LastPage>
				<ali:Yes>
					<img src="<%=ImagePath%>pagination/next_page_off.gif"/>
					<img src="<%=ImagePath%>pagination/last_page_off.gif"/>
				</ali:Yes>
				<ali:No>
					<a href="javascript:Go(<%=PageNumber%> + 1)" id="NextPage"><img src="<%=ImagePath%>pagination/next_page_on.gif"/></a>
					<a href="javascript:Go(<%=PageCount%>)"><img src="<%=ImagePath%>pagination/last_page_on.gif"/></a>
				</ali:No>
			</ali:LastPage>
		</div>
	</div>
</ali:Pagination>
