﻿<%@ Page CodeFileBaseClass="AliCMS.Lib.SystemPageBase" %>
<%@ Import Namespace="System.Text.RegularExpressions" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<!doctype html>
<html>
<head>
<meta charset="utf-8">
<meta http-equiv="pragma" content="no-cache" />
<meta http-equiv="Cache-Control" content="no-cache" />
<meta http-equiv="Expires" content="Mon,1 Fab 1979 23:36:05 GMT" />
<title>选择文件</title>
<link rel="stylesheet"  href="<%=CommonPath%>jquery/themes/lightness/all.css" >
<ali:Comment><link rel="stylesheet"  href="../../S01/CHS/css/common.css" ></ali:Comment>
<link rel="stylesheet" href="<%=CssPath%>common.css" >
<style >
IMG{vertical-align:middle;margin:0 2px}
BODY{overflow-x:hidden}
</style>
<script language="c#" runat="server">
protected bool IsImage(object extention)
{
	return Regex.IsMatch(extention.ToString(), "jpg|jpeg|gif|png|bmp");
}

protected string GetSize(object size)
{
	string unit = " B";
	Single result = Convert.ToSingle(size);
	if (result > 1024)
	{
		result = result / 1024;
		unit = " K";
	}
	if (result > 1024)
	{
		result = result / 1024;
		unit = " M";
	}
	if (result > 1024)
	{
		result = result / 1024;
		unit = " G";
	}
	
	return result.ToString("0.00") + unit;
}

protected bool ListByPicture
{
	get
	{
		if (Request.QueryString["ListByPicture"] != null)
			return Convert.ToBoolean(Request.QueryString["ListByPicture"]);
		else if (Request.Cookies["ListByPicture"] != null)
			return Convert.ToBoolean(Request.Cookies["ListByPicture"].Value);
		else
			return false;
	}
}

protected string Root
{
	get
	{
		if (Request.QueryString["Type"] == "Editor")
			return Manager.GetDataPath(Convert.ToInt32(Request.QueryString["Root"]), null) + "editor/" + Request.QueryString["Folder"];
		else
			return (Request.QueryString["Root"] + Request.QueryString["Folder"]).Replace("//", "/");
	}
}
</script>
<script >
var _page = 'file_manager_select',
    _lang = '<%=ContentLang%>',
    _webPath = '<%=WebPath%>',
    _imagePath = '<%=ImagePath%>',
    _type = '<%=Request.QueryString["Type"]%>',
    _root = '<%=Root%>',
    _ckeditorFuncNum = '<%=Request.QueryString["CKEditorFuncNum"]%>',
    _lang_working = '正在操作...',
    _lang_operation_fail = '操作失败！',
    _lang_operation_success = '操作成功！',
    _lang_confirm_delete = '要删除此项吗？',
    _lang_start_slash = '文件夹必须以斜杠开头！',
    _lang_folder_name = '请输入新建文件夹名称？',
    _lang_select_file = '请选择文件！',
    _lang_start_upload = '开始上传文件...',
    _lang_uploading = '正在上传文件...',
    _lang_input_name = '请输入新名称？',
    _lang_target_folder = '请输入目标文件夹？',
    _lang_target_name = '请输入目标？',
    _lang_target_file = '请输入目标文件？',
    _lang_must_be_zip = '目标文件扩展名应是.zip！';
</script>
</head>
<body scroll="yes">
<div class="Block">
	<ul class="Title">
		<li class="Left"></li>
		<li class="Middle">选择文件</li>
		<li class="Right"></li>
	</ul>
	<div class="ToolBar">
		<%If ListByPicture%>
			<input type="checkbox" id="ListByPicture" checked="checked" ><label for="ListByPicture">缩略图</label>
		<%Else%>
			<input type="checkbox" id="ListByPicture" ><label for="ListByPicture">缩略图</label>
		<%EndIf%>

		地址：
		<input type="text" id="Folder" value="/" class="Text" >
		<input type="button" id="Open" value="打开" >
		<input type="button" id="Up" value="上层" >
		<input type="button" id="CreateFolder" value="新建文件夹" >
		文件：
		<form style="display:inline">
			<input id="FileTextbox" type="text" name="File" disabled="disabled" class="Text" >
			<input id="FileBrowse" type="button" value="浏览..." >
			<input type="submit" value="上传" >
			<input type="checkbox" id="AddWaterMark"><label for="AddWaterMark">水印</label>
		</form>
	</div>
	<div id="List">
		<ali:List ID="List" Object="FileManager" Page="PageNumber" PageSize="50" Condition="Folder=Root" Validate="True" />
		<%If ListByPicture%>
			<ali:List Object="FileManager" Source="List">
				<ali:Row MaxCol="4">
					<ul>
						<ali:Col MaxRecord="1">
							<ali:Record>
								<li>
									<%If IsImage(Extension)%>
										<a href="" Path="<%=Folder%><%=Name%>"><img src="<%=Folder%><%=Name%>" /></a>
										<div><a href="" Path="<%=Folder%><%=Name%>"><%=Name%></a></div>
									<%ElseIf Convert.ToBoolean(IsFolder)%>
										<img src="<%=ImagePath%>tree/folder.gif" />
										<div><a href=""><%=Name%></a></div>
									<%Else%>
										<img src="<%=ImagePath%>tree/file.gif" />
										<div><%=Name%></div>
									<%EndIf%>
								</li>
							</ali:Record>
						</ali:Col>
					</ul>
				</ali:Row>
			</ali:List>
		<%Else%>
			<table border="0" cellpadding="4" cellspacing="1" class="ListTable">
				<thead>
					<tr>
						<th>名称</th>
						<th width="50">扩展名</th>
						<th width="40">大小</th>
						<th width="120">创建时间</th>
						<th width="120">更新时间</th>
						<th width="40">属性</th>
						<th width="40">重名</th>
						<th width="40">移动</th>
						<th width="40">复制</th>
						<th width="40">压解</th>
						<th width="40">删除</th>
					</tr>
				</thead>
				<tbody>
					<ali:List Object="FileManager" Source="List">
						<ali:Record>
							<tr id="<%=Name%>">
								<th>
									<%If Convert.ToBoolean(IsFolder)%>
										<img src="<%=ImagePath%>tree/folder.gif" /><a href=""><%=Name%></a>
									<%Else%>
										<img src="<%=ImagePath%>tree/file.gif" /><a href="" Path="<%=Folder%><%=Name%>"><%=Name%></a>
									<%EndIf%>
								</th>
								<td><%=Extension%></td>
								<td><%=GetSize(Size)%></td>
								<td><%=CreateTime%></td>
								<td><%=UpdateTime%></td>
								<td><%=Attribute%></td>
								<td><a href="">重名</a></td>
								<td><a href="">移动</a></td>
								<td><a href="">复制</a></td>
								<td>
									<%If Convert.ToString(Extension) == ".zip"%>
										<a href="">解压</a>
									<%Else%>
										<a href="">压缩</a>
									<%EndIf%>
								</td>
								<td><a href="">删除</a></td>
							</tr>
						</ali:Record>
					</ali:List>
				</tbody>
			</table>
		<%EndIf%>
		<ali:Pagination Page="PageNumber" PageSize="50" RecordCount="List[RecordCount]">
			<div class="Pagination">
				<div class="Left">共 <%=RecordCount%> 条 当前显示第 <%=PageNumber%> 页 第 <%=RangeLower%>-<%=RangeUpper%> 条 </div>
				<div class="Right">
					<ali:FirstPage>
						<ali:Yes>
							<img src="<%=ImagePath%>pagination/first_page_off.gif"/>
							<img src="<%=ImagePath%>pagination/previous_page_off.gif"/>
						</ali:Yes>
						<ali:No>
							<a href="javascript:Go(1)"><img src="<%=ImagePath%>pagination/first_page_on.gif"/></a>
							<a href="javascript:Go(<%=PageNumber%> - 1)" id="PrevPage"><img src="<%=ImagePath%>pagination/previous_page_on.gif"/></a>
						</ali:No>
					</ali:FirstPage>
					<ali:CurrentPage Range="5">
						<ali:Yes>
							<span class="Current"><%=Index%></span>						
						</ali:Yes>
						<ali:No>
							<a href="javascript:Go(<%=Index%>)">[<%=Index%>]</a>
						</ali:No>
					</ali:CurrentPage>
					<ali:LastPage>
						<ali:Yes>
							<img src="<%=ImagePath%>pagination/next_page_off.gif"/>
							<img src="<%=ImagePath%>pagination/last_page_off.gif"/>
						</ali:Yes>
						<ali:No>
							<a href="javascript:Go(<%=PageNumber%> + 1)" id="NextPage"><img src="<%=ImagePath%>pagination/next_page_on.gif"/></a>
							<a href="javascript:Go(<%=PageCount%>)"><img src="<%=ImagePath%>pagination/last_page_on.gif"/></a>
						</ali:No>
					</ali:LastPage>
				</div>
			</div>
		</ali:Pagination>
	</div>
	<div class="Footer"></div>
</div>
<script src="<%=CommonPath%>jquery/core.js"></script>
<script src="<%=CommonPath%>jquery/ui.js"></script>
<script src="<%=CommonPath%>utility.js"></script>
<script src="<%=CommonPath%>uploader.js"></script>
<script src="<%=JsPath%>global.js"></script>
<script src="<%=ModuleJsPath%>module.js"></script>
</body>
</html>