﻿<%@ Page CodeFileBaseClass="AliCMS.Lib.SystemPageBase" %>
<%@ Register TagPrefix="alicmsUC" TagName="Ime" Src="../../ime.dwt.ascx"%>
<%@ Register TagPrefix="alicmsUC" TagName="LanguageMenu" Src="../../language_menu.dwt.ascx"%>
<!doctype html>
<html>
<head>
<meta charset="utf-8">
<title>链接列表</title>
<link rel="stylesheet"  href="<%=CommonPath%>jquery/themes/lightness/all.css" >
<ali:Comment><link rel="stylesheet"  href="../../S01/CHS/css/common.css" ></ali:Comment>
<link rel="stylesheet" href="<%=CssPath%>common.css" >
<alicmsUC:Ime Ime="true" Eot="true" runat="server" />
<script language="c#" runat="server">
protected string Condition()
{
	StringBuilder condition = new StringBuilder();
	string and = String.Empty;

	#region 是否审核
	string isChecked = Request.QueryString["IsChecked"];
	if (isChecked == null)
		condition.Append(and + Alias.Link.IsChecked + "=true");
	else if (isChecked != String.Empty)
		condition.Append(and + Alias.Link.IsChecked + "=" + isChecked);
	#endregion

	if (and == String.Empty && condition.Length != 0)
		and = " AND ";

	#region 类别
	string categoryID = Request.QueryString["CategoryID"];
	if (!String.IsNullOrEmpty(categoryID))
	{
		if (Convert.ToBoolean(Request.QueryString["IncludeSubCategory"]))
		{
			condition.Append(and + Alias.Link.IncludeSubCategory + "=" + categoryID);
		}
		else
		{
			if (categoryID == "0")
				condition.Append(and + Alias.Link.CategoryID + " IS NULL");
			else
				condition.Append(and + Alias.Link.CategoryID + "=" + categoryID);
		}
	}
	#endregion

	if (and == String.Empty && condition.Length != 0)
		and = " AND ";

	#region 关键词
	string keyword = Request.QueryString["Keyword"];
	if (!String.IsNullOrEmpty(keyword))
	{
		switch (Request.QueryString["KeywordType"])
		{
			case "Name":
				condition.Append(and + Alias.Link.Name + " LIKE '%" + keyword + "%'");
				break;
			case "URL":
				condition.Append(and + Alias.Link.URL + " LIKE '%" + keyword + "%'");
				break;
			case "Email":
				condition.Append(and + Alias.Link.Email + " LIKE '%" + keyword + "%'");
				break;
			case "QQ":
				condition.Append(and + Alias.Link.QQ + " LIKE '%" + keyword + "%'");
				break;
			case "Phone":
				condition.Append(and + Alias.Link.Phone + " LIKE '%" + keyword + "%'");
				break;
		}
	}
	#endregion
	
	return condition.ToString();
}

protected string Sort()
{
	string sort = String.Empty;
	switch (Request.QueryString["Sort"])
	{
		case "1":
			sort = Alias.Link.Sort + " ASC";
			break;
		case "2":
			sort = Alias.Link.InnerID + " DESC";
			break;
		case "3":
			sort = Alias.Link.InnerID + " ASC";
			break;
		default:
			sort = Alias.Link.Sort + " ASC";
			break;
	}
	
	return sort;
}
</script>
<script >
var _page = 'link_list',
    _lang = '<%=ContentLang%>',
    _webPath = '<%=WebPath%>',
    _imagePath = '<%=ImagePath%>',
    _lang_working = '正在操作...',
    _lang_operation_fail = '操作失败！',
    _lang_operation_success = '操作成功！',
    _lang_name_empty = '名称不能空！',
    _lang_confirm_delete = '要删除此项吗？',
    _lang_check = '审核',
    _lang_uncheck = '取消审核';
</script>
</head>
<body>
<div class="WhiteHeader">
	<div class="Left"><img src="<%=ImagePath%>close_frame.gif" ></div>
	<div class="Title">链接列表</div>
	<div class="Right">
		<alicmsUC:LanguageMenu runat="server" />
		<img height="15" src="<%=ImagePath%>dropdown.gif" > 语言：<%=CurrentLanguage%>
	</div>
</div>
<div class="Block">
	<ul class="TabMenu">
		<li class="Left Selected"></li>
		<li class="Middle Selected">链接列表</li>
		<li class="Right Selected"></li>
		<li class="Left"></li>
		<li class="Middle"><a href="../link/add.aspx?Lang=<%=ContentLang%>">添加链接</a></li>
		<li class="Right"></li>
		<li class="Left"></li>
		<li class="Middle"><a href="../link_category/list.aspx?Lang=<%=ContentLang%>">类别列表</a></li>
		<li class="Right"></li>
		<li class="Left"></li>
		<li class="Middle"><a href="../link_category/add.aspx?Lang=<%=ContentLang%>">添加类别</a></li>
		<li class="Right"></li>
	</ul>
	<ul class="Title">
		<li class="Left"></li>
		<li class="Middle"></li>
		<li class="Right"></li>
	</ul>
	<div class="ToolBar">
		<select id="IsChecked">
			<option value="">是否审核</option>
			<option value="false">未审核</option>
			<option value="true" selected="selected">已审核</option>
		</select>
		<select id="CategoryID" class="<%=ContentLang%>Font">
			<option value="">所有类别</option>
			<option value="0">未指定类别</option>
			<ali:Tree Object="LinkCategory">
				<ali:Control>
					<ali:Space>&nbsp;&nbsp;</ali:Space>
					<ali:Line>│</ali:Line>
					<ali:TopOpen>┌</ali:TopOpen>
					<ali:Top>┌</ali:Top>
					<ali:MiddleOpen>├</ali:MiddleOpen>
					<ali:Middle>├</ali:Middle>
					<ali:BottomOpen>└</ali:BottomOpen>
					<ali:Bottom>└</ali:Bottom>
				</ali:Control>
				<ali:Record>
					<%If Convert.ToString(ID) == Request.QueryString["CategoryID"]%>
						<option value="<%=ID%>" selected="selected"><%=Control%><%=Name%></option>
					<%Else%>
						<option value="<%=ID%>"><%=Control%><%=Name%></option>
					<%EndIf%>
					<%=ChildRecords%>
				</ali:Record>
			</ali:Tree>
		</select>
		<input type="checkbox" id="IncludeSubCategory" /><label for="IncludeSubCategory">子类</label>
		<select id="Sort">
			<option value="1">手动</option>
			<option value="2">编号↓</option>
			<option value="3">编号↑</option>
		</select>
		<input id="Keyword" tabindex="1" class="Text <%=ContentLang%>Font" />
		<select id="KeywordType">
			<option value="Name">名称</option>
			<option value="URL">网址</option>
			<option value="Email">Email</option>
			<option value="QQ">QQ</option>
			<option value="Phone">电话</option>
		</select>
		<input type="button" id="Search" value="搜索" class="Button" />
		<input type="button" id="SelectAll" value="全选" class="Button" />
		<input type="button" id="ReverseSelect" value="反选" class="Button" />
		<button type="button" id="Delete" class="Button" >删除</button>
		<span id="ExtraButton"></span>
	</div>
	<div id="List">
		<table border="0" cellpadding="4" cellspacing="1" class="ListTable">
			<thead>
				<tr>
					<th width="40">选择</th>
					<th width="30">移动</th>
					<th width="90">LOGO</th>
					<th>名称</th>
					<th>网址</th>
					<th width="80">QQ</th>
					<th width="40">修改</th>
					<th width="40">编辑</th>
				</tr>
			</thead>
			<tbody>
				<ali:List ID="List" Object="Link" Page="PageNumber" PageSize="20" Condition="Condition()" Sort="Sort()" Validate="True">
					<ali:Record>
						<tr id="Row<%=InnerID%>" ItemID="<%=InnerID%>" ParentID="">
							<form action="<%=InnerID%>">
								<td><input type="checkbox" name="Sel" value="<%=InnerID%>" /></td>
								<td><img name="<%=Name%>" sort="<%=InnerID%>" class="Move" src="<%=ImagePath%>move.gif" /></td>
								<td>
									<%If Convert.ToString(Logo) != String.Empty%>
										<a href="<%=URL%>" target="_blank"><img src="<%=Logo%>" /></a>
									<%EndIf%>
								</td>
								<td><input type="text" name="Name" value="<%=Name%>" size="30" class="Text <%=ContentLang%>Font" ></td>
								<td><input type="text" name="URL" value="<%=URL%>" size="40" class="Text" ></td>
								<td><input type="text" name="QQ" value="<%=QQ%>" size="10" class="Text" ></td>
								<td><input type="image" src="<%=ImagePath%>modify.gif" ></td>
								<td><a href="../link/edit.aspx?Lang=<%=ContentLang%>&amp;ID=<%=InnerID%>">编辑</a></td>
							</form>
						</tr>
					</ali:Record>
				</ali:List>
			</tbody>
		</table>
		<ali:Pagination Page="PageNumber" PageSize="20" RecordCount="List[RecordCount]">
			<div class="Pagination">
				<div class="Left">共 <%=RecordCount%> 条 当前显示第 <%=PageNumber%> 页 第 <%=RangeLower%>-<%=RangeUpper%> 条 </div>
				<div class="Right">
					<ali:FirstPage>
						<ali:Yes>
							<img src="<%=ImagePath%>pagination/first_page_off.gif">
							<img src="<%=ImagePath%>pagination/previous_page_off.gif">
						</ali:Yes>
						<ali:No>
							<a href="javascript:Go(1)"><img src="<%=ImagePath%>pagination/first_page_on.gif"></a>
							<a href="javascript:Go(<%=PageNumber%> - 1)" id="PrevPage"><img src="<%=ImagePath%>pagination/previous_page_on.gif"></a>
						</ali:No>
					</ali:FirstPage>
					<ali:CurrentPage Range="5">
						<ali:Yes>
							<span class="Current"><%=Index%></span>						
						</ali:Yes>
						<ali:No>
							<a href="javascript:Go(<%=Index%>)">[<%=Index%>]</a>
						</ali:No>
					</ali:CurrentPage>
					<ali:LastPage>
						<ali:Yes>
							<img src="<%=ImagePath%>pagination/next_page_off.gif">
							<img src="<%=ImagePath%>pagination/last_page_off.gif">
						</ali:Yes>
						<ali:No>
							<a href="javascript:Go(<%=PageNumber%> + 1)" id="NextPage"><img src="<%=ImagePath%>pagination/next_page_on.gif"/></a>
							<a href="javascript:Go(<%=PageCount%>)"><img src="<%=ImagePath%>pagination/last_page_on.gif"/></a>
						</ali:No>
					</ali:LastPage>
				</div>
			</div>
		</ali:Pagination>
	</div>
</div>
<script src="<%=CommonPath%>jquery/core.js"></script>
<script src="<%=CommonPath%>jquery/ui.js"></script>
<script src="<%=CommonPath%>utility.js"></script>
<script src="<%=JsPath%>move.js"></script>
<script src="<%=JsPath%>tree_handler.js"></script>
<script src="<%=JsPath%>global.js"></script>
<script src="<%=ModuleJsPath%>module.js"></script>
</body>
</html>