﻿<%@ Page CodeFileBaseClass="AliCMS.Lib.SystemPageBase" %>
<script language="c#" runat="server">
protected string Condition()
{
	StringBuilder condition = new StringBuilder();
	string and = String.Empty;

	#region 是否显示
	string isDisplay = Request.QueryString["IsDisplay"];
	if (isDisplay == null)
		condition.Append(Alias.LinkCategory.IsDisplay + "=true");
	else if (isDisplay != String.Empty)
		condition.Append(Alias.LinkCategory.IsDisplay + "=" + isDisplay);
	#endregion

	if (and == String.Empty && condition.Length != 0)
		and = " AND ";

	#region 是否推荐
	string isRecommended = Request.QueryString["IsRecommended"];
	if (!String.IsNullOrEmpty(isRecommended))
		condition.Append(and + Alias.LinkCategory.IsRecommended + "=" + isRecommended);
	#endregion

	if (and == String.Empty && condition.Length != 0)
		and = " AND ";

	#region 是否置顶
	string isHeld = Request.QueryString["IsHeld"];
	if (!String.IsNullOrEmpty(isHeld))
		condition.Append(and + Alias.LinkCategory.IsHeld + "=" + isHeld);
	#endregion
	
	return condition.ToString();
}

protected string Sort()
{
	string sort = String.Empty;
	switch (Request.QueryString["Sort"])
	{
		case "1":
			sort = Alias.LinkCategory.Sort + " ASC";
			break;
		case "2":
			sort = Alias.LinkCategory.Recommend + " DESC";
			break;
		case "3":
			sort = Alias.LinkCategory.Recommend + " ASC";
			break;
		case "4":
			sort = Alias.LinkCategory.Hold + " DESC";
			break;
		case "5":
			sort = Alias.LinkCategory.Hold + " ASC";
			break;
		default:
			sort = Alias.LinkCategory.Sort + " ASC";
			break;
	}
	
	return sort;
}
</script>
<table border="0" cellpadding="4" cellspacing="1" class="TreeTable">
	<thead>
		<tr>
            <th width="40">选择</th>
            <th width="40">移动</th>
			<th>名称及层次</th>
			<th width="40">修改</th>
			<th width="80">浏览文章</th>
			<th width="80">添加子类别</th>
			<th width="40">编辑</th>
			<th width="40">删除</th>
		</tr>
	</thead>
	<tbody>
		<%If Request.QueryString["Sort"] == "1"%>
			<ali:Tree Object="LinkCategory" Condition="Condition()" Sort="Sort()" Validate="True">
				<ali:Control>
					<ali:Space><span style="margin-left:20px"></span></ali:Space>
					<ali:Line><img src="<%=ImagePath%>tree/line.gif" /></ali:Line>
					<ali:TopOpen><img id="SH<%=InnerID%>" onclick="ShowAndHide('<%=InnerID%>')" src="<%=ImagePath%>tree/top_open_flipCHS.gif" class="ShowHide" /></ali:TopOpen>
					<ali:Top><img src="<%=ImagePath%>tree/top_flipCHS.gif" /></ali:Top>
					<ali:MiddleOpen><img id="SH<%=InnerID%>" onclick="ShowAndHide('<%=InnerID%>')" src="<%=ImagePath%>tree/middle_open_flipCHS.gif" class="ShowHide" /></ali:MiddleOpen>
					<ali:Middle><img src="<%=ImagePath%>tree/middle_flipCHS.gif" /></ali:Middle>
					<ali:BottomOpen><img id="SH<%=InnerID%>" onclick="ShowAndHide('<%=InnerID%>')" src="<%=ImagePath%>tree/bottom_open_flipCHS.gif" class="ShowHide" /></ali:BottomOpen>
					<ali:Bottom><img src="<%=ImagePath%>tree/bottom_flipCHS.gif" /></ali:Bottom>
				</ali:Control>
				<ali:Record>
					<tr id="Row<%=InnerID%>" ItemID="<%=InnerID%>" ParentID="<%=ParentInnerID%>">
						<form>
                            <td><input type="checkbox" name="Sel" value="<%=InnerID%>" /></td>
							<td><img name="<%=Name%>" sort="<%=InnerID%>" class="Move" src="<%=ImagePath%>move.gif" /></td>
							<th><span id="Control<%=InnerID%>"><%=Control%></span><input type="text" name="Name" value="<%=Name%>" size="50" class="<%=ContentLang%>Font"></th>
							<td><input type="image" src="<%=ImagePath%>modify.gif" /></td>
							<td><a href="../link/list.aspx?Lang=<%=ContentLang%>&CategoryID=<%=ID%>">浏览文章</a></td>
							<td><a href="../link_category/add.aspx?Lang=<%=ContentLang%>&ParentID=<%=ID%>">添加子类别</a></td>
							<td><a href="../link_category/edit.aspx?Lang=<%=ContentLang%>&ID=<%=InnerID%>">编辑</a></td>
							<td><a href="">删除</a></td>
						</form>
					</tr>
					<%=ChildRecords%>
				</ali:Record>
			</ali:Tree>
		<%Else%>
			<ali:List Object="LinkCategory" Condition="Condition()" Sort="Sort()" Validate="True">
				<ali:Record>
					<tr id="Row<%=InnerID%>" ItemID="<%=InnerID%>" ParentID="">
						<form>
                            <td><input type="checkbox" name="Sel" value="<%=InnerID%>" /></td>
							<td>
								<%If (Request.QueryString["Sort"] == "2" || Request.QueryString["Sort"] == "3") && Request.QueryString["IsRecommended"] == "true" || (Request.QueryString["Sort"] == "4" || Request.QueryString["Sort"] == "5") && Request.QueryString["IsHeld"] == "true"%>
									<img name="<%=Name%>" sort="<%=InnerID%>" class="Move" src="<%=ImagePath%>move.gif" />
								<%EndIf%>
							</td>
							<th><input type="text" name="Name" value="<%=Name%>" class="<%=ContentLang%>Font"></th>
							<td><input type="image" src="<%=ImagePath%>modify.gif" /></td>
							<td><a href="../link/list.aspx?Lang=<%=ContentLang%>&CategoryID=<%=ID%>">浏览文章</a></td>
							<td><a href="../link_category/add.aspx?Lang=<%=ContentLang%>&ParentID=<%=ID%>">添加子类别</a></td>
							<td><a href="../link_category/edit.aspx?Lang=<%=ContentLang%>&ID=<%=InnerID%>">编辑</a></td>
							<td><a href="">删除</a></td>
						</form>
					</tr>
				</ali:Record>
			</ali:List>
		<%EndIf%>
	</tbody>
</table>
