﻿<%@ Page CodeFileBaseClass="AliCMS.Lib.SystemPageBase" %>
<script language="c#" runat="server">
protected string _contentLangName = null;
protected string ContentLangName
{
	get
	{
		if (_contentLangName != null)
			return _contentLangName;
			
		_contentLangName = Manager.Languages.Select(Alias.Language.Ab + "='" + ContentLang + "'")[0][Alias.Language.Name + PageLang].ToString();

		return _contentLangName;
	}
}

protected string Condition()
{
	StringBuilder condition = new StringBuilder(Alias.Module.Dictionary.Namespace + "=" + Request.QueryString["Namespace"]);
	string and = String.Empty;

	if (and == String.Empty && condition.Length != 0)
		and = " AND ";

	#region 关键词
	string keyword = Request.QueryString["Keyword"];
	if (!String.IsNullOrEmpty(keyword))
	{
		if (Request.QueryString["KeywordType"] == "Name")
			condition.Append(and + Alias.Module.Dictionary.Name + "='" + keyword + "'");
		else if (Request.QueryString["KeywordType"] == "Content")
			condition.Append(and + Alias.Module.Dictionary.Content + "='" + keyword + "'");
	}
	#endregion
	
	return condition.ToString();
}
</script>
<table border="0" cellpadding="4" cellspacing="1">
	<thead>
		<tr>
			<th width="150">标识</th>
			<th><%=ContentLangName%></th>
			<th width="40">修改</th>
			<th width="40">删除</th>
		</tr>
	</thead>
	<tbody>
		<ali:List ID="List" Object="Module.Dictionary" Page="PageNumber" PageSize="20" Condition="Condition()" Validate="True">
			<ali:Record>
				<tr data-id="<%=Name%>">
					<form>
						<td><input type="text" name="Name" value="<%=Name%>" size="30" class="Text" ></td>
						<td><textarea name="Content" cols="50" rows="3" class="Text <%=ContentLang%>Font"><%=Content%></textarea></td>
						<td><input type="image" src="<%=ImagePath%>modify.gif" ></td>
						<td><a href="">删除</a></td>
					</form>
				</tr>
			</ali:Record>
		</ali:List>
	</tbody>
</table>
<ali:Pagination Page="PageNumber" PageSize="20" RecordCount="List[RecordCount]">
	<div class="Pagination">
		<div class="Left">共 <%=RecordCount%> 条 当前显示第 <%=PageNumber%> 页 第 <%=RangeLower%>-<%=RangeUpper%> 条 </div>
		<div class="Right">
			<ali:FirstPage>
				<ali:Yes>
					<img src="<%=ImagePath%>pagination/first_page_off.gif"/>
					<img src="<%=ImagePath%>pagination/previous_page_off.gif"/>
				</ali:Yes>
				<ali:No>
					<a href="javascript:Go(1)"><img src="<%=ImagePath%>pagination/first_page_on.gif"/></a>
					<a href="javascript:Go(<%=PageNumber%> - 1)" id="PrevPage"><img src="<%=ImagePath%>pagination/previous_page_on.gif"/></a>
				</ali:No>
			</ali:FirstPage>
			<ali:CurrentPage Range="5">
				<ali:Yes>
					<span class="Current"><%=Index%></span>						
				</ali:Yes>
				<ali:No>
					<a href="javascript:Go(<%=Index%>)">[<%=Index%>]</a>
				</ali:No>
			</ali:CurrentPage>
			<ali:LastPage>
				<ali:Yes>
					<img src="<%=ImagePath%>pagination/next_page_off.gif"/>
					<img src="<%=ImagePath%>pagination/last_page_off.gif"/>
				</ali:Yes>
				<ali:No>
					<a href="javascript:Go(<%=PageNumber%> + 1)" id="NextPage"><img src="<%=ImagePath%>pagination/next_page_on.gif"/></a>
					<a href="javascript:Go(<%=PageCount%>)"><img src="<%=ImagePath%>pagination/last_page_on.gif"/></a>
				</ali:No>
			</ali:LastPage>
		</div>
	</div>
</ali:Pagination>